/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

public class HttpServer
extends Thread {
    private Log m_log;
    private String m_sExpectedPrefix;
    private int m_nBrowserTabTimeoutInMs;
    private ServerSocket m_ss;
    private SQLException m_ex;
    private Map m_mapRequestParams = new LinkedHashMap();

    public HttpServer(Log log, String string, int n, int n2) throws SQLException {
        this.m_log = log;
        this.m_sExpectedPrefix = string;
        this.m_nBrowserTabTimeoutInMs = n2;
        try {
            this.m_ss = new ServerSocket(0);
            this.m_ss.setSoTimeout(n);
        }
        catch (IOException iOException) {
            throw Utility.logEx(log, "HttpServer", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1545")));
        }
        this.setDaemon(true);
        this.start();
    }

    public int getLocalPort() {
        return this.m_ss.getLocalPort();
    }

    public Map waitForRequestParams(Log log) throws SQLException {
        long l = System.currentTimeMillis();
        Utility.waitForThreadDeath(this);
        if (log.isTimingEnabled()) {
            log.timing("Waiting for HttpServer thread took " + (System.currentTimeMillis() - l) + " ms");
        }
        if (this.m_ex != null) {
            throw this.m_ex;
        }
        return this.m_mapRequestParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket socket;
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("HttpServer listening on port " + this.m_ss.getLocalPort());
        }
        try {
            socket = this.m_ss.accept();
        }
        catch (IOException iOException) {
            this.m_ex = Utility.logEx(this.m_log, "HttpServer", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1546")));
            return;
        }
        try {
            this.m_ss.close();
        }
        catch (IOException iOException) {
            this.m_log.error("HttpServer close " + iOException);
        }
        try {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug("HttpServer accepted connection from " + socket.getRemoteSocketAddress());
            }
            try {
                String string;
                boolean bl;
                String[] stringArray;
                int n;
                InputStream inputStream = socket.getInputStream();
                OutputStream outputStream = socket.getOutputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = 0;
                while ((n = inputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                    if ((n2 = n2 << 8 | n) != 0xD0A0D0A) continue;
                }
                String string2 = (stringArray = byteArrayOutputStream.toString("ASCII").split("\r\n")).length > 0 ? stringArray[0] : "";
                String[] stringArray2 = string2.split(" ");
                boolean bl2 = bl = stringArray2.length >= 3 && stringArray2[0].equals("GET") && stringArray2[1].startsWith(this.m_sExpectedPrefix) && stringArray2[2].startsWith("HTTP/");
                if (bl) {
                    string = stringArray2[1].substring(this.m_sExpectedPrefix.length());
                    String[] stringArray3 = string.split("&");
                    for (int i = 0; i < stringArray3.length; ++i) {
                        String[] stringArray4 = stringArray3[i].split("=", 2);
                        this.m_mapRequestParams.put(stringArray4[0], stringArray4.length == 2 ? stringArray4[1] : null);
                    }
                }
                string = "HTTP/1.1 " + (bl ? "200 OK" : "404 Not Found") + "\r\n" + "Content-Type: text/html; charset=utf-8\r\n" + "Cache-Control: no-cache\r\n" + "Pragma: no-cache\r\n" + "Connection: close\r\n" + "\r\n" + (bl ? "<!DOCTYPE HTML>\r\n<html>\r\n<head>\r\n<title>" + ErrorMessage.messages.getString("JDBC-191772-TITLE") + "</title>\r\n" + "</head>\r\n" + "<body style=\"background-color: DimGray;\"" + (this.m_nBrowserTabTimeoutInMs < 0 ? "" : " onload=\"setTimeout(window.close," + this.m_nBrowserTabTimeoutInMs + ");\"") + ">\r\n" + "<p style=\"" + "border-radius: 10pt;" + "padding: 22pt;" + "background: DarkOrange;" + "color: white;" + "text-align: center;" + "font-family: sans-serif;" + "font-weight: bolder;" + "font-size: 24pt;" + "\">" + ErrorMessage.messages.getString("JDBC-191772-BODY") + "</p>\r\n" + "</body>\r\n" + "</html>\r\n" : "");
                outputStream.write(string.getBytes("UTF-8"));
            }
            catch (IOException iOException) {
                this.m_ex = Utility.logEx(this.m_log, "HttpServer", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1547")));
                Object var15_18 = null;
                try {
                    socket.shutdownInput();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                try {
                    socket.shutdownOutput();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                try {
                    socket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return;
            }
            Object var15_19 = null;
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            try {
                socket.shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            socket.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            socket.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }
}

