/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.jdbc_4.ResultSetRowContext;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSetUpdater {
    private TeraResultSetMetaData m_rsmd;
    private Connection m_con;
    private Log log;
    private PreparedStatement deleteStmt;
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private int[] indexColsChanged;
    private Object[] rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] typeInfo;
    private boolean isInserting;
    private boolean isUpdating;
    private int columnCount;
    private String[] updateSQLs;
    private String[] updateTables;
    private String[] uniqueTables;
    private String[] keyTables;
    private int numOfDifferTable_update;
    private StringBuffer[] fieldValues_update;
    private StringBuffer[] uniqueColumn_update;
    private StringBuffer[] keyColumns_update;
    private boolean[] fieldValuesFirstTime_update;
    private boolean[] uniqueColumnFirstTime_update;
    private boolean[] keyColumnsFirstTime_update;
    private int[][] indexColsChanged_update;
    private int[] indexColsChangedCount_update;
    private int[][] indexUniqueColumn;
    private int[][] indexKeyColumns;
    private int[] updateKeyValuesNumbers;
    private boolean[] haveUniqueColumn;
    private boolean[] haveKeyColumns;
    private boolean[] isUniqueColumnExist;
    private boolean[] isKeyColumnExist;
    private String[] insertSQLs;
    private String[] insertTables;
    private int numOfDifferTable_insert;
    private StringBuffer[] columnNames_insert;
    private StringBuffer[] insertPlaceHolders_insert;
    private boolean[] columnNamesFirstTime_insert;
    private boolean[] insertPlaceHoldersFirstTime_insert;
    private int[][] indexColsChanged_insert;
    private int[] indexColsChangedCount_insert;
    private String[] deleteSQLs;
    private String[] deleteTables;
    private String[] uniqueTables_delete;
    private String[] keyTables_delete;
    private StringBuffer[] uniqueColumn_delete;
    private StringBuffer[] keyColumns_delete;
    private boolean[] uniqueColumnFirstTime_delete;
    private boolean[] keyColumnsFirstTime_delete;
    private int numOfDifferTable_delete;
    private int[][] indexUniqueColumn_delete;
    private int[][] indexKeyColumns_delete;
    private int[] deleteKeyValuesNumbers;
    private boolean[] haveUniqueColumn_delete;
    private boolean[] haveKeyColumns_delete;
    private boolean[] isUniqueColumnExist_delete;
    private boolean[] isKeyColumnExist_delete;

    ResultSetUpdater(TeraResultSetMetaData teraResultSetMetaData, Connection connection, Log log) {
        this.m_rsmd = teraResultSetMetaData;
        this.m_con = connection;
        this.log = log;
        this.initVars();
        this.initUpdateVars();
        this.initInsertVars();
        this.initDeleteVars();
    }

    private void initVars() {
        this.deleteStmt = null;
        this.insertStmt = null;
        this.updateStmt = null;
        this.indexColsChanged = null;
        this.rowBuffer = null;
        this.m_nullIndicator = null;
        this.typeInfo = null;
        this.isInserting = false;
        this.isUpdating = false;
        this.columnCount = 0;
    }

    private void initUpdateVars() {
        this.updateSQLs = null;
        this.updateTables = null;
        this.uniqueTables = null;
        this.keyTables = null;
        this.numOfDifferTable_update = 0;
        this.fieldValues_update = null;
        this.uniqueColumn_update = null;
        this.keyColumns_update = null;
        this.fieldValuesFirstTime_update = null;
        this.uniqueColumnFirstTime_update = null;
        this.keyColumnsFirstTime_update = null;
        this.haveUniqueColumn = null;
        this.haveKeyColumns = null;
        this.indexColsChanged_update = null;
        this.indexColsChangedCount_update = null;
        this.indexUniqueColumn = null;
        this.indexKeyColumns = null;
        this.updateKeyValuesNumbers = null;
        this.isUniqueColumnExist = null;
        this.isKeyColumnExist = null;
        this.indexColsChanged = null;
    }

    private void initInsertVars() {
        this.insertSQLs = null;
        this.insertTables = null;
        this.numOfDifferTable_insert = 0;
        this.columnNames_insert = null;
        this.insertPlaceHolders_insert = null;
        this.columnNamesFirstTime_insert = null;
        this.insertPlaceHoldersFirstTime_insert = null;
        this.indexColsChanged_insert = null;
        this.indexColsChangedCount_insert = null;
        this.indexColsChanged = null;
    }

    private void initDeleteVars() {
        this.deleteSQLs = null;
        this.deleteTables = null;
        this.uniqueTables_delete = null;
        this.keyTables_delete = null;
        this.uniqueColumn_delete = null;
        this.keyColumns_delete = null;
        this.uniqueColumnFirstTime_delete = null;
        this.keyColumnsFirstTime_delete = null;
        this.numOfDifferTable_delete = 0;
        this.deleteKeyValuesNumbers = null;
        this.haveUniqueColumn_delete = null;
        this.haveKeyColumns_delete = null;
        this.indexUniqueColumn_delete = null;
        this.indexKeyColumns_delete = null;
        this.isUniqueColumnExist_delete = null;
        this.isKeyColumnExist_delete = null;
    }

    public void refreshRow() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.refreshRow isOnInsertRow=" + this.isOnInsertRow());
        }
        if (this.isOnInsertRow()) {
            throw ErrorFactory.makeDriverJDBCException("TJ504", "refreshRow");
        }
        this.cancelRowUpdates();
    }

    private boolean isOnInsertRow() {
        return this.isInserting;
    }

    private void setInserting(boolean bl) {
        this.isInserting = bl;
    }

    private boolean isUpdatingRow() {
        return this.isUpdating;
    }

    private void setUpdating(boolean bl) {
        this.isUpdating = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow(ResultSetRowContext resultSetRowContext) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.updateRow isOnInsertRow=" + this.isOnInsertRow());
        }
        if (this.isOnInsertRow()) {
            throw ErrorFactory.makeDriverJDBCException("TJ504", "updateRow");
        }
        try {
            int n = this.getNumColumnsChanged();
            if (n > 0) {
                if (this.updateSQLs == null) {
                    this.generateUpdateStatement(resultSetRowContext, n);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.updateRow numOfDifferTable_update=" + this.numOfDifferTable_update);
                }
                for (int i = 0; i < this.numOfDifferTable_update; ++i) {
                    this.prepareUpdateRowStatement(i);
                    this.prepareUpdateRowBinds(resultSetRowContext, this.indexColsChangedCount_update[i], i);
                    this.executeUpdateRow(i);
                }
            }
        }
        finally {
            this.clearRowBuffer();
            this.initUpdateVars();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.insertRow isOnInsertRow=" + this.isOnInsertRow());
        }
        if (!this.isOnInsertRow()) {
            throw ErrorFactory.makeDriverJDBCException("TJ505", "insertRow");
        }
        try {
            int n = this.getNumColumnsChanged();
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.insertRow getNumColumnsChanged=" + n);
            }
            if (n > 0) {
                if (this.insertSQLs == null) {
                    this.generateInsertStatement(n);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.insertRow numOfDifferTable_insert=" + this.numOfDifferTable_insert);
                }
                for (int i = 0; i < this.numOfDifferTable_insert; ++i) {
                    this.prepareInsertRowStatement(i);
                    this.prepareInsertRowBinds(this.indexColsChangedCount_insert[i], i);
                    this.executeInsertRow(i);
                }
            }
        }
        finally {
            this.clearRowBuffer();
            this.initInsertVars();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(ResultSetRowContext resultSetRowContext) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.deleteRow isOnInsertRow=" + this.isOnInsertRow());
        }
        if (this.isOnInsertRow()) {
            throw ErrorFactory.makeDriverJDBCException("TJ504", "deleteRow");
        }
        try {
            if (this.deleteSQLs == null) {
                this.generateDeleteStatement(resultSetRowContext);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.deleteRow numOfDifferTable_delete=" + this.numOfDifferTable_delete);
            }
            for (int i = 0; i < this.numOfDifferTable_delete; ++i) {
                this.prepareDeleteRowStatement(i);
                this.prepareDeleteRowBinds(resultSetRowContext, i);
                this.executeDeleteRow(i);
            }
        }
        finally {
            this.initDeleteVars();
        }
    }

    public void moveToInsertRow() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.moveToInsertRow isOnInsertRow=" + this.isOnInsertRow());
        }
        if (this.isOnInsertRow()) {
            return;
        }
        this.setInserting(true);
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
        }
        this.clearRowBuffer();
    }

    public void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    private void cancelRowInserts() {
        if (this.isOnInsertRow()) {
            this.setInserting(false);
            this.clearRowBuffer();
        }
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.cancelRowUpdates isOnInsertRow=" + this.isOnInsertRow());
        }
        if (this.isOnInsertRow()) {
            throw ErrorFactory.makeDriverJDBCException("TJ504", "cancelRowUpdates");
        }
        if (this.isUpdatingRow()) {
            this.setUpdating(false);
            this.clearRowBuffer();
        }
    }

    public void cancelRowChanges() throws SQLException {
        if (this.isOnInsertRow()) {
            this.cancelRowInserts();
        }
        if (this.isUpdatingRow()) {
            this.cancelRowUpdates();
        }
    }

    int getColumnCount() throws SQLException {
        if (this.columnCount == 0) {
            this.columnCount = this.m_rsmd.getColumnCount();
        }
        return this.columnCount;
    }

    public void updateInt(ResultSetRowContext resultSetRowContext, int n, int n2) throws SQLException {
        this.updateObject(resultSetRowContext, n, new Integer(n2));
    }

    public void updateDouble(ResultSetRowContext resultSetRowContext, int n, double d) throws SQLException {
        this.updateObject(resultSetRowContext, n, new Double(d));
    }

    public void updateString(ResultSetRowContext resultSetRowContext, int n, String string) throws SQLException {
        this.updateObject(resultSetRowContext, n, string);
    }

    public void updateBytes(ResultSetRowContext resultSetRowContext, int n, byte[] byArray) throws SQLException {
        this.updateObject(resultSetRowContext, n, byArray);
    }

    public void updateBigDecimal(ResultSetRowContext resultSetRowContext, int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(resultSetRowContext, n, bigDecimal);
    }

    public void updateBlob(ResultSetRowContext resultSetRowContext, int n, Blob blob) throws SQLException {
        if (blob != null) {
            this.setRowBufferAt(resultSetRowContext, n - 1, blob);
        }
    }

    public void updateClob(ResultSetRowContext resultSetRowContext, int n, Clob clob) throws SQLException {
        if (clob != null) {
            this.setRowBufferAt(resultSetRowContext, n - 1, clob);
        }
    }

    public void updateByte(ResultSetRowContext resultSetRowContext, int n, byte by) throws SQLException {
        this.updateObject(resultSetRowContext, n, new Integer(by));
    }

    public void updateDate(ResultSetRowContext resultSetRowContext, int n, Date date) throws SQLException {
        this.updateObject(resultSetRowContext, n, date);
    }

    public void updateFloat(ResultSetRowContext resultSetRowContext, int n, float f) throws SQLException {
        this.updateObject(resultSetRowContext, n, new Float(f));
    }

    public void updateLong(ResultSetRowContext resultSetRowContext, int n, long l) throws SQLException {
        this.updateObject(resultSetRowContext, n, new Long(l));
    }

    public void updateNull(ResultSetRowContext resultSetRowContext, int n) throws SQLException {
        this.setRowBufferAt(resultSetRowContext, n - 1, null);
    }

    public void updateShort(ResultSetRowContext resultSetRowContext, int n, short s) throws SQLException {
        this.updateObject(resultSetRowContext, n, new Integer(s));
    }

    public void updateTime(ResultSetRowContext resultSetRowContext, int n, Time time) throws SQLException {
        this.updateObject(resultSetRowContext, n, time);
    }

    public void updateTimestamp(ResultSetRowContext resultSetRowContext, int n, Timestamp timestamp) throws SQLException {
        this.updateObject(resultSetRowContext, n, timestamp);
    }

    public void updateAsciiStream(ResultSetRowContext resultSetRowContext, int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream != null && n2 >= 0) {
            int[] nArray = new int[]{n2, 1};
            this.setRowBufferAt(resultSetRowContext, n - 1, inputStream, nArray);
        } else {
            this.setRowBufferAt(resultSetRowContext, n - 1, null);
        }
    }

    public void updateBinaryStream(ResultSetRowContext resultSetRowContext, int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream != null && n2 >= 0) {
            int[] nArray = new int[]{n2, 2};
            this.setRowBufferAt(resultSetRowContext, n - 1, inputStream, nArray);
        } else {
            this.setRowBufferAt(resultSetRowContext, n - 1, null);
        }
    }

    public void updateCharacterStream(ResultSetRowContext resultSetRowContext, int n, Reader reader, int n2) throws SQLException {
        if (reader != null && n2 >= 0) {
            int[] nArray = new int[]{n2};
            this.setRowBufferAt(resultSetRowContext, n - 1, reader, nArray);
        } else {
            this.setRowBufferAt(resultSetRowContext, n - 1, null);
        }
    }

    public void updateSQLXML(ResultSetRowContext resultSetRowContext, int n, TeraSQLXML teraSQLXML) throws SQLException {
        this.setRowBufferAt(resultSetRowContext, n - 1, teraSQLXML);
    }

    public void updateObject(ResultSetRowContext resultSetRowContext, int n, Object object, int n2) throws SQLException {
        this.updateObject(resultSetRowContext, n, object);
    }

    public void updateObject(ResultSetRowContext resultSetRowContext, int n, Object object) throws SQLException {
        if (object != null) {
            this.setRowBufferAt(resultSetRowContext, n - 1, object);
        }
    }

    private void setRowBufferAt(ResultSetRowContext resultSetRowContext, int n, Object object) throws SQLException {
        this.setRowBufferAt(resultSetRowContext, n, object, null);
    }

    private void setRowBufferAt(ResultSetRowContext resultSetRowContext, int n, Object object, int[] nArray) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.setRowBufferAt isOnInsertRow=" + this.isOnInsertRow());
        }
        if (!this.isOnInsertRow()) {
            if (resultSetRowContext.isOnActualRow()) {
                this.setUpdating(true);
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ506");
            }
        }
        if (n < 0 || n > this.getColumnCount() - 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ507", n, this.getColumnCount());
        }
        if (this.rowBuffer == null) {
            this.rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.m_nullIndicator[i] = false;
            }
        }
        if (nArray != null) {
            if (this.typeInfo == null) {
                this.typeInfo = new int[this.getColumnCount()][];
            }
            this.typeInfo[n] = nArray;
        }
        this.rowBuffer[n] = object;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.setRowBufferAt rowBuffer[" + n + "]=" + object);
        }
        this.m_nullIndicator[n] = object == null;
    }

    private Object getRowBufferAt(int n) throws SQLException {
        if (n < 0 || n > this.getColumnCount() - 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ507", n, this.getColumnCount());
        }
        if (this.rowBuffer != null) {
            return this.rowBuffer[n];
        }
        return null;
    }

    private boolean isRowBufferUpdatedAt(int n) {
        if (this.rowBuffer == null) {
            return false;
        }
        return this.rowBuffer[n] != null || this.m_nullIndicator[n];
    }

    private int getNumColumnsChanged() throws SQLException {
        int n = 0;
        if (this.indexColsChanged == null) {
            this.indexColsChanged = new int[this.getColumnCount()];
        }
        if (this.rowBuffer != null) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.rowBuffer[i] == null && (this.rowBuffer[i] != null || !this.m_nullIndicator[i])) continue;
                this.indexColsChanged[n] = i;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.getNumColumnsChanged indexColsChanged[" + n + "]=" + i);
                }
                ++n;
            }
        }
        return n;
    }

    private void clearRowBuffer() {
        int n;
        if (this.rowBuffer != null) {
            for (n = 0; n < this.rowBuffer.length; ++n) {
                this.rowBuffer[n] = null;
            }
        }
        if (this.m_nullIndicator != null) {
            for (n = 0; n < this.m_nullIndicator.length; ++n) {
                this.m_nullIndicator[n] = false;
            }
        }
        if (this.typeInfo != null) {
            for (n = 0; n < this.typeInfo.length; ++n) {
                if (this.typeInfo[n] == null) continue;
                for (int i = 0; i < this.typeInfo[n].length; ++i) {
                    this.typeInfo[n][i] = 0;
                }
            }
        }
    }

    private void initUpdateBuffers() throws SQLException {
        int n;
        int n2;
        if (this.updateSQLs == null) {
            this.updateSQLs = new String[this.getColumnCount()];
        }
        if (this.updateSQLs != null) {
            for (n2 = 0; n2 < this.updateSQLs.length; ++n2) {
                this.updateSQLs[n2] = null;
            }
        }
        if (this.fieldValues_update == null) {
            this.fieldValues_update = new StringBuffer[this.getColumnCount()];
        }
        if (this.fieldValues_update != null) {
            for (n2 = 0; n2 < this.fieldValues_update.length; ++n2) {
                if (this.fieldValues_update[n2] != null) continue;
                this.fieldValues_update[n2] = new StringBuffer();
            }
        }
        if (this.uniqueColumn_update == null) {
            this.uniqueColumn_update = new StringBuffer[this.getColumnCount()];
        }
        if (this.uniqueColumn_update != null) {
            for (n2 = 0; n2 < this.uniqueColumn_update.length; ++n2) {
                if (this.uniqueColumn_update[n2] != null) continue;
                this.uniqueColumn_update[n2] = new StringBuffer();
            }
        }
        if (this.keyColumns_update == null) {
            this.keyColumns_update = new StringBuffer[this.getColumnCount()];
        }
        if (this.keyColumns_update != null) {
            for (n2 = 0; n2 < this.keyColumns_update.length; ++n2) {
                if (this.keyColumns_update[n2] != null) continue;
                this.keyColumns_update[n2] = new StringBuffer();
            }
        }
        if (this.fieldValuesFirstTime_update == null) {
            this.fieldValuesFirstTime_update = new boolean[this.getColumnCount()];
        }
        if (this.fieldValuesFirstTime_update != null) {
            for (n2 = 0; n2 < this.fieldValuesFirstTime_update.length; ++n2) {
                this.fieldValuesFirstTime_update[n2] = true;
            }
        }
        if (this.uniqueColumnFirstTime_update == null) {
            this.uniqueColumnFirstTime_update = new boolean[this.getColumnCount()];
        }
        if (this.uniqueColumnFirstTime_update != null) {
            for (n2 = 0; n2 < this.uniqueColumnFirstTime_update.length; ++n2) {
                this.uniqueColumnFirstTime_update[n2] = true;
            }
        }
        if (this.keyColumnsFirstTime_update == null) {
            this.keyColumnsFirstTime_update = new boolean[this.getColumnCount()];
        }
        if (this.keyColumnsFirstTime_update != null) {
            for (n2 = 0; n2 < this.keyColumnsFirstTime_update.length; ++n2) {
                this.keyColumnsFirstTime_update[n2] = true;
            }
        }
        if (this.indexUniqueColumn == null) {
            this.indexUniqueColumn = new int[this.getColumnCount()][];
        }
        if (this.indexUniqueColumn != null) {
            for (n2 = 0; n2 < this.indexUniqueColumn.length; ++n2) {
                if (this.indexUniqueColumn[n2] == null) {
                    this.indexUniqueColumn[n2] = new int[this.getColumnCount()];
                }
                for (n = 0; n < this.indexUniqueColumn[n2].length; ++n) {
                    this.indexUniqueColumn[n2][n] = 0;
                }
            }
        }
        if (this.indexKeyColumns == null) {
            this.indexKeyColumns = new int[this.getColumnCount()][];
        }
        if (this.indexKeyColumns != null) {
            for (n2 = 0; n2 < this.indexKeyColumns.length; ++n2) {
                if (this.indexKeyColumns[n2] == null) {
                    this.indexKeyColumns[n2] = new int[this.getColumnCount()];
                }
                for (n = 0; n < this.indexKeyColumns[n2].length; ++n) {
                    this.indexKeyColumns[n2][n] = 0;
                }
            }
        }
        if (this.updateTables == null) {
            this.updateTables = new String[this.getColumnCount()];
        }
        if (this.updateTables != null) {
            for (n2 = 0; n2 < this.updateTables.length; ++n2) {
                this.updateTables[n2] = null;
            }
        }
        if (this.uniqueTables == null) {
            this.uniqueTables = new String[this.getColumnCount()];
        }
        if (this.uniqueTables != null) {
            for (n2 = 0; n2 < this.uniqueTables.length; ++n2) {
                this.uniqueTables[n2] = null;
            }
        }
        if (this.keyTables == null) {
            this.keyTables = new String[this.getColumnCount()];
        }
        if (this.keyTables != null) {
            for (n2 = 0; n2 < this.keyTables.length; ++n2) {
                this.keyTables[n2] = null;
            }
        }
        if (this.isUniqueColumnExist == null) {
            this.isUniqueColumnExist = new boolean[this.getColumnCount()];
        }
        if (this.isUniqueColumnExist != null) {
            for (n2 = 0; n2 < this.isUniqueColumnExist.length; ++n2) {
                this.isUniqueColumnExist[n2] = false;
            }
        }
        if (this.isKeyColumnExist == null) {
            this.isKeyColumnExist = new boolean[this.getColumnCount()];
        }
        if (this.isKeyColumnExist != null) {
            for (n2 = 0; n2 < this.isKeyColumnExist.length; ++n2) {
                this.isKeyColumnExist[n2] = false;
            }
        }
        if (this.indexColsChanged_update == null) {
            this.indexColsChanged_update = new int[this.getColumnCount()][];
        }
        if (this.indexColsChanged_update != null) {
            for (n2 = 0; n2 < this.indexColsChanged_update.length; ++n2) {
                if (this.indexColsChanged_update[n2] == null) {
                    this.indexColsChanged_update[n2] = new int[this.getColumnCount()];
                }
                for (n = 0; n < this.indexColsChanged_update[n2].length; ++n) {
                    this.indexColsChanged_update[n2][n] = 0;
                }
            }
        }
        if (this.indexColsChangedCount_update == null) {
            this.indexColsChangedCount_update = new int[this.getColumnCount()];
        }
        if (this.indexColsChangedCount_update != null) {
            for (n2 = 0; n2 < this.indexColsChangedCount_update.length; ++n2) {
                this.indexColsChangedCount_update[n2] = 0;
            }
        }
    }

    private void initInsertBuffers() throws SQLException {
        int n;
        if (this.insertSQLs == null) {
            this.insertSQLs = new String[this.getColumnCount()];
        }
        if (this.insertSQLs != null) {
            for (n = 0; n < this.insertSQLs.length; ++n) {
                this.insertSQLs[n] = null;
            }
        }
        if (this.columnNames_insert == null) {
            this.columnNames_insert = new StringBuffer[this.getColumnCount()];
        }
        if (this.columnNames_insert != null) {
            for (n = 0; n < this.columnNames_insert.length; ++n) {
                if (this.columnNames_insert[n] != null) continue;
                this.columnNames_insert[n] = new StringBuffer();
            }
        }
        if (this.insertPlaceHolders_insert == null) {
            this.insertPlaceHolders_insert = new StringBuffer[this.getColumnCount()];
        }
        if (this.insertPlaceHolders_insert != null) {
            for (n = 0; n < this.insertPlaceHolders_insert.length; ++n) {
                if (this.insertPlaceHolders_insert[n] != null) continue;
                this.insertPlaceHolders_insert[n] = new StringBuffer();
            }
        }
        if (this.columnNamesFirstTime_insert == null) {
            this.columnNamesFirstTime_insert = new boolean[this.getColumnCount()];
        }
        if (this.columnNamesFirstTime_insert != null) {
            for (n = 0; n < this.columnNamesFirstTime_insert.length; ++n) {
                this.columnNamesFirstTime_insert[n] = true;
            }
        }
        if (this.insertPlaceHoldersFirstTime_insert == null) {
            this.insertPlaceHoldersFirstTime_insert = new boolean[this.getColumnCount()];
        }
        if (this.insertPlaceHoldersFirstTime_insert != null) {
            for (n = 0; n < this.insertPlaceHoldersFirstTime_insert.length; ++n) {
                this.insertPlaceHoldersFirstTime_insert[n] = true;
            }
        }
        if (this.insertTables == null) {
            this.insertTables = new String[this.getColumnCount()];
        }
        if (this.insertTables != null) {
            for (n = 0; n < this.insertTables.length; ++n) {
                this.insertTables[n] = null;
            }
        }
        if (this.indexColsChangedCount_insert == null) {
            this.indexColsChangedCount_insert = new int[this.getColumnCount()];
        }
        if (this.indexColsChangedCount_insert != null) {
            for (n = 0; n < this.indexColsChangedCount_insert.length; ++n) {
                this.indexColsChangedCount_insert[n] = 0;
            }
        }
        if (this.indexColsChanged_insert == null) {
            this.indexColsChanged_insert = new int[this.getColumnCount()][];
        }
        if (this.indexColsChanged_insert != null) {
            for (n = 0; n < this.indexColsChanged_insert.length; ++n) {
                if (this.indexColsChanged_insert[n] == null) {
                    this.indexColsChanged_insert[n] = new int[this.getColumnCount()];
                }
                for (int i = 0; i < this.indexColsChanged_insert[n].length; ++i) {
                    this.indexColsChanged_insert[n][i] = 0;
                }
            }
        }
    }

    private void initDeleteBuffers() throws SQLException {
        int n;
        int n2;
        if (this.deleteSQLs == null) {
            this.deleteSQLs = new String[this.getColumnCount()];
        }
        if (this.deleteSQLs != null) {
            for (n2 = 0; n2 < this.deleteSQLs.length; ++n2) {
                this.deleteSQLs[n2] = null;
            }
        }
        if (this.uniqueColumn_delete == null) {
            this.uniqueColumn_delete = new StringBuffer[this.getColumnCount()];
        }
        if (this.uniqueColumn_delete != null) {
            for (n2 = 0; n2 < this.uniqueColumn_delete.length; ++n2) {
                if (this.uniqueColumn_delete[n2] != null) continue;
                this.uniqueColumn_delete[n2] = new StringBuffer();
            }
        }
        if (this.keyColumns_delete == null) {
            this.keyColumns_delete = new StringBuffer[this.getColumnCount()];
        }
        if (this.keyColumns_delete != null) {
            for (n2 = 0; n2 < this.keyColumns_delete.length; ++n2) {
                if (this.keyColumns_delete[n2] != null) continue;
                this.keyColumns_delete[n2] = new StringBuffer();
            }
        }
        if (this.uniqueColumnFirstTime_delete == null) {
            this.uniqueColumnFirstTime_delete = new boolean[this.getColumnCount()];
        }
        if (this.uniqueColumnFirstTime_delete != null) {
            for (n2 = 0; n2 < this.uniqueColumnFirstTime_delete.length; ++n2) {
                this.uniqueColumnFirstTime_delete[n2] = true;
            }
        }
        if (this.keyColumnsFirstTime_delete == null) {
            this.keyColumnsFirstTime_delete = new boolean[this.getColumnCount()];
        }
        if (this.keyColumnsFirstTime_delete != null) {
            for (n2 = 0; n2 < this.keyColumnsFirstTime_delete.length; ++n2) {
                this.keyColumnsFirstTime_delete[n2] = true;
            }
        }
        if (this.indexUniqueColumn_delete == null) {
            this.indexUniqueColumn_delete = new int[this.getColumnCount()][];
        }
        if (this.indexUniqueColumn_delete != null) {
            for (n2 = 0; n2 < this.indexUniqueColumn_delete.length; ++n2) {
                if (this.indexUniqueColumn_delete[n2] == null) {
                    this.indexUniqueColumn_delete[n2] = new int[this.getColumnCount()];
                }
                for (n = 0; n < this.indexUniqueColumn_delete[n2].length; ++n) {
                    this.indexUniqueColumn_delete[n2][n] = 0;
                }
            }
        }
        if (this.indexKeyColumns_delete == null) {
            this.indexKeyColumns_delete = new int[this.getColumnCount()][];
        }
        if (this.indexKeyColumns_delete != null) {
            for (n2 = 0; n2 < this.indexKeyColumns_delete.length; ++n2) {
                if (this.indexKeyColumns_delete[n2] == null) {
                    this.indexKeyColumns_delete[n2] = new int[this.getColumnCount()];
                }
                for (n = 0; n < this.indexKeyColumns_delete[n2].length; ++n) {
                    this.indexKeyColumns_delete[n2][n] = 0;
                }
            }
        }
        if (this.isUniqueColumnExist_delete == null) {
            this.isUniqueColumnExist_delete = new boolean[this.getColumnCount()];
        }
        if (this.isUniqueColumnExist_delete != null) {
            for (n2 = 0; n2 < this.isUniqueColumnExist_delete.length; ++n2) {
                this.isUniqueColumnExist_delete[n2] = false;
            }
        }
        if (this.isKeyColumnExist_delete == null) {
            this.isKeyColumnExist_delete = new boolean[this.getColumnCount()];
        }
        if (this.isKeyColumnExist_delete != null) {
            for (n2 = 0; n2 < this.isKeyColumnExist_delete.length; ++n2) {
                this.isKeyColumnExist_delete[n2] = false;
            }
        }
        if (this.deleteTables == null) {
            this.deleteTables = new String[this.getColumnCount()];
        }
        if (this.deleteTables != null) {
            for (n2 = 0; n2 < this.deleteTables.length; ++n2) {
                this.deleteTables[n2] = null;
            }
        }
        if (this.uniqueTables_delete == null) {
            this.uniqueTables_delete = new String[this.getColumnCount()];
        }
        if (this.uniqueTables_delete != null) {
            for (n2 = 0; n2 < this.uniqueTables_delete.length; ++n2) {
                this.uniqueTables_delete[n2] = null;
            }
        }
        if (this.keyTables_delete == null) {
            this.keyTables_delete = new String[this.getColumnCount()];
        }
        if (this.keyTables_delete != null) {
            for (n2 = 0; n2 < this.keyTables_delete.length; ++n2) {
                this.keyTables_delete[n2] = null;
            }
        }
    }

    protected void generateUpdateStatement(ResultSetRowContext resultSetRowContext, int n) throws SQLException {
        int n2;
        int n3;
        String string = null;
        int[] nArray = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = null;
        Object object2 = null;
        boolean bl4 = false;
        int n9 = 0;
        int n10 = 0;
        this.initUpdateBuffers();
        if (nArray == null) {
            nArray = new int[this.getColumnCount()];
        }
        if (nArray != null) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                nArray[n3] = 0;
            }
        }
        if (object == null) {
            object = new int[this.getColumnCount()][];
        }
        if (object != null) {
            for (n3 = 0; n3 < ((int[][])object).length; ++n3) {
                if (object[n3] == null) {
                    object[n3] = new int[this.getColumnCount()];
                }
                for (n2 = 0; n2 < object[n3].length; ++n2) {
                    object[n3][n2] = 0;
                }
            }
        }
        if (object2 == null) {
            object2 = new int[this.getColumnCount()][];
        }
        if (object2 != null) {
            for (n3 = 0; n3 < ((int[][])object2).length; ++n3) {
                if (object2[n3] == null) {
                    object2[n3] = new int[this.getColumnCount()];
                }
                for (n2 = 0; n2 < object2[n3].length; ++n2) {
                    object2[n3][n2] = 0;
                }
            }
        }
        for (n3 = 0; n3 < this.getColumnCount(); ++n3) {
            string2 = this.m_rsmd.getColumnProperties(n3 + 1).getSchemaName();
            string3 = this.m_rsmd.getColumnProperties(n3 + 1).getTableName();
            string4 = string2 + "." + string3;
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.generateUpdateStatement tableFullName=" + string4);
            }
            bl4 = false;
            for (n2 = 0; n2 < n; ++n2) {
                n9 = this.indexColsChanged[n2];
                if (n3 != n9) continue;
                bl4 = true;
                break;
            }
            if (bl4) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.generateUpdateStatement column No." + (n3 + 1) + ": columnChanged=" + bl4);
                }
                for (n2 = 0; n2 < this.updateTables.length; ++n2) {
                    if (string4.equalsIgnoreCase(this.updateTables[n2])) {
                        bl = true;
                        n4 = n2;
                        break;
                    }
                    n4 = this.numOfDifferTable_update;
                }
                if (!bl) {
                    int n11 = this.numOfDifferTable_update;
                    int n12 = this.indexColsChangedCount_update[n11];
                    this.indexColsChangedCount_update[n11] = n12 + 1;
                    n2 = n12;
                    this.indexColsChanged_update[this.numOfDifferTable_update][n2] = n9;
                    this.updateTables[this.numOfDifferTable_update++] = string4;
                } else if (bl) {
                    int n13 = n4;
                    int n14 = this.indexColsChangedCount_update[n13];
                    this.indexColsChangedCount_update[n13] = n14 + 1;
                    n2 = n14;
                    this.indexColsChanged_update[n4][n2] = n9;
                }
                bl = false;
                if (this.fieldValuesFirstTime_update[n4]) {
                    this.fieldValuesFirstTime_update[n4] = false;
                    this.fieldValues_update[n4].append("SET ");
                    this.fieldValues_update[n4].append(this.m_rsmd.getColumnProperties(n3 + 1).getActualColumnName());
                    this.fieldValues_update[n4].append("=?");
                } else {
                    this.fieldValues_update[n4].append(",");
                    this.fieldValues_update[n4].append(this.m_rsmd.getColumnProperties(n3 + 1).getActualColumnName());
                    this.fieldValues_update[n4].append("=?");
                }
            }
            if (this.m_rsmd.getColumnProperties(n3 + 1).isUnique()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.generateUpdateStatement column No." + (n3 + 1) + ": isUnique=" + this.m_rsmd.getColumnProperties(n3 + 1).isUnique());
                }
                for (n2 = 0; n2 < this.uniqueTables.length; ++n2) {
                    if (string4.equalsIgnoreCase(this.uniqueTables[n2])) {
                        bl = true;
                        n7 = n2;
                        break;
                    }
                    n7 = n5;
                }
                if (!bl) {
                    this.uniqueTables[n5++] = string4;
                }
                bl = false;
                this.isUniqueColumnExist[n7] = true;
                if (!this.uniqueColumnFirstTime_update[n7]) continue;
                this.uniqueColumnFirstTime_update[n7] = false;
                object[n7][0] = n3 + 1;
                this.uniqueColumn_update[n7].append(this.m_rsmd.getColumnProperties(n3 + 1).getActualColumnName());
                this.uniqueColumn_update[n7].append("=?");
                continue;
            }
            if (!this.m_rsmd.getColumnProperties(n3 + 1).isKeyColumn()) continue;
            this.log.debug("ResultSetUpdater.generateUpdateStatement column No." + (n3 + 1) + ": isKeyColumn=" + this.m_rsmd.getColumnProperties(n3 + 1).isKeyColumn());
            for (n2 = 0; n2 < this.keyTables.length; ++n2) {
                if (string4.equalsIgnoreCase(this.keyTables[n2])) {
                    bl = true;
                    n8 = n2;
                    break;
                }
                n8 = n6;
            }
            if (!bl) {
                this.keyTables[n6++] = string4;
            }
            bl = false;
            this.isKeyColumnExist[n8] = true;
            object2[n8][n10++] = n3 + 1;
            int n15 = n8;
            nArray[n15] = nArray[n15] + 1;
            if (this.keyColumnsFirstTime_update[n8]) {
                this.keyColumnsFirstTime_update[n7] = false;
                this.keyColumns_update[n8].append(this.m_rsmd.getColumnProperties(n3 + 1).getActualColumnName());
                this.keyColumns_update[n8].append("=?");
                continue;
            }
            this.keyColumns_update[n8].append(" AND ");
            this.keyColumns_update[n8].append(this.m_rsmd.getColumnProperties(n3 + 1).getActualColumnName());
            this.keyColumns_update[n8].append("=?");
        }
        if (this.numOfDifferTable_update >= 0) {
            if (this.updateKeyValuesNumbers == null) {
                this.updateKeyValuesNumbers = new int[this.numOfDifferTable_update];
            }
            if (this.updateKeyValuesNumbers != null) {
                for (n3 = 0; n3 < this.updateKeyValuesNumbers.length; ++n3) {
                    this.updateKeyValuesNumbers[n3] = 0;
                }
            }
            if (this.haveUniqueColumn == null) {
                this.haveUniqueColumn = new boolean[this.numOfDifferTable_update];
            }
            if (this.haveUniqueColumn != null) {
                for (n3 = 0; n3 < this.haveUniqueColumn.length; ++n3) {
                    this.haveUniqueColumn[n3] = false;
                }
            }
            if (this.haveKeyColumns == null) {
                this.haveKeyColumns = new boolean[this.numOfDifferTable_update];
            }
            if (this.haveKeyColumns != null) {
                for (n3 = 0; n3 < this.haveKeyColumns.length; ++n3) {
                    this.haveKeyColumns[n3] = false;
                }
            }
            for (n3 = 0; n3 < this.numOfDifferTable_update; ++n3) {
                int n16;
                for (n16 = 0; n16 < this.uniqueTables.length; ++n16) {
                    if (!this.updateTables[n3].equalsIgnoreCase(this.uniqueTables[n16])) continue;
                    if (!this.isUniqueColumnExist[n16]) break;
                    string = this.uniqueColumn_update[n16].toString();
                    bl2 = true;
                    this.haveUniqueColumn[n3] = true;
                    this.indexUniqueColumn[n3][0] = object[n16][0];
                    Object object3 = resultSetRowContext.getObject(this.indexUniqueColumn[n3][0]);
                    if (object3 == null) {
                        this.log.debug("ResultSetUpdater.generateUpdateStatement: Unique Primary Index(UPI) columns are NULL for the table being updated: " + this.updateTables[n3]);
                        throw ErrorFactory.makeDriverJDBCException("TJ508", this.updateTables[n3]);
                    }
                    this.updateKeyValuesNumbers[n3] = 1;
                    break;
                }
                if (!bl2) {
                    for (n16 = 0; n16 < this.keyTables.length; ++n16) {
                        if (!this.updateTables[n3].equalsIgnoreCase(this.keyTables[n16])) continue;
                        if (!this.isKeyColumnExist[n16]) break;
                        string = this.keyColumns_update[n16].toString();
                        bl3 = true;
                        this.haveKeyColumns[n3] = true;
                        for (int i = 0; i < nArray[n16]; ++i) {
                            this.indexKeyColumns[n3][i] = object2[n16][i];
                            Object object4 = resultSetRowContext.getObject(this.indexKeyColumns[n3][i]);
                            if (object4 != null) continue;
                            this.log.debug("ResultSetUpdater.generateUpdateStatement: Primary Key columns are NULL for the table being updated: " + this.updateTables[n3]);
                            throw ErrorFactory.makeDriverJDBCException("TJ509", this.updateTables[n3]);
                        }
                        this.updateKeyValuesNumbers[n3] = nArray[n16];
                        break;
                    }
                }
                if (!bl2 && !bl3) {
                    string = null;
                }
                String string5 = null;
                if (this.fieldValues_update[n3] != null) {
                    string5 = this.fieldValues_update[n3].toString();
                }
                if (string5 != null && string != null) {
                    this.updateSQLs[n3] = "UPDATE " + this.updateTables[n3] + " " + string5 + " WHERE " + string;
                    this.log.debug("ResultSetUpdater.generateUpdateStatement updateSQLs[" + n3 + "]=" + this.updateSQLs[n3]);
                } else if (string == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ResultSetUpdater.generateUpdateStatement: No UPI/Key columns are fetched in this result set for the table being updated: " + this.updateTables[n3]);
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ510", this.updateTables[n3]);
                }
                string = null;
                bl2 = false;
                bl3 = false;
            }
        }
    }

    protected void generateInsertStatement(int n) throws SQLException {
        int n2;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = 0;
        this.initInsertBuffers();
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            int n6;
            string = this.m_rsmd.getColumnProperties(n2 + 1).getSchemaName();
            string2 = this.m_rsmd.getColumnProperties(n2 + 1).getTableName();
            string3 = string + "." + string2;
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.generateInsertStatement tableFullName=" + string3);
            }
            n4 = this.m_rsmd.getColumnProperties(n2 + 1).getNullable();
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.generateInsertStatement: column No." + (n2 + 1) + ": columnNullable=" + n4);
            }
            bl3 = false;
            bl2 = false;
            for (n6 = 0; n6 < n; ++n6) {
                n5 = this.indexColsChanged[n6];
                if (n2 != n5) continue;
                bl3 = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.generateInsertStatement column changed for column No." + (n2 + 1));
                }
                if (this.rowBuffer[n5] != null || !this.m_nullIndicator[n5]) break;
                bl2 = true;
                if (!this.log.isDebugEnabled()) break;
                this.log.debug("ResultSetUpdater.generateInsertStatement: columnNullIndicator = true for column No." + (n2 + 1));
                break;
            }
            if (n4 == 0) {
                if (!bl3) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ResultSetUpdater.generateInsertStatement: SQLException: Not all of non-nullable columns in the insert row have been given a value: columnNum=" + (n2 + 1) + " table name=" + string3);
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ511", String.valueOf(n2 + 1), string3);
                }
                if (bl3 && bl2) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ResultSetUpdater.generateInsertStatement: SQLException: Not all of non-nullable columns in the insert row have been given a non-null value: columnNum=" + (n2 + 1) + " table name=" + string3);
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ512", String.valueOf(n2 + 1), string3);
                }
            }
            if (!bl3) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.generateInsertStatement column No." + (n2 + 1) + ": columnChanged=" + bl3);
            }
            for (n6 = 0; n6 < this.insertTables.length; ++n6) {
                if (string3.equalsIgnoreCase(this.insertTables[n6])) {
                    bl = true;
                    n3 = n6;
                    break;
                }
                n3 = this.numOfDifferTable_insert;
            }
            if (!bl) {
                int n7 = this.numOfDifferTable_insert;
                int n8 = this.indexColsChangedCount_insert[n7];
                this.indexColsChangedCount_insert[n7] = n8 + 1;
                n6 = n8;
                this.indexColsChanged_insert[this.numOfDifferTable_insert][n6] = n5;
                this.insertTables[this.numOfDifferTable_insert++] = string3;
            } else if (bl) {
                int n9 = n3;
                int n10 = this.indexColsChangedCount_insert[n9];
                this.indexColsChangedCount_insert[n9] = n10 + 1;
                n6 = n10;
                this.indexColsChanged_insert[n3][n6] = n5;
            }
            bl = false;
            if (this.columnNamesFirstTime_insert[n3]) {
                this.columnNamesFirstTime_insert[n3] = false;
                this.columnNames_insert[n3].append(this.m_rsmd.getColumnProperties(n2 + 1).getActualColumnName());
                this.insertPlaceHolders_insert[n3].append("?");
                continue;
            }
            this.columnNames_insert[n3].append(",");
            this.columnNames_insert[n3].append(this.m_rsmd.getColumnProperties(n2 + 1).getActualColumnName());
            this.insertPlaceHolders_insert[n3].append(",?");
        }
        if (this.numOfDifferTable_insert > 0) {
            for (n2 = 0; n2 < this.numOfDifferTable_insert; ++n2) {
                String string4 = null;
                if (this.columnNames_insert[n2] != null) {
                    string4 = this.columnNames_insert[n2].toString();
                }
                if (string4 == null) continue;
                this.insertSQLs[n2] = "INSERT INTO " + this.insertTables[n2] + " (" + string4 + ") VALUES (" + this.insertPlaceHolders_insert[n2].toString() + ")";
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("ResultSetUpdater.generateInsertStatement insertSQLs[" + n2 + "]=" + this.insertSQLs[n2]);
            }
        }
    }

    protected void generateDeleteStatement(ResultSetRowContext resultSetRowContext) throws SQLException {
        int n;
        int n2;
        String string = null;
        int[] nArray = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        Object object = null;
        Object object2 = null;
        int n8 = 0;
        this.initDeleteBuffers();
        if (nArray == null) {
            nArray = new int[this.getColumnCount()];
        }
        if (nArray != null) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = 0;
            }
        }
        if (object == null) {
            object = new int[this.getColumnCount()][];
        }
        if (object != null) {
            for (n2 = 0; n2 < ((int[][])object).length; ++n2) {
                if (object[n2] == null) {
                    object[n2] = new int[this.getColumnCount()];
                }
                for (n = 0; n < object[n2].length; ++n) {
                    object[n2][n] = 0;
                }
            }
        }
        if (object2 == null) {
            object2 = new int[this.getColumnCount()][];
        }
        if (object2 != null) {
            for (n2 = 0; n2 < ((int[][])object2).length; ++n2) {
                if (object2[n2] == null) {
                    object2[n2] = new int[this.getColumnCount()];
                }
                for (n = 0; n < object2[n2].length; ++n) {
                    object2[n2][n] = 0;
                }
            }
        }
        for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
            bl2 = false;
            bl3 = false;
            string2 = this.m_rsmd.getColumnProperties(n2 + 1).getSchemaName();
            string3 = this.m_rsmd.getColumnProperties(n2 + 1).getTableName();
            string4 = string2 + "." + string3;
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.generateDeleteStatements tableFullName=" + string4);
            }
            if (this.m_rsmd.getColumnProperties(n2 + 1).isUnique()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.generateDeleteStatements column No." + (n2 + 1) + ": isUnique=" + this.m_rsmd.getColumnProperties(n2 + 1).isUnique());
                }
                for (n = 0; n < this.deleteTables.length; ++n) {
                    if (string4.equalsIgnoreCase(this.deleteTables[n])) {
                        bl = true;
                        n3 = n;
                        break;
                    }
                    n3 = this.numOfDifferTable_delete;
                }
                if (!bl) {
                    this.deleteTables[this.numOfDifferTable_delete++] = string4;
                }
                bl = false;
                for (n = 0; n < this.uniqueTables_delete.length; ++n) {
                    if (string4.equalsIgnoreCase(this.uniqueTables_delete[n])) {
                        bl = true;
                        n6 = n;
                        break;
                    }
                    n6 = n4;
                }
                if (!bl) {
                    this.uniqueTables_delete[n4++] = string4;
                }
                bl = false;
                this.isUniqueColumnExist_delete[n6] = true;
                if (this.uniqueColumnFirstTime_delete[n6]) {
                    this.uniqueColumnFirstTime_delete[n6] = false;
                    object[n6][0] = n2 + 1;
                    this.uniqueColumn_delete[n6].append(this.m_rsmd.getColumnProperties(n2 + 1).getActualColumnName());
                    this.uniqueColumn_delete[n6].append("=?");
                }
                bl2 = true;
            }
            if (!bl2 && this.m_rsmd.getColumnProperties(n2 + 1).isKeyColumn()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.generateDeleteStatements column No." + (n2 + 1) + ": isKeyColumn=" + this.m_rsmd.getColumnProperties(n2 + 1).isKeyColumn());
                }
                for (n = 0; n < this.deleteTables.length; ++n) {
                    if (string4.equalsIgnoreCase(this.deleteTables[n])) {
                        bl = true;
                        n3 = n;
                        break;
                    }
                    n3 = this.numOfDifferTable_delete;
                }
                if (!bl) {
                    this.deleteTables[this.numOfDifferTable_delete++] = string4;
                }
                bl = false;
                for (n = 0; n < this.keyTables_delete.length; ++n) {
                    if (string4.equalsIgnoreCase(this.keyTables_delete[n])) {
                        bl = true;
                        n7 = n;
                        break;
                    }
                    n7 = n5;
                }
                if (!bl) {
                    this.keyTables_delete[n5++] = string4;
                }
                bl = false;
                this.isKeyColumnExist_delete[n7] = true;
                object2[n7][n8++] = n2 + 1;
                int n9 = n7;
                nArray[n9] = nArray[n9] + 1;
                if (this.keyColumnsFirstTime_delete[n7]) {
                    this.keyColumnsFirstTime_delete[n6] = false;
                    this.keyColumns_delete[n7].append(this.m_rsmd.getColumnProperties(n2 + 1).getActualColumnName());
                    this.keyColumns_delete[n7].append("=?");
                } else {
                    this.keyColumns_delete[n7].append(" AND ");
                    this.keyColumns_delete[n7].append(this.m_rsmd.getColumnProperties(n2 + 1).getActualColumnName());
                    this.keyColumns_delete[n7].append("=?");
                }
                bl3 = true;
            }
            if (bl2 || bl3) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.generateDeleteStatements column No." + (n2 + 1) + ": Not a UPI or Key Column");
            }
            for (n = 0; n < this.deleteTables.length; ++n) {
                if (string4.equalsIgnoreCase(this.deleteTables[n])) {
                    bl = true;
                    n3 = n;
                    break;
                }
                n3 = this.numOfDifferTable_delete;
            }
            if (!bl) {
                this.deleteTables[this.numOfDifferTable_delete++] = string4;
            }
            bl = false;
        }
        if (this.numOfDifferTable_delete >= 0) {
            if (this.deleteKeyValuesNumbers == null) {
                this.deleteKeyValuesNumbers = new int[this.numOfDifferTable_delete];
            }
            if (this.deleteKeyValuesNumbers != null) {
                for (n2 = 0; n2 < this.deleteKeyValuesNumbers.length; ++n2) {
                    this.deleteKeyValuesNumbers[n2] = 0;
                }
            }
            if (this.haveUniqueColumn_delete == null) {
                this.haveUniqueColumn_delete = new boolean[this.numOfDifferTable_delete];
            }
            if (this.haveUniqueColumn_delete != null) {
                for (n2 = 0; n2 < this.haveUniqueColumn_delete.length; ++n2) {
                    this.haveUniqueColumn_delete[n2] = false;
                }
            }
            if (this.haveKeyColumns_delete == null) {
                this.haveKeyColumns_delete = new boolean[this.numOfDifferTable_delete];
            }
            if (this.haveKeyColumns_delete != null) {
                for (n2 = 0; n2 < this.haveKeyColumns_delete.length; ++n2) {
                    this.haveKeyColumns_delete[n2] = false;
                }
            }
            for (n2 = 0; n2 < this.numOfDifferTable_delete; ++n2) {
                for (n = 0; n < this.uniqueTables_delete.length; ++n) {
                    if (!this.deleteTables[n2].equalsIgnoreCase(this.uniqueTables_delete[n])) continue;
                    if (!this.isUniqueColumnExist_delete[n]) break;
                    string = this.uniqueColumn_delete[n].toString();
                    bl4 = true;
                    this.haveUniqueColumn_delete[n2] = true;
                    this.indexUniqueColumn_delete[n2][0] = object[n][0];
                    Object object3 = resultSetRowContext.getObject(this.indexUniqueColumn_delete[n2][0]);
                    if (object3 == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ResultSetUpdater.generateDeleteStatement: Unique Primary Index (UPI) columns are NULL for the table being deleted: " + this.deleteTables[n2]);
                        }
                        throw ErrorFactory.makeDriverJDBCException("TJ508", this.deleteTables[n2]);
                    }
                    this.deleteKeyValuesNumbers[n2] = 1;
                    break;
                }
                if (!bl4) {
                    for (n = 0; n < this.keyTables_delete.length; ++n) {
                        if (!this.deleteTables[n2].equalsIgnoreCase(this.keyTables_delete[n])) continue;
                        if (!this.isKeyColumnExist_delete[n]) break;
                        string = this.keyColumns_delete[n].toString();
                        bl5 = true;
                        this.haveKeyColumns_delete[n2] = true;
                        for (int i = 0; i < nArray[n]; ++i) {
                            this.indexKeyColumns_delete[n2][i] = object2[n][i];
                            Object object4 = resultSetRowContext.getObject(this.indexKeyColumns_delete[n2][i]);
                            if (object4 != null) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("ResultSetUpdater.generateDeleteStatement: Primary Key columns are NULL for the table being deleted: " + this.deleteTables[n2]);
                            }
                            throw ErrorFactory.makeDriverJDBCException("TJ509", this.deleteTables[n2]);
                        }
                        this.deleteKeyValuesNumbers[n2] = nArray[n];
                        break;
                    }
                }
                if (!bl4 && !bl5) {
                    string = null;
                }
                if (string != null) {
                    this.deleteSQLs[n2] = "DELETE FROM " + this.deleteTables[n2] + " " + " WHERE " + string;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ResultSetUpdater.generateDeleteStatement deleteSQLs[" + n2 + "]===>" + this.deleteSQLs[n2]);
                    }
                } else if (string == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ResultSetUpdater.generateDeleteStatement: No UPI/Key columns are fetched in this result set for the table being deleted: " + this.deleteTables[n2]);
                    }
                    throw ErrorFactory.makeDriverJDBCException("TJ510", this.deleteTables[n2]);
                }
                string = null;
                bl4 = false;
                bl5 = false;
            }
        }
    }

    private void prepareUpdateRowStatement(int n) throws SQLException {
        if (this.updateStmt != null) {
            this.updateStmt.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareUpdateRowStatement updateSQLs[" + n + "]==" + this.updateSQLs[n]);
        }
        this.updateStmt = this.m_con.prepareStatement(this.updateSQLs[n]);
        this.updateStmt.clearParameters();
    }

    private void prepareInsertRowStatement(int n) throws SQLException {
        if (this.insertStmt != null) {
            this.insertStmt.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareInsertRowStatement insertSQLs[" + n + "]==" + this.insertSQLs[n]);
        }
        this.insertStmt = this.m_con.prepareStatement(this.insertSQLs[n]);
        this.insertStmt.clearParameters();
    }

    private void prepareDeleteRowStatement(int n) throws SQLException {
        if (this.deleteStmt != null) {
            this.deleteStmt.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareDeleteRowStatement deleteSQLs[" + n + "]==" + this.deleteSQLs[n]);
        }
        this.deleteStmt = this.m_con.prepareStatement(this.deleteSQLs[n]);
        this.deleteStmt.clearParameters();
    }

    private void prepareUpdateRowBinds(ResultSetRowContext resultSetRowContext, int n, int n2) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareUpdateRowBinds i=" + n + " tableNum=" + n2);
        }
        int n3 = 1;
        int n4 = 0;
        Object object = null;
        Object object2 = null;
        int n5 = n + this.updateKeyValuesNumbers[n2];
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareUpdateRowBinds: updateTables[" + n2 + "]=" + this.updateTables[n2]);
            this.log.debug("ResultSetUpdater.prepareUpdateRowBinds totalBindParameter=" + n5);
        }
        for (int i = 0; i < n5; ++i) {
            if (i < n) {
                int n6 = this.indexColsChanged_update[n2][i];
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.prepareUpdateRowBinds: changed column l=" + n6);
                }
                object = this.getRowBufferAt(n6);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.prepareUpdateRowBinds: obj=" + object);
                }
                if (object != null) {
                    if (object instanceof String) {
                        ((TDPreparedStatement)((Object)this.updateStmt)).internalSetString(n3++, n6 + 1, null, (String)object);
                        continue;
                    }
                    if (object instanceof TeraSQLXML) {
                        ((TDPreparedStatement)((Object)this.updateStmt)).internalSetSQLXML(n3++, n6 + 1, null, (TeraSQLXML)object);
                        continue;
                    }
                    if (object instanceof Reader) {
                        ((TDPreparedStatement)((Object)this.updateStmt)).internalSetCharacterStream(n3++, n6 + 1, null, (Reader)object, this.typeInfo[n6][0]);
                        continue;
                    }
                    if (object instanceof InputStream) {
                        if (this.typeInfo[n6][1] == 1) {
                            ((TDPreparedStatement)((Object)this.updateStmt)).internalSetAsciiStream(n3++, n6 + 1, null, (InputStream)object, this.typeInfo[n6][0]);
                            continue;
                        }
                        if (this.typeInfo[n6][1] != 2) continue;
                        this.updateStmt.setBinaryStream(n3++, (InputStream)object, this.typeInfo[n6][0]);
                        continue;
                    }
                    this.updateStmt.setObject(n3++, object);
                    continue;
                }
                int n7 = this.m_rsmd.getColumnType(n6 + 1);
                this.updateStmt.setNull(n3++, n7, n7 == 2002 || n7 == 2001 ? this.m_rsmd.getColumnTypeName(n6 + 1) : null);
                continue;
            }
            if (i < n || i >= n5) continue;
            if (this.haveUniqueColumn[n2]) {
                object2 = resultSetRowContext.getObject(this.indexUniqueColumn[n2][0]);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.prepareUpdateRowBinds: indexUniqueColumn[" + n2 + "][0]=" + object2);
                }
                if (object2 != null) {
                    this.updateStmt.setObject(n3++, object2);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.prepareUpdateRowBinds: Unique Primary Index (UPI) columns are NULL for the table being updated: updateTables[" + n2 + "]=" + this.updateTables[n2]);
                }
                throw ErrorFactory.makeDriverJDBCException("TJ508", this.updateTables[n2]);
            }
            if (!this.haveKeyColumns[n2]) continue;
            object2 = resultSetRowContext.getObject(this.indexKeyColumns[n2][n4]);
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.prepareUpdateRowBinds: indexKeyColumns[" + n2 + "][" + n4 + "]=" + object2);
            }
            ++n4;
            if (object2 != null) {
                this.updateStmt.setObject(n3++, object2);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.prepareUpdateRowBinds: Primary Key columns are NULL for the table being updated: updateTables[" + n2 + "]=" + this.updateTables[n2]);
            }
            throw ErrorFactory.makeDriverJDBCException("TJ509", this.updateTables[n2]);
        }
    }

    private void prepareInsertRowBinds(int n, int n2) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareInsertRowBinds i=" + n + " tableNum=" + n2);
        }
        int n3 = 1;
        Object object = null;
        int n4 = n;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareInsertRowBinds totalBindParameter=" + n4);
        }
        for (int i = 0; i < n4; ++i) {
            int n5 = this.indexColsChanged_insert[n2][i];
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.prepareInsertRowBinds: changed column l=" + n5);
            }
            object = this.getRowBufferAt(n5);
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.prepareInsertRowBinds: obj=" + object);
            }
            if (object != null) {
                if (object instanceof Reader) {
                    this.insertStmt.setCharacterStream(n3++, (Reader)object, this.typeInfo[n5][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.typeInfo[n5][1] == 1) {
                        this.insertStmt.setAsciiStream(n3++, (InputStream)object, this.typeInfo[n5][0]);
                        continue;
                    }
                    if (this.typeInfo[n5][1] != 2) continue;
                    this.insertStmt.setBinaryStream(n3++, (InputStream)object, this.typeInfo[n5][0]);
                    continue;
                }
                this.insertStmt.setObject(n3++, object);
                continue;
            }
            int n6 = this.m_rsmd.getColumnType(n5 + 1);
            this.insertStmt.setNull(n3++, n6, n6 == 2002 || n6 == 2001 ? this.m_rsmd.getColumnTypeName(n5 + 1) : null);
        }
    }

    private void prepareDeleteRowBinds(ResultSetRowContext resultSetRowContext, int n) throws SQLException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareDeleteRowBinds tableNum=" + n);
        }
        int n2 = 1;
        int n3 = 0;
        Object object = null;
        int n4 = this.deleteKeyValuesNumbers[n];
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSetUpdater.prepareDeleteRowBinds: deleteTables[" + n + "]=" + this.deleteTables[n]);
            this.log.debug("ResultSetUpdater.prepareDeleteRowBinds totalBindParameter=" + n4);
        }
        for (int i = 0; i < n4; ++i) {
            if (this.haveUniqueColumn_delete[n]) {
                object = resultSetRowContext.getObject(this.indexUniqueColumn_delete[n][0]);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.prepareDeleteRowBinds: indexUniqueColumn_delete[" + n + "][0]=" + object);
                }
                if (object != null) {
                    this.deleteStmt.setObject(n2++, object);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.prepareDeleteRowBinds: Unique Primary Index (UPI) columns are NULL for the table being deleted: deleteTables[" + n + "]=" + this.deleteTables[n]);
                }
                throw ErrorFactory.makeDriverJDBCException("TJ508", this.deleteTables[n]);
            }
            if (!this.haveKeyColumns_delete[n]) continue;
            object = resultSetRowContext.getObject(this.indexKeyColumns_delete[n][n3]);
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.prepareDeleteRowBinds: indexKeyColumns_delete[" + n + "][" + n3 + "]=" + object);
            }
            ++n3;
            if (object != null) {
                this.deleteStmt.setObject(n2++, object);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSetUpdater.prepareDeleteRowBinds: Primary Key columns are NULL for the table being deleted: deleteTables[" + n + "]=" + this.deleteTables[n]);
            }
            throw ErrorFactory.makeDriverJDBCException("TJ509", this.deleteTables[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdateRow(int n) throws SQLException {
        try {
            if (this.updateStmt.executeUpdate() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.executeUpdateRow: fail to update the current row for the table: " + this.updateTables[n]);
                }
                throw ErrorFactory.makeDriverJDBCException("TJ513", this.updateTables[n]);
            }
        }
        finally {
            if (this.updateStmt != null) {
                this.updateStmt.close();
                this.updateStmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInsertRow(int n) throws SQLException {
        try {
            if (this.insertStmt.executeUpdate() != 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.executeInsertRow: fail to insert a row for the table: " + this.insertTables[n]);
                }
                throw ErrorFactory.makeDriverJDBCException("TJ547", this.insertTables[n]);
            }
        }
        finally {
            if (this.insertStmt != null) {
                this.insertStmt.close();
                this.insertStmt = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDeleteRow(int n) throws SQLException {
        try {
            if (this.deleteStmt.executeUpdate() == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("ResultSetUpdater.executeDeleteRow: fail to delete the current row for the table: " + this.deleteTables[n]);
                }
                throw ErrorFactory.makeDriverJDBCException("TJ548", this.deleteTables[n]);
            }
        }
        finally {
            if (this.deleteStmt != null) {
                this.deleteStmt.close();
                this.deleteStmt = null;
            }
        }
    }
}

