/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import java.sql.SQLException;

public class GtwConfigParcel
extends Parcel {
    private boolean supportsUTF_Credentials = false;
    private boolean m_bSupportsControlData = false;
    private boolean m_bSupportsRecoverableNP = false;
    private boolean m_bSupportsRedrive = false;
    private boolean m_bSupportsNegotiationMechanism = false;
    private String m_sIdentityProviderClientID = null;
    private String m_sIdentityProviderURL = null;
    private boolean m_bSupportsTLS = false;
    private byte m_byLegacyPort = 0;
    private byte m_byHTTPSPort = 0;

    public String formatGtwConfigAsJSON() {
        return "{\"SupportsUTF16Credentials\":\"" + this.supportsUTF_Credentials + "\"" + ",\"SupportsControlData\":\"" + this.m_bSupportsControlData + "\"" + ",\"SupportsRecoverableNetworkProtocol\":\"" + this.m_bSupportsRecoverableNP + "\"" + ",\"SupportsRedrive\":\"" + this.m_bSupportsRedrive + "\"" + ",\"SupportsNegotiationMechanism\":\"" + this.m_bSupportsNegotiationMechanism + "\"" + ",\"IdentityProviderClientID\":\"" + this.m_sIdentityProviderClientID + "\"" + ",\"IdentityProviderURL\":\"" + this.m_sIdentityProviderURL + "\"" + ",\"SupportsTLS\":\"" + this.m_bSupportsTLS + "\"" + ",\"LegacyPort\":\"" + this.m_byLegacyPort + "\"" + ",\"HTTPSPort\":\"" + this.m_byHTTPSPort + "\"" + "}";
    }

    public GtwConfigParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.flavorPosition = tDPacketStream.position();
        this.setFlavor(tDPacketStream.getShort());
        this.setLength(tDPacketStream.getShort());
        if (tDPacketStream.getInt() == 1) {
            this.determineFeatureSupport(tDPacketStream, this.flavorPosition + this.length);
        }
    }

    private void determineFeatureSupport(TDPacketStream tDPacketStream, int n) throws SQLException {
        while (tDPacketStream.position() + 4 <= n) {
            int n2 = tDPacketStream.position();
            short s = tDPacketStream.getShort();
            short s2 = tDPacketStream.getShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug("GtwConfigParcel: self-defining feature " + s + " at position " + n2 + " has length " + s2);
            }
            switch (s) {
                case 3: {
                    this.supportsUTF_Credentials = true;
                    break;
                }
                case 6: {
                    this.m_bSupportsControlData = true;
                    break;
                }
                case 5: {
                    this.m_bSupportsRecoverableNP = true;
                    break;
                }
                case 7: {
                    this.m_bSupportsRedrive = true;
                    break;
                }
                case 12: {
                    this.m_bSupportsNegotiationMechanism = tDPacketStream.getShort() >= 1;
                    break;
                }
                case 15: {
                    this.m_sIdentityProviderClientID = tDPacketStream.getStringUTF8(tDPacketStream.getUnsignedShort());
                    this.m_sIdentityProviderURL = tDPacketStream.getStringUTF8(tDPacketStream.getUnsignedShort());
                    break;
                }
                case 16: {
                    this.m_bSupportsTLS = true;
                    this.m_byLegacyPort = tDPacketStream.get();
                    this.m_byHTTPSPort = tDPacketStream.get();
                }
            }
            tDPacketStream.position(n2 + s2);
        }
    }

    public boolean isUTF_CredentialSupported() {
        return this.supportsUTF_Credentials;
    }

    public boolean isControlDataSupported() {
        return this.m_bSupportsControlData;
    }

    public boolean isRecoverableNPSupported() {
        return this.m_bSupportsRecoverableNP;
    }

    public boolean isRedriveSupported() {
        return this.m_bSupportsRedrive;
    }

    public boolean isNegotiationMechanismSupported() {
        return this.m_bSupportsNegotiationMechanism;
    }

    public String getIdentityProviderClientID() {
        return this.m_sIdentityProviderClientID;
    }

    public String getIdentityProviderURL() {
        return this.m_sIdentityProviderURL;
    }

    public boolean isLegacyPortAvailable() {
        return !this.m_bSupportsTLS || this.m_byLegacyPort >= 1;
    }

    public boolean isHTTPSPortAvailable() {
        return this.m_byHTTPSPort >= 1;
    }
}

