/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoEndParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveContinueSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveMultipartRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceivePauseSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class ReceiveStatementInfoEndSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private StatementInfoEndParcel currentEvent;
    protected Log log;

    public ReceiveStatementInfoEndSubState(StatementReceiveState statementReceiveState, StatementInfoEndParcel statementInfoEndParcel) {
        this.compositeState = statementReceiveState;
        this.currentEvent = statementInfoEndParcel;
        this.log = this.compositeState.getController().getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        TDParcelState tDParcelState = null;
        Parcel parcel = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReceiveStatementInfoEndSubState.action currentEvent=" + this.currentEvent);
        }
        if (this.currentEvent == null) {
            this.compositeState.setHistoricalState(null);
        }
        if ((parcel = this.compositeState.getNextParcel()) != null) {
            switch (parcel.getFlavor()) {
                case 10: {
                    tDParcelState = new ReceiveRecordSubState(this.compositeState, (RecordParcel)parcel);
                    break;
                }
                case 144: {
                    tDParcelState = new ReceiveMultipartRecordSubState(this.compositeState, (RecordParcel)parcel);
                    break;
                }
                case 11: {
                    boolean bl = this.compositeState.getController().usePositioning();
                    int n = this.compositeState.getPacket().nextParcelPeek();
                    boolean bl2 = n == 8 || n == 205;
                    boolean bl3 = n == 12;
                    boolean bl4 = ActivityAnalyzer.resultSetExpected(this.compositeState.getActivityType());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ReceiveStatementInfoEndSubState.action got PCLENDSTATEMENT, usePositioning=" + bl + ", bAnotherBundleComing=" + bl2 + ", bGotEndRequest=" + bl3 + ", bResultSetExpected=" + bl4 + ", this=" + this);
                    }
                    if (bl3) {
                        this.compositeState.getController().getStatement().getResults().markRequestAsComplete();
                    }
                    if (this.compositeState.getCurrentResultSet() != null) {
                        this.compositeState.getCurrentResultSet().lastRowFetched();
                    }
                    if (bl && !bl2 && this.compositeState.getCurrentResultSet() != null && bl4 && !ActivityAnalyzer.outParamResultSet(this.compositeState.getActivityType())) {
                        tDParcelState = new ReceivePauseSubState(this.compositeState, this, new StatementContinueState(this.compositeState.getController(), this.compositeState));
                        this.compositeState.savePrepInfo();
                        break;
                    }
                    tDParcelState = new ReceiveEndSubState(this.compositeState, (EndStatementParcel)parcel);
                    break;
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode(), errorParcel.getInfo());
                }
                default: {
                    throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                }
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveStatementInfoEndSubState.action reached end-of-packet, reading continuously, this=" + this);
            }
            this.currentEvent = null;
            tDParcelState = new ReceiveContinueSubState(this.compositeState, this);
            this.compositeState.savePrepInfo();
        }
        return tDParcelState;
    }
}

