/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jgssspi.GSSMechanismManager;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssContext;
import com.teradata.tdgss.jtdgss.TdgssCredential;
import com.teradata.tdgss.jtdgss.TdgssDeferredLogger;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLocationLogger;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssName;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Provider;
import java.util.Vector;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class TdgssManager
extends GSSMechanismManager {
    private static final TdgssDeferredLogger deferredLogger = new TdgssDeferredLogger();
    private static final TdgssManager instance = new TdgssManager(deferredLogger);
    private Vector mechImplementations;
    private TdgssConfigApi capi;
    private final TdgssLogger logger;
    public final Oid GSS_C_NT_TDAT_MECHDATA_UTF8;
    public final Oid GSS_C_NT_TDAT_MECHDATA_UTF16;
    public final Oid GSS_C_NT_TDAT_MECHDATA_UTF32;
    public final Oid GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA;
    public final Oid GSS_C_NT_TDAT_USER;
    public final Oid GSS_C_NT_TDAT_PASSWORD;
    public final Oid GSS_C_NT_TDAT_MECHDATA;

    private TdgssManager() {
        this(deferredLogger);
    }

    private TdgssManager(TdgssLogger tdgssLogger) {
        this.logger = new TdgssLocationLogger(tdgssLogger);
        try {
            this.GSS_C_NT_TDAT_MECHDATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.2");
            this.GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA = new Oid("1.3.6.1.4.1.191.1.1012.1.2.1");
            this.GSS_C_NT_TDAT_MECHDATA_UTF8 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.3");
            this.GSS_C_NT_TDAT_MECHDATA_UTF16 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.4");
            this.GSS_C_NT_TDAT_MECHDATA_UTF32 = new Oid("1.3.6.1.4.1.191.1.1012.1.2.5");
            this.GSS_C_NT_TDAT_USER = new Oid("1.3.6.1.4.1.191.1.1012.1.2.6");
            this.GSS_C_NT_TDAT_PASSWORD = new Oid("1.3.6.1.4.1.191.1.1012.1.2.7");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        this.mechImplementations = new Vector();
        this.capi = TdgssConfigApi.newInstance(tdgssLogger);
        if (this.capi != null) {
            String[] stringArray = this.capi.GetMechanisms();
            int n = 0;
            while (stringArray[n] != null) {
                GSSMechanism gSSMechanism = (GSSMechanism)TdgssManager.createObject(stringArray[n], this.logger);
                if (gSSMechanism != null) {
                    this.mechImplementations.addElement(gSSMechanism);
                }
                ++n;
            }
        }
        try {
            Class.forName("com.teradata.tdgss.jalgapi.AlgParcel");
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage());
        }
    }

    public static GSSManager getInstance() {
        return instance;
    }

    public static TdgssManager newInstance(TdgssLogger tdgssLogger) {
        deferredLogger.report(tdgssLogger);
        return new TdgssManager(tdgssLogger);
    }

    public Oid[] getMechs() {
        Oid[] oidArray = new Oid[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            oidArray[i] = ((GSSMechanism)this.mechImplementations.elementAt(i)).getMech();
        }
        return oidArray;
    }

    public Oid[] getNamesForMech(Oid oid) throws GSSException {
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            if (!((GSSMechanism)this.mechImplementations.elementAt(i)).getMech().equals(oid)) continue;
            return ((GSSMechanism)this.mechImplementations.elementAt(i)).getNames();
        }
        throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_BAD_MECH);
    }

    public Oid[] getMechsForName(Oid oid) {
        return null;
    }

    public GSSName createName(String string, Oid oid) throws GSSException {
        if (string != null) {
            return this.createName(string.getBytes(), oid);
        }
        return this.createName((byte[])null, oid);
    }

    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        GSSMechanism[] gSSMechanismArray = new GSSMechanism[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            gSSMechanismArray[i] = (GSSMechanism)this.mechImplementations.elementAt(i);
        }
        TdgssName tdgssName = new TdgssName(byArray, oid, gSSMechanismArray, this.logger);
        return tdgssName;
    }

    public GSSName createName(String string, Oid oid, Oid oid2) throws GSSException {
        if (string != null) {
            try {
                if (oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
                    return this.createName(string.getBytes("UTF-16"), oid, oid2);
                }
                if (oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8) || oid.equals(TdgssName.GSS_C_NT_TDAT_USER) || oid.equals(TdgssName.GSS_C_NT_TDAT_PASSWORD)) {
                    return this.createName(string.getBytes("UTF-8"), oid, oid2);
                }
                return this.createName(string.getBytes("US-ASCII"), oid, oid2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.logger.error(unsupportedEncodingException.getMessage());
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CANT_IMPORT_NAME, unsupportedEncodingException);
            }
        }
        return this.createName((byte[])null, oid, oid2);
    }

    public GSSName createName(byte[] byArray, Oid oid, Oid oid2) throws GSSException {
        GSSMechanism[] gSSMechanismArray = new GSSMechanism[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            gSSMechanismArray[i] = (GSSMechanism)this.mechImplementations.elementAt(i);
        }
        TdgssName tdgssName = new TdgssName(byArray, oid, gSSMechanismArray, this.logger);
        return tdgssName.canonicalize(oid2);
    }

    public GSSCredential createCredential(int n) throws GSSException {
        return this.createCredential(null, Integer.MAX_VALUE, (Oid[])null, n);
    }

    public GSSCredential createCredential(GSSName gSSName, int n, Oid oid, int n2) throws GSSException {
        if (oid != null) {
            Oid[] oidArray = new Oid[]{oid};
            return this.createCredential(gSSName, n, oidArray, n2);
        }
        return this.createCredential(gSSName, n, (Oid[])null, n2);
    }

    public GSSCredential createCredential(GSSName gSSName, int n, Oid[] oidArray, int n2) throws GSSException {
        TdgssName tdgssName;
        if (gSSName == null) {
            tdgssName = null;
        } else if (gSSName instanceof TdgssName) {
            tdgssName = (TdgssName)gSSName;
        } else {
            throw new TdgssException(3, TdgssMinorStatus.TDGSS_ERR_NOT_CONTAINER_IMPLEMENTATION);
        }
        GSSMechanism[] gSSMechanismArray = new GSSMechanism[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            gSSMechanismArray[i] = (GSSMechanism)this.mechImplementations.elementAt(i);
        }
        return new TdgssCredential(tdgssName, n, oidArray, n2, gSSMechanismArray, this.logger);
    }

    public GSSContext createContext(GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n) throws GSSException {
        TdgssCredential tdgssCredential;
        TdgssName tdgssName;
        if (gSSName == null) {
            tdgssName = null;
        } else if (gSSName instanceof TdgssName) {
            tdgssName = (TdgssName)gSSName;
        } else {
            throw new TdgssException(3, TdgssMinorStatus.TDGSS_ERR_NOT_CONTAINER_IMPLEMENTATION);
        }
        if (gSSCredential == null) {
            tdgssCredential = null;
        } else if (gSSCredential instanceof TdgssCredential) {
            tdgssCredential = (TdgssCredential)gSSCredential;
        } else {
            throw new TdgssException(9, TdgssMinorStatus.TDGSS_ERR_NOT_CONTAINER_IMPLEMENTATION);
        }
        GSSMechanism[] gSSMechanismArray = new GSSMechanism[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            gSSMechanismArray[i] = (GSSMechanism)this.mechImplementations.elementAt(i);
        }
        return new TdgssContext(tdgssName, oid, tdgssCredential, n, gSSMechanismArray, this.logger);
    }

    public GSSContext createContext(GSSCredential gSSCredential) throws GSSException {
        TdgssCredential tdgssCredential;
        if (gSSCredential == null) {
            tdgssCredential = null;
        } else if (gSSCredential instanceof TdgssCredential) {
            tdgssCredential = (TdgssCredential)gSSCredential;
        } else {
            throw new TdgssException(9, TdgssMinorStatus.TDGSS_ERR_NOT_CONTAINER_IMPLEMENTATION);
        }
        GSSMechanism[] gSSMechanismArray = new GSSMechanism[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            gSSMechanismArray[i] = (GSSMechanism)this.mechImplementations.elementAt(i);
        }
        return new TdgssContext(tdgssCredential, gSSMechanismArray, this.logger);
    }

    public GSSContext createContext(byte[] byArray) throws GSSException {
        return new TdgssContext(byArray, this.logger);
    }

    public GSSMechanism[] getMechImplementations() {
        GSSMechanism[] gSSMechanismArray = new GSSMechanism[this.mechImplementations.size()];
        for (int i = 0; i < this.mechImplementations.size(); ++i) {
            gSSMechanismArray[i] = (GSSMechanism)this.mechImplementations.elementAt(i);
        }
        return gSSMechanismArray;
    }

    public GSSMechanism removeMechImplementation(int n) {
        if (n < 0 || n >= this.mechImplementations.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        GSSMechanism gSSMechanism = (GSSMechanism)this.mechImplementations.elementAt(n);
        this.mechImplementations.removeElementAt(n);
        return gSSMechanism;
    }

    public void insertMechImplementation(GSSMechanism gSSMechanism, int n) {
        if (n < 0) {
            this.mechImplementations.insertElementAt(gSSMechanism, 0);
        } else if (n >= this.mechImplementations.size()) {
            this.mechImplementations.addElement(gSSMechanism);
        } else {
            this.mechImplementations.insertElementAt(gSSMechanism, n);
        }
    }

    private void addProviderAt(Provider provider, Oid oid, int n) throws GSSException {
        if (oid == null || provider == null) {
            throw new NullPointerException("Input arguments are null");
        }
        if (n < 0 || n > this.mechImplementations.size()) {
            throw new IllegalArgumentException("Index is out of range");
        }
        String string = provider.getProperty("GSSMechanism-" + oid.toString());
        if (string == null) {
            throw new TdgssException(2);
        }
        try {
            GSSMechanism gSSMechanism;
            Class<?> clazz = Class.forName(string);
            try {
                Constructor<?> constructor = clazz.getConstructor(TdgssLogger.class);
                Object obj = constructor.newInstance(this.logger);
                gSSMechanism = (GSSMechanism)obj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Object obj = clazz.newInstance();
                gSSMechanism = (GSSMechanism)obj;
            }
            this.mechImplementations.add(n, gSSMechanism);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TdgssException(16, (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new TdgssException(16, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TdgssException(16, (Throwable)illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TdgssException(16, (Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TdgssException(16, (Throwable)invocationTargetException);
        }
        catch (SecurityException securityException) {
            throw new TdgssException(16, (Throwable)securityException);
        }
        catch (ClassCastException classCastException) {
            throw new TdgssException(16, (Throwable)classCastException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new TdgssException(16, (Throwable)arrayIndexOutOfBoundsException);
        }
    }

    public boolean addProvider(Provider provider) {
        String[] stringArray = null;
        try {
            stringArray = (String[])provider.get("GSSMechanism");
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                GSSMechanism gSSMechanism;
                Object obj;
                Class<?> clazz = Class.forName(stringArray[i]);
                try {
                    Constructor<?> constructor = clazz.getConstructor(TdgssLogger.class);
                    obj = constructor.newInstance(this.logger);
                    gSSMechanism = (GSSMechanism)obj;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    obj = clazz.newInstance();
                    gSSMechanism = (GSSMechanism)obj;
                }
                this.mechImplementations.addElement(gSSMechanism);
                bl = true;
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                continue;
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return bl;
    }

    public void addProviderAtEnd(Provider provider, Oid oid) throws GSSException {
        this.addProviderAt(provider, oid, this.mechImplementations.size());
    }

    public void addProviderAtFront(Provider provider, Oid oid) throws GSSException {
        this.addProviderAt(provider, oid, 0);
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static Object createObject(String string, TdgssLogger tdgssLogger) {
        Object var2_2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(TdgssLogger.class);
            var2_2 = constructor.newInstance(tdgssLogger);
        }
        catch (InstantiationException instantiationException) {
            tdgssLogger.error(instantiationException.getMessage() + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            tdgssLogger.error(illegalAccessException.getMessage() + string, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            tdgssLogger.error(classNotFoundException.getMessage() + string, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            tdgssLogger.error("Constructor for " + string + " does not exist", noSuchMethodException);
        }
        catch (SecurityException securityException) {
            tdgssLogger.error("No access to constructor for " + string, securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            tdgssLogger.error("Programming error: argument passed to the constructor for class " + string + " is incorrect", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            tdgssLogger.error("Constructor for class " + string + " threw an exception", invocationTargetException);
        }
        return var2_2;
    }

    public String getNameForOid(Oid oid) {
        try {
            String[] stringArray = this.capi.GetInforForMech(oid);
            return stringArray[0];
        }
        catch (Exception exception) {
            this.logger.error(exception.getMessage());
            return null;
        }
    }
}

