/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.security.Security;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeraDriver
implements Driver {
    protected static Log log = new Log("TeraDriver/" + (class$com$teradata$jdbc$TeraDriver == null ? (class$com$teradata$jdbc$TeraDriver = TeraDriver.class$("com.teradata.jdbc.TeraDriver")) : class$com$teradata$jdbc$TeraDriver).getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    private static final int FORMAT_TEXT = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_CSV = 3;
    private static Calendar DUMMY_CALENDAR;
    static /* synthetic */ Class class$com$teradata$jdbc$TeraDriver;

    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        String string3;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string4 = "";
        String string5 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string6 = string.substring(string5.length());
        int n = string6.indexOf("/");
        if (n >= 0) {
            string3 = string6.substring(0, n);
            string4 = string6.substring(n + 1);
        } else {
            string3 = string6.trim();
            string4 = "";
        }
        if (string3.startsWith("[") && string3.endsWith("]")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (properties != null && properties.containsKey("username")) {
            boolean bl2;
            string2 = (String)properties.remove("username");
            boolean bl3 = bl2 = !properties.containsKey("user");
            if (bl2) {
                properties.setProperty("user", string2);
            }
        }
        URLParameters uRLParameters = new URLParameters(string4, properties);
        string2 = uRLParameters.getUser();
        String string7 = uRLParameters.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string3, string2, string7, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)((Object)connection);
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    public int getMajorVersion() {
        return 17;
    }

    public int getMinorVersion() {
        return 20;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)((Object)clob);
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)((Object)blob);
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        Object object;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)((Object)currentThreadIO.getConnection())).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (object = (TDResultSet)((Object)resultSetArray[i])) == null || ((TDResultSet)object).isClosed()) continue;
            long l = ((TDResultSet)object).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)object).getRequestNumber() + " stmtnum=" + ((TDResultSet)object).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)object).getStatementNumber(), ((TDResultSet)object).getRequestNumber(), l));
            ((TDResultSet)object).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)((Object)currentThreadIO.getConnection());
        object = (TDStatement)((Object)tDSession.createStatement());
        StatementController statementController = new StatementController((TDStatement)object, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    private static String quoteText(String string) {
        return "\"" + string.replaceAll("[\r\n]+", " ").replaceAll("\"", "\"\"") + "\"";
    }

    private static String quoteCsvText(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= ' ' && c != ',' && c != '\"') continue;
            return "\"" + string.replaceAll("\"", "\"\"") + "\"";
        }
        return string;
    }

    private static String formatValue(int n, boolean bl, int n2, String string, String string2) {
        if (n == 1) {
            return string + " = " + (string2 == null ? "null" : TeraDriver.quoteText(string2));
        }
        if (n == 2) {
            return (bl ? string + "=" : (n2 > 1 ? " " : "")) + (string2 == null ? "null" : string2.replaceAll("[\r\n]+", "\n"));
        }
        return (n2 > 1 ? "," : "") + (string2 == null ? "" : TeraDriver.quoteCsvText(string2));
    }

    private static void printValue(PrintWriter printWriter, int n, boolean bl, int n2, int n3, String string, String string2) {
        boolean bl2;
        String string3 = TeraDriver.formatValue(n, bl, n2, string, string2);
        boolean bl3 = n == 1 || n == 2 && bl;
        boolean bl4 = bl2 = n2 >= n3;
        if (bl3 || bl2) {
            printWriter.println(string3);
        } else {
            printWriter.print(string3);
        }
    }

    private static void printArray(PrintWriter printWriter, int n, boolean bl, String[][] stringArray) {
        int n2;
        String[] stringArray2 = stringArray[0];
        for (int i = n2 = n == 3 ? 0 : 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            for (int j = 1; j <= stringArray3.length; ++j) {
                TeraDriver.printValue(printWriter, n, bl, j, stringArray3.length, stringArray2[j - 1], stringArray3[j - 1]);
            }
        }
    }

    private static void printNameValue(PrintWriter printWriter, int n, String string, String string2) {
        TeraDriver.printArray(printWriter, n, false, new String[][]{{string}, {string2}});
    }

    private static void printProps(PrintWriter printWriter, int n, Properties properties) {
        Map.Entry[] entryArray = properties == null ? new Map.Entry[]{} : properties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                Comparable comparable = (Comparable)entry.getKey();
                Comparable comparable2 = (Comparable)entry2.getKey();
                return comparable.compareTo(comparable2);
            }
        });
        String[][] stringArray = new String[][]{new String[entryArray.length], new String[entryArray.length]};
        for (int i = 0; i < entryArray.length; ++i) {
            stringArray[0][i] = (String)entryArray[i].getKey();
            stringArray[1][i] = (String)entryArray[i].getValue();
        }
        if (n == 1) {
            printWriter.println("(Properties " + (properties == null ? "null" : "" + entryArray.length) + ")");
        }
        TeraDriver.printArray(printWriter, n, true, stringArray);
    }

    private static String formatCsvHeader(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        return resultSetMetaData.getColumnName(n) + (bl ? " " + resultSetMetaData.getColumnTypeName(n) + (resultSetMetaData.getColumnType(n) == -2 ? "(" + resultSetMetaData.getPrecision(n) + ")" : "") + (resultSetMetaData.getColumnType(n) == 3 ? "(" + resultSetMetaData.getPrecision(n) + (resultSetMetaData.getScale(n) != 0 ? "," + resultSetMetaData.getScale(n) : "") + ")" : "") : "");
    }

    private static String formatAsHexDigits(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string + (string2.length() < 2 ? "0" : "") + string2;
        }
        return string;
    }

    private static byte[] parseHexDigits(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = (string.length() & 1) == 1;
        if (bl) {
            throw new IllegalArgumentException("Odd number of hex digits: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private static void printResultSet(PrintWriter printWriter, int n, boolean bl, String string, ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (n == 3) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), null, TeraDriver.formatCsvHeader(resultSetMetaData, n2, bl));
            }
        }
        while (resultSet.next()) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                Comparable<Calendar> comparable;
                String string2 = (string != null ? string + " " : "") + "Row " + resultSet.getRow() + " Column " + n2 + " " + TeraDriver.quoteText(resultSetMetaData.getColumnName(n2)) + " " + resultSetMetaData.getColumnTypeName(n2) + "(" + resultSetMetaData.getPrecision(n2) + ")";
                String string3 = resultSetMetaData.getColumnType(n2) == 2004 || resultSetMetaData.getColumnType(n2) == -2 || resultSetMetaData.getColumnType(n2) == -3 || resultSetMetaData.getColumnType(n2) == -4 ? TeraDriver.formatAsHexDigits(resultSet.getBytes(n2)) : (resultSetMetaData.getColumnType(n2) == 92 ? ((comparable = resultSet.getTimestamp(n2)) == null ? null : ((Timestamp)comparable).toString().substring("1970-01-01 ".length())) : resultSet.getString(n2));
                if (string3 != null && resultSetMetaData.getColumnTypeName(n2).endsWith(" WITH TIME ZONE")) {
                    comparable = Calendar.getInstance();
                    resultSet.getTimestamp(n2, (Calendar)comparable);
                    string3 = string3 + TDPreparedStatement.formatTimeZone(((Calendar)comparable).getTimeZone());
                }
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), string2, string3);
            }
        }
    }

    private static void printUpdateCounts(PrintWriter printWriter, int n, int[] nArray) {
        if (n == 3) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, null, "Update Counts");
        }
        for (int i = 0; i < nArray.length; ++i) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, "Update count " + (i + 1), "" + nArray[i]);
        }
    }

    private static CsvHeader[] parseCsvHeaders(String[] stringArray) {
        CsvHeader[] csvHeaderArray = new CsvHeader[stringArray.length];
        block0: for (int i = 0; i < csvHeaderArray.length; ++i) {
            CsvHeader csvHeader;
            csvHeaderArray[i] = csvHeader = new CsvHeader();
            csvHeader.sHeader = stringArray[i];
            csvHeader.nType = 1111;
            if (csvHeader.sHeader == null) continue;
            for (int j = 0; j < TypeDesc.types.length; ++j) {
                Matcher matcher = Pattern.compile("(?i).* " + TypeDesc.types[j].sTypeName + "(?:\\(([0-9]+)(?:,([0-9]+))?\\))?").matcher(csvHeader.sHeader);
                if (!matcher.matches()) continue;
                csvHeader.sTypeName = TypeDesc.types[j].sTypeName;
                csvHeader.nType = TypeDesc.types[j].nType;
                csvHeader.bTimeZone = csvHeader.sTypeName.endsWith(" WITH TIME ZONE");
                if (matcher.group(2) != null) {
                    csvHeader.nScale = Integer.parseInt(matcher.group(2));
                    continue block0;
                }
                if (matcher.group(1) == null) continue block0;
                csvHeader.nScale = Integer.parseInt(matcher.group(1));
                continue block0;
            }
        }
        return csvHeaderArray;
    }

    private static String[] readCsvRow(PeekReader peekReader) throws IOException {
        if (peekReader.peek() < 0) {
            return null;
        }
        StringList stringList = new StringList();
        stringList.add(null);
        boolean bl = false;
        int n;
        while ((n = peekReader.read()) >= 0) {
            if (bl) {
                if (n != 34) {
                    stringList.append(n);
                    continue;
                }
                if (peekReader.peek() == 34) {
                    stringList.append(peekReader.read());
                    continue;
                }
                bl = false;
                continue;
            }
            if (n == 44) {
                stringList.add(null);
                continue;
            }
            if (n == 34) {
                bl = true;
                continue;
            }
            if (n == 13) continue;
            if (n == 10) {
                return stringList.toStringArray();
            }
            stringList.append(n);
        }
        return stringList.toStringArray();
    }

    private static void bindValue(PreparedStatement preparedStatement, int n, int n2, CsvHeader csvHeader, String string) {
        try {
            if (csvHeader.nType == -6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setByte(n2, Byte.parseByte(string));
                }
            } else if (csvHeader.nType == 5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setShort(n2, Short.parseShort(string));
                }
            } else if (csvHeader.nType == 4) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setInt(n2, Integer.parseInt(string));
                }
            } else if (csvHeader.nType == -5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setLong(n2, Long.parseLong(string));
                }
            } else if (csvHeader.nType == 6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setDouble(n2, Double.parseDouble(string));
                }
            } else if (csvHeader.nType == 3) {
                preparedStatement.setObject(n2, (Object)(string == null ? null : new BigDecimal(string)), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == 2) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                }
            } else if (csvHeader.nType == 2005) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setCharacterStream(n2, (Reader)new StringReader(string), string.length());
                }
            } else if (csvHeader.nType == 2004) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    byte[] byArray = TeraDriver.parseHexDigits(string);
                    preparedStatement.setBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                }
            } else if (csvHeader.nType == -2) {
                preparedStatement.setObject(n2, (Object)TeraDriver.parseHexDigits(string), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == -3 || csvHeader.nType == -4) {
                preparedStatement.setBytes(n2, TeraDriver.parseHexDigits(string));
            } else if (csvHeader.nType == 91) {
                preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
            } else if (csvHeader.nType == 92) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTime(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else if (csvHeader.nType == 93) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTimestamp(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else {
                preparedStatement.setString(n2, string);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error for CSV line " + n + " column " + n2 + " value: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws IOException, SQLException {
        if (var0.length == 0) {
            System.err.println("Arguments: Command...");
            System.err.println("-i turns on interactive mode to prompt for commands from System.in");
            System.err.println("prompt:message sets the prompt to the specified message");
            System.err.println("exit stops reading commands from the current input source");
            System.err.println("# begins a comment");
            System.err.println("version prints the Teradata JDBC Driver version");
            System.err.println("echo:message prints the specified message");
            System.err.println("pause waits for a line from System.in");
            System.err.println("prop:name=value sets the property name to value for DriverManager.getConnection");
            System.err.println("props:null specifies null Properties for DriverManager.getConnection (the default)");
            System.err.println("props:new specifies new empty Properties for DriverManager.getConnection");
            System.err.println("props:list prints the Properties for DriverManager.getConnection");
            System.err.println("props:filename reads Properties from the specified file for DriverManager.getConnection");
            System.err.println("verbose:connection (the default) and verbose:-connection controls printing connection status");
            System.err.println("jdbc: prefix calls DriverManager.getConnection for the command");
            System.err.println("input:stdin reads commands from System.in until EOF (interactive Ctrl+Z on Windows)");
            System.err.println("input:filename reads commands from the specified file until EOF");
            System.err.println("output:stdout sends output to System.out (the default)");
            System.err.println("output:filename sends output to specified file");
            System.err.println("format:text formats output as text (the default)");
            System.err.println("format:raw avoids formatting output");
            System.err.println("format:csv formats output as comma-separated values");
            System.err.println("ignore:all ignores all SQLException");
            System.err.println("ignore:none stops for SQLException (the default)");
            System.err.println("ignore:code,code,... ignores SQLException with one of the specified error codes");
            System.err.println("System.setProperty:name=value sets the System property name to value");
            System.err.println("System.getProperty:name prints the specified System property");
            System.err.println("System.getProperties prints the Properties from System.getProperties");
            System.err.println("Security.setProperty:name=value sets the Security property name to value");
            System.err.println("Security.getProperty:name prints the specified Security property");
            System.err.println("getColumns:schemaPattern,tableNamePattern,columnNamePattern prints the result from DatabaseMetaData.getColumns");
            System.err.println("getDatabaseProductVersion prints the return value from DatabaseMetaData.getDatabaseProductVersion");
            System.err.println("getDriverVersion prints the return value from DatabaseMetaData.getDriverVersion");
            System.err.println("getURL prints the return value from DatabaseMetaData.getURL");
            System.err.println("nativeSQL:command calls Connection.nativeSQL for the command");
            System.err.println("csvline:string appends comma-separated values from the specified string for use by a subsequent parameterized SQL request");
            System.err.println("readcsv:filename reads comma-separated values from the specified UTF8-encoded file for use by a subsequent parameterized SQL request");
            System.err.println("verbose:sql and verbose:-sql (the default) controls printing the SQL request before executing");
            System.err.println("verbose:csvtypes and verbose:-csvtypes (the default) controls printing data types in CSV header");
            System.err.println("verbose:updatecounts and verbose:-updatecounts (the default) controls printing update counts after executing");
            System.err.println("verbose:stack and verbose:-stack (the default) controls printing SQLException stack traces");
            System.err.println("agkr:none (the default) does not use the Auto-Generated Key Retrieval feature");
            System.err.println("agkr:generated returns generated keys");
            System.err.println("agkr:index,index,... returns the inserted column values corresponding to the specific column indexes");
            System.err.println("Otherwise the SQL request is executed, using parameter values if previously specified");
            return;
        }
        var1_1 = 1;
        var2_2 = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        var3_3 = null;
        try {
            block138: {
                var5_5 = var4_4 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
                try {
                    var6_6 = null;
                    try {
                        var7_7 = null;
                        var8_8 = null;
                        var9_9 = null;
                        var10_10 = null;
                        var11_11 = new Integer(2);
                        var12_12 = true;
                        var13_13 = false;
                        var14_14 = false;
                        var15_15 = false;
                        var16_16 = false;
                        var17_17 = 0;
                        while (true) lbl-1000:
                        // 62 sources

                        {
                            var18_18 = "";
                            if (var3_3 != null) {
                                if (var3_3 == var2_2 && var8_8 != null) {
                                    var5_5.print(var8_8);
                                    var5_5.flush();
                                }
                                if ((var18_18 = var3_3.readLine()) == null) {
                                    if (var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = null;
                                }
                            }
                            if (var3_3 == null) {
                                if (var17_17 >= var0.length) break block138;
                                var18_18 = var0[var17_17++];
                            }
                            try {
                                if (var18_18.equals("-i")) {
                                    if (var3_3 != null && var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = var2_2;
                                    var8_8 = ">>> ";
                                }
                                if (var18_18.startsWith("prompt:")) {
                                    var8_8 = var18_18.substring("prompt:".length());
                                }
                                if (var18_18.equals("exit")) {
                                    if (var3_3 != null && var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = null;
                                }
                                if (var18_18.startsWith("#")) ** GOTO lbl-1000
                                if (var18_18.equals("version")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var18_18, Const.DRIVER_VERSION);
                                }
                                if (var18_18.startsWith("echo:")) {
                                    var19_19 = var18_18.substring("echo:".length());
                                    var5_5.println((String)var19_19);
                                }
                                if (var18_18.equals("pause")) {
                                    var5_5.println("Paused. Press Enter to continue:");
                                    var2_2.readLine();
                                }
                                if (var18_18.startsWith("prop:")) {
                                    var19_19 = Pattern.compile("prop:([^=]+)=(.*)").matcher(var18_18);
                                    if (!var19_19.matches()) {
                                        throw new IllegalArgumentException(var18_18);
                                    }
                                    if (var9_9 == null) {
                                        var9_9 = new Properties();
                                    }
                                    var9_9.setProperty(var19_19.group(1), var19_19.group(2));
                                }
                                if (var18_18.startsWith("props:")) {
                                    var19_19 = var18_18.substring("props:".length());
                                    if (var19_19.equals("null")) {
                                        var9_9 = null;
                                    }
                                    if (var19_19.equals("new")) {
                                        var9_9 = new Properties();
                                    }
                                    if (var19_19.equals("list")) {
                                        TeraDriver.printProps(var5_5, var1_1, var9_9);
                                    }
                                    var9_9 = new Properties();
                                    var20_21 = new FileInputStream((String)var19_19);
                                    try {
                                        var9_9.load(var20_21);
                                    }
                                    finally {
                                        var20_21.close();
                                    }
                                }
                                if (var18_18.equals("verbose:connection")) {
                                    var12_12 = true;
                                }
                                if (var18_18.equals("verbose:-connection")) {
                                    var12_12 = false;
                                }
                                if (var18_18.startsWith("jdbc:")) {
                                    if (var6_6 != null) {
                                        var19_19 = var6_6;
                                        var6_6 = null;
                                        var19_19.close();
                                    }
                                    var6_6 = DriverManager.getConnection(var18_18, var9_9);
                                    if (!var12_12) ** GOTO lbl-1000
                                    TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"Status", "Remote", "Version", "Session"}, {var6_6.isClosed() != false ? "Closed" : "Connected", var6_6.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), var6_6.getMetaData().getDatabaseProductVersion(), var6_6.isClosed() != false ? null : var6_6.nativeSQL("{fn teradata_session_number}")}});
                                }
                                if (var18_18.startsWith("input:")) {
                                    var19_19 = var18_18.substring("input:".length());
                                    if (var3_3 != null && var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = null;
                                    if (var19_19.equals("stdin")) {
                                        var3_3 = var2_2;
                                    }
                                    var3_3 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)var19_19), "UTF-8"));
                                }
                                if (var18_18.startsWith("output:")) {
                                    var19_19 = var18_18.substring("output:".length());
                                    if (var5_5 != var4_4) {
                                        var5_5.close();
                                    }
                                    var5_5 = var4_4;
                                    if (var19_19.equals("stdout")) ** GOTO lbl-1000
                                    var5_5 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((String)var19_19), "UTF-8"), true);
                                }
                                if (var18_18.startsWith("format:")) {
                                    var19_19 = var18_18.substring("format:".length());
                                    if (var19_19.equals("text")) {
                                        var1_1 = 1;
                                    }
                                    if (var19_19.equals("raw")) {
                                        var1_1 = 2;
                                    }
                                    if (var19_19.equals("csv")) {
                                        var1_1 = 3;
                                    }
                                    throw new IllegalArgumentException("Unknown format " + (String)var19_19);
                                }
                                if (var18_18.equals("ignore:all")) {
                                    var10_10 = new int[]{};
                                }
                                if (var18_18.equals("ignore:none")) {
                                    var10_10 = null;
                                }
                                if (var18_18.startsWith("ignore:")) {
                                    var19_19 = var18_18.substring("ignore:".length());
                                    var20_22 = var19_19.split(",");
                                    if (var20_22.length == 0) {
                                        throw new IllegalArgumentException(var18_18);
                                    }
                                    var10_10 = new int[var20_22.length];
                                    var21_32 = 0;
                                    while (true) {
                                        if (var21_32 >= var20_22.length) ** GOTO lbl-1000
                                        var10_10[var21_32] = Integer.parseInt(var20_22[var21_32]);
                                        ++var21_32;
                                    }
                                }
                                if (var18_18.startsWith("System.setProperty:")) {
                                    var19_19 = Pattern.compile("System\\.setProperty:([^=]+)=(.*)").matcher(var18_18);
                                    if (!var19_19.matches()) {
                                        throw new IllegalArgumentException(var18_18);
                                    }
                                    System.setProperty(var19_19.group(1), var19_19.group(2));
                                }
                                if (var18_18.startsWith("System.getProperty:")) {
                                    var19_19 = var18_18.substring("System.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var19_19, System.getProperty((String)var19_19));
                                }
                                if (var18_18.equals("System.getProperties")) {
                                    TeraDriver.printProps(var5_5, var1_1, System.getProperties());
                                }
                                if (var18_18.startsWith("Security.setProperty:")) {
                                    var19_19 = Pattern.compile("Security\\.setProperty:([^=]+)=(.*)").matcher(var18_18);
                                    if (!var19_19.matches()) {
                                        throw new IllegalArgumentException(var18_18);
                                    }
                                    Security.setProperty(var19_19.group(1), var19_19.group(2));
                                }
                                if (var18_18.startsWith("Security.getProperty:")) {
                                    var19_19 = var18_18.substring("Security.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var19_19, Security.getProperty((String)var19_19));
                                }
                                if (var6_6 == null) {
                                    throw new IllegalArgumentException("No connection available for " + var18_18);
                                }
                                if (var18_18.startsWith("getColumns:")) {
                                    var19_19 = var18_18.substring("getColumns:".length()).split(",", -1);
                                    if (((String[])var19_19).length != 3) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var18_18);
                                    }
                                    for (var20_23 = 0; var20_23 < ((String[])var19_19).length; ++var20_23) {
                                        if (!"null".equals(var19_19[var20_23])) continue;
                                        var19_19[var20_23] = null;
                                    }
                                    var20_24 = var6_6.getMetaData().getColumns(null, var19_19[0], var19_19[1], var19_19[2]);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var14_14, "getColumns", var20_24);
                                    }
                                    finally {
                                        var20_24.close();
                                    }
                                }
                                if (var18_18.equals("getDatabaseProductVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var18_18, var6_6.getMetaData().getDatabaseProductVersion());
                                }
                                if (var18_18.equals("getDriverVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var18_18, var6_6.getMetaData().getDriverVersion());
                                }
                                if (var18_18.equals("getURL")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var18_18, var6_6.getMetaData().getURL());
                                }
                                if (var18_18.startsWith("nativeSQL:")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "nativeSQL", var6_6.nativeSQL(var18_18.substring("nativeSQL:".length())));
                                }
                                if (var18_18.startsWith("csvline:")) {
                                    var19_19 = var18_18.substring("csvline:".length()) + "\n";
                                    var20_25 = new ByteArrayInputStream(var19_19.getBytes("UTF-8"));
                                    var7_7 = var7_7 == null ? var20_25 : new SequenceInputStream(var7_7, var20_25);
                                }
                                if (var18_18.startsWith("readcsv:")) {
                                    var19_19 = var18_18.substring("readcsv:".length());
                                    var20_26 = new FileInputStream((String)var19_19);
                                    var7_7 = var7_7 == null ? var20_26 : new SequenceInputStream(var7_7, var20_26);
                                }
                                if (var18_18.equals("verbose:sql")) {
                                    var13_13 = true;
                                }
                                if (var18_18.equals("verbose:-sql")) {
                                    var13_13 = false;
                                }
                                if (var18_18.equals("verbose:csvtypes")) {
                                    var14_14 = true;
                                }
                                if (var18_18.equals("verbose:-csvtypes")) {
                                    var14_14 = false;
                                }
                                if (var18_18.equals("verbose:updatecounts")) {
                                    var15_15 = true;
                                }
                                if (var18_18.equals("verbose:-updatecounts")) {
                                    var15_15 = false;
                                }
                                if (var18_18.equals("verbose:stack")) {
                                    var16_16 = true;
                                }
                                if (var18_18.equals("verbose:-stack")) {
                                    var16_16 = false;
                                }
                                if (var18_18.equals("agkr:none")) {
                                    var11_11 = new Integer(2);
                                }
                                if (var18_18.equals("agkr:generated")) {
                                    var11_11 = new Integer(1);
                                }
                                if (var18_18.startsWith("agkr:")) {
                                    var19_19 = var18_18.substring("agkr:".length());
                                    var20_27 = var19_19.split(",");
                                    if (var20_27.length == 0) {
                                        throw new IllegalArgumentException(var18_18);
                                    }
                                    var21_33 = new int[var20_27.length];
                                    var11_11 = var21_33;
                                    var22_38 = 0;
                                    while (true) {
                                        if (var22_38 >= var20_27.length) ** GOTO lbl-1000
                                        var21_33[var22_38] = Integer.parseInt(var20_27[var22_38]);
                                        ++var22_38;
                                    }
                                }
                                if (var7_7 != null) {
                                    try {
                                        var19_19 = new PeekReader(new InputStreamReader(var7_7, "UTF-8"));
                                        try {
                                            var20_28 = TeraDriver.readCsvRow((PeekReader)var19_19);
                                            if (var20_28 == null) {
                                                throw new IllegalArgumentException("CSV header line is missing and no CSV data lines are available");
                                            }
                                            var21_34 = TeraDriver.parseCsvHeaders(var20_28);
                                            if (var13_13) {
                                                var5_5.println(var18_18);
                                            }
                                            var22_39 = var11_11 instanceof int[] != false ? var6_6.prepareStatement(var18_18, (int[])var11_11) : var6_6.prepareStatement(var18_18, (Integer)var11_11);
                                            try {
                                                var23_42 = 0;
                                                while (true) {
                                                    if ((var24_45 = TeraDriver.readCsvRow((PeekReader)var19_19)) == null && var23_42 >= 2 || var24_45 != null && var23_42 >= 1) {
                                                        var22_39.addBatch();
                                                    }
                                                    if (var24_45 == null) break;
                                                    if (var24_45.length != var21_34.length) {
                                                        throw new IllegalArgumentException("CSV data line " + var19_19.lineNumber + " contains " + var24_45.length + " values instead of the expected " + var21_34.length + " values");
                                                    }
                                                    for (var25_48 = 0; var25_48 < var24_45.length; ++var25_48) {
                                                        TeraDriver.bindValue(var22_39, var19_19.lineNumber, var25_48 + 1, var21_34[var25_48], var24_45[var25_48]);
                                                    }
                                                    ++var23_42;
                                                }
                                                var24_44 = false;
                                                if (var23_42 >= 2) {
                                                    var25_49 = var22_39.executeBatch();
                                                    if (var15_15) {
                                                        TeraDriver.printUpdateCounts(var5_5, var1_1, var25_49);
                                                    }
                                                } else {
                                                    var24_44 = var22_39.execute();
                                                    if (!var24_44 && var15_15) {
                                                        TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var22_39.getUpdateCount());
                                                    }
                                                }
                                                if (var24_44) {
                                                    var25_47 = var22_39.getResultSet();
                                                    try {
                                                        TeraDriver.printResultSet(var5_5, var1_1, var14_14, null, var25_47);
                                                    }
                                                    finally {
                                                        var25_47.close();
                                                    }
                                                }
                                                var25_47 = var22_39.getGeneratedKeys();
                                                try {
                                                    TeraDriver.printResultSet(var5_5, var1_1, var14_14, var11_11 instanceof int[] != false ? "Inserted" : "Generated", var25_47);
                                                }
                                                finally {
                                                    var25_47.close();
                                                }
                                            }
                                            finally {
                                                var22_39.close();
                                            }
                                        }
                                        finally {
                                            var19_19.close();
                                        }
                                    }
                                    finally {
                                        var7_7 = null;
                                    }
                                }
                                var19_19 = var6_6.createStatement();
                                try {
                                    if (var13_13) {
                                        var5_5.println(var18_18);
                                    }
                                    var20_29 = var11_11 instanceof int[] != false ? var19_19.execute(var18_18, (int[])var11_11) : var19_19.execute(var18_18, var11_11.intValue());
                                    while (true) {
                                        if (!var20_29 && var19_19.getUpdateCount() == -1) ** GOTO lbl-1000
                                        if (var20_29) {
                                            var21_35 = var19_19.getResultSet();
                                            try {
                                                TeraDriver.printResultSet(var5_5, var1_1, var14_14, null, var21_35);
                                            }
                                            finally {
                                                var21_35.close();
                                            }
                                        }
                                        if (var15_15) {
                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var19_19.getUpdateCount());
                                        }
                                        var21_35 = var19_19.getGeneratedKeys();
                                        try {
                                            TeraDriver.printResultSet(var5_5, var1_1, var14_14, var11_11 instanceof int[] != false ? "Inserted" : "Generated", var21_35);
                                        }
                                        finally {
                                            var21_35.close();
                                        }
                                        var20_29 = var19_19.getMoreResults();
                                    }
                                }
                                finally {
                                    var19_19.close();
                                }
                            }
                            catch (SQLException var19_20) {
                                var20_30 = var10_10 != null && var10_10.length == 0;
                                for (var21_36 = 0; !var20_30 && var10_10 != null && var21_36 < var10_10.length; ++var21_36) {
                                    if (var19_20.getErrorCode() != var10_10[var21_36]) continue;
                                    var20_30 = true;
                                }
                                if (var20_30) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Ignoring", "" + var19_20);
                                    continue;
                                }
                                var21_36 = 0;
                                for (var22_40 = var19_20; var22_40 != null; var22_40 = var22_40.getNextException()) {
                                    ++var21_36;
                                }
                                var22_41 = 1;
                                for (var23_43 = var19_20; var23_43 != null; var23_43 = var23_43.getNextException()) {
                                    var24_46 = new StringWriter();
                                    var23_43.printStackTrace(new PrintWriter((Writer)var24_46, true));
                                    var5_5.println("SQLException " + var22_41 + " of " + var21_36 + ": " + (var16_16 != false ? "" + var24_46 : "" + var23_43));
                                    ++var22_41;
                                }
                                throw var19_20;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                        finally {
                            if (var7_7 != null) {
                                var7_7.close();
                            }
                        }
                    }
                    finally {
                        if (var6_6 != null) {
                            var6_6.close();
                        }
                    }
                }
                finally {
                    if (var5_5 != var4_4) {
                        var5_5.close();
                    }
                }
            }
            var38_61 = null;
            ** if (var3_3 == null || var3_3 == var2_2) goto lbl-1000
        }
        catch (Throwable var37_63) {
            var38_62 = null;
            if (var3_3 != null && var3_3 != var2_2) {
                var3_3.close();
            }
            throw var37_63;
        }
lbl-1000:
        // 1 sources

        {
            var3_3.close();
        }
lbl-1000:
        // 2 sources

        {
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
        DUMMY_CALENDAR = Calendar.getInstance();
    }

    private static class StringList
    extends ArrayList {
        public String[] toStringArray() {
            return this.toArray(new String[0]);
        }

        public void append(int n) {
            int n2 = this.size() - 1;
            String string = (String)this.get(n2);
            if (string == null) {
                string = "";
            }
            this.set(n2, string + (char)n);
        }
    }

    private static class PeekReader
    extends PushbackReader {
        public int lineNumber = 0;

        public PeekReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            int n = super.read();
            if (n == 10) {
                ++this.lineNumber;
            }
            return n;
        }

        public int peek() throws IOException {
            int n = super.read();
            if (n >= 0) {
                this.unread(n);
            }
            return n;
        }
    }

    private static class CsvHeader {
        public String sHeader;
        public int nType;
        public String sTypeName;
        public boolean bTimeZone;
        public int nScale;

        private CsvHeader() {
        }
    }

    private static class TypeDesc {
        public String sTypeName;
        public int nType;
        public static TypeDesc[] types = new TypeDesc[]{new TypeDesc("BYTEINT", -6), new TypeDesc("SMALLINT", 5), new TypeDesc("INTEGER", 4), new TypeDesc("BIGINT", -5), new TypeDesc("FLOAT", 6), new TypeDesc("DECIMAL", 3), new TypeDesc("NUMBER", 2), new TypeDesc("CLOB", 2005), new TypeDesc("CHAR", 1), new TypeDesc("VARCHAR", 12), new TypeDesc("LONGVARCHAR", -1), new TypeDesc("BLOB", 2004), new TypeDesc("BYTE", -2), new TypeDesc("VARBYTE", -3), new TypeDesc("LONGVARBYTE", -4), new TypeDesc("DATE", 91), new TypeDesc("TIME", 92), new TypeDesc("TIME WITH TIME ZONE", 92), new TypeDesc("TIMESTAMP", 93), new TypeDesc("TIMESTAMP WITH TIME ZONE", 93)};

        private TypeDesc(String string, int n) {
            this.sTypeName = string;
            this.nType = n;
        }
    }
}

