/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemAmbiguous;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemArray;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemBigInt;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemByte;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemByteInt;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemChar;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemDecimal;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemFloat;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemInteger;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemLob;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemNumber;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemSmallInt;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemStruct;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemVarByte;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemVarChar;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;
import java.util.ArrayList;

public class PrepInfoParcel
extends Parcel {
    private short columnCount;
    private short summaryCount;
    protected PrepInfoItem[] items;
    private double costEstimate;

    protected PrepInfoParcel(GenericTeradataConnection genericTeradataConnection) {
        super(genericTeradataConnection);
    }

    public PrepInfoParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.initResponseParcel(tDPacketStream);
        if (PrepInfoParcel.trueFlavor(this.flavor) != 86 && PrepInfoParcel.trueFlavor(this.flavor) != 125) {
            return;
        }
        int n = 0;
        this.costEstimate = tDPacketStream.getDouble();
        this.summaryCount = tDPacketStream.getShort();
        this.columnCount = tDPacketStream.getShort();
        this.items = new PrepInfoItem[this.summaryCount + this.columnCount];
        PrepInfoItem prepInfoItem = null;
        int n2 = 0;
        for (int i = 0; i < this.items.length; ++i) {
            boolean bl;
            short s = tDPacketStream.getShort();
            boolean bl2 = bl = JDBC4Constants.getTDTypeParameterMode(s) == 1;
            if (!bl) {
                prepInfoItem = PrepInfoParcel.createPrepInfoItem(this.m_con, this.log, s, this.decimalShift());
                long l = this.getDataLen(tDPacketStream);
                prepInfoItem.setDataLen(l);
                prepInfoItem.setColumnServerCharSet(this.getColumnServerCharSet(tDPacketStream));
                prepInfoItem.setColumnExtInfo(this.getExtTypeInfo(tDPacketStream));
                short s2 = tDPacketStream.getShort();
                prepInfoItem.setColumnName(tDPacketStream.getString(s2, genericTeradataConnection));
                s2 = tDPacketStream.getShort();
                prepInfoItem.setColumnFormat(tDPacketStream.getString(s2, genericTeradataConnection));
                s2 = tDPacketStream.getShort();
                prepInfoItem.setColumnTitle(tDPacketStream.getString(s2, genericTeradataConnection));
                if ((prepInfoItem.getColumnName() == null || prepInfoItem.getColumnName().compareTo("") == 0) && prepInfoItem.getColumnTitle() != null) {
                    prepInfoItem.setColumnName(prepInfoItem.getColumnTitle());
                }
                this.items[n2++] = prepInfoItem;
                continue;
            }
            ++n;
            this.getDataLen(tDPacketStream);
            this.getColumnServerCharSet(tDPacketStream);
            this.getExtTypeInfo(tDPacketStream);
            short s3 = tDPacketStream.getShort();
            tDPacketStream.position(tDPacketStream.position() + s3);
            s3 = tDPacketStream.getShort();
            tDPacketStream.position(tDPacketStream.position() + s3);
            s3 = tDPacketStream.getShort();
            tDPacketStream.position(tDPacketStream.position() + s3);
        }
        this.columnCount = (short)(this.columnCount - n);
    }

    public static PrepInfoItem createPrepInfoItem(GenericTeradataConnection genericTeradataConnection, Log log, short s, int n) throws SQLException {
        switch (JDBC4Constants.getTDBasicType(s)) {
            case 504: 
            case 508: {
                return new PrepInfoItemArray(genericTeradataConnection, s);
            }
            case 600: {
                return new PrepInfoItemBigInt(genericTeradataConnection, s);
            }
            case 400: 
            case 404: 
            case 408: {
                return new PrepInfoItemLob(genericTeradataConnection, s);
            }
            case 692: {
                return new PrepInfoItemByte(genericTeradataConnection, s);
            }
            case 756: {
                return new PrepInfoItemByteInt(genericTeradataConnection, s);
            }
            case 452: 
            case 468: {
                return new PrepInfoItemChar(genericTeradataConnection, s);
            }
            case 416: 
            case 420: 
            case 424: {
                return new PrepInfoItemLob(genericTeradataConnection, s);
            }
            case 748: {
                return new PrepInfoItemChar(genericTeradataConnection, s);
            }
            case 752: {
                return new PrepInfoItemInteger(genericTeradataConnection, s);
            }
            case 484: {
                return new PrepInfoItemDecimal(genericTeradataConnection, s, n);
            }
            case 480: {
                return new PrepInfoItemFloat(genericTeradataConnection, s);
            }
            case 496: {
                return new PrepInfoItemInteger(genericTeradataConnection, s);
            }
            case 776: 
            case 780: 
            case 784: 
            case 788: 
            case 792: 
            case 796: 
            case 800: 
            case 804: 
            case 808: 
            case 812: 
            case 816: 
            case 820: 
            case 824: {
                return new PrepInfoItemChar(genericTeradataConnection, s);
            }
            case 884: {
                return new PrepInfoItemLob(genericTeradataConnection, s);
            }
            case 604: {
                return new PrepInfoItemNumber(genericTeradataConnection, s);
            }
            case 500: {
                return new PrepInfoItemSmallInt(genericTeradataConnection, s);
            }
            case 440: {
                return new PrepInfoItemStruct(genericTeradataConnection, s);
            }
            case 760: 
            case 764: 
            case 768: 
            case 772: {
                return new PrepInfoItemChar(genericTeradataConnection, s);
            }
            case 688: 
            case 696: {
                return new PrepInfoItemVarByte(genericTeradataConnection, s);
            }
            case 448: 
            case 456: 
            case 464: 
            case 472: {
                return new PrepInfoItemVarChar(genericTeradataConnection, s);
            }
            case 852: 
            case 856: 
            case 860: 
            case 864: 
            case 868: 
            case 872: {
                return new PrepInfoItemLob(genericTeradataConnection, s);
            }
            case 0: {
                return new PrepInfoItemAmbiguous(genericTeradataConnection, s);
            }
        }
        log.error("Unrecognized data type code: " + s);
        throw ErrorFactory.makeDriverJDBCException("TJ306", Integer.toString(s));
    }

    public void updateItems(PrepInfoItem[] prepInfoItemArray) {
        int n = 0;
        for (int i = 0; i < prepInfoItemArray.length && n < this.items.length; ++n, ++i) {
            this.items[n].setDataType(prepInfoItemArray[i].getDataType());
            this.items[n].setDataLen(prepInfoItemArray[i].getLongDataLen());
            if (JDBC4Constants.getTDBasicType(this.items[n].getDataType()) != 504) continue;
            ++i;
            i = this.updateArrayItem(this.items[n].getArrayBasePrepInfoItems(), prepInfoItemArray, i);
        }
    }

    private int updateArrayItem(ArrayList arrayList, PrepInfoItem[] prepInfoItemArray, int n) {
        for (int i = 0; i < arrayList.size() && n < prepInfoItemArray.length; ++n, ++i) {
            PrepInfoItem prepInfoItem = (PrepInfoItem)arrayList.get(i);
            prepInfoItem.setDataType(prepInfoItemArray[n].getDataType());
            prepInfoItem.setDataLen(prepInfoItemArray[n].getLongDataLen());
        }
        return n - 1;
    }

    public long getDataLen(TDPacketStream tDPacketStream) throws SQLException {
        short s = tDPacketStream.getShort();
        int n = UnsignedConversions.convertUnsignedShort(s);
        return new Long(n);
    }

    public byte getExtTypeInfo(TDPacketStream tDPacketStream) throws SQLException {
        return -1;
    }

    public byte getColumnServerCharSet(TDPacketStream tDPacketStream) throws SQLException {
        return -1;
    }

    public PrepInfoItemIterator getPrepInfoItemIterator() {
        return new PrepInfoItemIterator();
    }

    protected int decimalShift() {
        return 8;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PrepInfoParcel **************************\n");
        stringBuffer.append("ColumnCount: " + this.columnCount + '\n');
        stringBuffer.append("SummaryCount: " + this.summaryCount + '\n');
        stringBuffer.append(this.formatPrepInfoItems());
        stringBuffer.append("PrepInfoParcel END **********************\n");
        return stringBuffer.toString();
    }

    protected String formatPrepInfoItems() {
        StringBuffer stringBuffer = new StringBuffer();
        PrepInfoItemIterator prepInfoItemIterator = this.getPrepInfoItemIterator();
        while (prepInfoItemIterator.hasNext()) {
            PrepInfoItem prepInfoItem = prepInfoItemIterator.next();
            stringBuffer.append("***** PrepInfoItem ****\n");
            if (prepInfoItem == null) continue;
            stringBuffer.append("DataType: " + prepInfoItem.getDataType() + '\n');
            stringBuffer.append("DataLen: " + prepInfoItem.getDataLen() + '\n');
            stringBuffer.append("ColumnName: " + prepInfoItem.getColumnName() + '\n');
            stringBuffer.append("ColumnTitle: " + prepInfoItem.getColumnTitle() + '\n');
            stringBuffer.append("ColumnFormat: " + prepInfoItem.getColumnFormat() + '\n');
        }
        return stringBuffer.toString();
    }

    public ArrayList getParameterMarkerMetadataItems() {
        return null;
    }

    public ArrayList getAGKColumnMetadataItems() {
        return null;
    }

    public class PrepInfoItemIterator {
        private int index = 0;

        public int count() {
            return PrepInfoParcel.this.items != null ? PrepInfoParcel.this.items.length : 0;
        }

        public boolean hasNext() {
            return PrepInfoParcel.this.items != null ? this.index < PrepInfoParcel.this.items.length : false;
        }

        public PrepInfoItem next() {
            return this.hasNext() ? PrepInfoParcel.this.items[this.index++] : null;
        }
    }
}

