/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.GeneratedKeysRequest;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveDataInfoSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class ReceivePrepInfoSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private PrepInfoParcel currentEvent;
    protected Log log;

    public ReceivePrepInfoSubState(StatementReceiveState statementReceiveState, PrepInfoParcel prepInfoParcel) {
        this.compositeState = statementReceiveState;
        this.currentEvent = prepInfoParcel;
        this.log = this.compositeState.getController().getSession().getLog();
    }

    @Override
    public TDParcelState action() throws SQLException {
        Object object;
        PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator;
        TDParcelState tDParcelState = null;
        TeraResultSetMetaData teraResultSetMetaData = this.compositeState.getController().getSession().constructResultSetMetaData();
        teraResultSetMetaData.setActivityType(this.compositeState.getActivityType());
        teraResultSetMetaData.setPrepInfoParcel(this.currentEvent);
        Parcel parcel = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReceivePrepInfoSubState.action currentEvent=" + this.currentEvent);
        }
        if ((prepInfoItemIterator = this.currentEvent.getPrepInfoItemIterator()).count() > 0) {
            object = this.compositeState.getController().getStatement().getGeneratedKeysRequest();
            int n = 1;
            while (prepInfoItemIterator.hasNext()) {
                PrepInfoItem prepInfoItem = prepInfoItemIterator.next();
                ColumnProperties columnProperties = new ColumnProperties();
                columnProperties.initWithPrepInfoItem(prepInfoItem, this.compositeState.getController().getSession());
                boolean bl = object == null || !ActivityAnalyzer.update(this.compositeState.getActivityType()) || ((GeneratedKeysRequest)object).addColumnProperties(prepInfoItem.getColumnName(), n++);
                teraResultSetMetaData.addColumnProperties(columnProperties, bl);
            }
            if (object != null && ActivityAnalyzer.update(this.compositeState.getActivityType())) {
                ((GeneratedKeysRequest)object).verifyColumns(prepInfoItemIterator.count());
            }
        }
        if ((parcel = this.compositeState.getNextParcel()) == null) {
            throw ErrorFactory.makeIoJDBCException("TJ330", "ReceivePrepInfoSubState", this.compositeState.getController().getNetworkIO(), null, this.log);
        }
        switch (parcel.getFlavor()) {
            case 71: {
                object = (DataInfoParcel)parcel;
                tDParcelState = new ReceiveDataInfoSubState(this.compositeState, (DataInfoParcel)parcel);
                break;
            }
            case 146: {
                tDParcelState = new ReceiveDataInfoSubState(this.compositeState, (DataInfoParcel)parcel);
                break;
            }
            case 10: {
                tDParcelState = new ReceiveRecordSubState(this.compositeState, (RecordParcel)parcel);
                break;
            }
            case 11: {
                tDParcelState = new ReceiveEndSubState(this.compositeState, (EndStatementParcel)parcel);
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
            }
        }
        if (this.compositeState.preparingRequest()) {
            this.compositeState.getController().getStatement().getMetaDataList().saveMetaDataForStatement(teraResultSetMetaData, this.compositeState.getStatementNumber());
        } else {
            this.compositeState.createCurrentResultSet(teraResultSetMetaData);
        }
        return tDParcelState;
    }
}

