/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2jwt;

import com.teradata.tdgss.jgssp2jwt.JwtMechanism;
import com.teradata.tdgss.jgssp2jwt.JwtMinorStatus;
import com.teradata.tdgss.jgssp2jwt.JwtName;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class JwtCredential
implements GSSCredential {
    private final TdgssLogger logger;
    private JwtName jwtTokenName;
    private int initLifetime;
    private int acceptLifetime;
    private int usage;
    private long initEnd;
    private long acceptEnd;
    private boolean indefiniteInit = false;
    private boolean indefiniteAccept = false;
    private boolean acceptOnly = false;
    private boolean initOnly = false;
    private JwtName extraLogdata = null;
    private String jwtToken = null;

    public JwtCredential(JwtName jwtName, int n, int n2, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        String string = null;
        if (jwtName == null) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_INPUT);
        }
        string = jwtName.toString();
        if (string.toLowerCase().startsWith("token=")) {
            try {
                this.jwtToken = string.substring(6);
                this.jwtTokenName = new JwtName(this.jwtToken.getBytes("UTF-8"), TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, tdgssLogger);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                tdgssLogger.error(unsupportedEncodingException.getMessage());
                throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_INPUT, unsupportedEncodingException);
            }
        } else {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_INPUT);
        }
        long l = System.currentTimeMillis();
        this.usage = n2;
        if (this.usage != 2) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteInit = true;
            } else {
                this.initLifetime = n;
                this.initEnd = l + (long)this.initLifetime;
            }
        } else {
            this.acceptOnly = true;
        }
        if (n2 != 1) {
            if (n == Integer.MAX_VALUE) {
                this.indefiniteAccept = true;
            } else {
                this.acceptLifetime = n;
                this.acceptEnd = l + (long)this.acceptLifetime;
            }
        } else {
            this.initOnly = true;
        }
    }

    @Override
    public void dispose() throws GSSException {
    }

    @Override
    public GSSName getName() throws GSSException {
        return this.jwtTokenName;
    }

    @Override
    public GSSName getName(Oid oid) throws GSSException {
        if (oid != JwtMechanism.mechOid) {
            throw new TdgssException(2, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        return this.jwtTokenName;
    }

    @Override
    public int getRemainingLifetime() throws GSSException {
        int n;
        if (this.initOnly) {
            return this.getRemainingInitLifetime(JwtMechanism.mechOid);
        }
        if (this.acceptOnly) {
            return this.getRemainingAcceptLifetime(JwtMechanism.mechOid);
        }
        int n2 = this.getRemainingAcceptLifetime(JwtMechanism.mechOid);
        return n2 < (n = this.getRemainingInitLifetime(JwtMechanism.mechOid)) ? n2 : n;
    }

    @Override
    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (oid != JwtMechanism.mechOid) {
            throw new TdgssException(2, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (this.acceptOnly) {
            return 0;
        }
        if (this.indefiniteInit) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.initEnd);
        return n < 0 ? 0 : n;
    }

    @Override
    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (oid != JwtMechanism.mechOid) {
            throw new TdgssException(2, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        if (this.initOnly) {
            return 0;
        }
        if (this.indefiniteAccept) {
            return Integer.MAX_VALUE;
        }
        int n = (int)(System.currentTimeMillis() - this.acceptEnd);
        return n < 0 ? 0 : n;
    }

    @Override
    public int getUsage() throws GSSException {
        return this.usage;
    }

    @Override
    public int getUsage(Oid oid) throws GSSException {
        if (oid != JwtMechanism.mechOid) {
            throw new TdgssException(2, JwtMinorStatus.JWT_ERR_INVALID_ARGUMENT);
        }
        return this.usage;
    }

    @Override
    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{JwtMechanism.mechOid};
        return oidArray;
    }

    @Override
    public boolean equals(Object object) {
        try {
            GSSCredential gSSCredential = (GSSCredential)object;
            if (gSSCredential == null) {
                return false;
            }
            if (!gSSCredential.getName().equals(this.jwtTokenName)) {
                return false;
            }
            Oid[] oidArray = gSSCredential.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (gSSCredential.getUsage(oidArray[i]) != this.getUsage(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingAcceptLifetime(oidArray[i]) != this.getRemainingAcceptLifetime(oidArray[i])) {
                    return false;
                }
                if (gSSCredential.getRemainingInitLifetime(oidArray[i]) == this.getRemainingInitLifetime(oidArray[i])) continue;
                return false;
            }
        }
        catch (GSSException gSSException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return true;
    }

    @Override
    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        if (gSSName == null) {
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_INPUT);
        }
        try {
            this.setExtraLogdata(new JwtName(gSSName.toString().getBytes("UTF-8"), TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, this.logger));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.error(unsupportedEncodingException.getMessage());
            throw new TdgssException(11, JwtMinorStatus.JWT_ERR_INVALID_INPUT, unsupportedEncodingException);
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + this.usage;
        try {
            Oid[] oidArray = this.getMechs();
            for (int i = 0; i < oidArray.length; ++i) {
                if (!this.initOnly) {
                    n = n * 31 + (this.indefiniteAccept ? 1231 : this.acceptLifetime);
                }
                if (this.acceptOnly) continue;
                n = n * 31 + (this.indefiniteInit ? 1231 : this.initLifetime);
            }
        }
        catch (GSSException gSSException) {
            gSSException.printStackTrace();
        }
        return n;
    }

    public JwtName getExtraLogdata() {
        return this.extraLogdata;
    }

    public void setExtraLogdata(JwtName jwtName) {
        this.extraLogdata = jwtName;
    }
}

