/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td1;

import com.teradata.tdgss.jgssp2td1.Td1Context;
import com.teradata.tdgss.jgssp2td1.Td1Credential;
import com.teradata.tdgss.jgssp2td1.Td1MinorStatus;
import com.teradata.tdgss.jgssp2td1.Td1Name;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Td1Mechanism
implements GSSMechanism {
    private final TdgssLogger logger;
    private static Oid _mechOid;
    static final int TDATMETHODMAXTOKEN = 64;
    static final int AUTHTERADATA = 8;
    static final String AUTHTERADATASTR;
    static final Oid mechOid;
    static final short servicesAvailable = 98;
    private short servicesNeeded = 0;

    public Td1Mechanism(TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
        this.servicesNeeded = (short)98;
    }

    @Override
    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        if (object == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token is null");
            }
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (byArray.length <= 0 || byArray.length > 64) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof Td1Credential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIALmust be a credential created by this mech");
            }
            return false;
        }
        return true;
    }

    @Override
    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForAccept ");
        }
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, Td1MinorStatus.TD1_ERR_DEFECTIVE_TOKEN);
        }
        return new Td1Context((Td1Credential)gSSCredential, objectArray, this.logger);
    }

    @Override
    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForInit ");
        }
        if (!this.initable(gSSCredential, gSSName, n, objectArray, s = (short)(s & 0x62))) {
            throw new TdgssException(10, Td1MinorStatus.TD1_ERR_DEFECTIVE_TOKEN);
        }
        return new Td1Context((Td1Credential)gSSCredential, (Td1Name)gSSName, n, objectArray, s, this.logger);
    }

    @Override
    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, short s) {
        if (gSSCredential != null && !(gSSCredential instanceof Td1Credential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIAL: must be a credential created by this mech");
            }
            return false;
        }
        if (gSSName != null && !(gSSName instanceof Td1Name)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("must be a name created by this mech");
            }
            return false;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("servicesAvailable are " + new Short(98));
            this.logger.debug("servicesRequested are " + new Short(s));
        }
        return true;
    }

    @Override
    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        Td1Name td1Name;
        if (gSSName == null) {
            td1Name = null;
        } else if (gSSName instanceof Td1Name) {
            td1Name = (Td1Name)gSSName;
        } else {
            throw new TdgssException(3, Td1MinorStatus.TD1_ERR_INVALID_ARGUMENT);
        }
        return new Td1Credential(td1Name, n, n2);
    }

    @Override
    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return new Td1Name(byArray, oid);
    }

    @Override
    public Oid[] getNames() {
        Oid[] oidArray = new Oid[]{TdgssName.GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA, TdgssName.GSS_C_NT_TDAT_MECHDATA, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF32};
        return oidArray;
    }

    @Override
    public Oid getMech() {
        return mechOid;
    }

    @Override
    public short getServices() {
        return 98;
    }

    static {
        AUTHTERADATASTR = new String("TERADATA");
        try {
            _mechOid = new Oid("1.3.6.1.4.1.191.1.1012.1.1.8");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        mechOid = _mechOid;
    }
}

