/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2ldap;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.jalgapi.AlgParcel;
import com.teradata.tdgss.jalgapi.AlgQop;
import com.teradata.tdgss.jalgapi.AlgQopDer;
import com.teradata.tdgss.jgssp2ldap.LdapCredential;
import com.teradata.tdgss.jgssp2ldap.LdapDH;
import com.teradata.tdgss.jgssp2ldap.LdapMechanism;
import com.teradata.tdgss.jgssp2ldap.LdapMinorStatus;
import com.teradata.tdgss.jgssp2ldap.LdapName;
import com.teradata.tdgss.jgssp2ldap.LdapUtil;
import com.teradata.tdgss.jgssp2ldap.LdapVersion;
import com.teradata.tdgss.jgssp2td2.ASN1Msg;
import com.teradata.tdgss.jgssp2td2.ASN1TokenHdr;
import com.teradata.tdgss.jgssp2td2.Td2Crypto;
import com.teradata.tdgss.jgssp2td2.Td2Token;
import com.teradata.tdgss.jgssp2td2.Td2Util;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import com.teradata.tdgss.jtdgss.TdgssVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import javax.crypto.SecretKey;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class LdapContext
implements GSSContext {
    private final TdgssLogger logger;
    private static final short maxshort = Short.MAX_VALUE;
    private static final int CTX_NEW = 0;
    private static final int CTX_SEND_KEYS = 1;
    private static final int CTX_BINDABLE = 3;
    private static final int CTX_USER_PROPERTIES = 4;
    private static final int CTX_SETUP_COMPLETE = 5;
    private byte contextInit = 0;
    private int contextState = 0;
    private byte server_client = 1;
    private TdgssVersion mylibraryversion;
    private LdapVersion mymethodversion;
    private byte myendien = 1;
    private boolean protReady = false;
    private byte mytargetendien = (byte)-1;
    private int mycbmaxtoken = -1;
    private byte[] masterKey = null;
    private String[] endien_txt = new String[]{"small endien", "big endien"};
    private boolean initiator;
    private LdapCredential credential;
    private LdapName targetName;
    private int lifetime;
    private short requestedServices;
    private LdapDH DH;
    private static String[] QOPComp;
    private int publicKeyLength;
    private byte[] publicKeybuf;
    private AlgQop legacyQop;
    private AlgQop[] globalQops;
    private static final int HEADERLEN = 16;
    protected static final int LIB_MAJOR_REL_VER_INDEX = 16;
    private static final int LIB_MINOR_REL_VER_INDEX = 17;
    private static final int LIB_MAINT_REL_VER_INDEX = 18;
    private static final int LIB_EMG_REL_VER_INDEX = 19;
    protected static final int PKEY_LENGTH = 20;
    private static final int GKEY_LENGTH = 24;
    private static final int PUBLICKEY_LENGTH = 28;
    private static final int PARCEL_LENGTH = 36;
    private static final int ENCRYPTED_LOGDATA = 40;
    private static final int KEY_DATA = 80;
    private static final byte TDGSS_BIGENDIEN = 1;
    private static final byte TDGSS_SMALLENDIEN = 0;
    private static final byte TDGSS_SERVER = 1;
    private static final byte TDGSS_CLIENT = 0;
    protected static final byte FLAG_BYTE = 12;
    private static final int INITMSGLEN = 64;
    static final int keysize = 64;
    static final String[] msgexttxt;
    private byte[] UserPropBytes = null;
    private BigInteger mySeqNum = new BigInteger("1");
    private BigInteger peerSeqNum = new BigInteger("1");
    private int peerCapabilities = 0;
    private Td2Crypto[] td2Crypto = new Td2Crypto[4];

    public LdapContext(LdapCredential ldapCredential, Object[] objectArray, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.initiator = false;
        this.credential = ldapCredential;
        this.InitialiseData();
        this.requestedServices = (short)99;
    }

    public LdapContext(LdapCredential ldapCredential, LdapName ldapName, int n, Object[] objectArray, short s, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.initiator = true;
        this.credential = ldapCredential;
        this.targetName = ldapName;
        this.lifetime = n;
        this.requestedServices = s;
        this.InitialiseData();
    }

    public static TdgssVersion InquireLibraryVersion() {
        TdgssVersion tdgssVersion = new TdgssVersion();
        return tdgssVersion;
    }

    public static LdapVersion InquireMethodVersion() {
        LdapVersion ldapVersion = new LdapVersion();
        return ldapVersion;
    }

    private void InitialiseData() throws GSSException {
        this.contextState = 0;
        this.mylibraryversion = LdapContext.InquireLibraryVersion();
        this.mymethodversion = LdapContext.InquireMethodVersion();
        this.myendien = 1;
        this.mycbmaxtoken = 80;
        this.DH = new LdapDH(this.logger);
        if (QOPComp == null) {
            QOPComp = this.ParseQOP(1);
        }
    }

    private Td2Token ValidateMsgInfo(byte[] byArray, int n, int n2) throws GSSException {
        boolean bl;
        if (n2 <= 16) {
            throw new TdgssException(10, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n + n2 - 16, byArray2, 0, 16);
        Td2Token td2Token = new Td2Token(byArray2, 0, this.logger);
        byte by = td2Token.getVersion();
        byte by2 = td2Token.getMsgType();
        byte by3 = td2Token.getByteVar();
        if (by == 1 && (by2 != 3 && by2 != 4 || by3 != 2)) {
            throw new TdgssException(10, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        if (by == 3 && by2 != 7 && by2 != 8) {
            throw new TdgssException(10, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        boolean bl2 = bl = (td2Token.getFlags() & 4) == 4;
        if (by == 3 && by2 == 7 && !bl ? n2 != td2Token.getMsgLength() : n2 != td2Token.getMsgLength() + 16) {
            throw new TdgssException(10, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        return td2Token;
    }

    public String[] ParseQOP(int n) throws GSSException {
        String[] stringArray = new String[5];
        switch (n) {
            case 0: {
                stringArray[0] = "AES";
                stringArray[1] = "K128";
                stringArray[2] = "CFB";
                stringArray[3] = "PKCS5Padding";
                stringArray[4] = "MD5";
                break;
            }
            case 1: {
                stringArray[0] = "AES";
                stringArray[1] = "K128";
                stringArray[2] = "OFB";
                stringArray[3] = "PKCS5Padding";
                stringArray[4] = "SHA1";
                break;
            }
            default: {
                throw new TdgssException(14, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
            }
        }
        return stringArray;
    }

    private byte[] BuildInitMsg(byte by) throws GSSException {
        byte[] byArray = null;
        byte[] byArray2 = new byte[]{6, 12, 43, 6, 1, 4, 1, -127, 63, 1, -121, 116, 1, 20, 70, 8, 0, 1, -127, 0, 3, 0, 0, 0, 1, 0, 0, 0, 30, 1};
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("We will initiate the handshake now...");
        }
        byte[] byArray3 = AlgParcel.getCipherSuitesParcel();
        int n = byArray3.length;
        byArray = new byte[this.mycbmaxtoken + n + byArray2.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        byte by2 = 0;
        if ((this.requestedServices & 1) == 1) {
            by2 = (byte)(by2 | 0x10);
        }
        Td2Token td2Token = new Td2Token(1, by, 1, this.isserver() ? (byte)1 : 0, 29, by2, 0, 64 + n, null, this.logger);
        byte[] byArray4 = td2Token.GetTokenBytes();
        System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
        byArray[16] = this.mylibraryversion.MajorRelease;
        byArray[17] = this.mylibraryversion.MinorRelease;
        byArray[18] = this.mylibraryversion.MaintenanceRelease;
        byArray[19] = this.mylibraryversion.EmergencyRelease;
        byte[] byArray5 = LdapUtil.inttobytearray(n);
        System.arraycopy(byArray5, 0, byArray, 36, byArray5.length);
        System.arraycopy(byArray3, 0, byArray, this.mycbmaxtoken, n);
        System.arraycopy(byArray2, 0, byArray, this.mycbmaxtoken + n, byArray2.length);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("Successfully generated first message as", byArray));
        }
        return byArray;
    }

    private void ProcessInitMsg(byte[] byArray, int n, int n2) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Receiving and processing first message");
        }
        if (n != 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Only offset = 0 is allowed!");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_OFFSET_NOT_ZERO);
        }
        Td2Token td2Token = new Td2Token(byArray, n, this.logger);
        this.mytargetendien = 0;
        if ((td2Token.getFlags() & 0x10) != 16) {
            this.requestedServices = (short)(this.requestedServices & 0x7FFE);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Checking target endien as " + this.mytargetendien);
        }
        if (this.byteflipneeded() && this.logger.isDebugEnabled()) {
            this.logger.debug("We have to byte-flip!");
        }
        if (!this.chklibrary(byArray, this.mylibraryversion)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("*** Illegal library version *** ");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_VERSION_MISMATCH);
        }
        if (td2Token.getMsgType() != 1 && td2Token.getMsgType() != 2 || td2Token.getByteVar() != 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" Message header is not proper");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        this.peerCapabilities = (byte)td2Token.getCapabilities();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The received message is OK!");
        }
    }

    private void ExtractKeys(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        Object object2;
        Object object3;
        byte[] byArray2 = null;
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = null;
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = null;
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = new byte[4];
        byte[] byArray9 = null;
        System.arraycopy(byArray, 20, byArray3, 0, 4);
        int n3 = LdapUtil.ByteAtoInt(byArray3);
        byArray2 = new byte[n3];
        System.arraycopy(byArray, 80, byArray2, 0, n3);
        System.arraycopy(byArray, 24, byArray5, 0, 4);
        int n4 = LdapUtil.ByteAtoInt(byArray5);
        byArray4 = new byte[n4];
        System.arraycopy(byArray, 80 + n3, byArray4, 0, n4);
        System.arraycopy(byArray, 28, byArray7, 0, 4);
        int n5 = LdapUtil.ByteAtoInt(byArray7);
        byArray6 = new byte[n5];
        System.arraycopy(byArray, 80 + n3 + n4, byArray6, 0, n5);
        if ((this.peerCapabilities & 4) == 4 || (this.peerCapabilities & 0x10) == 16) {
            System.arraycopy(byArray, 36, byArray8, 0, 4);
            int n6 = LdapUtil.ByteAtoInt(byArray8);
            byArray9 = new byte[n6];
            System.arraycopy(byArray, 80 + n3 + n4 + n5, byArray9, 0, n6);
            object3 = new AlgQopDer(byArray9);
            this.globalQops = new AlgQop[4];
            this.globalQops[0] = ((AlgQopDer)object3).getAlgQop(0);
            this.globalQops[1] = ((AlgQopDer)object3).getAlgQop(1);
            this.globalQops[2] = ((AlgQopDer)object3).getAlgQop(2);
            this.globalQops[3] = ((AlgQopDer)object3).getAlgQop(3);
        } else {
            AlgQop algQop;
            object3 = QOPComp[0];
            String string = QOPComp[1].substring(1);
            int n7 = Integer.parseInt(string);
            String string2 = QOPComp[2];
            object2 = QOPComp[3];
            object = QOPComp[4];
            String string3 = "DH";
            int n8 = 640;
            this.legacyQop = algQop = new AlgQop((String)object3, n7, string2, (String)object2, (String)object, string3, n8);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generate DH Parameters ...");
        }
        this.DH.GenerateParameters(1, byArray4, byArray2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generate DH Public Key ...");
        }
        this.publicKeybuf = this.DH.GenerateKey();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Compute  DH Private Key ...");
        }
        this.masterKey = this.DH.ComputeKey(byArray6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("The Matser Key is ***********************************", this.masterKey));
        }
        this.publicKeyLength = n5;
        if ((this.peerCapabilities & 4) == 4 || (this.peerCapabilities & 0x10) == 16) {
            int n9 = 0;
            for (int i = 0; i < 4; ++i) {
                AlgQop algQop = this.globalQops[i];
                int n10 = algQop.getKeyLength() / 8;
                object2 = new byte[n10];
                System.arraycopy(this.masterKey, n9, object2, 0, n10);
                object = this.DH.BytetoKey(algQop.getConfidentialityAlgorithm(), (byte[])object2, 0, n10);
                this.td2Crypto[i] = new Td2Crypto((SecretKey)object, (byte[])object2, algQop, this.peerCapabilities, this.logger);
                this.td2Crypto[i].computeKeyHash();
                n9 += n10;
            }
        } else {
            object3 = this.DH.BytetoKey(this.legacyQop.getConfidentialityAlgorithm(), this.masterKey, 0, this.legacyQop.getKeyLength() / 8);
            this.td2Crypto[0] = new Td2Crypto((SecretKey)object3, this.masterKey, this.legacyQop, this.peerCapabilities, this.logger);
            this.td2Crypto[0].computeKeyHash();
        }
        this.protReady = true;
    }

    private byte[] BuildServerMsg() throws GSSException {
        byte[] byArray = null;
        byte by = 1;
        if ((this.peerCapabilities & 1) == 1) {
            by = 3;
        }
        byte by2 = 0;
        if ((this.requestedServices & 1) == 1) {
            by2 = (byte)(by2 | 0x10);
        }
        if ((this.peerCapabilities & 8) == 8) {
            byte[] byArray2 = this.getLogdataUTF8();
            MessageProp messageProp = new MessageProp(0, true);
            byte[] byArray3 = this.wrap(byArray2, 0, byArray2.length, messageProp);
            int n = 64 + byArray3.length + this.publicKeyLength;
            Td2Token td2Token = new Td2Token(by, 1, 2, this.isserver() ? (byte)1 : 0, 255, by2, 0, n, null, this.logger);
            byte[] byArray4 = td2Token.GetTokenBytes();
            byArray = new byte[16 + n];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
            byArray[16] = this.mylibraryversion.MajorRelease;
            byArray[17] = this.mylibraryversion.MinorRelease;
            byArray[18] = this.mylibraryversion.MaintenanceRelease;
            byArray[19] = this.mylibraryversion.EmergencyRelease;
            byte[] byArray5 = LdapUtil.inttobytearray(this.publicKeyLength);
            System.arraycopy(byArray5, 0, byArray, 28, byArray5.length);
            System.arraycopy(this.publicKeybuf, 0, byArray, 80, this.publicKeybuf.length);
            byte[] byArray6 = LdapUtil.inttobytearray(byArray3.length);
            System.arraycopy(byArray6, 0, byArray, 40, byArray6.length);
            System.arraycopy(byArray3, 0, byArray, 80 + this.publicKeybuf.length, byArray3.length);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("Successfully generated second message as", byArray));
            }
        } else {
            Td2Token td2Token = new Td2Token(by, 1, 2, this.isserver() ? (byte)1 : 0, 255, by2, 0, this.publicKeyLength, null, this.logger);
            byte[] byArray7 = td2Token.GetTokenBytes();
            byArray = new byte[16 + this.publicKeyLength];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            System.arraycopy(byArray7, 0, byArray, 0, byArray7.length);
            System.arraycopy(this.publicKeybuf, 0, byArray, byArray7.length, this.publicKeybuf.length);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("Successfully generated second message as", byArray));
            }
        }
        this.publicKeybuf = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The received message is OK!");
        }
        return byArray;
    }

    private byte[] getLogdataUTF8() throws GSSException {
        GSSName gSSName = null;
        byte[] byArray = null;
        String string = "";
        gSSName = this.getSrcName();
        if (gSSName != null) {
            string = gSSName.toString();
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.error(unsupportedEncodingException.getMessage());
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_LDAP, unsupportedEncodingException);
        }
        return byArray;
    }

    public void setkey(byte[] byArray) {
        this.masterKey = (byte[])byArray.clone();
    }

    public boolean byteflipneeded() {
        boolean bl = false;
        if (this.mytargetendien != this.myendien) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("target endien is [" + this.endien_txt[this.mytargetendien] + "] different against our endien [" + this.endien_txt[this.myendien] + "]");
            }
            try {
                if (this.isserver()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are server! No need to byte-flip!");
                    }
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are client, we have to byte-flip!");
                    }
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.logger.error(exception.getMessage());
            }
        }
        return bl;
    }

    public byte[] msgcvt(byte[] byArray) {
        if (!this.byteflipneeded()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No flipping needed!");
            }
            return byArray;
        }
        int n = 0;
        while (n + 3 < byArray.length) {
            byte by = byArray[n];
            byArray[n] = byArray[n + 3];
            byArray[n + 3] = by;
            by = byArray[n + 1];
            byArray[n + 1] = byArray[n + 2];
            byArray[n + 2] = by;
            n += 4;
        }
        return byArray;
    }

    private boolean chklibrary(byte[] byArray, TdgssVersion tdgssVersion) {
        return byArray[16] >= 6;
    }

    private void checkInputToken(byte[] byArray, int n, int n2) throws GSSException {
        if (byArray == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input Buffer is NULL");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        if (n < 0 || n + n2 > byArray.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Offset value is incorrect");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        if (n2 < 16) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input buffer is less than token header (16 bytes)");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        new Td2Token(byArray2, 0, this.logger);
    }

    @Override
    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        byte[] byArray2 = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Context state is now " + this.contextState);
        }
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        switch (this.contextState) {
            case 0: {
                this.server_client = 0;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Confirming that we are now " + msgexttxt[this.server_client]);
                }
                byArray2 = this.BuildInitMsg((byte)1);
                this.contextState = 1;
                break;
            }
            case 1: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("Just receive info-data from server as:", byArray));
                }
                this.checkInputToken(byArray, n, n2);
                this.ProcessInitMsg(byArray, n, n2);
                this.ExtractKeys(byArray, n, n2);
                byArray2 = this.BuildServerMsg();
                if ((this.peerCapabilities & 8) == 8) {
                    this.contextState = 4;
                    break;
                }
                this.contextState = 3;
                break;
            }
            case 3: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("Received data from server as:", byArray));
                }
                this.checkInputToken(byArray, n, n2);
                byte[] byArray3 = this.getLogdataUTF8();
                Td2Token td2Token = null;
                byte by = 0;
                if ((this.requestedServices & 1) == 1) {
                    by = (byte)(by | 0x10);
                }
                td2Token = (this.peerCapabilities & 1) == 1 ? new Td2Token(3, 5, 2, this.isserver() ? (byte)1 : 0, 1, by, 0, byArray3.length, null, this.logger) : new Td2Token(1, 5, 2, this.isserver() ? (byte)1 : 0, 0, by, 0, byArray3.length, null, this.logger);
                byte[] byArray4 = new byte[16 + byArray3.length];
                byte[] byArray5 = td2Token.GetTokenBytes();
                System.arraycopy(byArray5, 0, byArray4, 0, byArray5.length);
                System.arraycopy(byArray3, 0, byArray4, 16, byArray3.length);
                MessageProp messageProp = new MessageProp(0, true);
                byArray2 = this.wrap(byArray4, 0, byArray4.length, messageProp);
                this.contextState = 4;
                break;
            }
            case 4: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(TdgssUtil.dump("Receive info-data from server as:", byArray));
                }
                this.checkInputToken(byArray, n, n2);
                byte[] byArray6 = new byte[4];
                System.arraycopy(byArray, 4, byArray6, 0, 4);
                BigInteger bigInteger = new BigInteger(byArray6);
                int n3 = bigInteger.intValue();
                this.UserPropBytes = new byte[n3];
                System.arraycopy(byArray, 16, this.UserPropBytes, 0, n3);
                this.contextState = 5;
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_BAD_CONTEXT_STATE);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Context state before leaving is " + this.contextState);
        }
        return byArray2;
    }

    @Override
    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public boolean isEstablished() {
        return this.contextState == 5;
    }

    public boolean isserver() throws GSSException {
        if (this.server_client == 1) {
            return true;
        }
        if (this.server_client == 0) {
            return false;
        }
        throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_BAD_CONTEXT_STATE);
    }

    @Override
    public void dispose() throws GSSException {
        if (this.credential != null) {
            this.credential.dispose();
        }
    }

    @Override
    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        boolean bl2 = false;
        if (!this.isProtReady()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_CONTEXT_NOT_READY);
        }
        n = this.validateQop(n);
        if ((this.peerCapabilities & 0x10) == 16) {
            bl2 = true;
        }
        int n3 = this.td2Crypto[n].getWrapSizeLimit(n, bl, n2, bl2);
        return n3;
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        int n3 = 0;
        boolean bl = false;
        byte by = 0;
        Td2Token td2Token = null;
        byte[] byArray2 = null;
        if (!this.isProtReady()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_CONTEXT_NOT_READY);
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (messageProp == null) {
            throw new TdgssException(14, LdapMinorStatus.LDAPV3_ERR_INVALID_INPUT);
        }
        n3 = messageProp.getQOP();
        n3 = this.validateQop(n3);
        if (this.getConfState() && messageProp.getPrivacy()) {
            by = (byte)(by | 4);
            bl = true;
        }
        if (this.peerCapabilities == 0) {
            td2Token = new Td2Token(1, 3, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null, this.logger);
            byArray2 = this.td2Crypto[n3].wrap(byArray, n, n2, messageProp, td2Token);
        } else if ((this.peerCapabilities & 1) == 1) {
            int n4 = 1;
            if ((this.peerCapabilities & 0x10) == 16) {
                n4 |= 0x10;
            }
            td2Token = new Td2Token(3, 7, 2, this.isserver() ? (byte)1 : 0, n4, by, n3, 0, this.mySeqNum, this.logger);
            byArray2 = (this.peerCapabilities & 0x10) == 16 ? this.td2Crypto[n3].newWrap(byArray, n, n2, messageProp, td2Token) : this.td2Crypto[n3].wrap(byArray, n, n2, messageProp, td2Token);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unknown peer capabilities");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        if (bl) {
            messageProp.setPrivacy(true);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }

    @Override
    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2;
        Td2Token td2Token;
        int n3;
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (!this.isProtReady()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_CONTEXT_NOT_READY);
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (byArray == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input argument is null");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_INPUT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if ((this.peerCapabilities & 0x10) == 16) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Decoding ASN1 message token!");
            }
            object2 = new ASN1Msg();
            object = new DER(byArray);
            ((ASN1Msg)object2).parseDERObject((DER)object);
            ASN1TokenHdr aSN1TokenHdr = ((ASN1Msg)object2).getAsn1TokenHdr();
            byArray3 = ((ASN1Msg)object2).getInputMsg();
            if (((ASN1Msg)object2).isauthTagSet()) {
                byArray4 = ((ASN1Msg)object2).getAuthTag();
            }
            if (((ASN1Msg)object2).iscomputedMacSet()) {
                byArray5 = ((ASN1Msg)object2).getComputedMac();
            }
            n3 = Td2Util.ByteAtoInt(aSN1TokenHdr.getfQOP());
            byte[] byArray6 = aSN1TokenHdr.getVersion();
            byte[] byArray7 = aSN1TokenHdr.getMsgType();
            int n4 = aSN1TokenHdr.getMsgLength();
            byte by = aSN1TokenHdr.getFlag();
            BigInteger bigInteger = aSN1TokenHdr.getSeqNum();
            td2Token = new Td2Token(byArray6[0], byArray7[0], 0, 0, 1, by, n3, n4, bigInteger, this.logger);
        } else {
            td2Token = this.ValidateMsgInfo(byArray, n, n2);
        }
        boolean bl5 = (td2Token.getFlags() & 4) == 4;
        if ((this.peerCapabilities & 1) == 1 && 0 != ((BigInteger)(object2 = td2Token.getSeqNumber())).compareTo(this.peerSeqNum)) {
            object = LdapMinorStatus.LDAPV3_ERR_ILLEGAL_SEQUENCE;
            if (((BigInteger)object2).equals(this.peerSeqNum.subtract(BigInteger.ONE))) {
                bl = true;
            }
            if (((BigInteger)object2).compareTo(this.peerSeqNum) > 0) {
                bl4 = true;
            }
            if (((BigInteger)object2).compareTo(this.peerSeqNum) < 0) {
                bl2 = true;
                bl3 = true;
            }
            if (messageProp != null) {
                messageProp.setSupplementaryStates(bl, bl2, bl3, bl4, ((TdgssMinorStatus)object).getErrorCode(), ((TdgssMinorStatus)object).getErrorMessage());
            }
        }
        n3 = td2Token.getQOP();
        n3 = this.validateQop(n3);
        if ((this.peerCapabilities & 0x10) == 16) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Doing ASN1 unwrap");
            }
            byArray2 = this.td2Crypto[n3].newUnWrap(byArray3, 0, byArray3.length, byArray5, bl5, td2Token, byArray4);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Doing unwrap");
            }
            byArray2 = this.td2Crypto[n3].unwrap(byArray, n, n2, messageProp, td2Token);
        }
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        if (messageProp != null) {
            messageProp.setPrivacy(bl5);
            messageProp.setQOP(n3);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }

    @Override
    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        int n3 = 0;
        Td2Token td2Token = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (!this.isProtReady()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_CONTEXT_NOT_READY);
        }
        if (n < 0 || n2 < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (byArray.length < n2 + n) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("INPUT BUFFER SIZE " + byArray.length + " IS SMALLER THAN LENGTH + OFFSET " + (n2 + n));
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (messageProp != null) {
            n3 = messageProp.getQOP();
        }
        n3 = this.validateQop(n3);
        byte by = 0;
        if (this.peerCapabilities == 0) {
            td2Token = new Td2Token(1, 4, 2, this.isserver() ? (byte)1 : 0, 255, by, n3, 0, null, this.logger);
        } else if ((this.peerCapabilities & 1) == 1) {
            td2Token = new Td2Token(3, 8, 2, this.isserver() ? (byte)1 : 0, 1, by, n3, 0, this.mySeqNum, this.logger);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unknown peer capabilities");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = this.td2Crypto[n3].getMIC(byArray, n, n2, messageProp, td2Token);
        this.mySeqNum = this.mySeqNum.add(BigInteger.ONE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
        return byArray2;
    }

    @Override
    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        BigInteger bigInteger;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Entering!");
        }
        if (!this.isProtReady()) {
            throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
        }
        if (n3 < 0 || n4 < 0 || n2 < 0 || n < 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Argument out of Range");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        if (n2 + n > byArray.length || n4 + n3 > byArray2.length) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Input length  is larger than buffer size ");
            }
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
        }
        Td2Token td2Token = this.ValidateMsgInfo(byArray, n, n2);
        if ((this.peerCapabilities & 1) == 1 && 0 != (bigInteger = td2Token.getSeqNumber()).compareTo(this.peerSeqNum)) {
            LdapMinorStatus ldapMinorStatus = LdapMinorStatus.LDAPV3_ERR_ILLEGAL_SEQUENCE;
            if (bigInteger.equals(this.peerSeqNum.subtract(BigInteger.ONE))) {
                bl = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) > 0) {
                bl4 = true;
            }
            if (bigInteger.compareTo(this.peerSeqNum) < 0) {
                bl2 = true;
                bl3 = true;
            }
            if (messageProp != null) {
                messageProp.setSupplementaryStates(bl, bl2, bl3, bl4, ldapMinorStatus.getErrorCode(), ldapMinorStatus.getErrorMessage());
            }
        }
        int n5 = td2Token.getQOP();
        n5 = this.validateQop(n5);
        this.td2Crypto[n5].verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp, td2Token);
        this.peerSeqNum = this.peerSeqNum.add(BigInteger.ONE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Leaving!");
        }
    }

    @Override
    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    private int validateQop(int n) throws GSSException {
        if ((this.peerCapabilities & 4) == 4) {
            if (n < 0 || n >= 4) {
                throw new TdgssException(14, LdapMinorStatus.LDAPV3_ERR_INVALID_ARGUMENT);
            }
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public byte[] export() throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 2) : (short)(this.requestedServices & 0x7FFD);
    }

    @Override
    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 4) : (short)(this.requestedServices & 0x7FFB);
    }

    @Override
    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 8) : (short)(this.requestedServices & 0x7FF7);
    }

    @Override
    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 1) : (short)(this.requestedServices & 0x7FFE);
    }

    @Override
    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x10) : (short)(this.requestedServices & 0x7FEF);
    }

    @Override
    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x20) : (short)(this.requestedServices & 0x7FDF);
    }

    @Override
    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.requestedServices = bl ? (short)(this.requestedServices | 0x40) : (short)(this.requestedServices & 0x7FBF);
    }

    @Override
    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_INVALID_REQUEST);
        }
        this.lifetime = n;
    }

    @Override
    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public boolean getCredDelegState() {
        if (this.contextInit == 0) {
            return false;
        }
        if (this.isEstablished()) {
            return (this.requestedServices & 1) != 0;
        }
        return false;
    }

    @Override
    public boolean getMutualAuthState() {
        if (this.contextInit == 0) {
            return false;
        }
        return (this.requestedServices & 2) != 0;
    }

    @Override
    public boolean getReplayDetState() {
        if (this.contextInit == 0) {
            return false;
        }
        return (this.requestedServices & 4) != 0;
    }

    @Override
    public boolean getSequenceDetState() {
        if (this.contextInit == 0) {
            return false;
        }
        return (this.requestedServices & 8) != 0;
    }

    @Override
    public boolean getAnonymityState() {
        return false;
    }

    @Override
    public boolean getConfState() {
        return this.contextInit != 0;
    }

    @Override
    public boolean getIntegState() {
        return this.contextInit != 0;
    }

    @Override
    public int getLifetime() {
        return this.contextInit == 0 ? 0 : this.lifetime;
    }

    @Override
    public boolean isTransferable() throws GSSException {
        if (this.contextInit == 0) {
            throw new TdgssException(11, LdapMinorStatus.LDAPV3_ERR_NO_CONTEXT);
        }
        return false;
    }

    @Override
    public boolean isProtReady() {
        return this.contextInit == 0 ? false : this.protReady;
    }

    @Override
    public GSSName getSrcName() throws GSSException {
        if (this.credential != null) {
            return this.credential.getName();
        }
        return null;
    }

    @Override
    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    @Override
    public Oid getMech() throws GSSException {
        return LdapMechanism.mechOid;
    }

    @Override
    public GSSCredential getDelegCred() throws GSSException {
        throw new TdgssException(16, LdapMinorStatus.LDAPV3_ERR_API_NOT_SUPPORTED);
    }

    @Override
    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }

    static {
        msgexttxt = new String[]{"client", "server"};
    }
}

