/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc_4.io.CertChecker;
import com.teradata.jdbc.jdbc_4.io.ProxySupport;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Utility {
    public static final int HELP_SESSION_CURRENT_DATABASE_INDEX = 5;
    public static final int HELP_SESSION_FULL_CURRENT_DATABASE_INDEX = 75;
    public static final int HELP_SESSION_QUERY_BAND_INDEX = 44;
    public static final int HELP_SESSION_TRANSACTION_QUERY_BAND_INDEX = 122;
    public static final int HELP_SESSION_SESSION_QUERY_BAND_INDEX = 123;
    public static final int HELP_SESSION_PROFILE_QUERY_BAND_INDEX = 124;
    public static final int HELP_SESSION_UNICODE_PASS_THROUGH_INDEX = 125;
    public static final int QUERY_BAND_TRANSACTION_INDEX = 0;
    public static final int QUERY_BAND_SESSION_INDEX = 1;
    public static final int QUERY_BAND_PROFILE_INDEX = 2;
    private static SecureRandom sm_rand = new SecureRandom();

    public static String getCurrentDatabaseFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        int n = resultSet.getMetaData().getColumnCount();
        if (n >= 75) {
            return resultSet.getString(75);
        }
        if (n >= 5) {
            return resultSet.getString(5);
        }
        return "";
    }

    public static String getQueryBandFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        String string = "";
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() >= 44) {
            string = resultSet.getString(44);
        }
        return string;
    }

    public static String[] parseQueryBand(String string) {
        if (string == null) {
            throw new IllegalArgumentException("queryBand argument must not be null");
        }
        String[] stringArray = new String[]{"", "", ""};
        if (!string.equals("")) {
            String string2 = "=T> ";
            String string3 = "=S> ";
            int n = string.indexOf(string2);
            int n2 = string.indexOf(string3);
            if (n >= 0 && n2 >= 0) {
                if (n < n2) {
                    stringArray[0] = string.substring(n + string2.length(), n2).trim();
                    stringArray[1] = string.substring(n2 + string3.length()).trim();
                } else {
                    stringArray[0] = string.substring(n + string2.length()).trim();
                    stringArray[1] = string.substring(n2 + string3.length(), n).trim();
                }
            } else if (n >= 0) {
                stringArray[0] = string.substring(n + string2.length()).trim();
            } else if (n2 >= 0) {
                stringArray[1] = string.substring(n2 + string3.length()).trim();
            }
        }
        return stringArray;
    }

    public static void tokenizeQueryBand(Map map, String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n < 0) continue;
            map.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
        }
    }

    public static void sleepForSeconds(int n) {
        long l = (long)n * 1000L;
        Utility.sleepForMilliseconds(l);
    }

    public static void sleepForMilliseconds(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            sQLException.setNextException(sQLException2);
        }
        return sQLException;
    }

    public static String[] getQueryBandStringsFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() >= 124) {
            String[] stringArray = new String[]{resultSet.getString(122), resultSet.getString(123), resultSet.getString(124)};
            return stringArray;
        }
        String string = resultSetMetaData.getColumnCount() >= 44 ? resultSet.getString(44) : "";
        return Utility.parseQueryBand(string);
    }

    public static boolean getUnicodePassThroughFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        if (resultSet.getMetaData().getColumnCount() < 125) {
            return false;
        }
        String string = resultSet.getString(125);
        if (string == null) {
            return false;
        }
        return string.trim().equals("S");
    }

    public static SQLException wrapEx(Throwable throwable, SQLException sQLException) {
        sQLException.initCause(throwable);
        return sQLException;
    }

    public static SQLException logEx(Log log, String string, SQLException sQLException) {
        if (log.isDebugEnabled()) {
            for (Throwable throwable = sQLException; throwable != null; throwable = throwable.getCause()) {
                log.debug(string + ": " + (throwable != sQLException ? "Caused by " : "") + throwable, null);
            }
        }
        return sQLException;
    }

    public static String getHTTPSProtocol(URLParameters uRLParameters) {
        String string = uRLParameters.getSSLProtocol();
        if (string == null) {
            string = "TLSv1.2";
        }
        return string;
    }

    public static SSLSocketFactory obtainSSLSocketFactory(URLParameters uRLParameters, Log log) throws SQLException {
        SSLContext sSLContext;
        if (uRLParameters.getSSLDebug()) {
            System.setProperty("javax.net.debug", "all");
        }
        String string = Utility.getHTTPSProtocol(uRLParameters);
        if (log.isDebugEnabled()) {
            log.debug("obtainSSLSocketFactory: sHTTPSProtocol=" + string);
        }
        try {
            sSLContext = SSLContext.getInstance(string);
            sSLContext.init(null, new TrustManager[]{new MinimalTrustManager()}, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Utility.logEx(log, "obtainSSLSocketFactory", Utility.wrapEx(generalSecurityException, ErrorFactory.makeDriverJDBCException("TJ1555", string)));
        }
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        if (log.isDebugEnabled()) {
            log.debug("obtainSSLSocketFactory: socketFactory.getDefaultCipherSuites=" + Arrays.asList(sSLSocketFactory.getDefaultCipherSuites()));
        }
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doHttpRequest(URLParameters uRLParameters, Log log, String string, String string2, String[] stringArray, byte[] byArray, boolean bl, String string3, int[] nArray) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("doHttpRequest: sMethod=" + string + " sURL=" + string2 + " asHeaders=" + Utility.formatObjectArray(stringArray) + " anRequiredResponseCodes=" + Utility.formatIntArray(nArray));
        }
        HttpResponse httpResponse = new HttpResponse();
        long l = System.currentTimeMillis();
        try {
            block33: {
                URI uRI = Utility.parseURI(string2, "TJ1571");
                String string4 = uRI.getScheme();
                if (!"http".equals(string4) && !"https".equals(string4)) {
                    throw ErrorFactory.makeDriverJDBCException("TJ1570", string4, string2);
                }
                boolean bl2 = "https".equals(string4);
                int n = uRI.getPort() >= 0 ? uRI.getPort() : (bl2 ? 443 : 80);
                String string5 = uRI.getPath() != null && uRI.getPath().length() > 0 ? uRI.getPath() : "/";
                String string6 = uRI.getQuery() != null && uRI.getQuery().length() > 0 ? "?" + uRI.getQuery() : "";
                String string7 = string + " " + string5 + string6 + " HTTP/1.0\r\n" + "Host: " + uRI.getHost() + ":" + n + "\r\n" + "Accept: */*\r\n";
                for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                    string7 = string7 + stringArray[i] + "\r\n";
                }
                if (byArray != null) {
                    string7 = string7 + "Content-Length: " + byArray.length + "\r\n";
                }
                string7 = string7 + "\r\n";
                byte[] byArray2 = Encoder.encodeStringUTF8(string7);
                if (byArray != null) {
                    byArray2 = Utility.concatByteArrays(byArray2, byArray);
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(uRI.getHost(), n);
                SSLSocketFactory sSLSocketFactory = bl2 ? Utility.obtainSSLSocketFactory(uRLParameters, log) : null;
                try (Socket socket = ProxySupport.connectSocket(log, uRLParameters, false, false, null, null, true, 10, null, inetSocketAddress, 15000, string4, sSLSocketFactory, null);){
                    Object object;
                    if (bl2) {
                        object = uRI.getHost();
                        if (((String)object).startsWith("[") && ((String)object).endsWith("]")) {
                            object = ((String)object).substring(1, ((String)object).length() - 1);
                        }
                        CertChecker.checkCert(uRLParameters, (SSLSocket)socket, (String)object, inetSocketAddress, log);
                    }
                    object = socket.getOutputStream();
                    try {
                        log.debugPartialByteArray("Transmit HTTP request", byArray2, 0, byArray2.length);
                        ((OutputStream)object).write(byArray2);
                        ((OutputStream)object).flush();
                        try (InputStream inputStream = socket.getInputStream();){
                            int n2;
                            int n3 = 0xD0A0D0A;
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            int n4 = 0;
                            while ((n2 = inputStream.read()) != -1) {
                                byteArrayOutputStream.write(n2);
                                if ((n4 = n4 << 8 | n2) != n3) continue;
                            }
                            byte[] byArray3 = byteArrayOutputStream.toByteArray();
                            log.debugPartialByteArray("Received HTTP response", byArray3, 0, byArray3.length);
                            String string8 = Decoder.getUTF8DecodedString(byArray3);
                            String[] stringArray2 = string8.split("\r\n");
                            Matcher matcher = Pattern.compile("HTTP/[0-9.]+ ([0-9]+) (.*)").matcher(stringArray2[0]);
                            if (!matcher.matches()) break block33;
                            httpResponse.nCode = Integer.parseInt(matcher.group(1));
                            httpResponse.sMessage = matcher.group(2);
                            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
                                String string9;
                                StringBuffer stringBuffer = new StringBuffer();
                                while ((string9 = bufferedReader.readLine()) != null) {
                                    if (bl) {
                                        string9 = string9.trim();
                                    }
                                    if (stringBuffer.length() > 0 && string3 != null) {
                                        stringBuffer.append(string3);
                                    }
                                    stringBuffer.append(string9);
                                }
                                httpResponse.sBody = stringBuffer.toString();
                            }
                        }
                    }
                    finally {
                        ((OutputStream)object).close();
                    }
                }
            }
            if (nArray != null) {
                boolean bl3 = false;
                for (int i = 0; !bl3 && i < nArray.length; ++i) {
                    bl3 = httpResponse.nCode == nArray[i];
                }
                if (!bl3) {
                    throw Utility.logEx(log, "doHttpRequest", ErrorFactory.makeDriverJDBCException("TJ1549", "" + httpResponse.nCode, string2));
                }
            }
            HttpResponse httpResponse2 = httpResponse;
            if (log.isTimingEnabled()) {
                log.timing("Accessing " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (httpResponse.nCode < 0 ? "failed" : "completed with " + httpResponse.nCode + " " + httpResponse.sMessage));
            }
            return httpResponse2;
        }
        catch (Throwable throwable) {
            try {
                if (log.isTimingEnabled()) {
                    log.timing("Accessing " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (httpResponse.nCode < 0 ? "failed" : "completed with " + httpResponse.nCode + " " + httpResponse.sMessage));
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw Utility.logEx(log, "doHttpRequest", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1543", string2)));
            }
        }
    }

    public static String getStringFromJSON(String string, String string2, String string3, String string4) throws SQLException {
        String string5;
        Pattern pattern = Pattern.compile("\"" + string + "\"\\s*:\\s*\"([^\"]*)\"");
        Matcher matcher = pattern.matcher(string2);
        String string6 = string5 = matcher.find() ? matcher.group(1) : null;
        if (string5 == null && string3 != null) {
            throw ErrorFactory.makeDriverJDBCException(string3, string, string4);
        }
        return string5;
    }

    public static void waitForThreadDeath(Thread thread) {
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String safeForURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static URI parseURI(String string, String string2) throws SQLException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException(string2, string);
            sQLException.initCause(uRISyntaxException);
            throw sQLException;
        }
    }

    public static byte[] getRandomBytes(int n) {
        byte[] byArray = new byte[n];
        sm_rand.nextBytes(byArray);
        return byArray;
    }

    public static String base64Encode(boolean bl, byte[] byArray) {
        int n = byArray.length * 8 % 6;
        int n2 = n == 0 ? 0 : 1;
        int n3 = byArray.length * 8 / 6 + n2;
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 1;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        String string = new BigInteger(byArray2).toString(2).substring(1);
        if (n == 2) {
            string = string + "0000";
        }
        if (n == 4) {
            string = string + "00";
        }
        int[] nArray = new int[n3];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(string.substring(i * 6, (i + 1) * 6), 2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            if (n4 < 26) {
                stringBuffer.append((char)(n4 + 65));
                continue;
            }
            if (n4 < 52) {
                stringBuffer.append((char)(n4 - 26 + 97));
                continue;
            }
            if (n4 < 62) {
                stringBuffer.append((char)(n4 - 52 + 48));
                continue;
            }
            if (n4 == 62) {
                stringBuffer.append(bl ? (char)'-' : '+');
                continue;
            }
            stringBuffer.append(bl ? (char)'_' : '/');
        }
        if (!bl && n == 2) {
            stringBuffer.append("==");
        }
        if (!bl && n == 4) {
            stringBuffer.append("=");
        }
        return stringBuffer.toString();
    }

    public static byte[] hashBytes(Log log, String string, byte[] byArray) throws SQLException {
        try {
            return MessageDigest.getInstance(string).digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Utility.logEx(log, "hashBytes", Utility.wrapEx(noSuchAlgorithmException, ErrorFactory.makeDriverJDBCException("TJ215", string)));
        }
    }

    public static String quoteName(String string) {
        return string != null ? "\"" + string.replaceAll("\"", "\"\"") + "\"" : string;
    }

    public static String unquoteName(String string) {
        return string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1).replaceAll("\"\"", "\"") : string;
    }

    public static String ensureQuotedName(String string) {
        return Utility.quoteName(Utility.unquoteName(string));
    }

    public static String formatStringAsJSON(String string) {
        StringBuffer stringBuffer = new StringBuffer("\"");
        for (char c : string.toCharArray()) {
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\').append(c);
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\u").append(Log.leadingZeros(Integer.toHexString(c), 4));
        }
        return stringBuffer.append("\"").toString();
    }

    public static String formatNameAndValueAsJSON(String string, Object object) {
        if (object instanceof String) {
            object = Utility.formatStringAsJSON((String)object);
        }
        return Utility.formatStringAsJSON(string) + ":" + object;
    }

    public static byte[] concatByteArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static String formatObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.append("]").toString();
    }

    public static String formatIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.append("]").toString();
    }

    public static class HttpResponse {
        public int nCode = -1;
        public String sMessage = null;
        public String sBody = null;
    }

    private static class MinimalTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }
}

