/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ElicitDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitFileParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ElicitFileState;
import com.teradata.jdbc.jdbc_4.statemachine.LobSendState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveContinueSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveSuccessSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class ReceiveInitSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private StatementController controller;
    protected Log log;

    public ReceiveInitSubState(StatementReceiveState statementReceiveState) {
        this.compositeState = statementReceiveState;
        this.controller = statementReceiveState.getController();
        this.log = this.controller.getSession().getLog();
    }

    @Override
    public TDParcelState action() throws SQLException {
        TDParcelState tDParcelState;
        block18: {
            block17: {
                tDParcelState = null;
                Parcel parcel = this.compositeState.getNextParcel();
                if (parcel == null) break block17;
                this.log.debug("Event flavor: " + parcel.getFlavor());
                this.log.debug("StatementState: " + this.compositeState.getController().getStatement().getState());
                block0 : switch (parcel.getFlavor()) {
                    case 8: 
                    case 205: {
                        StatementStatusParcel statementStatusParcel = (StatementStatusParcel)parcel;
                        statementStatusParcel.verifySuccess();
                        if (this.compositeState.getController().getStatement().getState() == 9) {
                            tDParcelState = null;
                            break;
                        }
                        tDParcelState = new ReceiveSuccessSubState(this.compositeState, statementStatusParcel);
                        break;
                    }
                    case 9: 
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        this.log.debug("Error or Failure parcel received: " + errorParcel.getMsg());
                        switch (this.compositeState.getController().getStatement().getState()) {
                            case 9: {
                                this.controller.getStatement().setState(11);
                                break block0;
                            }
                            case 10: {
                                this.controller.getStatement().setState(11);
                                if (this.controller.getStoredException() == null) {
                                    this.controller.setStoredException(ErrorFactory.makeDriverJDBCException("TJ057"));
                                    break block0;
                                }
                                break block18;
                            }
                            case 5: {
                                this.controller.getStatement().setState(6);
                                tDParcelState = null;
                                break block0;
                            }
                            default: {
                                this.controller.setFailedStatementNumber(errorParcel.getStatementNumber());
                                throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode(), errorParcel.getInfo());
                            }
                        }
                    }
                    case 192: {
                        StatementErrorParcel statementErrorParcel = (StatementErrorParcel)parcel;
                        this.log.debug("Statement Error Parcel received: " + statementErrorParcel.getMsg());
                        this.compositeState.setActivityCount(true, 0L);
                        SQLException sQLException = ErrorFactory.makeDatabaseSQLException(statementErrorParcel.getMsg(), statementErrorParcel.getCode() * -1);
                        this.controller.addBatchException(sQLException);
                        EndStatementParcel endStatementParcel = (EndStatementParcel)this.compositeState.scanForEndParcel(true);
                        if (endStatementParcel != null) {
                            tDParcelState = new ReceiveEndSubState(this.compositeState, endStatementParcel);
                            break;
                        }
                        tDParcelState = new ReceiveContinueSubState(this.compositeState, this);
                        break;
                    }
                    case 12: {
                        if (this.controller.getStatement().getState() == 5) {
                            this.controller.getStatement().setState(6);
                        }
                        tDParcelState = null;
                        break;
                    }
                    case 150: {
                        ElicitDataParcel elicitDataParcel = (ElicitDataParcel)parcel;
                        this.controller.getStatement().setState(12);
                        this.compositeState.setReturnState(new LobSendState(this.controller, elicitDataParcel.getToken()));
                        tDParcelState = null;
                        break;
                    }
                    case 151: {
                        ElicitFileParcel elicitFileParcel = (ElicitFileParcel)parcel;
                        this.controller.getStatement().setState(12);
                        this.compositeState.setReturnState(new ElicitFileState(this.controller, elicitFileParcel.getFileName()));
                        tDParcelState = null;
                        break;
                    }
                    default: {
                        this.log.error("Parcel state exception: " + parcel.getFlavor());
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                    }
                }
                break block18;
            }
            this.log.error("Parcel state exception: parcel is null");
            throw ErrorFactory.makeIoJDBCException("TJ330", "ReceiveInitSubState", this.controller.getNetworkIO(), null, this.log);
        }
        return tDParcelState;
    }
}

