/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.sql.SQLException;

public class BearerFlow {
    public static void bearerFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        String string3;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        if (string != null && string.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1572", uRLParameters.getLogMech());
        }
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1573", uRLParameters.getLogMech());
        }
        String string4 = Utility.coalesce(uRLParameters.getJWSAlgorithm(), "RS256");
        if (!(string4.equals("RS256") || string4.equals("RS384") || string4.equals("RS512"))) {
            throw ErrorFactory.makeDriverJDBCException("TJ843", "JWS_ALGORITHM", string4);
        }
        genericTeradataConnection.addExtraClientAttribute("JWS", string4);
        String string5 = "RSA";
        String string6 = "SHA" + string4.substring(2) + "withRSA";
        if (log.isDebugEnabled()) {
            log.debug("sJWSAlgorithm=" + string4);
            log.debug("sKeyFactory=" + string5);
            log.debug("sSignatureAlgorithm=" + string6);
        }
        if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "LOGDATA", uRLParameters.getLogMech());
        }
        if (uRLParameters.getJWSPrivateKey() == null || uRLParameters.getJWSPrivateKey().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1582", "JWS_PRIVATE_KEY", uRLParameters.getLogMech());
        }
        String[] stringArray = new String[1];
        PrivateKey privateKey = Utility.loadPrivateKeyFromFile(log, string5, uRLParameters.getJWSPrivateKey(), stringArray);
        String string7 = uRLParameters.getJWSCert() != null && uRLParameters.getJWSCert().length() > 0 ? BearerFlow.loadX509Thumbprint(log, privateKey, uRLParameters.getJWSPrivateKey(), uRLParameters.getJWSCert()) : null;
        GenericTeradataConnection genericTeradataConnection2 = ConnectionFactory.makeLogMechNoneConnection(genericTeradataConnection);
        if (genericTeradataConnection2.getGtwConfig() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderURL() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderClientID() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string8 = Utility.coalesce(uRLParameters.getOIDCMetadata(), genericTeradataConnection2.getGtwConfig().getIdentityProviderURL());
        String string9 = uRLParameters.getOIDCClientID();
        if (string9 == null) {
            string9 = genericTeradataConnection2.getGtwConfig().getIdentityProviderClientID();
        }
        if ((string3 = uRLParameters.getOIDCScope()) == null) {
            string3 = genericTeradataConnection2.getGtwConfig().getOIDCScope();
        }
        if (string3 == null) {
            string3 = "openid";
        }
        if (log.isDebugEnabled()) {
            log.debug("sIdProURL=" + string8);
            log.debug("sClientID=" + string9);
            log.debug("sOIDCScope=" + string3);
        }
        if ((string8 = string8.replaceFirst("/+$", "")).length() == 0 || string9.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string10 = "/.well-known/openid-configuration";
        if (!string8.toLowerCase().endsWith(string10)) {
            string8 = string8 + string10;
            if (log.isDebugEnabled()) {
                log.debug("Modified sIdProURL=" + string8);
            }
        }
        String string11 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"GET", (String)string8, null, null, (boolean)true, (int[])new int[]{200}).sBody;
        String string12 = Utility.getStringFromJSON("token_endpoint", string11, "TJ1544", string8);
        String string13 = "{\"alg\": \"" + string4 + "\"" + (stringArray[0] != null ? ", \"kid\": \"" + stringArray[0] + "\"" : "") + ", \"typ\": \"JWT\"" + (string7 != null ? ", \"x5t\": \"" + string7 + "\"" : "") + "}";
        genericTeradataConnection.addExtraClientAttribute("JH", ((stringArray[0] != null ? " kid" : "") + (string7 != null ? " x5t" : "")).trim().replace(' ', ','));
        String string14 = string9;
        String string15 = string9;
        String string16 = string12;
        String string17 = Long.toString(System.currentTimeMillis() / 1000L + 60L);
        String string18 = Utility.base64Encode(true, Utility.getRandomBytes(16));
        String string19 = "{\"iss\": \"" + string14 + "\"" + ", \"sub\": \"" + string15 + "\"" + ", \"aud\": \"" + string16 + "\"" + ", \"exp\": " + string17 + ", \"jti\": \"" + string18 + "\"" + "}";
        if (log.isDebugEnabled()) {
            log.debug("sJSON=" + string11);
            log.debug("sTokenURL=" + string12);
            log.debug("sIssuer=" + string14);
            log.debug("sSubject=" + string15);
            log.debug("sAudience=" + string16);
            log.debug("sExpiration=" + string17);
            log.debug("sUniqueID=" + string18);
            log.debug("sJWTHeader=" + string13);
            log.debug("sPayload=" + string19);
        }
        String string20 = Utility.makeJWT(log, string13, string19, string6, privateKey);
        String string21 = "grant_type=client_credentials&scope=" + Utility.safeForURL(string3) + "&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer" + "&client_assertion=" + string20;
        if (log.isDebugEnabled()) {
            log.debug("sSignedJWT=" + string20);
            log.debug("sFormData=" + string21);
        }
        byte[] byArray = Encoder.encodeStringUTF8(string21);
        string11 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string12, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
        String string22 = uRLParameters.getOIDCToken();
        if (log.isDebugEnabled()) {
            log.debug("sOIDCToken=" + string22);
            log.debug("sJSON=" + string11);
        }
        String string23 = Utility.getStringFromJSON(string22, string11, "TJ1552", string12);
        if (log.isDebugEnabled()) {
            log.debug("sJWT=" + string23);
        }
        uRLParameters.changeLogMech("JWT", "token=" + string23);
    }

    private static void verifyMatchingKeys(Log log, PrivateKey privateKey, String string, X509Certificate x509Certificate, String string2) throws SQLException {
        boolean bl;
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (log.isDebugEnabled()) {
            log.debug("verifyMatchingKeys: privkey class=" + privateKey.getClass().getName() + " pubkey class=" + publicKey.getClass().getName());
        }
        if (!(privateKey instanceof RSAPrivateCrtKey)) {
            throw ErrorFactory.makeDriverJDBCException("TJ1590", string, "JWS_PRIVATE_KEY", "RSAPrivateCrtKey");
        }
        if (!(publicKey instanceof RSAPublicKey)) {
            throw ErrorFactory.makeDriverJDBCException("TJ1591", string2, "JWS_CERT", "RSAPublicKey");
        }
        RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
        RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
        boolean bl2 = bl = rSAPrivateCrtKey.getModulus().equals(rSAPublicKey.getModulus()) && rSAPrivateCrtKey.getPublicExponent().equals(rSAPublicKey.getPublicExponent());
        if (log.isDebugEnabled()) {
            log.debug("verifyMatchingKeys: bMatchingKeyPair=" + bl);
        }
        if (!bl) {
            throw ErrorFactory.makeDriverJDBCException("TJ1592", string, "JWS_PRIVATE_KEY", string2, "JWS_CERT");
        }
    }

    private static String loadX509Thumbprint(Log log, PrivateKey privateKey, String string, String string2) throws SQLException {
        byte[] byArray;
        X509Certificate[] x509CertificateArray = Utility.loadCertificatesFromPEMFile(string2, log, "JWS_CERT", "TJ1589");
        X509Certificate x509Certificate = x509CertificateArray[0];
        BearerFlow.verifyMatchingKeys(log, privateKey, string, x509Certificate, string2);
        try {
            byArray = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw Utility.wrapEx(certificateEncodingException, ErrorFactory.makeDriverJDBCException("TJ1589", string2, "JWS_CERT"));
        }
        byte[] byArray2 = Utility.hashBytes(log, "SHA-1", byArray);
        String string3 = Utility.base64Encode(true, byArray2);
        if (log.isDebugEnabled()) {
            log.debug("loadX509Thumbprint: abyThumbprint=" + Utility.formatByteArrayAsHexDigits(byArray2));
            log.debug("loadX509Thumbprint: sThumbprintBase64=" + string3);
        }
        return string3;
    }
}

