/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.sql.SQLException;

public class SLOBDataParcel
extends Parcel {
    public static final int OVERHEAD = 8;
    protected DeferredLob m_deferredLob;
    private byte[] m_abySlobData;

    public SLOBDataParcel(GenericTeradataConnection genericTeradataConnection) {
        super(genericTeradataConnection);
    }

    public SLOBDataParcel(GenericTeradataConnection genericTeradataConnection, DeferredLob deferredLob) {
        super(genericTeradataConnection);
        this.setFlavor((short)221);
        this.setLength(4 + (int)deferredLob.getDeferredLobByteLengthRead() + 8);
        this.createBuffer(this.getLength());
        this.m_deferredLob = deferredLob;
    }

    public SLOBDataParcel(TDPacketStream tDPacketStream, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.initResponseParcel(tDPacketStream);
        this.m_abySlobData = new byte[this.bodyLength()];
        tDPacketStream.get(this.m_abySlobData);
    }

    public byte[] getSlobData() {
        return this.m_abySlobData;
    }

    @Override
    public TDPacketStream toStream() throws SQLException {
        super.toStream();
        try {
            this.buffer.putLong(this.m_deferredLob.getDeferredLobByteLengthRead());
            this.m_deferredLob.writeDeferredLob(this.buffer, (int)this.m_deferredLob.getDeferredLobByteLengthRead());
        }
        catch (IOException iOException) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ804", iOException.getMessage());
            sQLException.initCause(sQLException);
            throw sQLException;
        }
        this.buffer.flip();
        return this.buffer;
    }
}

