/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.security.Security;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeraDriver
implements Driver {
    protected static Log sm_log = new Log("TeraDriver/" + TeraDriver.class.getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    private static final int FORMAT_TEXT = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_CSV = 3;
    private static Calendar DUMMY_CALENDAR;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        String string3;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string4 = "";
        String string5 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string6 = string.substring(string5.length());
        int n = string6.indexOf("/");
        if (n >= 0) {
            string3 = string6.substring(0, n);
            string4 = string6.substring(n + 1);
        } else {
            string3 = string6.trim();
            string4 = "";
        }
        if (string3.startsWith("[") && string3.endsWith("]")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (properties != null && properties.containsKey("username")) {
            boolean bl2;
            string2 = (String)properties.remove("username");
            boolean bl3 = bl2 = !properties.containsKey("user");
            if (bl2) {
                properties.setProperty("user", string2);
            }
        }
        URLParameters uRLParameters = new URLParameters(string4, properties);
        string2 = uRLParameters.getUser();
        String string7 = uRLParameters.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string3, string2, string7, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)connection;
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    @Override
    public int getMajorVersion() {
        return 20;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)clob;
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)blob;
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        AutoCloseable autoCloseable;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)currentThreadIO.getConnection()).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (autoCloseable = (TDResultSet)resultSetArray[i]) == null || ((TDResultSet)autoCloseable).isClosed()) continue;
            long l = ((TDResultSet)autoCloseable).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)autoCloseable).getRequestNumber() + " stmtnum=" + ((TDResultSet)autoCloseable).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)autoCloseable).getStatementNumber(), ((TDResultSet)autoCloseable).getRequestNumber(), l));
            ((TDResultSet)autoCloseable).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        autoCloseable = (TDStatement)tDSession.createStatement();
        StatementController statementController = new StatementController((TDStatement)autoCloseable, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    private static String quoteText(String string) {
        return string == null ? "null" : "\"" + string.replaceAll("[\r\n]+", " ").replaceAll("\"", "\"\"") + "\"";
    }

    private static String quoteCsvText(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= ' ' && c != ',' && c != '\"') continue;
            return "\"" + string.replaceAll("\"", "\"\"") + "\"";
        }
        return string;
    }

    private static String formatValue(int n, boolean bl, int n2, String string, String string2) {
        if (n == 1) {
            return string + " = " + TeraDriver.quoteText(string2);
        }
        if (n == 2) {
            return (bl ? string + "=" : (n2 > 1 ? " " : "")) + (string2 == null ? "null" : string2.replaceAll("[\r\n]+", "\n"));
        }
        return (n2 > 1 ? "," : "") + (string2 == null ? "" : TeraDriver.quoteCsvText(string2));
    }

    private static void printValue(PrintWriter printWriter, int n, boolean bl, int n2, int n3, String string, String string2) {
        boolean bl2;
        String string3 = TeraDriver.formatValue(n, bl, n2, string, string2);
        boolean bl3 = n == 1 || n == 2 && bl;
        boolean bl4 = bl2 = n2 >= n3;
        if (bl3 || bl2) {
            printWriter.println(string3);
        } else {
            printWriter.print(string3);
        }
    }

    private static void printArray(PrintWriter printWriter, int n, boolean bl, String[][] stringArray) {
        int n2;
        String[] stringArray2 = stringArray[0];
        for (int i = n2 = n == 3 ? 0 : 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            for (int j = 1; j <= stringArray3.length; ++j) {
                TeraDriver.printValue(printWriter, n, bl, j, stringArray3.length, stringArray2[j - 1], stringArray3[j - 1]);
            }
        }
    }

    private static void printNameValue(PrintWriter printWriter, int n, String string, String string2) {
        TeraDriver.printArray(printWriter, n, false, new String[][]{{string}, {string2}});
    }

    private static void printProps(PrintWriter printWriter, int n, Properties properties) {
        Map.Entry[] entryArray = properties == null ? new Map.Entry[]{} : properties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                Comparable comparable = (Comparable)entry.getKey();
                Comparable comparable2 = (Comparable)entry2.getKey();
                return comparable.compareTo(comparable2);
            }
        });
        String[][] stringArray = new String[][]{new String[entryArray.length], new String[entryArray.length]};
        for (int i = 0; i < entryArray.length; ++i) {
            stringArray[0][i] = (String)entryArray[i].getKey();
            stringArray[1][i] = (String)entryArray[i].getValue();
        }
        if (n == 1) {
            printWriter.println("(Properties " + (properties == null ? "null" : "" + entryArray.length) + ")");
        }
        TeraDriver.printArray(printWriter, n, true, stringArray);
    }

    private static String formatCsvHeader(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        return resultSetMetaData.getColumnName(n) + (bl ? " " + resultSetMetaData.getColumnTypeName(n) + (resultSetMetaData.getColumnType(n) == -2 ? "(" + resultSetMetaData.getPrecision(n) + ")" : "") + (resultSetMetaData.getColumnType(n) == 3 ? "(" + resultSetMetaData.getPrecision(n) + (resultSetMetaData.getScale(n) != 0 ? "," + resultSetMetaData.getScale(n) : "") + ")" : "") : "");
    }

    private static String formatAsHexDigits(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string + (string2.length() < 2 ? "0" : "") + string2;
        }
        return string;
    }

    private static byte[] parseHexDigits(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = (string.length() & 1) == 1;
        if (bl) {
            throw new IllegalArgumentException("Odd number of hex digits: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private static void printResultSetMetaData(PrintWriter printWriter, int n, Map<String, Boolean> map, ResultSetMetaData resultSetMetaData) throws SQLException {
        if (!map.values().contains(true)) {
            return;
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n2;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            if (map.get("getCatalogName").booleanValue()) {
                linkedHashMap.put("getCatalogName", "" + resultSetMetaData.getCatalogName(i));
            }
            if (map.get("getColumnClassName").booleanValue()) {
                linkedHashMap.put("getColumnClassName", "" + resultSetMetaData.getColumnClassName(i));
            }
            if (map.get("getColumnDisplaySize").booleanValue()) {
                linkedHashMap.put("getColumnDisplaySize", "" + resultSetMetaData.getColumnDisplaySize(i));
            }
            if (map.get("getColumnLabel").booleanValue()) {
                linkedHashMap.put("getColumnLabel", "" + resultSetMetaData.getColumnLabel(i));
            }
            if (map.get("getColumnName").booleanValue()) {
                linkedHashMap.put("getColumnName", "" + resultSetMetaData.getColumnName(i));
            }
            if (map.get("getColumnType").booleanValue()) {
                linkedHashMap.put("getColumnType", "" + resultSetMetaData.getColumnType(i));
            }
            if (map.get("getColumnTypeName").booleanValue()) {
                linkedHashMap.put("getColumnTypeName", "" + resultSetMetaData.getColumnTypeName(i));
            }
            if (map.get("getPrecision").booleanValue()) {
                linkedHashMap.put("getPrecision", "" + resultSetMetaData.getPrecision(i));
            }
            if (map.get("getScale").booleanValue()) {
                linkedHashMap.put("getScale", "" + resultSetMetaData.getScale(i));
            }
            if (map.get("getSchemaName").booleanValue()) {
                linkedHashMap.put("getSchemaName", "" + resultSetMetaData.getSchemaName(i));
            }
            if (map.get("getTableName").booleanValue()) {
                linkedHashMap.put("getTableName", "" + resultSetMetaData.getTableName(i));
            }
            if (map.get("isAutoIncrement").booleanValue()) {
                linkedHashMap.put("isAutoIncrement", "" + resultSetMetaData.isAutoIncrement(i));
            }
            if (map.get("isCaseSensitive").booleanValue()) {
                linkedHashMap.put("isCaseSensitive", "" + resultSetMetaData.isCaseSensitive(i));
            }
            if (map.get("isCurrency").booleanValue()) {
                linkedHashMap.put("isCurrency", "" + resultSetMetaData.isCurrency(i));
            }
            if (map.get("isDefinitelyWritable").booleanValue()) {
                linkedHashMap.put("isDefinitelyWritable", "" + resultSetMetaData.isDefinitelyWritable(i));
            }
            if (map.get("isNullable").booleanValue()) {
                linkedHashMap.put("isNullable", "" + resultSetMetaData.isNullable(i));
            }
            if (map.get("isReadOnly").booleanValue()) {
                linkedHashMap.put("isReadOnly", "" + resultSetMetaData.isReadOnly(i));
            }
            if (map.get("isSearchable").booleanValue()) {
                linkedHashMap.put("isSearchable", "" + resultSetMetaData.isSearchable(i));
            }
            if (map.get("isSigned").booleanValue()) {
                linkedHashMap.put("isSigned", "" + resultSetMetaData.isSigned(i));
            }
            if (map.get("isWritable").booleanValue()) {
                linkedHashMap.put("isWritable", "" + resultSetMetaData.isWritable(i));
            }
            ArrayList arrayList = new ArrayList(linkedHashMap.entrySet());
            if (n == 3 && i == 1) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), null, (String)((Map.Entry)arrayList.get(n2)).getKey());
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), (String)((Map.Entry)arrayList.get(n2)).getKey() + "(" + i + ")", (String)((Map.Entry)arrayList.get(n2)).getValue());
            }
        }
    }

    private static void printResultSet(PrintWriter printWriter, int n, Map<String, Boolean> map, boolean bl, String string, ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TeraDriver.printResultSetMetaData(printWriter, n, map, resultSetMetaData);
        if (n == 3) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), null, TeraDriver.formatCsvHeader(resultSetMetaData, n2, bl));
            }
        }
        while (resultSet.next()) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                Comparable<Calendar> comparable;
                String string2 = (string != null ? string + " " : "") + "Row " + resultSet.getRow() + " Column " + n2 + " " + TeraDriver.quoteText(resultSetMetaData.getColumnName(n2)) + " " + resultSetMetaData.getColumnTypeName(n2) + "(" + resultSetMetaData.getPrecision(n2) + ")";
                String string3 = resultSetMetaData.getColumnType(n2) == 2004 || resultSetMetaData.getColumnType(n2) == -2 || resultSetMetaData.getColumnType(n2) == -3 || resultSetMetaData.getColumnType(n2) == -4 ? TeraDriver.formatAsHexDigits(resultSet.getBytes(n2)) : (resultSetMetaData.getColumnType(n2) == 92 ? ((comparable = resultSet.getTimestamp(n2)) == null ? null : ((Timestamp)comparable).toString().substring("1970-01-01 ".length())) : resultSet.getString(n2));
                if (string3 != null && resultSetMetaData.getColumnTypeName(n2).endsWith(" WITH TIME ZONE")) {
                    comparable = Calendar.getInstance();
                    resultSet.getTimestamp(n2, (Calendar)comparable);
                    string3 = string3 + TDPreparedStatement.formatTimeZone(((Calendar)comparable).getTimeZone());
                }
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), string2, string3);
            }
        }
    }

    private static void printUpdateCounts(PrintWriter printWriter, int n, int[] nArray) {
        if (n == 3) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, null, "Update Counts");
        }
        for (int i = 0; i < nArray.length; ++i) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, "Update count " + (i + 1), "" + nArray[i]);
        }
    }

    private static CsvHeader[] parseCsvHeaders(String[] stringArray) {
        CsvHeader[] csvHeaderArray = new CsvHeader[stringArray.length];
        block0: for (int i = 0; i < csvHeaderArray.length; ++i) {
            CsvHeader csvHeader;
            csvHeaderArray[i] = csvHeader = new CsvHeader();
            csvHeader.sHeader = stringArray[i];
            csvHeader.nType = 1111;
            if (csvHeader.sHeader == null) continue;
            for (int j = 0; j < TypeDesc.types.length; ++j) {
                Matcher matcher = Pattern.compile("(?i).* " + TypeDesc.types[j].sTypeName + "(?:\\(([0-9]+)(?:,([0-9]+))?\\))?").matcher(csvHeader.sHeader);
                if (!matcher.matches()) continue;
                csvHeader.sTypeName = TypeDesc.types[j].sTypeName;
                csvHeader.nType = TypeDesc.types[j].nType;
                csvHeader.bTimeZone = csvHeader.sTypeName.endsWith(" WITH TIME ZONE");
                if (matcher.group(2) != null) {
                    csvHeader.nScale = Integer.parseInt(matcher.group(2));
                    continue block0;
                }
                if (matcher.group(1) == null) continue block0;
                csvHeader.nScale = Integer.parseInt(matcher.group(1));
                continue block0;
            }
        }
        return csvHeaderArray;
    }

    private static String[] readCsvRow(PeekReader peekReader) throws IOException {
        if (peekReader.peek() < 0) {
            return null;
        }
        StringList stringList = new StringList();
        stringList.add(null);
        boolean bl = false;
        int n;
        while ((n = peekReader.read()) >= 0) {
            if (bl) {
                if (n != 34) {
                    stringList.append(n);
                    continue;
                }
                if (peekReader.peek() == 34) {
                    stringList.append(peekReader.read());
                    continue;
                }
                bl = false;
                continue;
            }
            if (n == 44) {
                stringList.add(null);
                continue;
            }
            if (n == 34) {
                bl = true;
                continue;
            }
            if (n == 13) continue;
            if (n == 10) {
                return stringList.toStringArray();
            }
            stringList.append(n);
        }
        return stringList.toStringArray();
    }

    private static void bindValue(PreparedStatement preparedStatement, int n, int n2, CsvHeader csvHeader, String string) {
        try {
            if (csvHeader.nType == -6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setByte(n2, Byte.parseByte(string));
                }
            } else if (csvHeader.nType == 5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setShort(n2, Short.parseShort(string));
                }
            } else if (csvHeader.nType == 4) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setInt(n2, Integer.parseInt(string));
                }
            } else if (csvHeader.nType == -5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setLong(n2, Long.parseLong(string));
                }
            } else if (csvHeader.nType == 6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setDouble(n2, Double.parseDouble(string));
                }
            } else if (csvHeader.nType == 3) {
                preparedStatement.setObject(n2, (Object)(string == null ? null : new BigDecimal(string)), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == 2) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                }
            } else if (csvHeader.nType == 2005) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setCharacterStream(n2, (Reader)new StringReader(string), string.length());
                }
            } else if (csvHeader.nType == 2004) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    byte[] byArray = TeraDriver.parseHexDigits(string);
                    preparedStatement.setBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                }
            } else if (csvHeader.nType == -2) {
                preparedStatement.setObject(n2, (Object)TeraDriver.parseHexDigits(string), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == -3 || csvHeader.nType == -4) {
                preparedStatement.setBytes(n2, TeraDriver.parseHexDigits(string));
            } else if (csvHeader.nType == 91) {
                preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
            } else if (csvHeader.nType == 92) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTime(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else if (csvHeader.nType == 93) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTimestamp(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else {
                preparedStatement.setString(n2, string);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error for CSV line " + n + " column " + n2 + " value: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Throwable {
        block174: {
            if (var0.length == 0) {
                System.err.println("Arguments: Command...");
                System.err.println("-i turns on interactive mode to prompt for commands from System.in");
                System.err.println("prompt:message sets the prompt to the specified message");
                System.err.println("exit stops reading commands from the current input source");
                System.err.println("# begins a comment");
                System.err.println("version prints the Teradata JDBC Driver version");
                System.err.println("echo:message prints the specified message");
                System.err.println("pause waits for a line from System.in");
                System.err.println("prop:name=value sets the property name to value for DriverManager.getConnection");
                System.err.println("props:null specifies null Properties for DriverManager.getConnection (the default)");
                System.err.println("props:new specifies new empty Properties for DriverManager.getConnection");
                System.err.println("props:list prints the Properties for DriverManager.getConnection");
                System.err.println("props:filename reads Properties from the specified file for DriverManager.getConnection");
                System.err.println("verbose:connection (the default) and verbose:-connection controls printing connection status");
                System.err.println("jdbc: prefix calls DriverManager.getConnection for the command");
                System.err.println("input:stdin reads commands from System.in until EOF (interactive Ctrl+Z on Windows)");
                System.err.println("input:filename reads commands from the specified file until EOF");
                System.err.println("output:stdout sends output to System.out (the default)");
                System.err.println("output:filename sends output to specified file");
                System.err.println("format:text formats output as text (the default)");
                System.err.println("format:raw avoids formatting output");
                System.err.println("format:csv formats output as comma-separated values");
                System.err.println("ignore:nsql:all ignores all non-SQLException");
                System.err.println("ignore:nsql:none stops for any non-SQLException (the default)");
                System.err.println("ignore:sql:all ignores all SQLException");
                System.err.println("ignore:sql:none stops for any SQLException");
                System.err.println("ignore:sql:code,code,... ignores SQLException with one of the specified error codes");
                System.err.println("System.setProperty:name=value sets the System property name to value");
                System.err.println("System.getProperty:name prints the specified System property");
                System.err.println("System.getProperties prints the Properties from System.getProperties");
                System.err.println("Security.setProperty:name=value sets the Security property name to value");
                System.err.println("Security.getProperty:name prints the specified Security property");
                System.err.println("random:b64:count prints a base64 encoded string of the specified number of random bytes");
                System.err.println("random:b64u:count prints a base64 URL encoded string of the specified number of random bytes");
                System.err.println("random:hex:count prints a hex-format string of the specified number of random bytes");
                System.err.println("http-method:value overrides the default HTTP GET method to specify the HTTP method for the next HTTP request");
                System.err.println("http-header:value adds an HTTP header for the next HTTP request");
                System.err.println("http-params:name=value,name=value,... specifies driver connection parameters for the next HTTP request");
                System.err.println("http://... makes an HTTP request to the specified URL");
                System.err.println("https://... makes an HTTPS request to the specified URL");
                System.err.println("getCatalogs prints the result from DatabaseMetaData.getCatalogs");
                System.err.println("getColumns:catalog,schemaPattern,tableNamePattern,columnNamePattern prints the result from DatabaseMetaData.getColumns");
                System.err.println("getDatabaseProductVersion prints the return value from DatabaseMetaData.getDatabaseProductVersion");
                System.err.println("getDriverVersion prints the return value from DatabaseMetaData.getDriverVersion");
                System.err.println("getSchemas prints the result from DatabaseMetaData.getSchemas");
                System.err.println("getTables:catalog,schemaPattern,tableNamePattern[,tableType]... prints the result from DatabaseMetaData.getTables");
                System.err.println("getURL prints the return value from DatabaseMetaData.getURL");
                System.err.println("nativeSQL:command calls Connection.nativeSQL for the command");
                System.err.println("csvline:string appends comma-separated values from the specified string for use by a subsequent parameterized SQL request");
                System.err.println("readcsv:filename reads comma-separated values from the specified UTF8-encoded file for use by a subsequent parameterized SQL request");
                System.err.println("verbose:dbmd and verbose:-dbmd (the default) controls printing arguments before calling DatabaseMetaData methods");
                System.err.println("verbose:sql and verbose:-sql (the default) controls printing the SQL request before executing");
                System.err.println("verbose:csvtypes and verbose:-csvtypes (the default) controls printing data types in CSV header");
                System.err.println("verbose:updatecounts and verbose:-updatecounts (the default) controls printing update counts after executing");
                System.err.println("verbose:stack and verbose:-stack (the default) controls printing SQLException stack traces");
                System.err.println("agkr:none (the default) does not use the Auto-Generated Key Retrieval feature");
                System.err.println("agkr:generated returns generated keys");
                System.err.println("agkr:index,index,... returns the inserted column values corresponding to the specific column indexes");
                System.err.println("rsmd:none (the default) does not print result set column metadata");
                System.err.println("rsmd:all prints all result set column metadata");
                System.err.println("rsmd:function,function,... prints only the result set column metadata returned from the specified ResultSetMetaData functions");
                System.err.println("Otherwise the SQL request is executed, using parameter values if previously specified");
                return;
            }
            var1_1 = 1;
            var2_2 = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            var3_3 = null;
            try {
                var5_5 = var4_4 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
                try {
                    var6_6 = null;
                    try {
                        var7_7 = null;
                        var8_8 = null;
                        var9_9 = "GET";
                        var10_10 = new StringList();
                        var11_11 = new URLParameters("");
                        var12_12 = null;
                        var13_13 = false;
                        var14_14 = null;
                        var15_15 = new Integer(2);
                        var16_16 = true;
                        var17_17 = false;
                        var18_18 = false;
                        var19_19 = false;
                        var20_20 = false;
                        var21_21 = false;
                        var22_22 = new LinkedHashMap<String, Boolean>();
                        var22_22.put("getCatalogName", false);
                        var22_22.put("getColumnClassName", false);
                        var22_22.put("getColumnDisplaySize", false);
                        var22_22.put("getColumnLabel", false);
                        var22_22.put("getColumnName", false);
                        var22_22.put("getColumnType", false);
                        var22_22.put("getColumnTypeName", false);
                        var22_22.put("getPrecision", false);
                        var22_22.put("getScale", false);
                        var22_22.put("getSchemaName", false);
                        var22_22.put("getTableName", false);
                        var22_22.put("isAutoIncrement", false);
                        var22_22.put("isCaseSensitive", false);
                        var22_22.put("isCurrency", false);
                        var22_22.put("isDefinitelyWritable", false);
                        var22_22.put("isNullable", false);
                        var22_22.put("isReadOnly", false);
                        var22_22.put("isSearchable", false);
                        var22_22.put("isSigned", false);
                        var22_22.put("isWritable", false);
                        var23_23 = 0;
                        while (true) lbl-1000:
                        // 82 sources

                        {
                            var24_24 = "";
                            if (var3_3 != null) {
                                if (var3_3 == var2_2 && var8_8 != null) {
                                    var5_5.print(var8_8);
                                    var5_5.flush();
                                }
                                if ((var24_24 = var3_3.readLine()) == null) {
                                    if (var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = null;
                                }
                            }
                            if (var3_3 == null) {
                                if (var23_23 >= var0.length) break block174;
                                var24_24 = var0[var23_23++];
                            }
                            try {
                                if (var24_24.equals("")) ** GOTO lbl-1000
                                if (var24_24.equals("-i")) {
                                    if (var3_3 != null && var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = var2_2;
                                    var8_8 = ">>> ";
                                    var13_13 = true;
                                    var14_14 = new int[]{};
                                }
                                if (var24_24.startsWith("prompt:")) {
                                    var8_8 = var24_24.substring("prompt:".length());
                                }
                                if (var24_24.equals("exit")) {
                                    if (var3_3 != null && var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = null;
                                }
                                if (var24_24.startsWith("#")) ** GOTO lbl-1000
                                if (var24_24.equals("version")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var24_24, Const.DRIVER_VERSION);
                                }
                                if (var24_24.startsWith("echo:")) {
                                    var25_25 = var24_24.substring("echo:".length());
                                    var5_5.println((String)var25_25);
                                }
                                if (var24_24.equals("pause")) {
                                    var5_5.println("Paused. Press Enter to continue:");
                                    var2_2.readLine();
                                }
                                if (var24_24.startsWith("prop:")) {
                                    var25_25 = Pattern.compile("prop:([^=]+)=(.*)").matcher(var24_24);
                                    if (!var25_25.matches()) {
                                        throw new IllegalArgumentException(var24_24);
                                    }
                                    if (var12_12 == null) {
                                        var12_12 = new Properties();
                                    }
                                    var12_12.setProperty(var25_25.group(1), var25_25.group(2));
                                }
                                if (var24_24.startsWith("props:")) {
                                    var25_25 = var24_24.substring("props:".length());
                                    if (var25_25.equals("null")) {
                                        var12_12 = null;
                                    }
                                    if (var25_25.equals("new")) {
                                        var12_12 = new Properties();
                                    }
                                    if (var25_25.equals("list")) {
                                        TeraDriver.printProps(var5_5, var1_1, var12_12);
                                    }
                                    var12_12 = new Properties();
                                    var26_28 = new FileInputStream((String)var25_25);
                                    try {
                                        var12_12.load(var26_28);
                                    }
                                    finally {
                                        var26_28.close();
                                    }
                                }
                                if (var24_24.equals("verbose:connection")) {
                                    var16_16 = true;
                                }
                                if (var24_24.equals("verbose:-connection")) {
                                    var16_16 = false;
                                }
                                if (var24_24.startsWith("jdbc:")) {
                                    if (var6_6 != null) {
                                        var25_25 = var6_6;
                                        var6_6 = null;
                                        var25_25.close();
                                    }
                                    var6_6 = DriverManager.getConnection(var24_24, var12_12);
                                    if (!var16_16) ** GOTO lbl-1000
                                    TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"Status", "Remote", "Version", "Session"}, {var6_6.isClosed() != false ? "Closed" : "Connected", var6_6.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), var6_6.getMetaData().getDatabaseProductVersion(), var6_6.isClosed() != false ? null : var6_6.nativeSQL("{fn teradata_session_number}")}});
                                }
                                if (var24_24.startsWith("input:")) {
                                    var25_25 = var24_24.substring("input:".length());
                                    if (var3_3 != null && var3_3 != var2_2) {
                                        var3_3.close();
                                    }
                                    var3_3 = null;
                                    if (var25_25.equals("stdin")) {
                                        var3_3 = var2_2;
                                    }
                                    var3_3 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)var25_25), "UTF-8"));
                                }
                                if (var24_24.startsWith("output:")) {
                                    var25_25 = var24_24.substring("output:".length());
                                    if (var5_5 != var4_4) {
                                        var5_5.close();
                                    }
                                    var5_5 = var4_4;
                                    if (var25_25.equals("stdout")) ** GOTO lbl-1000
                                    var5_5 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((String)var25_25), "UTF-8"), true);
                                }
                                if (var24_24.startsWith("format:")) {
                                    var25_25 = var24_24.substring("format:".length());
                                    if (var25_25.equals("text")) {
                                        var1_1 = 1;
                                    }
                                    if (var25_25.equals("raw")) {
                                        var1_1 = 2;
                                    }
                                    if (var25_25.equals("csv")) {
                                        var1_1 = 3;
                                    }
                                    throw new IllegalArgumentException("Unknown format " + (String)var25_25);
                                }
                                if (var24_24.equals("ignore:nsql:all")) {
                                    var13_13 = true;
                                }
                                if (var24_24.equals("ignore:nsql:none")) {
                                    var13_13 = false;
                                }
                                if (var24_24.equals("ignore:sql:all")) {
                                    var14_14 = new int[]{};
                                }
                                if (var24_24.equals("ignore:sql:none")) {
                                    var14_14 = null;
                                }
                                if (var24_24.startsWith("ignore:sql:")) {
                                    var25_25 = var24_24.substring("ignore:sql:".length());
                                    var26_29 = var25_25.split(",");
                                    if (var26_29.length == 0) {
                                        throw new IllegalArgumentException(var24_24);
                                    }
                                    var14_14 = new int[var26_29.length];
                                    var27_46 = 0;
                                    while (true) {
                                        if (var27_46 >= var26_29.length) ** GOTO lbl-1000
                                        var14_14[var27_46] = Integer.parseInt(var26_29[var27_46]);
                                        ++var27_46;
                                    }
                                }
                                if (var24_24.startsWith("System.setProperty:")) {
                                    var25_25 = Pattern.compile("System\\.setProperty:([^=]+)=(.*)").matcher(var24_24);
                                    if (!var25_25.matches()) {
                                        throw new IllegalArgumentException(var24_24);
                                    }
                                    System.setProperty(var25_25.group(1), var25_25.group(2));
                                }
                                if (var24_24.startsWith("System.getProperty:")) {
                                    var25_25 = var24_24.substring("System.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var25_25, System.getProperty((String)var25_25));
                                }
                                if (var24_24.equals("System.getProperties")) {
                                    TeraDriver.printProps(var5_5, var1_1, System.getProperties());
                                }
                                if (var24_24.startsWith("Security.setProperty:")) {
                                    var25_25 = Pattern.compile("Security\\.setProperty:([^=]+)=(.*)").matcher(var24_24);
                                    if (!var25_25.matches()) {
                                        throw new IllegalArgumentException(var24_24);
                                    }
                                    Security.setProperty(var25_25.group(1), var25_25.group(2));
                                }
                                if (var24_24.startsWith("Security.getProperty:")) {
                                    var25_25 = var24_24.substring("Security.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var25_25, Security.getProperty((String)var25_25));
                                }
                                if (var24_24.startsWith("random:b64:") || var24_24.startsWith("random:b64u:") || var24_24.startsWith("random:hex:")) {
                                    var25_25 = var24_24.split(":", 3);
                                    var26_30 = Utility.getRandomBytes(Integer.parseInt(var25_25[2]));
                                    TeraDriver.printNameValue(var5_5, var1_1, var24_24, var25_25[1].equals("hex") != false ? Utility.formatByteArrayAsHexDigits(var26_30) : Utility.base64Encode(var25_25[1].equals("b64u"), var26_30));
                                }
                                if (var24_24.startsWith("http-method:")) {
                                    var9_9 = var24_24.substring("http-method:".length()).trim().toUpperCase();
                                }
                                if (var24_24.startsWith("http-header:")) {
                                    var10_10.add(var24_24.substring("http-header:".length()));
                                }
                                if (var24_24.startsWith("http-params:")) {
                                    var11_11 = new URLParameters(var24_24.substring("http-params:".length()));
                                    TeraDriver.sm_log.setLogLevel(var11_11.getLogLevel());
                                }
                                if (var24_24.startsWith("http:") || var24_24.startsWith("https:")) {
                                    var25_25 = var9_9;
                                    var9_9 = "GET";
                                    var26_31 = var10_10.isEmpty() != false ? null : var10_10.toStringArray();
                                    var10_10.clear();
                                    var27_47 = Utility.doHttpRequest(var11_11, TeraDriver.sm_log, (String)var25_25, var24_24, var26_31, null, false, null);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Code", "" + var27_47.nCode);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Message", var27_47.sMessage);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Body", var27_47.sBody);
                                }
                                if (var24_24.equals("verbose:dbmd")) {
                                    var17_17 = true;
                                }
                                if (var24_24.equals("verbose:-dbmd")) {
                                    var17_17 = false;
                                }
                                if (var24_24.equals("verbose:sql")) {
                                    var18_18 = true;
                                }
                                if (var24_24.equals("verbose:-sql")) {
                                    var18_18 = false;
                                }
                                if (var24_24.equals("rsmd:all")) {
                                    var25_25 = var22_22.keySet().iterator();
                                    while (true) {
                                        if (!var25_25.hasNext()) ** GOTO lbl-1000
                                        var26_32 = (String)var25_25.next();
                                        var22_22.put(var26_32, true);
                                    }
                                }
                                if (var24_24.equals("rsmd:none")) {
                                    var25_25 = var22_22.keySet().iterator();
                                    while (true) {
                                        if (!var25_25.hasNext()) ** GOTO lbl-1000
                                        var26_33 = (String)var25_25.next();
                                        var22_22.put(var26_33, false);
                                    }
                                }
                                if (var24_24.startsWith("rsmd:")) {
                                    var25_25 = var24_24.substring("rsmd:".length()).split(",");
                                    if (((Object)var25_25).length == 0) {
                                        throw new IllegalArgumentException(var24_24);
                                    }
                                    for (String var27_48 : var22_22.keySet()) {
                                        var22_22.put(var27_48, false);
                                    }
                                    var26_34 = var25_25;
                                    var27_49 = ((Object)var26_34).length;
                                    var28_55 = 0;
                                    while (true) {
                                        if (var28_55 >= var27_49) ** GOTO lbl-1000
                                        var29_59 = var26_34[var28_55];
                                        if (!var22_22.containsKey(var29_59)) {
                                            throw new IllegalArgumentException((String)var29_59);
                                        }
                                        var22_22.put((String)var29_59, true);
                                        ++var28_55;
                                    }
                                }
                                if (var24_24.equals("verbose:csvtypes")) {
                                    var19_19 = true;
                                }
                                if (var24_24.equals("verbose:-csvtypes")) {
                                    var19_19 = false;
                                }
                                if (var24_24.equals("verbose:updatecounts")) {
                                    var20_20 = true;
                                }
                                if (var24_24.equals("verbose:-updatecounts")) {
                                    var20_20 = false;
                                }
                                if (var24_24.equals("verbose:stack")) {
                                    var21_21 = true;
                                }
                                if (var24_24.equals("verbose:-stack")) {
                                    var21_21 = false;
                                }
                                if (var24_24.equals("agkr:none")) {
                                    var15_15 = new Integer(2);
                                }
                                if (var24_24.equals("agkr:generated")) {
                                    var15_15 = new Integer(1);
                                }
                                if (var24_24.startsWith("agkr:")) {
                                    var25_25 = var24_24.substring("agkr:".length());
                                    var26_35 = var25_25.split(",");
                                    if (var26_35.length == 0) {
                                        throw new IllegalArgumentException(var24_24);
                                    }
                                    var27_50 = new int[var26_35.length];
                                    var15_15 = var27_50;
                                    var28_55 = 0;
                                    while (true) {
                                        if (var28_55 >= var26_35.length) ** GOTO lbl-1000
                                        var27_50[var28_55] = Integer.parseInt(var26_35[var28_55]);
                                        ++var28_55;
                                    }
                                }
                                if (var24_24.startsWith("csvline:")) {
                                    var25_25 = var24_24.substring("csvline:".length()) + "\n";
                                    var26_36 = new ByteArrayInputStream(var25_25.getBytes("UTF-8"));
                                    var7_7 = var7_7 == null ? var26_36 : new SequenceInputStream(var7_7, var26_36);
                                }
                                if (var24_24.startsWith("readcsv:")) {
                                    var25_25 = var24_24.substring("readcsv:".length());
                                    var26_37 = new FileInputStream((String)var25_25);
                                    var7_7 = var7_7 == null ? var26_37 : new SequenceInputStream(var7_7, var26_37);
                                }
                                if (var6_6 == null) {
                                    throw new IllegalArgumentException("No connection available for " + var24_24);
                                }
                                if (var24_24.equals("getCatalogs")) {
                                    var25_25 = var6_6.getMetaData().getCatalogs();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, "getCatalogs", (ResultSet)var25_25);
                                    }
                                    finally {
                                        var25_25.close();
                                    }
                                }
                                if (var24_24.equals("getSchemas")) {
                                    var25_25 = var6_6.getMetaData().getSchemas();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, "getSchemas", (ResultSet)var25_25);
                                    }
                                    finally {
                                        var25_25.close();
                                    }
                                }
                                if (var24_24.startsWith("getTables:")) {
                                    var25_25 = var24_24.substring("getTables:".length()).split(",", -1);
                                    if (((Object)var25_25).length < 3) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var24_24);
                                    }
                                    for (var26_38 = 0; var26_38 < ((Object)var25_25).length; ++var26_38) {
                                        if (!"null".equals(var25_25[var26_38])) continue;
                                        var25_25[var26_38] = null;
                                    }
                                    v0 = var26_39 = ((Object)var25_25).length <= 3 ? null : (String[])Arrays.copyOfRange(var25_25, 3, ((Object)var25_25).length);
                                    if (var17_17) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getTables catalog", "getTables schemaPattern", "getTables tableNamePattern", "getTables tableTypes"}, {var25_25[0], var25_25[1], var25_25[2], var26_39 == null ? null : Arrays.toString(var26_39)}});
                                    }
                                    var27_51 = var6_6.getMetaData().getTables((String)var25_25[0], (String)var25_25[1], (String)var25_25[2], (String[])var26_39);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, "getTables", var27_51);
                                    }
                                    finally {
                                        var27_51.close();
                                    }
                                }
                                if (var24_24.startsWith("getColumns:")) {
                                    var25_25 = var24_24.substring("getColumns:".length()).split(",", -1);
                                    if (((Object)var25_25).length != 4) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var24_24);
                                    }
                                    for (var26_40 = 0; var26_40 < ((Object)var25_25).length; ++var26_40) {
                                        if (!"null".equals(var25_25[var26_40])) continue;
                                        var25_25[var26_40] = null;
                                    }
                                    if (var17_17) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getColumns catalog", "getColumns schemaPattern", "getColumns tableNamePattern", "getColumns columnNamePattern"}, {var25_25[0], var25_25[1], var25_25[2], var25_25[3]}});
                                    }
                                    var26_41 = var6_6.getMetaData().getColumns((String)var25_25[0], (String)var25_25[1], (String)var25_25[2], (String)var25_25[3]);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, "getColumns", var26_41);
                                    }
                                    finally {
                                        var26_41.close();
                                    }
                                }
                                if (var24_24.equals("getDatabaseProductVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var24_24, var6_6.getMetaData().getDatabaseProductVersion());
                                }
                                if (var24_24.equals("getDriverVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var24_24, var6_6.getMetaData().getDriverVersion());
                                }
                                if (var24_24.equals("getURL")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var24_24, var6_6.getMetaData().getURL());
                                }
                                if (var24_24.startsWith("nativeSQL:")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "nativeSQL", var6_6.nativeSQL(var24_24.substring("nativeSQL:".length())));
                                }
                                if (var7_7 != null) {
                                    try {
                                        var25_25 = new PeekReader(new InputStreamReader(var7_7, "UTF-8"));
                                        try {
                                            var26_42 = TeraDriver.readCsvRow((PeekReader)var25_25);
                                            if (var26_42 == null) {
                                                throw new IllegalArgumentException("CSV header line is missing and no CSV data lines are available");
                                            }
                                            var27_52 = TeraDriver.parseCsvHeaders(var26_42);
                                            if (var18_18) {
                                                var5_5.println(var24_24);
                                            }
                                            var28_56 = var15_15 instanceof int[] != false ? var6_6.prepareStatement(var24_24, (int[])var15_15) : var6_6.prepareStatement(var24_24, (Integer)var15_15);
                                            try {
                                                var29_60 = 0;
                                                while (true) {
                                                    if ((var30_63 = TeraDriver.readCsvRow((PeekReader)var25_25)) == null && var29_60 >= 2 || var30_63 != null && var29_60 >= 1) {
                                                        var28_56.addBatch();
                                                    }
                                                    if (var30_63 == null) break;
                                                    if (var30_63.length != var27_52.length) {
                                                        throw new IllegalArgumentException("CSV data line " + var25_25.lineNumber + " contains " + var30_63.length + " values instead of the expected " + var27_52.length + " values");
                                                    }
                                                    for (var31_67 = 0; var31_67 < var30_63.length; ++var31_67) {
                                                        TeraDriver.bindValue(var28_56, var25_25.lineNumber, var31_67 + 1, var27_52[var31_67], var30_63[var31_67]);
                                                    }
                                                    ++var29_60;
                                                }
                                                var30_61 = false;
                                                if (var29_60 >= 2) {
                                                    var31_68 = var28_56.executeBatch();
                                                    if (var20_20) {
                                                        TeraDriver.printUpdateCounts(var5_5, var1_1, var31_68);
                                                    }
                                                } else {
                                                    var30_61 = var28_56.execute();
                                                    if (!var30_61 && var20_20) {
                                                        TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var28_56.getUpdateCount());
                                                    }
                                                }
                                                if (var30_61) {
                                                    var31_65 = var28_56.getResultSet();
                                                    try {
                                                        TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, null, var31_65);
                                                    }
                                                    finally {
                                                        var31_65.close();
                                                    }
                                                }
                                                var31_65 = var28_56.getGeneratedKeys();
                                                try {
                                                    TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, var15_15 instanceof int[] != false ? "Inserted" : "Generated", var31_65);
                                                }
                                                finally {
                                                    var31_65.close();
                                                }
                                            }
                                            finally {
                                                var28_56.close();
                                            }
                                        }
                                        finally {
                                            var25_25.close();
                                        }
                                    }
                                    finally {
                                        var7_7 = null;
                                    }
                                }
                                var25_25 = var6_6.createStatement();
                                try {
                                    if (var18_18) {
                                        var5_5.println(var24_24);
                                    }
                                    var26_43 = var15_15 instanceof int[] != false ? var25_25.execute(var24_24, (int[])var15_15) : var25_25.execute(var24_24, (Integer)var15_15);
                                    while (true) {
                                        if (!var26_43 && var25_25.getUpdateCount() == -1) ** GOTO lbl-1000
                                        if (var26_43) {
                                            var27_53 = var25_25.getResultSet();
                                            try {
                                                TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, null, var27_53);
                                            }
                                            finally {
                                                var27_53.close();
                                            }
                                        }
                                        if (var20_20) {
                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var25_25.getUpdateCount());
                                        }
                                        var27_53 = var25_25.getGeneratedKeys();
                                        try {
                                            TeraDriver.printResultSet(var5_5, var1_1, var22_22, var19_19, var15_15 instanceof int[] != false ? "Inserted" : "Generated", var27_53);
                                        }
                                        finally {
                                            var27_53.close();
                                        }
                                        var26_43 = var25_25.getMoreResults();
                                    }
                                }
                                finally {
                                    var25_25.close();
                                }
                            }
                            catch (SQLException var25_26) {
                                var26_44 = var14_14 != null && var14_14.length == 0;
                                for (var27_54 = 0; !var26_44 && var14_14 != null && var27_54 < var14_14.length; ++var27_54) {
                                    if (var25_26.getErrorCode() != var14_14[var27_54]) continue;
                                    var26_44 = true;
                                }
                                if (var26_44) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var25_26);
                                }
                                var27_54 = 0;
                                for (var28_57 = var25_26; var28_57 != null; var28_57 = var28_57.getNextException()) {
                                    ++var27_54;
                                }
                                var28_58 = 1;
                                for (var29_59 = var25_26; var29_59 != null; var29_59 = var29_59.getNextException()) {
                                    var30_64 = new StringWriter();
                                    var29_59.printStackTrace(new PrintWriter((Writer)var30_64, true));
                                    var5_5.println("SQLException " + var28_58 + " of " + var27_54 + ": " + (var21_21 != false ? "" + var30_64 : "" + var29_59));
                                    ++var28_58;
                                }
                                throw var25_26;
                            }
                            catch (Throwable var25_27) {
                                if (var13_13) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var25_27);
                                    continue;
                                }
                                throw var25_27;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                        finally {
                            if (var7_7 != null) {
                                var7_7.close();
                            }
                        }
                    }
                    finally {
                        if (var6_6 != null) {
                            var6_6.close();
                        }
                    }
                }
                finally {
                    if (var5_5 != var4_4) {
                        var5_5.close();
                    }
                }
            }
            finally {
                if (var3_3 != null && var3_3 != var2_2) {
                    var3_3.close();
                }
            }
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            sm_log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
        DUMMY_CALENDAR = Calendar.getInstance();
    }

    private static class StringList
    extends ArrayList {
        public String[] toStringArray() {
            return this.toArray(new String[0]);
        }

        public void append(int n) {
            int n2 = this.size() - 1;
            String string = (String)this.get(n2);
            if (string == null) {
                string = "";
            }
            this.set(n2, string + (char)n);
        }
    }

    private static class PeekReader
    extends PushbackReader {
        public int lineNumber = 0;

        public PeekReader(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n == 10) {
                ++this.lineNumber;
            }
            return n;
        }

        public int peek() throws IOException {
            int n = super.read();
            if (n >= 0) {
                this.unread(n);
            }
            return n;
        }
    }

    private static class CsvHeader {
        public String sHeader;
        public int nType;
        public String sTypeName;
        public boolean bTimeZone;
        public int nScale;

        private CsvHeader() {
        }
    }

    private static class TypeDesc {
        public String sTypeName;
        public int nType;
        public static TypeDesc[] types = new TypeDesc[]{new TypeDesc("BYTEINT", -6), new TypeDesc("SMALLINT", 5), new TypeDesc("INTEGER", 4), new TypeDesc("BIGINT", -5), new TypeDesc("FLOAT", 6), new TypeDesc("DECIMAL", 3), new TypeDesc("NUMBER", 2), new TypeDesc("CLOB", 2005), new TypeDesc("CHAR", 1), new TypeDesc("VARCHAR", 12), new TypeDesc("LONGVARCHAR", -1), new TypeDesc("BLOB", 2004), new TypeDesc("BYTE", -2), new TypeDesc("VARBYTE", -3), new TypeDesc("LONGVARBYTE", -4), new TypeDesc("DATE", 91), new TypeDesc("TIME", 92), new TypeDesc("TIME WITH TIME ZONE", 92), new TypeDesc("TIMESTAMP", 93), new TypeDesc("TIMESTAMP WITH TIME ZONE", 93)};

        private TypeDesc(String string, int n) {
            this.sTypeName = string;
            this.nType = n;
        }
    }
}

