/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignParcel;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.AuthMechParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConnectParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SSORequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionOptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import org.ietf.jgss.Oid;

public class GenericLogonController {
    private LogonInformation m_logonInfo;
    private GenericTeradataConnection m_con;
    private Reconnect m_reconnect;
    private boolean m_bConfigOnly;

    public GenericLogonController(GenericTeradataConnection genericTeradataConnection) {
        this.m_logonInfo = genericTeradataConnection.getLogonInformation();
        this.m_con = genericTeradataConnection;
    }

    public void setReconnect(Reconnect reconnect) {
        this.m_reconnect = reconnect;
    }

    public void setConfigOnly() {
        this.m_bConfigOnly = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws SQLException {
        Parcel parcel;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        TDPacket tDPacket;
        Log log;
        block80: {
            String string;
            Object object7;
            Object object8;
            block81: {
                boolean bl;
                boolean bl2;
                Oid oid;
                Oid oid2;
                Oid oid3;
                boolean bl3;
                Object object9;
                block82: {
                    log = this.m_con.getLog();
                    tDPacket = this.m_con.createPacket(1);
                    if (log.isDebugEnabled()) {
                        log.debug("GenericLogonController.run: reconnect=" + (this.m_reconnect != null) + " ConfigResponse=" + (this.m_con.getConfigResponse() != null) + " GtwConfig=" + (this.m_con.getGtwConfig() != null) + " AuthMech=" + !this.m_con.getAuthMechParcels().isEmpty() + " m_bConfigOnly=" + this.m_bConfigOnly);
                    }
                    tDPacket.setInitParcelPosition();
                    tDPacket.setLANKind((byte)10);
                    tDPacket.setByteVar((byte)7);
                    tDPacket.setHostCharSet((byte)-1);
                    if (this.m_reconnect != null) {
                        tDPacket.setSessionNumber(this.m_con.getSessionNum());
                        tDPacket.setAuthentication(this.m_reconnect.nAuthenticationNonce);
                    }
                    ClientConfigParcel clientConfigParcel = new ClientConfigParcel(this.m_con);
                    tDPacket.addParcel(clientConfigParcel);
                    tDPacket.toStream();
                    tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                    tDPacket.clear();
                    tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                    tDPacket.initParcelFactory(this.m_con);
                    ArrayList<AuthMechParcel> arrayList = new ArrayList<AuthMechParcel>();
                    block30: while ((object6 = tDPacket.nextParcel()) != null) {
                        switch (((Parcel)object6).getFlavor()) {
                            case 43: {
                                object9 = (ConfigRspParcel)object6;
                                this.m_con.setConfigResponse((ConfigRspParcel)object9);
                                continue block30;
                            }
                            case 165: {
                                object8 = (GtwConfigParcel)object6;
                                this.m_con.setGtwConfig((GtwConfigParcel)object8);
                                continue block30;
                            }
                            case 167: {
                                object7 = (AuthMechParcel)object6;
                                arrayList.add((AuthMechParcel)object7);
                                continue block30;
                            }
                            case 9: {
                                FailureParcel failureParcel = (FailureParcel)object6;
                                throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                            }
                            case 49: {
                                ErrorParcel errorParcel = (ErrorParcel)object6;
                                throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                            }
                        }
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object6).getFlavor()));
                    }
                    this.m_con.setAuthMechParcels(arrayList);
                    if (this.m_con.getConfigResponse() == null || this.m_con.getGtwConfig() == null || this.m_con.getAuthMechParcels().isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ1560");
                    }
                    if (this.m_bConfigOnly) {
                        return;
                    }
                    object6 = this.m_con.getTeraEncrypt();
                    object9 = new ArrayList();
                    object8 = null;
                    object7 = null;
                    for (AuthMechParcel authMechParcel : this.m_con.getAuthMechParcels()) {
                        if (log.isDebugEnabled()) {
                            log.debug("New Server Mechanism: " + ((GenericTeraEncrypt)object6).getMechNameForOid(authMechParcel.getMechOid()) + "   " + authMechParcel.getMechOid());
                        }
                        object9.add(authMechParcel.getMechOid());
                        if (authMechParcel.isDefaultMechanism()) {
                            object8 = authMechParcel.getMechOid();
                            if (log.isDebugEnabled()) {
                                log.debug(" Default Server Mechanism is: " + authMechParcel.getMechOid());
                            }
                        }
                        if (!authMechParcel.isDefaultNegotiatingMechanism()) continue;
                        object7 = authMechParcel.getMechOid();
                        if (!log.isDebugEnabled()) continue;
                        log.debug(" Negotiation Mechanism Supported: " + this.m_con.getGtwConfig().isNegotiationMechanismSupported() + "   Default Server Negotiating Mechanism is: " + authMechParcel.getMechOid());
                    }
                    string = this.m_con.getURLParameters().getLogMech();
                    if ("NONE".equalsIgnoreCase(string)) {
                        this.m_con.getIO().close();
                        return;
                    }
                    if (object9.isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ334");
                    }
                    bl3 = false;
                    oid3 = null;
                    oid2 = ((GenericTeraEncrypt)object6).getClientDefaultMech(false);
                    Oid oid4 = oid = this.m_con.getGtwConfig().isNegotiationMechanismSupported() ? ((GenericTeraEncrypt)object6).getClientDefaultMech(true) : null;
                    if (string == null && oid2 == null && oid == null) break block81;
                    if (string != null && (oid3 = ((GenericTeraEncrypt)object6).getOidForName(string)) == null) {
                        throw ErrorFactory.makeDriverJDBCException("TJ335", string);
                    }
                    boolean bl4 = false;
                    bl2 = false;
                    bl = false;
                    object5 = object9.iterator();
                    while (object5.hasNext()) {
                        object4 = (Oid)object5.next();
                        if (oid3 != null && oid3.equals(object4)) {
                            bl4 = true;
                        }
                        if (oid2 != null && oid2.equals(object4)) {
                            bl2 = true;
                        }
                        if (oid == null || !oid.equals(object4)) continue;
                        bl = true;
                    }
                    if (!bl4) break block82;
                    object3 = oid3;
                    break block80;
                }
                if (bl) {
                    object3 = oid;
                    bl3 = true;
                    break block80;
                } else if (bl2) {
                    object3 = oid2;
                    bl3 = true;
                    break block80;
                } else {
                    object5 = null;
                    if (oid3 != null) {
                        object5 = string;
                    } else if (oid != null) {
                        object5 = oid.toString();
                    } else if (oid2 != null) {
                        object5 = oid2.toString();
                    }
                    object4 = new StringBuffer(Log.LINE_SEP + ErrorMessage.Format1(ErrorMessage.messages.getString("TJ340"), (String)object5) + Log.LINE_SEP + ErrorMessage.messages.getString("TJ337"));
                    Iterator iterator = object9.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw ErrorFactory.makeDriverJDBCException("TJ341", ((StringBuffer)object4).toString());
                        }
                        Oid oid5 = (Oid)iterator.next();
                        ((StringBuffer)object4).append(Log.LINE_SEP + ((GenericTeraEncrypt)object6).getMechNameForOid(oid5) + "  " + oid5);
                    }
                }
            }
            if (this.m_con.getGtwConfig().isNegotiationMechanismSupported() && object7 != null) {
                object3 = object7;
            } else {
                if (object8 == null) {
                    throw ErrorFactory.makeDriverJDBCException("TJ333", string);
                }
                object3 = object8;
            }
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)2 : 1);
        tDPacket.setByteVar((byte)7);
        tDPacket.setAuthentication(this.m_reconnect != null ? this.m_reconnect.nAuthenticationNonce : this.m_con.getAuthenticationNonce());
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        if (this.m_reconnect != null) {
            tDPacket.setSessionNumber(this.m_con.getSessionNum());
        }
        AssignParcel assignParcel = new AssignParcel(this.m_con);
        ((GenericTeraEncrypt)object6).useAuthMech(this.m_con, (Oid)object3);
        byte[] byArray = ((GenericTeraEncrypt)object6).getIntoken();
        byte[] byArray2 = ((GenericTeraEncrypt)object6).initSecContext(byArray, 0, byArray.length);
        if (byArray2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ343");
        }
        object5 = new SSORequestParcel(this.m_con);
        ((SSORequestParcel)object5).setTrip(((GenericTeraEncrypt)object6).getTrip());
        ((GenericTeraEncrypt)object6).incTrip();
        ((SSORequestParcel)object5).setAuthData(byArray2);
        ((SSORequestParcel)object5).setMethod(((GenericTeraEncrypt)object6).getSSOAuthMethod());
        tDPacket.addParcel((Parcel)object5);
        ((GenericTeraEncrypt)object6).updateGeneratedCredentials();
        if (!this.m_con.isExtObjectNameParcelSupported()) {
            assignParcel.setUserName(((GenericTeraEncrypt)object6).isUsingGeneratedCredentials() ? "" : this.m_logonInfo.getUserName());
        }
        tDPacket.addParcel(assignParcel);
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        if (log.isDebugEnabled()) {
            log.debug("packet.getEncryption=" + tDPacket.getEncryption());
        }
        this.m_con.setSessionNum(tDPacket.getLANSessionNumber());
        block34: while ((object4 = tDPacket.nextParcel()) != null) {
            switch (((Parcel)object4).getFlavor()) {
                case 101: {
                    this.m_con.setAssignRspParcel((AssignRspParcel)object4);
                    continue block34;
                }
                case 43: {
                    continue block34;
                }
                case 134: {
                    object2 = (SSOResponseParcel)object4;
                    this.m_con.getTeraEncrypt().setIntoken(((SSOResponseParcel)object2).getAuthData());
                    continue block34;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)object4;
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)object4;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            log.error("AssignRspState receive an un-expected parcel with flavor: " + ((Parcel)object4).getFlavor());
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object4).getFlavor()));
        }
        try {
            byArray = ((GenericTeraEncrypt)object6).getIntoken();
            do {
                tDPacket.clear();
                tDPacket.newLanHeader();
                tDPacket.setInitParcelPosition();
                tDPacket.setLANKind((byte)12);
                tDPacket.setByteVar((byte)7);
                tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
                tDPacket.setSessionNumber(this.m_con.getSessionNum());
                log.debugByteArray("EncryptContextState calling initSecContext with", byArray);
                byArray2 = ((GenericTeraEncrypt)object6).initSecContext(byArray, 0, byArray.length);
                log.debugByteArray("EncryptContextState called initSecContext and got", byArray2);
                ((GenericTeraEncrypt)object6).updateGeneratedCredentials();
                if (byArray2 == null && !((GenericTeraEncrypt)object6).isEstablished()) {
                    byArray2 = new byte[]{};
                }
                if (byArray2 == null) continue;
                tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
                object5 = new SSORequestParcel(this.m_con);
                ((SSORequestParcel)object5).setTrip(((GenericTeraEncrypt)object6).getTrip());
                ((GenericTeraEncrypt)object6).incTrip();
                ((SSORequestParcel)object5).setAuthData(byArray2);
                ((SSORequestParcel)object5).setMethod(((GenericTeraEncrypt)object6).getSSOAuthMethod());
                tDPacket.addParcel((Parcel)object5);
                tDPacket.toStream();
                tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                tDPacket.clear();
                tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                tDPacket.initParcelFactory(this.m_con);
                block36: while ((object4 = tDPacket.nextParcel()) != null) {
                    switch (((Parcel)object4).getFlavor()) {
                        case 134: {
                            object2 = (SSOResponseParcel)object4;
                            byArray = ((SSOResponseParcel)object2).getAuthData();
                            log.debugByteArray("EncryptContextState called getAuthData and got", byArray);
                            continue block36;
                        }
                        case 9: {
                            FailureParcel failureParcel = (FailureParcel)object4;
                            throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                        }
                        case 49: {
                            ErrorParcel errorParcel = (ErrorParcel)object4;
                            throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                        }
                    }
                    throw ErrorFactory.makeIoJDBCException("TJ305", Integer.toString(((Parcel)object4).getFlavor()), this.m_con.getIO(), null, log);
                }
            } while (!((GenericTeraEncrypt)object6).isEstablished());
            if (log.isDebugEnabled()) {
                ((GenericTeraEncrypt)object6).showContext();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw ErrorFactory.makeIoJDBCException("TJ331", "GenericEncryptContextState action", this.m_con.getIO(), throwable, log);
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)4 : 3);
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        if (this.m_reconnect != null) {
            tDPacket.setRequestNumber(this.m_reconnect.nRequestNumber);
            tDPacket.setByteVar((byte)1);
        }
        object4 = new LogonParcel(this.m_con);
        if (!((GenericTeraEncrypt)object6).isUsingGeneratedCredentials()) {
            ((LogonParcel)object4).setLogonInformation(this.m_logonInfo);
        } else {
            object2 = this.m_logonInfo.getAccount();
            if (object2 != null && ((String)object2).length() > 0) {
                object = new LogonInformation(null, null);
                ((LogonInformation)object).setAccount((String)object2);
                ((LogonParcel)object4).setLogonInformation((LogonInformation)object);
            }
        }
        tDPacket.addParcel((Parcel)object4);
        object2 = new SessionOptionsParcel(this.m_con);
        ((SessionOptionsParcel)object2).setSemantics(this.m_con.getTransactionSemantics());
        if (this.m_con.getConfigResponse().statementStatusLevel() >= 1) {
            ((SessionOptionsParcel)object2).setEssFlag((byte)69);
            ((SessionOptionsParcel)object2).setEssLevel((byte)1);
        }
        if (this.m_con.getURLParameters().getConnectFunction() == 1 && this.m_con instanceof TDSession && ((TDSession)this.m_con).useCheckWorkload()) {
            ((SessionOptionsParcel)object2).setCheckWorkload((byte)49);
        }
        if (this.m_con.desiredRedriveLevel() >= 4 && this.m_con.databaseCapableOfRedriveLevel() >= 3) {
            ((SessionOptionsParcel)object2).setRedrive((byte)89);
        }
        tDPacket.addParcel((Parcel)object2);
        object = new ConnectParcel(this.m_con);
        ((ConnectParcel)object).setPartitionName(this.m_con.getURLParameters().getPartition());
        if (this.m_con.getURLParameters().getLogonSequenceNumber() != null) {
            ((ConnectParcel)object).setLogonSequenceNumber(this.m_con.getURLParameters().getLogonSequenceNumber());
        }
        ((ConnectParcel)object).setFunction(this.m_con.getURLParameters().getConnectFunction());
        tDPacket.addParcel((Parcel)object);
        byte by = this.m_con.getConfigResponse().getClientAttributesSupport();
        LogonDataParcel logonDataParcel = new LogonDataParcel(this.m_con.getIO(), this.m_con.getURLParameters().getLssType(), this.m_con);
        if (by <= 1) {
            tDPacket.addParcel(logonDataParcel);
        }
        ClientAttributesParcel clientAttributesParcel = new ClientAttributesParcel(this.m_con);
        if (by >= 1) {
            tDPacket.addParcel(clientAttributesParcel);
        }
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        block37: while (true) {
            if ((parcel = tDPacket.nextParcel()) == null) {
                return;
            }
            switch (parcel.getFlavor()) {
                case 8: 
                case 205: {
                    StatementStatusParcel statementStatusParcel = (StatementStatusParcel)parcel;
                    statementStatusParcel.verifySuccess();
                    if (statementStatusParcel.getSQLWarnings() == null) continue block37;
                    this.m_con.setNeedNewPassword(statementStatusParcel.hasWarningCode(3032));
                    if (this.m_con.supportsPasswordChange()) continue block37;
                    Object object10 = statementStatusParcel.getSQLWarnings();
                    this.m_con.addWarning((SQLWarning)object10);
                    continue block37;
                }
                case 137: {
                    continue block37;
                }
                case 89: {
                    this.m_con.setLogonSequenceNumberParcel((LogonSequenceNumberParcel)parcel);
                    continue block37;
                }
                case 9: {
                    Object object10 = (FailureParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object10).getMsg(), ((ErrorParcel)object10).getCode());
                }
                case 12: {
                    EndRequestParcel endRequestParcel = (EndRequestParcel)parcel;
                    continue block37;
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            break;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
    }

    public static class Reconnect {
        public long nAuthenticationNonce;
        public int nRequestNumber;
    }
}

