/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

public class TeraSQLInput
implements SQLInput {
    protected int m_nIndex = 0;
    protected ResultSetHelper m_helper;
    private Map m_mMap;
    private Class m_clsAppSQLData;
    protected Object[] m_aoAttributes;
    private int[] m_anAttributeTypes;
    private int[] m_anAttributeBaseJDBCTypes;
    private String[] m_asAttributeTypeNames;

    public TeraSQLInput(ResultSetHelper resultSetHelper, Object[] objectArray, int[] nArray, int[] nArray2, String[] stringArray, Map map, Class clazz) {
        this.m_helper = resultSetHelper;
        this.m_aoAttributes = objectArray;
        this.m_anAttributeTypes = nArray;
        this.m_anAttributeBaseJDBCTypes = nArray2;
        this.m_asAttributeTypeNames = stringArray;
        this.m_mMap = map;
        this.m_clsAppSQLData = clazz;
    }

    protected void verifyAttribute(String string, int[] nArray) throws SQLException {
        int n;
        String string2 = this.m_clsAppSQLData.getName() + ".readSQL";
        string = "SQLInput." + string;
        if (this.m_nIndex >= this.m_aoAttributes.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ682", string2, String.valueOf(this.m_nIndex + 1), String.valueOf(this.m_aoAttributes.length));
        }
        int n2 = this.m_anAttributeTypes[this.m_nIndex];
        boolean bl = false;
        for (n = 0; !bl && n < nArray.length; ++n) {
            bl = n2 == nArray[n];
        }
        for (n = 0; !bl && n < nArray.length; ++n) {
            bl = this.m_anAttributeBaseJDBCTypes[this.m_nIndex] == nArray[n];
        }
        if (!bl) {
            throw ErrorFactory.makeDriverJDBCException("TJ681", string2, string, this.m_asAttributeTypeNames[this.m_nIndex]);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_aoAttributes[this.m_nIndex - 1] == null;
    }

    @Override
    public String readString() throws SQLException {
        this.verifyAttribute("readString", new int[]{1, 12, 1111});
        String string = TDResultSet.internalGetString(this.m_helper, this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return string;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLInput.readBoolean");
    }

    @Override
    public byte readByte() throws SQLException {
        this.verifyAttribute("readByte", new int[]{-6});
        byte by = (byte)TDResultSet.internalGetInt(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return by;
    }

    @Override
    public short readShort() throws SQLException {
        this.verifyAttribute("readShort", new int[]{5});
        short s = (short)TDResultSet.internalGetInt(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return s;
    }

    @Override
    public int readInt() throws SQLException {
        this.verifyAttribute("readInt", new int[]{4});
        int n = TDResultSet.internalGetInt(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return n;
    }

    @Override
    public long readLong() throws SQLException {
        this.verifyAttribute("readLong", new int[]{-5});
        long l = TDResultSet.internalGetLong(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return l;
    }

    @Override
    public float readFloat() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLInput.readFloat");
    }

    @Override
    public double readDouble() throws SQLException {
        this.verifyAttribute("readDouble", new int[]{8, 6, 7});
        double d = TDResultSet.internalGetDouble(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return d;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        this.verifyAttribute("readBigDecimal", new int[]{3, 2});
        BigDecimal bigDecimal = TDResultSet.internalGetBigDecimal(this.m_aoAttributes[this.m_nIndex], 0);
        ++this.m_nIndex;
        return bigDecimal;
    }

    @Override
    public byte[] readBytes() throws SQLException {
        this.verifyAttribute("readBytes", new int[]{-2, -3});
        byte[] byArray = TDResultSet.internalGetBytes(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return byArray;
    }

    @Override
    public Date readDate() throws SQLException {
        this.verifyAttribute("readDate", new int[]{91});
        Date date = this.m_aoAttributes[this.m_nIndex] instanceof Date ? (Date)this.m_aoAttributes[this.m_nIndex] : TDResultSet.internalGetDate(this.m_nIndex + 1, this.m_aoAttributes[this.m_nIndex], null);
        ++this.m_nIndex;
        return date;
    }

    @Override
    public Time readTime() throws SQLException {
        this.verifyAttribute("readTime", new int[]{92});
        Time time = this.m_aoAttributes[this.m_nIndex] instanceof Time ? (Time)this.m_aoAttributes[this.m_nIndex] : TDResultSet.internalGetTime(this.m_nIndex + 1, this.m_aoAttributes[this.m_nIndex], null);
        ++this.m_nIndex;
        return time;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        this.verifyAttribute("readTimestamp", new int[]{93});
        Timestamp timestamp = this.m_aoAttributes[this.m_nIndex] instanceof Timestamp ? (Timestamp)this.m_aoAttributes[this.m_nIndex] : TDResultSet.internalGetTimestamp(this.m_nIndex + 1, this.m_aoAttributes[this.m_nIndex], null);
        ++this.m_nIndex;
        return timestamp;
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        this.verifyAttribute("readCharacterStream", new int[]{12, -1});
        Reader reader = TDResultSet.internalGetCharacterStream(this.m_helper, this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return reader;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        this.verifyAttribute("readAsciiStream", new int[]{12, -1});
        InputStream inputStream = TDResultSet.internalGetAsciiStream(this.m_helper, -1, this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return inputStream;
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        this.verifyAttribute("readBinaryStream", new int[]{-3, -4});
        InputStream inputStream = TDResultSet.internalGetBinaryStream(this.m_helper, -1, this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return inputStream;
    }

    @Override
    public Object readObject() throws SQLException {
        this.verifyAttribute("readObject", new int[]{2002, 2001});
        Object object = TDResultSet.internalGetObject(this.m_helper, this.m_nIndex + 1, this.m_aoAttributes[this.m_nIndex], this.m_anAttributeTypes[this.m_nIndex], this.m_anAttributeBaseJDBCTypes[this.m_nIndex], this.m_asAttributeTypeNames[this.m_nIndex], this.m_mMap);
        ++this.m_nIndex;
        return object;
    }

    @Override
    public Ref readRef() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLInput.readRef");
    }

    @Override
    public Blob readBlob() throws SQLException {
        this.verifyAttribute("readBlob", new int[]{2004});
        Blob blob = TDResultSet.internalGetBlob(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return blob;
    }

    @Override
    public Clob readClob() throws SQLException {
        int n = this.m_asAttributeTypeNames[this.m_nIndex].trim().equalsIgnoreCase("JSON") ? 1111 : 2005;
        this.verifyAttribute("readClob", new int[]{n});
        Clob clob = TDResultSet.internalGetClob(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return clob;
    }

    @Override
    public Array readArray() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLInput.readArray");
    }

    @Override
    public URL readURL() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLInput.readURL");
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "readRowId");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        this.verifyAttribute("readSQLXML", new int[]{2009});
        TeraSQLXML teraSQLXML = TDResultSet.internalGetSQLXML(this.m_aoAttributes[this.m_nIndex]);
        ++this.m_nIndex;
        return teraSQLXML;
    }

    @Override
    public String readNString() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "readNString");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "readNClob");
    }
}

