/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc_4.io.CertChecker;
import com.teradata.jdbc.jdbc_4.io.ProxySupport;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;

public class Utility {
    public static final int HELP_SESSION_CURRENT_DATABASE_INDEX = 5;
    public static final int HELP_SESSION_FULL_CURRENT_DATABASE_INDEX = 75;
    public static final int HELP_SESSION_QUERY_BAND_INDEX = 44;
    public static final int HELP_SESSION_TRANSACTION_QUERY_BAND_INDEX = 122;
    public static final int HELP_SESSION_SESSION_QUERY_BAND_INDEX = 123;
    public static final int HELP_SESSION_PROFILE_QUERY_BAND_INDEX = 124;
    public static final int HELP_SESSION_UNICODE_PASS_THROUGH_INDEX = 125;
    public static final int QUERY_BAND_TRANSACTION_INDEX = 0;
    public static final int QUERY_BAND_SESSION_INDEX = 1;
    public static final int QUERY_BAND_PROFILE_INDEX = 2;
    private static SecureRandom sm_rand = new SecureRandom();

    public static String getCurrentDatabaseFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        int n = resultSet.getMetaData().getColumnCount();
        if (n >= 75) {
            return resultSet.getString(75);
        }
        if (n >= 5) {
            return resultSet.getString(5);
        }
        return "";
    }

    public static String getQueryBandFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        String string = "";
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() >= 44) {
            string = resultSet.getString(44);
        }
        return string;
    }

    public static String[] parseQueryBand(String string) {
        if (string == null) {
            throw new IllegalArgumentException("queryBand argument must not be null");
        }
        String[] stringArray = new String[]{"", "", ""};
        if (!string.equals("")) {
            String string2 = "=T> ";
            String string3 = "=S> ";
            int n = string.indexOf(string2);
            int n2 = string.indexOf(string3);
            if (n >= 0 && n2 >= 0) {
                if (n < n2) {
                    stringArray[0] = string.substring(n + string2.length(), n2).trim();
                    stringArray[1] = string.substring(n2 + string3.length()).trim();
                } else {
                    stringArray[0] = string.substring(n + string2.length()).trim();
                    stringArray[1] = string.substring(n2 + string3.length(), n).trim();
                }
            } else if (n >= 0) {
                stringArray[0] = string.substring(n + string2.length()).trim();
            } else if (n2 >= 0) {
                stringArray[1] = string.substring(n2 + string3.length()).trim();
            }
        }
        return stringArray;
    }

    public static void tokenizeQueryBand(Map map, String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n < 0) continue;
            map.put(stringArray[i].substring(0, n), stringArray[i].substring(n + 1));
        }
    }

    public static void sleepForSeconds(int n) {
        long l = (long)n * 1000L;
        Utility.sleepForMilliseconds(l);
    }

    public static void sleepForMilliseconds(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        if (sQLException == null) {
            sQLException = sQLException2;
        } else {
            sQLException.setNextException(sQLException2);
        }
        return sQLException;
    }

    public static String[] getQueryBandStringsFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() >= 124) {
            String[] stringArray = new String[]{resultSet.getString(122), resultSet.getString(123), resultSet.getString(124)};
            return stringArray;
        }
        String string = resultSetMetaData.getColumnCount() >= 44 ? resultSet.getString(44) : "";
        return Utility.parseQueryBand(string);
    }

    public static boolean getUnicodePassThroughFromHelpSessionResultSet(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("rsHelpSession argument must not be null");
        }
        if (resultSet.getMetaData().getColumnCount() < 125) {
            return false;
        }
        String string = resultSet.getString(125);
        if (string == null) {
            return false;
        }
        return string.trim().equals("S");
    }

    public static SQLException wrapEx(Throwable throwable, SQLException sQLException) {
        sQLException.initCause(throwable);
        return sQLException;
    }

    public static SQLException logEx(Log log, String string, SQLException sQLException) {
        if (log.isDebugEnabled()) {
            log.debug(string + ":", sQLException);
        }
        return sQLException;
    }

    public static String getHTTPSProtocol(URLParameters uRLParameters) {
        String string = uRLParameters.getSSLProtocol();
        if (string == null) {
            string = "TLSv1.2";
        }
        return string;
    }

    public static SSLSocketFactory obtainSSLSocketFactory(URLParameters uRLParameters, Log log) throws SQLException {
        SSLContext sSLContext;
        if (uRLParameters.getSSLDebug()) {
            System.setProperty("javax.net.debug", "all");
        }
        String string = Utility.getHTTPSProtocol(uRLParameters);
        if (log.isDebugEnabled()) {
            log.debug("obtainSSLSocketFactory: sHTTPSProtocol=" + string);
        }
        try {
            sSLContext = SSLContext.getInstance(string);
            sSLContext.init(null, new TrustManager[]{new MinimalTrustManager()}, new SecureRandom());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Utility.logEx(log, "obtainSSLSocketFactory", Utility.wrapEx(generalSecurityException, ErrorFactory.makeDriverJDBCException("TJ1555", string)));
        }
        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        if (log.isDebugEnabled()) {
            log.debug("obtainSSLSocketFactory: socketFactory.getDefaultCipherSuites=" + Arrays.asList(sSLSocketFactory.getDefaultCipherSuites()));
        }
        return sSLSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse doHttpRequest(URLParameters uRLParameters, Log log, String string, String string2, String[] stringArray, byte[] byArray, boolean bl, int[] nArray) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("doHttpRequest: sMethod=" + string + " sURL=" + string2 + " asHeaders=" + Utility.formatObjectArray(stringArray) + " anRequiredResponseCodes=" + Utility.formatIntArray(nArray));
        }
        HttpResponse httpResponse = new HttpResponse();
        long l = System.currentTimeMillis();
        try {
            String string3;
            Object object;
            URI uRI = Utility.parseURI(string2, "TJ1571");
            String string4 = uRI.getScheme();
            if (!"http".equals(string4) && !"https".equals(string4)) {
                throw ErrorFactory.makeDriverJDBCException("TJ1570", string4, string2);
            }
            boolean bl2 = "https".equals(string4);
            int n = uRI.getPort() >= 0 ? uRI.getPort() : (bl2 ? 443 : 80);
            String string5 = uRI.getPath() != null && uRI.getPath().length() > 0 ? uRI.getPath() : "/";
            String string6 = uRI.getQuery() != null && uRI.getQuery().length() > 0 ? "?" + uRI.getQuery() : "";
            String string7 = string + " " + string5 + string6 + " HTTP/1.0\r\n" + "Host: " + uRI.getHost() + ":" + n + "\r\n" + "Accept: */*\r\n";
            for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                string7 = string7 + stringArray[i] + "\r\n";
            }
            if (byArray != null) {
                string7 = string7 + "Content-Length: " + byArray.length + "\r\n";
            }
            string7 = string7 + "\r\n";
            byte[] byArray2 = Encoder.encodeStringUTF8(string7);
            if (byArray != null) {
                byArray2 = Utility.concatByteArrays(byArray2, byArray);
            }
            InetSocketAddress inetSocketAddress = new InetSocketAddress(uRI.getHost(), n);
            SSLSocketFactory sSLSocketFactory = bl2 ? Utility.obtainSSLSocketFactory(uRLParameters, log) : null;
            try (Socket socket = ProxySupport.connectSocket(log, uRLParameters, false, false, null, null, true, 10, null, inetSocketAddress, 15000, string4, sSLSocketFactory, null);){
                Object object2;
                if (bl2) {
                    object2 = uRI.getHost();
                    if (((String)object2).startsWith("[") && ((String)object2).endsWith("]")) {
                        object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                    }
                    int n2 = uRLParameters.getOIDCSSLModeLevel();
                    httpResponse.sCertStatus = CertChecker.checkCert(uRLParameters, n2, (SSLSocket)socket, (String)object2, inetSocketAddress, log);
                }
                object2 = socket.getOutputStream();
                try {
                    log.debugPartialByteArray("Transmit HTTP request", byArray2, 0, byArray2.length);
                    ((OutputStream)object2).write(byArray2);
                    ((OutputStream)object2).flush();
                    try (InputStream inputStream = socket.getInputStream();){
                        object = Utility.fullyReadInputStream(inputStream, 1000);
                        log.debugPartialByteArray("Received HTTP response", (byte[])object, 0, ((byte[])object).length);
                        string3 = Decoder.getUTF8DecodedString(object);
                        String[] stringArray2 = string3.split("\r\n\r\n", 2);
                        String string8 = stringArray2[0];
                        httpResponse.sBody = stringArray2.length > 1 ? stringArray2[1] : null;
                        String[] stringArray3 = string8.split("\r\n");
                        Matcher matcher = Pattern.compile("HTTP/[0-9.]+ ([0-9]+) (.*)").matcher(stringArray3[0]);
                        if (matcher.matches()) {
                            httpResponse.nCode = Integer.parseInt(matcher.group(1));
                            httpResponse.sMessage = matcher.group(2);
                        }
                        if (httpResponse.sBody != null && bl) {
                            httpResponse.sBody = httpResponse.sBody.trim().replaceAll("\\s+", " ");
                        }
                    }
                }
                finally {
                    ((OutputStream)object2).close();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("resp.nCode=" + httpResponse.nCode + " resp.sMessage=" + httpResponse.sMessage);
            }
            if (nArray != null) {
                boolean bl3 = false;
                for (int i = 0; !bl3 && i < nArray.length; ++i) {
                    bl3 = httpResponse.nCode == nArray[i];
                }
                if (log.isDebugEnabled()) {
                    log.debug("anRequiredResponseCodes=" + Utility.formatIntArray(nArray) + " bFound=" + bl3);
                }
                if (!bl3) {
                    String string9 = null;
                    object = null;
                    if (httpResponse.nCode == 400 || httpResponse.nCode == 401) {
                        string9 = Utility.getStringFromJSON("error", httpResponse.sBody, null, null);
                        object = Utility.getStringFromJSON("error_description", httpResponse.sBody, null, null);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("sError=" + string9);
                        log.debug("sErrorDesc=" + (String)object);
                    }
                    string3 = httpResponse.nCode + (object != null ? " " + (String)object : (string9 != null ? " " + string9 : (httpResponse.sMessage != null ? " " + httpResponse.sMessage : "")));
                    throw Utility.logEx(log, "doHttpRequest", ErrorFactory.makeDriverJDBCException("TJ1549", string3, string2));
                }
            }
            HttpResponse httpResponse2 = httpResponse;
            if (log.isTimingEnabled()) {
                log.timing("Accessing " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (httpResponse.nCode < 0 ? "failed" : "completed with " + httpResponse.nCode + " " + httpResponse.sMessage));
            }
            return httpResponse2;
        }
        catch (Throwable throwable) {
            try {
                if (log.isTimingEnabled()) {
                    log.timing("Accessing " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (httpResponse.nCode < 0 ? "failed" : "completed with " + httpResponse.nCode + " " + httpResponse.sMessage));
                }
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw Utility.logEx(log, "doHttpRequest", sQLException);
            }
            catch (Throwable throwable2) {
                throw Utility.logEx(log, "doHttpRequest", Utility.wrapEx(throwable2, ErrorFactory.makeDriverJDBCException("TJ1543", string2)));
            }
        }
    }

    public static String getStringFromJSON(String string, String string2, String string3, String string4) throws SQLException {
        String string5;
        Pattern pattern = Pattern.compile("\"" + string + "\"\\s*:\\s*\"([^\"]*)\"");
        Matcher matcher = pattern.matcher(string2);
        String string6 = string5 = matcher.find() ? matcher.group(1) : null;
        if (string5 == null && string3 != null) {
            throw ErrorFactory.makeDriverJDBCException(string3, string, string4);
        }
        return string5;
    }

    public static int getIntFromJSON(String string, String string2, String string3, String string4, int n) throws SQLException {
        String string5;
        Pattern pattern = Pattern.compile("\"" + string + "\"\\s*:\\s*([0-9]+)");
        Matcher matcher = pattern.matcher(string2);
        String string6 = string5 = matcher.find() ? matcher.group(1) : null;
        if (string5 != null) {
            return Integer.parseInt(string5);
        }
        if (string3 != null) {
            throw ErrorFactory.makeDriverJDBCException(string3, string, string4);
        }
        return n;
    }

    public static byte[] resizeByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, byArray2.length));
        return byArray2;
    }

    public static byte[] fullyReadInputStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray, n3, byArray.length - n3)) >= 0) {
            if ((n3 += n2) != byArray.length) continue;
            byArray = Utility.resizeByteArray(byArray, byArray.length + n);
        }
        return Utility.resizeByteArray(byArray, n3);
    }

    public static String readUTF8File(String string, String string2) throws SQLException {
        try {
            return Decoder.getUTF8DecodedString(Files.readAllBytes(Paths.get(string, new String[0])));
        }
        catch (IOException iOException) {
            throw Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException(string2, string));
        }
    }

    public static void threadSleep(Log log, long l) {
        if (log.isTimingEnabled()) {
            log.timing("Sleeping for " + l + " ms");
        }
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (log.isTimingEnabled()) {
            log.timing("Finished sleeping for " + l + " ms");
        }
    }

    public static void waitForThreadDeath(Thread thread) {
        while (thread.isAlive()) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static String safeForURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static URI parseURI(String string, String string2) throws SQLException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException(string2, string);
            sQLException.initCause(uRISyntaxException);
            throw sQLException;
        }
    }

    public static byte[] getRandomBytes(int n) {
        byte[] byArray = new byte[n];
        sm_rand.nextBytes(byArray);
        return byArray;
    }

    public static String base64Encode(boolean bl, byte[] byArray) {
        return bl ? Base64.getUrlEncoder().withoutPadding().encodeToString(byArray) : Base64.getEncoder().encodeToString(byArray);
    }

    public static byte[] hashBytes(Log log, String string, byte[] byArray) throws SQLException {
        try {
            return MessageDigest.getInstance(string).digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Utility.logEx(log, "hashBytes", Utility.wrapEx(noSuchAlgorithmException, ErrorFactory.makeDriverJDBCException("TJ215", string)));
        }
    }

    public static byte[] signBytes(Log log, String string, PrivateKey privateKey, byte[] byArray) throws SQLException {
        try {
            Signature signature = Signature.getInstance(string);
            signature.initSign(privateKey);
            signature.update(byArray);
            return signature.sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Utility.logEx(log, "signBytes", Utility.wrapEx(generalSecurityException, ErrorFactory.makeDriverJDBCException("TJ215", string)));
        }
    }

    public static String makeJWT(Log log, String string, String string2, String string3, PrivateKey privateKey) throws SQLException {
        String string4 = Utility.base64Encode(true, Encoder.encodeStringUTF8(string));
        String string5 = Utility.base64Encode(true, Encoder.encodeStringUTF8(string2));
        String string6 = string4 + "." + string5;
        byte[] byArray = Utility.signBytes(log, string3, privateKey, Encoder.encodeStringUTF8(string6));
        String string7 = Utility.base64Encode(true, byArray);
        String string8 = string6 + "." + string7;
        if (log.isDebugEnabled()) {
            log.debug("makeJWT: sHeader=" + string);
            log.debug("makeJWT: sPayload=" + string2);
            log.debug("makeJWT: sSignatureAlgorithm=" + string3);
            log.debug("makeJWT: privkey=" + privateKey);
            log.debug("makeJWT: sEncodedHeader=" + string4);
            log.debug("makeJWT: sEncodedPayload=" + string5);
            log.debug("makeJWT: sUnsignedJWT=" + string6);
            log.debug("makeJWT: abySignature.length=" + byArray.length + " bits=" + byArray.length * 8);
            log.debug("makeJWT: sEncodedSignature=" + string7);
            log.debug("makeJWT: sOutput=" + string8);
        }
        return string8;
    }

    public static X509Certificate[] loadCertificatesFromPEMFile(String string, Log log, String string2, String string3) throws SQLException {
        try {
            return CertChecker.loadCertificatesFromPEMFile(string, log, string2);
        }
        catch (Exception exception) {
            throw Utility.wrapEx(exception, ErrorFactory.makeDriverJDBCException(string3, string, string2));
        }
    }

    private static PrivateKey loadPrivateKeyFromPEMFile(Log log, String string, String string2) throws SQLException {
        String string3 = Utility.readUTF8File(string2, "TJ1585").trim().replaceAll("\\s+", " ");
        if (log.isDebugEnabled()) {
            log.debug("loadPrivateKeyFromPEMFile: sPEM=" + string3);
        }
        if (!string3.startsWith("-----BEGIN PRIVATE KEY-----") || !string3.endsWith("-----END PRIVATE KEY-----")) {
            throw ErrorFactory.makeDriverJDBCException("TJ1584", string2, "PEM");
        }
        try {
            String string4 = string3.replaceAll("-----[^-]+-----", "").replaceAll("\\s", "");
            if (log.isDebugEnabled()) {
                log.debug("loadPrivateKeyFromPEMFile: sPrivateKey=" + string4);
            }
            byte[] byArray = Base64.getDecoder().decode(Encoder.encodeStringUTF8(string4));
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
        }
        catch (Exception exception) {
            throw Utility.wrapEx(exception, ErrorFactory.makeDriverJDBCException("TJ1586", string2));
        }
    }

    private static PrivateKey loadPrivateKeyFromJWKFile(Log log, String string, String string2, String[] stringArray) throws SQLException {
        String string3 = Utility.readUTF8File(string2, "TJ1585").trim().replaceAll("\\s+", " ");
        if (log.isDebugEnabled()) {
            log.debug("loadPrivateKeyFromJWKFile: sJWK=" + string3);
        }
        if (!string3.startsWith("{") || !string3.endsWith("}")) {
            throw ErrorFactory.makeDriverJDBCException("TJ1584", string2, "JWK");
        }
        String string4 = Utility.getStringFromJSON("kty", string3, "TJ1587", string2);
        if (!string.equals(string4)) {
            throw ErrorFactory.makeDriverJDBCException("TJ1588", string2, string4);
        }
        if (stringArray != null) {
            stringArray[0] = Utility.getStringFromJSON("kid", string3, null, null);
            if (log.isDebugEnabled()) {
                log.debug("loadPrivateKeyFromJWKFile: asOutputKeyID[0]=" + stringArray[0]);
            }
        }
        String string5 = Utility.getStringFromJSON("n", string3, "TJ1587", string2);
        String string6 = Utility.getStringFromJSON("e", string3, "TJ1587", string2);
        String string7 = Utility.getStringFromJSON("d", string3, "TJ1587", string2);
        String string8 = Utility.getStringFromJSON("p", string3, "TJ1587", string2);
        String string9 = Utility.getStringFromJSON("q", string3, "TJ1587", string2);
        String string10 = Utility.getStringFromJSON("dp", string3, "TJ1587", string2);
        String string11 = Utility.getStringFromJSON("dq", string3, "TJ1587", string2);
        String string12 = Utility.getStringFromJSON("qi", string3, "TJ1587", string2);
        try {
            BigInteger bigInteger = new BigInteger(1, Base64.getUrlDecoder().decode(string5));
            BigInteger bigInteger2 = new BigInteger(1, Base64.getUrlDecoder().decode(string6));
            BigInteger bigInteger3 = new BigInteger(1, Base64.getUrlDecoder().decode(string7));
            BigInteger bigInteger4 = new BigInteger(1, Base64.getUrlDecoder().decode(string8));
            BigInteger bigInteger5 = new BigInteger(1, Base64.getUrlDecoder().decode(string9));
            BigInteger bigInteger6 = new BigInteger(1, Base64.getUrlDecoder().decode(string10));
            BigInteger bigInteger7 = new BigInteger(1, Base64.getUrlDecoder().decode(string11));
            BigInteger bigInteger8 = new BigInteger(1, Base64.getUrlDecoder().decode(string12));
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, bigInteger8);
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            return keyFactory.generatePrivate(rSAPrivateCrtKeySpec);
        }
        catch (Exception exception) {
            throw Utility.wrapEx(exception, ErrorFactory.makeDriverJDBCException("TJ1586", string2));
        }
    }

    public static PrivateKey loadPrivateKeyFromFile(Log log, String string, String string2, String[] stringArray) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("loadPrivateKeyFromFile: sKeyFactory=" + string + " sFileName=" + string2);
        }
        if (string2.endsWith(".pem")) {
            return Utility.loadPrivateKeyFromPEMFile(log, string, string2);
        }
        if (string2.endsWith(".jwk")) {
            return Utility.loadPrivateKeyFromJWKFile(log, string, string2, stringArray);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ1583", string2);
    }

    public static String quoteName(String string) {
        return string != null ? "\"" + string.replaceAll("\"", "\"\"") + "\"" : string;
    }

    public static String unquoteName(String string) {
        return string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"") ? string.substring(1, string.length() - 1).replaceAll("\"\"", "\"") : string;
    }

    public static String ensureQuotedName(String string) {
        return Utility.quoteName(Utility.unquoteName(string));
    }

    public static String formatStringAsJSON(String string) {
        StringBuffer stringBuffer = new StringBuffer("\"");
        for (char c : string.toCharArray()) {
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\').append(c);
                continue;
            }
            if (c >= ' ' && c < '\u007f') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("\\u").append(Log.leadingZeros(Integer.toHexString(c), 4));
        }
        return stringBuffer.append("\"").toString();
    }

    public static String formatNameAndValueAsJSON(String string, Object object) {
        if (object instanceof String) {
            object = Utility.formatStringAsJSON((String)object);
        }
        return Utility.formatStringAsJSON(string) + ":" + object;
    }

    public static byte[] concatByteArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static String formatObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.append("]").toString();
    }

    public static String formatIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.append("]").toString();
    }

    public static String formatByteArrayAsHexDigits(byte[] byArray) {
        return DatatypeConverter.printHexBinary((byte[])byArray);
    }

    public static String coalesce(String string, String string2) {
        return string != null ? string : string2;
    }

    public static class HttpResponse {
        public int nCode = -1;
        public String sMessage = null;
        public String sBody = null;
        public String sCertStatus = null;
    }

    private static class MinimalTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        }
    }
}

