/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.TeraDriver;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc_3.dbmetadata.ColumnInfo;
import com.teradata.jdbc.jdbc_3.dbmetadata.TypeInfoRow;
import com.teradata.jdbc.jdbc_3.dbmetadata.TypeInfoRows;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.InitializedList;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TeraDatabaseMetaData
implements DatabaseMetaData {
    private TDSession m_session;
    private Log log;
    private int nDatabaseMajorVersion = 0;
    private int nDatabaseMinorVersion = 0;
    private int DBCRelease = 0;
    public static final int R3 = 30;
    public static final int R4 = 40;
    public static final int R5 = 50;
    public static final int R51 = 51;
    public static final int R6 = 60;
    public static final int R61 = 61;
    public static final int R62 = 62;
    public static final int R1200 = 1200;
    public static final int R1300 = 1300;
    public static final int R1310 = 1310;
    public static final int R1400 = 1400;
    public static final int R1410 = 1410;
    public static final int R1500 = 1500;
    public static final int R1510 = 1510;
    public static final int R1600 = 1600;
    public static final int V2DataTypesNo = 10;
    public static final int V2R3DataTypesNo = 31;
    public static final int V2R51DataTypesNo = 33;
    public static final int V2R61DataTypesNo = 35;
    private static final char LIKE_ESCAPE_CHAR = '\\';
    public static final String LIKE_ESCAPE = "\\";
    boolean m_bLiteralUnderscore;
    boolean m_bDataDictStats;
    boolean m_bQueryableViewColumnInfo;
    boolean usingXviews = false;
    private String dbc_databases = "DBC.DatabasesV";
    private String dbc_tables = "DBC.TablesV";
    private String dbc_columns = "DBC.ColumnsV";
    private String dbc_columnsQ = "DBC.ColumnsJQV";
    private String dbc_allRights = "DBC.AllRightsV";
    private String dbc_indices = "DBC.IndicesV";
    private String dbc_allRiChildren = "DBC.All_RI_ChildrenV";
    private String dbc_allRiParents = "DBC.All_RI_ParentsV";
    private String dbc_indexStats = "DBC.IndexStatsV";
    private String dbc_functions = "DBC.FunctionsV";
    private String dbc_udtInfo = "DBC.UDTInfo";

    public TeraDatabaseMetaData(TDSession tDSession) throws SQLException {
        this.m_session = tDSession;
        this.log = this.m_session.getLog();
        int[] nArray = this.m_session.getTeradataDatabaseVersionNumbers();
        this.nDatabaseMajorVersion = nArray[0];
        this.nDatabaseMinorVersion = nArray[1];
        this.DBCRelease = this.m_session.getTeradataDatabaseVersionNumber();
        this.m_bLiteralUnderscore = this.m_session.getURLParameters().getLiteralUnderscore();
        this.m_bDataDictStats = this.m_session.getURLParameters().getDataDictStats();
        if (this.DBCRelease >= 1600) {
            this.dbc_udtInfo = this.dbc_udtInfo + "V";
        }
        boolean bl = this.m_bQueryableViewColumnInfo = this.m_session.getConfigResponse().isQueryableViewColumnInfoSupported() && !tDSession.isJavaSPDefaultConnection();
        if (!this.m_bQueryableViewColumnInfo) {
            this.dbc_columnsQ = this.dbc_columns;
        }
        if (this.m_session.getURLParameters().getuseXviews()) {
            this.usingXviews = true;
            this.dbc_databases = this.dbc_databases + "X";
            this.dbc_tables = this.dbc_tables + "X";
            this.dbc_columns = this.dbc_columns + "X";
            this.dbc_columnsQ = this.dbc_columnsQ + "X";
            this.dbc_allRights = this.dbc_allRights + "X";
            this.dbc_allRiChildren = this.dbc_allRiChildren + "X";
            this.dbc_allRiParents = this.dbc_allRiParents + "X";
            this.dbc_indices = this.dbc_indices + "X";
            this.dbc_functions = this.dbc_functions + "X";
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return this.usingXviews;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return this.usingXviews;
    }

    @Override
    public String getURL() throws SQLException {
        return this.m_session.getURLParameters().synthesizeURL(this.m_session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserName() throws SQLException {
        String string = "SELECT USER";
        if (this.log.canLog(1)) {
            this.log.info("TeraDatabaseMetaData.getUserName: " + string);
        }
        try (Statement statement = this.m_session.createStatement();){
            String string2;
            ResultSet resultSet = statement.executeQuery(string);
            try {
                resultSet.next();
                string2 = resultSet.getString(1);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return string2;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getNullCollation() == 0;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getNullCollation() == 1;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getDBMS();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.m_session.getTeradataDatabaseVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return TeraDriver.class.getName();
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return Const.DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return 20;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 3;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 0;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 1;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getUnquotedIdentifierCase() == 2;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 3;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 0;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 1;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getQuotedIdentifierCase() == 2;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getIdentifierQuote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set queryAsSet(String string, String string2) throws SQLException {
        TreeSet<String> treeSet = new TreeSet<String>();
        try (Statement statement = this.m_session.createStatement();){
            this.logQuery(string, null, string2);
            try (ResultSet resultSet = statement.executeQuery(string2);){
                while (resultSet.next()) {
                    treeSet.add(resultSet.getString(1));
                }
            }
        }
        return treeSet;
    }

    private static Set createKeywordSet(Object[] objectArray, int n) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (((Integer)objectArray[i + 1] & n) == 0) continue;
            treeSet.add(objectArray[i]);
        }
        return treeSet;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        Object[] objectArray = new Object[]{"A", new Integer(62), "ABORT", new Integer(15), "ABORTSESSION", new Integer(15), "ABS", new Integer(63), "ABSOLUTE", new Integer(48), "ACCESS", new Integer(15), "ACCESS_LOCK", new Integer(15), "ACCOUNT", new Integer(15), "ACOS", new Integer(15), "ACOSH", new Integer(15), "ACTION", new Integer(48), "ADA", new Integer(63), "ADD", new Integer(48), "ADD_MONTHS", new Integer(15), "ADMIN", new Integer(63), "AFTER", new Integer(63), "AG", new Integer(14), "AGGREGATE", new Integer(15), "ALIAS", new Integer(15), "ALL", new Integer(48), "ALLOCATE", new Integer(48), "ALLOCATION", new Integer(15), "ALTER", new Integer(48), "ALWAYS", new Integer(63), "AMP", new Integer(15), "ANALYSIS", new Integer(15), "AND", new Integer(48), "ANSIDATE", new Integer(15), "ANY", new Integer(48), "ARE", new Integer(48), "ARGLPAREN", new Integer(14), "ARRAY", new Integer(63), "ARRAY_AGG", new Integer(32), "AS", new Integer(48), "ASC", new Integer(48), "ASCII", new Integer(15), "ASENSITIVE", new Integer(63), "ASIN", new Integer(15), "ASINH", new Integer(15), "ASSERTION", new Integer(48), "ASSIGNMENT", new Integer(63), "ASYMMETRIC", new Integer(63), "AT", new Integer(48), "ATAN", new Integer(15), "ATAN2", new Integer(15), "ATANH", new Integer(15), "ATOMIC", new Integer(63), "ATTR", new Integer(15), "ATTRIBUTE", new Integer(62), "ATTRIBUTES", new Integer(63), "ATTRS", new Integer(15), "AUTHORIZATION", new Integer(48), "AVE", new Integer(15), "AVERAGE", new Integer(15), "AVG", new Integer(48), "BEFORE", new Integer(63), "BEGIN", new Integer(48), "BERNOULLI", new Integer(62), "BETWEEN", new Integer(48), "BIGINT", new Integer(62), "BINARY", new Integer(63), "BITVAR", new Integer(1), "BLOB", new Integer(63), "BOOLEAN", new Integer(63), "BOTH", new Integer(48), "BREADTH", new Integer(63), "BT", new Integer(15), "BUT", new Integer(15), "BY", new Integer(48), "BYTE", new Integer(15), "BYTEINT", new Integer(15), "BYTES", new Integer(15), "C", new Integer(63), "CALL", new Integer(63), "CALLED", new Integer(63), "CARDINALITY", new Integer(63), "CASCADE", new Integer(48), "CASCADED", new Integer(48), "CASE", new Integer(48), "CASESPECIFIC", new Integer(15), "CASE_N", new Integer(15), "CAST", new Integer(48), "CATALOG", new Integer(48), "CATALOG_NAME", new Integer(63), "CD", new Integer(15), "CEIL", new Integer(62), "CEILING", new Integer(62), "CHAIN", new Integer(63), "CHANGERATE", new Integer(15), "CHAR", new Integer(48), "CHAR2HEXINT", new Integer(15), "CHARACTER", new Integer(48), "CHARACTERISTICS", new Integer(62), "CHARACTERS", new Integer(63), "CHARACTER_LENGTH", new Integer(48), "CHARACTER_SET_CATALOG", new Integer(63), "CHARACTER_SET_NAME", new Integer(63), "CHARACTER_SET_SCHEMA", new Integer(63), "CHARS", new Integer(15), "CHARSET_COLL", new Integer(15), "CHAR_LENGTH", new Integer(48), "CHECK", new Integer(48), "CHECKED", new Integer(1), "CHECKPOINT", new Integer(15), "CHECKSUM", new Integer(15), "CLASS", new Integer(15), "CLASS_ORIGIN", new Integer(63), "CLOB", new Integer(63), "CLOSE", new Integer(48), "CLUSTER", new Integer(15), "CM", new Integer(15), "COALESCE", new Integer(48), "COBOL", new Integer(63), "COLLATE", new Integer(48), "COLLATION", new Integer(48), "COLLATION_CATALOG", new Integer(63), "COLLATION_NAME", new Integer(63), "COLLATION_SCHEMA", new Integer(63), "COLLECT", new Integer(63), "COLUMN", new Integer(48), "COLUMNSPERINDEX", new Integer(15), "COLUMN_NAME", new Integer(63), "COMMAND_FUNCTION", new Integer(63), "COMMAND_FUNCTION_CODE", new Integer(63), "COMMENT", new Integer(15), "COMMIT", new Integer(48), "COMMITTED", new Integer(63), "COMPILE", new Integer(14), "COMPLETION", new Integer(1), "COMPRESS", new Integer(15), "CONDITION", new Integer(62), "CONDITION_NUMBER", new Integer(63), "CONNECT", new Integer(48), "CONNECTION", new Integer(48), "CONNECTION_NAME", new Integer(63), "CONSTRAINT", new Integer(48), "CONSTRAINTS", new Integer(48), "CONSTRAINT_CATALOG", new Integer(63), "CONSTRAINT_NAME", new Integer(63), "CONSTRAINT_SCHEMA", new Integer(63), "CONSTRUCTOR", new Integer(63), "CONSUME", new Integer(14), "CONTAINS", new Integer(63), "CONTINUE", new Integer(48), "CONVERT", new Integer(48), "CONVERT_TABLE_HEADER", new Integer(15), "CORR", new Integer(63), "CORRESPONDING", new Integer(48), "COS", new Integer(15), "COSH", new Integer(15), "COSTS", new Integer(15), "COUNT", new Integer(48), "COVAR_POP", new Integer(63), "COVAR_SAMP", new Integer(63), "CPP", new Integer(14), "CPUTIME", new Integer(14), "CREATE", new Integer(48), "CROSS", new Integer(48), "CS", new Integer(15), "CSUM", new Integer(15), "CT", new Integer(15), "CTCONTROL", new Integer(8), "CUBE", new Integer(63), "CUME_DIST", new Integer(62), "CURRENT", new Integer(48), "CURRENT_CATALOG", new Integer(32), "CURRENT_DATE", new Integer(48), "CURRENT_DEFAULT_TRANSFORM_GROUP", new Integer(62), "CURRENT_PATH", new Integer(63), "CURRENT_ROLE", new Integer(63), "CURRENT_SCHEMA", new Integer(32), "CURRENT_TIME", new Integer(48), "CURRENT_TIMESTAMP", new Integer(48), "CURRENT_TRANSFORM_GROUP_FOR_TYPE", new Integer(62), "CURRENT_USER", new Integer(48), "CURSOR", new Integer(48), "CURSOR_NAME", new Integer(63), "CV", new Integer(15), "CYCLE", new Integer(63), "DATA", new Integer(63), "DATABASE", new Integer(15), "DATABLOCKSIZE", new Integer(15), "DATE", new Integer(48), "DATEFORM", new Integer(15), "DATETIME_INTERVAL_CODE", new Integer(63), "DATETIME_INTERVAL_PRECISION", new Integer(63), "DAY", new Integer(48), "DBC", new Integer(15), "DEALLOCATE", new Integer(48), "DEBUG", new Integer(14), "DEC", new Integer(48), "DECIMAL", new Integer(48), "DECLARE", new Integer(48), "DEFAULT", new Integer(48), "DEFAULTS", new Integer(62), "DEFERRABLE", new Integer(48), "DEFERRED", new Integer(48), "DEFINED", new Integer(63), "DEFINER", new Integer(63), "DEGREE", new Integer(48), "DEGREES", new Integer(15), "DEL", new Integer(15), "DELETE", new Integer(48), "DEMOGRAPHICS", new Integer(15), "DENIALS", new Integer(15), "DENSE_RANK", new Integer(62), "DEPTH", new Integer(63), "DEREF", new Integer(63), "DERIVED", new Integer(62), "DESC", new Integer(48), "DESCRIBE", new Integer(48), "DESCRIPTOR", new Integer(48), "DESTROY", new Integer(1), "DESTRUCTOR", new Integer(1), "DETERMINISTIC", new Integer(63), "DIAGNOSTIC", new Integer(15), "DIAGNOSTICS", new Integer(48), "DICTIONARY", new Integer(1), "DIGITS", new Integer(15), "DISABLED", new Integer(15), "DISCONNECT", new Integer(48), "DISPATCH", new Integer(63), "DISTINCT", new Integer(48), "DO", new Integer(15), "DOMAIN", new Integer(48), "DOUBLE", new Integer(48), "DOWN", new Integer(8), "DROP", new Integer(48), "DUAL", new Integer(15), "DUMP", new Integer(15), "DYNAMIC", new Integer(63), "DYNAMIC_FUNCTION", new Integer(63), "DYNAMIC_FUNCTION_CODE", new Integer(63), "EACH", new Integer(63), "EBCDIC", new Integer(15), "ECHO", new Integer(15), "ELEMENT", new Integer(62), "ELSE", new Integer(48), "ELSEIF", new Integer(15), "ENABLED", new Integer(15), "ENCRYPT", new Integer(14), "END", new Integer(48), "END-EXEC", new Integer(48), "EQ", new Integer(15), "EQUALS", new Integer(63), "ERROR", new Integer(15), "ERRORFILES", new Integer(15), "ERRORTABLES", new Integer(15), "ESCAPE", new Integer(48), "ET", new Integer(15), "EVERY", new Integer(63), "EXCEPT", new Integer(48), "EXCEPTION", new Integer(16), "EXCL", new Integer(15), "EXCLUDE", new Integer(62), "EXCLUDING", new Integer(62), "EXCLUSIVE", new Integer(15), "EXEC", new Integer(48), "EXECUTE", new Integer(48), "EXISTING", new Integer(1), "EXISTS", new Integer(48), "EXIT", new Integer(15), "EXP", new Integer(63), "EXPAND", new Integer(8), "EXPIRE", new Integer(15), "EXPLAIN", new Integer(15), "EXTERNAL", new Integer(48), "EXTRACT", new Integer(48), "FALLBACK", new Integer(15), "FALSE", new Integer(48), "FASTEXPORT", new Integer(15), "FETCH", new Integer(48), "FILTER", new Integer(62), "FINAL", new Integer(63), "FIRST", new Integer(48), "FLAG", new Integer(32), "FLOAT", new Integer(48), "FLOOR", new Integer(62), "FOLLOWING", new Integer(63), "FOR", new Integer(48), "FOREIGN", new Integer(48), "FORMAT", new Integer(15), "FORTRAN", new Integer(63), "FOUND", new Integer(48), "FREE", new Integer(63), "FREESPACE", new Integer(15), "FROM", new Integer(48), "FULL", new Integer(48), "FUNCTION", new Integer(63), "FUSION", new Integer(62), "G", new Integer(63), "GE", new Integer(15), "GENERAL", new Integer(63), "GENERATED", new Integer(63), "GET", new Integer(48), "GIVE", new Integer(15), "GLOBAL", new Integer(48), "GO", new Integer(48), "GOTO", new Integer(48), "GRANT", new Integer(48), "GRANTED", new Integer(63), "GRAPHIC", new Integer(15), "GROUP", new Integer(48), "GROUPING", new Integer(63), "GT", new Integer(15), "HANDLER", new Integer(15), "HASH", new Integer(15), "HASHAMP", new Integer(15), "HASHBAKAMP", new Integer(15), "HASHBUCKET", new Integer(15), "HASHROW", new Integer(15), "HAVING", new Integer(48), "HELP", new Integer(15), "HIERARCHY", new Integer(63), "HIGH", new Integer(15), "HOLD", new Integer(63), "HOST", new Integer(15), "HOUR", new Integer(48), "IDENTITY", new Integer(48), "IF", new Integer(15), "IFP", new Integer(15), "IGNORE", new Integer(1), "IMMEDIATE", new Integer(48), "IMPLEMENTATION", new Integer(63), "IN", new Integer(48), "INCLUDING", new Integer(62), "INCONSISTENT", new Integer(15), "INCREMENT", new Integer(63), "INDEX", new Integer(15), "INDEXESPERTABLE", new Integer(15), "INDICATOR", new Integer(48), "INFIX", new Integer(1), "INITIALIZE", new Integer(1), "INITIALLY", new Integer(48), "INITIATE", new Integer(15), "INNER", new Integer(48), "INOUT", new Integer(63), "INPUT", new Integer(48), "INS", new Integer(15), "INSENSITIVE", new Integer(48), "INSERT", new Integer(48), "INSTANCE", new Integer(63), "INSTANTIABLE", new Integer(63), "INSTEAD", new Integer(47), "INT", new Integer(48), "INTEGER", new Integer(48), "INTEGERDATE", new Integer(15), "INTERSECT", new Integer(48), "INTERSECTION", new Integer(62), "INTERVAL", new Integer(48), "INTO", new Integer(48), "INVOKER", new Integer(63), "IOCOUNT", new Integer(14), "IS", new Integer(48), "ISOLATION", new Integer(48), "ITERATE", new Integer(15), "JAR", new Integer(12), "JAVA", new Integer(14), "JIS_COLL", new Integer(15), "JOIN", new Integer(48), "JOURNAL", new Integer(15), "K", new Integer(63), "KANJI1", new Integer(15), "KANJISJIS", new Integer(15), "KBYTE", new Integer(15), "KBYTES", new Integer(15), "KEEP", new Integer(15), "KEY", new Integer(48), "KEY_MEMBER", new Integer(63), "KEY_TYPE", new Integer(63), "KILOBYTES", new Integer(15), "KURTOSIS", new Integer(15), "LANGUAGE", new Integer(48), "LARGE", new Integer(63), "LAST", new Integer(48), "LATERAL", new Integer(63), "LATIN", new Integer(15), "LDIFF", new Integer(8), "LE", new Integer(15), "LEADING", new Integer(48), "LEAVE", new Integer(15), "LEFT", new Integer(48), "LENGTH", new Integer(63), "LESS", new Integer(1), "LEVEL", new Integer(48), "LIKE", new Integer(48), "LIKE_REGEX", new Integer(32), "LIMIT", new Integer(15), "LN", new Integer(63), "LOADING", new Integer(15), "LOCAL", new Integer(48), "LOCALTIME", new Integer(63), "LOCALTIMESTAMP", new Integer(63), "LOCATOR", new Integer(63), "LOCK", new Integer(15), "LOCKEDUSEREXPIRE", new Integer(15), "LOCKING", new Integer(15), "LOG", new Integer(15), "LOGGING", new Integer(15), "LOGON", new Integer(15), "LONG", new Integer(15), "LOOP", new Integer(15), "LOW", new Integer(15), "LOWER", new Integer(48), "LT", new Integer(15), "M", new Integer(63), "MACRO", new Integer(15), "MAP", new Integer(63), "MATCH", new Integer(48), "MATCHED", new Integer(63), "MAVG", new Integer(15), "MAX", new Integer(48), "MAXCHAR", new Integer(15), "MAXIMUM", new Integer(15), "MAXLOGONATTEMPTS", new Integer(15), "MAXVALUE", new Integer(63), "MCHARACTERS", new Integer(15), "MDIFF", new Integer(15), "MEDIUM", new Integer(15), "MEETS", new Integer(8), "MEMBER", new Integer(62), "MERGE", new Integer(63), "MESSAGE_LENGTH", new Integer(63), "MESSAGE_OCTET_LENGTH", new Integer(63), "MESSAGE_TEXT", new Integer(63), "METHOD", new Integer(63), "MIN", new Integer(48), "MINCHAR", new Integer(15), "MINDEX", new Integer(15), "MINIMUM", new Integer(15), "MINUS", new Integer(15), "MINUTE", new Integer(48), "MINVALUE", new Integer(63), "MLINREG", new Integer(15), "MLOAD", new Integer(15), "MOD", new Integer(63), "MODE", new Integer(15), "MODIFIED", new Integer(15), "MODIFIES", new Integer(63), "MODIFY", new Integer(15), "MODULE", new Integer(48), "MONITOR", new Integer(15), "MONRESOURCE", new Integer(15), "MONSESSION", new Integer(15), "MONTH", new Integer(48), "MORE", new Integer(63), "MSUBSTR", new Integer(15), "MSUM", new Integer(15), "MULTINATIONAL", new Integer(15), "MULTISET", new Integer(63), "MUMPS", new Integer(63), "NAME", new Integer(63), "NAMED", new Integer(15), "NAMES", new Integer(48), "NATIONAL", new Integer(48), "NATURAL", new Integer(48), "NCHAR", new Integer(48), "NCLOB", new Integer(63), "NE", new Integer(15), "NESTING", new Integer(62), "NEW", new Integer(63), "NEW_TABLE", new Integer(15), "NEXT", new Integer(48), "NFC", new Integer(32), "NFD", new Integer(32), "NFKC", new Integer(32), "NFKD", new Integer(32), "NO", new Integer(48), "NONE", new Integer(63), "NORMALIZE", new Integer(62), "NORMALIZED", new Integer(62), "NOT", new Integer(48), "NOWAIT", new Integer(15), "NULL", new Integer(48), "NULLABLE", new Integer(63), "NULLIF", new Integer(48), "NULLIFZERO", new Integer(15), "NULLS", new Integer(62), "NUMBER", new Integer(63), "NUMERIC", new Integer(48), "OA", new Integer(14), "OBJECT", new Integer(63), "OBJECTS", new Integer(15), "OCCURRENCES_REGEX", new Integer(32), "OCTETS", new Integer(62), "OCTET_LENGTH", new Integer(48), "OF", new Integer(48), "OFF", new Integer(15), "OLD", new Integer(63), "OLD_NEW_TABLE", new Integer(8), "OLD_TABLE", new Integer(15), "ON", new Integer(48), "ONLY", new Integer(48), "OPEN", new Integer(48), "OPERATION", new Integer(1), "OPTION", new Integer(48), "OPTIONS", new Integer(63), "OR", new Integer(48), "ORDER", new Integer(48), "ORDERED_ANALYTIC", new Integer(15), "ORDERING", new Integer(62), "ORDINALITY", new Integer(63), "OTHERS", new Integer(62), "OUT", new Integer(63), "OUTER", new Integer(48), "OUTPUT", new Integer(48), "OVER", new Integer(63), "OVERLAPS", new Integer(48), "OVERLAY", new Integer(63), "OVERRIDE", new Integer(15), "OVERRIDING", new Integer(63), "P", new Integer(32), "PAD", new Integer(48), "PARAMETER", new Integer(63), "PARAMETERS", new Integer(1), "PARAMETER_MODE", new Integer(63), "PARAMETER_NAME", new Integer(63), "PARAMETER_ORDINAL_POSITION", new Integer(63), "PARAMETER_SPECIFIC_CATALOG", new Integer(63), "PARAMETER_SPECIFIC_NAME", new Integer(63), "PARAMETER_SPECIFIC_SCHEMA", new Integer(63), "PARTIAL", new Integer(48), "PARTITION", new Integer(63), "PARTITIONED", new Integer(15), "PASCAL", new Integer(63), "PASSWORD", new Integer(15), "PATH", new Integer(63), "PERCENT", new Integer(15), "PERCENTILE_CONT", new Integer(62), "PERCENTILE_DISC", new Integer(62), "PERCENT_RANK", new Integer(63), "PERIOD", new Integer(8), "PERM", new Integer(15), "PERMANENT", new Integer(15), "PLACING", new Integer(62), "PLI", new Integer(63), "POSITION", new Integer(48), "POSITION_REGEX", new Integer(32), "POSTFIX", new Integer(1), "POWER", new Integer(62), "PRECEDES", new Integer(8), "PRECEDING", new Integer(63), "PRECISION", new Integer(48), "PREFIX", new Integer(1), "PREORDER", new Integer(1), "PREPARE", new Integer(48), "PRESERVE", new Integer(48), "PRIMARY", new Integer(48), "PRINT", new Integer(14), "PRIOR", new Integer(48), "PRIVATE", new Integer(15), "PRIVILEGES", new Integer(48), "PROCEDURE", new Integer(48), "PROFILE", new Integer(15), "PROPORTIONAL", new Integer(1), "PROTECTED", new Integer(15), "PROTECTION", new Integer(15), "PUBLIC", new Integer(48), "P_INTERSECT", new Integer(8), "P_NORMALIZE", new Integer(8), "QUALIFIED", new Integer(15), "QUALIFY", new Integer(15), "QUANTILE", new Integer(15), "QUERY", new Integer(15), "QUERY_BAND", new Integer(12), "QUEUE", new Integer(14), "RADIANS", new Integer(15), "RANDOM", new Integer(15), "RANDOMIZED", new Integer(15), "RANGE", new Integer(63), "RANGE_N", new Integer(15), "RANK", new Integer(63), "RDIFF", new Integer(8), "READ", new Integer(48), "READS", new Integer(63), "REAL", new Integer(48), "RECALC", new Integer(15), "RECURSIVE", new Integer(63), "REF", new Integer(63), "REFERENCES", new Integer(48), "REFERENCING", new Integer(63), "REGR_AVGX", new Integer(63), "REGR_AVGY", new Integer(63), "REGR_COUNT", new Integer(63), "REGR_INTERCEPT", new Integer(63), "REGR_R2", new Integer(63), "REGR_SLOPE", new Integer(63), "REGR_SXX", new Integer(63), "REGR_SXY", new Integer(63), "REGR_SYY", new Integer(63), "RELATIVE", new Integer(48), "RELEASE", new Integer(63), "RENAME", new Integer(15), "REPEAT", new Integer(15), "REPEATABLE", new Integer(63), "REPLACE", new Integer(15), "REPLACEMENT", new Integer(15), "REPLCONTROL", new Integer(14), "REPLICATION", new Integer(15), "REPOVERRIDE", new Integer(1), "REQUEST", new Integer(15), "RESIGNAL", new Integer(8), "RESTART", new Integer(63), "RESTORE", new Integer(15), "RESTRICT", new Integer(48), "RESULT", new Integer(63), "RESUME", new Integer(15), "RET", new Integer(15), "RETRIEVE", new Integer(15), "RETURN", new Integer(63), "RETURNED_CARDINALITY", new Integer(62), "RETURNED_LENGTH", new Integer(63), "RETURNED_OCTET_LENGTH", new Integer(63), "RETURNED_SQLSTATE", new Integer(63), "RETURNS", new Integer(63), "REUSE", new Integer(15), "REVALIDATE", new Integer(15), "REVOKE", new Integer(48), "RIGHT", new Integer(48), "RIGHTS", new Integer(15), "ROLE", new Integer(63), "ROLLBACK", new Integer(48), "ROLLFORWARD", new Integer(15), "ROLLUP", new Integer(63), "ROUTINE", new Integer(63), "ROUTINE_CATALOG", new Integer(63), "ROUTINE_NAME", new Integer(63), "ROUTINE_SCHEMA", new Integer(63), "ROW", new Integer(63), "ROWID", new Integer(15), "ROWS", new Integer(48), "ROW_COUNT", new Integer(63), "ROW_NUMBER", new Integer(63), "RULESET", new Integer(8), "SAMPLE", new Integer(15), "SAMPLEID", new Integer(15), "SAMPLES", new Integer(15), "SAVEPOINT", new Integer(63), "SCALE", new Integer(63), "SCHEMA", new Integer(48), "SCHEMA_NAME", new Integer(63), "SCOPE", new Integer(63), "SCOPE_CATALOG", new Integer(62), "SCOPE_NAME", new Integer(62), "SCOPE_SCHEMA", new Integer(62), "SCROLL", new Integer(48), "SEARCH", new Integer(63), "SEARCHSPACE", new Integer(15), "SECOND", new Integer(48), "SECTION", new Integer(48), "SECURITY", new Integer(63), "SEL", new Integer(15), "SELECT", new Integer(48), "SELF", new Integer(63), "SENSITIVE", new Integer(63), "SEQUENCE", new Integer(63), "SERIALIZABLE", new Integer(63), "SERVER_NAME", new Integer(63), "SESSION", new Integer(48), "SESSION_USER", new Integer(48), "SET", new Integer(48), "SETRESRATE", new Integer(15), "SETS", new Integer(63), "SETSESSRATE", new Integer(15), "SHARE", new Integer(15), "SHOW", new Integer(15), "SIGNAL", new Integer(8), "SIMILAR", new Integer(63), "SIMPLE", new Integer(63), "SIN", new Integer(15), "SINH", new Integer(15), "SIZE", new Integer(48), "SKEW", new Integer(15), "SMALLINT", new Integer(48), "SOME", new Integer(48), "SOUNDEX", new Integer(15), "SOURCE", new Integer(63), "SPACE", new Integer(48), "SPECCHAR", new Integer(15), "SPECIFIC", new Integer(63), "SPECIFICTYPE", new Integer(63), "SPECIFIC_NAME", new Integer(63), "SPL", new Integer(14), "SPOOL", new Integer(15), "SQL", new Integer(48), "SQLEXCEPTION", new Integer(63), "SQLSTATE", new Integer(48), "SQLTEXT", new Integer(15), "SQLWARNING", new Integer(63), "SQRT", new Integer(63), "SS", new Integer(15), "START", new Integer(63), "STARTUP", new Integer(15), "STAT", new Integer(15), "STATE", new Integer(63), "STATEMENT", new Integer(63), "STATIC", new Integer(63), "STATISTICS", new Integer(15), "STATS", new Integer(15), "STDDEV_POP", new Integer(63), "STDDEV_SAMP", new Integer(63), "STEPINFO", new Integer(15), "STRING_CS", new Integer(15), "STRUCTURE", new Integer(63), "STYLE", new Integer(63), "SUBCLASS_ORIGIN", new Integer(63), "SUBLIST", new Integer(1), "SUBMULTISET", new Integer(62), "SUBSCRIBER", new Integer(15), "SUBSTR", new Integer(15), "SUBSTRING", new Integer(48), "SUBSTRING_REGEX", new Integer(32), "SUCCEEDS", new Integer(8), "SUM", new Integer(48), "SUMMARY", new Integer(15), "SUMMARYONLY", new Integer(14), "SUSPEND", new Integer(15), "SYMMETRIC", new Integer(63), "SYSTEM", new Integer(63), "SYSTEMTEST", new Integer(15), "SYSTEM_USER", new Integer(48), "T", new Integer(32), "TABLE", new Integer(48), "TABLESAMPLE", new Integer(62), "TABLE_NAME", new Integer(63), "TAN", new Integer(15), "TANH", new Integer(15), "TARGET", new Integer(14), "TBL_CS", new Integer(15), "TD_GENERAL", new Integer(15), "TD_INTERNAL", new Integer(14), "TEMPORARY", new Integer(48), "TERMINATE", new Integer(15), "TEXT", new Integer(15), "THAN", new Integer(1), "THEN", new Integer(48), "THRESHOLD", new Integer(15), "THROUGH", new Integer(8), "TIES", new Integer(62), "TIME", new Integer(48), "TIMESTAMP", new Integer(48), "TIMEZONE_HOUR", new Integer(48), "TIMEZONE_MINUTE", new Integer(48), "TITLE", new Integer(15), "TO", new Integer(48), "TOP", new Integer(14), "TOP_LEVEL_COUNT", new Integer(62), "TPA", new Integer(15), "TRACE", new Integer(15), "TRAILING", new Integer(48), "TRANSACTION", new Integer(48), "TRANSACTIONS_COMMITTED", new Integer(63), "TRANSACTIONS_ROLLED_BACK", new Integer(63), "TRANSACTION_ACTIVE", new Integer(63), "TRANSFORM", new Integer(63), "TRANSFORMS", new Integer(63), "TRANSLATE", new Integer(48), "TRANSLATE_CHK", new Integer(15), "TRANSLATE_REGEX", new Integer(32), "TRANSLATION", new Integer(48), "TREAT", new Integer(63), "TRIGGER", new Integer(63), "TRIGGER_CATALOG", new Integer(63), "TRIGGER_NAME", new Integer(63), "TRIGGER_SCHEMA", new Integer(63), "TRIM", new Integer(48), "TRUE", new Integer(48), "TRUNCATE", new Integer(32), "TYPE", new Integer(63), "UC", new Integer(15), "UDTCASTAS", new Integer(14), "UDTCASTLPAREN", new Integer(14), "UDTMETHOD", new Integer(14), "UDTTYPE", new Integer(14), "UDTUSAGE", new Integer(14), "UESCAPE", new Integer(62), "UNBOUNDED", new Integer(63), "UNCOMMITTED", new Integer(63), "UNDEFINED", new Integer(15), "UNDER", new Integer(63), "UNDO", new Integer(15), "UNICODE", new Integer(15), "UNION", new Integer(48), "UNIQUE", new Integer(48), "UNKNOWN", new Integer(48), "UNNAMED", new Integer(63), "UNNEST", new Integer(63), "UNTIL", new Integer(15), "UNTIL_CHANGED", new Integer(8), "UPD", new Integer(15), "UPDATE", new Integer(48), "UPPER", new Integer(48), "UPPERCASE", new Integer(15), "USAGE", new Integer(48), "USE", new Integer(15), "USER", new Integer(48), "USER_DEFINED_TYPE_CATALOG", new Integer(63), "USER_DEFINED_TYPE_CODE", new Integer(62), "USER_DEFINED_TYPE_NAME", new Integer(63), "USER_DEFINED_TYPE_SCHEMA", new Integer(63), "USING", new Integer(48), "VALUE", new Integer(48), "VALUES", new Integer(48), "VARBINARY", new Integer(32), "VARBYTE", new Integer(15), "VARCHAR", new Integer(48), "VARGRAPHIC", new Integer(15), "VARIABLE", new Integer(1), "VARIANT_TYPE", new Integer(8), "VARYING", new Integer(48), "VAR_POP", new Integer(63), "VAR_SAMP", new Integer(63), "VIEW", new Integer(48), "VOLATILE", new Integer(15), "WAIT", new Integer(15), "WARNING", new Integer(14), "WHEN", new Integer(48), "WHENEVER", new Integer(48), "WHERE", new Integer(48), "WHILE", new Integer(15), "WIDTH_BUCKET", new Integer(63), "WINDOW", new Integer(62), "WITH", new Integer(48), "WITHIN", new Integer(62), "WITHOUT", new Integer(63), "WORK", new Integer(48), "WRITE", new Integer(48), "XMLPLAN", new Integer(8), "YEAR", new Integer(48), "ZEROIFNULL", new Integer(15), "ZONE", new Integer(48)};
        Set set = this.DBCRelease <= 51 ? TeraDatabaseMetaData.createKeywordSet(objectArray, 1) : (this.DBCRelease <= 62 ? TeraDatabaseMetaData.createKeywordSet(objectArray, 2) : (this.DBCRelease < 1300 ? TeraDatabaseMetaData.createKeywordSet(objectArray, 4) : (this.DBCRelease < 1310 ? TeraDatabaseMetaData.createKeywordSet(objectArray, 8) : this.queryAsSet("getSQLKeywords", "select restricted_word from SYSLIB.SQLRestrictedWords"))));
        set.addAll(TeraDatabaseMetaData.createKeywordSet(objectArray, 32));
        set.removeAll(TeraDatabaseMetaData.createKeywordSet(objectArray, 16));
        return TeraDatabaseMetaData.formatCommaSepList(set);
    }

    private static String formatCommaSepList(Set set) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((stringBuffer.length() > 0 ? "," : "") + iterator.next());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return TeraDatabaseMetaData.formatCommaSepList(new TreeSet(new InitializedList().item("ABS").item("ACOS").item("ASIN").item("ATAN").item("ATAN2").item("CEILING", this.DBCRelease >= 1400).item("COS").item("COT").item("DEGREES").item("EXP").item("FLOOR", this.DBCRelease >= 1400).item("LOG").item("LOG10").item("MOD").item("POWER", this.DBCRelease >= 1400).item("PI").item("RADIANS").item("RAND", this.DBCRelease >= 1400).item("ROUND", this.DBCRelease >= 1400).item("SIGN", this.DBCRelease >= 1400).item("SIN").item("SQRT").item("TAN").item("TRUNCATE", this.DBCRelease >= 1400)));
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return TeraDatabaseMetaData.formatCommaSepList(new TreeSet(new InitializedList().item("ASCII", this.DBCRelease >= 1400).item("CHAR", this.DBCRelease >= 1400).item("CHAR_LENGTH", this.DBCRelease >= 1400).item("CHARACTER_LENGTH", this.DBCRelease >= 1400).item("CONCAT").item("DIFFERENCE", this.DBCRelease >= 1400).item("INSERT", this.DBCRelease >= 1500).item("LCASE").item("LEFT").item("LENGTH").item("LOCATE").item("LTRIM").item("OCTET_LENGTH", this.DBCRelease >= 1400).item("POSITION", this.DBCRelease >= 1400).item("REPEAT", this.DBCRelease >= 1500).item("REPLACE", this.DBCRelease >= 1400).item("RIGHT", this.DBCRelease >= 1500).item("RTRIM").item("SOUNDEX").item("SPACE", this.DBCRelease >= 1400).item("SUBSTRING").item("UCASE")));
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "DATABASE,IFNULL,USER";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "CURDATE,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURTIME,DAYOFMONTH,EXTRACT,HOUR,MINUTE,MONTH,NOW,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,YEAR";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return LIKE_ESCAPE;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getSpecialChars();
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return this.DBCRelease >= 40;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return this.DBCRelease >= 60;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return this.DBCRelease >= 40;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getSupportsExtendedSQLGrammar();
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getSupportsANSI92IntermSQLGrammar();
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getSupportsANSI92FullSQLGrammar();
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getSupportsIntegrityEnhancementFacility();
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        if (this.DBCRelease >= 40) {
            return "procedure";
        }
        return "macro";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return this.DBCRelease >= 40;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return this.DBCRelease >= 40;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getCursorCommitBehavior() == 2;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getCursorCommitBehavior() == 2;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxBinLiteralChars();
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxCharLiteralChars();
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxColNameChars();
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxColGrpBy();
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxColperIdx();
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxColOrdrBy();
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxColInSel();
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxColinTbl();
    }

    @Override
    public int getMaxConnections() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaximumDriverConnections();
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxCursorNameChars();
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxIdxBytes();
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxSchemaNameChars();
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxProcedureNameChars();
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxRowBytes();
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxRowBytesIncludesLOBs();
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxStatementChars();
    }

    @Override
    public int getMaxStatements() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxRequests();
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxTblNameChars();
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxTblinSel();
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getMaxUsrNameChars();
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getTransactionIsolationDefault();
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getTransactionCapability() != 0;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return (configRspParcel.getSupportedTransactionIsolationLevels() & n) != 0;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getTransactionCapability() == 2;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getTransactionCapability() == 1;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getTransactionCapability() == 3;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getTransactionCapability() == 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logQuery(String string, String string2, String string3) throws SQLException {
        if (this.m_bDataDictStats) {
            String string4 = "explain diagnostic helpstats on for request ; " + string3;
            if (this.log.canLog(1)) {
                this.log.info("TeraDatabaseMetaData." + string + ": " + (string2 != null ? string2 + ": " : "") + string4);
            }
            try (Statement statement = this.m_session.createStatement();
                 ResultSet resultSet = statement.executeQuery(string4);){
                boolean bl = false;
                while (resultSet.next()) {
                    String string5 = resultSet.getString(1);
                    if (string5 == null) continue;
                    if (string5.indexOf("BEGIN RECOMMENDED STATS") >= 0) {
                        bl = true;
                    }
                    if (!bl) continue;
                    this.log.error("DDSTATS: " + string5);
                }
            }
        }
        if (this.log.canLog(1)) {
            this.log.info("TeraDatabaseMetaData." + string + ": " + (string2 != null ? string2 + ": " : "") + string3);
        }
    }

    private static String caseInsensitiveCompare(String string, boolean bl, boolean bl2, String string2) {
        if (bl2) {
            string2 = "'" + string2.replaceFirst(" +$", "") + "'";
        }
        return string + " (not casespecific) " + (bl ? "like" : "=") + " " + string2 + " (not casespecific)" + (bl ? " escape '\\'" : "");
    }

    private static String equalToUser(String string) {
        return TeraDatabaseMetaData.caseInsensitiveCompare(string, false, false, "user");
    }

    private static String equalToLiteral(String string, String string2) {
        return TeraDatabaseMetaData.caseInsensitiveCompare(string, false, true, string2);
    }

    private static void findPatternCharacters(String string, LinkedList linkedList, LinkedList linkedList2, LinkedList linkedList3) throws SQLException {
        char[] cArray = string.toCharArray();
        linkedList.clear();
        linkedList2.clear();
        linkedList3.clear();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\\' && !bl) {
                bl = true;
                linkedList.add(0, new Integer(i));
                continue;
            }
            if (bl) {
                boolean bl2;
                boolean bl3 = bl2 = c == '%' || c == '_' || c == '\\';
                if (!bl2) {
                    throw ErrorFactory.makeDriverJDBCException("TJ385", LIKE_ESCAPE + c);
                }
            } else if (c == '%') {
                linkedList2.add(0, new Integer(i));
            } else if (c == '_') {
                linkedList3.add(0, new Integer(i));
            }
            bl = false;
        }
        if (bl) {
            throw ErrorFactory.makeDriverJDBCException("TJ385", LIKE_ESCAPE);
        }
    }

    private String matchPattern(String string, String string2) throws SQLException {
        boolean bl;
        Object object;
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        LinkedList linkedList3 = new LinkedList();
        TeraDatabaseMetaData.findPatternCharacters(string2, linkedList, linkedList2, linkedList3);
        if (this.m_bLiteralUnderscore && linkedList3.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            object = linkedList3.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                stringBuffer.insert(n, '\\');
            }
            string2 = stringBuffer.toString();
            TeraDatabaseMetaData.findPatternCharacters(string2, linkedList, linkedList2, linkedList3);
        }
        boolean bl2 = bl = linkedList2.size() > 0 || linkedList3.size() > 0;
        if (!bl) {
            object = new StringBuffer(string2);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                ((StringBuffer)object).deleteCharAt(n);
            }
            string2 = ((StringBuffer)object).toString();
        }
        return TeraDatabaseMetaData.caseInsensitiveCompare(string, bl, true, string2);
    }

    @Override
    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT CAST (null AS VARCHAR(30)) AS PROCEDURE_CAT, DATABASENAME AS PROCEDURE_SCHEM, TABLENAME AS PROCEDURE_NAME, CAST (null AS VARCHAR(30)) AS FUTURE_USE1, CAST (null AS VARCHAR(30)) AS FUTURE_USE2, CAST (null AS VARCHAR(30)) AS FUTURE_USE3, COMMENTSTRING AS REMARKS, CAST ((CASE CHILDCOUNT WHEN 0 THEN 1 ELSE 2 END) AS SMALLINT) AS PROCEDURE_TYPE FROM " + this.dbc_tables + " WHERE TABLEKIND IN ('P', 'E')" + (string2 != null && !string2.equals("") ? " AND " + this.matchPattern("DATABASENAME", string2) : "") + (string2 != null && string2.equals("") ? " AND " + TeraDatabaseMetaData.equalToUser("DATABASENAME") : "") + (string3 != null && !string3.equals("") ? " AND " + this.matchPattern("TABLENAME", string3) : "") + " ORDER BY DATABASENAME, TABLENAME";
        this.logQuery("getProcedures", null, string4);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        String string5 = "SELECT DISTINCT CAST (NULL AS VARCHAR(30)) AS PROCEDURE_CAT, c.DATABASENAME AS PROCEDURE_SCHEM, c.TABLENAME AS PROCEDURE_NAME, c.COLUMNNAME AS COLUMN_NAME, CAST ((CASE c.SPPARAMETERTYPE WHEN 'I' THEN 1 WHEN 'O' THEN 4 WHEN 'B' THEN 2 ELSE 0 END) AS SMALLINT) AS COLUMN_TYPE," + TeraDatabaseMetaData.caseJDBCTypes("c.COLUMNTYPE", "u.TYPEKIND") + " AS DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.COLUMNTYPE", "c.COLUMNUDTNAME", this.DBCRelease >= 1600 ? "c.StorageFormat" : null) + " AS TYPE_NAME," + " CAST ((CASE" + " WHEN (c.COLUMNTYPE = 'N' OR c.COLUMNTYPE = 'UT' AND BaseTypes.COLUMNTYPE = 'N') AND c.DECIMALTOTALDIGITS = " + -128 + " THEN " + 40 + " ELSE c.DECIMALTOTALDIGITS" + " END) AS INTEGER) AS \"PRECISION\"," + " CAST (c.COLUMNLENGTH AS INTEGER) AS LENGTH," + " CAST ((CASE " + " WHEN (c.COLUMNTYPE = 'N' OR c.COLUMNTYPE = 'UT' AND BaseTypes.COLUMNTYPE = 'N') AND c.DECIMALFRACTIONALDIGITS = " + -128 + " THEN 0" + " ELSE c.DECIMALFRACTIONALDIGITS" + " END) AS SMALLINT) AS SCALE," + " CAST (10 AS SMALLINT) AS RADIX," + " CAST ((CASE c.NULLABLE" + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END) AS SMALLINT) AS NULLABLE," + " c.COMMENTSTRING AS REMARKS" + " FROM " + this.dbc_tables + " t, " + this.dbc_columns + " c" + " LEFT OUTER JOIN " + this.dbc_udtInfo + " u ON c.COLUMNUDTNAME = u.TYPENAME" + " LEFT OUTER JOIN " + this.dbc_columns + " BaseTypes ON u.TYPEKIND = 'D'" + " AND 'SYSUDTLIB' = BaseTypes.DATABASENAME (not casespecific)" + " AND u.TYPENAME (not casespecific) = BaseTypes.TABLENAME (not casespecific)" + " WHERE c.DATABASENAME = t.DATABASENAME" + " AND c.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND IN ('P', 'E')" + (string2 != null && !string2.equals("") ? " AND " + this.matchPattern("c.DATABASENAME", string2) : "") + (string2 != null && string2.equals("") ? " AND " + TeraDatabaseMetaData.equalToUser("c.DATABASENAME") : "") + (string3 != null && !string3.equals("") ? " AND " + this.matchPattern("c.TABLENAME", string3) : "") + (string4 != null && !string4.equals("") ? " AND " + this.matchPattern("c.COLUMNNAME", string4) : "") + " ORDER BY c.DATABASENAME, c.TABLENAME, c.COLUMNID";
        this.logQuery("getProcedureColumns", null, string5);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string5);
        TDResultSet tDResultSet = (TDResultSet)resultSet;
        tDResultSet.setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT CAST(NULL AS VARCHAR(100)) AS TABLE_CAT, DATABASENAME AS TABLE_SCHEM, TABLENAME AS TABLE_NAME, CAST((CASE WHEN TABLEKIND = 'V' THEN 'VIEW'" + (this.DBCRelease >= 1200 ? " WHEN COMMITOPT IN ('D','P') THEN 'GLOBAL TEMPORARY'" : "") + " ELSE 'TABLE'" + " END) AS VARCHAR(100)) AS TABLE_TYPE," + " COMMENTSTRING AS REMARKS," + " CAST(NULL AS VARCHAR(100)) AS TYPE_CAT," + " CAST(NULL AS VARCHAR(100)) AS TYPE_SCHEM," + " CAST(NULL AS VARCHAR(100)) AS TYPE_NAME," + " CAST(NULL AS VARCHAR(100)) AS SELF_REFERENCING_COL_NAME," + " CAST(NULL AS VARCHAR(100)) AS REF_GENERATION" + " FROM " + this.dbc_tables + " WHERE" + (string2 != null && !string2.equals("") ? " " + this.matchPattern("DATABASENAME", string2) : "") + (string2 != null && string2.equals("") ? " " + TeraDatabaseMetaData.equalToUser("DATABASENAME") : "") + (string2 != null && string3 != null && !string3.equals("") ? " AND" : "") + (string3 != null && !string3.equals("") ? " " + this.matchPattern("TABLENAME", string3) : "") + (string2 != null || string3 != null && !string3.equals("") ? " AND" : "") + this.buildTableType(stringArray, string2) + " ORDER BY TABLE_TYPE, TABLE_SCHEM, TABLE_NAME";
        this.logQuery("getTables", null, string4);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    private String buildTableType(String[] stringArray, String string) throws SQLException {
        int n;
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (stringArray == null) {
            bl2 = true;
            bl = true;
            bl3 = true;
            bl4 = true;
            if (this.DBCRelease >= 1200) {
                bl6 = true;
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equalsIgnoreCase("TABLE")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("SYSTEM TABLE")) {
                    bl = true;
                    continue;
                }
                if (stringArray[n].equalsIgnoreCase("VIEW")) {
                    bl3 = true;
                    continue;
                }
                if (this.DBCRelease >= 1200 && stringArray[n].equalsIgnoreCase("GLOBAL TEMPORARY")) {
                    bl6 = true;
                    continue;
                }
                bl4 = true;
            }
        }
        if (string != null && string.trim().equalsIgnoreCase("DBC") && bl) {
            return " TABLEKIND IN ('O','T','V') ";
        }
        if (string != null && string.trim().equalsIgnoreCase("DBC") && !bl) {
            return " 1 = 2 ";
        }
        if (!(string == null || string.trim().equalsIgnoreCase("DBC") || !bl || bl2 || bl3 || bl6)) {
            return " 1 = 2 ";
        }
        if (bl) {
            string2 = " ((DATABASENAME = 'DBC' AND TABLEKIND IN ('O','T','V')) ";
            bl5 = true;
        }
        if (!bl) {
            string2 = string2 + " DATABASENAME <> 'DBC' ";
            if (bl2 || bl3 || bl6) {
                string2 = string2 + " AND ";
            }
        }
        if (bl2 || bl6) {
            if (!bl5) {
                string2 = string2 + " ( ";
                bl5 = true;
            } else {
                string2 = string2 + " OR ";
            }
            string2 = string2 + " TABLEKIND IN ('O','T') ";
            int n2 = n = bl2 && bl6 ? 1 : 0;
            if (this.DBCRelease >= 1200 && n == 0) {
                string2 = string2 + " AND COMMITOPT " + (bl6 ? "" : "NOT") + " IN ('D','P') ";
            }
        }
        if (bl3) {
            if (!bl5) {
                string2 = string2 + " ( ";
                bl5 = true;
            } else {
                string2 = string2 + " OR ";
            }
            string2 = string2 + " TABLEKIND = 'V' ";
        }
        if (!(!bl4 || bl || bl2 || bl3 || bl6)) {
            return " 1 = 2 ";
        }
        if (bl5) {
            string2 = string2 + ") ";
        }
        return string2;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String string = "SELECT DATABASENAME AS TABLE_SCHEM, CAST(null AS varchar(30)) AS TABLE_CATALOG FROM " + this.dbc_databases + " ORDER BY DATABASENAME";
        this.logQuery("getSchemas", null, string);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        TDResultSet tDResultSet = (TDResultSet)resultSet;
        tDResultSet.setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery("select cast(null as VARCHAR(30)) as TABLE_CAT where 1 = 0");
        TDResultSet tDResultSet = (TDResultSet)resultSet;
        tDResultSet.setMetadataRS(true);
        return resultSet;
    }

    private void addColumnInfo(TeraResultSetMetaData teraResultSetMetaData, ColumnInfo columnInfo) {
        ColumnProperties columnProperties = new ColumnProperties();
        teraResultSetMetaData.addColumnProperties(columnProperties, true);
        columnProperties.setPrecision(columnInfo.getPrecision());
        columnProperties.setScale(columnInfo.getScale());
        columnProperties.setColumnName(columnInfo.getColumnName());
        columnProperties.setColumnLabel(columnInfo.getColumnName());
        columnProperties.setNullable(columnInfo.getNullable());
        columnProperties.setColumnType(columnInfo.getColumnType(), columnInfo.getTdType());
        columnProperties.setTdType(columnInfo.getTdType());
        columnProperties.setColumnDisplaySize(columnInfo.getColumnDisplaySize());
    }

    private void addTableTypeRow(TDResultSet tDResultSet, Object object) throws SQLException {
        ResultSetRow resultSetRow = new ResultSetRow();
        resultSetRow.addValue(object);
        tDResultSet.addResultSetRow(resultSetRow);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.setColumnName("TABLE_TYPE");
        columnProperties.setColumnLabel("TABLE_TYPE");
        columnProperties.setColumnType(12, 449);
        columnProperties.setTdType(448);
        columnProperties.setColumnDisplaySize(16);
        TeraResultSetMetaData teraResultSetMetaData = this.m_session.constructResultSetMetaData();
        teraResultSetMetaData.addColumnProperties(columnProperties, true);
        TDResultSet tDResultSet = this.m_session.constructResultSet(teraResultSetMetaData, 1, null, null, this.log);
        tDResultSet.setActivityCount(4L);
        this.addTableTypeRow(tDResultSet, "GLOBAL TEMPORARY");
        this.addTableTypeRow(tDResultSet, "SYSTEM TABLE");
        this.addTableTypeRow(tDResultSet, "TABLE");
        this.addTableTypeRow(tDResultSet, "VIEW");
        return tDResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        String string5 = "select cast (null as varchar(30)) as TABLE_CAT, t.DatabaseName as TABLE_SCHEM, t.TableName as TABLE_NAME, c.ColumnName as COLUMN_NAME," + TeraDatabaseMetaData.caseJDBCTypes("c.ColumnType", "u.TypeKind") + " as DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.ColumnType", "c.ColumnUDTName", this.DBCRelease >= 1600 ? "c.StorageFormat" : null) + " as TYPE_NAME," + " (CASE WHEN c.COLUMNTYPE = 'UT' AND u.TypeKind = 'D'" + " THEN " + TeraDatabaseMetaData.caseDisplaySize("BaseTypes.COLUMNTYPE", "c.DECIMALTOTALDIGITS", "c.CHARTYPE", "c.ColumnLength") + " ELSE " + TeraDatabaseMetaData.caseDisplaySize("c.COLUMNTYPE", "c.DECIMALTOTALDIGITS", "c.CHARTYPE", "c.COLUMNLENGTH") + " END) AS COLUMN_SIZE, " + " cast (null as integer) as BUFFER_LENGTH," + " cast ((CASE" + " WHEN (c.COLUMNTYPE = 'N' OR c.COLUMNTYPE = 'UT' AND BaseTypes.COLUMNTYPE = 'N') AND c.DECIMALFRACTIONALDIGITS = " + -128 + " THEN 0" + " ELSE c.DECIMALFRACTIONALDIGITS" + " END) as integer) as DECIMAL_DIGITS," + " cast (10 as integer) as NUM_PREC_RADIX," + TeraDatabaseMetaData.caseColumnNullable("c.Nullable") + " as NULLABLE," + " c.CommentString as REMARKS," + " c.DefaultValue as COLUMN_DEF," + " cast (null as integer) as SQL_DATA_TYPE," + " cast (null as integer) as SQL_DATETIME_SUB," + " cast (c.ColumnLength as integer) as CHAR_OCTET_LENGTH," + " cast ((row_number () over (partition by TABLE_SCHEM, TABLE_NAME order by c.ColumnID)) as integer) as ORDINAL_POSITION," + TeraDatabaseMetaData.caseIsNullable("c.Nullable") + " as IS_NULLABLE," + " cast (null as varchar(30)) as SCOPE_CATLOG," + " cast (null as varchar(30)) as SCOPE_SCHEMA," + " cast (null as varchar(30)) as SCOPE_TABLE," + TeraDatabaseMetaData.caseUDTSrcType1("c.ColumnType", "u.TypeKind", "BaseTypes.ColumnType") + " as SOURCE_DATA_TYPE" + " from " + this.dbc_tables + " t" + " join " + this.dbc_columnsQ + " c" + " on t.DatabaseName = c.DatabaseName" + " and t.TableName = c.TableName" + " left outer join " + this.dbc_udtInfo + " u" + " on c.ColumnUDTName = u.TypeName" + " left outer join " + this.dbc_columns + " BaseTypes" + " on u.TypeKind = 'D'" + " and 'SYSUDTLIB' = BaseTypes.DatabaseName (not casespecific)" + " and u.TypeName (not casespecific) = BaseTypes.TableName (not casespecific)";
        int n = 0;
        if (!this.m_bQueryableViewColumnInfo) {
            string5 = string5 + TeraDatabaseMetaData.whereAnd(n++) + "t.TableKind IN ('O','T','V')";
        }
        if ("".equals(string2)) {
            string5 = string5 + TeraDatabaseMetaData.whereAnd(n++) + TeraDatabaseMetaData.equalToUser("c.DatabaseName");
        } else if (string2 != null) {
            string5 = string5 + TeraDatabaseMetaData.whereAnd(n++) + this.matchPattern("c.DatabaseName", string2);
        }
        if (string3 != null) {
            string5 = string5 + TeraDatabaseMetaData.whereAnd(n++) + this.matchPattern("c.TableName", string3);
        }
        if (string4 != null) {
            string5 = string5 + TeraDatabaseMetaData.whereAnd(n++) + this.matchPattern("c.ColumnName", string4);
        }
        string5 = string5 + " order by TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION";
        this.logQuery("getColumns", null, string5);
        boolean bl = true;
        Statement statement = this.m_session.createStatement();
        try {
            ResultSet resultSet;
            block15: {
                ResultSet resultSet2 = statement.executeQuery(string5);
                try {
                    if (!this.m_bQueryableViewColumnInfo) {
                        ((TDResultSet)resultSet2).setFetchedRowsPostProcessor(new ObtainViewColumnMetaData());
                    }
                    ((TDResultSet)resultSet2).setMetadataRS(true);
                    bl = false;
                    resultSet = resultSet2;
                    if (!bl) break block15;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        resultSet2.close();
                    }
                    throw throwable;
                }
                resultSet2.close();
            }
            return resultSet;
        }
        finally {
            if (bl) {
                statement.close();
            }
        }
    }

    private static String whereAnd(int n) {
        return n == 0 ? " where " : " and ";
    }

    @Override
    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        String string5 = "SELECT CAST (NULL AS VARCHAR(30)) AS TABLE_CAT, dt.DatabaseName AS TABLE_SCHEM, dt.TableName AS TABLE_NAME, dt.ColumnName AS COLUMN_NAME, dt.GrantorName AS GRANTOR, dt.UserName AS GRANTEE, CAST (" + TeraDatabaseMetaData.casePrivilegeName("dt.AccessRight") + " AS VARCHAR(100)) AS PRIVILEGE," + " CAST (" + TeraDatabaseMetaData.caseYesNo("dt.GrantAuthority") + " AS VARCHAR(3)) AS IS_GRANTABLE" + " FROM (" + " SELECT" + " a.DatabaseName," + " a.TableName," + " a.ColumnName," + " a.GrantorName," + " a.UserName," + " a.AccessRight," + " a.GrantAuthority" + " FROM " + this.dbc_allRights + " a" + " JOIN " + this.dbc_tables + " t" + " ON a.DatabaseName = t.DatabaseName" + " AND a.TableName = t.TableName" + " JOIN " + this.dbc_columns + " c" + " ON a.DatabaseName = c.DatabaseName" + " AND a.TableName = c.TableName" + " AND a.ColumnName = c.ColumnName" + " WHERE t.TABLEKIND IN ('O','T')" + (string2 != null ? " AND " + this.matchPattern("a.DatabaseName", string2) : "") + (string3 != null ? " AND " + this.matchPattern("a.TableName", string3) : "") + (string4 != null ? " AND " + this.matchPattern("a.ColumnName", string4) : "") + " UNION" + " SELECT" + " c.DatabaseName," + " c.TableName," + " c.ColumnName," + " a.GrantorName," + " a.UserName," + " a.AccessRight," + " a.GrantAuthority" + " FROM " + this.dbc_columns + " c" + " JOIN " + this.dbc_tables + " t" + " ON c.DatabaseName = t.DatabaseName" + " AND c.TableName = t.TableName" + " JOIN " + this.dbc_allRights + " a" + " ON c.DatabaseName = a.DatabaseName" + " AND c.TableName = a.TableName" + " WHERE t.TABLEKIND IN ('O','T')" + " AND UPPER(a.ColumnName) = 'ALL'" + (string2 != null ? " AND " + this.matchPattern("c.DatabaseName", string2) : "") + (string3 != null ? " AND " + this.matchPattern("c.TableName", string3) : "") + (string4 != null ? " AND " + this.matchPattern("c.ColumnName", string4) : "") + " ) AS dt" + " ORDER BY TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, PRIVILEGE";
        this.logQuery("getColumnPrivileges", null, string5);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string5);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT DISTINCT CAST (NULL AS VARCHAR(30)) AS TABLE_CAT, a.DATABASENAME AS TABLE_SCHEM, a.TABLENAME AS TABLE_NAME, a.GrantorName AS GRANTOR, a.UserName AS GRANTEE, CAST (" + TeraDatabaseMetaData.casePrivilegeName("a.AccessRight") + " AS VARCHAR(100)) AS PRIVILEGE," + " CAST (" + TeraDatabaseMetaData.caseYesNo("a.GrantAuthority") + " AS VARCHAR(3)) AS IS_GRANTABLE" + " FROM " + this.dbc_allRights + " a, " + this.dbc_tables + " t" + " WHERE a.DATABASENAME = t.DATABASENAME" + " AND a.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND IN ('O','T')" + (string2 != null ? " AND " + this.matchPattern("a.DATABASENAME", string2) : "") + (string3 != null ? " AND " + this.matchPattern("a.TABLENAME", string3) : "") + " ORDER BY a.DATABASENAME, a.TABLENAME, PRIVILEGE";
        this.logQuery("getTablePrivileges", null, string4);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        if (string3 == null || string3.equals("")) {
            throw ErrorFactory.makeDriverJDBCException("TJ398");
        }
        if (string2 == null || string2.equals("")) {
            object3 = new HashMap();
            object2 = this.getTables(string, string2, string3, null);
            try {
                while (object2.next()) {
                    object = object2.getString(2);
                    String string4 = object2.getString(3);
                    String string5 = (String)object3.get(string4);
                    if (string5 == null) {
                        object3.put(string4, object);
                        continue;
                    }
                    if (string5.equals(object)) continue;
                    throw ErrorFactory.makeDriverJDBCException("TJ397", string3, string5, (String)object);
                }
            }
            finally {
                object2.close();
            }
        }
        if (!(object = (object3 = this.m_session.createStatement()).executeQuery((String)(object2 = this.getBestRowIdentifierSQL(string2, string3, bl, true)))).isBeforeFirst()) {
            object2 = this.getBestRowIdentifierSQL(string2, string3, bl, false);
            object = object3.executeQuery((String)object2);
        }
        ((TDResultSet)object).setMetadataRS(true);
        return object;
    }

    private String getBestRowIdentifierSQL(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        string = string != null ? string.replaceAll("'", "''") : null;
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        String string3 = "SELECT DISTINCT CAST (2 AS SMALLINT) AS SCOPE, c.COLUMNNAME AS COLUMN_NAME," + TeraDatabaseMetaData.caseJDBCTypes("c.COLUMNTYPE", "u.TYPEKIND") + " AS DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.COLUMNTYPE", "c.COLUMNUDTNAME", this.DBCRelease >= 1600 ? "c.StorageFormat" : null) + " AS TYPE_NAME," + " (CASE" + " WHEN c.COLUMNTYPE = 'UT' AND u.TypeKind = 'D'" + " THEN " + TeraDatabaseMetaData.caseDisplaySize("BaseTypes.COLUMNTYPE", "c.DECIMALTOTALDIGITS", "c.CHARTYPE", "c.ColumnLength") + " ELSE " + TeraDatabaseMetaData.caseDisplaySize("c.COLUMNTYPE", "c.DECIMALTOTALDIGITS", "c.CHARTYPE", "c.COLUMNLENGTH") + " END) AS COLUMN_SIZE," + " CAST (NULL AS INTEGER) AS BUFFER_LENGTH," + " CAST ((CASE" + " WHEN (c.COLUMNTYPE = 'N' OR c.COLUMNTYPE = 'UT' AND BaseTypes.COLUMNTYPE = 'N') AND c.DECIMALFRACTIONALDIGITS = " + -128 + " THEN 0" + " ELSE c.DECIMALFRACTIONALDIGITS" + " END) AS SMALLINT) AS DECIMAL_DIGITS," + " CAST (" + 1 + " AS SMALLINT) AS PSEUDO_COLUMN" + " FROM " + this.dbc_tables + " t" + (bl2 ? ", " + this.dbc_indices + " i" : "") + ", " + this.dbc_columns + " c" + " LEFT OUTER JOIN " + this.dbc_udtInfo + " u ON c.COLUMNUDTNAME = u.TYPENAME" + " LEFT OUTER JOIN " + this.dbc_columns + " BaseTypes ON u.TypeKind = 'D'" + " AND 'SYSUDTLIB' = BaseTypes.DatabaseName (not casespecific)" + " AND u.TypeName (not casespecific) = BaseTypes.TableName (not casespecific)" + " WHERE c.DATABASENAME = t.DATABASENAME" + " AND c.TABLENAME = t.TABLENAME" + " AND t.TABLEKIND IN ('O','T')" + " AND c.COLUMNTYPE NOT IN ('BO','CO')" + (bl2 ? " AND c.DATABASENAME = i.DATABASENAME AND c.TABLENAME = i.TABLENAME AND c.COLUMNNAME = i.COLUMNNAME AND i.UniqueFlag = 'Y'" : "") + (!bl ? " AND c.NULLABLE = 'N'" : "") + (string != null ? " AND " + TeraDatabaseMetaData.equalToLiteral("c.DATABASENAME", string) : "") + (string2 != null ? " AND " + TeraDatabaseMetaData.equalToLiteral("c.TABLENAME", string2) : "") + " ORDER BY" + (bl2 ? " i.IndexType," : "") + " c.DATABASENAME, c.TABLENAME, c.COLUMNID";
        this.logQuery("getBestRowIdentifier", bl2 ? "unique" : "all", string3);
        return string3;
    }

    @Override
    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.m_session.createStatement();
        String string4 = "SELECT CAST(NULL AS SMALLINT) AS SCOPE,  CAST(NULL AS VARCHAR(30)) AS COLUMN_NAME, CAST(NULL AS INTEGER) AS DATA_TYPE, CAST(NULL AS VARCHAR(30)) AS TYPE_NAME, CAST(NULL AS INTEGER) AS COLUMN_SIZE, CAST(NULL AS INTEGER) AS BUFFER_LENGTH, CAST(NULL AS SMALLINT) AS DECIMAL_DIGITS, CAST(NULL AS SMALLINT) AS PSEUDO_COLUMN WHERE 1 = 2";
        this.logQuery("getVersionColumns", null, string4);
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT cast (null as varchar(30)) AS TABLE_CAT, DATABASENAME AS TABLE_SCHEM, TABLENAME AS TABLE_NAME, COLUMNNAME AS COLUMN_NAME, CAST (COLUMNPOSITION as SMALLINT) as KEY_SEQ, INDEXNAME AS PK_NAME FROM " + this.dbc_indices + " WHERE INDEXTYPE = 'K'" + (string2 != null && !string2.equals("") ? " AND " + TeraDatabaseMetaData.equalToLiteral("DATABASENAME", string2) : "") + (string2 != null && string2.equals("") ? " AND " + TeraDatabaseMetaData.equalToUser("DATABASENAME") : "") + (string3 != null && !string3.equals("") ? " AND " + TeraDatabaseMetaData.equalToLiteral("TABLENAME", string3) : "") + " ORDER BY DATABASENAME, TABLENAME, COLUMNPOSITION";
        this.logQuery("getPrimaryKeys", null, string4);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        TDResultSet tDResultSet = (TDResultSet)resultSet;
        tDResultSet.setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.m_session.createStatement();
        String string4 = "select cast (null as varchar(30)) as PKTABLE_CAT, ParentDB as PKTABLE_SCHEM, ParentTable as PKTABLE_NAME, ParentKeyColumn as PKCOLUMN_NAME, cast (null as varchar(30)) as FKTABLE_CAT, ChildDB as FKTABLE_SCHEM, ChildTable as FKTABLE_NAME, ChildKeyColumn as FKCOLUMN_NAME, cast (null as smallint) as KEY_SEQ, cast (3 as smallint) as UPDATE_RULE, cast (3 as smallint) as DELETE_RULE, IndexName as FK_NAME, (case when PkColumnCount = FkColumnCount and PkColumnCount = OverlapColumnCount then PkName else null end) as PK_NAME, cast (null as smallint) as DEFERRABILITY from (select c.ParentDB, c.ParentTable, c.ParentKeyColumn, c.ChildDB, c.ChildTable, c.ChildKeyColumn, c.IndexName, i3.PkColumnCount, count(c.IndexID) over (partition by c.ChildDB, c.ChildTable, c.IndexID) as FkColumnCount, count(i1.IndexName) over (partition by c.ChildDB, c.ChildTable, c.IndexID) as OverlapColumnCount, i1.IndexName as PkName from " + this.dbc_allRiChildren + " c" + " left outer join " + this.dbc_indices + " i1" + " on c.ParentDB = i1.DatabaseName" + " and c.ParentTable = i1.TableName" + " and c.ParentKeyColumn = i1.ColumnName" + " and i1.IndexType = 'K'" + " and i1.IndexName is not null" + " left outer join (select" + " i2.DatabaseName," + " i2.TableName," + " i2.IndexName," + " count(*) as PkColumnCount" + " from " + this.dbc_indices + " i2" + " where i2.IndexType = 'K'" + " and i2.IndexName is not null" + " group by i2.DatabaseName, i2.TableName, i2.IndexName) i3" + " on c.ParentDB = i3.DatabaseName" + " and c.ParentTable = i3.TableName" + " and i1.IndexName = i3.IndexName" + (string2 != null || string3 != null ? " where" : "") + (string2 != null ? " " + TeraDatabaseMetaData.equalToLiteral("c.ChildDB", string2) : "") + (string2 != null && string3 != null ? " and" : "") + (string3 != null ? " " + TeraDatabaseMetaData.equalToLiteral("c.ChildTable", string3) : "") + ") dt" + " order by PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, KEY_SEQ," + " FKTABLE_SCHEM, FKTABLE_NAME, FK_NAME, FKCOLUMN_NAME";
        this.logQuery("getImportedKeys", null, string4);
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        Statement statement = this.m_session.createStatement();
        String string4 = "select cast (null as varchar(30)) as PKTABLE_CAT, ParentDB as PKTABLE_SCHEM, ParentTable as PKTABLE_NAME, ParentKeyColumn as PKCOLUMN_NAME, cast (null as varchar(30)) as FKTABLE_CAT, ChildDB as FKTABLE_SCHEM, ChildTable as FKTABLE_NAME, ChildKeyColumn as FKCOLUMN_NAME, cast (null as smallint) as KEY_SEQ, cast (3 as smallint) as UPDATE_RULE, cast (3 as smallint) as DELETE_RULE, IndexName as FK_NAME, (case when PkColumnCount = FkColumnCount and PkColumnCount = OverlapColumnCount then PkName else null end) as PK_NAME, cast (null as smallint) as DEFERRABILITY from (select p.ParentDB, p.ParentTable, p.ParentKeyColumn, p.ChildDB, p.ChildTable, p.ChildKeyColumn, p.IndexName, i3.PkColumnCount, count(p.IndexID) over (partition by p.ChildDB, p.ChildTable, p.IndexID) as FkColumnCount, count(i1.IndexName) over (partition by p.ChildDB, p.ChildTable, p.IndexID) as OverlapColumnCount, i1.IndexName as PkName from " + this.dbc_allRiParents + " p" + " left outer join " + this.dbc_indices + " i1" + " on p.ParentDB = i1.DatabaseName" + " and p.ParentTable = i1.TableName" + " and p.ParentKeyColumn = i1.ColumnName" + " and i1.IndexType = 'K'" + " and i1.IndexName is not null" + " left outer join (select" + " i2.DatabaseName," + " i2.TableName," + " i2.IndexName," + " count(*) as PkColumnCount" + " from " + this.dbc_indices + " i2" + " where i2.IndexType = 'K'" + " and i2.IndexName is not null" + " group by i2.DatabaseName, i2.TableName, i2.IndexName) i3" + " on p.ParentDB = i3.DatabaseName" + " and p.ParentTable = i3.TableName" + " and i1.IndexName = i3.IndexName" + (string2 != null || string3 != null ? " where" : "") + (string2 != null ? " " + TeraDatabaseMetaData.equalToLiteral("p.ParentDB", string2) : "") + (string2 != null && string3 != null ? " and" : "") + (string3 != null ? " " + TeraDatabaseMetaData.equalToLiteral("p.ParentTable", string3) : "") + ") dt" + " order by FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ," + " FK_NAME, FKCOLUMN_NAME";
        this.logQuery("getExportedKeys", null, string4);
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string5 = string5 != null ? string5.replaceAll("'", "''") : null;
        string6 = string6 != null ? string6.replaceAll("'", "''") : null;
        Statement statement = this.m_session.createStatement();
        String string7 = "select cast (null as varchar(30)) as PKTABLE_CAT, ParentDB as PKTABLE_SCHEM, ParentTable as PKTABLE_NAME, ParentKeyColumn as PKCOLUMN_NAME, cast (null as varchar(30)) as FKTABLE_CAT, ChildDB as FKTABLE_SCHEM, ChildTable as FKTABLE_NAME, ChildKeyColumn as FKCOLUMN_NAME, cast (null as smallint) as KEY_SEQ, cast (3 as smallint) as UPDATE_RULE, cast (3 as smallint) as DELETE_RULE, IndexName as FK_NAME, cast (null as varchar(30)) as PK_NAME,  cast (null as smallint) as DEFERRABILITY from " + this.dbc_allRiParents + (string2 != null || string3 != null ? " where" : "") + (string2 != null ? " " + TeraDatabaseMetaData.equalToLiteral("ParentDB", string2) : "") + (string2 != null && string3 != null ? " and" : "") + (string3 != null ? " " + TeraDatabaseMetaData.equalToLiteral("ParentTable", string3) : "") + (string2 == null && string3 == null && (string5 != null || string6 != null) ? " where" : "") + (!(string2 == null && string3 == null || string5 == null && string6 == null) ? " and" : "") + (string5 != null ? " " + TeraDatabaseMetaData.equalToLiteral("ChildDB", string5) : "") + (string5 != null && string6 != null ? " and" : "") + (string6 != null ? " " + TeraDatabaseMetaData.equalToLiteral("ChildTable", string6) : "") + " order by PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME," + " FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        this.logQuery("getCrossReference", null, string7);
        ResultSet resultSet = statement.executeQuery(string7);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        TypeInfoRows typeInfoRows = new TypeInfoRows(this.DBCRelease, this.m_session);
        TeraResultSetMetaData teraResultSetMetaData = this.m_session.constructResultSetMetaData();
        for (int i = 0; i < typeInfoRows.getColCount(); ++i) {
            this.addColumnInfo(teraResultSetMetaData, typeInfoRows.getTypeInfoCol(i));
        }
        TDResultSet tDResultSet = this.m_session.constructResultSet(teraResultSetMetaData, 1, null, null, this.log);
        tDResultSet.setActivityCount(typeInfoRows.getRowCount());
        for (int i = 0; i < typeInfoRows.getRowCount(); ++i) {
            TypeInfoRow typeInfoRow = typeInfoRows.getTypeInfoRow(i);
            ResultSetRow resultSetRow = new ResultSetRow();
            resultSetRow.addValue(typeInfoRow.getTypeName());
            resultSetRow.addValue(typeInfoRow.getDataType());
            resultSetRow.addValue(typeInfoRow.getPrecision());
            resultSetRow.addValue(typeInfoRow.getLiteralPrefix());
            resultSetRow.addValue(typeInfoRow.getLiteralSuffix());
            resultSetRow.addValue(typeInfoRow.getCreateParams());
            resultSetRow.addValue(typeInfoRow.getNullable());
            resultSetRow.addValue(typeInfoRow.getCaseSensitive());
            resultSetRow.addValue(typeInfoRow.getSearchable());
            resultSetRow.addValue(typeInfoRow.getUnsignedAttribute());
            resultSetRow.addValue(typeInfoRow.getFixedPrecScale());
            resultSetRow.addValue(typeInfoRow.getAutoIncrement());
            resultSetRow.addValue(typeInfoRow.getLocalTypeName());
            resultSetRow.addValue(typeInfoRow.getMinimumScale());
            resultSetRow.addValue(typeInfoRow.getMaximumScale());
            resultSetRow.addValue(typeInfoRow.getSqlDataType());
            resultSetRow.addValue(typeInfoRow.getSqlDatetimeSub());
            resultSetRow.addValue(typeInfoRow.getNumPrecRadix());
            tDResultSet.addResultSetRow(resultSetRow);
        }
        return tDResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        if (string3 == null || string3.equals("")) {
            throw ErrorFactory.makeDriverJDBCException("TJ398");
        }
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3.replaceAll("'", "''");
        String string4 = "select cast(null as varchar(30)) as TABLE_CAT, i.DatabaseName as TABLE_SCHEM, i.TableName as TABLE_NAME, cast((case i.UniqueFlag when 'N' then 'true' else 'false' end) as varchar(5)) as NON_UNIQUE, " + (this.DBCRelease >= 1410 ? "i.IndexDatabaseName" : "cast(null as varchar(30))") + " as INDEX_QUALIFIER" + ", i.IndexName as INDEX_NAME" + ", cast((case" + " when i.IndexType in ('A', 'K', 'P', 'Q', 'U') and i.IndexNumber = 1 then 1 /* tableIndexClustered */" + " when i.IndexType in ('H', 'K','O','P', 'S', 'U', 'V') then 2 /* tableIndexHashed */" + " else 3 /* tableIndexOther */ end) as smallint) as \"TYPE\"" + ", i.ColumnPosition as ORDINAL_POSITION" + ", i.ColumnName as COLUMN_NAME" + ", cast((case when o.IndexType = 'I' then 'A' else null end) as varchar(1)) as ASC_OR_DESC" + ", cast(" + (this.DBCRelease >= 1400 ? "s.UniqueValueCount" : "null") + " as integer) as \"CARDINALITY\"" + ", cast(null as integer) as \"PAGES\"" + ", cast(null as varchar(30)) as FILTER_CONDITION" + " from " + this.dbc_indices + " i" + " join " + this.dbc_tables + " t" + " on i.DatabaseName = t.DatabaseName" + " and i.TableName = t.TableName" + " and t.TableKind in ('O', 'T')" + " left outer join " + this.dbc_indices + " o" + " on i.DatabaseName = o.DatabaseName" + " and i.TableName = o.TableName" + " and i.IndexNumber + 4 = o.IndexNumber" + " and i.ColumnName = o.ColumnName" + " and o.IndexType = 'I'" + " left outer join " + this.dbc_indexStats + " s" + " on i.DatabaseName = s.DatabaseName" + " and i.TableName = s.TableName" + " and i.IndexNumber = s.IndexNumber" + " and i.ColumnName = s.ColumnName" + " where i.IndexType in (" + " /* Primary: */ 'A', 'P', 'Q'," + " /* Secondary: */ 'S', 'V', 'H', 'O'," + " /* Primary or Secondary: */ 'K', 'U'," + " /* Join: */ 'J'," + " /* Hash: */ 'N')" + (string2 != null && string2.equals("") ? " and " + TeraDatabaseMetaData.equalToUser("i.DatabaseName") : "") + (string2 != null && !string2.equals("") ? " and " + TeraDatabaseMetaData.equalToLiteral("i.DatabaseName", string2) : "") + " and " + TeraDatabaseMetaData.equalToLiteral("i.TableName", string3) + (bl ? " and i.UniqueFlag = 'Y'" : "") + " order by NON_UNIQUE, \"TYPE\", INDEX_NAME, ORDINAL_POSITION, INDEX_QUALIFIER, TABLE_SCHEM";
        this.logQuery("getIndexInfo", null, string4);
        boolean bl3 = true;
        Statement statement = this.m_session.createStatement();
        try {
            ResultSet resultSet;
            block9: {
                ResultSet resultSet2 = statement.executeQuery(string4);
                try {
                    ((TDResultSet)resultSet2).setFetchedRowsPostProcessor(new ConvertIndexInfoBooleanColumnValues());
                    TeraResultSetMetaData teraResultSetMetaData = (TeraResultSetMetaData)resultSet2.getMetaData();
                    teraResultSetMetaData.getColumnProperties(4).setColumnType(16, -1);
                    ((TDResultSet)resultSet2).setMetadataRS(true);
                    bl3 = false;
                    resultSet = resultSet2;
                    if (!bl3) break block9;
                }
                catch (Throwable throwable) {
                    if (bl3) {
                        resultSet2.close();
                    }
                    throw throwable;
                }
                resultSet2.close();
            }
            return resultSet;
        }
        finally {
            if (bl3) {
                statement.close();
            }
        }
    }

    @Override
    public boolean supportsResultSetType(int n) throws SQLException {
        switch (n) {
            case 1003: {
                return true;
            }
            case 1004: {
                return this.m_session.isPositioningSupported();
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        switch (n) {
            case 1003: {
                if (n2 == 1007) {
                    return true;
                }
                if (n2 == 1008) {
                    return this.m_session.isStatementInfoSupported();
                }
            }
            case 1004: {
                if (n2 == 1007) {
                    return this.m_session.isPositioningSupported();
                }
                if (n2 != 1008) break;
                return this.m_session.isPositioningSupported() && this.m_session.isStatementInfoSupported();
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        Object object;
        int n;
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        boolean bl = false;
        boolean bl2 = false;
        if (nArray == null) {
            bl = true;
            bl2 = true;
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 2001) {
                    bl = true;
                    continue;
                }
                if (nArray[i] != 2002) continue;
                bl2 = true;
            }
        }
        Statement statement = this.m_session.createStatement();
        if (string3 != null) {
            boolean bl3;
            n = string3.indexOf(".");
            boolean bl4 = bl3 = n != -1;
            if (bl3) {
                object = string3.substring(0, n);
                String string4 = string3.substring(n + 1);
                string2 = object;
                string3 = string4;
            }
        }
        n = this.DBCRelease >= 1600 ? 1 : 0;
        String string5 = "select distinct cast (null as varchar(30)) as TYPE_CAT, t.DatabaseName as TYPE_SCHEM, t.TableName as TYPE_NAME, cast (" + TeraDatabaseMetaData.formatTypeMappingCases(this.m_session.getTypeMap(), "(CASE (CASE" + (this.DBCRelease >= 1400 ? " WHEN u.ArrayNumDimensions = 1 THEN 'A1' WHEN u.ArrayNumDimensions > 1 THEN 'AN'" : "") + " WHEN u.TypeKind = 'D' THEN COALESCE (" + (n != 0 ? "rr.FromSQLReturnDataType" : "c1.ColumnType") + ", c.ColumnType)" + " WHEN u.TypeKind = 'S' THEN 'UT'" + " ELSE NULL" + " END)" + " WHEN 'A1' THEN 'java.sql.Array'" + " WHEN 'AN' THEN 'java.sql.Array'" + " WHEN 'AT' THEN 'java.sql.Time'" + " WHEN 'BF' THEN '[B'" + " WHEN 'BO' THEN 'java.sql.Blob'" + " WHEN 'BV' THEN '[B'" + " WHEN 'CF' THEN 'java.lang.String'" + " WHEN 'CO' THEN 'java.sql.Clob'" + " WHEN 'CV' THEN 'java.lang.String'" + " WHEN 'D'  THEN 'java.math.BigDecimal'" + " WHEN 'DA' THEN 'java.sql.Date'" + " WHEN 'DH' THEN 'java.lang.String'" + " WHEN 'DM' THEN 'java.lang.String'" + " WHEN 'DS' THEN 'java.lang.String'" + " WHEN 'DY' THEN 'java.lang.String'" + " WHEN 'F'  THEN 'java.lang.Double'" + " WHEN 'GF' THEN 'java.lang.String'" + " WHEN 'GV' THEN 'java.lang.String'" + " WHEN 'HM' THEN 'java.lang.String'" + " WHEN 'HR' THEN 'java.lang.String'" + " WHEN 'HS' THEN 'java.lang.String'" + " WHEN 'I1' THEN 'java.lang.Integer'" + " WHEN 'I2' THEN 'java.lang.Integer'" + " WHEN 'I'  THEN 'java.lang.Integer'" + " WHEN 'I8' THEN 'java.lang.Long'" + " WHEN 'JN' THEN 'java.sql.Clob'" + " WHEN 'MI' THEN 'java.lang.String'" + " WHEN 'MO' THEN 'java.lang.String'" + " WHEN 'MS' THEN 'java.lang.String'" + " WHEN 'N'  THEN 'java.math.BigDecimal'" + " WHEN 'SC' THEN 'java.lang.String'" + " WHEN 'SZ' THEN 'java.sql.Timestamp'" + " WHEN 'TS' THEN 'java.sql.Timestamp'" + " WHEN 'TZ' THEN 'java.sql.Time'" + " WHEN 'UT' THEN 'java.sql.Struct'" + " WHEN 'XM' THEN 'java.sql.SQLXML'" + " WHEN 'YM' THEN 'java.lang.String'" + " WHEN 'YR' THEN 'java.lang.String'" + " ELSE NULL" + " END)") + " as varchar(500)) as CLASS_NAME," + " cast ((CASE" + (this.DBCRelease >= 1400 ? " WHEN u.ArrayNumDimensions >= 1 THEN 2001" : "") + " WHEN u.TypeKind = 'D' THEN " + 2001 + " WHEN u.TypeKind = 'S' THEN " + 2002 + " ELSE NULL" + " END) as integer) as DATA_TYPE," + " t.CommentString as REMARKS," + " cast ((CASE" + (this.DBCRelease >= 1400 ? " WHEN u.ArrayNumDimensions >= 1 THEN 2003" : "") + " WHEN u.TypeKind = 'D' THEN " + TeraDatabaseMetaData.caseJDBCTypes("c.ColumnType", null) + " ELSE NULL" + " END) as smallint) as BASE_TYPE" + " from " + this.dbc_tables + " t" + " join " + this.dbc_udtInfo + " u" + " on t.TableName = u.TypeName" + " join " + this.dbc_columns + " c" + " on t.DatabaseName = c.DatabaseName" + " and t.TableName = c.TableName" + (n != 0 ? " left outer join DBC.UDTTransformV rr on u.TypeName = rr.TypeName" : " left outer join ((" + this.dbc_columns + " c1 join " + this.dbc_columns + " c2 on c1.TableName=c2.TableName" + " and c1.ColumnName in ('RETURN','RETURN0') and c1.ColumnType <> 'UT')" + " join (DBC.UDTTransform r join DBC.UDFInfo f on r.FromSQLRoutineId=f.FunctionId) on c1.TableName=f.FunctionName)" + " on c.TableName=c2.ColumnUDTName") + " where t.TableKind = 'U'" + (string2 != null ? " and " + this.matchPattern("t.DatabaseName", string2) : "") + (string3 != null ? " and " + this.matchPattern("t.TableName", string3) : "") + (!bl && bl2 ? " and u.TypeKind = 'S'" : "") + (bl && !bl2 ? " and (" + (this.DBCRelease >= 1400 ? "u.ArrayNumDimensions >= 1 or " : "") + "u.TypeKind = 'D')" : "") + (bl && bl2 ? " and (" + (this.DBCRelease >= 1400 ? "u.ArrayNumDimensions >= 1 or " : "") + "u.TypeKind in ('D','S'))" : "") + (!bl && !bl2 ? " and 1 = 0" : "") + " order by DATA_TYPE, TYPE_SCHEM, TYPE_NAME";
        this.logQuery("getUDTs", null, string5);
        object = statement.executeQuery(string5);
        ((TDResultSet)object).setMetadataRS(true);
        return object;
    }

    private static String formatTypeMappingCases(Map map, String string) {
        String string2 = "";
        for (Map.Entry entry : map.entrySet()) {
            String string3 = (String)entry.getKey();
            Class clazz = (Class)entry.getValue();
            int n = string3.indexOf(".");
            if (n < 0 || !string3.substring(0, n).equalsIgnoreCase("SYSUDTLIB")) continue;
            string2 = string2 + (string2.length() > 0 ? " " : "") + "WHEN u.TypeKind IN ('D','S') AND t.TableName (not casespecific) = '" + string3.substring(n + 1).replaceAll("'", "''") + "' (not casespecific) THEN '" + clazz.getName() + "'";
        }
        return string2.length() > 0 ? "(CASE " + string2 + " ELSE " + string + " END)" : string;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_session;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        ConfigRspParcel configRspParcel = this.m_session.getConfigResponse();
        return configRspParcel.getStatementPositioningSupport();
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return this.m_session.generatedKeysSupported();
    }

    @Override
    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "select cast(null as VARCHAR(30)) as TYPE_CAT, cast(null as VARCHAR(30)) as TYPE_SCHEM, cast(null as VARCHAR(30)) as TYPE_NAME, cast(null as VARCHAR(30)) as SUPERTYPE_CAT, cast(null as VARCHAR(30)) as SUPERTYPE_SCHEM, cast(null as VARCHAR(30)) as SUPERTYPE_NAME where 1 = 0";
        this.logQuery("getSuperTypes", null, string4);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "select cast(null as VARCHAR(30)) as TABLE_CAT, cast(null as VARCHAR(30)) as TABLE_SCHEM, cast(null as VARCHAR(30)) as TABLE_NAME, cast(null as VARCHAR(30)) as SUPERTABLE_NAME where 1 = 0";
        this.logQuery("getSuperTables", null, string4);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        Statement statement = this.m_session.createStatement();
        String string5 = "select distinct cast (null as varchar(30)) as TYPE_CAT, c.DatabaseName as TYPE_SCHEM, c.TableName as TYPE_NAME, c.ColumnName as ATTR_NAME," + TeraDatabaseMetaData.caseJDBCTypes("c.ColumnType", "u.TypeKind") + " as DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.ColumnType", "c.ColumnUDTName", null) + " as ATTR_TYPE_NAME," + " (CASE WHEN c.COLUMNTYPE = 'UT' AND u.TypeKind = 'D'" + " THEN " + TeraDatabaseMetaData.caseDisplaySize("c2.COLUMNTYPE", "c.DecimalTotalDigits", "c.CHARTYPE", "c.ColumnLength") + " ELSE " + TeraDatabaseMetaData.caseDisplaySize("c.COLUMNTYPE", "c.DecimalTotalDigits", "c.CHARTYPE", "c.ColumnLength") + " END) AS ATTR_SIZE," + " cast ((CASE " + " WHEN (c.COLUMNTYPE = 'N' OR (c.COLUMNTYPE = 'UT' AND c2.COLUMNTYPE = 'N')) AND c.DECIMALFRACTIONALDIGITS = " + -128 + " THEN 0" + " ELSE c.DECIMALFRACTIONALDIGITS" + " END) as integer) as DECIMAL_DIGITS," + " cast (10 as integer) as NUM_PREC_RADIX," + TeraDatabaseMetaData.caseAttributeNullable("c.Nullable") + " as NULLABLE," + " c.CommentString as REMARKS," + " c.DefaultValue as ATTR_DEF," + " cast (null as integer) as SQL_DATA_TYPE," + " cast (null as integer) as SQL_DATETIME_SUB," + " cast (c.ColumnLength as integer) as CHAR_OCTET_LENGTH," + " cast ((row_number () over (partition by TYPE_SCHEM, TYPE_NAME order by c.ColumnID)) as integer) as ORDINAL_POSITION," + TeraDatabaseMetaData.caseIsNullable("c.Nullable") + " as IS_NULLABLE," + " cast (null as varchar(30)) as SCOPE_CATALOG," + " cast (null as varchar(30)) as SCOPE_SCHEMA," + " cast (null as varchar(30)) as SCOPE_TABLE," + TeraDatabaseMetaData.caseUDTSrcType1("c.ColumnType", "u.TypeKind", "c2.ColumnType") + " as SOURCE_DATA_TYPE" + " from " + this.dbc_tables + " t, " + this.dbc_udtInfo + " u, " + this.dbc_columns + " c" + " left outer join" + " (" + this.dbc_columns + " c2 join " + this.dbc_udtInfo + " u2 on c2.TableName = u2.TypeName and u2.TypeKind = 'D')" + " on c.columnUDTname = c2.tablename" + " where (c.DatabaseName = t.DatabaseName" + " and c.TableName = t.TableName" + " and ((c.TableName = u.TypeName and c.columntype <> 'UT')" + " or (c.columnUDTname = u.typename and c.columntype='UT'))" + " and t.TableKind = 'U')" + (string2 != null ? " and " + this.matchPattern("c.DatabaseName", string2) : "") + (string3 != null ? " and " + this.matchPattern("c.TableName", string3) : "") + (string4 != null ? " and " + this.matchPattern("c.ColumnName", string4) : "") + " order by TYPE_SCHEM, TYPE_NAME, ORDINAL_POSITION";
        this.logQuery("getAttributes", null, string5);
        ResultSet resultSet = statement.executeQuery(string5);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return n == 1 || n == 2;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.nDatabaseMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.nDatabaseMinorVersion;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    private static String caseJDBCTypes(String string, String string2) {
        return " CAST ((CASE " + string + " WHEN 'A1' THEN " + 2003 + " WHEN 'AN' THEN " + 2003 + " WHEN 'AT' THEN " + 92 + " WHEN 'BF' THEN " + -2 + " WHEN 'BO' THEN " + 2004 + " WHEN 'BV' THEN " + -3 + " WHEN 'CF' THEN " + 1 + " WHEN 'CO' THEN " + 2005 + " WHEN 'CV' THEN " + 12 + " WHEN 'D' THEN " + 3 + " WHEN 'DA' THEN " + 91 + " WHEN 'F' THEN " + 6 + " WHEN 'GF' THEN " + 1 + " WHEN 'GV' THEN " + 12 + " WHEN 'I1' THEN " + -6 + " WHEN 'I2' THEN " + 5 + " WHEN 'I' THEN " + 4 + " WHEN 'I8' THEN " + -5 + " WHEN 'JN' THEN " + 1111 + " WHEN 'N' THEN " + 2 + " WHEN 'SZ' THEN " + 93 + " WHEN 'TS' THEN " + 93 + " WHEN 'TZ' THEN " + 92 + " WHEN 'UT' THEN (CASE " + string2 + " WHEN 'D' THEN " + 2001 + " WHEN 'S' THEN " + 2002 + " ELSE " + 1111 + " END)" + " WHEN 'XM' THEN " + 2009 + " ELSE " + 1111 + " END)" + " AS INTEGER)";
    }

    private static Integer helpColumnToJDBCType(String string) {
        return new Integer(TeraDatabaseMetaData.convertTeradataTypeCodeToJDBCType(string));
    }

    private static Short helpTypeToJDBCType(String string) {
        return new Short((short)TeraDatabaseMetaData.convertTeradataTypeCodeToJDBCType(string));
    }

    private static int convertTeradataTypeCodeToJDBCType(String string) {
        if ("A1".equals(string)) {
            return 2003;
        }
        if ("AN".equals(string)) {
            return 2003;
        }
        if ("AT".equals(string)) {
            return 92;
        }
        if ("BF".equals(string)) {
            return -2;
        }
        if ("BO".equals(string)) {
            return 2004;
        }
        if ("BV".equals(string)) {
            return -3;
        }
        if ("CF".equals(string)) {
            return 1;
        }
        if ("CO".equals(string)) {
            return 2005;
        }
        if ("CV".equals(string)) {
            return 12;
        }
        if ("D".equals(string)) {
            return 3;
        }
        if ("DA".equals(string)) {
            return 91;
        }
        if ("F".equals(string)) {
            return 6;
        }
        if ("GF".equals(string)) {
            return 1;
        }
        if ("GV".equals(string)) {
            return 12;
        }
        if ("I1".equals(string)) {
            return -6;
        }
        if ("I2".equals(string)) {
            return 5;
        }
        if ("I".equals(string)) {
            return 4;
        }
        if ("I8".equals(string)) {
            return -5;
        }
        if ("JN".equals(string)) {
            return 1111;
        }
        if ("N".equals(string)) {
            return 2;
        }
        if ("SZ".equals(string)) {
            return 93;
        }
        if ("TS".equals(string)) {
            return 93;
        }
        if ("TZ".equals(string)) {
            return 92;
        }
        if ("UD".equals(string)) {
            return 2001;
        }
        if ("US".equals(string)) {
            return 2002;
        }
        if ("XM".equals(string)) {
            return 2009;
        }
        return 1111;
    }

    private static String caseUDTSrcType1(String string, String string2, String string3) {
        return " CAST(" + (string2 == null || string3 == null ? "NULL" : "(CASE " + string + " WHEN 'UT' THEN" + " (CASE " + string2 + " WHEN 'D' THEN " + TeraDatabaseMetaData.caseJDBCTypes(string3, null) + " ELSE NULL" + " END)" + " ELSE NULL" + " END)") + " AS SMALLINT)";
    }

    private static String caseAttributeNullable(String string) {
        return " CAST((CASE " + string + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END)" + " AS INTEGER)";
    }

    private static String caseColumnNullable(String string) {
        return " CAST((CASE " + string + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END)" + " AS INTEGER)";
    }

    private static Integer helpColumnToNullable(String string) {
        return "Y".equals(string) ? new Integer(1) : ("N".equals(string) ? new Integer(0) : new Integer(2));
    }

    private static String caseIsNullable(String string) {
        return " TRIM((CASE " + string + " WHEN 'Y' THEN 'YES'" + " WHEN 'N' THEN 'NO'" + " ELSE ''" + " END)" + ")";
    }

    private static String helpColumnToIsNullable(String string) {
        return "Y".equals(string) ? "YES" : ("N".equals(string) ? "NO" : "");
    }

    private static String caseTeradataTypeNames(String string, String string2, String string3) {
        return " CAST ((CASE " + string + " WHEN '++' THEN 'TD_ANYTYPE'" + " WHEN 'A1' THEN 'SYSUDTLIB.' || TRIM(TRAILING FROM " + string2 + ")" + " WHEN 'AN' THEN 'SYSUDTLIB.' || TRIM(TRAILING FROM " + string2 + ")" + " WHEN 'AT' THEN 'TIME'" + " WHEN 'BF' THEN 'BYTE'" + " WHEN 'BO' THEN 'BLOB'" + " WHEN 'BV' THEN 'VARBYTE'" + " WHEN 'CF' THEN 'CHAR'" + " WHEN 'CO' THEN 'CLOB'" + " WHEN 'CV' THEN 'VARCHAR'" + " WHEN 'D' THEN 'DECIMAL'" + " WHEN 'DA' THEN 'DATE'" + " WHEN 'DH' THEN 'INTERVAL DAY TO HOUR'" + " WHEN 'DM' THEN 'INTERVAL DAY TO MINUTE'" + " WHEN 'DS' THEN 'INTERVAL DAY TO SECOND'" + (string3 != null ? " WHEN 'DT' THEN 'DATASET STORAGE FORMAT ' || TRIM(TRAILING FROM " + string3 + ")" : "") + " WHEN 'DY' THEN 'INTERVAL DAY'" + " WHEN 'F' THEN 'FLOAT'" + " WHEN 'GF' THEN 'GRAPHIC'" + " WHEN 'GV' THEN 'VARGRAPHIC'" + " WHEN 'HM' THEN 'INTERVAL HOUR TO MINUTE'" + " WHEN 'HR' THEN 'INTERVAL HOUR'" + " WHEN 'HS' THEN 'INTERVAL HOUR TO SECOND'" + " WHEN 'I1' THEN 'BYTEINT'" + " WHEN 'I2' THEN 'SMALLINT'" + " WHEN 'I' THEN 'INTEGER'" + " WHEN 'I8' THEN 'BIGINT'" + " WHEN 'JN' THEN 'JSON'" + " WHEN 'MI' THEN 'INTERVAL MINUTE'" + " WHEN 'MO' THEN 'INTERVAL MONTH'" + " WHEN 'MS' THEN 'INTERVAL MINUTE TO SECOND'" + " WHEN 'N'  THEN 'NUMBER'" + " WHEN 'PD' THEN 'PERIOD(DATE)'" + " WHEN 'PM' THEN 'PERIOD(TIMESTAMP WITH TIME ZONE)'" + " WHEN 'PS' THEN 'PERIOD(TIMESTAMP)'" + " WHEN 'PT' THEN 'PERIOD(TIME)'" + " WHEN 'PZ' THEN 'PERIOD(TIME WITH TIME ZONE)'" + " WHEN 'SC' THEN 'INTERVAL SECOND'" + " WHEN 'SZ' THEN 'TIMESTAMP WITH TIME ZONE'" + " WHEN 'TS' THEN 'TIMESTAMP'" + " WHEN 'TZ' THEN 'TIME WITH TIME ZONE'" + " WHEN 'XM' THEN 'XML'" + " WHEN 'YM' THEN 'INTERVAL YEAR TO MONTH'" + " WHEN 'YR' THEN 'INTERVAL YEAR'" + " WHEN 'UT' THEN 'SYSUDTLIB.' || TRIM(TRAILING FROM " + string2 + ")" + " ELSE TRIM (" + string + ")" + " END)" + " AS VARCHAR(500))";
    }

    private static String helpColumnToTeradataTypeName(String string, String string2, String string3) throws SQLException {
        if ("AT".equals(string)) {
            return "TIME";
        }
        if ("BF".equals(string)) {
            return "BYTE";
        }
        if ("BO".equals(string)) {
            return "BLOB";
        }
        if ("BV".equals(string)) {
            return "VARBYTE";
        }
        if ("CF".equals(string)) {
            return "CHAR";
        }
        if ("CO".equals(string)) {
            return "CLOB";
        }
        if ("CV".equals(string)) {
            return "VARCHAR";
        }
        if ("D".equals(string)) {
            return "DECIMAL";
        }
        if ("DA".equals(string)) {
            return "DATE";
        }
        if ("DH".equals(string)) {
            return "INTERVAL DAY TO HOUR";
        }
        if ("DM".equals(string)) {
            return "INTERVAL DAY TO MINUTE";
        }
        if ("DS".equals(string)) {
            return "INTERVAL DAY TO SECOND";
        }
        if ("DT".equals(string)) {
            return "DATASET STORAGE FORMAT " + string3;
        }
        if ("DY".equals(string)) {
            return "INTERVAL DAY";
        }
        if ("F".equals(string)) {
            return "FLOAT";
        }
        if ("GF".equals(string)) {
            return "GRAPHIC";
        }
        if ("GV".equals(string)) {
            return "VARGRAPHIC";
        }
        if ("HM".equals(string)) {
            return "INTERVAL HOUR TO MINUTE";
        }
        if ("HR".equals(string)) {
            return "INTERVAL HOUR";
        }
        if ("HS".equals(string)) {
            return "INTERVAL HOUR TO SECOND";
        }
        if ("I1".equals(string)) {
            return "BYTEINT";
        }
        if ("I2".equals(string)) {
            return "SMALLINT";
        }
        if ("I".equals(string)) {
            return "INTEGER";
        }
        if ("I8".equals(string)) {
            return "BIGINT";
        }
        if ("JN".equals(string)) {
            return "JSON";
        }
        if ("MI".equals(string)) {
            return "INTERVAL MINUTE";
        }
        if ("MO".equals(string)) {
            return "INTERVAL MONTH";
        }
        if ("MS".equals(string)) {
            return "INTERVAL MINUTE TO SECOND";
        }
        if ("N".equals(string)) {
            return "NUMBER";
        }
        if ("PD".equals(string)) {
            return "PERIOD(DATE)";
        }
        if ("PM".equals(string)) {
            return "PERIOD(TIMESTAMP WITH TIME ZONE)";
        }
        if ("PS".equals(string)) {
            return "PERIOD(TIMESTAMP)";
        }
        if ("PT".equals(string)) {
            return "PERIOD(TIME)";
        }
        if ("PZ".equals(string)) {
            return "PERIOD(TIME WITH TIME ZONE)";
        }
        if ("SC".equals(string)) {
            return "INTERVAL SECOND";
        }
        if ("SZ".equals(string)) {
            return "TIMESTAMP WITH TIME ZONE";
        }
        if ("TS".equals(string)) {
            return "TIMESTAMP";
        }
        if ("TZ".equals(string)) {
            return "TIME WITH TIME ZONE";
        }
        if ("XM".equals(string)) {
            return "XML";
        }
        if ("YM".equals(string)) {
            return "INTERVAL YEAR TO MONTH";
        }
        if ("YR".equals(string)) {
            return "INTERVAL YEAR";
        }
        if (("UD".equals(string) || "US".equals(string) || "UT".equals(string) || "A1".equals(string) || "AN".equals(string)) && string2 != null) {
            return string2;
        }
        return string;
    }

    private static String caseDisplaySize(String string, String string2, String string3, String string4) {
        return " CAST ((CASE WHEN " + string + " = 'AT' THEN 15" + " WHEN (" + string + " = 'CF'" + " OR " + string + " = 'CO'" + " OR " + string + " = 'CV'" + " OR " + string + " = 'GF'" + " OR " + string + " = 'GV'" + " OR " + string + " = 'JN'" + " OR " + string + " = 'XM'" + ") AND (" + string3 + " = 2" + " OR " + string3 + " = 4)" + " THEN " + string4 + " / 2" + " WHEN " + string + " = 'D' THEN " + string2 + " WHEN " + string + " = 'DA' THEN 10" + " WHEN " + string + " = 'DH' THEN 4 + " + string2 + " WHEN " + string + " = 'DM' THEN 7 + " + string2 + " WHEN " + string + " = 'DS' THEN 17 + " + string2 + " WHEN " + string + " = 'DY' THEN 1 + " + string2 + " WHEN " + string + " = 'F'  THEN 15" + " WHEN " + string + " = 'HM' THEN 4 + " + string2 + " WHEN " + string + " = 'HR' THEN 1 + " + string2 + " WHEN " + string + " = 'HS' THEN 14 + " + string2 + " WHEN " + string + " = 'I1' THEN 3" + " WHEN " + string + " = 'I2' THEN 5" + " WHEN " + string + " = 'I'  THEN 10" + " WHEN " + string + " = 'I8' THEN 19" + " WHEN " + string + " = 'MI' THEN 1 + " + string2 + " WHEN " + string + " = 'MO' THEN 1 + " + string2 + " WHEN " + string + " = 'MS' THEN 11 + " + string2 + " WHEN " + string + " = 'N'  THEN" + " (CASE WHEN " + string2 + " = " + -128 + " THEN " + 40 + " ELSE " + string2 + " END)" + " WHEN " + string + " = 'PD' THEN 28" + " WHEN " + string + " = 'PM' THEN 72" + " WHEN " + string + " = 'PS' THEN 60" + " WHEN " + string + " = 'PT' THEN 38" + " WHEN " + string + " = 'PZ' THEN 50" + " WHEN " + string + " = 'SC' THEN 8 + " + string2 + " WHEN " + string + " = 'SZ' THEN 32" + " WHEN " + string + " = 'TS' THEN 26" + " WHEN " + string + " = 'TZ' THEN 21" + " WHEN " + string + " = 'YM' THEN 4 + " + string2 + " WHEN " + string + " = 'YR' THEN 1 + " + string2 + " ELSE " + string4 + " END)" + " AS INTEGER)";
    }

    private static Integer helpColumnToDisplaySize(String string, Integer n, int n2, Integer n3) throws SQLException {
        if ("AT".equals(string)) {
            return new Integer(15);
        }
        if (("CF".equals(string) || "CO".equals(string) || "CV".equals(string) || "GF".equals(string) || "GV".equals(string) || "JN".equals(string) || "XM".equals(string)) && (n2 == 2 || n2 == 4)) {
            return TeraDatabaseMetaData.nullArith(n3, '/', 2);
        }
        if ("D".equals(string)) {
            return n;
        }
        if ("DA".equals(string)) {
            return new Integer(10);
        }
        if ("DH".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 4);
        }
        if ("DM".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 7);
        }
        if ("DS".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 17);
        }
        if ("DY".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("F".equals(string)) {
            return new Integer(15);
        }
        if ("HM".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 4);
        }
        if ("HR".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("HS".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 14);
        }
        if ("I1".equals(string)) {
            return new Integer(3);
        }
        if ("I2".equals(string)) {
            return new Integer(5);
        }
        if ("I".equals(string)) {
            return new Integer(10);
        }
        if ("I8".equals(string)) {
            return new Integer(19);
        }
        if ("MI".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("MO".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        if ("MS".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 11);
        }
        if ("N".equals(string)) {
            return n;
        }
        if ("PD".equals(string)) {
            return new Integer(28);
        }
        if ("PM".equals(string)) {
            return new Integer(72);
        }
        if ("PS".equals(string)) {
            return new Integer(60);
        }
        if ("PT".equals(string)) {
            return new Integer(38);
        }
        if ("PZ".equals(string)) {
            return new Integer(50);
        }
        if ("SC".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 8);
        }
        if ("SZ".equals(string)) {
            return new Integer(32);
        }
        if ("TS".equals(string)) {
            return new Integer(26);
        }
        if ("TZ".equals(string)) {
            return new Integer(21);
        }
        if ("YM".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 4);
        }
        if ("YR".equals(string)) {
            return TeraDatabaseMetaData.nullArith(n, '+', 1);
        }
        return n3;
    }

    private static Integer nullArith(Integer n, char c, int n2) {
        if (n == null) {
            return null;
        }
        switch (c) {
            case '+': {
                return new Integer(n + n2);
            }
            case '/': {
                return new Integer(n / n2);
            }
        }
        throw new IllegalArgumentException("Invalid value for cOperator: " + c);
    }

    private static String casePrivilegeName(String string) {
        return "(CASE " + string + " WHEN 'AE' THEN 'ALTER EXTERNAL PROCEDURE'" + " WHEN 'AF' THEN 'ALTER FUNCTION'" + " WHEN 'AN' THEN 'ANY PRIVILEGE'" + " WHEN 'AP' THEN 'ALTER PROCEDURE'" + " WHEN 'AS' THEN 'ABORT SESSION'" + " WHEN 'CA' THEN 'CREATE AUTHORIZATION'" + " WHEN 'CD' THEN 'CREATE DATABASE'" + " WHEN 'CE' THEN 'CREATE EXTERNAL PROCEDURE'" + " WHEN 'CF' THEN 'CREATE FUNCTION'" + " WHEN 'CG' THEN 'CREATE TRIGGER'" + " WHEN 'CM' THEN 'CREATE MACRO'" + " WHEN 'CO' THEN 'CREATE PROFILE'" + " WHEN 'CP' THEN 'CHECKPOINT'" + " WHEN 'CR' THEN 'CREATE ROLE'" + " WHEN 'CS' THEN 'CREATE SERVER'" + " WHEN 'CT' THEN 'CREATE TABLE'" + " WHEN 'CU' THEN 'CREATE USER'" + " WHEN 'CV' THEN 'CREATE VIEW'" + " WHEN 'CZ' THEN 'CREATE ZONE'" + " WHEN 'D'  THEN 'DELETE'" + " WHEN 'DA' THEN 'DROP AUTHORIZATION'" + " WHEN 'DD' THEN 'DROP DATABASE'" + " WHEN 'DF' THEN 'DROP FUNCTION'" + " WHEN 'DG' THEN 'DROP TRIGGER'" + " WHEN 'DM' THEN 'DROP MACRO'" + " WHEN 'DO' THEN 'DROP PROFILE'" + " WHEN 'DP' THEN 'DUMP'" + " WHEN 'DR' THEN 'DROP ROLE'" + " WHEN 'DS' THEN 'DROP SERVER'" + " WHEN 'DT' THEN 'DROP TABLE'" + " WHEN 'DU' THEN 'DROP USER'" + " WHEN 'DV' THEN 'DROP VIEW'" + " WHEN 'DZ' THEN 'DROP ZONE'" + " WHEN 'E'  THEN 'EXECUTE MACRO'" + " WHEN 'EF' THEN 'EXECUTE FUNCTION'" + " WHEN 'GC' THEN 'CREATE GLOP'" + " WHEN 'GD' THEN 'DROP GLOP'" + " WHEN 'GM' THEN 'GLOP MEMBER'" + " WHEN 'HR' THEN 'HUT RELEASE LOCK'" + " WHEN 'I'  THEN 'INSERT'" + " WHEN 'IX' THEN 'INDEX'" + " WHEN 'MC' THEN 'CREATE MAP'" + " WHEN 'MD' THEN 'DROP MAP'" + " WHEN 'MR' THEN 'MONITOR RESOURCE'" + " WHEN 'MS' THEN 'MONITOR SESSION'" + " WHEN 'NT' THEN 'NONTEMPORAL'" + " WHEN 'OA' THEN 'OVERRIDE DUMP POLICY FOR OBJECT'" + " WHEN 'OD' THEN 'OVERRIDE DELETE POLICY FOR CONSTRAINT'" + " WHEN 'OI' THEN 'OVERRIDE INSERT POLICY FOR CONSTRAINT'" + " WHEN 'OP' THEN 'CREATE OWNER PROCEDURE'" + " WHEN 'OR' THEN 'OVERRIDE RESTORE POLICY FOR OBJECT'" + " WHEN 'OS' THEN 'OVERRIDE SELECT POLICY FOR CONSTRAINT'" + " WHEN 'OU' THEN 'OVERRIDE UPDATE POLICY FOR CONSTRAINT'" + " WHEN 'PC' THEN 'CREATE PROCEDURE'" + " WHEN 'PD' THEN 'DROP PROCEDURE'" + " WHEN 'PE' THEN 'EXECUTE PROCEDURE'" + " WHEN 'R'  THEN 'SELECT'" + " WHEN 'RF' THEN 'REFERENCE'" + " WHEN 'RS' THEN 'RESTORE'" + " WHEN 'S'  THEN 'SELECT'" + " WHEN 'SA' THEN 'SECURITY CONSTRAINT ASSIGNMENT'" + " WHEN 'SD' THEN 'SECURITY CONSTRAINT DEFINITION'" + " WHEN 'SH' THEN 'SHOW'" + " WHEN 'SR' THEN 'SET RESOURCE RATE'" + " WHEN 'SS' THEN 'SET SESSION RATE'" + " WHEN 'ST' THEN 'STATISTICS'" + " WHEN 'TH' THEN 'CONNECT THROUGH'" + " WHEN 'U'  THEN 'UPDATE'" + " WHEN 'UM' THEN 'UDT METHOD'" + " WHEN 'UT' THEN 'UDT TYPE'" + " WHEN 'UU' THEN 'UDT USAGE'" + " WHEN 'WL' THEN 'WRITE LOCK'" + " WHEN 'ZO' THEN 'ZONE OVERRIDE'" + " ELSE TRIM (" + string + ") END)";
    }

    private static String caseYesNo(String string) {
        return "(CASE " + string + " WHEN 'Y' THEN 'YES'" + " WHEN 'N' THEN 'NO'" + " ELSE NULL END)";
    }

    @Override
    public ResultSet getSchemas(String string, String string2) throws SQLException {
        String string3 = "SELECT DATABASENAME AS TABLE_SCHEM, CAST(null AS varchar(30)) AS TABLE_CATALOG FROM " + this.dbc_databases + (string2 != null && !string2.equals("") ? " WHERE " + this.matchPattern("DATABASENAME", string2) : "") + (string2 != null && string2.equals("") ? " WHERE " + TeraDatabaseMetaData.equalToUser("DATABASENAME") : "") + " ORDER BY TABLE_SCHEM";
        this.logQuery("getSchemas(String,String)", null, string3);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        String string = this.DBCRelease >= 1400 ? "SELECT queryband_name AS NAME, max_len AS MAX_LEN, default_value AS DEFAULT_VALUE, description AS DESCRIPTION FROM SYSLIB.QueryBandReservedNames ORDER BY NAME" : "SELECT CAST(NULL AS VARCHAR(30)) AS NAME, CAST(NULL AS INTEGER) AS MAX_LEN, CAST(NULL AS VARCHAR(30)) AS DEFAULT_VALUE, CAST(NULL AS VARCHAR(30)) AS DESCRIPTION WHERE 1 = 2";
        this.logQuery("getClientInfoProperties", null, string);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getFunctions(String string, String string2, String string3) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        String string4 = "SELECT CAST (null AS VARCHAR(30)) AS FUNCTION_CAT, t.DATABASENAME AS FUNCTION_SCHEM, f.FUNCTIONNAME AS FUNCTION_NAME, t.COMMENTSTRING AS REMARKS, CAST ((CASE t.TABLEKIND WHEN 'L' THEN 2 WHEN 'R' THEN 2 ELSE 1 END) AS SMALLINT) AS FUNCTION_TYPE, f.SPECIFICNAME AS SPECIFIC_NAME FROM " + this.dbc_tables + " t" + " JOIN " + this.dbc_functions + " f" + " ON t.DATABASENAME = f.DATABASENAME" + " AND t.TABLENAME = f.SPECIFICNAME" + " WHERE t.TABLEKIND IN ('A'," + " 'B'," + " 'F'," + " 'L'," + " 'R'," + " 'S')" + (string2 != null && !string2.equals("") ? " AND " + this.matchPattern("t.DATABASENAME", string2) : "") + (string2 != null && string2.equals("") ? " AND " + TeraDatabaseMetaData.equalToUser("t.DATABASENAME") : "") + (string3 != null && !string3.equals("") ? " AND " + this.matchPattern("f.FUNCTIONNAME", string3) : "") + " ORDER BY FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME";
        this.logQuery("getFunctions", null, string4);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getFunctionColumns(String string, String string2, String string3, String string4) throws SQLException {
        string2 = string2 != null ? string2.replaceAll("'", "''") : null;
        string3 = string3 != null ? string3.replaceAll("'", "''") : null;
        string4 = string4 != null ? string4.replaceAll("'", "''") : null;
        String string5 = "SELECT CAST (NULL AS VARCHAR(30)) AS FUNCTION_CAT, c.DATABASENAME AS FUNCTION_SCHEM, f.FUNCTIONNAME AS FUNCTION_NAME, c.COLUMNNAME AS COLUMN_NAME, CAST ((CASE c.SPPARAMETERTYPE WHEN 'C' THEN 5 WHEN 'E' THEN 4 WHEN 'I' THEN 1 WHEN 'O' THEN 4 ELSE 0 END) AS SMALLINT) AS COLUMN_TYPE," + TeraDatabaseMetaData.caseJDBCTypes("c.COLUMNTYPE", "u.TYPEKIND") + " AS DATA_TYPE," + TeraDatabaseMetaData.caseTeradataTypeNames("c.COLUMNTYPE", "c.COLUMNUDTNAME", this.DBCRelease >= 1600 ? "c.StorageFormat" : null) + " AS TYPE_NAME," + " CAST ((CASE" + " WHEN (c.COLUMNTYPE = 'N' OR c.COLUMNTYPE = 'UT' AND BaseTypes.COLUMNTYPE = 'N') AND c.DECIMALTOTALDIGITS = " + -128 + " THEN " + 40 + " ELSE c.DECIMALTOTALDIGITS" + " END) AS INTEGER) AS \"PRECISION\"," + " CAST (c.COLUMNLENGTH AS INTEGER) AS LENGTH," + " CAST ((CASE" + " WHEN (c.COLUMNTYPE = 'N' OR c.COLUMNTYPE = 'UT' AND BaseTypes.COLUMNTYPE = 'N') AND c.DECIMALFRACTIONALDIGITS = " + -128 + " THEN 0" + " ELSE c.DECIMALFRACTIONALDIGITS" + " END) AS SMALLINT) AS SCALE," + " CAST (10 AS SMALLINT) AS RADIX," + " CAST((CASE c.NULLABLE" + " WHEN 'Y' THEN " + 1 + " WHEN 'N' THEN " + 0 + " ELSE " + 2 + " END) AS SMALLINT) AS NULLABLE," + " c.COMMENTSTRING AS REMARKS," + " CAST (c.COLUMNLENGTH AS INTEGER) AS CHAR_OCTET_LENGTH," + " CAST ((CASE c.SPPARAMETERTYPE" + " WHEN 'E' THEN 0" + " WHEN 'O' THEN 0" + " ELSE (ROW_NUMBER () OVER (PARTITION BY FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME, COLUMN_TYPE ORDER BY c.COLUMNID))" + " END) AS INTEGER) AS ORDINAL_POSITION," + TeraDatabaseMetaData.caseIsNullable("c.NULLABLE") + " AS IS_NULLABLE," + " f.SPECIFICNAME AS SPECIFIC_NAME" + " FROM " + this.dbc_tables + " t" + " JOIN " + this.dbc_functions + " f" + " ON t.DATABASENAME = f.DATABASENAME" + " AND t.TABLENAME = f.SPECIFICNAME" + " JOIN " + this.dbc_columns + " c" + " ON t.DATABASENAME = c.DATABASENAME" + " AND t.TABLENAME = c.TABLENAME" + " LEFT OUTER JOIN " + this.dbc_udtInfo + " u" + " ON c.COLUMNUDTNAME = u.TYPENAME" + " LEFT OUTER JOIN " + this.dbc_columns + " BaseTypes" + " ON u.TYPENAME = BaseTypes.TABLENAME" + " AND u.TYPEKIND = 'D'" + " AND BaseTypes.DATABASENAME = 'SYSUDTLIB'" + " WHERE t.TABLEKIND IN ('A'," + " 'B'," + " 'F'," + " 'L'," + " 'R'," + " 'S')" + (string2 != null && !string2.equals("") ? " AND " + this.matchPattern("c.DATABASENAME", string2) : "") + (string2 != null && string2.equals("") ? " AND " + TeraDatabaseMetaData.equalToUser("c.DATABASENAME") : "") + (string3 != null && !string3.equals("") ? " AND " + this.matchPattern("f.FUNCTIONNAME", string3) : "") + (string4 != null && !string4.equals("") ? " AND " + this.matchPattern("c.COLUMNNAME", string4) : "") + " ORDER BY FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME," + " (CASE COLUMN_TYPE WHEN " + 5 + " THEN 1 ELSE 0 END)," + " ORDINAL_POSITION, COLUMN_NAME";
        this.logQuery("getFunctionColumns", null, string5);
        Statement statement = this.m_session.createStatement();
        ResultSet resultSet = statement.executeQuery(string5);
        ((TDResultSet)resultSet).setMetadataRS(true);
        return resultSet;
    }

    @Override
    public ResultSet getPseudoColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "getRowIdLifetime");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    private class ConvertIndexInfoBooleanColumnValues
    implements TDResultSet.FetchedRowsPostProcessor {
        private ConvertIndexInfoBooleanColumnValues() {
        }

        @Override
        public void processRows(long l, List list) throws SQLException {
            for (ResultSetRow resultSetRow : list) {
                resultSetRow.setValue(3, Boolean.valueOf((String)resultSetRow.getValue(3)));
            }
        }
    }

    private class ObtainViewColumnMetaData
    implements TDResultSet.FetchedRowsPostProcessor {
        private ObtainViewColumnMetaData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void processRows(long l, List list) throws SQLException {
            Object object;
            Object object2;
            Object object3;
            Object object422;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object object422 : list) {
                boolean n;
                boolean bl = ((ResultSetRow)object422).getValue(1) != null && ((ResultSetRow)object422).getValue(2) != null && ((ResultSetRow)object422).getValue(3) != null;
                boolean bl2 = n = ((ResultSetRow)object422).getValue(5) == null;
                if (!bl || !n) continue;
                arrayList.add(object422);
            }
            ArrayList arrayList2 = new ArrayList();
            object422 = new StringBuffer();
            if (!arrayList.isEmpty()) {
                void var8_11;
                boolean resultSetRow = false;
                while (var8_11 < arrayList.size()) {
                    try {
                        this.executeHelpColumn(arrayList, (int)var8_11, 500, (StringBuffer)object422, arrayList2);
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() != 3523) {
                            throw sQLException;
                        }
                        for (void var10_17 = var8_11; var10_17 < arrayList.size() && var10_17 < var8_11 + 500; ++var10_17) {
                            this.executeHelpColumn(arrayList, (int)var10_17, 1, (StringBuffer)object422, arrayList2);
                        }
                    }
                    var8_11 += 500;
                }
            }
            if (!arrayList2.isEmpty()) {
                if (TeraDatabaseMetaData.this.log.canLog(1)) {
                    TeraDatabaseMetaData.this.log.info("TeraDatabaseMetaData.ObtainViewColumnMetaData.processRows: " + object422);
                }
                try (Statement statement = TeraDatabaseMetaData.this.m_session.createStatement();){
                    boolean bl;
                    boolean bl3 = statement.execute(((StringBuffer)object422).toString());
                    object3 = arrayList2.iterator();
                    while (bl && object3.hasNext()) {
                        ResultSetRow resultSetRow = (ResultSetRow)object3.next();
                        object2 = statement.getResultSet();
                        try {
                            object2.next();
                            object = object2.getString(3);
                            if (object != null) {
                                object = ((String)object).trim();
                            }
                            Integer n = object2.getObject(4) != null ? new Integer(object2.getInt(4)) : null;
                            Integer n2 = object2.getObject(5) != null ? new Integer(object2.getInt(5)) : null;
                            int n3 = object2.getInt(14);
                            resultSetRow.setValue(6, TeraDatabaseMetaData.helpColumnToDisplaySize((String)object, n2, n3, n));
                            resultSetRow.setValue(21, TeraDatabaseMetaData.helpTypeToJDBCType((String)object));
                        }
                        finally {
                            object2.close();
                        }
                        bl = statement.getMoreResults();
                    }
                }
            }
            for (ResultSetRow resultSetRow : arrayList) {
                object3 = (Integer)resultSetRow.getValue(4);
                Short s = (Short)resultSetRow.getValue(21);
                if ((object3 == null || (Integer)object3 != 2) && (object3 == null || (Integer)object3 != 2001 || s == null || s != 2)) continue;
                object2 = (Integer)resultSetRow.getValue(6);
                if (object2 != null && (Integer)object2 == -128) {
                    resultSetRow.setValue(6, new Integer(40));
                }
                if ((object = (Integer)resultSetRow.getValue(8)) == null || (Integer)object != -128) continue;
                resultSetRow.setValue(8, new Integer(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeHelpColumn(List list, int n, int n2, StringBuffer stringBuffer, List list2) throws SQLException {
            Object object2;
            int n3 = Math.min(n + n2, list.size());
            List list3 = list.subList(n, n3);
            StringBuffer stringBuffer2 = new StringBuffer();
            for (Object object2 : list3) {
                stringBuffer2.append(stringBuffer2.length() > 0 ? "," : "").append("\"").append(((ResultSetRow)object2).getValue(1).toString().replaceAll("\"", "\"\"")).append("\".\"").append(((ResultSetRow)object2).getValue(2).toString().replaceAll("\"", "\"\"")).append("\".\"").append(((ResultSetRow)object2).getValue(3).toString().replaceAll("\"", "\"\"")).append("\"");
            }
            String string = "help column " + stringBuffer2;
            if (TeraDatabaseMetaData.this.log.canLog(1)) {
                TeraDatabaseMetaData.this.log.info("TeraDatabaseMetaData.ObtainViewColumnMetaData.executeHelpColumn: " + (String)string);
            }
            object2 = TeraDatabaseMetaData.this.m_session.createStatement();
            try {
                try (ResultSet resultSet = object2.executeQuery(string);){
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    Iterator iterator = list3.iterator();
                    while (resultSet.next() && iterator.hasNext()) {
                        String string2;
                        String string3;
                        ResultSetRow resultSetRow = (ResultSetRow)iterator.next();
                        String string4 = resultSet.getString(2);
                        if (string4 != null) {
                            string4 = string4.trim();
                        }
                        if ((string3 = resultSet.getString(3)) != null) {
                            string3 = string3.trim();
                        }
                        Integer n4 = resultSet.getObject(5) != null ? new Integer(resultSet.getInt(5)) : null;
                        Integer n5 = resultSet.getObject(6) != null ? new Integer(resultSet.getInt(6)) : null;
                        Integer n6 = resultSet.getObject(7) != null ? new Integer(resultSet.getInt(7)) : null;
                        int n7 = resultSet.getInt(17);
                        String string5 = resultSetMetaData.getColumnCount() >= 19 ? resultSet.getString(19) : null;
                        String string6 = string2 = resultSetMetaData.getColumnCount() >= 45 ? resultSet.getString(45) : null;
                        if (string2 != null) {
                            string2 = string2.trim();
                        }
                        resultSetRow.setValue(4, TeraDatabaseMetaData.helpColumnToJDBCType(string4));
                        resultSetRow.setValue(5, TeraDatabaseMetaData.helpColumnToTeradataTypeName(string4, string5, string2));
                        resultSetRow.setValue(6, TeraDatabaseMetaData.helpColumnToDisplaySize(string4, n5, n7, n4));
                        resultSetRow.setValue(8, n6);
                        resultSetRow.setValue(10, TeraDatabaseMetaData.helpColumnToNullable(string3));
                        resultSetRow.setValue(15, n4);
                        resultSetRow.setValue(17, TeraDatabaseMetaData.helpColumnToIsNullable(string3));
                        if (!"UD".equals(string4) || resultSetMetaData.getColumnCount() < 41 || resultSet.getString(38) == null || resultSet.getString(41) == null) continue;
                        String string7 = Utility.quoteName(resultSet.getString(38)) + "." + Utility.quoteName(resultSet.getString(41));
                        stringBuffer.append((list2.isEmpty() ? "" : ";") + "help type " + string7);
                        list2.add(resultSetRow);
                    }
                }
                catch (SQLException sQLException) {
                    boolean bl;
                    boolean bl2 = bl = sQLException.getErrorCode() == 3523 && list3.size() == 1;
                    if (!bl) {
                        throw sQLException;
                    }
                }
            }
            finally {
                object2.close();
            }
        }
    }
}

