/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class ClientCredFlow {
    public static void clientCredFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        if (string != null && string.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1572", uRLParameters.getLogMech());
        }
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1573", uRLParameters.getLogMech());
        }
        if (uRLParameters.getOIDCClientID() != null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "OIDC_CLIENTID", uRLParameters.getLogMech());
        }
        if (uRLParameters.getOIDCScope() != null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "OIDC_SCOPE", uRLParameters.getLogMech());
        }
        if (uRLParameters.getLogData() == null || uRLParameters.getLogData().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1582", "LOGDATA", uRLParameters.getLogMech());
        }
        GenericTeradataConnection genericTeradataConnection2 = ConnectionFactory.makeLogMechNoneConnection(genericTeradataConnection);
        if (genericTeradataConnection2.getGtwConfig() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderURL() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderClientID() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string3 = Utility.coalesce(uRLParameters.getOIDCMetadata(), genericTeradataConnection2.getGtwConfig().getIdentityProviderURL());
        if (log.isDebugEnabled()) {
            log.debug("sIdProURL=" + string3);
        }
        if ((string3 = string3.replaceFirst("/+$", "")).length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string4 = "/.well-known/openid-configuration";
        if (!string3.toLowerCase().endsWith(string4)) {
            string3 = string3 + string4;
            if (log.isDebugEnabled()) {
                log.debug("Modified sIdProURL=" + string3);
            }
        }
        Utility.HttpResponse httpResponse = Utility.doHttpRequest(uRLParameters, log, "GET", string3, null, null, true, new int[]{200});
        genericTeradataConnection.addExtraClientAttribute("IDPC", httpResponse.sCertStatus);
        String string5 = httpResponse.sBody;
        String string6 = Utility.getStringFromJSON("token_endpoint", string5, "TJ1544", string3);
        String string7 = uRLParameters.getLogData();
        if (log.isDebugEnabled()) {
            log.debug("sJSON=" + string5);
            log.debug("sTokenURL=" + string6);
            log.debug("sFormData=" + string7);
        }
        byte[] byArray = Encoder.encodeStringUTF8(string7);
        string5 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string6, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
        String string8 = uRLParameters.getOIDCToken();
        if (log.isDebugEnabled()) {
            log.debug("sOIDCToken=" + string8);
            log.debug("sJSON=" + string5);
        }
        String string9 = Utility.getStringFromJSON(string8, string5, "TJ1552", string6);
        if (log.isDebugEnabled()) {
            log.debug("sJWT=" + string9);
        }
        uRLParameters.changeLogMech("JWT", "token=" + string9);
    }
}

