/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.statemachine.PreparedIndicMultiPartProtocol;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementSendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;

public class PreparedBatchStatementSendState
extends PreparedStatementSendState {
    private int numberOfStatementsInSubBatch = 1;

    public PreparedBatchStatementSendState(StatementController statementController) {
        super(statementController);
    }

    @Override
    public TDParcelState action() throws SQLException {
        if (this.abortRequest()) {
            return null;
        }
        if (this.paramProperties != null && this.paramProperties.numberOfParamSetsLeft() == 0) {
            this.paramProperties.resetParameterSetIndex();
        }
        TDParcelState tDParcelState = super.action();
        if (this.paramProperties != null && this.log.canLog(1)) {
            this.log.info("PreparedStatement batch sent " + this.numberOfStatementsInSubBatch + " rows; " + this.paramProperties.numberOfParamSetsLeft() + " rows remaining");
        }
        return tDParcelState;
    }

    private boolean abortRequest() throws SQLException {
        switch (this.controller.getStatement().getState()) {
            case 4: {
                this.controller.getStatement().setState(3);
                return false;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                if (this.controller.getStoredException() == null) {
                    this.controller.setStoredException(ErrorFactory.makeDriverJDBCException("TJ057"));
                }
                return true;
            }
        }
        return false;
    }

    protected int getNumberOfStatementsInSubBatch() {
        return this.numberOfStatementsInSubBatch;
    }

    @Override
    protected void initSubclassParcels() throws SQLException {
        super.initSubclassParcels();
        this.numberOfStatementsInSubBatch = ((PreparedIndicMultiPartProtocol)this.protocol).getNumberOfDataParcelsInBuffer();
    }

    @Override
    protected TDParcelState returnToController() {
        StatementReceiveState statementReceiveState = new StatementReceiveState(this.controller);
        this.controller.setHistoricalReturnState(this.paramProperties != null && this.paramProperties.numberOfParamSetsLeft() > 0 ? this : null);
        return statementReceiveState;
    }

    @Override
    protected byte getStatementIndependenceSetting() {
        return this.controller.getSession().getConfigResponse().isStatementIndependenceSupported() ? (byte)89 : 78;
    }
}

