/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.security.Security;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeraDriver
implements Driver {
    protected static Log sm_log = new Log("TeraDriver/" + TeraDriver.class.getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    private static final int FORMAT_TEXT = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_CSV = 3;
    private static Calendar DUMMY_CALENDAR;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        String string3;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string4 = "";
        String string5 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string6 = string.substring(string5.length());
        int n = string6.indexOf("/");
        if (n >= 0) {
            string3 = string6.substring(0, n);
            string4 = string6.substring(n + 1);
        } else {
            string3 = string6.trim();
            string4 = "";
        }
        if (string3.startsWith("[") && string3.endsWith("]")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (properties != null && properties.containsKey("username")) {
            boolean bl2;
            string2 = (String)properties.remove("username");
            boolean bl3 = bl2 = !properties.containsKey("user");
            if (bl2) {
                properties.setProperty("user", string2);
            }
        }
        URLParameters uRLParameters = new URLParameters(string4, properties);
        string2 = uRLParameters.getUser();
        String string7 = uRLParameters.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string3, string2, string7, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)connection;
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    @Override
    public int getMajorVersion() {
        return 20;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)clob;
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)blob;
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        AutoCloseable autoCloseable;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)currentThreadIO.getConnection()).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (autoCloseable = (TDResultSet)resultSetArray[i]) == null || ((TDResultSet)autoCloseable).isClosed()) continue;
            long l = ((TDResultSet)autoCloseable).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)autoCloseable).getRequestNumber() + " stmtnum=" + ((TDResultSet)autoCloseable).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)autoCloseable).getStatementNumber(), ((TDResultSet)autoCloseable).getRequestNumber(), l));
            ((TDResultSet)autoCloseable).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        autoCloseable = (TDStatement)tDSession.createStatement();
        StatementController statementController = new StatementController((TDStatement)autoCloseable, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    private static String quoteText(String string) {
        return string == null ? "null" : "\"" + string.replaceAll("[\r\n]+", " ").replaceAll("\"", "\"\"") + "\"";
    }

    private static String quoteCsvText(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= ' ' && c != ',' && c != '\"') continue;
            return "\"" + string.replaceAll("\"", "\"\"") + "\"";
        }
        return string;
    }

    private static String formatValue(int n, boolean bl, int n2, String string, String string2) {
        if (n == 1) {
            return string + " = " + TeraDriver.quoteText(string2);
        }
        if (n == 2) {
            return (bl ? string + "=" : (n2 > 1 ? " " : "")) + (string2 == null ? "null" : string2.replaceAll("[\r\n]+", "\n"));
        }
        return (n2 > 1 ? "," : "") + (string2 == null ? "" : TeraDriver.quoteCsvText(string2));
    }

    private static void printValue(PrintWriter printWriter, int n, boolean bl, int n2, int n3, String string, String string2) {
        boolean bl2;
        String string3 = TeraDriver.formatValue(n, bl, n2, string, string2);
        boolean bl3 = n == 1 || n == 2 && bl;
        boolean bl4 = bl2 = n2 >= n3;
        if (bl3 || bl2) {
            printWriter.println(string3);
        } else {
            printWriter.print(string3);
        }
    }

    private static void printArray(PrintWriter printWriter, int n, boolean bl, String[][] stringArray) {
        int n2;
        String[] stringArray2 = stringArray[0];
        for (int i = n2 = n == 3 ? 0 : 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            for (int j = 1; j <= stringArray3.length; ++j) {
                TeraDriver.printValue(printWriter, n, bl, j, stringArray3.length, stringArray2[j - 1], stringArray3[j - 1]);
            }
        }
    }

    private static void printNameValue(PrintWriter printWriter, int n, String string, String string2) {
        TeraDriver.printArray(printWriter, n, false, new String[][]{{string}, {string2}});
    }

    private static void printProps(PrintWriter printWriter, int n, Properties properties) {
        Map.Entry[] entryArray = properties == null ? new Map.Entry[]{} : properties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                Comparable comparable = (Comparable)entry.getKey();
                Comparable comparable2 = (Comparable)entry2.getKey();
                return comparable.compareTo(comparable2);
            }
        });
        String[][] stringArray = new String[][]{new String[entryArray.length], new String[entryArray.length]};
        for (int i = 0; i < entryArray.length; ++i) {
            stringArray[0][i] = (String)entryArray[i].getKey();
            stringArray[1][i] = (String)entryArray[i].getValue();
        }
        if (n == 1) {
            printWriter.println("(Properties " + (properties == null ? "null" : "" + entryArray.length) + ")");
        }
        TeraDriver.printArray(printWriter, n, true, stringArray);
    }

    private static String formatCsvHeader(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        return resultSetMetaData.getColumnName(n) + (bl ? " " + resultSetMetaData.getColumnTypeName(n) + (resultSetMetaData.getColumnType(n) == -2 ? "(" + resultSetMetaData.getPrecision(n) + ")" : "") + (resultSetMetaData.getColumnType(n) == 3 ? "(" + resultSetMetaData.getPrecision(n) + (resultSetMetaData.getScale(n) != 0 ? "," + resultSetMetaData.getScale(n) : "") + ")" : "") : "");
    }

    private static String formatAsHexDigits(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string + (string2.length() < 2 ? "0" : "") + string2;
        }
        return string;
    }

    private static byte[] parseHexDigits(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = (string.length() & 1) == 1;
        if (bl) {
            throw new IllegalArgumentException("Odd number of hex digits: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private static void printResultSetMetaData(PrintWriter printWriter, int n, Map<String, Boolean> map, ResultSetMetaData resultSetMetaData) throws SQLException {
        if (!map.values().contains(true)) {
            return;
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n2;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            if (map.get("getCatalogName").booleanValue()) {
                linkedHashMap.put("getCatalogName", "" + resultSetMetaData.getCatalogName(i));
            }
            if (map.get("getColumnClassName").booleanValue()) {
                linkedHashMap.put("getColumnClassName", "" + resultSetMetaData.getColumnClassName(i));
            }
            if (map.get("getColumnDisplaySize").booleanValue()) {
                linkedHashMap.put("getColumnDisplaySize", "" + resultSetMetaData.getColumnDisplaySize(i));
            }
            if (map.get("getColumnLabel").booleanValue()) {
                linkedHashMap.put("getColumnLabel", "" + resultSetMetaData.getColumnLabel(i));
            }
            if (map.get("getColumnName").booleanValue()) {
                linkedHashMap.put("getColumnName", "" + resultSetMetaData.getColumnName(i));
            }
            if (map.get("getColumnType").booleanValue()) {
                linkedHashMap.put("getColumnType", "" + resultSetMetaData.getColumnType(i));
            }
            if (map.get("getColumnTypeName").booleanValue()) {
                linkedHashMap.put("getColumnTypeName", "" + resultSetMetaData.getColumnTypeName(i));
            }
            if (map.get("getPrecision").booleanValue()) {
                linkedHashMap.put("getPrecision", "" + resultSetMetaData.getPrecision(i));
            }
            if (map.get("getScale").booleanValue()) {
                linkedHashMap.put("getScale", "" + resultSetMetaData.getScale(i));
            }
            if (map.get("getSchemaName").booleanValue()) {
                linkedHashMap.put("getSchemaName", "" + resultSetMetaData.getSchemaName(i));
            }
            if (map.get("getTableName").booleanValue()) {
                linkedHashMap.put("getTableName", "" + resultSetMetaData.getTableName(i));
            }
            if (map.get("isAutoIncrement").booleanValue()) {
                linkedHashMap.put("isAutoIncrement", "" + resultSetMetaData.isAutoIncrement(i));
            }
            if (map.get("isCaseSensitive").booleanValue()) {
                linkedHashMap.put("isCaseSensitive", "" + resultSetMetaData.isCaseSensitive(i));
            }
            if (map.get("isCurrency").booleanValue()) {
                linkedHashMap.put("isCurrency", "" + resultSetMetaData.isCurrency(i));
            }
            if (map.get("isDefinitelyWritable").booleanValue()) {
                linkedHashMap.put("isDefinitelyWritable", "" + resultSetMetaData.isDefinitelyWritable(i));
            }
            if (map.get("isNullable").booleanValue()) {
                linkedHashMap.put("isNullable", "" + resultSetMetaData.isNullable(i));
            }
            if (map.get("isReadOnly").booleanValue()) {
                linkedHashMap.put("isReadOnly", "" + resultSetMetaData.isReadOnly(i));
            }
            if (map.get("isSearchable").booleanValue()) {
                linkedHashMap.put("isSearchable", "" + resultSetMetaData.isSearchable(i));
            }
            if (map.get("isSigned").booleanValue()) {
                linkedHashMap.put("isSigned", "" + resultSetMetaData.isSigned(i));
            }
            if (map.get("isWritable").booleanValue()) {
                linkedHashMap.put("isWritable", "" + resultSetMetaData.isWritable(i));
            }
            ArrayList arrayList = new ArrayList(linkedHashMap.entrySet());
            if (n == 3 && i == 1) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), null, (String)((Map.Entry)arrayList.get(n2)).getKey());
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), (String)((Map.Entry)arrayList.get(n2)).getKey() + "(" + i + ")", (String)((Map.Entry)arrayList.get(n2)).getValue());
            }
        }
    }

    private static void printResultSet(PrintWriter printWriter, int n, Map<String, Boolean> map, boolean bl, String string, ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TeraDriver.printResultSetMetaData(printWriter, n, map, resultSetMetaData);
        if (n == 3) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), null, TeraDriver.formatCsvHeader(resultSetMetaData, n2, bl));
            }
        }
        while (resultSet.next()) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                Comparable<Calendar> comparable;
                String string2 = (string != null ? string + " " : "") + "Row " + resultSet.getRow() + " Column " + n2 + " " + TeraDriver.quoteText(resultSetMetaData.getColumnName(n2)) + " " + resultSetMetaData.getColumnTypeName(n2) + "(" + resultSetMetaData.getPrecision(n2) + ")";
                String string3 = resultSetMetaData.getColumnType(n2) == 2004 || resultSetMetaData.getColumnType(n2) == -2 || resultSetMetaData.getColumnType(n2) == -3 || resultSetMetaData.getColumnType(n2) == -4 ? TeraDriver.formatAsHexDigits(resultSet.getBytes(n2)) : (resultSetMetaData.getColumnType(n2) == 92 ? ((comparable = resultSet.getTimestamp(n2)) == null ? null : ((Timestamp)comparable).toString().substring("1970-01-01 ".length())) : resultSet.getString(n2));
                if (string3 != null && resultSetMetaData.getColumnTypeName(n2).endsWith(" WITH TIME ZONE")) {
                    comparable = Calendar.getInstance();
                    resultSet.getTimestamp(n2, (Calendar)comparable);
                    string3 = string3 + TDPreparedStatement.formatTimeZone(((Calendar)comparable).getTimeZone());
                }
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), string2, string3);
            }
        }
    }

    private static void printUpdateCounts(PrintWriter printWriter, int n, int[] nArray) {
        if (n == 3) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, null, "Update Counts");
        }
        for (int i = 0; i < nArray.length; ++i) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, "Update count " + (i + 1), "" + nArray[i]);
        }
    }

    private static CsvHeader[] parseCsvHeaders(String[] stringArray) {
        CsvHeader[] csvHeaderArray = new CsvHeader[stringArray.length];
        block0: for (int i = 0; i < csvHeaderArray.length; ++i) {
            CsvHeader csvHeader;
            csvHeaderArray[i] = csvHeader = new CsvHeader();
            csvHeader.sHeader = stringArray[i];
            csvHeader.nType = 1111;
            if (csvHeader.sHeader == null) continue;
            for (int j = 0; j < TypeDesc.types.length; ++j) {
                Matcher matcher = Pattern.compile("(?i).* " + TypeDesc.types[j].sTypeName + "(?:\\(([0-9]+)(?:,([0-9]+))?\\))?").matcher(csvHeader.sHeader);
                if (!matcher.matches()) continue;
                csvHeader.sTypeName = TypeDesc.types[j].sTypeName;
                csvHeader.nType = TypeDesc.types[j].nType;
                csvHeader.bTimeZone = csvHeader.sTypeName.endsWith(" WITH TIME ZONE");
                if (matcher.group(2) != null) {
                    csvHeader.nScale = Integer.parseInt(matcher.group(2));
                    continue block0;
                }
                if (matcher.group(1) == null) continue block0;
                csvHeader.nScale = Integer.parseInt(matcher.group(1));
                continue block0;
            }
        }
        return csvHeaderArray;
    }

    private static String[] readCsvRow(PeekReader peekReader) throws IOException {
        if (peekReader.peek() < 0) {
            return null;
        }
        StringList stringList = new StringList();
        stringList.add(null);
        boolean bl = false;
        int n;
        while ((n = peekReader.read()) >= 0) {
            if (bl) {
                if (n != 34) {
                    stringList.append(n);
                    continue;
                }
                if (peekReader.peek() == 34) {
                    stringList.append(peekReader.read());
                    continue;
                }
                bl = false;
                continue;
            }
            if (n == 44) {
                stringList.add(null);
                continue;
            }
            if (n == 34) {
                bl = true;
                continue;
            }
            if (n == 13) continue;
            if (n == 10) {
                return stringList.toStringArray();
            }
            stringList.append(n);
        }
        return stringList.toStringArray();
    }

    private static void bindValue(PreparedStatement preparedStatement, int n, int n2, CsvHeader csvHeader, String string) {
        try {
            if (csvHeader.nType == -6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setByte(n2, Byte.parseByte(string));
                }
            } else if (csvHeader.nType == 5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setShort(n2, Short.parseShort(string));
                }
            } else if (csvHeader.nType == 4) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setInt(n2, Integer.parseInt(string));
                }
            } else if (csvHeader.nType == -5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setLong(n2, Long.parseLong(string));
                }
            } else if (csvHeader.nType == 6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setDouble(n2, Double.parseDouble(string));
                }
            } else if (csvHeader.nType == 3) {
                preparedStatement.setObject(n2, (Object)(string == null ? null : new BigDecimal(string)), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == 2) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                }
            } else if (csvHeader.nType == 2005) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setCharacterStream(n2, (Reader)new StringReader(string), string.length());
                }
            } else if (csvHeader.nType == 2004) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    byte[] byArray = TeraDriver.parseHexDigits(string);
                    preparedStatement.setBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                }
            } else if (csvHeader.nType == -2) {
                preparedStatement.setObject(n2, (Object)TeraDriver.parseHexDigits(string), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == -3 || csvHeader.nType == -4) {
                preparedStatement.setBytes(n2, TeraDriver.parseHexDigits(string));
            } else if (csvHeader.nType == 91) {
                preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
            } else if (csvHeader.nType == 92) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTime(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else if (csvHeader.nType == 93) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTimestamp(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else {
                preparedStatement.setString(n2, string);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error for CSV line " + n + " column " + n2 + " value: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    private static <T> T safePeek(Stack<T> stack) {
        return stack.empty() ? null : (T)stack.peek();
    }

    private static <T> void pushDiff(Stack<T> stack, T t) {
        if (t != TeraDriver.safePeek(stack)) {
            stack.push(t);
        }
    }

    private static <T extends Closeable> void popClose(Stack<T> stack, T t) throws IOException {
        Closeable closeable = (Closeable)stack.pop();
        if (closeable != t) {
            closeable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Throwable {
        block203: {
            if (var0.length == 0) {
                System.err.println("Arguments: Command...");
                System.err.println("-i turns on interactive mode to prompt for commands from System.in");
                System.err.println("-im turns on interactive mode and sql:multi");
                System.err.println("-is turns on interactive mode and sql:semicolon");
                System.err.println("# begins a comment");
                System.err.println("agkr:generated returns generated keys");
                System.err.println("agkr:index,index,... returns the inserted column values corresponding to the specific column indexes");
                System.err.println("agkr:none (the default) does not use the Auto-Generated Key Retrieval feature");
                System.err.println("cont:message sets the continuation prompt to the specified message");
                System.err.println("csvline:string appends comma-separated values from the specified string for use by a subsequent parameterized SQL request");
                System.err.println("echo:message prints the specified message");
                System.err.println("exit stops reading commands from the current input source");
                System.err.println("format:csv formats output as comma-separated values");
                System.err.println("format:raw avoids formatting output");
                System.err.println("format:text (the default) formats output as text");
                System.err.println("getCatalogs prints the result from DatabaseMetaData.getCatalogs");
                System.err.println("getColumns:catalog,schemaPattern,tableNamePattern,columnNamePattern prints the result from DatabaseMetaData.getColumns");
                System.err.println("getDatabaseProductVersion prints the return value from DatabaseMetaData.getDatabaseProductVersion");
                System.err.println("getDriverVersion prints the return value from DatabaseMetaData.getDriverVersion");
                System.err.println("getSchemas prints the result from DatabaseMetaData.getSchemas");
                System.err.println("getTables:catalog,schemaPattern,tableNamePattern[,tableType]... prints the result from DatabaseMetaData.getTables");
                System.err.println("getURL prints the return value from DatabaseMetaData.getURL");
                System.err.println("host= prefix begins an ignored Python driver connection string");
                System.err.println("http-header:value adds an HTTP header for the next HTTP request");
                System.err.println("http-method:value overrides the default HTTP GET method to specify the HTTP method for the next HTTP request");
                System.err.println("http-params:name=value,name=value,... specifies driver connection parameters for the next HTTP request");
                System.err.println("http://... makes an HTTP request to the specified URL");
                System.err.println("https://... makes an HTTPS request to the specified URL");
                System.err.println("ignore:nsql:all ignores all non-SQLException");
                System.err.println("ignore:nsql:none (the default) stops for any non-SQLException");
                System.err.println("ignore:sql:all ignores all SQLException");
                System.err.println("ignore:sql:code,code,... ignores SQLException with one of the specified error codes");
                System.err.println("ignore:sql:none stops for any SQLException");
                System.err.println("input:filename reads commands from the specified file until EOF");
                System.err.println("input:stdin reads commands from System.in until EOF (interactive Ctrl+Z on Windows)");
                System.err.println("jdbc: prefix calls DriverManager.getConnection for the command");
                System.err.println("lsof prints the open file handles of the JVM on Linux");
                System.err.println("nativeSQL:command calls Connection.nativeSQL for the command");
                System.err.println("output:filename sends output to specified file");
                System.err.println("output:stdout (the default) sends output to System.out");
                System.err.println("pause waits for a line from System.in");
                System.err.println("pid prints the process ID of the JVM");
                System.err.println("prompt:message sets the prompt to the specified message");
                System.err.println("prop:name=value sets the property name to value for DriverManager.getConnection");
                System.err.println("props:filename reads Properties from the specified file for DriverManager.getConnection");
                System.err.println("props:list prints the Properties for DriverManager.getConnection");
                System.err.println("props:new specifies new empty Properties for DriverManager.getConnection");
                System.err.println("props:null (the default) specifies null Properties for DriverManager.getConnection");
                System.err.println("random:b64:count prints a base64 encoded string of the specified number of random bytes");
                System.err.println("random:b64u:count prints a base64 URL encoded string of the specified number of random bytes");
                System.err.println("random:hex:count prints a hex-format string of the specified number of random bytes");
                System.err.println("readcsv:filename reads comma-separated values from the specified UTF8-encoded file for use by a subsequent parameterized SQL request");
                System.err.println("rsmd:all prints all result set column metadata");
                System.err.println("rsmd:function,function,... prints only the result set column metadata returned from the specified ResultSetMetaData functions");
                System.err.println("rsmd:none (the default) does not print result set column metadata");
                System.err.println("Security.getProperty:name prints the specified Security property");
                System.err.println("Security.getProviders prints the list of Security providers");
                System.err.println("Security.setProperty:name=value sets the Security property name to value");
                System.err.println("sql:multi accepts multiple arguments or input lines as a SQL request up to an empty argument or input line");
                System.err.println("sql:semicolon accepts multiple arguments or input lines as a SQL request up to an argument or input line ending with a semicolon");
                System.err.println("sql:single (the default) accepts a single argument or input line as a SQL request");
                System.err.println("System.getProperties prints the Properties from System.getProperties");
                System.err.println("System.getProperty:name prints the specified System property");
                System.err.println("System.setProperty:name=value sets the System property name to value");
                System.err.println("verbose:connection (the default) and verbose:-connection control printing connection status");
                System.err.println("verbose:csvtypes and verbose:-csvtypes (the default) control printing data types in CSV header");
                System.err.println("verbose:dbmd and verbose:-dbmd (the default) control printing arguments before calling DatabaseMetaData methods");
                System.err.println("verbose:sql and verbose:-sql (the default) control printing the SQL request before executing");
                System.err.println("verbose:stack and verbose:-stack (the default) control printing SQLException stack traces");
                System.err.println("verbose:updatecounts and verbose:-updatecounts (the default) control printing update counts after executing");
                System.err.println("version prints the Teradata JDBC Driver version");
                System.err.println("Otherwise the SQL request is executed, using parameter values if previously specified");
                return;
            }
            var1_1 = 1;
            var2_2 = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
            var3_3 = new Stack<E>();
            try {
                var5_5 = var4_4 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
                try {
                    var6_6 = null;
                    try {
                        var7_7 = null;
                        var11_8 = 3;
                        var12_9 = null;
                        var13_10 = null;
                        var14_11 = null;
                        var15_12 = "GET";
                        var16_13 = new StringList();
                        var17_14 = new URLParameters("");
                        var18_15 = null;
                        var19_16 = false;
                        var20_17 = null;
                        var21_18 = new Integer(2);
                        var22_19 = true;
                        var23_20 = false;
                        var24_21 = false;
                        var25_22 = false;
                        var26_23 = false;
                        var27_24 = false;
                        var28_25 = new LinkedHashMap<String, Boolean>();
                        var28_25.put("getCatalogName", false);
                        var28_25.put("getColumnClassName", false);
                        var28_25.put("getColumnDisplaySize", false);
                        var28_25.put("getColumnLabel", false);
                        var28_25.put("getColumnName", false);
                        var28_25.put("getColumnType", false);
                        var28_25.put("getColumnTypeName", false);
                        var28_25.put("getPrecision", false);
                        var28_25.put("getScale", false);
                        var28_25.put("getSchemaName", false);
                        var28_25.put("getTableName", false);
                        var28_25.put("isAutoIncrement", false);
                        var28_25.put("isCaseSensitive", false);
                        var28_25.put("isCurrency", false);
                        var28_25.put("isDefinitelyWritable", false);
                        var28_25.put("isNullable", false);
                        var28_25.put("isReadOnly", false);
                        var28_25.put("isSearchable", false);
                        var28_25.put("isSigned", false);
                        var28_25.put("isWritable", false);
                        var29_26 = 0;
                        while (true) lbl-1000:
                        // 93 sources

                        {
                            var30_27 = null;
                            if (TeraDriver.safePeek(var3_3) == var2_2) {
                                if (var12_9 != null && var13_10 != null) {
                                    var4_4.print(var13_10);
                                } else if (var12_9 == null && var14_11 != null) {
                                    var4_4.print(var14_11);
                                }
                                var4_4.flush();
                            }
                            while (var30_27 == null && TeraDriver.safePeek(var3_3) != null) {
                                var30_27 = ((BufferedReader)TeraDriver.safePeek(var3_3)).readLine();
                                if (var30_27 != null) continue;
                                TeraDriver.popClose(var3_3, var2_2);
                            }
                            if (var30_27 == null && var29_26 < var0.length) {
                                var30_27 = var0[var29_26++];
                            }
                            var31_28 = false;
                            if (var12_9 != null) {
                                if (var30_27 == null) {
                                    var30_27 = var12_9;
                                    var12_9 = null;
                                    var31_28 = true;
                                } else if (var11_8 == 1 && var30_27.equals("")) {
                                    var30_27 = var12_9;
                                    var12_9 = null;
                                    var31_28 = true;
                                } else if (var11_8 == 2 && var30_27.endsWith(";")) {
                                    var30_27 = var12_9 + " " + var30_27;
                                    var12_9 = null;
                                    var31_28 = true;
                                } else {
                                    var12_9 = var12_9 + " " + var30_27;
                                    continue;
                                }
                            }
                            if (var30_27 == null) {
                                break block203;
                            }
                            try {
                                if (var30_27.equals("")) ** GOTO lbl-1000
                                if (var30_27.equals("-i") || var30_27.equals("-im") || var30_27.equals("-is")) {
                                    TeraDriver.pushDiff(var3_3, var2_2);
                                    var14_11 = ">>> ";
                                    var13_10 = "... ";
                                    var19_16 = true;
                                    var20_17 = new int[]{};
                                    if (var30_27.equals("-im")) {
                                        var11_8 = 1;
                                    }
                                    if (!var30_27.equals("-is")) ** GOTO lbl-1000
                                    var11_8 = 2;
                                }
                                if (var30_27.equals("sql:multi")) {
                                    var11_8 = 1;
                                }
                                if (var30_27.equals("sql:semicolon")) {
                                    var11_8 = 2;
                                }
                                if (var30_27.equals("sql:single")) {
                                    var11_8 = 3;
                                }
                                if (var30_27.startsWith("cont:")) {
                                    var13_10 = var30_27.substring("cont:".length());
                                }
                                if (var30_27.startsWith("prompt:")) {
                                    var14_11 = var30_27.substring("prompt:".length());
                                }
                                if (var30_27.equals("exit")) {
                                    if (var3_3.size() <= 0) ** GOTO lbl-1000
                                    TeraDriver.popClose(var3_3, var2_2);
                                }
                                if (var30_27.startsWith("#")) ** GOTO lbl-1000
                                if (var30_27.equals("version")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var30_27, Const.DRIVER_VERSION);
                                }
                                if (var30_27.equals("pid")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var30_27, ClientAttributesParcel.getJVMProcessID());
                                }
                                if (var30_27.equals("lsof")) {
                                    var32_29 = new File("/proc/self/fd").listFiles();
                                    if (var32_29 == null) {
                                        throw new IOException("/proc file system is not available");
                                    }
                                    var33_32 = new ArrayList<File>(Arrays.asList(var32_29));
                                    var32_29 = new File("/proc/self/map_files").listFiles();
                                    if (var32_29 != null) {
                                        var33_32.addAll(Arrays.asList(var32_29));
                                    }
                                    var34_51 = new LinkedHashMap<String, String>();
                                    for (String[][] var36_69 : var33_32) {
                                        var37_74 = var36_69.getName();
                                        var38_77 = null;
                                        try {
                                            var38_77 = Files.readSymbolicLink(var36_69.toPath()).toString();
                                        }
                                        catch (Throwable var39_80) {
                                            // empty catch block
                                        }
                                        if (var38_77 == null) continue;
                                        var39_81 = var37_74.indexOf(45);
                                        v0 = var40_83 = var39_81 >= 0;
                                        if (var40_83) {
                                            var37_74 = "mem-" + var37_74.substring(0, var39_81);
                                        }
                                        if (var41_86 = var40_83 != false && var34_51.containsValue(var38_77) != false) continue;
                                        var34_51.put(var37_74, (String)var38_77);
                                    }
                                    var35_62 = var34_51.entrySet().toArray(new Map.Entry[0]);
                                    var36_69 = new String[][]{new String[var35_62.length], new String[var35_62.length]};
                                    for (var37_73 = 0; var37_73 < var35_62.length; ++var37_73) {
                                        var36_69[0][var37_73] = (String)var35_62[var37_73].getKey();
                                        var36_69[1][var37_73] = (String)var35_62[var37_73].getValue();
                                    }
                                    if (var1_1 == 1) {
                                        var5_5.println("(Open files " + var35_62.length + ")");
                                    }
                                    TeraDriver.printArray(var5_5, var1_1, true, var36_69);
                                }
                                if (var30_27.startsWith("echo:")) {
                                    var32_29 = var30_27.substring("echo:".length());
                                    var5_5.println((String)var32_29);
                                }
                                if (var30_27.equals("pause")) {
                                    var5_5.println("Paused. Press Enter to continue:");
                                    var2_2.readLine();
                                }
                                if (var30_27.startsWith("prop:")) {
                                    var32_29 = Pattern.compile("prop:([^=]+)=(.*)").matcher(var30_27);
                                    if (!var32_29.matches()) {
                                        throw new IllegalArgumentException(var30_27);
                                    }
                                    if (var18_15 == null) {
                                        var18_15 = new Properties();
                                    }
                                    var18_15.setProperty(var32_29.group(1), var32_29.group(2));
                                }
                                if (var30_27.startsWith("props:")) {
                                    var32_29 = var30_27.substring("props:".length());
                                    if (var32_29.equals("null")) {
                                        var18_15 = null;
                                    }
                                    if (var32_29.equals("new")) {
                                        var18_15 = new Properties();
                                    }
                                    if (var32_29.equals("list")) {
                                        TeraDriver.printProps(var5_5, var1_1, var18_15);
                                    }
                                    var18_15 = new Properties();
                                    var33_33 = new FileInputStream((String)var32_29);
                                    try {
                                        var18_15.load(var33_33);
                                    }
                                    finally {
                                        var33_33.close();
                                    }
                                }
                                if (var30_27.equals("verbose:connection")) {
                                    var22_19 = true;
                                }
                                if (var30_27.equals("verbose:-connection")) {
                                    var22_19 = false;
                                }
                                if (var30_27.startsWith("host=")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Ignored", var30_27);
                                }
                                if (var30_27.startsWith("jdbc:")) {
                                    if (var6_6 != null) {
                                        var32_29 = var6_6;
                                        var6_6 = null;
                                        var32_29.close();
                                    }
                                    var6_6 = DriverManager.getConnection(var30_27, var18_15);
                                    if (!var22_19) ** GOTO lbl-1000
                                    TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"Status", "Remote", "Version", "Session"}, {var6_6.isClosed() != false ? "Closed" : "Connected", var6_6.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), var6_6.getMetaData().getDatabaseProductVersion(), var6_6.isClosed() != false ? null : var6_6.nativeSQL("{fn teradata_session_number}")}});
                                }
                                if (var30_27.startsWith("input:")) {
                                    var32_29 = var30_27.substring("input:".length());
                                    TeraDriver.pushDiff(var3_3, var32_29.equals("stdin") != false ? var2_2 : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)var32_29), "UTF-8")));
                                }
                                if (var30_27.startsWith("output:")) {
                                    var32_29 = var30_27.substring("output:".length());
                                    if (var5_5 != var4_4) {
                                        var5_5.close();
                                    }
                                    var5_5 = var4_4;
                                    if (var32_29.equals("stdout")) ** GOTO lbl-1000
                                    var5_5 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((String)var32_29), "UTF-8"), true);
                                }
                                if (var30_27.startsWith("format:")) {
                                    var32_29 = var30_27.substring("format:".length());
                                    if (var32_29.equals("text")) {
                                        var1_1 = 1;
                                    }
                                    if (var32_29.equals("raw")) {
                                        var1_1 = 2;
                                    }
                                    if (var32_29.equals("csv")) {
                                        var1_1 = 3;
                                    }
                                    throw new IllegalArgumentException("Unknown format " + (String)var32_29);
                                }
                                if (var30_27.equals("ignore:nsql:all")) {
                                    var19_16 = true;
                                }
                                if (var30_27.equals("ignore:nsql:none")) {
                                    var19_16 = false;
                                }
                                if (var30_27.equals("ignore:sql:all")) {
                                    var20_17 = new int[]{};
                                }
                                if (var30_27.equals("ignore:sql:none")) {
                                    var20_17 = null;
                                }
                                if (var30_27.startsWith("ignore:sql:")) {
                                    var32_29 = var30_27.substring("ignore:sql:".length());
                                    var33_34 = var32_29.split(",");
                                    if (var33_34.length == 0) {
                                        throw new IllegalArgumentException(var30_27);
                                    }
                                    var20_17 = new int[var33_34.length];
                                    var34_52 = 0;
                                    while (true) {
                                        if (var34_52 >= var33_34.length) ** GOTO lbl-1000
                                        var20_17[var34_52] = Integer.parseInt(var33_34[var34_52]);
                                        ++var34_52;
                                    }
                                }
                                if (var30_27.startsWith("System.setProperty:")) {
                                    var32_29 = Pattern.compile("System\\.setProperty:([^=]+)=(.*)").matcher(var30_27);
                                    if (!var32_29.matches()) {
                                        throw new IllegalArgumentException(var30_27);
                                    }
                                    System.setProperty(var32_29.group(1), var32_29.group(2));
                                }
                                if (var30_27.startsWith("System.getProperty:")) {
                                    var32_29 = var30_27.substring("System.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var32_29, System.getProperty((String)var32_29));
                                }
                                if (var30_27.equals("System.getProperties")) {
                                    TeraDriver.printProps(var5_5, var1_1, System.getProperties());
                                }
                                if (var30_27.startsWith("Security.setProperty:")) {
                                    var32_29 = Pattern.compile("Security\\.setProperty:([^=]+)=(.*)").matcher(var30_27);
                                    if (!var32_29.matches()) {
                                        throw new IllegalArgumentException(var30_27);
                                    }
                                    Security.setProperty(var32_29.group(1), var32_29.group(2));
                                }
                                if (var30_27.startsWith("Security.getProperty:")) {
                                    var32_29 = var30_27.substring("Security.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, (String)var32_29, Security.getProperty((String)var32_29));
                                }
                                if (var30_27.equals("Security.getProviders")) {
                                    var32_29 = Security.getProviders();
                                    var33_35 = new String[][]{new String[((Object)var32_29).length], new String[((Object)var32_29).length]};
                                    for (var34_53 = 0; var34_53 < ((Object)var32_29).length; ++var34_53) {
                                        var33_35[0][var34_53] = String.valueOf(var32_29[var34_53]);
                                        var33_35[1][var34_53] = var32_29[var34_53].getInfo();
                                    }
                                    if (var1_1 == 1) {
                                        var5_5.println("(Providers " + ((Object)var32_29).length + ")");
                                    }
                                    TeraDriver.printArray(var5_5, var1_1, true, var33_35);
                                }
                                if (var30_27.startsWith("random:b64:") || var30_27.startsWith("random:b64u:") || var30_27.startsWith("random:hex:")) {
                                    var32_29 = var30_27.split(":", 3);
                                    var33_36 = Utility.getRandomBytes(Integer.parseInt((String)var32_29[2]));
                                    TeraDriver.printNameValue(var5_5, var1_1, var30_27, var32_29[1].equals("hex") != false ? Utility.formatByteArrayAsHexDigits(var33_36) : Utility.base64Encode(var32_29[1].equals("b64u"), var33_36));
                                }
                                if (var30_27.startsWith("http-method:")) {
                                    var15_12 = var30_27.substring("http-method:".length()).trim().toUpperCase();
                                }
                                if (var30_27.startsWith("http-header:")) {
                                    var16_13.add(var30_27.substring("http-header:".length()));
                                }
                                if (var30_27.startsWith("http-params:")) {
                                    var17_14 = new URLParameters(var30_27.substring("http-params:".length()));
                                    TeraDriver.sm_log.setLogLevel(var17_14.getLogLevel());
                                }
                                if (var30_27.startsWith("http:") || var30_27.startsWith("https:")) {
                                    var32_29 = var15_12;
                                    var15_12 = "GET";
                                    var33_37 = var16_13.isEmpty() != false ? null : var16_13.toStringArray();
                                    var16_13.clear();
                                    var34_54 = Utility.doHttpRequest(var17_14, TeraDriver.sm_log, (String)var32_29, var30_27, var33_37, null, false, null);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Code", "" + var34_54.nCode);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Message", var34_54.sMessage);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Body", var34_54.sBody);
                                }
                                if (var30_27.equals("verbose:dbmd")) {
                                    var23_20 = true;
                                }
                                if (var30_27.equals("verbose:-dbmd")) {
                                    var23_20 = false;
                                }
                                if (var30_27.equals("verbose:sql")) {
                                    var24_21 = true;
                                }
                                if (var30_27.equals("verbose:-sql")) {
                                    var24_21 = false;
                                }
                                if (var30_27.equals("rsmd:all")) {
                                    var32_29 = var28_25.keySet().iterator();
                                    while (true) {
                                        if (!var32_29.hasNext()) ** GOTO lbl-1000
                                        var33_38 = (String)var32_29.next();
                                        var28_25.put(var33_38, true);
                                    }
                                }
                                if (var30_27.equals("rsmd:none")) {
                                    var32_29 = var28_25.keySet().iterator();
                                    while (true) {
                                        if (!var32_29.hasNext()) ** GOTO lbl-1000
                                        var33_39 = (String)var32_29.next();
                                        var28_25.put(var33_39, false);
                                    }
                                }
                                if (var30_27.startsWith("rsmd:")) {
                                    var32_29 = var30_27.substring("rsmd:".length()).split(",");
                                    if (((Object)var32_29).length == 0) {
                                        throw new IllegalArgumentException(var30_27);
                                    }
                                    for (String var34_55 : var28_25.keySet()) {
                                        var28_25.put(var34_55, false);
                                    }
                                    var33_40 = var32_29;
                                    var34_56 = ((Object)var33_40).length;
                                    var35_63 = 0;
                                    while (true) {
                                        if (var35_63 >= var34_56) ** GOTO lbl-1000
                                        var36_70 = var33_40[var35_63];
                                        if (!var28_25.containsKey(var36_70)) {
                                            throw new IllegalArgumentException((String)var36_70);
                                        }
                                        var28_25.put((String)var36_70, true);
                                        ++var35_63;
                                    }
                                }
                                if (var30_27.equals("verbose:csvtypes")) {
                                    var25_22 = true;
                                }
                                if (var30_27.equals("verbose:-csvtypes")) {
                                    var25_22 = false;
                                }
                                if (var30_27.equals("verbose:updatecounts")) {
                                    var26_23 = true;
                                }
                                if (var30_27.equals("verbose:-updatecounts")) {
                                    var26_23 = false;
                                }
                                if (var30_27.equals("verbose:stack")) {
                                    var27_24 = true;
                                }
                                if (var30_27.equals("verbose:-stack")) {
                                    var27_24 = false;
                                }
                                if (var30_27.equals("agkr:none")) {
                                    var21_18 = new Integer(2);
                                }
                                if (var30_27.equals("agkr:generated")) {
                                    var21_18 = new Integer(1);
                                }
                                if (var30_27.startsWith("agkr:")) {
                                    var32_29 = var30_27.substring("agkr:".length());
                                    var33_41 = var32_29.split(",");
                                    if (var33_41.length == 0) {
                                        throw new IllegalArgumentException(var30_27);
                                    }
                                    var34_57 = new int[var33_41.length];
                                    var21_18 = var34_57;
                                    var35_64 = 0;
                                    while (true) {
                                        if (var35_64 >= var33_41.length) ** GOTO lbl-1000
                                        var34_57[var35_64] = Integer.parseInt(var33_41[var35_64]);
                                        ++var35_64;
                                    }
                                }
                                if (var30_27.startsWith("csvline:")) {
                                    var32_29 = var30_27.substring("csvline:".length()) + "\n";
                                    var33_42 = new ByteArrayInputStream(var32_29.getBytes("UTF-8"));
                                    var7_7 = var7_7 == null ? var33_42 : new SequenceInputStream(var7_7, var33_42);
                                }
                                if (var30_27.startsWith("readcsv:")) {
                                    var32_29 = var30_27.substring("readcsv:".length());
                                    var33_43 = new FileInputStream((String)var32_29);
                                    var7_7 = var7_7 == null ? var33_43 : new SequenceInputStream(var7_7, var33_43);
                                }
                                if (var6_6 == null) {
                                    throw new IllegalArgumentException("No connection available for " + var30_27);
                                }
                                if (var30_27.equals("getCatalogs")) {
                                    var32_29 = var6_6.getMetaData().getCatalogs();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, "getCatalogs", (ResultSet)var32_29);
                                    }
                                    finally {
                                        var32_29.close();
                                    }
                                }
                                if (var30_27.equals("getSchemas")) {
                                    var32_29 = var6_6.getMetaData().getSchemas();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, "getSchemas", (ResultSet)var32_29);
                                    }
                                    finally {
                                        var32_29.close();
                                    }
                                }
                                if (var30_27.startsWith("getTables:")) {
                                    var32_29 = var30_27.substring("getTables:".length()).split(",", -1);
                                    if (((Object)var32_29).length < 3) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var30_27);
                                    }
                                    for (var33_44 = 0; var33_44 < ((Object)var32_29).length; ++var33_44) {
                                        if (!"null".equals(var32_29[var33_44])) continue;
                                        var32_29[var33_44] = null;
                                    }
                                    v1 = var33_45 = ((Object)var32_29).length <= 3 ? null : (String[])Arrays.copyOfRange(var32_29, 3, ((Object)var32_29).length);
                                    if (var23_20) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getTables catalog", "getTables schemaPattern", "getTables tableNamePattern", "getTables tableTypes"}, {var32_29[0], var32_29[1], var32_29[2], var33_45 == null ? null : Arrays.toString(var33_45)}});
                                    }
                                    var34_58 = var6_6.getMetaData().getTables((String)var32_29[0], (String)var32_29[1], (String)var32_29[2], (String[])var33_45);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, "getTables", var34_58);
                                    }
                                    finally {
                                        var34_58.close();
                                    }
                                }
                                if (var30_27.startsWith("getColumns:")) {
                                    var32_29 = var30_27.substring("getColumns:".length()).split(",", -1);
                                    if (((Object)var32_29).length != 4) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var30_27);
                                    }
                                    for (var33_46 = 0; var33_46 < ((Object)var32_29).length; ++var33_46) {
                                        if (!"null".equals(var32_29[var33_46])) continue;
                                        var32_29[var33_46] = null;
                                    }
                                    if (var23_20) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getColumns catalog", "getColumns schemaPattern", "getColumns tableNamePattern", "getColumns columnNamePattern"}, {var32_29[0], var32_29[1], var32_29[2], var32_29[3]}});
                                    }
                                    var33_47 = var6_6.getMetaData().getColumns((String)var32_29[0], (String)var32_29[1], (String)var32_29[2], (String)var32_29[3]);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, "getColumns", var33_47);
                                    }
                                    finally {
                                        var33_47.close();
                                    }
                                }
                                if (var30_27.equals("getDatabaseProductVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var30_27, var6_6.getMetaData().getDatabaseProductVersion());
                                }
                                if (var30_27.equals("getDriverVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var30_27, var6_6.getMetaData().getDriverVersion());
                                }
                                if (var30_27.equals("getURL")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var30_27, var6_6.getMetaData().getURL());
                                }
                                if (var30_27.startsWith("nativeSQL:")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "nativeSQL", var6_6.nativeSQL(var30_27.substring("nativeSQL:".length())));
                                }
                                if (var11_8 == 1 && !var31_28) {
                                    var12_9 = var30_27;
                                }
                                if (var11_8 == 2 && !var31_28 && !var30_27.endsWith(";")) {
                                    var12_9 = var30_27;
                                }
                                if (var7_7 != null) {
                                    try {
                                        var32_29 = new PeekReader(new InputStreamReader(var7_7, "UTF-8"));
                                        try {
                                            var33_48 = TeraDriver.readCsvRow((PeekReader)var32_29);
                                            if (var33_48 == null) {
                                                throw new IllegalArgumentException("CSV header line is missing and no CSV data lines are available");
                                            }
                                            var34_59 = TeraDriver.parseCsvHeaders(var33_48);
                                            if (var24_21) {
                                                var5_5.println(var30_27);
                                            }
                                            var35_65 = var21_18 instanceof int[] != false ? var6_6.prepareStatement(var30_27, (int[])var21_18) : var6_6.prepareStatement(var30_27, (Integer)var21_18);
                                            try {
                                                var36_71 = 0;
                                                while (true) {
                                                    if ((var37_75 = TeraDriver.readCsvRow((PeekReader)var32_29)) == null && var36_71 >= 2 || var37_75 != null && var36_71 >= 1) {
                                                        var35_65.addBatch();
                                                    }
                                                    if (var37_75 == null) break;
                                                    if (var37_75.length != var34_59.length) {
                                                        throw new IllegalArgumentException("CSV data line " + var32_29.lineNumber + " contains " + var37_75.length + " values instead of the expected " + var34_59.length + " values");
                                                    }
                                                    for (var38_79 = 0; var38_79 < var37_75.length; ++var38_79) {
                                                        TeraDriver.bindValue(var35_65, var32_29.lineNumber, var38_79 + 1, var34_59[var38_79], var37_75[var38_79]);
                                                    }
                                                    ++var36_71;
                                                }
                                                var37_73 = 0;
                                                var38_77 = null;
                                                if (var36_71 >= 2) {
                                                    var38_77 = var35_65.executeBatch();
                                                } else {
                                                    var37_73 = (int)var35_65.execute();
                                                }
                                                var39_82 = 1;
                                                while (true) {
                                                    if (var26_23) {
                                                        if (var36_71 >= 2) {
                                                            TeraDriver.printUpdateCounts(var5_5, var1_1, (int[])var38_77);
                                                        } else if (var37_73 == 0) {
                                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var35_65.getUpdateCount());
                                                        }
                                                    }
                                                    if (var37_73 != 0) {
                                                        var40_84 = var35_65.getResultSet();
                                                        try {
                                                            TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, "Result " + var39_82, var40_84);
                                                        }
                                                        finally {
                                                            var40_84.close();
                                                        }
                                                    }
                                                    var40_84 = var35_65.getGeneratedKeys();
                                                    try {
                                                        TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, var21_18 instanceof int[] != false ? "Inserted" : "Generated", var40_84);
                                                    }
                                                    finally {
                                                        var40_84.close();
                                                    }
                                                    if (var36_71 >= 2) ** GOTO lbl-1000
                                                    var37_73 = (int)var35_65.getMoreResults();
                                                    v2 = var40_85 = var37_73 != 0 || var35_65.getUpdateCount() != -1;
                                                    if (!var40_85) ** GOTO lbl-1000
                                                    ++var39_82;
                                                }
                                            }
                                            finally {
                                                var35_65.close();
                                            }
                                        }
                                        finally {
                                            var32_29.close();
                                        }
                                    }
                                    finally {
                                        var7_7 = null;
                                    }
                                }
                                var32_29 = var6_6.createStatement();
                                try {
                                    if (var24_21) {
                                        var5_5.println(var30_27);
                                    }
                                    var33_49 = var21_18 instanceof int[] != false ? var32_29.execute(var30_27, (int[])var21_18) : var32_29.execute(var30_27, (Integer)var21_18);
                                    var34_60 = 1;
                                    while (true) {
                                        if (!var33_49 && var32_29.getUpdateCount() == -1) ** GOTO lbl-1000
                                        if (var33_49) {
                                            var35_66 = var32_29.getResultSet();
                                            try {
                                                TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, "Result " + var34_60, var35_66);
                                            }
                                            finally {
                                                var35_66.close();
                                            }
                                        }
                                        if (var26_23) {
                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var32_29.getUpdateCount());
                                        }
                                        var35_66 = var32_29.getGeneratedKeys();
                                        try {
                                            TeraDriver.printResultSet(var5_5, var1_1, var28_25, var25_22, var21_18 instanceof int[] != false ? "Inserted" : "Generated", var35_66);
                                        }
                                        finally {
                                            var35_66.close();
                                        }
                                        var33_49 = var32_29.getMoreResults();
                                        ++var34_60;
                                    }
                                }
                                finally {
                                    var32_29.close();
                                }
                            }
                            catch (SQLException var32_30) {
                                var33_50 = var20_17 != null && var20_17.length == 0;
                                for (var34_61 = 0; !var33_50 && var20_17 != null && var34_61 < var20_17.length; ++var34_61) {
                                    if (var32_30.getErrorCode() != var20_17[var34_61]) continue;
                                    var33_50 = true;
                                }
                                if (var33_50) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var32_30);
                                }
                                var34_61 = 0;
                                for (var35_67 = var32_30; var35_67 != null; var35_67 = var35_67.getNextException()) {
                                    ++var34_61;
                                }
                                var35_68 = 1;
                                for (var36_72 = var32_30; var36_72 != null; var36_72 = var36_72.getNextException()) {
                                    var37_76 = new StringWriter();
                                    var36_72.printStackTrace(new PrintWriter((Writer)var37_76, true));
                                    var5_5.println("SQLException " + var35_68 + " of " + var34_61 + ": " + (var27_24 != false ? "" + var37_76 : "" + var36_72));
                                    ++var35_68;
                                }
                                throw var32_30;
                            }
                            catch (Throwable var32_31) {
                                if (var19_16) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var32_31);
                                    continue;
                                }
                                throw var32_31;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                        finally {
                            if (var7_7 != null) {
                                var7_7.close();
                            }
                        }
                    }
                    finally {
                        if (var6_6 != null) {
                            var6_6.close();
                        }
                    }
                }
                finally {
                    if (var5_5 != var4_4) {
                        var5_5.close();
                    }
                }
            }
            finally {
                while (var3_3.size() > 0) {
                    TeraDriver.popClose(var3_3, var2_2);
                }
            }
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            sm_log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
        DUMMY_CALENDAR = Calendar.getInstance();
    }

    private static class StringList
    extends ArrayList {
        public String[] toStringArray() {
            return this.toArray(new String[0]);
        }

        public void append(int n) {
            int n2 = this.size() - 1;
            String string = (String)this.get(n2);
            if (string == null) {
                string = "";
            }
            this.set(n2, string + (char)n);
        }
    }

    private static class PeekReader
    extends PushbackReader {
        public int lineNumber = 0;

        public PeekReader(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n == 10) {
                ++this.lineNumber;
            }
            return n;
        }

        public int peek() throws IOException {
            int n = super.read();
            if (n >= 0) {
                this.unread(n);
            }
            return n;
        }
    }

    private static class CsvHeader {
        public String sHeader;
        public int nType;
        public String sTypeName;
        public boolean bTimeZone;
        public int nScale;

        private CsvHeader() {
        }
    }

    private static class TypeDesc {
        public String sTypeName;
        public int nType;
        public static TypeDesc[] types = new TypeDesc[]{new TypeDesc("BYTEINT", -6), new TypeDesc("SMALLINT", 5), new TypeDesc("INTEGER", 4), new TypeDesc("BIGINT", -5), new TypeDesc("FLOAT", 6), new TypeDesc("DECIMAL", 3), new TypeDesc("NUMBER", 2), new TypeDesc("CLOB", 2005), new TypeDesc("CHAR", 1), new TypeDesc("VARCHAR", 12), new TypeDesc("LONGVARCHAR", -1), new TypeDesc("BLOB", 2004), new TypeDesc("BYTE", -2), new TypeDesc("VARBYTE", -3), new TypeDesc("LONGVARBYTE", -4), new TypeDesc("DATE", 91), new TypeDesc("TIME", 92), new TypeDesc("TIME WITH TIME ZONE", 92), new TypeDesc("TIMESTAMP", 93), new TypeDesc("TIMESTAMP WITH TIME ZONE", 93)};

        private TypeDesc(String string, int n) {
            this.sTypeName = string;
            this.nType = n;
        }
    }
}

