/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignParcel;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.AuthMechParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConnectParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SSORequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionOptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import org.ietf.jgss.Oid;

public class GenericLogonController {
    private LogonInformation m_logonInfo;
    private GenericTeradataConnection m_con;
    private Reconnect m_reconnect;
    private boolean m_bConfigOnly;

    public GenericLogonController(GenericTeradataConnection genericTeradataConnection) {
        this.m_logonInfo = genericTeradataConnection.getLogonInformation();
        this.m_con = genericTeradataConnection;
    }

    public void setReconnect(Reconnect reconnect) {
        this.m_reconnect = reconnect;
    }

    public void setConfigOnly() {
        this.m_bConfigOnly = true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws SQLException {
        Parcel parcel;
        Object object;
        Object object2;
        void var15_26;
        Object object3;
        Object object4;
        Object object5;
        ArrayList<Oid> arrayList;
        TDPacket tDPacket;
        Log log;
        block85: {
            String string;
            Object object6;
            Object object7;
            block86: {
                boolean bl;
                boolean bl2;
                Oid oid;
                boolean bl3;
                Oid oid2;
                Object object8;
                Object object9;
                block87: {
                    log = this.m_con.getLog();
                    tDPacket = this.m_con.createPacket(1);
                    if (log.isDebugEnabled()) {
                        log.debug("GenericLogonController.run: reconnect=" + (this.m_reconnect != null) + " ConfigResponse=" + (this.m_con.getConfigResponse() != null) + " GtwConfig=" + (this.m_con.getGtwConfig() != null) + " AuthMech=" + !this.m_con.getAuthMechParcels().isEmpty() + " m_bConfigOnly=" + this.m_bConfigOnly);
                    }
                    tDPacket.setInitParcelPosition();
                    tDPacket.setLANKind((byte)10);
                    tDPacket.setByteVar((byte)7);
                    tDPacket.setHostCharSet((byte)-1);
                    if (this.m_reconnect != null) {
                        tDPacket.setSessionNumber(this.m_con.getSessionNum());
                        tDPacket.setAuthentication(this.m_reconnect.nAuthenticationNonce);
                    }
                    ClientConfigParcel clientConfigParcel = new ClientConfigParcel(this.m_con);
                    tDPacket.addParcel(clientConfigParcel);
                    tDPacket.toStream();
                    tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                    tDPacket.clear();
                    tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                    tDPacket.initParcelFactory(this.m_con);
                    ArrayList<AuthMechParcel> arrayList2 = new ArrayList<AuthMechParcel>();
                    arrayList = new ArrayList<Oid>();
                    block32: while ((object5 = tDPacket.nextParcel()) != null) {
                        switch (((Parcel)object5).getFlavor()) {
                            case 43: {
                                object9 = (ConfigRspParcel)object5;
                                this.m_con.setConfigResponse((ConfigRspParcel)object9);
                                continue block32;
                            }
                            case 165: {
                                object7 = (GtwConfigParcel)object5;
                                this.m_con.setGtwConfig((GtwConfigParcel)object7);
                                continue block32;
                            }
                            case 167: {
                                object6 = (AuthMechParcel)object5;
                                arrayList2.add((AuthMechParcel)object6);
                                if (!((AuthMechParcel)object6).isCIBypassSupported() || !this.m_con.getIO().isSSLSocket()) continue block32;
                                arrayList.add(((AuthMechParcel)object6).getMechOid());
                                continue block32;
                            }
                            case 9: {
                                FailureParcel failureParcel = (FailureParcel)object5;
                                throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                            }
                            case 49: {
                                ErrorParcel errorParcel = (ErrorParcel)object5;
                                throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                            }
                        }
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object5).getFlavor()));
                    }
                    this.m_con.setAuthMechParcels(arrayList2);
                    if (this.m_con.getConfigResponse() == null || this.m_con.getGtwConfig() == null || this.m_con.getAuthMechParcels().isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ1560");
                    }
                    if (this.m_bConfigOnly) {
                        return;
                    }
                    object5 = this.m_con.getTeraEncrypt();
                    object9 = new ArrayList();
                    object7 = null;
                    object6 = null;
                    for (Object object10 : this.m_con.getAuthMechParcels()) {
                        if (log.isDebugEnabled()) {
                            log.debug("New Server Mechanism: " + ((GenericTeraEncrypt)object5).getMechNameForOid(((AuthMechParcel)object10).getMechOid()) + "   " + ((AuthMechParcel)object10).getMechOid());
                        }
                        object9.add(((AuthMechParcel)object10).getMechOid());
                        if (((AuthMechParcel)object10).isDefaultMechanism()) {
                            object7 = ((AuthMechParcel)object10).getMechOid();
                            if (log.isDebugEnabled()) {
                                log.debug(" Default Server Mechanism is: " + ((AuthMechParcel)object10).getMechOid());
                            }
                        }
                        if (!((AuthMechParcel)object10).isDefaultNegotiatingMechanism()) continue;
                        object6 = ((AuthMechParcel)object10).getMechOid();
                        if (!log.isDebugEnabled()) continue;
                        log.debug(" Negotiation Mechanism Supported: " + this.m_con.getGtwConfig().isNegotiationMechanismSupported() + "   Default Server Negotiating Mechanism is: " + ((AuthMechParcel)object10).getMechOid());
                    }
                    string = this.m_con.getURLParameters().getLogMech();
                    if ("NONE".equalsIgnoreCase(string)) {
                        this.m_con.getIO().close();
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        Object object10;
                        object10 = this.m_con.getURLParameters().getLogMech(true);
                        object8 = this.m_con.getURLParameters().getLogData();
                        boolean bl4 = object8 != null && ((String)object8).startsWith("token=");
                        oid2 = bl4 ? ((String)object8).substring("token=".length()) : null;
                        String[] stringArray = oid2 != null ? ((String)((Object)oid2)).split("\\.") : null;
                        log.debug("Original LOGMECH=" + (String)object10 + " Current LOGMECH=" + (String)string + " LOGDATA=" + (String)object8 + " (len=" + (object8 != null ? "" + ((String)object8).length() : "n/a") + ")" + " bHasToken=" + bl4 + " asParts.length=" + (stringArray != null ? "" + stringArray.length : "n/a"));
                        if (stringArray != null && stringArray.length == 3) {
                            try {
                                String string2 = Utility.reformatJSONAsLines(Decoder.getUTF8DecodedString(Base64.getUrlDecoder().decode(stringArray[0])));
                                String string3 = Utility.reformatJSONAsLines(Decoder.getUTF8DecodedString(Base64.getUrlDecoder().decode(stringArray[1])));
                                log.debug("Original LOGMECH=" + (String)object10 + " sJWTHeader=" + string2);
                                log.debug("Original LOGMECH=" + (String)object10 + " sJWTPayload=" + string3);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                log.debug("LOGMECH=" + (String)string + " cannot decode JWT", illegalArgumentException);
                            }
                        }
                    }
                    if (object9.isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ334");
                    }
                    bl3 = false;
                    object8 = null;
                    oid = ((GenericTeraEncrypt)object5).getClientDefaultMech(false);
                    Oid oid3 = oid2 = this.m_con.getGtwConfig().isNegotiationMechanismSupported() ? ((GenericTeraEncrypt)object5).getClientDefaultMech(true) : null;
                    if (string == null && oid == null && oid2 == null) break block86;
                    if (string != null && (object8 = ((GenericTeraEncrypt)object5).getOidForName(string)) == null) {
                        throw ErrorFactory.makeDriverJDBCException("TJ335", string);
                    }
                    boolean bl5 = false;
                    bl2 = false;
                    bl = false;
                    object4 = object9.iterator();
                    while (object4.hasNext()) {
                        object3 = (Oid)object4.next();
                        if (object8 != null && ((Oid)object8).equals(object3)) {
                            bl5 = true;
                        }
                        if (oid != null && oid.equals(object3)) {
                            bl2 = true;
                        }
                        if (oid2 == null || !oid2.equals(object3)) continue;
                        bl = true;
                    }
                    if (!bl5) break block87;
                    Object object11 = object8;
                    break block85;
                }
                if (bl) {
                    Oid oid4 = oid2;
                    bl3 = true;
                    break block85;
                } else if (bl2) {
                    Oid oid5 = oid;
                    bl3 = true;
                    break block85;
                } else {
                    object4 = null;
                    if (object8 != null) {
                        object4 = string;
                    } else if (oid2 != null) {
                        object4 = oid2.toString();
                    } else if (oid != null) {
                        object4 = oid.toString();
                    }
                    object3 = new StringBuffer(Log.LINE_SEP + ErrorMessage.Format1(ErrorMessage.messages.getString("TJ340"), (String)object4) + Log.LINE_SEP + ErrorMessage.messages.getString("TJ337"));
                    Iterator iterator = object9.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw ErrorFactory.makeDriverJDBCException("TJ341", ((StringBuffer)object3).toString());
                        }
                        Oid oid6 = (Oid)iterator.next();
                        ((StringBuffer)object3).append(Log.LINE_SEP + ((GenericTeraEncrypt)object5).getMechNameForOid(oid6) + "  " + oid6);
                    }
                }
            }
            if (this.m_con.getGtwConfig().isNegotiationMechanismSupported() && object6 != null) {
                Object object12 = object6;
            } else {
                if (object7 == null) {
                    throw ErrorFactory.makeDriverJDBCException("TJ333", string);
                }
                Object object13 = object7;
            }
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)2 : 1);
        tDPacket.setByteVar((byte)7);
        tDPacket.setAuthentication(this.m_reconnect != null ? this.m_reconnect.nAuthenticationNonce : this.m_con.getAuthenticationNonce());
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        if (this.m_reconnect != null) {
            tDPacket.setSessionNumber(this.m_con.getSessionNum());
        }
        AssignParcel assignParcel = new AssignParcel(this.m_con);
        ((GenericTeraEncrypt)object5).useAuthMech(this.m_con, (Oid)var15_26);
        byte[] byArray = ((GenericTeraEncrypt)object5).getIntoken();
        byte[] byArray2 = ((GenericTeraEncrypt)object5).initSecContext(byArray, 0, byArray.length, arrayList);
        if (byArray2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ343");
        }
        object4 = new SSORequestParcel(this.m_con);
        ((SSORequestParcel)object4).setTrip(((GenericTeraEncrypt)object5).getTrip());
        ((GenericTeraEncrypt)object5).incTrip();
        ((SSORequestParcel)object4).setAuthData(byArray2);
        ((SSORequestParcel)object4).setMethod(((GenericTeraEncrypt)object5).getSSOAuthMethod());
        tDPacket.addParcel((Parcel)object4);
        ((GenericTeraEncrypt)object5).updateGeneratedCredentials();
        if (!this.m_con.isExtObjectNameParcelSupported()) {
            assignParcel.setUserName(((GenericTeraEncrypt)object5).isUsingGeneratedCredentials() ? "" : this.m_logonInfo.getUserName());
        }
        tDPacket.addParcel(assignParcel);
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        if (log.isDebugEnabled()) {
            log.debug("packet.getEncryption=" + tDPacket.getEncryption());
        }
        this.m_con.setSessionNum(tDPacket.getLANSessionNumber());
        block36: while ((object3 = tDPacket.nextParcel()) != null) {
            switch (((Parcel)object3).getFlavor()) {
                case 101: {
                    this.m_con.setAssignRspParcel((AssignRspParcel)object3);
                    continue block36;
                }
                case 43: {
                    continue block36;
                }
                case 134: {
                    object2 = (SSOResponseParcel)object3;
                    this.m_con.getTeraEncrypt().setIntoken(((SSOResponseParcel)object2).getAuthData());
                    continue block36;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)object3;
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)object3;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            log.error("AssignRspState receive an un-expected parcel with flavor: " + ((Parcel)object3).getFlavor());
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object3).getFlavor()));
        }
        this.m_con.m_nDHKE = 0;
        try {
            byArray = ((GenericTeraEncrypt)object5).getIntoken();
            do {
                tDPacket.clear();
                tDPacket.newLanHeader();
                tDPacket.setInitParcelPosition();
                tDPacket.setLANKind((byte)12);
                tDPacket.setByteVar((byte)7);
                tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
                tDPacket.setSessionNumber(this.m_con.getSessionNum());
                log.debugByteArray("EncryptContextState calling initSecContext with", byArray);
                byArray2 = ((GenericTeraEncrypt)object5).initSecContext(byArray, 0, byArray.length, arrayList);
                log.debugByteArray("EncryptContextState called initSecContext and got", byArray2);
                ((GenericTeraEncrypt)object5).updateGeneratedCredentials();
                if (byArray2 == null && !((GenericTeraEncrypt)object5).isEstablished()) {
                    byArray2 = new byte[]{};
                }
                if (byArray2 == null) continue;
                tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
                object4 = new SSORequestParcel(this.m_con);
                ((SSORequestParcel)object4).setTrip(((GenericTeraEncrypt)object5).getTrip());
                ((GenericTeraEncrypt)object5).incTrip();
                ((SSORequestParcel)object4).setAuthData(byArray2);
                ((SSORequestParcel)object4).setMethod(((GenericTeraEncrypt)object5).getSSOAuthMethod());
                tDPacket.addParcel((Parcel)object4);
                tDPacket.toStream();
                tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                tDPacket.clear();
                tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                tDPacket.initParcelFactory(this.m_con);
                block38: while ((object3 = tDPacket.nextParcel()) != null) {
                    switch (((Parcel)object3).getFlavor()) {
                        case 134: {
                            object2 = (SSOResponseParcel)object3;
                            byArray = ((SSOResponseParcel)object2).getAuthData();
                            log.debugByteArray("EncryptContextState called getAuthData and got", byArray);
                            ++this.m_con.m_nDHKE;
                            continue block38;
                        }
                        case 9: {
                            FailureParcel failureParcel = (FailureParcel)object3;
                            throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                        }
                        case 49: {
                            ErrorParcel errorParcel = (ErrorParcel)object3;
                            throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                        }
                    }
                    throw ErrorFactory.makeIoJDBCException("TJ305", Integer.toString(((Parcel)object3).getFlavor()), this.m_con.getIO(), null, log);
                }
            } while (!((GenericTeraEncrypt)object5).isEstablished());
            if (log.isDebugEnabled()) {
                ((GenericTeraEncrypt)object5).showContext();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw ErrorFactory.makeIoJDBCException("TJ331", "GenericEncryptContextState action", this.m_con.getIO(), throwable, log);
        }
        if (log.isDebugEnabled()) {
            log.debug("m_con.m_nDHKE=" + this.m_con.m_nDHKE);
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)4 : 3);
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        if (this.m_reconnect != null) {
            tDPacket.setRequestNumber(this.m_reconnect.nRequestNumber);
            tDPacket.setByteVar((byte)1);
        }
        object3 = new LogonParcel(this.m_con);
        if (!((GenericTeraEncrypt)object5).isUsingGeneratedCredentials()) {
            ((LogonParcel)object3).setLogonInformation(this.m_logonInfo);
        } else {
            object2 = this.m_logonInfo.getAccount();
            if (object2 != null && ((String)object2).length() > 0) {
                object = new LogonInformation(null, null);
                ((LogonInformation)object).setAccount((String)object2);
                ((LogonParcel)object3).setLogonInformation((LogonInformation)object);
            }
        }
        tDPacket.addParcel((Parcel)object3);
        object2 = new SessionOptionsParcel(this.m_con);
        ((SessionOptionsParcel)object2).setSemantics(this.m_con.getTransactionSemantics());
        if (this.m_con.getConfigResponse().statementStatusLevel() >= 1) {
            ((SessionOptionsParcel)object2).setEssFlag((byte)69);
            ((SessionOptionsParcel)object2).setEssLevel((byte)1);
        }
        if (this.m_con.getURLParameters().getConnectFunction() == 1 && this.m_con instanceof TDSession && ((TDSession)this.m_con).useCheckWorkload()) {
            ((SessionOptionsParcel)object2).setCheckWorkload((byte)49);
        }
        if (this.m_con.desiredRedriveLevel() >= 4 && this.m_con.databaseCapableOfRedriveLevel() >= 3) {
            ((SessionOptionsParcel)object2).setRedrive((byte)89);
        }
        tDPacket.addParcel((Parcel)object2);
        object = new ConnectParcel(this.m_con);
        ((ConnectParcel)object).setPartitionName(this.m_con.getURLParameters().getPartition());
        if (this.m_con.getURLParameters().getLogonSequenceNumber() != null) {
            ((ConnectParcel)object).setLogonSequenceNumber(this.m_con.getURLParameters().getLogonSequenceNumber());
        }
        ((ConnectParcel)object).setFunction(this.m_con.getURLParameters().getConnectFunction());
        tDPacket.addParcel((Parcel)object);
        byte by = this.m_con.getConfigResponse().getClientAttributesSupport();
        LogonDataParcel logonDataParcel = new LogonDataParcel(this.m_con.getIO(), this.m_con.getURLParameters().getLssType(), this.m_con);
        if (by <= 1) {
            tDPacket.addParcel(logonDataParcel);
        }
        ClientAttributesParcel clientAttributesParcel = new ClientAttributesParcel(this.m_con);
        if (by >= 1) {
            tDPacket.addParcel(clientAttributesParcel);
        }
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        block39: while (true) {
            if ((parcel = tDPacket.nextParcel()) == null) {
                return;
            }
            switch (parcel.getFlavor()) {
                case 8: 
                case 205: {
                    StatementStatusParcel statementStatusParcel = (StatementStatusParcel)parcel;
                    statementStatusParcel.verifySuccess();
                    if (statementStatusParcel.getSQLWarnings() == null) continue block39;
                    this.m_con.setNeedNewPassword(statementStatusParcel.hasWarningCode(3032));
                    if (this.m_con.supportsPasswordChange()) continue block39;
                    Object object14 = statementStatusParcel.getSQLWarnings();
                    this.m_con.addWarning((SQLWarning)object14);
                    continue block39;
                }
                case 137: {
                    continue block39;
                }
                case 89: {
                    this.m_con.setLogonSequenceNumberParcel((LogonSequenceNumberParcel)parcel);
                    continue block39;
                }
                case 9: {
                    Object object14 = (FailureParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object14).getMsg(), ((ErrorParcel)object14).getCode());
                }
                case 12: {
                    EndRequestParcel endRequestParcel = (EndRequestParcel)parcel;
                    continue block39;
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            break;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
    }

    public static class Reconnect {
        public long nAuthenticationNonce;
        public int nRequestNumber;
    }
}

