/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.tdgss.asn1.der.DER;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.ietf.jgss.Oid;

public class CertChecker {
    public static void checkCertForThread(TDNetworkIOIF tDNetworkIOIF, TDNetworkIOIF.ConnectThread connectThread) throws IOException {
        URLParameters uRLParameters = tDNetworkIOIF.m_con.getURLParameters();
        int n = uRLParameters.getSSLModeLevel();
        connectThread.m_sCertStatus = CertChecker.checkCert(uRLParameters, n, (SSLSocket)connectThread.m_socket, tDNetworkIOIF.getOriginalHostName(), connectThread.m_isa, tDNetworkIOIF.log);
    }

    public static String checkCert(URLParameters uRLParameters, int n, SSLSocket sSLSocket, String string, InetSocketAddress inetSocketAddress, Log log) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        X509Certificate[] x509CertificateArray;
        Certificate[] certificateArray;
        X509TrustManager x509TrustManager;
        X509TrustManager x509TrustManager2;
        X509TrustManager x509TrustManager3;
        X509TrustManager x509TrustManager4;
        String string2;
        String string3;
        String string4;
        String string5;
        block31: {
            SSLSession sSLSession = sSLSocket.getSession();
            if (log.isDebugEnabled()) {
                log.debug("checkCert: nSSLModeLevel=" + n + " sHostName=" + string + " isa=" + inetSocketAddress + " getProtocol=" + sSLSession.getProtocol() + " getCipherSuite=" + sSLSession.getCipherSuite());
            }
            string5 = uRLParameters.getSSLCA();
            string4 = uRLParameters.getSSLCAPath();
            string3 = uRLParameters.getSSLTrustStoreType();
            string2 = uRLParameters.getSSLTrustStore();
            String string6 = uRLParameters.getSSLTrustStorePassword();
            if (log.isDebugEnabled()) {
                log.debug(">>>>> createTrustManagerFromPEMFile(" + string5 + ")");
            }
            x509TrustManager4 = CertChecker.createTrustManagerFromPEMFile(string5, log, "SSLCA=" + string5);
            if (log.isDebugEnabled()) {
                log.debug("<<<<< createTrustManagerFromPEMFile(" + string5 + ") returned " + x509TrustManager4);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> createTrustManagerFromPEMDirectory(" + string4 + ")");
            }
            x509TrustManager3 = CertChecker.createTrustManagerFromPEMDirectory(string4, log, "SSLCAPATH=" + string4);
            if (log.isDebugEnabled()) {
                log.debug("<<<<< createTrustManagerFromPEMDirectory(" + string4 + ") returned " + x509TrustManager3);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> createTrustManagerFromTrustStoreFile(" + string3 + "," + string2 + ")");
            }
            x509TrustManager2 = CertChecker.createTrustManagerFromTrustStoreFile(string3, string2, string6, log);
            if (log.isDebugEnabled()) {
                log.debug("<<<<< createTrustManagerFromTrustStoreFile(" + string3 + "," + string2 + ") returned " + x509TrustManager2);
            }
            if (log.isDebugEnabled()) {
                log.debug(">>>>> getDefaultTrustManager");
            }
            x509TrustManager = CertChecker.getDefaultTrustManager(log);
            if (log.isDebugEnabled()) {
                log.debug("<<<<< getDefaultTrustManager returned " + x509TrustManager);
            }
            certificateArray = null;
            try {
                certificateArray = sSLSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (!log.isInfoEnabled()) break block31;
                log.info("getPeerCertificates failed for connection to " + inetSocketAddress, sSLPeerUnverifiedException);
            }
        }
        X509Certificate[] x509CertificateArray2 = x509CertificateArray = certificateArray instanceof X509Certificate[] ? (X509Certificate[])certificateArray : null;
        if (log.isInfoEnabled()) {
            for (int i = 0; x509CertificateArray != null && i < x509CertificateArray.length; ++i) {
                log.info("getPeerCertificates returned certificate " + (i + 1) + " of " + x509CertificateArray.length + (i == 0 ? " which is the peer certificate" : "") + CertChecker.formatCert(x509CertificateArray[i]));
            }
        }
        String string7 = "SSLCA=" + string5;
        String string8 = "SSLCAPATH=" + string4;
        String string9 = "SSLTRUSTSTORE=" + string2;
        String string10 = "Default Java";
        List<Throwable> list = CertChecker.getValidityProblems(x509CertificateArray);
        List<Throwable> list2 = CertChecker.getServerCertProblems(x509TrustManager4, x509CertificateArray, string7, log);
        List<Throwable> list3 = CertChecker.getServerCertProblems(x509TrustManager3, x509CertificateArray, string8, log);
        List<Throwable> list4 = CertChecker.getServerCertProblems(x509TrustManager2, x509CertificateArray, string9, log);
        List<Throwable> list5 = CertChecker.getServerCertProblems(x509TrustManager, x509CertificateArray, string10, log);
        if (log.isInfoEnabled()) {
            log.info("getValidityProblems " + (list.isEmpty() ? "accepted certificate" : "found " + list.size() + " certificate problem(s): " + CertChecker.formatList(list, ", ", null)));
            log.info("createTrustManagerFromPEMFile(" + string5 + ") " + (x509TrustManager4 == null ? "is not available" : (list2.isEmpty() ? "accepted certificate" : "found " + list2.size() + " certificate problem(s): " + CertChecker.formatList(list2, ", ", null))));
            log.info("createTrustManagerFromPEMDirectory(" + string4 + ") " + (x509TrustManager3 == null ? "is not available" : (list3.isEmpty() ? "accepted certificate" : "found " + list3.size() + " certificate problem(s): " + CertChecker.formatList(list3, ", ", null))));
            log.info("createTrustManagerFromTrustStoreFile(" + string3 + "," + string2 + ") " + (x509TrustManager2 == null ? "is not available" : (list4.isEmpty() ? "accepted certificate" : "found " + list4.size() + " certificate problem(s): " + CertChecker.formatList(list4, ", ", null))));
            log.info("getDefaultTrustManager " + (x509TrustManager == null ? "is not available" : (list5.isEmpty() ? "accepted certificate" : "found " + list5.size() + " certificate problem(s): " + CertChecker.formatList(list5, ", ", null))));
        }
        boolean bl5 = x509TrustManager4 != null || x509TrustManager3 != null || x509TrustManager2 != null || x509TrustManager != null;
        boolean bl6 = x509TrustManager4 != null && list2.isEmpty();
        boolean bl7 = x509TrustManager3 != null && list3.isEmpty();
        boolean bl8 = x509TrustManager2 != null && list4.isEmpty();
        boolean bl9 = x509TrustManager != null && list5.isEmpty();
        boolean bl10 = bl6 || bl7 || bl8 || bl9;
        boolean bl11 = n >= 5 || "PREFER".equals(uRLParameters.getSSLCRC()) || "REQUIRE".equals(uRLParameters.getSSLCRC());
        boolean bl12 = bl4 = !"REQUIRE".equals(uRLParameters.getSSLCRC());
        if (log.isDebugEnabled()) {
            log.debug("checkCert: bPerformCRC=" + bl11 + " bCRCSoftFail=" + bl4);
        }
        CertRevStatus certRevStatus = new CertRevStatus();
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (bl11) {
            if (bl6 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(uRLParameters, x509TrustManager4, x509CertificateArray, string7, certRevStatus, arrayList, log);
            }
            if (bl7 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(uRLParameters, x509TrustManager3, x509CertificateArray, string8, certRevStatus, arrayList, log);
            }
            if (bl8 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(uRLParameters, x509TrustManager2, x509CertificateArray, string9, certRevStatus, arrayList, log);
            }
            if (bl9 && !certRevStatus.known()) {
                CertChecker.checkRevocationStatus(uRLParameters, x509TrustManager, x509CertificateArray, string10, certRevStatus, arrayList, log);
            }
        }
        boolean bl13 = bl4 ? !certRevStatus.revoked() : certRevStatus.good();
        boolean bl14 = bl3 = list.isEmpty() && bl5 && bl10 && bl13;
        if (log.isInfoEnabled()) {
            log.info("VERIFY-CA would " + (bl3 ? "accept" : "reject") + " this connection");
        }
        X509Certificate x509Certificate = x509CertificateArray != null ? x509CertificateArray[0] : null;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        String[] stringArray = inetAddress != null ? inetAddress.toString().split("/") : null;
        boolean bl15 = stringArray != null && stringArray[0].length() == 0;
        String string11 = bl15 ? null : string;
        String string12 = bl15 || stringArray == null ? null : stringArray[0];
        String string13 = stringArray != null ? stringArray[1] : null;
        List<Throwable> list6 = CertChecker.getCertHostNameProblems(x509Certificate, "Hostname", string11, log);
        List<Throwable> list7 = CertChecker.getCertHostNameProblems(x509Certificate, "Resolved", string12, log);
        List<Throwable> list8 = CertChecker.getCertHostNameProblems(x509Certificate, "IP Address", string13, log);
        boolean bl16 = list6.isEmpty();
        boolean bl17 = list7.isEmpty();
        boolean bl18 = list8.isEmpty();
        boolean bl19 = bl2 = bl3 && (bl16 || bl18);
        if (log.isInfoEnabled()) {
            log.info("VERIFY-FULL would " + (bl2 ? "accept" : "reject") + " this connection");
        }
        String string14 = (list.isEmpty() ? "V" : "I") + ",P" + (x509TrustManager4 == null ? "U" : (bl6 ? "A" : "R")) + ",D" + (x509TrustManager3 == null ? "U" : (bl7 ? "A" : "R")) + ",T" + (x509TrustManager2 == null ? "U" : (bl8 ? "A" : "R")) + ",J" + (x509TrustManager == null ? "U" : (bl9 ? "A" : "R")) + ",C" + (bl3 ? "Y" : "N") + ",H" + (bl15 ? "U" : (bl16 ? "Y" : "N")) + ",R" + (bl15 ? "U" : (bl17 ? "Y" : "N")) + ",I" + (bl18 ? "Y" : "N") + ",F" + (bl2 ? "Y" : "N") + ",S" + (certRevStatus.good() ? "G" : (certRevStatus.revoked() ? "R" : "U"));
        if (log.isDebugEnabled()) {
            log.debug("checkCert: sCertStatus=" + string14);
        }
        boolean bl20 = n == 5 && !bl3;
        boolean bl21 = bl = n == 6 && !bl2;
        if (bl20 || bl) {
            ArrayList<Throwable> arrayList2 = new ArrayList<Throwable>(list);
            if (!bl5) {
                arrayList2.add(new CertificateException("No TrustManager available to verify certificate"));
            } else if (!bl10) {
                arrayList2.addAll(list2);
                arrayList2.addAll(list3);
                arrayList2.addAll(list4);
                arrayList2.addAll(list5);
            }
            if (!bl13) {
                arrayList2.addAll(arrayList);
            }
            if (bl) {
                arrayList2.addAll(list6);
                arrayList2.addAll(list8);
            }
            String string15 = (bl ? "VERIFY-FULL" : "VERIFY-CA") + " error";
            if (log.isDebugEnabled()) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    log.debug("checkCert: " + string15 + " " + (i + 1) + " of " + arrayList2.size(), (Throwable)arrayList2.get(i));
                }
            }
            throw CertChecker.makeIOException(log, null, CertChecker.formatList(arrayList2, ", ", string15));
        }
        return string14;
    }

    private static IOException makeIOException(Log log, Throwable throwable, String string) {
        log.error(string + (throwable == null ? "" : " caused by " + throwable));
        IOException iOException = new IOException(string);
        if (throwable != null) {
            iOException.initCause(throwable);
        }
        return iOException;
    }

    public static void logJavaProperty(Log log, String string) {
        String string2;
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("System.getProperty(" + string + ") = " + System.getProperty(string));
        try {
            string2 = Security.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = "" + securityException;
        }
        log.debug("Security.getProperty(" + string + ") = " + string2);
    }

    private static boolean reclassifyAsProviderProblem(GeneralSecurityException generalSecurityException) {
        String[] stringArray;
        String string = generalSecurityException.getMessage();
        if (string == null) {
            return false;
        }
        for (String string2 : stringArray = new String[]{"OCSP response expired", "No CRLs found for issuer \"cn=Entrust Root Certification Authority"}) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean reclassifyAsSoftFailure(GeneralSecurityException generalSecurityException) {
        String[] stringArray;
        String string = generalSecurityException.getMessage();
        if (string == null) {
            return false;
        }
        for (String string2 : stringArray = new String[]{"Certificate does not specify OCSP responder", "No CRLs found for issuer"}) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkRevocationStatus(URLParameters uRLParameters, X509TrustManager x509TrustManager, X509Certificate[] x509CertificateArray, String string, CertRevStatus certRevStatus, List<Throwable> list, Log log) throws IOException {
        int n;
        void var12_19;
        CertPath certPath;
        CertificateFactory certificateFactory;
        if (log.isDebugEnabled()) {
            log.debug("checkRevocationStatus: CRL=" + uRLParameters.getSSLCRL() + " OCSP=" + uRLParameters.getSSLOCSP() + " CRC=" + uRLParameters.getSSLCRC() + " tm=" + x509TrustManager + " sTitle=" + string);
        }
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            list.add(new CertificateException(string + " TrustManager cannot check certificate revocation status because server certificate is missing"));
            return;
        }
        X509Certificate[] x509CertificateArray2 = x509TrustManager.getAcceptedIssuers();
        if (x509CertificateArray2 == null || x509CertificateArray2.length == 0) {
            list.add(new CertificateException(string + " TrustManager is misconfigured and has no trusted Certificate Authority issuer certificates"));
            return;
        }
        LinkedHashSet<TrustAnchor> linkedHashSet = new LinkedHashSet<TrustAnchor>();
        for (X509Certificate providerArray2 : x509CertificateArray2) {
            linkedHashSet.add(new TrustAnchor(providerArray2, null));
        }
        if (log.isDebugEnabled()) {
            log.debug("checkRevocationStatus: " + string + " TrustManager setTrustAnchors.size=" + linkedHashSet.size());
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            if (log.isDebugEnabled()) {
                log.debug("checkRevocationStatus: " + string + " TrustManager failed", certificateException);
            }
            list.add(certificateException);
            return;
        }
        try {
            certPath = certificateFactory.generateCertPath(Arrays.asList(x509CertificateArray));
        }
        catch (CertificateException certificateException) {
            if (log.isDebugEnabled()) {
                log.debug("checkRevocationStatus: " + string + " TrustManager failed", certificateException);
            }
            list.add(certificateException);
            return;
        }
        CertChecker.logJavaProperty(log, "ocsp.enable");
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        Provider[] providerArray = Security.getProviders("CertPathValidator.PKIX");
        int n2 = providerArray.length;
        if (!uRLParameters.getSSLCRCAny() && providerArray.length > 1) {
            Provider[] providerArray2 = new Provider[]{providerArray[0]};
        }
        if (log.isDebugEnabled()) {
            log.debug("checkRevocationStatus: " + string + " TrustManager getSSLCRCAny=" + uRLParameters.getSSLCRCAny() + " Provider count before=" + n2 + " after=" + ((void)var12_19).length);
        }
        for (n = 0; n < ((void)var12_19).length; ++n) {
            boolean bl;
            List<CertPathValidatorException> list2;
            boolean bl2;
            PKIXParameters pKIXParameters;
            String string2 = "Provider " + (n + 1) + " of " + ((void)var12_19).length + " [" + var12_19[n] + "]";
            if (log.isDebugEnabled()) {
                log.debug("checkRevocationStatus: " + string + " TrustManager " + string2 + " " + var12_19[n].getInfo());
            }
            CertPathValidator certPathValidator = null;
            PKIXRevocationChecker pKIXRevocationChecker = null;
            try {
                certPathValidator = CertPathValidator.getInstance("PKIX", (Provider)var12_19[n]);
                pKIXRevocationChecker = (PKIXRevocationChecker)certPathValidator.getRevocationChecker();
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled()) {
                    log.debug("checkRevocationStatus: " + string + " TrustManager PKIXRevocationChecker exception from " + string2, throwable);
                }
                arrayList.add(new CertificateException(string + " TrustManager cannot check certificate revocation using " + string2));
                arrayList.add(throwable);
            }
            if (pKIXRevocationChecker == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("checkRevocationStatus: " + string + " TrustManager obtained PKIXRevocationChecker from " + string2);
            }
            if (uRLParameters.getSSLCRL() && uRLParameters.getSSLOCSP()) {
                pKIXRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL));
            } else if (uRLParameters.getSSLCRL()) {
                pKIXRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL, PKIXRevocationChecker.Option.PREFER_CRLS, PKIXRevocationChecker.Option.NO_FALLBACK));
            } else if (uRLParameters.getSSLOCSP()) {
                pKIXRevocationChecker.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL, PKIXRevocationChecker.Option.NO_FALLBACK));
            } else {
                throw CertChecker.makeIOException(log, null, "SSLCRL=OFF and SSLOCSP=OFF combination not permitted");
            }
            if (log.isDebugEnabled()) {
                log.debug("checkRevocationStatus: " + string + " TrustManager " + string2 + " PKIXRevocationChecker.getOptions=" + pKIXRevocationChecker.getOptions());
            }
            try {
                pKIXParameters = new PKIXParameters(linkedHashSet);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (log.isDebugEnabled()) {
                    log.debug("checkRevocationStatus: " + string + " TrustManager " + string2 + " failed", generalSecurityException);
                }
                list.add(generalSecurityException);
                return;
            }
            ArrayList<GeneralSecurityException> arrayList2 = new ArrayList<GeneralSecurityException>();
            pKIXParameters.addCertPathChecker(pKIXRevocationChecker);
            CertPathValidatorResult certPathValidatorResult = null;
            try {
                certPathValidatorResult = certPathValidator.validate(certPath, pKIXParameters);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (CertChecker.reclassifyAsProviderProblem(generalSecurityException)) {
                    log.error("checkRevocationStatus: " + string + " TrustManager " + string2 + " reclassifyAsProviderProblem", generalSecurityException);
                    arrayList.add(new CertificateException(string + " TrustManager cannot validate certificate using " + string2));
                    arrayList.add(generalSecurityException);
                }
                if (CertChecker.reclassifyAsSoftFailure(generalSecurityException)) {
                    if (log.isDebugEnabled()) {
                        log.debug("checkRevocationStatus: " + string + " TrustManager " + string2 + " reclassifyAsSoftFailure", generalSecurityException);
                    }
                    arrayList2.add(generalSecurityException);
                }
                if (log.isDebugEnabled()) {
                    log.debug("checkRevocationStatus: " + string + " TrustManager " + string2 + " known to be revoked", generalSecurityException);
                }
                list.add(generalSecurityException);
                certRevStatus.setRevoked();
                return;
            }
            boolean bl3 = bl2 = certPathValidatorResult != null || arrayList2.size() > 0;
            if (log.isDebugEnabled()) {
                X509Certificate x509Certificate;
                log.debug("checkRevocationStatus: " + string + " TrustManager " + string2 + " bDone=" + bl2 + " listSoftFailures.size=" + arrayList2.size() + " cpvr=" + certPathValidatorResult);
                if (certPathValidatorResult instanceof PKIXCertPathValidatorResult && (list2 = ((PKIXCertPathValidatorResult)certPathValidatorResult).getTrustAnchor()) != null && (x509Certificate = ((TrustAnchor)((Object)list2)).getTrustedCert()) != null) {
                    log.debug("checkRevocationStatus: " + string + " TrustManager " + string2 + " selected TrustAnchor root certificate" + CertChecker.formatCert(x509Certificate));
                }
            }
            if (!bl2) continue;
            list2 = pKIXRevocationChecker.getSoftFailExceptions();
            if (list2 != null) {
                arrayList2.addAll(list2);
            }
            if (arrayList2.isEmpty()) {
                certRevStatus.setGood();
            }
            boolean bl4 = bl = !"REQUIRE".equals(uRLParameters.getSSLCRC());
            if (log.isDebugEnabled()) {
                log.debug("checkRevocationStatus: CRL=" + uRLParameters.getSSLCRL() + " OCSP=" + uRLParameters.getSSLOCSP() + " CRC=" + uRLParameters.getSSLCRC() + " bCRCSoftFail=" + bl + " status.good=" + certRevStatus.good() + " tm=" + x509TrustManager + " sTitle=" + string + " sProviderTitle=" + string2);
            }
            if (log.isInfoEnabled()) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    log.info("checkRevocationStatus " + string + " TrustManager " + string2 + (bl ? " ignored soft" : "") + " failure " + (i + 1) + " of " + arrayList2.size() + ": " + arrayList2.get(i));
                }
            }
            list.addAll(arrayList2);
            return;
        }
        if (arrayList.isEmpty()) {
            arrayList.add(new CertificateException(string + " TrustManager cannot check certificate revocation status because PKIXRevocationChecker is not available"));
        }
        if (log.isDebugEnabled()) {
            for (n = 0; n < arrayList.size(); ++n) {
                log.debug("checkRevocationStatus: " + string + " TrustManager failed with Provider problem " + (n + 1) + " of " + arrayList.size(), (Throwable)arrayList.get(n));
            }
        }
        list.addAll(arrayList);
    }

    private static List<Throwable> getCertHostNameProblems(X509Certificate x509Certificate, String string, String string2, Log log) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (string2 == null) {
            arrayList.add(new CertificateException(string + " is not available to match Subject CN or SANs"));
        } else {
            boolean bl;
            String string3 = CertChecker.extractCNfromCert(x509Certificate);
            boolean bl2 = bl = string3 != null && CertChecker.matchesPatternIgnoreCase(string2, CertChecker.convertHostNamePatternToRegexPattern(string3));
            if (log.isInfoEnabled()) {
                log.info(string + " " + string2 + " " + (bl ? "matches" : "does not match") + " Subject CN" + (string3 != null ? " " + string3 : ""));
            }
            ExtractedSANs extractedSANs = CertChecker.extractSANsFromCert(x509Certificate);
            if (extractedSANs.ex != null && log.isInfoEnabled()) {
                log.info(string + " " + string2 + " extractSANsFromCert: " + extractedSANs.ex);
            }
            List<String> list = CertChecker.findMatchingPatterns(string2, CertChecker.convertHostNamePatternsToRegexPatterns(extractedSANs.list));
            if (log.isInfoEnabled()) {
                log.info(string + " " + string2 + " " + (list.isEmpty() ? "does not match any SANs" : "matches SANs " + CertChecker.formatList(list, ", ", null)));
            }
            if (!bl && list.isEmpty()) {
                if (!bl) {
                    arrayList.add(new CertificateException(string + " " + string2 + (string3 != null ? " does not match Subject CN " + string3 : " cannnot match missing Subject CN")));
                }
                if (extractedSANs.ex != null) {
                    arrayList.add(extractedSANs.ex);
                }
                if (list.isEmpty()) {
                    arrayList.add(new CertificateException(string + " " + string2 + " does not match any SANs from certificate: " + extractedSANs.list));
                }
            }
        }
        return arrayList;
    }

    private static String convertHostNamePatternToRegexPattern(String string) {
        return string.replaceAll("[\\W]", "\\\\$0").replaceAll("\\\\\\*", "[^.]*");
    }

    private static List<String> convertHostNamePatternsToRegexPatterns(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(CertChecker.convertHostNamePatternToRegexPattern(iterator.next()));
            }
        }
        return arrayList;
    }

    private static List<String> findMatchingPatterns(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (String string2 : list) {
                if (!CertChecker.matchesPatternIgnoreCase(string, string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private static boolean matchesPatternIgnoreCase(String string, String string2) {
        return string.matches("(?i)" + string2);
    }

    private static X509TrustManager getDefaultTrustManager(Log log) {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (log.isInfoEnabled()) {
                log.info("Could not obtain default TrustManagerFactory: " + generalSecurityException);
            }
            return null;
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            if (log.isInfoEnabled()) {
                log.info("Could not obtain default X509TrustManager");
            }
            return null;
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    public static X509Certificate[] loadCertificatesFromPEMFile(String string, Log log, String string2) throws IOException {
        Collection<? extends Certificate> collection;
        CertificateFactory certificateFactory;
        FileInputStream fileInputStream;
        if (log.isDebugEnabled()) {
            log.debug("loadCertificatesFromPEMFile: " + string2 + " sPathName=" + string);
        }
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            throw CertChecker.makeIOException(log, exception, string2 + " Could not access server certificate file " + string);
        }
        if (log.isDebugEnabled()) {
            log.debug("loadCertificatesFromPEMFile: " + string2 + " opened file " + string);
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw CertChecker.makeIOException(log, certificateException, string2 + " Could not obtain X.509 certificate factory");
        }
        try {
            collection = certificateFactory.generateCertificates(fileInputStream);
        }
        catch (CertificateException certificateException) {
            throw CertChecker.makeIOException(log, certificateException, string2 + " Could not obtain server certificate from file " + string);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        if (log.isDebugEnabled()) {
            log.debug("loadCertificatesFromPEMFile: " + string2 + " loaded " + collection.size() + " cert(s) from file " + string);
        }
        if (collection.isEmpty()) {
            throw CertChecker.makeIOException(log, null, string2 + " Found no server certificate in file " + string);
        }
        return collection.toArray(new X509Certificate[0]);
    }

    private static X509TrustManager createTrustManagerFromPEMFiles(List<String> list, Log log, String string) throws IOException {
        TrustManagerFactory trustManagerFactory;
        Object[] objectArray;
        if (list == null) {
            return null;
        }
        String[] stringArray = list.toArray(new String[0]);
        LinkedHashSet<TrustAnchor> linkedHashSet = new LinkedHashSet<TrustAnchor>();
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray = CertChecker.loadCertificatesFromPEMFile(stringArray[i], log, string);
            for (int j = 0; j < objectArray.length; ++j) {
                linkedHashSet.add(new TrustAnchor(objectArray[j], null));
            }
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(new CertPathTrustManagerParameters(new PKIXBuilderParameters(linkedHashSet, (CertSelector)new X509CertSelector())));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw CertChecker.makeIOException(log, generalSecurityException, string + " Could not obtain TrustManagerFactory for trusted certificates");
        }
        objectArray = trustManagerFactory.getTrustManagers();
        if (objectArray.length != 1 || !(objectArray[0] instanceof X509TrustManager)) {
            throw CertChecker.makeIOException(log, null, string + " Could not obtain X509TrustManager for trusted certificates");
        }
        return (X509TrustManager)objectArray[0];
    }

    private static X509TrustManager createTrustManagerFromPEMFile(String string, Log log, String string2) throws IOException {
        if (string == null) {
            return null;
        }
        return CertChecker.createTrustManagerFromPEMFiles(Collections.singletonList(string), log, string2);
    }

    private static X509TrustManager createTrustManagerFromPEMDirectory(String string, Log log, String string2) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.isDirectory()) {
            throw CertChecker.makeIOException(log, null, string2 + " Specified name " + string + " is not a directory");
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pem");
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        if (fileArray == null) {
            throw CertChecker.makeIOException(log, null, string2 + " Unable to access directory " + string);
        }
        if (fileArray.length == 0) {
            throw CertChecker.makeIOException(log, null, string2 + " No .pem files found in directory " + string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            arrayList.add(fileArray[i].toString());
        }
        return CertChecker.createTrustManagerFromPEMFiles(arrayList, log, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509TrustManager createTrustManagerFromTrustStoreFile(String string, String string2, String string3, Log log) throws IOException {
        TrustManagerFactory trustManagerFactory;
        KeyStore keyStore;
        FileInputStream fileInputStream;
        if (string2 == null) {
            return null;
        }
        try {
            fileInputStream = new FileInputStream(string2);
        }
        catch (Exception exception) {
            throw CertChecker.makeIOException(log, exception, "Could not access TrustStore file " + string2);
        }
        if (string == null) {
            string = KeyStore.getDefaultType();
        }
        if (log.isDebugEnabled()) {
            log.debug("createTrustManagerFromTrustStoreFile: sKeyStoreType=" + string + " sPassword=" + string3 + " sPathName=" + string2);
        }
        char[] cArray = string3 != null ? string3.toCharArray() : null;
        try {
            try {
                keyStore = KeyStore.getInstance(string);
            }
            catch (KeyStoreException keyStoreException) {
                throw CertChecker.makeIOException(log, keyStoreException, "Could not obtain " + string + " key store");
            }
            try {
                keyStore.load(fileInputStream, cArray);
            }
            catch (Exception exception) {
                throw CertChecker.makeIOException(log, exception, "Could not load " + string + " TrustStore file " + string2);
            }
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw CertChecker.makeIOException(log, generalSecurityException, "Could not obtain TrustManagerFactory");
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray.length != 1 || !(trustManagerArray[0] instanceof X509TrustManager)) {
            throw CertChecker.makeIOException(log, null, "Could not obtain X509TrustManager for " + string + " key store");
        }
        return (X509TrustManager)trustManagerArray[0];
    }

    private static String formatDateRange(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "not available";
        }
        return x509Certificate.getNotBefore() + " to " + x509Certificate.getNotAfter();
    }

    private static List<Throwable> getValidityProblems(X509Certificate[] x509CertificateArray) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            arrayList.add(new CertificateException("Cannot check server certificate validity because server certificate is missing"));
        } else {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                try {
                    x509CertificateArray[i].checkValidity();
                    continue;
                }
                catch (CertificateException certificateException) {
                    arrayList.add(certificateException);
                }
            }
        }
        return arrayList;
    }

    private static String formatValidity(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "validity is not available";
        }
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateException certificateException) {
            return "is invalid due to " + certificateException;
        }
        return "is valid";
    }

    private static String formatCertPurpose(X509Certificate x509Certificate) {
        boolean[] blArray;
        boolean[] blArray2 = blArray = x509Certificate != null ? x509Certificate.getKeyUsage() : null;
        if (blArray == null) {
            return "not available";
        }
        String[] stringArray = new String[]{"digitalSignature(0)", "nonRepudiation(1)", "keyEncipherment(2)", "dataEncipherment(3)", "keyAgreement(4)", "keyCertSign(5)", "cRLSign(6)", "encipherOnly(7)", "decipherOnly(8)"};
        String string = "";
        for (int i = 0; i < blArray.length; ++i) {
            string = string + (!blArray[i] ? "" : (string.length() > 0 ? ", " : "") + (i < stringArray.length ? stringArray[i] : "unknown(" + i + ")"));
        }
        return string;
    }

    private static String formatDN(X509Certificate x509Certificate) {
        Principal principal = x509Certificate != null ? x509Certificate.getSubjectDN() : null;
        String string = principal != null ? principal.getName() : null;
        return string != null ? string : "not available";
    }

    private static String extractCNfromDN(String string) {
        return string == null ? null : string.replaceAll("\\\\\\\\", "\u0019").replaceAll("\\\\,", "\u001c").replaceAll("\\\\;", "\u001d").replaceAll("\\\\\"", "\u001e").replaceAll("\\\\=", "\u001f").replaceAll("\"([^\"]*)\"", "\u0017$1\u0018").replaceAll("(\u0017[^\u0018]*)C(N\\s*=)", "$1\u0016$2").replaceFirst("(?s)(?:^|^.*[,;]\\s*)CN\\s*=\\s*(\u0017[^\u0018]*\u0018|[^,;]*).*", "$1").replaceFirst("\\s+$", "").replaceAll("\u0018", "").replaceAll("\u0016", "C").replaceAll("\u0017", "").replaceAll("\u001f", "=").replaceAll("\u001e", "\"").replaceAll("\u001d", ";").replaceAll("\u001c", ",").replaceAll("\\\\", "").replaceAll("\u0019", "\\\\");
    }

    private static String extractCNfromCert(X509Certificate x509Certificate) {
        Principal principal = x509Certificate != null ? x509Certificate.getSubjectDN() : null;
        String string = principal != null ? principal.getName() : null;
        return CertChecker.extractCNfromDN(string);
    }

    private static String formatCN(X509Certificate x509Certificate) {
        String string = CertChecker.extractCNfromCert(x509Certificate);
        return string != null ? string : "not available";
    }

    private static ExtractedSANs extractSANsFromCert(X509Certificate x509Certificate) {
        ExtractedSANs extractedSANs = new ExtractedSANs();
        Collection<List<?>> collection = null;
        if (x509Certificate != null) {
            try {
                collection = x509Certificate.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                extractedSANs.ex = certificateParsingException;
            }
        }
        if (collection != null) {
            extractedSANs.list = new ArrayList<String>();
            List<Object> list = Arrays.asList(new Integer(2), new Integer(7));
            for (List<?> list2 : collection) {
                if (list2.size() < 2 || !list.contains(list2.get(0)) || !(list2.get(1) instanceof String)) continue;
                extractedSANs.list.add((String)list2.get(1));
            }
        }
        return extractedSANs;
    }

    private static String formatList(List list, String string, String string2) {
        if (list == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (string != null && stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            if (string2 != null) {
                stringBuffer.append(string2).append(" " + n + " of " + list.size() + ": ");
            }
            stringBuffer.append(String.valueOf(iterator.next()));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String formatSANs(X509Certificate x509Certificate) {
        ExtractedSANs extractedSANs = CertChecker.extractSANsFromCert(x509Certificate);
        if (extractedSANs.ex != null) {
            return "not available: " + extractedSANs.ex;
        }
        if (extractedSANs.list == null) {
            return "not present";
        }
        return CertChecker.formatList(extractedSANs.list, ", ", null);
    }

    private static String formatAuthorityInfoAccess(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (byArray == null) {
            return "not present";
        }
        return Log.formatPartialByteArray(null, byArray, 0, byArray.length);
    }

    private static String formatOCSPResponderURLs(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("1.3.6.1.5.5.7.1.1");
        if (byArray == null) {
            return "not present";
        }
        try {
            DER dER = new DER(byArray);
            if (dER.getTagNumber() != 4) {
                throw new IllegalArgumentException("unexpected AuthorityInfoAccess tag 0x" + Log.leadingZeros(Integer.toHexString(dER.getTagNumber()), 2));
            }
            if ((dER = new DER(dER.getValueAsOctetString())).getTagNumber() != 16) {
                throw new IllegalArgumentException("unexpected AuthorityInfoAccessSyntax tag 0x" + Log.leadingZeros(Integer.toHexString(dER.getTagNumber()), 2));
            }
            String string = "";
            DER[] dERArray = dER.getChildren();
            for (int i = 0; i < dERArray.length; ++i) {
                if (dERArray[i].getTagNumber() != 16) {
                    throw new IllegalArgumentException("unexpected AccessDescription[" + i + "] tag 0x" + Log.leadingZeros(Integer.toHexString(dERArray[i].getTagNumber()), 2));
                }
                DER[] dERArray2 = dERArray[i].getChildren();
                if (dERArray2.length != 2) {
                    throw new IllegalArgumentException("unexpected AccessDescription[" + i + "] contains " + dERArray2.length + " item(s)");
                }
                if (dERArray2[0].getTagNumber() != 6) {
                    throw new IllegalArgumentException("unexpected AccessMethod[" + i + "] tag 0x" + Log.leadingZeros(Integer.toHexString(dERArray2[0].getTagNumber()), 2));
                }
                if (dERArray2[1].getTagNumber() != 6) {
                    throw new IllegalArgumentException("unexpected AccessLocation[" + i + "] tag 0x" + Log.leadingZeros(Integer.toHexString(dERArray2[1].getTagNumber()), 2));
                }
                Oid oid = dERArray2[0].getValueAsOid();
                if (oid == null || !"1.3.6.1.5.5.7.48.1".equals(oid.toString())) continue;
                string = string + (string.length() == 0 ? "" : " ") + dERArray2[1].getValueAsUTF8String();
            }
            return string.length() > 0 ? string : "not present";
        }
        catch (Throwable throwable) {
            return "not available: " + throwable;
        }
    }

    private static String formatCRLDistributionPoints(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.31");
        if (byArray == null) {
            return "not present";
        }
        return Log.formatPartialByteArray(null, byArray, 0, byArray.length);
    }

    private static String formatCRLDistributionPointURLs(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.31");
        if (byArray == null) {
            return "not present";
        }
        try {
            DER dER = new DER(byArray);
            if (dER.getTagNumber() != 4) {
                throw new IllegalArgumentException("unexpected CRLDistributionPoints tag 0x" + Log.leadingZeros(Integer.toHexString(dER.getTagNumber()), 2));
            }
            if ((dER = new DER(dER.getValueAsOctetString())).getTagNumber() != 16) {
                throw new IllegalArgumentException("unexpected CRLDistributionPointsSequence tag 0x" + Log.leadingZeros(Integer.toHexString(dER.getTagNumber()), 2));
            }
            String string = "";
            DER[] dERArray = dER.getChildren();
            for (int i = 0; i < dERArray.length; ++i) {
                if (dERArray[i].getTagNumber() != 16) {
                    throw new IllegalArgumentException("unexpected DistributionPoint[" + i + "] tag 0x" + Log.leadingZeros(Integer.toHexString(dERArray[i].getTagNumber()), 2));
                }
                DER[] dERArray2 = dERArray[i].getChildren();
                for (int j = 0; j < dERArray2.length; ++j) {
                    DER dER2 = dERArray2[j];
                    while (dER2.getTagNumber() == 0) {
                        dER2 = new DER(dER2.getValueAsOctetString());
                    }
                    if (dER2.getTagNumber() != 6) continue;
                    string = string + (string.length() == 0 ? "" : " ") + dER2.getValueAsUTF8String();
                }
            }
            return string.length() > 0 ? string : "not present";
        }
        catch (Throwable throwable) {
            return "not available: " + throwable;
        }
    }

    private static String formatCert(X509Certificate x509Certificate) {
        return "\n  Certificate date range is " + CertChecker.formatDateRange(x509Certificate) + "\n  Certificate " + CertChecker.formatValidity(x509Certificate) + "\n  Certificate purpose is " + CertChecker.formatCertPurpose(x509Certificate) + "\n  Subject Distinguished Name (DN) is " + CertChecker.formatDN(x509Certificate) + "\n  Subject Common Name (CN) is " + CertChecker.formatCN(x509Certificate) + "\n  Subject Alternative Names (SANs) are " + CertChecker.formatSANs(x509Certificate) + "\n  Authority Info Access extension is " + CertChecker.formatAuthorityInfoAccess(x509Certificate).trim().replaceAll("\n", "\n    AIA  ") + "\n  OCSP Responder URLs are " + CertChecker.formatOCSPResponderURLs(x509Certificate) + "\n  CRL Distribution Points extension is " + CertChecker.formatCRLDistributionPoints(x509Certificate).trim().replaceAll("\n", "\n    CRL  ") + "\n  CRL Distribution Point URLs are " + CertChecker.formatCRLDistributionPointURLs(x509Certificate) + "\n  ----------------------------------------------" + "\n" + "  |  " + String.valueOf(x509Certificate).trim().replaceAll("\n", "\n  |  ") + "\n  ----------------------------------------------";
    }

    private static List<Throwable> getServerCertProblems(X509TrustManager x509TrustManager, X509Certificate[] x509CertificateArray, String string, Log log) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            arrayList.add(new CertificateException(string + " TrustManager cannot check server certificate validity because server certificate is missing"));
        } else if (x509TrustManager != null) {
            X509Certificate[] x509CertificateArray2 = x509TrustManager.getAcceptedIssuers();
            if (x509CertificateArray2 == null || x509CertificateArray2.length == 0) {
                arrayList.add(new CertificateException(string + " TrustManager is misconfigured and has no trusted Certificate Authority issuer certificates"));
            } else {
                if (log.isDebugEnabled()) {
                    for (int i = 0; i < x509CertificateArray2.length; ++i) {
                        log.debug("getServerCertProblems: " + string + " TrustManager root certificate " + (i + 1) + " of " + x509CertificateArray2.length + CertChecker.formatCert(x509CertificateArray2[i]));
                    }
                }
                try {
                    x509TrustManager.checkServerTrusted(x509CertificateArray, "UNKNOWN");
                }
                catch (CertificateException certificateException) {
                    arrayList.add(new CertificateException(string + " TrustManager rejected certificate"));
                    arrayList.add(certificateException);
                }
            }
        }
        return arrayList;
    }

    private static Set setMinus(Collection collection, Collection collection2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet(collection);
        linkedHashSet.removeAll(collection2);
        return linkedHashSet;
    }

    private static class ExtractedSANs {
        public List<String> list = null;
        public CertificateParsingException ex = null;
    }

    private static class CertRevStatus {
        private boolean bGood;
        private boolean bRevoked;

        public void setGood() {
            this.bGood = true;
        }

        public void setRevoked() {
            this.bRevoked = true;
        }

        public boolean good() {
            return this.bGood;
        }

        public boolean revoked() {
            return this.bRevoked;
        }

        public boolean known() {
            return this.bGood || this.bRevoked;
        }
    }
}

