/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.monitor;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc.monitor.MonitorConnection;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.AbortParcel;
import com.teradata.jdbc.jdbc_4.parcel.BigResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.CancelParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class MonitorPreparedStatement
implements PreparedStatement,
RowFetchController {
    private MonitorConnection con = null;
    private String sql = null;
    private ArrayList m_listResultSets = new ArrayList();
    private int m_nCurrentResultsIndex = 0;
    private boolean m_bRequestClosed = false;
    private Object[] workingRow = new Object[2000];
    private BitSet workingRowColumn = new BitSet(2000);
    private int maxDecimalPrecision = 18;
    private short m_monitorVersion = 0;
    private int m_nQueryTimeoutInSeconds = 0;
    private volatile boolean m_bCanSendAbortRequest = false;
    public static final int TIME_STRING_LENGTH = 8;
    public static final int TIMESTAMP_STRING_LENGTH = 19;
    public static final int TIME_ZONE_STRING_LENGTH = 6;
    public static final int MAX_COLUMN_COUNT = 2000;

    public MonitorPreparedStatement(MonitorConnection monitorConnection, String string) throws SQLException {
        this.con = monitorConnection;
        this.sql = string;
    }

    protected void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private void abortIfIndexNotValid(int n) throws SQLException {
        if (n <= 0 || n > 2000) {
            throw ErrorFactory.makeDriverJDBCException("TJ411", n);
        }
    }

    private void initReqPacket(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.con.getSessionNum());
        tDPacket.setAuthentication(this.con.getAuthenticationNonce());
        tDPacket.setLANKind(by);
        tDPacket.setRequestNumber(n);
    }

    private void initIndicReq(TDPacket tDPacket) throws SQLException {
        IndicRequestParcel indicRequestParcel = new IndicRequestParcel(this.con);
        indicRequestParcel.setRequestText(this.sql);
        tDPacket.addParcel(indicRequestParcel);
    }

    private void initIndicData(TDPacket tDPacket) throws SQLException {
        int n;
        int n2 = this.workingRowColumn.nextClearBit(0);
        byte[] byArray = new byte[(n2 + 7) / 8];
        ParameterProperties.ParameterSet parameterSet = ParameterProperties.createParameterSetForIndicData(n2);
        int n3 = 0;
        IndicDataParcel indicDataParcel = null;
        ResponseParcel responseParcel = new ResponseParcel(this.con);
        int n4 = responseParcel.toStream().limit();
        int n5 = 0;
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 0;
        }
        n3 = byArray.length;
        for (n = 0; n < parameterSet.getNumberOfParamValues(); ++n) {
            this.initPreparedParameter(parameterSet, this.workingRow[n], n + 1, 1);
            n3 += parameterSet.getLength(n + 1);
            if (!parameterSet.isNullValue(n + 1)) continue;
            int n6 = (n + 8) / 8 - 1;
            byArray[n6] = (byte)(byArray[n6] | (byte)(1 << 7 - n % 8));
        }
        indicDataParcel = new IndicDataParcel(n3, this.con, false);
        indicDataParcel.setParameters(parameterSet);
        indicDataParcel.setNullIndicatorBits(byArray);
        n5 = indicDataParcel.toStream().limit();
        if (n5 > 65156 - tDPacket.getBuffer().position() - n4) {
            throw ErrorFactory.makeDriverJDBCException("TJ421", 1, n5, 65156 - tDPacket.getBuffer().position() - n4);
        }
        tDPacket.addParcel(indicDataParcel);
    }

    private void initPreparedParameter(ParameterProperties.ParameterSet parameterSet, Object object, int n, int n2) throws SQLException {
        boolean bl = false;
        Calendar calendar = null;
        int n3 = 0;
        if (object instanceof TypedNull) {
            object = ((TypedNull)object).getType();
            bl = true;
        }
        if (object instanceof ObjectWithCalendar) {
            calendar = ((ObjectWithCalendar)object).getCalendar();
            object = ((ObjectWithCalendar)object).getObject();
            n3 = 6;
        }
        if (object instanceof BigDecimal) {
            int n4 = 0;
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(new BigDecimal(0)) != 0) {
                n4 = bigDecimal.scale();
                bigDecimal = bigDecimal.movePointRight(n4);
            }
            parameterSet.setParameter(n, object, ByteConverter.putLong(bigDecimal.longValue()), 485, bl, this.maxDecimalPrecision, n4);
        } else if (object instanceof Byte) {
            parameterSet.setParameter(n, object, ByteConverter.putByte((Byte)object), 757, bl, 0, 0);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > 64000) {
                throw ErrorFactory.makeTDDataTruncation("TJ424", n, true, false, byArray.length, 64000, n2);
            }
            parameterSet.setParameter(n, object, byArray, 693, bl, 0, 0);
        } else if (object instanceof Date) {
            int n5 = 0;
            if (!bl) {
                String string = ((Date)object).toString();
                n5 = (Integer.valueOf(string.substring(0, 4)) - 1900) * 10000 + Integer.valueOf(string.substring(5, 7)) * 100 + Integer.valueOf(string.substring(8, 10));
            }
            parameterSet.setParameter(n, object, ByteConverter.putInt(n5), 497, bl, 0, 0);
        } else if (object instanceof Double) {
            parameterSet.setParameter(n, object, ByteConverter.putDouble((Double)object), 481, bl, 0, 0);
        } else if (object instanceof Integer) {
            parameterSet.setParameter(n, object, ByteConverter.putInt((Integer)object), 497, bl, 0, 0);
        } else if (object instanceof Short) {
            parameterSet.setParameter(n, object, ByteConverter.putShort((Short)object), 501, bl, 0, 0);
        } else if (object instanceof String) {
            byte[] byArray = Encoder.encodeStringParameter(this.con, n, n2, (String)object);
            if (byArray.length > 64000) {
                throw ErrorFactory.makeTDDataTruncation("TJ410", n, true, false, byArray.length, 64000, n2);
            }
            if (this.m_monitorVersion >= 9) {
                byte[] byArray2 = new byte[byArray.length + 2];
                ByteConverter.putShort(byArray2, 0, (short)byArray.length);
                System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
                parameterSet.setParameter(n, object, byArray2, 449, bl, 0, 0);
            } else {
                parameterSet.setParameter(n, object, byArray, 453, bl, 0, 0);
            }
        } else if (object instanceof Time) {
            int n6 = this.con.getURLParameters().getTimeNano() < 1 ? 0 : this.con.getURLParameters().getTimeNano() + 1;
            StringBuffer stringBuffer = new StringBuffer(8 + n6 + n3);
            if (!bl) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTimeInMillis(((Time)object).getTime());
                int n7 = gregorianCalendar.get(14);
                String string = String.valueOf(n7);
                if (n7 < 10) {
                    string = "00" + n7;
                } else if (n7 < 100) {
                    string = "0" + n7;
                }
                String string2 = ((Time)object).toString() + "." + string;
                int n8 = string2.length() > stringBuffer.capacity() - n3 ? stringBuffer.capacity() - n3 : string2.length();
                stringBuffer = stringBuffer.append(string2.toCharArray(), 0, n8);
                for (int i = n8; i < stringBuffer.capacity() - n3; ++i) {
                    stringBuffer = stringBuffer.append('0');
                }
                if (calendar != null) {
                    stringBuffer = stringBuffer.append(TDPreparedStatement.formatCalendarTimeZone(n, calendar));
                }
            } else {
                for (int i = 0; i < stringBuffer.capacity(); ++i) {
                    stringBuffer = stringBuffer.append(' ');
                }
            }
            parameterSet.setParameter(n, object, Encoder.encodeStringParameter(this.con, n, n2, stringBuffer.toString()), 453, bl, 0, 0);
        } else if (object instanceof Timestamp) {
            int n9 = this.con.getURLParameters().getTimestampNano() < 1 ? 0 : this.con.getURLParameters().getTimestampNano() + 1;
            StringBuffer stringBuffer = new StringBuffer(19 + n9 + n3);
            if (!bl) {
                String string = ((Timestamp)object).toString();
                int n10 = string.length() > stringBuffer.capacity() - n3 ? stringBuffer.capacity() - n3 : string.length();
                stringBuffer = stringBuffer.append(string.toCharArray(), 0, n10);
                for (int i = n10; i < stringBuffer.capacity() - n3; ++i) {
                    stringBuffer = stringBuffer.append('0');
                }
                if (calendar != null) {
                    stringBuffer = stringBuffer.append(TDPreparedStatement.formatCalendarTimeZone(n, calendar));
                }
            } else {
                for (int i = 0; i < stringBuffer.capacity(); ++i) {
                    stringBuffer = stringBuffer.append(' ');
                }
            }
            parameterSet.setParameter(n, object, Encoder.encodeStringParameter(this.con, n, n2, stringBuffer.toString()), 453, bl, 0, 0);
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ417", String.valueOf(n), String.valueOf(n2), object.getClass().getName());
        }
    }

    private void initResp(TDPacket tDPacket) throws SQLException {
        ResponseParcel responseParcel;
        if (this.m_monitorVersion >= 9) {
            responseParcel = new BigResponseParcel(this.con);
            responseParcel.setMaxMsgSize(this.con.getMaxMessageSize(false, false));
        } else {
            responseParcel = new ResponseParcel(this.con);
            responseParcel.setMaxMsgSize(65104);
        }
        tDPacket.addParcel(responseParcel);
    }

    private void bufferMessage(TDPacket tDPacket) throws SQLException {
        this.initReqPacket(tDPacket, (byte)5, this.con.getRequestNum());
        this.initIndicReq(tDPacket);
        this.initIndicData(tDPacket);
        this.initResp(tDPacket);
        tDPacket.toStream();
    }

    private void sendMessage(TDPacket tDPacket) throws SQLException {
        tDPacket.getBuffer().writeStream(this.con.getIO());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessage(TDPacket tDPacket, int n) throws SQLException {
        tDPacket.clear();
        TDNetworkIOIF tDNetworkIOIF = this.con.getIO();
        tDNetworkIOIF.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(tDNetworkIOIF, null, n, true);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 802) {
                throw sQLException;
            }
            this.initReqPacket(tDPacket, (byte)7, this.con.getCurrentRequestNum());
            tDPacket.addParcel(new AbortParcel(this.con));
            tDPacket.toStream();
            this.sendMessage(tDPacket);
            try {
                tDPacket.getBuffer().readStream(tDNetworkIOIF, null, n, true);
            }
            catch (SQLException sQLException2) {
                tDNetworkIOIF.close();
                throw sQLException2;
            }
        }
        finally {
            tDNetworkIOIF.releaseReadLock();
        }
        tDPacket.initParcelFactory(this.con);
    }

    private void receiveResults(TDPacket tDPacket, TDResultSet tDResultSet) throws SQLException {
        TeraResultSetMetaData teraResultSetMetaData = tDResultSet == null ? null : (TeraResultSetMetaData)tDResultSet.getMetaData();
        Parcel parcel = null;
        block9: while ((parcel = tDPacket.nextParcel()) != null) {
            this.con.getLog().debug("Parcel flavor: " + parcel.getFlavor());
            switch (parcel.getFlavor()) {
                case 8: {
                    SuccessParcel successParcel = (SuccessParcel)parcel;
                    teraResultSetMetaData = this.con.constructResultSetMetaData();
                    tDResultSet = this.con.constructResultSet(teraResultSetMetaData, 1, this, this, this.con.getLog());
                    tDResultSet.setActivityCount(0x7FFFFFFEL);
                    this.m_listResultSets.add(tDResultSet);
                    break;
                }
                case 71: {
                    Object object;
                    DataInfoParcel dataInfoParcel = (DataInfoParcel)parcel;
                    teraResultSetMetaData.setPrepInfoParcel(dataInfoParcel);
                    tDPacket.setParcelFactoryPrepInfo(dataInfoParcel);
                    PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator = dataInfoParcel.getPrepInfoItemIterator();
                    while (prepInfoItemIterator.hasNext()) {
                        object = new ColumnProperties();
                        ((ColumnProperties)object).initWithPrepInfoItem(prepInfoItemIterator.next(), this.con, null);
                        teraResultSetMetaData.addColumnProperties((ColumnProperties)object, true);
                    }
                    continue block9;
                }
                case 10: {
                    if (tDResultSet.isClosed()) break;
                    Object object = (RecordParcel)parcel;
                    ResultSetRow resultSetRow = new ResultSetRow();
                    RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = ((RecordParcel)object).getRecordParcelColumnValuesIterator();
                    while (recordParcelColumnValuesIterator.hasNext()) {
                        resultSetRow.addValue(recordParcelColumnValuesIterator.next());
                    }
                    tDResultSet.addResultSetRow(resultSetRow);
                    break;
                }
                case 11: {
                    EndStatementParcel endStatementParcel = (EndStatementParcel)parcel;
                    tDResultSet.lastRowFetched();
                    break;
                }
                case 9: {
                    this.m_bRequestClosed = true;
                    FailureParcel failureParcel = (FailureParcel)parcel;
                    this.con.getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    this.m_bRequestClosed = true;
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    this.con.getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
                case 12: {
                    this.m_bRequestClosed = true;
                    break;
                }
                default: {
                    this.con.getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
                    throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
                }
            }
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.abortIfClosed();
        for (int i = 0; i < this.workingRowColumn.length(); ++i) {
            this.workingRow[i] = null;
        }
        this.workingRowColumn.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        this.abortIfClosed();
        this.closeResponse();
        this.m_listResultSets.clear();
        try {
            this.m_nCurrentResultsIndex = 0;
            this.m_bRequestClosed = false;
            if (this.workingRowColumn.length() != this.workingRowColumn.nextClearBit(0)) {
                throw ErrorFactory.makeDriverJDBCException("TJ526", this.workingRowColumn.nextClearBit(0) + 1);
            }
            TDPacket tDPacket = this.con.createPacket(1);
            this.bufferMessage(tDPacket);
            this.sendMessage(tDPacket);
            this.fetchRows(null, -1, 1, 0L, 0L);
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = ErrorFactory.makeDriverJDBCException("TJ527");
            sQLException2.setNextException(sQLException);
            throw sQLException2;
        }
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.abortIfClosed();
            this.abortIfIndexNotValid(n);
            throw ErrorFactory.makeDriverJDBCException("TJ432", n);
        }
        this.setObject(n, bigDecimal);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setObject(n, new Byte(by));
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.abortIfClosed();
            this.abortIfIndexNotValid(n);
            throw ErrorFactory.makeDriverJDBCException("TJ614", n);
        }
        this.setObject(n, byArray);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (calendar != null) {
            date = TDResultSet.convertDateWithTimeZoneToGMT(n, date, calendar);
        }
        this.setObject(n, date);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.setObject(n, new Double(d));
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setDouble(n, Double.valueOf(Float.toString(f)));
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setObject(n, new Integer(n2));
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        TypedNull typedNull;
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                throw ErrorFactory.makeDriverJDBCException("TJ612", n);
            }
            case -1: 
            case 1: 
            case 12: {
                if (this.m_monitorVersion >= 9) {
                    typedNull = new TypedNull("");
                    break;
                }
                throw ErrorFactory.makeDriverJDBCException("TJ528", n);
            }
            case 91: {
                typedNull = new TypedNull(new Date(0L));
                break;
            }
            case 2: 
            case 3: {
                throw ErrorFactory.makeDriverJDBCException("TJ449", n);
            }
            case 6: 
            case 7: 
            case 8: {
                typedNull = new TypedNull(new Double(0.0));
                break;
            }
            case 4: {
                typedNull = new TypedNull(new Integer(0));
                break;
            }
            case 5: {
                typedNull = new TypedNull(new Short(0));
                break;
            }
            case 92: {
                typedNull = new TypedNull(new Time(0L));
                break;
            }
            case 93: {
                typedNull = new TypedNull(new Timestamp(0L));
                break;
            }
            case -6: {
                typedNull = new TypedNull(new Byte(0));
                break;
            }
            case -7: 
            case -5: 
            case 0: 
            case 16: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw ErrorFactory.makeDriverJDBCException("TJ428", n, n2);
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ429", n, n2);
            }
        }
        this.setObject(n, typedNull);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNull(n, n2);
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ425", n);
        }
        Object object2 = object;
        if (object2 instanceof TypedNull) {
            object2 = ((TypedNull)object2).getType();
        }
        if (object2 instanceof ObjectWithCalendar) {
            object2 = ((ObjectWithCalendar)object2).getObject();
        }
        if (object2 instanceof Time && this.con.getURLParameters().getTimeNano() < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ452", n);
        }
        if (object2 instanceof Timestamp && this.con.getURLParameters().getTimestampNano() < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ453", n);
        }
        if (object instanceof BigDecimal) {
            int n2;
            BigDecimal bigDecimal = (BigDecimal)object;
            int n3 = bigDecimal.scale();
            if (n3 < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n3 = bigDecimal.scale();
            }
            if ((n2 = ComUtil.getSignificantDigits(bigDecimal) + n3) > this.maxDecimalPrecision) {
                throw ErrorFactory.makeTDDataTruncation("TJ422", n, true, false, n2, this.maxDecimalPrecision);
            }
        } else if (object instanceof Float) {
            object = new Double(Double.valueOf(object.toString()));
        } else if (!(object instanceof Byte || object instanceof byte[] || object instanceof Date || object instanceof Double || object instanceof Integer || object instanceof Short || object instanceof String || object instanceof Time || object instanceof Timestamp || object instanceof TypedNull || object instanceof ObjectWithCalendar)) {
            throw ErrorFactory.makeDriverJDBCException("TJ426", String.valueOf(n), object.getClass().getName());
        }
        if (n == 1 && object instanceof Short) {
            this.m_monitorVersion = (Short)object;
        }
        this.workingRow[n - 1] = object;
        this.workingRowColumn.set(n - 1);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                if (object instanceof byte[]) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof String) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 91: {
                if (object instanceof Date) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 2: 
            case 3: {
                if (object instanceof BigDecimal) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 6: 
            case 7: 
            case 8: {
                if (object instanceof Double || object instanceof Float) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 4: {
                if (object instanceof Integer) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 5: {
                if (object instanceof Short) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 92: {
                if (object instanceof Time) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case 93: {
                if (object instanceof Timestamp) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -6: {
                if (object instanceof Byte) break;
                throw ErrorFactory.makeDriverJDBCException("TJ427", String.valueOf(n), object.getClass().getName(), String.valueOf(n2));
            }
            case -7: 
            case -5: 
            case 0: 
            case 16: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                throw ErrorFactory.makeDriverJDBCException("TJ428", n, n2);
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ429", n, n2);
            }
        }
        this.setObject(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.abortIfClosed();
        this.abortIfIndexNotValid(n);
        if (object == null && (n2 == 3 || n2 == 2)) {
            if (n3 < 0 || n3 > this.maxDecimalPrecision) {
                throw ErrorFactory.makeDriverJDBCException("TJ431", n, n3, this.maxDecimalPrecision);
            }
            this.setObject(n, new TypedNull(new BigDecimal("0").setScale(n3)));
            return;
        }
        if (object == null && (n2 == 1 || n2 == 12 || n2 == -1)) {
            this.setObject(n, new TypedNull(new String(Utility.fillChars(' ', n3))));
            return;
        }
        if (object == null && (n2 == -2 || n2 == -3 || n2 == -4)) {
            byte[] byArray = new byte[n3];
            this.setObject(n, new TypedNull(byArray));
            return;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            int n4 = bigDecimal.scale();
            if (n4 < 0) {
                bigDecimal = bigDecimal.movePointRight(0);
                n4 = bigDecimal.scale();
            }
            if (n4 != n3) {
                throw ErrorFactory.makeDriverJDBCException("TJ430", n, n4, n3);
            }
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > n3) {
                throw ErrorFactory.makeTDDataTruncation("TJ613", n, true, false, byArray.length, n3);
            }
            if (byArray.length < n3) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                object = byArray2;
            }
        } else if (object instanceof String) {
            byte[] byArray = Encoder.encodeStringParameter(this.con, n, (String)object);
            if (byArray.length > n3) {
                throw ErrorFactory.makeTDDataTruncation("TJ529", n, true, false, byArray.length, n3);
            }
            if (byArray.length < n3) {
                int n5 = Encoder.encodeStringParameter(this.con, n, " ").length;
                int n6 = n3 - byArray.length;
                int n7 = n6 / n5;
                object = (String)object + new String(Utility.fillChars(' ', n7));
            }
        }
        this.setObject(n, object, n2);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setObject(n, new Short(s));
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            if (this.m_monitorVersion >= 9) {
                this.setNull(n, 12);
                return;
            }
            this.abortIfClosed();
            this.abortIfIndexNotValid(n);
            throw ErrorFactory.makeDriverJDBCException("TJ530", n);
        }
        this.setObject(n, string);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null && calendar == null) {
            this.setNull(n, 92);
            return;
        }
        if (time == null && calendar != null) {
            this.setObject(n, new TypedNull(new ObjectWithCalendar(new Time(0L), calendar)));
            return;
        }
        if (time != null && calendar != null) {
            this.setObject(n, new ObjectWithCalendar(time, calendar));
            return;
        }
        this.setObject(n, time);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null && calendar == null) {
            this.setNull(n, 93);
            return;
        }
        if (timestamp == null && calendar != null) {
            this.setObject(n, new TypedNull(new ObjectWithCalendar(new Timestamp(0L), calendar)));
            return;
        }
        if (timestamp != null && calendar != null) {
            this.setObject(n, new ObjectWithCalendar(timestamp, calendar));
            return;
        }
        this.setObject(n, timestamp);
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
        if (this.con.getConfigResponse().isMonitorAsyncAbortSupported() && this.m_bCanSendAbortRequest) {
            TDPacket tDPacket = this.con.createPacket(1);
            this.initReqPacket(tDPacket, (byte)7, this.con.getCurrentRequestNum());
            tDPacket.addParcel(new AbortParcel(this.con));
            tDPacket.toStream();
            this.sendMessage(tDPacket);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void close() throws SQLException {
        this.workingRow = null;
        this.workingRowColumn = null;
        this.closeResponse();
    }

    private void closeResponse() throws SQLException {
        if (!this.m_listResultSets.isEmpty() && !this.m_bRequestClosed) {
            TDPacket tDPacket = this.con.createPacket(1);
            this.initReqPacket(tDPacket, (byte)6, this.con.getCurrentRequestNum());
            tDPacket.addParcel(new CancelParcel(this.con));
            tDPacket.toStream();
            this.sendMessage(tDPacket);
            TDPacket tDPacket2 = this.con.createPacket(1);
            this.receiveMessage(tDPacket2, 0);
            this.receiveResults(tDPacket2, null);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ407");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return this.getRowFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return this.getRowFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return this.getMaxFetchFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return this.getMaxFetchRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        if (this.m_nCurrentResultsIndex < this.m_listResultSets.size()) {
            ((ResultSet)this.m_listResultSets.get(this.m_nCurrentResultsIndex)).close();
            ++this.m_nCurrentResultsIndex;
        }
        if (this.m_nCurrentResultsIndex < this.m_listResultSets.size()) {
            return true;
        }
        if (!this.m_bRequestClosed) {
            this.fetchRows((TDResultSet)this.getResultSet(), -1, 1, 0L, 0L);
            if (this.m_nCurrentResultsIndex < this.m_listResultSets.size()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return this.m_nQueryTimeoutInSeconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.m_nCurrentResultsIndex < this.m_listResultSets.size()) {
            return (ResultSet)this.m_listResultSets.get(this.m_nCurrentResultsIndex);
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
        if (this.con.getConfigResponse().isMonitorAsyncAbortSupported()) {
            if (n < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ603", n);
            }
            this.m_nQueryTimeoutInSeconds = n;
        }
    }

    @Override
    public void suppressResponseCancel() {
    }

    @Override
    public void closingResultSet(boolean bl, boolean bl2) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchRows(TDResultSet tDResultSet, int n, int n2, long l, long l2) throws SQLException {
        TDPacket tDPacket = this.con.createPacket(1);
        if (this.m_listResultSets.isEmpty()) {
            this.m_bCanSendAbortRequest = true;
            try {
                this.receiveMessage(tDPacket, this.m_nQueryTimeoutInSeconds * 1000);
            }
            finally {
                this.m_bCanSendAbortRequest = false;
            }
        } else {
            TDPacket tDPacket2 = this.con.createPacket(1);
            this.initReqPacket(tDPacket2, (byte)6, this.con.getCurrentRequestNum());
            this.initResp(tDPacket2);
            tDPacket2.toStream();
            this.sendMessage(tDPacket2);
            this.receiveMessage(tDPacket, 0);
            tDPacket.setParcelFactoryPrepInfo(tDResultSet == null ? null : ((TeraResultSetMetaData)tDResultSet.getMetaData()).getPrepInfoParcel());
        }
        this.receiveResults(tDPacket, tDResultSet);
    }

    @Override
    public Object getCloseMutex() {
        return this.con;
    }

    @Override
    public int getCurrentRequestNumber() {
        return -1;
    }

    @Override
    public int getCurrentStatementNumber() {
        return this.m_nCurrentResultsIndex + 1;
    }

    @Override
    public int getRowFetchDirection() {
        return 1000;
    }

    @Override
    public int getRowFetchSize() {
        return 0;
    }

    @Override
    public int getMaxFetchRows() {
        return 0;
    }

    @Override
    public int getMaxFetchFieldSize() {
        return 0;
    }

    @Override
    public boolean registerStatement() {
        return true;
    }

    @Override
    public void unregisterStatement() {
    }

    @Override
    public boolean getFinalizeAutoClose() {
        return this.con.getURLParameters().getFinalizeAutoClose();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.workingRow == null || this.workingRowColumn == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return true;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream)");
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setAsciiStream(int,InputStream,long)");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream");
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBinaryStream(int,InputStream,long)");
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream");
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setBlob(int,InputStream,long)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader)");
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setCharacterStream(int,Reader,long)");
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader)");
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setClob(int,Reader,long)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader)");
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNCharacterStream(int,Reader,long)");
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader)");
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,Reader,long)");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ726", "setNClob(int,NClob)");
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    private static class ObjectWithCalendar {
        private Object obj;
        private Calendar cal;

        public ObjectWithCalendar(Object object, Calendar calendar) {
            this.obj = object;
            this.cal = calendar;
        }

        public Object getObject() {
            return this.obj;
        }

        public Calendar getCalendar() {
            return this.cal;
        }
    }

    private static class TypedNull {
        private Object type;

        public TypedNull(Object object) {
            this.type = object;
        }

        public Object getType() {
            return this.type;
        }
    }
}

