/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.SQLException;

public class TDPacketStream
implements BufferContainer {
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    protected byte[] streamBuffer;
    final int offset = 0;

    public TDPacketStream(int n) {
        this.streamBuffer = new byte[n];
        this.limit = n;
        this.capacity = n;
    }

    public TDPacketStream(byte[] byArray, int n) {
        this.setBuffer(byArray);
        this.position = n;
    }

    @Override
    public byte[] getBuffer() {
        return this.streamBuffer;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.streamBuffer = byArray;
        this.limit = byArray.length;
        this.capacity = byArray.length;
    }

    public final int capacity() {
        return this.capacity;
    }

    public final int position() {
        return this.position;
    }

    public final TDPacketStream position(int n) throws SQLException {
        if (n > this.limit || n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "new position " + n + " is outside valid range 0 to " + this.limit + " inclusive");
        }
        this.position = n;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }

    public final int limit() {
        return this.limit;
    }

    public final TDPacketStream limit(int n) throws SQLException {
        if (n > this.capacity || n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "new limit " + n + " is outside valid range 0 to " + this.capacity + " inclusive");
        }
        this.limit = n;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    public final TDPacketStream mark() {
        this.mark = this.position;
        return this;
    }

    public final TDPacketStream reset() throws SQLException {
        if (this.mark < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "negative mark " + this.mark);
        }
        this.position = this.mark;
        return this;
    }

    public final TDPacketStream clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public final TDPacketStream flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final TDPacketStream rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    final int nextGetIndex() throws SQLException {
        if (this.position >= this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", 1, this.limit, this.position);
        }
        return this.position++;
    }

    final int nextGetIndex(int n) throws SQLException {
        if (this.position + n > this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", n, this.limit, this.position);
        }
        int n2 = this.position;
        this.position += n;
        return n2;
    }

    final int nextPutIndex() throws SQLException {
        if (this.position >= this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "position " + this.position + " reached limit " + this.limit);
        }
        return this.position++;
    }

    final int nextPutIndex(int n) throws SQLException {
        if (this.position + n > this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "position " + this.position + " and count " + n + " exceed limit " + this.limit);
        }
        int n2 = this.position;
        this.position += n;
        return n2;
    }

    final int checkGetIndex(int n) throws SQLException {
        if (n < 0 || n >= this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", 1, this.limit, n);
        }
        return n;
    }

    final int checkGetIndex(int n, int n2) throws SQLException {
        if (n < 0 || n + n2 > this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ491", n2, this.limit, n);
        }
        return n;
    }

    final int checkIndex(int n) throws SQLException {
        if (n < 0 || n >= this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "index " + n + " is outside valid range 0 to " + this.limit + " exclusive");
        }
        return n;
    }

    final int checkIndex(int n, int n2) throws SQLException {
        if (n < 0 || n + n2 > this.limit) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "index " + n + " and extent " + n2 + " is outside valid range 0 to " + this.limit + " inclusive");
        }
        return n;
    }

    final int markValue() {
        return this.mark;
    }

    static void checkBounds(int n, int n2, int n3) throws SQLException {
        if ((n | n2 | n + n2 | n3 - (n + n2)) < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "offset " + n + " and length " + n2 + " exceed capacity " + n3);
        }
    }

    protected int ix(int n) {
        return n + 0;
    }

    public byte get() throws SQLException {
        return this.streamBuffer[this.ix(this.nextGetIndex())];
    }

    public byte get(int n) throws SQLException {
        return this.streamBuffer[this.ix(this.checkGetIndex(n))];
    }

    public TDPacketStream get(byte[] byArray) throws SQLException {
        return this.get(byArray, 0, byArray.length);
    }

    public TDPacketStream get(byte[] byArray, int n, int n2) throws SQLException {
        TDPacketStream.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "length " + n2 + " exceeds remaining " + this.remaining());
        }
        System.arraycopy(this.streamBuffer, this.ix(this.position()), byArray, n, n2);
        this.position(this.position() + n2);
        return this;
    }

    public TDPacketStream put(byte by) throws SQLException {
        this.streamBuffer[this.ix((int)this.nextPutIndex())] = by;
        return this;
    }

    public TDPacketStream put(int n, byte by) throws SQLException {
        this.streamBuffer[this.ix((int)this.checkIndex((int)n))] = by;
        return this;
    }

    public TDPacketStream put(byte[] byArray, int n, int n2) throws SQLException {
        TDPacketStream.checkBounds(n, n2, byArray.length);
        if (n2 > this.remaining()) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "length " + n2 + " exceeds remaining " + this.remaining());
        }
        System.arraycopy(byArray, n, this.streamBuffer, this.ix(this.position()), n2);
        this.position(this.position() + n2);
        return this;
    }

    public TDPacketStream putStream(TDPacketStream tDPacketStream) throws SQLException {
        if (tDPacketStream == this) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "source is also destination");
        }
        TDPacketStream tDPacketStream2 = tDPacketStream;
        int n = tDPacketStream2.remaining();
        if (n > this.remaining()) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "source count " + n + " exceeds remaining " + this.remaining());
        }
        System.arraycopy(tDPacketStream2.streamBuffer, tDPacketStream2.ix(tDPacketStream2.position()), this.streamBuffer, this.ix(this.position()), n);
        tDPacketStream2.position(tDPacketStream2.position() + n);
        this.position(this.position() + n);
        return this;
    }

    public int putInputStream(InputStream inputStream, int n) throws IOException, SQLException {
        if (n > this.remaining()) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "length " + n + " exceeds remaining " + this.remaining());
        }
        int n2 = inputStream.read(this.streamBuffer, this.position, n);
        if (n2 == -1) {
            n2 = 0;
        }
        this.position(this.position() + n2);
        return n2;
    }

    byte _get(int n) {
        return this.streamBuffer[n];
    }

    void _put(int n, byte by) {
        this.streamBuffer[n] = by;
    }

    public short getShort() throws SQLException {
        return ByteConverter.getShort(this.streamBuffer, this.ix(this.nextGetIndex(2)));
    }

    public short getShort(int n) throws SQLException {
        return ByteConverter.getShort(this.streamBuffer, this.ix(this.checkGetIndex(n, 2)));
    }

    public TDPacketStream putShort(short s) throws SQLException {
        ByteConverter.putShort(this.streamBuffer, this.ix(this.nextPutIndex(2)), s);
        return this;
    }

    public TDPacketStream putShort(int n, short s) throws SQLException {
        ByteConverter.putShort(this.streamBuffer, this.ix(this.checkIndex(n, 2)), s);
        return this;
    }

    public int getInt() throws SQLException {
        return ByteConverter.getInt(this.streamBuffer, this.ix(this.nextGetIndex(4)));
    }

    public int getUnsignedShort() throws SQLException {
        return ByteConverter.getUnsignedShort(this.streamBuffer, this.ix(this.nextGetIndex(2)));
    }

    public int getInt(int n) throws SQLException {
        return ByteConverter.getInt(this.streamBuffer, this.ix(this.checkGetIndex(n, 4)));
    }

    public TDPacketStream putInt(int n) throws SQLException {
        ByteConverter.putInt(this.streamBuffer, this.ix(this.nextPutIndex(4)), n);
        return this;
    }

    public TDPacketStream putInt(int n, int n2) throws SQLException {
        ByteConverter.putInt(this.streamBuffer, this.ix(this.checkIndex(n, 4)), n2);
        return this;
    }

    public long getLong() throws SQLException {
        return ByteConverter.getLong(this.streamBuffer, this.ix(this.nextGetIndex(8)));
    }

    public long getLong(int n) throws SQLException {
        return ByteConverter.getLong(this.streamBuffer, this.ix(this.checkGetIndex(n, 8)));
    }

    public TDPacketStream putLong(long l) throws SQLException {
        ByteConverter.putLong(this.streamBuffer, this.ix(this.nextPutIndex(8)), l);
        return this;
    }

    public TDPacketStream putLong(int n, long l) throws SQLException {
        ByteConverter.putLong(this.streamBuffer, this.ix(this.checkIndex(n, 8)), l);
        return this;
    }

    public float getFloat() throws SQLException {
        return ByteConverter.getFloat(this.streamBuffer, this.ix(this.nextGetIndex(4)));
    }

    public float getFloat(int n) throws SQLException {
        return ByteConverter.getFloat(this.streamBuffer, this.ix(this.checkGetIndex(n, 4)));
    }

    public TDPacketStream putFloat(float f) throws SQLException {
        ByteConverter.putFloat(this.streamBuffer, this.ix(this.nextPutIndex(4)), f);
        return this;
    }

    public TDPacketStream putFloat(int n, float f) throws SQLException {
        ByteConverter.putFloat(this.streamBuffer, this.ix(this.checkIndex(n, 4)), f);
        return this;
    }

    public double getDouble() throws SQLException {
        return ByteConverter.getDouble(this.streamBuffer, this.ix(this.nextGetIndex(8)));
    }

    public double getDouble(int n) throws SQLException {
        return ByteConverter.getDouble(this.streamBuffer, this.ix(this.checkGetIndex(n, 8)));
    }

    public TDPacketStream putDouble(double d) throws SQLException {
        ByteConverter.putDouble(this.streamBuffer, this.ix(this.nextPutIndex(8)), d);
        return this;
    }

    public TDPacketStream putDouble(int n, double d) throws SQLException {
        ByteConverter.putDouble(this.streamBuffer, this.ix(this.checkIndex(n, 8)), d);
        return this;
    }

    public BigInteger get16ByteBigInteger() throws SQLException {
        return ByteConverter.get16ByteBigInteger(this.streamBuffer, this.ix(this.nextGetIndex(16)));
    }

    public String getClobString(boolean bl, GenericTeradataConnection genericTeradataConnection, int n) throws SQLException {
        return Decoder.decodeClob(bl, genericTeradataConnection, this.streamBuffer, this.ix(this.nextGetIndex(n)), n);
    }

    public String getSlobString(boolean bl, GenericTeradataConnection genericTeradataConnection, int n) throws SQLException {
        return Decoder.decodeClob(bl, genericTeradataConnection, this.streamBuffer, this.ix(this.mark), n);
    }

    public void getSlobBytes(byte[] byArray, int n, int n2, int n3) throws SQLException {
        TDPacketStream.checkBounds(n, n3, byArray.length);
        if (n3 > this.capacity() - (n2 + this.mark)) {
            throw ErrorFactory.makeDriverJDBCException("TJ1596", "length " + n3 + " exceeds capacity " + this.capacity() + " less offset " + n2 + " and mark " + this.mark);
        }
        System.arraycopy(this.streamBuffer, this.ix(n2 + this.mark), byArray, n, n3);
    }

    public String getString(int n, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        return Decoder.decodeString(genericTeradataConnection, this.streamBuffer, this.ix(this.nextGetIndex(n)), n);
    }

    public String getStringUTF8(int n) throws SQLException {
        return Decoder.getUTF8DecodedString(this.streamBuffer, this.ix(this.nextGetIndex(n)), n);
    }

    public String getAsciiString(int n, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        return Decoder.decodeStringAscii(genericTeradataConnection, this.streamBuffer, this.ix(this.nextGetIndex(n)), n);
    }

    public String getAsciiString(int n, int n2, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        return Decoder.decodeStringAscii(genericTeradataConnection, this.streamBuffer, this.ix(this.checkGetIndex(n, n2)), n2);
    }

    public final TDPacketStream put(byte[] byArray) throws SQLException {
        return this.put(byArray, 0, byArray.length);
    }

    public void writeStream(TDNetworkIOIF tDNetworkIOIF) throws SQLException {
        this.writeStream(tDNetworkIOIF, null, true);
    }

    public void writeStream(TDNetworkIOIF tDNetworkIOIF, TDStatement tDStatement, boolean bl) throws SQLException {
        tDNetworkIOIF.write(this.streamBuffer, tDStatement, bl);
    }

    public void readStream(TDNetworkIOIF tDNetworkIOIF) throws SQLException {
        this.readStream(tDNetworkIOIF, null, 0, true);
    }

    public void readStream(TDNetworkIOIF tDNetworkIOIF, TDStatement tDStatement, int n, boolean bl) throws SQLException {
        this.clear();
        int n2 = tDNetworkIOIF.read(this, n, tDStatement, bl);
        this.limit(n2);
        this.position = 0;
    }

    public void setMsgLength(int n) throws SQLException {
        byte[] byArray = new byte[4];
        ByteConverter.putInt(byArray, 0, n);
        short s = ByteConverter.getShort(byArray, 0);
        short s2 = ByteConverter.getShort(byArray, 2);
        this.putShort(8, s2);
        this.putShort(3, s);
    }
}

