/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignParcel;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.AuthMechParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConnectParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SSORequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionOptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import org.ietf.jgss.Oid;

public class GenericLogonController {
    private LogonInformation m_logonInfo;
    private GenericTeradataConnection m_con;
    private Reconnect m_reconnect;
    private boolean m_bConfigOnly;

    public GenericLogonController(GenericTeradataConnection genericTeradataConnection) {
        this.m_logonInfo = genericTeradataConnection.getLogonInformation();
        this.m_con = genericTeradataConnection;
    }

    public void setReconnect(Reconnect reconnect) {
        this.m_reconnect = reconnect;
    }

    public void setConfigOnly() {
        this.m_bConfigOnly = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws SQLException {
        Parcel parcel;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        ArrayList<Oid> arrayList;
        TDPacket tDPacket;
        Log log;
        block82: {
            String string;
            Object object7;
            Object object8;
            block83: {
                boolean bl;
                boolean bl2;
                Oid oid;
                boolean bl3;
                Oid oid2;
                Object object9;
                Object object10;
                block84: {
                    log = this.m_con.getLog();
                    tDPacket = this.m_con.createPacket(1);
                    if (log.isDebugEnabled()) {
                        log.debug("GenericLogonController.run: reconnect=" + (this.m_reconnect != null) + " ConfigResponse=" + (this.m_con.getConfigResponse() != null) + " GtwConfig=" + (this.m_con.getGtwConfig() != null) + " AuthMech=" + !this.m_con.getAuthMechParcels().isEmpty() + " m_bConfigOnly=" + this.m_bConfigOnly);
                    }
                    tDPacket.setInitParcelPosition();
                    tDPacket.setLANKind((byte)10);
                    tDPacket.setByteVar((byte)7);
                    tDPacket.setHostCharSet((byte)-1);
                    if (this.m_reconnect != null) {
                        tDPacket.setSessionNumber(this.m_con.getSessionNum());
                        tDPacket.setAuthentication(this.m_reconnect.nAuthenticationNonce);
                    }
                    ClientConfigParcel clientConfigParcel = new ClientConfigParcel(this.m_con);
                    tDPacket.addParcel(clientConfigParcel);
                    tDPacket.toStream();
                    tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                    tDPacket.clear();
                    tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                    tDPacket.initParcelFactory(this.m_con);
                    ArrayList<AuthMechParcel> arrayList2 = new ArrayList<AuthMechParcel>();
                    arrayList = new ArrayList<Oid>();
                    block30: while ((object6 = tDPacket.nextParcel()) != null) {
                        switch (((Parcel)object6).getFlavor()) {
                            case 43: {
                                object10 = (ConfigRspParcel)object6;
                                this.m_con.setConfigResponse((ConfigRspParcel)object10);
                                continue block30;
                            }
                            case 165: {
                                object8 = (GtwConfigParcel)object6;
                                this.m_con.setGtwConfig((GtwConfigParcel)object8);
                                continue block30;
                            }
                            case 167: {
                                object7 = (AuthMechParcel)object6;
                                arrayList2.add((AuthMechParcel)object7);
                                if (!((AuthMechParcel)object7).isCIBypassSupported() || !this.m_con.getIO().isSSLSocket()) continue block30;
                                arrayList.add(((AuthMechParcel)object7).getMechOid());
                                continue block30;
                            }
                            case 9: {
                                FailureParcel failureParcel = (FailureParcel)object6;
                                throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                            }
                            case 49: {
                                ErrorParcel errorParcel = (ErrorParcel)object6;
                                throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                            }
                        }
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object6).getFlavor()));
                    }
                    this.m_con.setAuthMechParcels(arrayList2);
                    if (this.m_con.getConfigResponse() == null || this.m_con.getGtwConfig() == null || this.m_con.getAuthMechParcels().isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ1560");
                    }
                    if (this.m_bConfigOnly) {
                        return;
                    }
                    object6 = this.m_con.getTeraEncrypt();
                    object10 = new ArrayList();
                    object8 = null;
                    object7 = null;
                    for (Object object11 : this.m_con.getAuthMechParcels()) {
                        if (log.isDebugEnabled()) {
                            log.debug("New Server Mechanism: " + ((GenericTeraEncrypt)object6).getMechNameForOid(((AuthMechParcel)object11).getMechOid()) + "   " + ((AuthMechParcel)object11).getMechOid());
                        }
                        object10.add(((AuthMechParcel)object11).getMechOid());
                        if (((AuthMechParcel)object11).isDefaultMechanism()) {
                            object8 = ((AuthMechParcel)object11).getMechOid();
                            if (log.isDebugEnabled()) {
                                log.debug(" Default Server Mechanism is: " + ((AuthMechParcel)object11).getMechOid());
                            }
                        }
                        if (!((AuthMechParcel)object11).isDefaultNegotiatingMechanism()) continue;
                        object7 = ((AuthMechParcel)object11).getMechOid();
                        if (!log.isDebugEnabled()) continue;
                        log.debug(" Negotiation Mechanism Supported: " + this.m_con.getGtwConfig().isNegotiationMechanismSupported() + "   Default Server Negotiating Mechanism is: " + ((AuthMechParcel)object11).getMechOid());
                    }
                    string = this.m_con.getURLParameters().getLogMech();
                    if ("NONE".equalsIgnoreCase(string)) {
                        this.m_con.getIO().close();
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        Object object11;
                        object11 = this.m_con.getURLParameters().getLogMech(true);
                        object9 = this.m_con.getURLParameters().getLogData();
                        boolean bl4 = object9 != null && ((String)object9).startsWith("token=");
                        oid2 = bl4 ? ((String)object9).substring("token=".length()) : null;
                        log.debug("Original LOGMECH=" + (String)object11 + " Current LOGMECH=" + (String)string + " LOGDATA=" + (String)object9 + " (len=" + (object9 != null ? "" + ((String)object9).length() : "n/a") + ")" + " bHasToken=" + bl4);
                        Utility.getJWTHeaderAndPayload((String)((Object)oid2), log, "Original LOGMECH=" + (String)object11);
                    }
                    if (object10.isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ334");
                    }
                    bl3 = false;
                    object9 = null;
                    oid = ((GenericTeraEncrypt)object6).getClientDefaultMech(false);
                    Oid oid3 = oid2 = this.m_con.getGtwConfig().isNegotiationMechanismSupported() ? ((GenericTeraEncrypt)object6).getClientDefaultMech(true) : null;
                    if (string == null && oid == null && oid2 == null) break block83;
                    if (string != null && (object9 = ((GenericTeraEncrypt)object6).getOidForName(string)) == null) {
                        throw ErrorFactory.makeDriverJDBCException("TJ335", string);
                    }
                    boolean bl5 = false;
                    bl2 = false;
                    bl = false;
                    object5 = object10.iterator();
                    while (object5.hasNext()) {
                        object4 = (Oid)object5.next();
                        if (object9 != null && ((Oid)object9).equals(object4)) {
                            bl5 = true;
                        }
                        if (oid != null && oid.equals(object4)) {
                            bl2 = true;
                        }
                        if (oid2 == null || !oid2.equals(object4)) continue;
                        bl = true;
                    }
                    if (!bl5) break block84;
                    object3 = object9;
                    break block82;
                }
                if (bl) {
                    object3 = oid2;
                    bl3 = true;
                    break block82;
                } else if (bl2) {
                    object3 = oid;
                    bl3 = true;
                    break block82;
                } else {
                    object5 = null;
                    if (object9 != null) {
                        object5 = string;
                    } else if (oid2 != null) {
                        object5 = oid2.toString();
                    } else if (oid != null) {
                        object5 = oid.toString();
                    }
                    object4 = new StringBuffer(Log.LINE_SEP + ErrorMessage.Format1(ErrorMessage.messages.getString("TJ340"), (String)object5) + Log.LINE_SEP + ErrorMessage.messages.getString("TJ337"));
                    Iterator iterator = object10.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw ErrorFactory.makeDriverJDBCException("TJ341", ((StringBuffer)object4).toString());
                        }
                        Oid oid4 = (Oid)iterator.next();
                        ((StringBuffer)object4).append(Log.LINE_SEP + ((GenericTeraEncrypt)object6).getMechNameForOid(oid4) + "  " + oid4);
                    }
                }
            }
            if (this.m_con.getGtwConfig().isNegotiationMechanismSupported() && object7 != null) {
                object3 = object7;
            } else {
                if (object8 == null) {
                    throw ErrorFactory.makeDriverJDBCException("TJ333", string);
                }
                object3 = object8;
            }
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)2 : 1);
        tDPacket.setByteVar((byte)7);
        tDPacket.setAuthentication(this.m_reconnect != null ? this.m_reconnect.nAuthenticationNonce : this.m_con.getAuthenticationNonce());
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        if (this.m_reconnect != null) {
            tDPacket.setSessionNumber(this.m_con.getSessionNum());
        }
        AssignParcel assignParcel = new AssignParcel(this.m_con);
        ((GenericTeraEncrypt)object6).useAuthMech(this.m_con, (Oid)object3);
        byte[] byArray = ((GenericTeraEncrypt)object6).getIntoken();
        byte[] byArray2 = ((GenericTeraEncrypt)object6).initSecContext(byArray, 0, byArray.length, arrayList);
        if (byArray2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ343");
        }
        object5 = new SSORequestParcel(this.m_con);
        ((SSORequestParcel)object5).setTrip(((GenericTeraEncrypt)object6).getTrip());
        ((GenericTeraEncrypt)object6).incTrip();
        ((SSORequestParcel)object5).setAuthData(byArray2);
        ((SSORequestParcel)object5).setMethod(((GenericTeraEncrypt)object6).getSSOAuthMethod());
        tDPacket.addParcel((Parcel)object5);
        ((GenericTeraEncrypt)object6).updateGeneratedCredentials();
        if (!this.m_con.isExtObjectNameParcelSupported()) {
            assignParcel.setUserName(this.m_con.noTransmitCredentials() || ((GenericTeraEncrypt)object6).isUsingGeneratedCredentials() ? "" : this.m_logonInfo.getUserName());
        }
        tDPacket.addParcel(assignParcel);
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        if (log.isDebugEnabled()) {
            log.debug("packet.getEncryption=" + tDPacket.getEncryption());
        }
        this.m_con.setSessionNum(tDPacket.getLANSessionNumber());
        block34: while ((object4 = tDPacket.nextParcel()) != null) {
            switch (((Parcel)object4).getFlavor()) {
                case 101: {
                    this.m_con.setAssignRspParcel((AssignRspParcel)object4);
                    continue block34;
                }
                case 43: {
                    continue block34;
                }
                case 134: {
                    object2 = (SSOResponseParcel)object4;
                    this.m_con.getTeraEncrypt().setIntoken(((SSOResponseParcel)object2).getAuthData());
                    continue block34;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)object4;
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)object4;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            log.error("AssignRspState receive an un-expected parcel with flavor: " + ((Parcel)object4).getFlavor());
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object4).getFlavor()));
        }
        this.m_con.m_nDHKE = 0;
        try {
            byArray = ((GenericTeraEncrypt)object6).getIntoken();
            do {
                tDPacket.clear();
                tDPacket.newLanHeader();
                tDPacket.setInitParcelPosition();
                tDPacket.setLANKind((byte)12);
                tDPacket.setByteVar((byte)7);
                tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
                tDPacket.setSessionNumber(this.m_con.getSessionNum());
                log.debugByteArray("EncryptContextState calling initSecContext with", byArray);
                byArray2 = ((GenericTeraEncrypt)object6).initSecContext(byArray, 0, byArray.length, arrayList);
                log.debugByteArray("EncryptContextState called initSecContext and got", byArray2);
                ((GenericTeraEncrypt)object6).updateGeneratedCredentials();
                if (byArray2 == null && !((GenericTeraEncrypt)object6).isEstablished()) {
                    byArray2 = new byte[]{};
                }
                if (byArray2 == null) continue;
                tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
                object5 = new SSORequestParcel(this.m_con);
                ((SSORequestParcel)object5).setTrip(((GenericTeraEncrypt)object6).getTrip());
                ((GenericTeraEncrypt)object6).incTrip();
                ((SSORequestParcel)object5).setAuthData(byArray2);
                ((SSORequestParcel)object5).setMethod(((GenericTeraEncrypt)object6).getSSOAuthMethod());
                tDPacket.addParcel((Parcel)object5);
                tDPacket.toStream();
                tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                tDPacket.clear();
                tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                tDPacket.initParcelFactory(this.m_con);
                block36: while ((object4 = tDPacket.nextParcel()) != null) {
                    switch (((Parcel)object4).getFlavor()) {
                        case 134: {
                            object2 = (SSOResponseParcel)object4;
                            byArray = ((SSOResponseParcel)object2).getAuthData();
                            log.debugByteArray("EncryptContextState called getAuthData and got", byArray);
                            ++this.m_con.m_nDHKE;
                            continue block36;
                        }
                        case 9: {
                            FailureParcel failureParcel = (FailureParcel)object4;
                            throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                        }
                        case 49: {
                            ErrorParcel errorParcel = (ErrorParcel)object4;
                            throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                        }
                    }
                    throw ErrorFactory.makeIoJDBCException("TJ305", Integer.toString(((Parcel)object4).getFlavor()), this.m_con.getIO(), null, log);
                }
            } while (!((GenericTeraEncrypt)object6).isEstablished());
            if (log.isDebugEnabled()) {
                ((GenericTeraEncrypt)object6).showContext();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw ErrorFactory.makeIoJDBCException("TJ331", "GenericEncryptContextState action", this.m_con.getIO(), throwable, log);
        }
        if (log.isDebugEnabled()) {
            log.debug("m_con.m_nDHKE=" + this.m_con.m_nDHKE);
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)4 : 3);
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        if (this.m_reconnect != null) {
            tDPacket.setRequestNumber(this.m_reconnect.nRequestNumber);
            tDPacket.setByteVar((byte)1);
        }
        object4 = new LogonParcel(this.m_con);
        if (this.m_con.noTransmitCredentials() || ((GenericTeraEncrypt)object6).isUsingGeneratedCredentials()) {
            object2 = this.m_logonInfo.getAccount();
            if (object2 != null && ((String)object2).length() > 0) {
                object = new LogonInformation(null, null);
                ((LogonInformation)object).setAccount((String)object2);
                ((LogonParcel)object4).setLogonInformation((LogonInformation)object);
            }
        } else {
            ((LogonParcel)object4).setLogonInformation(this.m_logonInfo);
        }
        tDPacket.addParcel((Parcel)object4);
        object2 = new SessionOptionsParcel(this.m_con);
        ((SessionOptionsParcel)object2).setSemantics(this.m_con.getTransactionSemantics());
        if (this.m_con.getConfigResponse().statementStatusLevel() >= 1) {
            ((SessionOptionsParcel)object2).setEssFlag((byte)69);
            ((SessionOptionsParcel)object2).setEssLevel((byte)1);
        }
        if (this.m_con.getURLParameters().getConnectFunction() == 1 && this.m_con instanceof TDSession && ((TDSession)this.m_con).useCheckWorkload()) {
            ((SessionOptionsParcel)object2).setCheckWorkload((byte)49);
        }
        if (this.m_con.desiredRedriveLevel() >= 4 && this.m_con.databaseCapableOfRedriveLevel() >= 3) {
            ((SessionOptionsParcel)object2).setRedrive((byte)89);
        }
        tDPacket.addParcel((Parcel)object2);
        object = new ConnectParcel(this.m_con);
        ((ConnectParcel)object).setPartitionName(this.m_con.getURLParameters().getPartition());
        if (this.m_con.getURLParameters().getLogonSequenceNumber() != null) {
            ((ConnectParcel)object).setLogonSequenceNumber(this.m_con.getURLParameters().getLogonSequenceNumber());
        }
        ((ConnectParcel)object).setFunction(this.m_con.getURLParameters().getConnectFunction());
        tDPacket.addParcel((Parcel)object);
        byte by = this.m_con.getConfigResponse().getClientAttributesSupport();
        LogonDataParcel logonDataParcel = new LogonDataParcel(this.m_con.getIO(), this.m_con.getURLParameters().getLssType(), this.m_con);
        if (by <= 1) {
            tDPacket.addParcel(logonDataParcel);
        }
        ClientAttributesParcel clientAttributesParcel = new ClientAttributesParcel(this.m_con);
        if (by >= 1) {
            tDPacket.addParcel(clientAttributesParcel);
        }
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        block37: while (true) {
            if ((parcel = tDPacket.nextParcel()) == null) {
                return;
            }
            switch (parcel.getFlavor()) {
                case 8: 
                case 205: {
                    StatementStatusParcel statementStatusParcel = (StatementStatusParcel)parcel;
                    statementStatusParcel.verifySuccess();
                    if (statementStatusParcel.getSQLWarnings() == null) continue block37;
                    this.m_con.setNeedNewPassword(statementStatusParcel.hasWarningCode(3032));
                    if (this.m_con.supportsPasswordChange()) continue block37;
                    Object object12 = statementStatusParcel.getSQLWarnings();
                    this.m_con.addWarning((SQLWarning)object12);
                    continue block37;
                }
                case 137: {
                    continue block37;
                }
                case 89: {
                    this.m_con.setLogonSequenceNumberParcel((LogonSequenceNumberParcel)parcel);
                    continue block37;
                }
                case 9: {
                    Object object12 = (FailureParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object12).getMsg(), ((ErrorParcel)object12).getCode());
                }
                case 12: {
                    EndRequestParcel endRequestParcel = (EndRequestParcel)parcel;
                    continue block37;
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            break;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
    }

    public static class Reconnect {
        public long nAuthenticationNonce;
        public int nRequestNumber;
    }
}

