/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.TeraDatabaseMetaData;
import com.teradata.jdbc.TeraDriver;
import com.teradata.jdbc.TeraParameterMetaData;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.TeraSQLInput;
import com.teradata.jdbc.TeraSQLOutput;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.client.ClientArray;
import com.teradata.jdbc.client.ClientBlob;
import com.teradata.jdbc.client.ClientClob;
import com.teradata.jdbc.client.ClientStruct;
import com.teradata.jdbc.jdbc.GenericLogoffController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc_4.GeneratedKeysRequest;
import com.teradata.jdbc.jdbc_4.ResponseTracker;
import com.teradata.jdbc.jdbc_4.TDCallableStatement;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.BigResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.CancelParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ConfigController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;

public class TDSession
extends GenericTeradataConnection
implements Connection,
ResultSetHelper {
    private boolean bAutoCommit = true;
    private boolean m_bUseAnsiDate = true;
    private boolean transactionInProgress;
    private int m_nDeferredLobToken = 0;
    private Map m_mapDeferredLobs = new HashMap();
    private volatile boolean m_bStatementCleanupStarted = false;
    private Set m_setRegisteredStatements = new LinkedHashSet();
    private int writableLobId = 1;
    private byte m_spReturnResult = 0;
    private Map m_typeMap = Collections.EMPTY_MAP;
    private ResponseTracker m_responseTracker = new ResponseTracker();
    private List m_listCloseCursorsAtCommitStatements = new ArrayList();
    private int m_nHoldabilityForSubsequentStatements = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDSession(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, string2, string3, uRLParameters);
        Object object;
        if (uRLParameters.isJavaSPDefaultConnection()) {
            this.bAutoCommit = false;
            TDNetworkIOIF.createIO(this, TeraDriver.getCurrentThreadDefaultConnection());
            try {
                object = new ConfigController(this);
                ((ConfigController)object).run();
            }
            catch (SQLException sQLException) {
                if (this.io != null) {
                    this.io.close();
                }
                throw sQLException;
            }
        }
        if (this.isClosed()) {
            return;
        }
        try {
            if (this.supportsPasswordChange()) {
                object = "MODIFY USER " + Utility.quoteName(this.getLogonInformation().getUserName()) + " AS PASSWORD=" + Utility.ensureQuotedName(uRLParameters.getNewPassword());
                this.executeSessionRequest("TDSession constructor", false, (String)object, false);
                if (this.isAnsiMode()) {
                    this.executeSessionRequest("TDSession constructor", false, "COMMIT WORK", false);
                }
                this.needNewPassword = false;
            }
            if (this.needNewPassword) {
                return;
            }
            if (uRLParameters.isJavaSPDefaultConnection()) {
                boolean bl;
                Byte by = (Byte)TeraDriver.getCurrentThreadDefaultConnection().getOptions().get("TransactionContext");
                if (by != null) {
                    byte by2 = by;
                    bl = (by2 & 1) != 0;
                    boolean bl2 = this.transactionInProgress = (by2 & 2) != 0;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("TransactionContext=" + by2 + " bSessionIsAnsiMode=" + bl + " transactionInProgress=" + this.transactionInProgress);
                    }
                } else {
                    try (TDResultSet tDResultSet = this.executeSessionRequest("TDSession constructor", true, "HELP SESSION", false);){
                        tDResultSet.next();
                        bl = "ANSI".equals(tDResultSet.getObject(8));
                    }
                }
                uRLParameters.setTransactMode(bl ? "ANSI" : "TERA");
                if (!this.isAnsiMode()) {
                    boolean bl3 = this.bAutoCommit = !this.transactionInProgress;
                }
            }
            if (uRLParameters.getRunStartup() && !uRLParameters.isJavaSPDefaultConnection()) {
                this.runUserStartup();
            }
            if (uRLParameters.getDatabaseName() != null && uRLParameters.getDatabaseName().length() > 0 && !uRLParameters.getDatabaseName().equals("NO_DEF_DATABASE")) {
                String string4 = "DATABASE " + Utility.ensureQuotedName(uRLParameters.getDatabaseName());
                if (this.isAnsiMode()) {
                    string4 = string4 + ";COMMIT WORK";
                }
                this.executeSessionRequest("TDSession constructor", false, string4, false);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            throw sQLException;
        }
    }

    private void initPacketForRequest(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(by);
        tDPacket.setHostCharSet(this.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.getSessionNum());
        tDPacket.setAuthentication(this.getAuthenticationNonce());
        tDPacket.setRequestNumber(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendAndReceive(TDPacket tDPacket, int n, String string, Integer n2) throws SQLException {
        this.io.sendPacket(tDPacket, null, true);
        tDPacket.clear();
        this.io.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(this.io, null, n, true);
        }
        finally {
            this.io.releaseReadLock();
        }
        tDPacket.initParcelFactory(this);
        this.setTransactionInProgress(tDPacket.inTransaction());
        switch (tDPacket.nextParcelPeek()) {
            case 9: 
            case 49: {
                boolean bl;
                ErrorParcel errorParcel = (ErrorParcel)tDPacket.nextParcel();
                SQLException sQLException = ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode(), errorParcel.getInfo());
                if (this.log.canLog(1)) {
                    this.log.info(string + " produced Error or Failure parcel: " + sQLException);
                }
                boolean bl2 = bl = n2 != null && sQLException.getErrorCode() == n2.intValue();
                if (bl) {
                    return true;
                }
                throw sQLException;
            }
        }
        return false;
    }

    private void runUserStartup() throws SQLException {
        Parcel parcel;
        ResponseParcel responseParcel;
        TDPacket tDPacket = this.createPacket(1);
        int n = this.getRequestNum();
        this.initPacketForRequest(tDPacket, (byte)5, n);
        OptionsParcel optionsParcel = new OptionsParcel(this);
        optionsParcel.setDBCFunction((byte)69);
        optionsParcel.setReturnStatementInfo(this.isStatementInfoSupported());
        if (this.isLargeDecimalAndBigIntSupported()) {
            optionsParcel.setMaxDecimalPrecision(this.getMaxDecimalPrecision());
        }
        if (this.areAPHResponsesSupported()) {
            optionsParcel.setAPHResponses((byte)89);
        }
        if (this.dynamicResultSetsSupported()) {
            optionsParcel.setDynamicResultSetAllowed(true);
            optionsParcel.setSPReturnResult(this.getSPReturnResult());
        }
        if (this.isArrayDataTypeSupported()) {
            optionsParcel.setArrayTransformOff((byte)89);
        }
        tDPacket.addParcel(optionsParcel);
        tDPacket.getBuffer().putShort((short)2);
        tDPacket.getBuffer().putShort((short)4);
        tDPacket.addToMsgLength(4);
        if (this.areAPHResponsesSupported()) {
            responseParcel = new BigResponseParcel(this);
            responseParcel.setMaxMsgSize(this.getMaxMessageSize(false, false));
        } else {
            responseParcel = new ResponseParcel(this);
        }
        tDPacket.addParcel(responseParcel);
        boolean bl = this.sendAndReceive(tDPacket, 0, "RUNSTARTUP Execute", new Integer(3747));
        boolean bl2 = this.isAnsiMode() && this.transactionInProgress;
        boolean bl3 = bl;
        while (!bl3 && (parcel = tDPacket.nextParcel()) != null) {
            if (!(parcel instanceof EndRequestParcel)) continue;
            bl3 = true;
        }
        if (!bl3) {
            this.initPacketForRequest(tDPacket, (byte)6, n);
            parcel = new CancelParcel(this);
            tDPacket.addParcel(parcel);
            this.sendAndReceive(tDPacket, 0, "RUNSTARTUP Continue/Cancel", null);
        }
        if (bl2) {
            this.executeSessionRequest("runUserStartup", false, "COMMIT WORK", false);
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            if (this.isJavaSPDefaultConnection()) {
                return;
            }
            this.cleanUpStatements();
            GenericLogoffController genericLogoffController = new GenericLogoffController(this);
            this.log.debug("TDSession.close: logoff waiting for session lock");
            this.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            try {
                this.log.debug("TDSession.close: acquired session lock, beginning logoff");
                genericLogoffController.run();
                this.io.close();
            }
            finally {
                this.releaseSessionLock();
                this.log.debug("TDSession.close: logoff complete");
            }
        }
    }

    public ResponseTracker responseTracker() {
        return this.m_responseTracker;
    }

    public void setTransactionInProgress(boolean bl) {
        this.transactionInProgress = bl;
    }

    public synchronized int getWritableLobId() {
        if (this.writableLobId < 0) {
            this.writableLobId = 0;
        }
        return this.writableLobId++;
    }

    public String getLobTempTable() {
        return this.urlParams.getLobTempTable();
    }

    public boolean shouldSendAnsiDate() {
        return this.isStatementInfoRequestSupported() && this.m_bUseAnsiDate;
    }

    @Override
    public String useAnsiDate() {
        this.m_bUseAnsiDate = true;
        return "";
    }

    @Override
    public String useIntegerDate() {
        this.m_bUseAnsiDate = false;
        return "";
    }

    public TDResultSet executeSessionRequest(String string, boolean bl, String string2, boolean bl2) throws SQLException {
        return this.executeSessionRequest(string, bl, string2, bl2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDResultSet executeSessionRequest(String string, boolean bl, String string2, boolean bl2, int n) throws SQLException {
        TDStatement tDStatement = (TDStatement)this.createStatement(1003, 1007, 1);
        try {
            if (bl2) {
                this.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            }
            try {
                TDResultSet tDResultSet;
                if (this.log.canLog(1)) {
                    this.log.info(string + ": " + string2);
                }
                StatementController statementController = new StatementController(tDStatement, this, string2);
                statementController.setRequestOrigin("driver " + string);
                statementController.setMode(bl ? (byte)66 : 69);
                statementController.setResultTypeExpected(bl ? 2 : 1);
                tDStatement.setUseKeepResponse(false);
                tDStatement.resetStatementStartTime();
                if (n > 0) {
                    tDStatement.setQueryTimeout(n);
                }
                tDStatement.setState(3);
                statementController.run();
                TDResultSet tDResultSet2 = tDResultSet = bl ? tDStatement.getResults().getResult().getResultSet() : null;
                if (tDResultSet != null) {
                    tDResultSet.setMetadataRS(true);
                }
                TDResultSet tDResultSet3 = tDResultSet;
                if (bl2) {
                    this.releaseSessionLock();
                }
                return tDResultSet3;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    this.releaseSessionLock();
                }
                throw throwable;
            }
        }
        finally {
            if (!bl) {
                tDStatement.internalClose(false, bl2);
            }
        }
    }

    public int queryDatabaseLSN() throws SQLException {
        try (TDResultSet tDResultSet = this.executeSessionRequest("queryDatabaseLSN", true, "select cast(from_bytes('00'xb || substring(LogonSequenceNo from 2 for 1) || substring(LogonSequenceNo from 1 for 1) || substring(LogonSequenceNo from 4 for 1) || substring(LogonSequenceNo from 3 for 1), 'base10') as integer) as LSN from DBC.SessionInfoV where SessionNo = session", true);){
            int n = tDResultSet.next() ? tDResultSet.getInt(1) : 0;
            return n;
        }
    }

    public boolean uncheckedGetAutoCommit() {
        return this.bAutoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return this.bAutoCommit;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.doCommit("setAutoCommit", true, null);
        this.bAutoCommit = bl;
    }

    @Override
    public void commit() throws SQLException {
        this.doCommit("commit", true, null);
    }

    private void doCommit(String string, boolean bl, TDStatement tDStatement) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.isAnsiMode()) {
            if (this.transactionInProgress) {
                this.executeSessionRequest(string, false, "COMMIT WORK", bl);
            }
        } else {
            while (this.transactionInProgress) {
                this.executeSessionRequest(string, false, "ET", bl);
            }
        }
        this.closeCursorsAtCommitResultSets(tDStatement, bl);
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.m_nHoldabilityForSubsequentStatements);
    }

    @Override
    public void rollback() throws SQLException {
        block4: {
            try {
                if (this.isAnsiMode()) {
                    this.executeSessionRequest("rollback", false, "ROLLBACK WORK", true);
                } else {
                    this.executeSessionRequest("rollback", false, "ABORT", true);
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 3514) break block4;
                throw sQLException;
            }
        }
    }

    public void beforeExecuteStatement() throws SQLException {
        if (!(this.isAnsiMode() || this.bAutoCommit || this.transactionInProgress)) {
            this.executeSessionRequest("beforeExecuteStatement", false, "BT", false);
        }
    }

    public void afterExecuteStatement(TDStatement tDStatement) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        if (this.bAutoCommit) {
            this.doCommit("afterExecuteStatement", false, tDStatement);
        }
    }

    public void acquireSessionLock(Mutex.AcquireCallback acquireCallback) throws SQLException {
        this.sessionLock.acquire(acquireCallback);
        if (this.isClosed()) {
            this.sessionLock.release();
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    public void releaseSessionLock() {
        this.sessionLock.release();
    }

    public boolean isAphSupported() {
        return this.configRsp.getAPHSupport();
    }

    public boolean isPositioningSupported() {
        return this.configRsp.getPositioningSupport();
    }

    public boolean isStatementPositioningSupported() {
        return this.configRsp.getStatementPositioningSupport();
    }

    public boolean areAPHResponsesSupported() {
        return this.configRsp.getAPHResponseSupport();
    }

    public boolean generatedKeysSupported() {
        return this.configRsp.getGeneratedKeysSupport();
    }

    public boolean trustedSessionsSupport() {
        return this.configRsp.getTrustedSessionsSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerDeferredLob(DeferredLob deferredLob) {
        Map map = this.m_mapDeferredLobs;
        synchronized (map) {
            ++this.m_nDeferredLobToken;
            this.m_mapDeferredLobs.put(new Integer(this.m_nDeferredLobToken), deferredLob);
            return this.m_nDeferredLobToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeferredLob unregisterDeferredLob(int n) {
        Map map = this.m_mapDeferredLobs;
        synchronized (map) {
            return (DeferredLob)this.m_mapDeferredLobs.remove(new Integer(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeferredLob getDeferredLob(int n) throws IOException, SQLException {
        Map map = this.m_mapDeferredLobs;
        synchronized (map) {
            return (DeferredLob)this.m_mapDeferredLobs.get(new Integer(n));
        }
    }

    public boolean arraySupported() {
        return this.configRsp.getArraySupport();
    }

    public boolean outParamArgSupported() {
        return this.configRsp.getOutParamArgSupport();
    }

    public boolean isLargeDecimalAndBigIntSupported() {
        return this.configRsp.isLargeDecimalAndBigIntSupported();
    }

    public byte getMaxDecimalPrecision() {
        if (this.configRsp.isLargeDecimalAndBigIntSupported()) {
            return 38;
        }
        return 18;
    }

    public short getMaximumNumberOfSegments() {
        return this.configRsp.getMaximumNumberOfSegments();
    }

    public int getMaximumSegmentSize() {
        return this.configRsp.getMaximumSegmentSize();
    }

    public int getCompatDBS() {
        return this.urlParams.getCompatDBS();
    }

    public int getCompatIsAutoInc() {
        return this.urlParams.getCompatIsAutoInc();
    }

    public int getCompatIsCurrency() {
        return this.urlParams.getCompatIsCurrency();
    }

    public int getCompatIsSigned() {
        return this.urlParams.getCompatIsSigned();
    }

    public int getCompatIsSearch() {
        return this.urlParams.getCompatIsSearch();
    }

    public String getCompatGetSchema() {
        return this.urlParams.getCompatGetSchema();
    }

    public String getCompatGetTable() {
        return this.urlParams.getCompatGetTable();
    }

    public int getCompatIsReadOnly() {
        return this.urlParams.getCompatIsReadOnly();
    }

    public int getCompatIsWritable() {
        return this.urlParams.getCompatIsWritable();
    }

    public int getCompatIsDefWrit() {
        return this.urlParams.getCompatIsDefWrit();
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        boolean bl;
        String string = null;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ396", n);
            }
        }
        n = this.getMappedTransactionLevel(n);
        switch (n) {
            case 8: {
                string = "SR";
                break;
            }
            case 2: {
                string = "RC";
                break;
            }
            case 1: {
                string = "RU";
                break;
            }
            case 4: {
                string = "RR";
            }
        }
        boolean bl2 = bl = n == this.configRsp.getSupportedTransactionIsolationLevels();
        if (bl) {
            return;
        }
        String string2 = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + string;
        if (this.isAnsiMode()) {
            string2 = string2 + ";COMMIT WORK";
        }
        this.executeSessionRequest("setTransactionIsolation", false, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        try (TDResultSet tDResultSet = this.executeSessionRequest("getTransactionIsolation", true, "HELP SESSION", true);){
            if (tDResultSet.next() && tDResultSet.getMetaData().getColumnCount() >= 42) {
                String string = String.valueOf(tDResultSet.getObject(42)).trim();
                if ("SR".equals(string)) {
                    int n = 8;
                    return n;
                }
                if ("RC".equals(string)) {
                    int n = 2;
                    return n;
                }
                if ("RU".equals(string)) {
                    int n = 1;
                    return n;
                }
                if ("RR".equals(string)) {
                    int n = 4;
                    return n;
                }
            }
            int n = this.configRsp.getTransactionIsolationDefault();
            return n;
        }
    }

    private int getMappedTransactionLevel(int n) {
        while (n < 8) {
            if ((n & this.configRsp.getSupportedTransactionIsolationLevels()) != 0) {
                return n;
            }
            n <<= 1;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerStatement(TDStatement tDStatement) {
        if (this.m_bStatementCleanupStarted) {
            return false;
        }
        TDSession tDSession = this;
        synchronized (tDSession) {
            if (this.m_bStatementCleanupStarted) {
                return false;
            }
            this.m_setRegisteredStatements.add(tDStatement);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStatement(TDStatement tDStatement) {
        if (this.m_bStatementCleanupStarted) {
            return;
        }
        TDSession tDSession = this;
        synchronized (tDSession) {
            if (this.m_bStatementCleanupStarted) {
                return;
            }
            this.m_setRegisteredStatements.remove(tDStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpStatements() throws SQLException {
        TDSession tDSession = this;
        synchronized (tDSession) {
            this.m_bStatementCleanupStarted = true;
            Iterator iterator = this.m_setRegisteredStatements.iterator();
            while (iterator.hasNext()) {
                ((TDStatement)iterator.next()).cancel();
            }
            iterator = this.m_setRegisteredStatements.iterator();
            while (iterator.hasNext()) {
                ((TDStatement)iterator.next()).close();
            }
            this.m_setRegisteredStatements.clear();
        }
    }

    public boolean isCleanUpStatementsStarted() {
        return this.m_bStatementCleanupStarted;
    }

    public boolean isStatementInfoRequestSupported() {
        return this.configRsp.isStatementInfoRequestSupported() && this.urlParams.sipSupport();
    }

    @Override
    public boolean supportsPasswordChange() {
        return this.needNewPassword && this.urlParams.getNewPassword() != null && this.urlParams.getNewPassword().length() > 0 && !this.urlParams.isJavaSPDefaultConnection();
    }

    public boolean isJavaSPDefaultConnection() {
        return this.urlParams.isJavaSPDefaultConnection();
    }

    public byte getSPReturnResult() {
        return this.m_spReturnResult;
    }

    public void setSPReturnResult(byte by) {
        this.m_spReturnResult = by;
    }

    public boolean isUDTTransformOffSupported() {
        return this.configRsp.isUDTTransformOffSupported() && this.isStatementInfoSupported();
    }

    public boolean isNumberDataTypeSupported() {
        return this.configRsp.isNumberDataTypeSupported() && this.isStatementInfoSupported();
    }

    public boolean isJsonUsable() {
        return this.configRsp.isJsonSupported() && this.isStatementInfoSupported();
    }

    public boolean isAvroDataSetUsable() {
        return this.configRsp.isAvroDataSetSupported() && this.isStatementInfoSupported();
    }

    public boolean isCSVDataSetUsable() {
        return this.configRsp.isCSVDataSetSupported() && this.isStatementInfoSupported();
    }

    public boolean isSlobReceivable() {
        return this.configRsp.isSlobClientToServerSupported() && this.isStatementInfoSupported() && this.urlParams.getSlobReceiveThreshold() >= 0;
    }

    public boolean isSlobTransmittable() {
        return this.configRsp.isSlobServerToClientSupported() && this.isStatementInfoSupported() && this.urlParams.getSlobTransmitThreshold() > 0;
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        if (this.isClosed() && !"NONE".equalsIgnoreCase(this.urlParams.getLogMech())) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return EscapeUtil.nativeSQL(string, this.getLocalEscapeFunctions());
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return false;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return "";
    }

    public static Map copyAndVerifyTypeMap(Map map) throws SQLException {
        if (map == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ683");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap(map);
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (k instanceof String && v instanceof Class) {
                Class clazz = (Class)v;
                if (!SQLData.class.isAssignableFrom(clazz)) {
                    throw ErrorFactory.makeDriverJDBCException("TJ684", clazz.getName());
                }
                try {
                    clazz.getConstructor(new Class[0]);
                    continue;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ685", clazz.getName());
                    sQLException.initCause(noSuchMethodException);
                    throw sQLException;
                }
            }
            throw ErrorFactory.makeDriverJDBCException("TJ686", k != null ? k.getClass().getName() : null, v != null ? v.getClass().getName() : null);
        }
        return linkedHashMap;
    }

    @Override
    public Map getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return this.m_typeMap.isEmpty() ? Collections.EMPTY_MAP : new LinkedHashMap(this.m_typeMap);
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        this.m_typeMap = TDSession.copyAndVerifyTypeMap(map);
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.m_nHoldabilityForSubsequentStatements = TDSession.validateHoldability(n);
    }

    @Override
    public int getHoldability() throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return this.m_nHoldabilityForSubsequentStatements;
    }

    public static int validateHoldability(int n) throws SQLException {
        if (n == 2 || n == 1) {
            return n;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ493", n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCloseCursorsAtCommitStatements(TDStatement tDStatement) {
        if (tDStatement.getResultSetHoldability() != 2) {
            return;
        }
        List list = this.m_listCloseCursorsAtCommitStatements;
        synchronized (list) {
            Iterator iterator = this.m_listCloseCursorsAtCommitStatements.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                TDStatement tDStatement2 = (TDStatement)weakReference.get();
                if (tDStatement2 != null) continue;
                iterator.remove();
            }
            this.m_listCloseCursorsAtCommitStatements.add(new WeakReference<TDStatement>(tDStatement));
            if (this.log.canLog(0)) {
                this.log.debug("addToCloseCursorsAtCommitStatements: m_listCloseCursorsAtCommitStatements=" + this.m_listCloseCursorsAtCommitStatements);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursorsAtCommitResultSets(TDStatement tDStatement, boolean bl) throws SQLException {
        ArrayList arrayList = new ArrayList();
        List list = this.m_listCloseCursorsAtCommitStatements;
        synchronized (list) {
            for (WeakReference weakReference : this.m_listCloseCursorsAtCommitStatements) {
                TDStatement tDStatement2 = (TDStatement)weakReference.get();
                if (tDStatement2 == null || tDStatement2 == tDStatement) continue;
                arrayList.addAll(tDStatement2.getResults().getAllResultSets());
            }
        }
        for (Object object : arrayList) {
            ((TDResultSet)object).internalClose(false, bl);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setSavepoint");
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "setSavepoint");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "rollback");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "releaseSavepoint");
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        return this.constructStatement(n, n2, n3);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        string = EscapeUtil.nativeSQL(string, true, this.getLocalEscapeFunctions(), linkedHashMap);
        return this.constructPreparedStatement(string, n, n2, n3, null, linkedHashMap);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        string = EscapeUtil.nativeSQL(string, true, this.getLocalEscapeFunctions(), linkedHashMap);
        return this.constructCallableStatement(string, n, n2, n3, linkedHashMap);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.m_nHoldabilityForSubsequentStatements);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.m_nHoldabilityForSubsequentStatements);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n == 2) {
            return this.prepareStatement(string);
        }
        return this.preparedGenKeyStatement(string, new GeneratedKeysRequest(n, this.generatedKeysSupported()));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.preparedGenKeyStatement(string, new GeneratedKeysRequest(nArray, this.generatedKeysSupported()));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.preparedGenKeyStatement(string, new GeneratedKeysRequest(stringArray, this.generatedKeysSupported()));
    }

    private PreparedStatement preparedGenKeyStatement(String string, GeneratedKeysRequest generatedKeysRequest) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (string == null || string.trim().length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", string == null ? "null" : string);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        string = EscapeUtil.nativeSQL(string, true, this.getLocalEscapeFunctions(), linkedHashMap);
        return this.constructPreparedStatement(string, 1003, 1007, this.m_nHoldabilityForSubsequentStatements, generatedKeysRequest, linkedHashMap);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (!this.isUDTTransformOffSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ636");
        }
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ644");
        }
        if (objectArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ637");
        }
        return new ClientStruct(string, objectArray);
    }

    @Override
    public Clob createClob() throws SQLException {
        return new ClientClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new ClientBlob();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ603", n);
        }
        if (this.isClosed()) {
            return false;
        }
        try {
            this.executeSessionRequest("isValid", false, "--isValid", true, n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return !this.isClosed();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return this.getClientInfo().getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        try (TDResultSet tDResultSet = this.executeSessionRequest("getClientInfo", true, "HELP SESSION", true);){
            if (tDResultSet.next()) {
                String[] stringArray = Utility.getQueryBandStringsFromHelpSessionResultSet(tDResultSet);
                Utility.tokenizeQueryBand(properties, stringArray[2]);
                Utility.tokenizeQueryBand(properties, stringArray[1]);
                Utility.tokenizeQueryBand(properties, stringArray[0]);
            }
        }
        return properties;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return new ClientArray(this, string, objectArray);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new TeraDatabaseMetaData(this);
    }

    public TeraResultSetMetaData constructResultSetMetaData() throws SQLException {
        return new TeraResultSetMetaData(this);
    }

    public TDResultSet constructResultSet(TeraResultSetMetaData teraResultSetMetaData, int n, Statement statement, RowFetchController rowFetchController, Log log) throws SQLException {
        return new TDResultSet(teraResultSetMetaData, n, this, statement, rowFetchController, log);
    }

    @Override
    public SQLInput constructSQLInput(Object[] objectArray, int[] nArray, int[] nArray2, String[] stringArray, Map map, Class clazz) {
        return new TeraSQLInput(this, objectArray, nArray, nArray2, stringArray, map, clazz);
    }

    public TeraSQLOutput constructSQLOutput(TDPreparedStatement tDPreparedStatement, FullContentMetadataItem[] fullContentMetadataItemArray, int n, Class clazz) {
        return new TeraSQLOutput(tDPreparedStatement, fullContentMetadataItemArray, n, clazz);
    }

    public ParameterMetaData constructParameterMetaData(TDPreparedStatement tDPreparedStatement) throws SQLException {
        return new TeraParameterMetaData(tDPreparedStatement);
    }

    protected TDStatement constructStatement(int n, int n2, int n3) throws SQLException {
        return new TDStatement(this, n, n2, n3);
    }

    protected PreparedStatement constructPreparedStatement(String string, int n, int n2, int n3, GeneratedKeysRequest generatedKeysRequest, Map map) throws SQLException {
        return new TDPreparedStatement(this, string, n, n2, n3, generatedKeysRequest, map);
    }

    protected CallableStatement constructCallableStatement(String string, int n, int n2, int n3, Map map) throws SQLException {
        return new TDCallableStatement(this, string, n, n2, n3, map);
    }

    @Override
    public Blob constructLocatorBlob(long l, byte[] byArray, boolean bl) {
        return new LocatorBlob(this, l, byArray, bl);
    }

    @Override
    public Clob constructLocatorClob(long l, byte[] byArray, boolean bl) {
        return new LocatorClob(this, l, byArray, bl);
    }

    @Override
    public TeraSQLXML constructLocatorSQLXML(short s, long l, byte[] byArray) {
        return new TeraSQLXML(this, s, l, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQueryBand(Properties properties, String string) throws SQLClientInfoException {
        block11: {
            String string2;
            if (!this.trustedSessionsSupport()) {
                throw ErrorFactory.makeSQLClientInfoException(null, "TJ1598", properties);
            }
            properties = properties == null ? new Properties() : properties;
            StringJoiner stringJoiner = new StringJoiner(";");
            for (Map.Entry<Object, Object> object2 : properties.entrySet()) {
                string2 = (String)object2.getKey();
                String string3 = (String)object2.getValue();
                if (string2.contains(";") || string2.contains("=")) {
                    throw ErrorFactory.makeSQLClientInfoException(null, "TJ1599", properties);
                }
                if (string3.contains(";")) {
                    throw ErrorFactory.makeSQLClientInfoException(null, "TJ1600", properties);
                }
                stringJoiner.add(string2 + "=" + string3);
            }
            try {
                Object object;
                if (!this.bAutoCommit) {
                    if (properties.size() == 0) {
                        object = "SET QUERY_BAND=NONE FOR TRANSACTION";
                        this.executeSessionRequest("TDSession setClientInfo", false, (String)object, true);
                        break block11;
                    }
                    object = "{fn TERADATA_NOPREPARE}SET QUERY_BAND=? " + string + " FOR TRANSACTION";
                    try (TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)this.prepareStatement((String)object);){
                        tDPreparedStatement.setString(1, stringJoiner.toString() + ";");
                        tDPreparedStatement.executeUpdate();
                        break block11;
                    }
                }
                object = properties.size() > 0 ? "'" + stringJoiner.toString() + ";' " : " NONE ";
                String string4 = this.isAnsiMode() && this.bAutoCommit ? "; COMMIT WORK" : "";
                string2 = "SET QUERY_BAND=" + (String)object + string + "FOR SESSION" + string4;
                this.executeSessionRequest("TDSession setClientInfo", false, string2, true);
            }
            catch (SQLException sQLException) {
                throw ErrorFactory.makeSQLClientInfoException(sQLException, null, properties);
            }
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (string == null) {
            throw ErrorFactory.makeSQLClientInfoException(null, "TJ1597", null);
        }
        Properties properties = new Properties();
        if (string2 == null) {
            try {
                properties = this.getClientInfo();
            }
            catch (SQLException sQLException) {
                properties.clear();
                properties.setProperty(string, "");
                throw ErrorFactory.makeSQLClientInfoException(sQLException, null, properties);
            }
            for (String string3 : properties.stringPropertyNames()) {
                if (!string3.equalsIgnoreCase(string)) continue;
                properties.remove(string);
                this.setQueryBand(properties, "");
                break;
            }
        } else {
            properties.setProperty(string, string2);
            this.setQueryBand(properties, " UPDATE ");
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.setQueryBand(properties, "");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "createNClob");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        if (!this.isXMLDataTypeSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ215", "createSQLXML");
        }
        return new TeraSQLXML(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

