/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.HttpServer;
import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;

public class BrowserAuth {
    private static final String PLACEHOLDER = "PLACEHOLDER";

    public static void browserAuth(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        String string3;
        String string4;
        Object object;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1539");
        }
        if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1540");
        }
        String string5 = uRLParameters.getBrowser();
        if (string5 == null || string5.length() == 0) {
            object = System.getProperty("os.name");
            String string6 = string4 = object != null ? ((String)object).toUpperCase() : "";
            if (string4.indexOf("WIN") >= 0) {
                string5 = "cmd /c start \"title\" \"PLACEHOLDER\"";
            } else if (string4.indexOf("MAC") >= 0) {
                string5 = "open PLACEHOLDER";
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ1541", (String)object);
            }
        }
        if (((GenericTeradataConnection)(object = ConnectionFactory.makeLogMechNoneConnection(genericTeradataConnection))).getGtwConfig() == null || ((GenericTeradataConnection)object).getGtwConfig().getIdentityProviderURL() == null || ((GenericTeradataConnection)object).getGtwConfig().getIdentityProviderClientID() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1542");
        }
        string4 = Utility.coalesce(uRLParameters.getOIDCMetadata(), ((GenericTeradataConnection)object).getGtwConfig().getIdentityProviderURL());
        String string7 = uRLParameters.getOIDCClientID();
        if (string7 == null) {
            string7 = ((GenericTeradataConnection)object).getGtwConfig().getIdentityProviderClientID();
        }
        if ((string3 = uRLParameters.getOIDCScope()) == null) {
            string3 = ((GenericTeradataConnection)object).getGtwConfig().getOIDCScope();
        }
        if (string3 == null) {
            string3 = "openid";
        }
        if (log.isDebugEnabled()) {
            log.debug("sIdProURL=" + string4);
            log.debug("sClientID=" + string7);
            log.debug("urlParams.getOIDCScope=" + uRLParameters.getOIDCScope() + " con.getGtwConfig ().getOIDCScope=" + ((GenericTeradataConnection)object).getGtwConfig().getOIDCScope() + " --> sOIDCScope=" + string3);
        }
        if ((string4 = string4.replaceFirst("/+$", "")).length() == 0 || string7.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1550");
        }
        String string8 = "/.well-known/openid-configuration";
        if (!string4.toLowerCase().endsWith(string8)) {
            string4 = string4 + string8;
            if (log.isDebugEnabled()) {
                log.debug("Modified sIdProURL=" + string4);
            }
        }
        for (String string9 : Utility.joinStrings(string3, "|", uRLParameters.getOAuthScopes()).split("\\|")) {
            BrowserAuth.doBrowserAuth(genericTeradataConnection, string, string2, string5, string4, string7, string9);
        }
    }

    private static void doBrowserAuth(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        String string7;
        HttpServer httpServer;
        String string8;
        String string9;
        String string10;
        TokenCache.CacheContext cacheContext;
        Log log;
        URLParameters uRLParameters;
        block10: {
            Process process;
            boolean bl;
            uRLParameters = genericTeradataConnection.getURLParameters();
            log = genericTeradataConnection.getLog();
            cacheContext = TokenCache.getCacheEntry(genericTeradataConnection, string, string2, string4, string5, string6);
            if (cacheContext == null) {
                return;
            }
            Utility.HttpResponse httpResponse = Utility.doHttpRequest(uRLParameters, log, "GET", string4, null, null, true, new int[]{200});
            genericTeradataConnection.m_extraClientAttributes.sIdpProxyUsed = httpResponse.sProxyUsed;
            genericTeradataConnection.m_extraClientAttributes.sIdpProtocol = httpResponse.sProtocol;
            genericTeradataConnection.m_extraClientAttributes.sIdpCipher = httpResponse.sCipher;
            genericTeradataConnection.m_extraClientAttributes.sIdpCertStatus = httpResponse.sCertStatus;
            string10 = httpResponse.sBody;
            String string11 = Utility.getStringFromJSON("authorization_endpoint", string10, "TJ1544", string4);
            string9 = Utility.getStringFromJSON("token_endpoint", string10, "TJ1544", string4);
            string8 = Utility.base64Encode(true, Utility.getRandomBytes(32));
            String string12 = Utility.base64Encode(true, Utility.hashBytes(log, "SHA-256", Encoder.encodeStringAsciiReplace(genericTeradataConnection, string8)));
            String string13 = "/openid-callback";
            int n = uRLParameters.getBrowserTimeout() * 1000;
            int n2 = uRLParameters.getBrowserTabTimeout() * 1000;
            if (log.isTimingEnabled()) {
                log.timing("Starting HttpServer with Browser Authentication timeout " + n + " ms and browser tab timeout " + n2 + " ms");
            }
            httpServer = new HttpServer(log, string13 + "?", n, n2);
            string7 = "http://127.0.0.1:" + httpServer.getLocalPort() + string13;
            boolean bl2 = string != null && string.length() > 0;
            boolean bl3 = bl = bl2 && uRLParameters.getOIDCPrompt() != null;
            if (log.isDebugEnabled()) {
                log.debug("sJSON=" + string10);
                log.debug("sAuthURL=" + string11);
                log.debug("sTokenURL=" + string9);
                log.debug("sCodeVerifier=" + string8);
                log.debug("sCodeChallenge=" + string12);
                log.debug("sRedirectURL=" + string7);
                log.debug("sUserName=" + string + " bUseLoginHint=" + bl2);
                log.debug("getOIDCPrompt=" + uRLParameters.getOIDCPrompt() + " bUsePrompt=" + bl);
                log.debug("(before PLACEHOLDER swap) sBrowser=" + string3);
            }
            string3 = string3.replaceAll(PLACEHOLDER, string11 + "?response_type=code" + "&client_id=" + Utility.safeForURL(string5) + "&redirect_uri=" + Utility.safeForURL(string7) + "&code_challenge=" + Utility.safeForURL(string12) + "&code_challenge_method=S256" + "&scope=" + Utility.safeForURL(string6) + (bl2 ? "&login_hint=" + Utility.safeForURL(string) : "") + (bl ? "&prompt=" + Utility.safeForURL(uRLParameters.getOIDCPrompt()) : ""));
            if (log.isTimingEnabled()) {
                log.timing("Launching browser " + string3);
            }
            try {
                process = Runtime.getRuntime().exec(string3);
            }
            catch (IOException iOException) {
                throw Utility.logEx(log, "Runtime exec", Utility.wrapEx(iOException, ErrorFactory.makeDriverJDBCException("TJ1551", string3)));
            }
            try {
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block10;
                log.debug("Ignoring Process stream close exception: " + iOException);
            }
        }
        Map<String, String> map = httpServer.waitForRequestParams(log);
        String string14 = map.get("code");
        if (string14 == null || string14.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1548");
        }
        String string15 = "grant_type=authorization_code&client_id=" + Utility.safeForURL(string5) + "&code=" + Utility.safeForURL(string14) + "&redirect_uri=" + Utility.safeForURL(string7) + "&code_verifier=" + Utility.safeForURL(string8);
        if (log.isDebugEnabled()) {
            log.debug("sClientID=" + string5);
            log.debug("sCode=" + string14);
            log.debug("sRedirectURL=" + string7);
            log.debug("sCodeVerifier=" + string8);
            log.debug("sFormData=" + string15);
        }
        byte[] byArray = Encoder.encodeStringUTF8(string15);
        string10 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string9, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
        TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string4, string5, string6, string9, string10, cacheContext);
    }
}

