/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc.TokenCache;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;

public class DeviceCodeFlow {
    public static void deviceCodeFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        String string3;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1573", uRLParameters.getLogMech());
        }
        if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "LOGDATA", uRLParameters.getLogMech());
        }
        GenericTeradataConnection genericTeradataConnection2 = ConnectionFactory.makeLogMechNoneConnection(genericTeradataConnection);
        if (genericTeradataConnection2.getGtwConfig() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderURL() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderClientID() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string4 = Utility.coalesce(uRLParameters.getOIDCMetadata(), genericTeradataConnection2.getGtwConfig().getIdentityProviderURL());
        String string5 = uRLParameters.getOIDCClientID();
        if (string5 == null) {
            string5 = genericTeradataConnection2.getGtwConfig().getIdentityProviderClientID();
        }
        if ((string3 = uRLParameters.getOIDCScope()) == null) {
            string3 = genericTeradataConnection2.getGtwConfig().getOIDCScope();
        }
        if (string3 == null) {
            string3 = "openid";
        }
        if (log.isDebugEnabled()) {
            log.debug("sIdProURL=" + string4);
            log.debug("sClientID=" + string5);
            log.debug("sOIDCScope=" + string3);
        }
        if ((string4 = string4.replaceFirst("/+$", "")).length() == 0 || string5.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string6 = "/.well-known/openid-configuration";
        if (!string4.toLowerCase().endsWith(string6)) {
            string4 = string4 + string6;
            if (log.isDebugEnabled()) {
                log.debug("Modified sIdProURL=" + string4);
            }
        }
        for (String string7 : Utility.joinStrings(string3, "|", uRLParameters.getOAuthScopes()).split("\\|")) {
            DeviceCodeFlow.doDeviceCodeFlow(genericTeradataConnection, string, string2, string4, string5, string7);
        }
    }

    private static void doDeviceCodeFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6;
        String string7;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        TokenCache.CacheContext cacheContext = TokenCache.getCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5);
        if (cacheContext == null) {
            return;
        }
        Utility.HttpResponse httpResponse = Utility.doHttpRequest(uRLParameters, log, "GET", string3, null, null, true, new int[]{200});
        genericTeradataConnection.m_extraClientAttributes.sIdpProxyUsed = httpResponse.sProxyUsed;
        genericTeradataConnection.m_extraClientAttributes.sIdpProtocol = httpResponse.sProtocol;
        genericTeradataConnection.m_extraClientAttributes.sIdpCipher = httpResponse.sCipher;
        genericTeradataConnection.m_extraClientAttributes.sIdpCertStatus = httpResponse.sCertStatus;
        String string8 = httpResponse.sBody;
        String string9 = Utility.getStringFromJSON("device_authorization_endpoint", string8, "TJ1544", string3);
        String string10 = Utility.getStringFromJSON("token_endpoint", string8, "TJ1544", string3);
        String string11 = "client_id=" + Utility.safeForURL(string4) + "&scope=" + Utility.safeForURL(string5);
        if (log.isDebugEnabled()) {
            log.debug("sJSON=" + string8);
            log.debug("sAuthURL=" + string9);
            log.debug("sTokenURL=" + string10);
            log.debug("sFormData=" + string11);
        }
        byte[] byArray = Encoder.encodeStringUTF8(string11);
        string8 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string9, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
        int n = Utility.getIntFromJSON("interval", string8, null, null, 5) * 1000;
        int n2 = Utility.getIntFromJSON("expires_in", string8, "TJ1575", string9, 0) * 1000;
        String string12 = Utility.getStringFromJSON("device_code", string8, "TJ1552", string9);
        String string13 = Utility.getStringFromJSON("user_code", string8, "TJ1552", string9);
        String string14 = Utility.getStringFromJSON("verification_uri", string8, "TJ1552", string9);
        String string15 = Utility.getStringFromJSON("verification_uri_complete", string8, null, null);
        String string16 = string15 != null ? string15 : string14 + "?user_code=" + Utility.safeForURL(string13);
        string11 = "grant_type=urn:ietf:params:oauth:grant-type:device_code&client_id=" + Utility.safeForURL(string4) + "&device_code=" + Utility.safeForURL(string12);
        String string17 = uRLParameters.getOIDCToken();
        if (log.isDebugEnabled()) {
            log.debug("sJSON=" + string8);
            log.debug("nIntervalInMs=" + n);
            log.debug("nExpiresInMs=" + n2);
            log.debug("sDeviceCode=" + string12);
            log.debug("sUserCode=" + string13);
            log.debug("sVerificationURL=" + string14);
            log.debug("sCompleteURL=" + string15);
            log.debug("sDisplayURL=" + string16);
            log.debug("sFormData=" + string11);
            log.debug("sOIDCToken=" + string17);
        }
        DeviceCodeFlow.displayCodeToUser(uRLParameters, string16, string13);
        byArray = Encoder.encodeStringUTF8(string11);
        while (true) {
            Utility.threadSleep(log, n);
            httpResponse = Utility.doHttpRequest(uRLParameters, log, "POST", string10, new String[]{"Content-Type: application/x-www-form-urlencoded"}, byArray, true, null);
            string8 = httpResponse.sBody;
            if (log.isDebugEnabled()) {
                log.debug("resp.nCode=" + httpResponse.nCode + " resp.sMessage=" + httpResponse.sMessage);
                log.debug("sJSON=" + string8);
            }
            if (httpResponse.nCode == 200) {
                TokenCache.putCacheEntry(genericTeradataConnection, string, string2, string3, string4, string5, string10, string8, cacheContext);
                return;
            }
            string7 = Utility.getStringFromJSON("error", string8, null, null);
            string6 = Utility.getStringFromJSON("error_description", string8, null, null);
            if (log.isDebugEnabled()) {
                log.debug("sError=" + string7);
                log.debug("sErrorDesc=" + string6);
            }
            if (httpResponse.nCode == 400 && "authorization_pending".equals(string7)) continue;
            if (httpResponse.nCode != 400 || !"slow_down".equals(string7)) break;
            n += 5000;
        }
        String string18 = httpResponse.nCode + (string6 != null ? " " + string6 : (string7 != null ? " " + string7 : (httpResponse.sMessage != null ? " " + httpResponse.sMessage : "")));
        throw ErrorFactory.makeDriverJDBCException("TJ1549", string18, string10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void displayCodeToUser(URLParameters uRLParameters, String string, String string2) throws SQLException {
        try (PrintStream printStream = null;){
            PrintStream printStream2;
            if (uRLParameters.getCodeAppendFile() == null || "-out".equalsIgnoreCase(uRLParameters.getCodeAppendFile())) {
                printStream2 = System.out;
            } else if ("-err".equalsIgnoreCase(uRLParameters.getCodeAppendFile())) {
                printStream2 = System.err;
            } else {
                try {
                    printStream2 = printStream = new PrintStream(new FileOutputStream(uRLParameters.getCodeAppendFile(), true), true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ1578", uRLParameters.getCodeAppendFile(), "CODE_APPEND_FILE");
                    sQLException.initCause(fileNotFoundException);
                    throw sQLException;
                }
            }
            String string3 = Log.currentDateTime();
            printStream2.println(string3);
            printStream2.println(string3 + " -----------------------------------------------------------------------------------------");
            printStream2.println(string3);
            printStream2.println(string3 + " " + ErrorMessage.messages.getString("TJ1576"));
            printStream2.println(string3);
            printStream2.println(string3 + "   " + string);
            printStream2.println(string3);
            printStream2.println(string3 + " " + ErrorMessage.messages.getString("TJ1577"));
            printStream2.println(string3);
            printStream2.println(string3 + "   " + string2);
            printStream2.println(string3);
            printStream2.println(string3 + " -----------------------------------------------------------------------------------------");
            printStream2.println(string3);
        }
    }
}

