/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class TokenCache {
    private static Map<String, CacheEntry> sm_cache = new LinkedHashMap<String, CacheEntry>();

    private static CacheEntry newCacheEntry(String string, CacheContext cacheContext) {
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.sEndpointURL = string;
        cacheEntry.sRefreshToken = cacheContext.sRefreshToken;
        cacheEntry.sJWT = cacheContext.sJWT;
        cacheEntry.nExpirationTime = cacheContext.nExpirationTime;
        cacheEntry.sClaimValue = cacheContext.sClaimValue;
        cacheEntry.sUserDesc = cacheContext.sUserDesc;
        cacheEntry.nReuseCount = 0;
        cacheEntry.nLastAccessTime = System.currentTimeMillis();
        return cacheEntry;
    }

    private static CacheEntry copyCacheEntry(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return null;
        }
        ++cacheEntry.nReuseCount;
        cacheEntry.nLastAccessTime = System.currentTimeMillis();
        return cacheEntry.clone();
    }

    private static String composeCacheKey(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        string7 = Utility.coalesce(string7, "").toLowerCase();
        string8 = Utility.coalesce(string8, "");
        string9 = Utility.coalesce(string9, "");
        return Utility.safeForURL(string) + "&" + Utility.safeForURL(string2) + "&" + Utility.safeForURL(string3) + "&" + Utility.safeForURL(string4) + "&" + Utility.safeForURL(string5) + "&" + Utility.safeForURL(string6) + "&" + Utility.safeForURL(string7) + "&" + Utility.safeForURL(string8) + "&" + Utility.safeForURL(string9);
    }

    private static void parseIdPResponse(GenericTeradataConnection genericTeradataConnection, String string, String string2, CacheContext cacheContext) throws SQLException {
        String[] stringArray;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        String string3 = uRLParameters.getLogMech();
        String string4 = uRLParameters.getOIDCToken();
        String string5 = uRLParameters.getOIDCClaim();
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sLogMech=" + string3);
            log.debug("parseIdPResponse: sOIDCToken=" + string4);
            log.debug("parseIdPResponse: sOIDCClaim=" + string5);
            log.debug("parseIdPResponse: sEndpointURL=" + string);
            log.debug("parseIdPResponse: sIdPResponse=" + string2);
        }
        cacheContext.sRefreshToken = Utility.getStringFromJSON("refresh_token", string2, null, null);
        cacheContext.sJWT = Utility.getStringFromJSON(string4, string2, "TJ1552", string);
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sJWT=" + cacheContext.sJWT);
        }
        if ((stringArray = Utility.getJWTHeaderAndPayload(cacheContext.sJWT, log, "parseIdPResponse")) == null) {
            throw Utility.logEx(log, "parseIdPResponse", ErrorFactory.makeDriverJDBCException("TJ1552", string4, string));
        }
        String string6 = stringArray[1];
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sJWTPayload=" + string6);
        }
        cacheContext.nExpirationTime = Utility.getLongFromJSON("exp", string6, null, null, 0L);
        cacheContext.sClaimValue = Utility.getStringFromJSON(string5, string6, null, null);
        cacheContext.sUserDesc = string4 + " " + string5 + " " + Utility.coalesce(cacheContext.sClaimValue, "unavailable");
        if (log.isDebugEnabled()) {
            log.debug("parseIdPResponse: sCacheStatus=" + cacheContext.sCacheStatus);
            log.debug("parseIdPResponse: sRefreshToken=" + cacheContext.sRefreshToken);
            log.debug("parseIdPResponse: sJWT=" + cacheContext.sJWT);
            log.debug("parseIdPResponse: nExpirationTime=" + cacheContext.nExpirationTime);
            log.debug("parseIdPResponse: sClaimValue=" + cacheContext.sClaimValue);
            log.debug("parseIdPResponse: sUserDesc=" + cacheContext.sUserDesc);
            log.debug("parseIdPResponse: nReuseCount=" + cacheContext.nReuseCount);
        }
    }

    private static void completeOIDCFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, CacheContext cacheContext) {
        boolean bl;
        int n;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        ClientAttributesParcel.Extra extra = genericTeradataConnection.m_extraClientAttributes;
        Log log = genericTeradataConnection.getLog();
        String string5 = uRLParameters.getLogMech();
        String string6 = cacheContext.sCacheStatus != null ? "" + cacheContext.nReuseCount : null;
        String string7 = cacheContext.sRefreshToken != null ? "Y" : "N";
        String string8 = "" + cacheContext.tokenTTLSecs();
        boolean bl2 = "JWT".equals(string5);
        if (bl2) {
            extra.sOAuthReuseCounts = Utility.joinStrings(extra.sOAuthReuseCounts, ",", string6);
            extra.sOAuthRefreshAvail = Utility.joinStrings(extra.sOAuthRefreshAvail, "", string7);
            extra.sOAuthScopes = Utility.joinStrings(extra.sOAuthScopes, "|", string4);
        }
        boolean bl3 = ((n = uRLParameters.getOAuthLevel()) & 1) != 0;
        boolean bl4 = (n & 2) != 0;
        boolean bl5 = bl = bl2 && bl4 || !bl2 && bl3;
        if (bl) {
            genericTeradataConnection.m_listOAuthScopeTokenPairs.add(new String[]{string4, cacheContext.sJWT});
        }
        if (log.isDebugEnabled()) {
            log.debug("completeOIDCFlow: sLogMech=" + string5);
            log.debug("completeOIDCFlow: bOAuthFlow=" + bl2);
            log.debug("completeOIDCFlow: sOAuthReuseCounts=" + extra.sOAuthReuseCounts);
            log.debug("completeOIDCFlow: sOAuthRefreshAvail=" + extra.sOAuthRefreshAvail);
            log.debug("completeOIDCFlow: sOAuthScopes=" + extra.sOAuthScopes);
            log.debug("completeOIDCFlow: nOAuthLevel=" + n);
            log.debug("completeOIDCFlow: bSendOIDCToken=" + bl3);
            log.debug("completeOIDCFlow: bSendOAuthToken=" + bl4);
            log.debug("completeOIDCFlow: bAddToken=" + bl);
            log.debug("completeOIDCFlow: TokenPairs.size=" + genericTeradataConnection.m_listOAuthScopeTokenPairs.size());
            log.debug("completeOIDCFlow: sIdProURL=" + string2);
            log.debug("completeOIDCFlow: sClientID=" + string3);
            log.debug("completeOIDCFlow: sOIDCScope=" + string4);
            log.debug("completeOIDCFlow: sUserName=" + string);
            log.debug("completeOIDCFlow: sUserDesc=" + cacheContext.sUserDesc);
            log.debug("completeOIDCFlow: sCacheStatus=" + cacheContext.sCacheStatus);
            log.debug("completeOIDCFlow: sReuseCount=" + string6);
            log.debug("completeOIDCFlow: sRefreshTokenAvail=" + string7);
            log.debug("completeOIDCFlow: sTokenTTLSecs=" + string8);
            log.debug("completeOIDCFlow: sJWT=" + cacheContext.sJWT);
        }
        if (bl2) {
            return;
        }
        extra.sOIDCMetadataURL = string2;
        extra.sOIDCClientID = string3;
        extra.sLogonOIDCScope = string4;
        extra.sOIDCLoginHint = string;
        extra.sOIDCTokenKind = cacheContext.sUserDesc;
        extra.sTokenCacheStatus = cacheContext.sCacheStatus;
        extra.sTokenReuseCount = string6;
        extra.sRefreshTokenAvail = string7;
        extra.sTokenTTLSecs = string8;
        uRLParameters.changeLogMech("JWT", "token=" + cacheContext.sJWT);
        if (cacheContext.sCacheStatus != null) {
            genericTeradataConnection.setNoTransmitCredentials();
        }
    }

    public static void completeUncachedOIDCFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        CacheContext cacheContext = new CacheContext();
        TokenCache.parseIdPResponse(genericTeradataConnection, string5, string6, cacheContext);
        TokenCache.completeOIDCFlow(genericTeradataConnection, string, string2, string3, string4, cacheContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheContext getCacheEntry(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        String string6;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        String string7 = uRLParameters.getLogMech();
        String string8 = uRLParameters.getLogData();
        int n = uRLParameters.getOIDCCacheSize();
        String string9 = uRLParameters.getOIDCToken();
        String string10 = uRLParameters.getOIDCClaim();
        if (log.isDebugEnabled()) {
            log.debug("getCacheEntry: nOIDCCacheSize=" + n + " sm_cache.size=" + sm_cache.size());
            log.debug("getCacheEntry: sLogMech=" + string7);
            log.debug("getCacheEntry: sIdProURL=" + string3);
            log.debug("getCacheEntry: sClientID=" + string4);
            log.debug("getCacheEntry: sOIDCScope=" + string5);
            log.debug("getCacheEntry: sOIDCToken=" + string9);
            log.debug("getCacheEntry: sOIDCClaim=" + string10);
            log.debug("getCacheEntry: sUserName=" + string);
            log.debug("getCacheEntry: sPassword=" + string2);
            log.debug("getCacheEntry: sLogData=" + string8);
        }
        CacheContext cacheContext = new CacheContext();
        if (n == 0) {
            cacheContext.sCacheStatus = "O";
        } else {
            Object object;
            string6 = TokenCache.composeCacheKey(string7, string3, string4, string5, string9, string10, string, string2, string8);
            if (log.isDebugEnabled()) {
                log.debug("getCacheEntry: sKey=" + string6);
            }
            Map<String, CacheEntry> map = sm_cache;
            synchronized (map) {
                object = TokenCache.copyCacheEntry(sm_cache.get(string6));
            }
            if (object == null) {
                cacheContext.sCacheStatus = "M";
            } else {
                boolean bl;
                long l = System.currentTimeMillis() / 1000L;
                boolean bl2 = bl = l > ((CacheEntry)object).nExpirationTime;
                if (log.isDebugEnabled()) {
                    log.debug("getCacheEntry: nCurrentUnixTime=" + l + " " + (bl ? "after" : "before") + " entry.nExpirationTime=" + ((CacheEntry)object).nExpirationTime + " --> bExpired=" + bl);
                }
                if (bl) {
                    cacheContext.sCacheStatus = "X";
                    cacheContext.sRefreshToken = ((CacheEntry)object).sRefreshToken;
                    cacheContext.nReuseCount = ((CacheEntry)object).nReuseCount;
                } else {
                    cacheContext.sCacheStatus = "H";
                    cacheContext.sRefreshToken = ((CacheEntry)object).sRefreshToken;
                    cacheContext.sJWT = ((CacheEntry)object).sJWT;
                    cacheContext.nExpirationTime = ((CacheEntry)object).nExpirationTime;
                    cacheContext.sClaimValue = ((CacheEntry)object).sClaimValue;
                    cacheContext.sUserDesc = ((CacheEntry)object).sUserDesc;
                    cacheContext.nReuseCount = ((CacheEntry)object).nReuseCount;
                }
            }
        }
        if (log.isInfoEnabled()) {
            string6 = string != null && string.length() > 0 ? "username " + string : "default user";
            switch (cacheContext.sCacheStatus) {
                case "O": {
                    log.info("OIDC token cache turned off");
                    break;
                }
                case "M": {
                    log.info("OIDC token cache miss for " + string6);
                    break;
                }
                case "X": {
                    log.info("OIDC token cache hit expired " + string9 + " reused " + cacheContext.nReuseCount + " time(s) for " + string6);
                    break;
                }
                case "H": {
                    log.info("OIDC token cache hit valid " + string9 + " reused " + cacheContext.nReuseCount + " time(s) for " + string6);
                }
            }
        }
        if (cacheContext.sJWT != null) {
            TokenCache.completeOIDCFlow(genericTeradataConnection, string, string3, string4, string5, cacheContext);
            return null;
        }
        return cacheContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putCacheEntry(GenericTeradataConnection genericTeradataConnection, String string, String string2, String string3, String string4, String string5, String string6, String string7, CacheContext cacheContext) throws SQLException {
        String string8;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        String string9 = uRLParameters.getLogMech();
        String string10 = uRLParameters.getLogData();
        int n = uRLParameters.getOIDCCacheSize();
        String string11 = uRLParameters.getOIDCToken();
        String string12 = uRLParameters.getOIDCClaim();
        if (log.isDebugEnabled()) {
            log.debug("putCacheEntry: nOIDCCacheSize=" + n + " sm_cache.size=" + sm_cache.size());
            log.debug("putCacheEntry: sEndpointURL=" + string6);
            log.debug("putCacheEntry: sIdPResponse=" + string7);
            log.debug("putCacheEntry: sLogMech=" + string9);
            log.debug("putCacheEntry: sIdProURL=" + string3);
            log.debug("putCacheEntry: sClientID=" + string4);
            log.debug("putCacheEntry: sOIDCScope=" + string5);
            log.debug("putCacheEntry: sOIDCToken=" + string11);
            log.debug("putCacheEntry: sOIDCClaim=" + string12);
            log.debug("putCacheEntry: sUserName=" + string);
            log.debug("putCacheEntry: sPassword=" + string2);
            log.debug("putCacheEntry: sLogData=" + string10);
        }
        TokenCache.parseIdPResponse(genericTeradataConnection, string6, string7, cacheContext);
        String string13 = string8 = string != null && string.length() > 0 ? cacheContext.sClaimValue : null;
        if (log.isDebugEnabled()) {
            log.debug("putCacheEntry: sKeyClaimValue=" + string8);
        }
        if (n > 0) {
            if (string != null && string.length() > 0 && string8 == null) {
                throw Utility.logEx(log, "putCacheEntry", ErrorFactory.makeDriverJDBCException("TJ1552", string12, string6));
            }
            String string14 = TokenCache.composeCacheKey(string9, string3, string4, string5, string11, string12, string8, string2, string10);
            if (log.isDebugEnabled()) {
                log.debug("putCacheEntry: sKey=" + string14);
            }
            CacheEntry cacheEntry = TokenCache.newCacheEntry(string6, cacheContext);
            ArrayList<String> arrayList = new ArrayList<String>();
            Map<String, CacheEntry> map = sm_cache;
            synchronized (map) {
                sm_cache.put(string14, cacheEntry);
                while (sm_cache.size() > n) {
                    Map.Entry[] entryArray = sm_cache.entrySet().toArray(new Map.Entry[0]);
                    int n2 = 0;
                    for (int i = 1; i < entryArray.length; ++i) {
                        if (((CacheEntry)entryArray[i].getValue()).nLastAccessTime >= ((CacheEntry)entryArray[n2].getValue()).nLastAccessTime) continue;
                        n2 = i;
                    }
                    String string15 = (String)entryArray[n2].getKey();
                    sm_cache.remove(string15);
                    arrayList.add(string15);
                }
            }
            if (log.isDebugEnabled()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    log.debug("putCacheEntry: removed key " + (i + 1) + " of " + arrayList.size() + ": " + (String)arrayList.get(i));
                }
                log.debug("putCacheEntry: after put: nOIDCCacheSize=" + n + " sm_cache.size=" + sm_cache.size());
            }
        }
        TokenCache.completeOIDCFlow(genericTeradataConnection, string, string3, string4, string5, cacheContext);
    }

    public static class CacheContext {
        String sCacheStatus;
        String sRefreshToken;
        String sJWT;
        long nExpirationTime;
        String sClaimValue;
        String sUserDesc;
        int nReuseCount;

        long tokenTTLSecs() {
            return this.nExpirationTime - System.currentTimeMillis() / 1000L;
        }
    }

    private static class CacheEntry
    implements Cloneable {
        String sEndpointURL;
        String sRefreshToken;
        String sJWT;
        long nExpirationTime;
        String sClaimValue;
        String sUserDesc;
        int nReuseCount;
        long nLastAccessTime;

        private CacheEntry() {
        }

        public CacheEntry clone() {
            try {
                return (CacheEntry)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

