/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.console;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc.console.ConsoleConnection;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.parcel.DataParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PromptParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.RequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class ConsoleStatement
implements Statement,
RowFetchController {
    private ConsoleConnection con = null;
    private Results results = null;
    private String sqlStmt = null;
    private int m_nQueryTimeoutInSeconds = 0;

    public ConsoleStatement(ConsoleConnection consoleConnection) throws SQLException {
        this.con = consoleConnection;
        this.results = new Results(consoleConnection.getLog());
    }

    protected void abortIfClosed() throws SQLException {
        if (this.con.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ408");
        }
        if (this.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ409");
        }
    }

    private static SQLException chainSQLExceptions(SQLException sQLException, SQLException sQLException2) {
        return Utility.chainSQLExceptions(sQLException, sQLException2);
    }

    private void initReqPacket(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.con.getSessionNum());
        tDPacket.setAuthentication(this.con.getAuthenticationNonce());
        tDPacket.setLANKind(by);
        tDPacket.setRequestNumber(n);
    }

    private void initReq(TDPacket tDPacket, String string) throws SQLException {
        RequestParcel requestParcel = new RequestParcel(this.con);
        requestParcel.setRequestText(string);
        tDPacket.addParcel(requestParcel);
    }

    private void initData(TDPacket tDPacket, String string) throws SQLException {
        DataParcel dataParcel = new DataParcel(this.con, Encoder.encodeRequestText(this.con, string), true);
        tDPacket.addParcel(dataParcel);
    }

    private void initResp(TDPacket tDPacket) throws SQLException {
        ResponseParcel responseParcel = new ResponseParcel(this.con);
        responseParcel.setMaxMsgSize(65104);
        tDPacket.addParcel(responseParcel);
    }

    private void bufferMessage(TDPacket tDPacket, String string) throws SQLException {
        this.initReqPacket(tDPacket, (byte)5, this.con.getRequestNum());
        if (this.con.getPromptMode()) {
            this.initReq(tDPacket, " ");
            this.initData(tDPacket, string);
        } else {
            this.initReq(tDPacket, string);
        }
        this.initResp(tDPacket);
        tDPacket.toStream();
    }

    private void sendMessage(TDPacket tDPacket) throws SQLException {
        tDPacket.getBuffer().writeStream(this.con.getIO());
    }

    private void receiveMessage(TDPacket tDPacket) throws SQLException {
        tDPacket.clear();
        TDNetworkIOIF tDNetworkIOIF = this.con.getIO();
        tDNetworkIOIF.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(tDNetworkIOIF, null, this.m_nQueryTimeoutInSeconds * 1000, true);
        }
        finally {
            tDNetworkIOIF.releaseReadLock();
        }
        tDPacket.initParcelFactory(this.con);
    }

    private void receiveResults(TDResultSet tDResultSet) throws SQLException {
        TDPacket tDPacket = this.con.createPacket(1);
        this.receiveMessage(tDPacket);
        Parcel parcel = null;
        block9: while (true) {
            if ((parcel = tDPacket.nextParcel()) == null) {
                this.con.getLog().error("Did not receive an expected parcel from the database!");
                throw ErrorFactory.makeIoJDBCException("TJ420", "ConsoleStatement.receiveResults", this.con.getIO(), null, this.con.getLog());
            }
            this.con.getLog().debug("Parcel flavor: " + parcel.getFlavor());
            switch (parcel.getFlavor()) {
                case 8: {
                    SuccessParcel successParcel = (SuccessParcel)parcel;
                    break;
                }
                case 10: {
                    if (tDResultSet.isClosed()) continue block9;
                    RecordParcel recordParcel = (RecordParcel)parcel;
                    ResultSetRow resultSetRow = new ResultSetRow();
                    RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = recordParcel.getRecordParcelColumnValuesIterator();
                    while (recordParcelColumnValuesIterator.hasNext()) {
                        resultSetRow.addValue(recordParcelColumnValuesIterator.next());
                    }
                    tDResultSet.addResultSetRow(resultSetRow);
                    break;
                }
                case 11: {
                    EndStatementParcel endStatementParcel = (EndStatementParcel)parcel;
                    break;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)parcel;
                    if (failureParcel.getCode() == 3187) {
                        tDResultSet.lastRowFetched();
                        this.con.setPromptMode(false);
                        return;
                    }
                    this.con.getLog().debug("Received Failure parcel: " + failureParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    this.con.getLog().debug("Received Error parcel: " + errorParcel.getMsg());
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
                case 12: {
                    EndRequestParcel endRequestParcel = (EndRequestParcel)parcel;
                    return;
                }
                case 29: {
                    PromptParcel promptParcel = (PromptParcel)parcel;
                    tDResultSet.lastRowFetched();
                    this.con.setPromptMode(true);
                    break;
                }
                default: {
                    this.con.getLog().error("Parcel flavor " + parcel.getFlavor() + " is not supported!");
                    throw ErrorFactory.makeDriverJDBCException("TJ419", Integer.toString(parcel.getFlavor()));
                }
            }
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void cancel() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void close() throws SQLException {
        this.results = null;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this.abortIfClosed();
        return this.execute(string, 2);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        this.abortIfClosed();
        if (n != 2) {
            throw ErrorFactory.makeDriverJDBCException("TJ406");
        }
        this.executeQuery(string);
        return true;
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        Object object;
        this.abortIfClosed();
        SQLException sQLException = null;
        this.results.reinit();
        try {
            this.sqlStmt = string;
            object = this.con.constructResultSetMetaData();
            ColumnProperties columnProperties = new ColumnProperties();
            columnProperties = new ColumnProperties();
            columnProperties.setPrecision(0);
            columnProperties.setScale(0);
            columnProperties.setColumnName(null);
            columnProperties.setColumnLabel(columnProperties.getColumnName());
            columnProperties.setNullable(0);
            columnProperties.setColumnType(12, 449);
            columnProperties.setTdType(448);
            columnProperties.setColumnDisplaySize(64000);
            ((TeraResultSetMetaData)object).addColumnProperties(columnProperties, true);
            TDResultSet tDResultSet = this.con.constructResultSet((TeraResultSetMetaData)object, 1, this, this, this.con.getLog());
            tDResultSet.setActivityCount(0x7FFFFFFEL);
            this.results.addResult(null, new Result(tDResultSet));
            this.fetchRows(tDResultSet, -1, 1, 0L, 0L);
        }
        catch (SQLException sQLException2) {
            sQLException = ConsoleStatement.chainSQLExceptions(sQLException, sQLException2);
        }
        if (sQLException != null) {
            object = ErrorFactory.makeDriverJDBCException("TJ531");
            ((SQLException)object).setNextException(sQLException);
            throw object;
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.abortIfClosed();
        return this.con;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.abortIfClosed();
        return this.getRowFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.abortIfClosed();
        return this.getRowFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.abortIfClosed();
        return this.getMaxFetchFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.abortIfClosed();
        return this.getMaxFetchRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        this.abortIfClosed();
        throw ErrorFactory.makeDriverJDBCException("TJ406");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.abortIfClosed();
        return this.m_nQueryTimeoutInSeconds;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.abortIfClosed();
        if (this.results.getResultType() == 2) {
            TDResultSet tDResultSet = this.results.getResult().getResultSet();
            return tDResultSet;
        }
        return null;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.abortIfClosed();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.abortIfClosed();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.abortIfClosed();
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.abortIfClosed();
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.abortIfClosed();
        return null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.abortIfClosed();
        if (n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ603", n);
        }
        this.m_nQueryTimeoutInSeconds = n;
    }

    @Override
    public void suppressResponseCancel() {
    }

    @Override
    public void closingResultSet(boolean bl, boolean bl2) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchRows(TDResultSet tDResultSet, int n, int n2, long l, long l2) throws SQLException {
        block7: {
            SQLException sQLException = null;
            try {
                TDPacket tDPacket = this.con.createPacket(1);
                if (tDResultSet.isBeforeFirst()) {
                    this.bufferMessage(tDPacket, this.sqlStmt);
                } else {
                    this.bufferMessage(tDPacket, " ");
                }
                this.sendMessage(tDPacket);
                this.receiveResults(tDResultSet);
            }
            catch (SQLException sQLException2) {
                sQLException = ConsoleStatement.chainSQLExceptions(sQLException, sQLException2);
            }
            finally {
                if (sQLException == null) break block7;
                SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ609");
                sQLException3.setNextException(sQLException);
                throw sQLException3;
            }
        }
    }

    @Override
    public Object getCloseMutex() {
        return this.con;
    }

    @Override
    public int getCurrentRequestNumber() {
        return -1;
    }

    @Override
    public int getCurrentStatementNumber() {
        return this.results.getResultsSize() + 1;
    }

    @Override
    public int getRowFetchDirection() {
        return 1000;
    }

    @Override
    public int getRowFetchSize() {
        return 0;
    }

    @Override
    public int getMaxFetchRows() {
        return 0;
    }

    @Override
    public int getMaxFetchFieldSize() {
        return 0;
    }

    @Override
    public boolean registerStatement() {
        return true;
    }

    @Override
    public void unregisterStatement() {
    }

    @Override
    public boolean getFinalizeAutoClose() {
        return this.con.getURLParameters().getFinalizeAutoClose();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.results == null;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.abortIfClosed();
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.abortIfClosed();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ733");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }
}

