/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Decoder;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.io.CertChecker;
import com.teradata.jdbc.jdbc_4.io.LanHeader;
import com.teradata.jdbc.jdbc_4.io.ProxySupport;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.io.WireProtocol;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AbortUCParcel;
import com.teradata.jdbc.jdbc_4.parcel.AckRequestedParcel;
import com.teradata.jdbc.jdbc_4.parcel.CancelParcel;
import com.teradata.jdbc.jdbc_4.parcel.ContinueContextParcel;
import com.teradata.jdbc.jdbc_4.parcel.ControlDataEndParcel;
import com.teradata.jdbc.jdbc_4.parcel.ControlDataStartParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecoverableNPSupportedParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecoverableProtocolParcel;
import com.teradata.jdbc.jdbc_4.parcel.RedriveParcel;
import com.teradata.jdbc.jdbc_4.parcel.RedriveSupportedParcel;
import com.teradata.jdbc.jdbc_4.parcel.SecurityPolicyParcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionStatusResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.UnknownParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class TDNetworkIOIF {
    private String m_sOriginalHostName;
    private boolean m_bClosedJavaSPDefaultConnection;
    private Socket socket = null;
    private int[] m_anPorts;
    private String m_sProxyUsed;
    private String m_sCertStatus;
    private boolean m_bSkipFrame;
    private OutputStream outStream;
    private InputStream inStream;
    private Mutex readLock;
    private Mutex writeLock;
    private int sessionNum;
    private final String m_sConnectionID = Integer.toHexString(System.identityHashCode(this));
    private int m_tcp_concurrent = 3;
    private int m_tcp_contimeout = 10000;
    private long m_tcp_conwait = 1000L;
    private long m_result_connecttime = 0L;
    private long m_result_connecttotaltime = 0L;
    private int m_result_connectattempts = 0;
    private int m_result_connectfailures = 0;
    private int m_nHTTPSRetries = 0;
    private byte[] m_abyLastSentMsg;
    private int m_nRecoverableNetworkState;
    private boolean m_bReadInProgress;
    private int m_nReconnectAttempts = 0;
    private boolean m_bReconnectInProgress;
    protected GenericTeradataConnection m_con;
    protected Log log;
    private static Map sm_mapConnectFailures = Collections.synchronizedMap(new HashMap());
    private static Map sm_map = new HashMap();
    private Object m_oSocketWriteErrorMutex = new Object();
    private SQLException m_exSocketWriteErrorChain = null;
    private static final int GET_TCP_KEEPALIVE = 1;
    private static final int GET_TCP_NODELAY = 2;
    private static final int GET_TCP_RECEIVE = 3;
    private static final int GET_TCP_SEND = 4;
    private static final int GET_TCP_LINGER = 5;
    private static final int GET_TCP_TRAFFIC = 6;

    private TDNetworkIOIF() {
    }

    public static void createIO(GenericTeradataConnection genericTeradataConnection, CurrentThreadIO currentThreadIO) throws SQLException {
        TDNetworkIOIF tDNetworkIOIF = new TDNetworkIOIF();
        genericTeradataConnection.setIO(tDNetworkIOIF);
        tDNetworkIOIF.log = genericTeradataConnection.getLog();
        tDNetworkIOIF.readLock = new Mutex("IO ReadLock", tDNetworkIOIF.log);
        tDNetworkIOIF.writeLock = new Mutex("IO WriteLock", tDNetworkIOIF.log);
        if (currentThreadIO != null) {
            tDNetworkIOIF.outStream = currentThreadIO.getOutputStream();
            tDNetworkIOIF.inStream = currentThreadIO.getInputStream();
        } else {
            tDNetworkIOIF.m_con = genericTeradataConnection;
            tDNetworkIOIF.m_sOriginalHostName = genericTeradataConnection.getMachineName();
            tDNetworkIOIF.createSocketConnection();
        }
    }

    private void createSocketConnection() throws SQLException {
        try {
            this.connectToHost();
        }
        catch (Throwable throwable) {
            this.close();
            throw ErrorAnalyzer.analyzeIoError("Connection to " + this.m_sOriginalHostName, this, throwable, false, false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Completed connection: " + this);
        }
    }

    private static int randomNumber(int n, int n2) {
        int n3 = n2 - n + 1;
        return (int)(Math.random() * (double)n3) % n3 + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToHost() throws Throwable {
        Object object;
        long l;
        int n;
        Object object2;
        Serializable serializable;
        Object object3;
        int n2;
        Object object4;
        LinkedHashSet<Serializable> linkedHashSet;
        int n3;
        Lookup lookup;
        ArrayList<InetAddress[]> arrayList;
        boolean bl;
        SQLException sQLException;
        SSLSocketFactory sSLSocketFactory;
        int n4;
        Integer n5;
        int n6;
        boolean bl2;
        Integer n7;
        Integer n8;
        boolean bl3;
        boolean bl4;
        Log log;
        long l2;
        String string;
        block72: {
            int n9;
            string = this.m_con.getMachineName();
            l2 = this.m_con.getURLParameters().getConnectFailureTTL();
            log = this.m_con.getLog();
            bl4 = false;
            bl3 = false;
            n8 = null;
            n7 = null;
            bl2 = true;
            n6 = 10;
            n5 = null;
            String string2 = this.m_con.getURLParameters().getTCP();
            if (string2 != null) {
                String[] stringArray = string2.toUpperCase().trim().split("[+]");
                for (n9 = 0; n9 < stringArray.length; ++n9) {
                    if (stringArray[n9].equals("KEEPALIVE")) {
                        bl4 = true;
                        continue;
                    }
                    if (stringArray[n9].equals("NODELAY")) {
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[n9].startsWith("RECEIVE")) {
                        n8 = new Integer(stringArray[n9].substring("RECEIVE".length()));
                        continue;
                    }
                    if (stringArray[n9].startsWith("SEND")) {
                        n7 = new Integer(stringArray[n9].substring("SEND".length()));
                        continue;
                    }
                    if (stringArray[n9].equals("NOLINGER")) {
                        bl2 = false;
                        continue;
                    }
                    if (stringArray[n9].startsWith("LINGER")) {
                        n6 = Integer.parseInt(stringArray[n9].substring("LINGER".length()));
                        continue;
                    }
                    if (stringArray[n9].startsWith("TRAFFIC")) {
                        n5 = new Integer(stringArray[n9].substring("TRAFFIC".length()));
                        continue;
                    }
                    if (stringArray[n9].startsWith("CONCURRENT")) {
                        this.m_tcp_concurrent = Integer.parseInt(stringArray[n9].substring("CONCURRENT".length()));
                        continue;
                    }
                    if (stringArray[n9].startsWith("CONTIMEOUT")) {
                        this.m_tcp_contimeout = Integer.parseInt(stringArray[n9].substring("CONTIMEOUT".length()));
                        continue;
                    }
                    if (!stringArray[n9].startsWith("CONWAIT")) continue;
                    this.m_tcp_conwait = Long.parseLong(stringArray[n9].substring("CONWAIT".length()));
                }
            }
            if (this.m_tcp_concurrent <= 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ654", string, "concurrent", String.valueOf(this.m_tcp_concurrent));
            }
            if (this.m_tcp_contimeout < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ652", string, "contimeout", String.valueOf(this.m_tcp_contimeout));
            }
            if (this.m_tcp_conwait < 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ652", string, "conwait", String.valueOf(this.m_tcp_conwait));
            }
            n4 = this.m_con.getURLParameters().getSSLModeLevel();
            n9 = n4 >= 4 ? 1 : 0;
            String string3 = System.getProperty("java.version");
            if (log.isDebugEnabled()) {
                log.debug("TDNetworkIOIF.connectToHost: nSSLModeLevel=" + n4 + " bSocketFactoryRequired=" + (n9 != 0) + " sJavaVersion=" + string3);
            }
            sSLSocketFactory = null;
            sQLException = null;
            if (n4 >= 2) {
                try {
                    sSLSocketFactory = Utility.obtainSSLSocketFactory(this.m_con.getURLParameters(), log);
                }
                catch (SQLException sQLException2) {
                    if (log.isDebugEnabled()) {
                        log.debug("TDNetworkIOIF.connectToHost: bSocketFactoryRequired=" + (n9 != 0) + " sJavaVersion=" + string3 + " obtainSSLSocketFactory threw " + sQLException2);
                    }
                    if (n9 != 0) {
                        throw sQLException2;
                    }
                    sQLException = sQLException2;
                }
            }
            boolean bl5 = bl = sSLSocketFactory != null;
            if (this.m_anPorts == null) {
                int n10 = this.m_con.getURLParameters().getDbsPort();
                int n11 = this.m_con.getURLParameters().getHTTPSPort();
                this.m_anPorts = n4 >= 4 ? new int[]{n11} : (n4 == 2 && bl ? new int[]{n10, n11} : (n4 == 3 && bl ? new int[]{n11, n10} : new int[]{n10}));
                if (log.isDebugEnabled()) {
                    log.debug("TDNetworkIOIF.connectToHost: nSSLModeLevel=" + n4 + " sJavaVersion=" + string3 + " bTLSAvailable=" + bl + " m_anPorts.length=" + this.m_anPorts.length + " values " + this.m_anPorts[0] + (this.m_anPorts.length > 1 ? ", " + this.m_anPorts[1] : ""));
                }
            }
            String string4 = this.m_con.getURLParameters().getCopDiscovery() ? "cop" : null;
            arrayList = new ArrayList<InetAddress[]>();
            lookup = new Lookup(this.m_con, string);
            if (lookup.isLiteralIpAddress()) {
                arrayList.add(lookup.getAddresses());
            } else if (string4 != null) {
                n3 = string.indexOf(46);
                linkedHashSet = n3 < 0 ? string : string.substring(0, n3);
                object4 = n3 < 0 ? "" : string.substring(n3);
                InetAddress inetAddress = this.m_con.getURLParameters().getCOPLast() ? new Lookup(this.m_con, (String)((Object)linkedHashSet) + string4 + "last" + (String)object4).getAddresses()[0] : null;
                try {
                    n2 = 1;
                    while (true) {
                        String string5 = (String)((Object)linkedHashSet) + string4 + n2 + (String)object4;
                        object3 = new Lookup(this.m_con, string5).getAddresses();
                        arrayList.add((InetAddress[])object3);
                        if (object3[0].equals(inetAddress)) {
                            if (log.canLog(2)) {
                                log.timing("Reached last cop " + object3[0]);
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (log.isDebugEnabled()) {
                        log.debug("TDNetworkIOIF.connectToHost: caught " + unknownHostException);
                    }
                }
                catch (SecurityException securityException) {
                    if (!log.isDebugEnabled()) break block72;
                    log.debug("TDNetworkIOIF.connectToHost: caught " + securityException);
                }
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(lookup.getAddresses());
        }
        n3 = TDNetworkIOIF.randomNumber(0, arrayList.size() - 1);
        linkedHashSet = sm_map;
        synchronized (linkedHashSet) {
            object4 = (Integer)sm_map.get(string);
            if (object4 != null) {
                n3 = ((Integer)object4 + 1) % arrayList.size();
            }
            sm_map.put(string, new Integer(n3));
        }
        Collections.rotate(arrayList, -n3);
        if (log.isDebugEnabled()) {
            log.debug("Before connect loop: sm_mapConnectFailures=" + sm_mapConnectFailures);
        }
        linkedHashSet = new LinkedHashSet<Serializable>();
        long l3 = System.currentTimeMillis();
        n2 = arrayList.size() == 1 && ((InetAddress[])arrayList.get(0)).length == 1 ? 1 : 0;
        int n12 = n2 != 0 && n4 >= 3 && bl ? this.m_con.getURLParameters().getHTTPSRetry() : 0;
        object3 = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            InetAddress[] inetAddressArray = (InetAddress[])arrayList.get(i);
            for (int j = 0; j < inetAddressArray.length; ++j) {
                for (int k = 0; k < this.m_anPorts.length; ++k) {
                    serializable = new InetSocketAddress(inetAddressArray[j], this.m_anPorts[k]);
                    this.m_con.checkRemainingLoginTime();
                    object2 = (Date)sm_mapConnectFailures.get(serializable);
                    if (object2 != null) {
                        long l4 = ((Date)object2).getTime();
                        int n13 = n = l4 <= l3 ? 1 : 0;
                        if (n != 0) {
                            boolean bl6;
                            l = l4 + l2 * 1000L;
                            boolean bl7 = bl6 = l3 < l;
                            if (bl6) {
                                if (!log.canLog(2)) continue;
                                log.timing("Fail-fast connection attempt skipped due to failure at " + object2 + ", " + serializable + " will become usable at " + new Date(l));
                                continue;
                            }
                        }
                    }
                    linkedHashSet.add(serializable);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("setAddresses=" + linkedHashSet);
        }
        ArrayList<InetSocketAddress> arrayList2 = new ArrayList<InetSocketAddress>(linkedHashSet);
        this.m_result_connectattempts = 0;
        long l5 = System.currentTimeMillis();
        ConnectThread connectThread = null;
        serializable = new ArrayList();
        try {
            object2 = new ArrayList();
            try {
                object = new WorkerThreadList();
                int n14 = 0;
                while (connectThread == null) {
                    if (n14 >= arrayList2.size() && serializable.size() <= 0) break;
                    n = this.m_con.checkRemainingLoginTime();
                    if (serializable.size() < this.m_tcp_concurrent && n14 < arrayList2.size()) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)arrayList2.get(n14);
                        ++n14;
                        ++this.m_result_connectattempts;
                        boolean bl8 = this.m_con.getURLParameters().isHTTPSPort(inetSocketAddress.getPort());
                        if (log.canLog(2)) {
                            log.timing("Attempting " + (bl8 ? "HTTPS" : "Teradata") + " connection " + this.m_result_connectattempts + " to " + inetSocketAddress);
                        }
                        int n15 = n == 0 && this.m_tcp_contimeout != 0 ? this.m_tcp_contimeout : (n != 0 && this.m_tcp_contimeout == 0 ? n : Math.min(n, this.m_tcp_contimeout));
                        ConnectThread connectThread2 = new ConnectThread(log, this.m_con.getURLParameters(), bl4, bl3, n8, n7, bl2, n6, n5, inetSocketAddress, n15, bl8, sSLSocketFactory, (List<Socket>)object2, (WorkerThreadList)object);
                        serializable.add(connectThread2);
                        connectThread2.setDaemon(true);
                        connectThread2.start();
                    }
                    l = serializable.size() < this.m_tcp_concurrent && n14 < arrayList2.size() ? this.m_tcp_conwait : 0L;
                    List list = ((WorkerThreadList)object).waitForThreads(l);
                    for (ConnectThread connectThread3 : list) {
                        serializable.remove(connectThread3);
                        long l6 = System.currentTimeMillis();
                        Utility.waitForThreadDeath(connectThread3);
                        if (log.canLog(2)) {
                            log.timing((connectThread3.m_bUseHTTPS ? "HTTPS" : "Teradata") + " connection attempt to " + connectThread3.m_isa + " with timeout " + connectThread3.m_nTimeoutMs + " ms took " + connectThread3.m_nElapsedTime + " ms and " + (connectThread3.m_ex != null ? "failed" : (connectThread == null ? "succeeded" : "succeeded but was discarded")) + ", waiting for thread took " + (System.currentTimeMillis() - l6) + " ms");
                        }
                        if (connectThread == null && TDNetworkIOIF.isUsableSocket(this, bl, sQLException, connectThread3)) {
                            connectThread = connectThread3;
                            this.m_result_connecttime = connectThread3.m_nElapsedTime;
                        }
                        if (connectThread3.m_ex == null) continue;
                        ++this.m_result_connectfailures;
                        sm_mapConnectFailures.put(connectThread3.m_isa, connectThread3.m_dateFailure);
                        if (connectThread3.m_ex instanceof IOException) {
                            connectThread3.m_ex = new IOException("Connection to " + connectThread3.m_isa + " failed: " + connectThread3.m_ex.getMessage(), connectThread3.m_ex);
                        }
                        Throwable throwable = connectThread3.m_ex;
                        while (object3 != null) {
                            if (throwable.getCause() == null) {
                                throwable.initCause((Throwable)object3);
                                break;
                            }
                            throwable = throwable.getCause();
                        }
                        object3 = connectThread3.m_ex;
                        if (connectThread3.m_socket != null) {
                            object2.remove(connectThread3.m_socket);
                            try {
                                connectThread3.m_socket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (!connectThread3.m_bHTTPSFailure || n12 <= 0) continue;
                        if (log.isDebugEnabled()) {
                            log.debug("nHTTPSRetry=" + n12 + " m_isa=" + connectThread3.m_isa);
                        }
                        arrayList2.add(connectThread3.m_isa);
                        ++this.m_nHTTPSRetries;
                        --n12;
                    }
                }
            }
            finally {
                object = object2.iterator();
                while (object.hasNext()) {
                    Socket socket = (Socket)object.next();
                    if (connectThread != null && socket == connectThread.m_socket) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            object2 = serializable.iterator();
        }
        catch (Throwable throwable) {
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                ConnectThread connectThread4 = (ConnectThread)iterator.next();
                long l7 = System.currentTimeMillis();
                Utility.waitForThreadDeath(connectThread4);
                if (!log.canLog(2)) continue;
                log.timing("Discarded connection attempt to " + connectThread4.m_isa + ", waiting for thread took " + (System.currentTimeMillis() - l7) + " ms");
            }
            throw throwable;
        }
        while (object2.hasNext()) {
            object = (ConnectThread)object2.next();
            long l8 = System.currentTimeMillis();
            Utility.waitForThreadDeath((Thread)object);
            if (!log.canLog(2)) continue;
            log.timing("Discarded connection attempt to " + ((ConnectThread)object).m_isa + ", waiting for thread took " + (System.currentTimeMillis() - l8) + " ms");
        }
        this.m_result_connecttotaltime = System.currentTimeMillis() - l5;
        if (connectThread != null) {
            this.socket = connectThread.m_socket;
            this.m_anPorts = new int[]{this.socket.getPort()};
            this.m_sProxyUsed = connectThread.m_sProxyUsed;
            this.m_sCertStatus = connectThread.m_sCertStatus;
            this.inStream = connectThread.m_inStream;
            this.outStream = connectThread.m_outStream;
            return;
        }
        if (object3 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ635", String.valueOf(l2));
        }
        throw object3;
    }

    public int connectAttempts() {
        return this.m_result_connectattempts;
    }

    public int connectFailures() {
        return this.m_result_connectfailures;
    }

    public int httpsRetries() {
        return this.m_nHTTPSRetries;
    }

    public String getTLSProtocol(String[] stringArray) {
        return Utility.getTLSProtocol(this.socket, stringArray);
    }

    public String toString() {
        return (this.isJavaSPDefaultConnection() ? "jdbc:default:connection" : "socket orig=" + this.m_sOriginalHostName) + (this.socket != null ? " local=" + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort() + " remote=" + this.socket.getInetAddress() + ":" + this.socket.getPort() + " tls=" + (this.socket instanceof SSLSocket) + " protocol=" + this.getTLSProtocol(null) + " cert=" + this.getCertStatus() + " keepalive=" + this.getTcpOption(1) + " nodelay=" + this.getTcpOption(2) + " receive=" + this.getTcpOption(3) + " send=" + this.getTcpOption(4) + " linger=" + this.getTcpOption(5) + " traffic=" + this.getTcpOption(6) + " concurrent=" + this.m_tcp_concurrent + " contimeout=" + this.m_tcp_contimeout + " conwait=" + this.m_tcp_conwait + " connecttime=" + this.m_result_connecttime + " connecttotaltime=" + this.m_result_connecttotaltime + " connectattempts=" + this.m_result_connectattempts + " connectfailures=" + this.m_result_connectfailures + " reconnectattempts=" + this.m_nReconnectAttempts + " recoverable=" + this.m_con.isRecoverableNPActive() + " redrive=" + this.m_con.isRedriveActive() + " failurecache=" + sm_mapConnectFailures : "") + " cid=" + this.m_sConnectionID + " sess=" + this.sessionNum;
    }

    private String getTcpOption(int n) {
        try {
            switch (n) {
                case 1: {
                    return String.valueOf(this.socket.getKeepAlive());
                }
                case 2: {
                    return String.valueOf(this.socket.getTcpNoDelay());
                }
                case 3: {
                    return String.valueOf(this.socket.getReceiveBufferSize());
                }
                case 4: {
                    return String.valueOf(this.socket.getSendBufferSize());
                }
                case 5: {
                    return String.valueOf(this.socket.getSoLinger());
                }
                case 6: {
                    return String.valueOf(this.socket.getTrafficClass());
                }
            }
            throw new IllegalArgumentException("Invalid value specified for nDesiredOption");
        }
        catch (SocketException socketException) {
            return "unavailable";
        }
    }

    public String getOriginalHostName() {
        return this.m_sOriginalHostName;
    }

    public InetAddress getRemoteAddress() {
        return this.socket != null ? this.socket.getInetAddress() : null;
    }

    public int getRemotePort() {
        return this.socket != null ? this.socket.getPort() : 0;
    }

    public InetAddress getLocalAddress() {
        return this.socket != null ? this.socket.getLocalAddress() : null;
    }

    public int getLocalPort() {
        return this.socket != null ? this.socket.getLocalPort() : 0;
    }

    public String getProxyUsed() {
        return this.m_sProxyUsed;
    }

    public String getCertStatus() {
        return this.m_sCertStatus != null ? this.m_sCertStatus : "U";
    }

    public String getConnectionID() {
        return this.m_sConnectionID;
    }

    public int getSessionNum() {
        return this.sessionNum;
    }

    public void setSessionNum(int n) {
        this.sessionNum = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int read(BufferContainer bufferContainer, int n, TDStatement tDStatement, boolean bl) throws SQLException {
        boolean bl2 = tDStatement != null ? tDStatement.isFinalized() : false;
        try {
            boolean bl3 = this.m_bReadInProgress;
            this.m_bReadInProgress = true;
            try {
                int n2;
                int n3 = 0;
                int n4 = !this.m_bSkipFrame && this.socket instanceof SSLSocket ? 2 : 0;
                byte[] object = new byte[10];
                int n5 = 0;
                long l = System.currentTimeMillis();
                byte[] byArray = bufferContainer.getBuffer();
                boolean bl4 = false;
                int n6 = 1;
                boolean bl5 = false;
                try {
                    if (this.socket != null) {
                        this.socket.setSoTimeout(n);
                    }
                    while (true) {
                        boolean byArray5;
                        int iOException = 0;
                        try {
                            try {
                                int iOException2;
                                while (n3 < n4) {
                                    iOException2 = this.inStream.read(object, n3, n4 - n3);
                                    if (iOException2 == -1) {
                                        if (!bl2) {
                                            this.log.error("Read message " + n6 + ": Incomplete WebSocket frame: read " + n3 + " bytes");
                                            if (n3 > 0) {
                                                this.log.debugPartialByteArray("Received incomplete WebSocket frame", object, 0, n3);
                                            }
                                        }
                                        throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ1556"), n3));
                                    }
                                    if ((n3 += iOException2) != 2) continue;
                                    switch (object[1] & 0x7F) {
                                        case 126: {
                                            n4 += 2;
                                            break;
                                        }
                                        case 127: {
                                            n4 += 8;
                                        }
                                    }
                                }
                                if (n3 > 0) {
                                    this.log.debugPartialByteArray("Received WebSocket frame", object, 0, n3);
                                }
                                while (n5 < 52 && (iOException2 = this.inStream.read(byArray, n5, 52 - n5)) != -1) {
                                    n5 += iOException2;
                                }
                                if (n5 < 52) {
                                    if (!bl2) {
                                        this.log.error("Read message " + n6 + ": Incomplete LAN message header: read " + n5 + " bytes");
                                        if (n5 > 0) {
                                            this.log.debugPartialByteArray("Incomplete response message header", byArray, 0, n5);
                                        }
                                    }
                                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ324"), n5));
                                }
                                iOException = TDNetworkIOIF.getTotalMsgLength(byArray);
                                iOException2 = this.m_con != null && this.m_con.getConfigResponse() != null ? this.m_con.getMaxMessageSize(false, true) * 2 : 0xFFF800;
                                boolean bl6 = byArray5 = iOException > byArray.length && iOException <= iOException2;
                                if (byArray5) {
                                    byte[] n22 = new byte[iOException];
                                    System.arraycopy(byArray, 0, n22, 0, n5);
                                    if (this.log.canLog(1)) {
                                        this.log.info("Read message " + n6 + ": resizing buffer from " + byArray.length + " bytes to " + n22.length + " bytes");
                                    }
                                    byArray = n22;
                                    bufferContainer.setBuffer(byArray);
                                }
                                int n7 = n2 = iOException > byArray.length ? 1 : 0;
                                if (n2 != 0) {
                                    if (!this.isJavaSPDefaultConnection()) {
                                        this.m_con.suppressReconnect();
                                    }
                                    this.log.error("Read message " + n6 + ": Bad response message header with invalid message length of " + iOException + " bytes");
                                    this.log.debugPartialByteArray("Bad response message header message dump", byArray, 0, 52);
                                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ325"), iOException));
                                }
                                while (n5 < iOException) {
                                    int n8 = this.inStream.read(byArray, n5, iOException - n5);
                                    if (n8 < 0) {
                                        bl5 = true;
                                        this.log.error("Read message " + n6 + ": Incomplete message: could only read " + n5 + " of " + iOException + " expected bytes");
                                        throw new IOException(ErrorMessage.Format2(ErrorMessage.messages.getString("TJ1557"), n5, iOException));
                                    }
                                    n5 += n8;
                                }
                                if (this.socket != null) {
                                    this.socket.setSoTimeout(0);
                                }
                            }
                            finally {
                                if (this.log.canLog(2)) {
                                    this.log.timing("Read " + TDNetworkIOIF.messageTitle(byArray, " ") + "message " + n6 + ", " + n5 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                                }
                            }
                        }
                        catch (IOException n8) {
                            if (bl5) {
                                throw n8;
                            }
                            byArray5 = false;
                            if (n8 instanceof SocketException && n8.getMessage().equals("Read timed out") || n8 instanceof InterruptedIOException) {
                                bl4 = true;
                                boolean bl7 = byArray5 = n6 < 2 && (n3 > 0 || n5 > 0);
                                if (!bl2) {
                                    this.log.info("Read message " + n6 + ", " + (n4 > 0 ? n3 + " of " + n4 + " frame bytes, " : "") + n5 + (iOException > 0 ? " of " + iOException : "") + " bytes, timed out: " + n8);
                                    if (n5 > 0) {
                                        this.log.debugPartialByteArray("Timed out message header message dump", byArray, 0, Math.min(n5, 52));
                                    }
                                }
                            }
                            if (!byArray5) {
                                throw n8;
                            }
                            ++n6;
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException byArray3) {
                    if (bl4) {
                        block59: {
                            if (n5 > 0) {
                                if (!bl2) {
                                    this.log.error("Read message " + n6 + " timed out after partial read; closing socket due to: " + byArray3);
                                }
                                this.close();
                                IOException iOException3 = new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ625"), n5));
                                iOException3.initCause(byArray3);
                                throw iOException3;
                            }
                            try {
                                if (this.socket != null) {
                                    this.socket.setSoTimeout(0);
                                }
                            }
                            catch (IOException n11) {
                                if (bl2) break block59;
                                this.log.error("Read message " + n6 + " reset socket timeout failed: " + n11);
                            }
                        }
                        throw byArray3;
                    }
                    if (bl2 || this.isJavaSPDefaultConnection() || !bl || bl5 || !this.m_con.isReconnectEnabled() || this.m_bReconnectInProgress) {
                        if (!bl2) {
                            this.log.error("Read message " + n6 + " failed; closing socket due to: " + byArray3);
                        }
                        this.close();
                        throw byArray3;
                    }
                    int byArray4 = this.processReconnect(byArray3, bufferContainer, n, tDStatement, bl);
                    this.m_bReadInProgress = bl3;
                    if (!this.m_bReadInProgress) {
                        this.m_nRecoverableNetworkState = 2;
                    }
                    return byArray4;
                }
                this.log.debugPartialByteArray("Raw packet receive", byArray, 0, n5);
                if (!this.isJavaSPDefaultConnection() && this.m_con.getTeraEncrypt() != null && (byArray[1] & 0x80) != 0) {
                    byte[] n12 = new byte[24];
                    System.arraycopy(byArray, 0, n12, 0, n12.length);
                    byte[] byArray2 = new byte[n5 - n12.length];
                    System.arraycopy(byArray, n12.length, byArray2, 0, byArray2.length);
                    byte[] byArray3 = this.m_con.getTeraEncrypt().decrypt(byArray2, 0, byArray2.length);
                    n5 = byArray3.length + n12.length;
                    byArray = new byte[n5];
                    bufferContainer.setBuffer(byArray);
                    System.arraycopy(n12, 0, byArray, 0, n12.length);
                    System.arraycopy(byArray3, 0, byArray, n12.length, byArray3.length);
                    byArray[1] = (byte)(byArray[1] - 128);
                    n2 = byArray3.length - 28;
                    byArray[3] = (byte)(n2 >> 24 & 0xFF);
                    byArray[4] = (byte)(n2 >> 16 & 0xFF);
                    byArray[8] = (byte)(n2 >> 8 & 0xFF);
                    byArray[9] = (byte)(n2 & 0xFF);
                    this.log.debugPartialByteArray("message dump", byArray, 0, n5);
                }
                if (!this.isJavaSPDefaultConnection() && bufferContainer instanceof TDPacketStream) {
                    this.processControlData((TDPacketStream)bufferContainer, tDStatement, bl);
                }
                int n9 = n5;
                return n9;
            }
            finally {
                this.m_bReadInProgress = bl3;
                if (!this.m_bReadInProgress) {
                    this.m_nRecoverableNetworkState = 2;
                }
            }
        }
        catch (IOException iOException) {
            SQLException sQLException;
            SQLException sQLException2 = ErrorAnalyzer.analyzeIoError("Packet receive", this, iOException, bl2, bl);
            Object object = this.m_oSocketWriteErrorMutex;
            synchronized (object) {
                sQLException = this.m_exSocketWriteErrorChain;
                this.m_exSocketWriteErrorChain = null;
            }
            if (sQLException == null) {
                sQLException = sQLException2;
            } else {
                sQLException.setNextException(sQLException2);
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, TDStatement tDStatement, boolean bl) throws SQLException {
        Object object;
        byte[] byArray2;
        boolean bl2;
        boolean bl3;
        boolean bl4 = tDStatement != null && tDStatement.isFinalized();
        byte by = byArray[2];
        int n = TDNetworkIOIF.getTotalMsgLength(byArray);
        if (!(this.isJavaSPDefaultConnection() || !this.m_con.isRecoverableNPActive() || this.m_bReadInProgress || by != 5 && by != 6 && by != 13)) {
            this.m_abyLastSentMsg = new byte[n];
            System.arraycopy(byArray, 0, this.m_abyLastSentMsg, 0, this.m_abyLastSentMsg.length);
            this.m_nRecoverableNetworkState = 0;
        }
        boolean bl5 = !this.isJavaSPDefaultConnection() && this.m_con.getEncryptData();
        SecurityPolicyParcel securityPolicyParcel = !this.isJavaSPDefaultConnection() ? this.m_con.getSecurityPolicy() : null;
        boolean bl6 = securityPolicyParcel != null && securityPolicyParcel.getSecurityRequired() >= 1;
        int n2 = securityPolicyParcel != null ? securityPolicyParcel.getSecurityLevel() : 0;
        boolean bl7 = securityPolicyParcel != null && securityPolicyParcel.getConfidentialityRequired() >= 1;
        switch (by) {
            case 1: 
            case 2: 
            case 10: 
            case 11: 
            case 12: {
                bl3 = false;
                bl2 = false;
                break;
            }
            case 3: 
            case 4: {
                bl2 = bl3 = !this.isJavaSPDefaultConnection() && !(this.socket instanceof SSLSocket);
                break;
            }
            default: {
                bl3 = !this.isJavaSPDefaultConnection() && !(this.socket instanceof SSLSocket) && (bl5 || bl6) && this.m_con.getTeraEncrypt().canEncrypt();
                boolean bl8 = bl2 = bl3 && (bl5 || bl7);
            }
        }
        if (bl3) {
            this.log.debugPartialByteArray("message dump", byArray, 0, n);
            byArray2 = new byte[24];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[n - byArray2.length];
            System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
            object = this.m_con.getTeraEncrypt().encrypt(n2, bl2, byArray3, 0, byArray3.length);
            byArray = new byte[((Object)object).length + byArray2.length];
            n = byArray.length;
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            System.arraycopy(object, 0, byArray, byArray2.length, ((Object)object).length);
            byArray[1] = (byte)(byArray[1] | 0x80);
            int n3 = ((Object)object).length - 28;
            byArray[3] = (byte)(n3 >> 24 & 0xFF);
            byArray[4] = (byte)(n3 >> 16 & 0xFF);
            byArray[8] = (byte)(n3 >> 8 & 0xFF);
            byArray[9] = (byte)(n3 & 0xFF);
        }
        byArray2 = null;
        if (this.socket instanceof SSLSocket) {
            int n4 = n <= 125 ? 2 : (n <= 65535 ? 4 : 10);
            byArray2 = new byte[n4 + n];
            System.arraycopy(byArray, 0, byArray2, n4, n);
            byArray2[0] = -126;
            if (n <= 125) {
                byArray2[1] = (byte)n;
            } else if (n <= 65535) {
                byArray2[1] = 126;
                byArray2[2] = (byte)(n >> 8 & 0xFF);
                byArray2[3] = (byte)(n & 0xFF);
            } else {
                byArray2[1] = 127;
                byArray2[6] = (byte)(n >> 24 & 0xFF);
                byArray2[7] = (byte)(n >> 16 & 0xFF);
                byArray2[8] = (byte)(n >> 8 & 0xFF);
                byArray2[9] = (byte)(n & 0xFF);
            }
            this.log.debugPartialByteArray("Transmit WebSocket frame", byArray2, 0, n4);
        }
        this.log.debugPartialByteArray("Raw packet transmit", byArray, 0, n);
        try {
            this.acquireWriteLock();
            try {
                long l = System.currentTimeMillis();
                try {
                    if (byArray2 != null) {
                        this.outStream.write(byArray2, 0, byArray2.length);
                    } else {
                        this.outStream.write(byArray, 0, n);
                    }
                    this.outStream.flush();
                }
                finally {
                    if (this.log.canLog(2)) {
                        this.log.timing("Wrote " + TDNetworkIOIF.messageTitle(byArray, " ") + "message, " + n + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                    }
                }
            }
            finally {
                this.releaseWriteLock();
            }
        }
        catch (IOException iOException) {
            object = ErrorAnalyzer.analyzeIoError("Packet transmit", this, iOException, bl4, bl);
            Object object2 = this.m_oSocketWriteErrorMutex;
            synchronized (object2) {
                if (this.m_exSocketWriteErrorChain == null) {
                    this.m_exSocketWriteErrorChain = object;
                } else {
                    this.m_exSocketWriteErrorChain.setNextException((SQLException)object);
                }
            }
        }
    }

    public static int getMsgBodyLength(byte[] byArray) {
        return (UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 3)) << 16) + UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 8));
    }

    public static int getTotalMsgLength(byte[] byArray) {
        return 52 + TDNetworkIOIF.getMsgBodyLength(byArray);
    }

    private static String messageTitle(byte[] byArray, String string) {
        boolean bl = byArray.length >= 52;
        String string2 = bl ? WireProtocol.messageKind(byArray[2]) : null;
        String string3 = bl ? WireProtocol.messageClass(byArray[1] & 0x7F) : null;
        return string2 != null && string3 != null ? string2 + " " + string3 + string : "";
    }

    public boolean isJavaSPDefaultConnection() {
        return this.m_sOriginalHostName == null;
    }

    public boolean isClosed() {
        return this.isJavaSPDefaultConnection() ? this.m_bClosedJavaSPDefaultConnection : this.socket == null || this.socket.isClosed();
    }

    public void close() {
        if (this.isJavaSPDefaultConnection()) {
            this.m_bClosedJavaSPDefaultConnection = true;
            return;
        }
        this.closeSocket(false);
    }

    private void closeSocket(boolean bl) {
        if (this.socket != null) {
            if (bl) {
                try {
                    this.socket.setSoLinger(true, 0);
                }
                catch (IOException iOException) {}
            } else if (!this.isSSLSocket()) {
                try {
                    this.socket.shutdownInput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.socket.shutdownOutput();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void acquireReadLock() throws SQLException {
        this.readLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    private void acquireWriteLock() throws SQLException {
        this.writeLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    public void releaseReadLock() {
        this.readLock.release();
    }

    private void releaseWriteLock() {
        this.writeLock.release();
    }

    public Log getLog() {
        return this.log;
    }

    public boolean isSSLSocket() {
        return this.socket instanceof SSLSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUsableSocket(TDNetworkIOIF tDNetworkIOIF, boolean bl, SQLException sQLException, ConnectThread connectThread) {
        block22: {
            if (connectThread.m_ex != null) {
                return false;
            }
            try {
                Object object;
                if (connectThread.m_bUseHTTPS) {
                    CertChecker.checkCertForThread(tDNetworkIOIF, connectThread);
                    String string = Utility.base64Encode(false, Utility.getRandomBytes(16));
                    object = "GET /gateway HTTP/1.1\r\nHost: " + connectThread.m_isa.getAddress().getHostAddress() + "\r\n" + "Upgrade: websocket\r\n" + "Connection: Upgrade\r\n" + "Sec-WebSocket-Key: " + string + "\r\n" + "Sec-WebSocket-Version: 13\r\n" + "\r\n";
                    byte[] byArray = Encoder.encodeStringUTF8((String)object);
                    tDNetworkIOIF.log.debugPartialByteArray("Transmit HTTP request", byArray, 0, byArray.length);
                    connectThread.m_outStream.write(byArray);
                    connectThread.m_outStream.flush();
                    int n = 0xD0A0D0A;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        int n2;
                        int n3 = 0;
                        while ((n2 = connectThread.m_inStream.read()) != -1) {
                            byteArrayOutputStream.write(n2);
                            if ((n3 = n3 << 8 | n2) != n) continue;
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        connectThread.m_bHTTPSFailure = true;
                        throw iOException;
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    tDNetworkIOIF.log.debugPartialByteArray("Received HTTP response", byArray2, 0, byArray2.length);
                    String string2 = Decoder.getUTF8DecodedString(byArray2);
                    String[] stringArray = string2.split("\r\n");
                    if (stringArray.length < 2 || !"HTTP/1.1 101 Switching Protocols".equals(stringArray[0]) || !"Upgrade: websocket".equals(stringArray[1])) {
                        connectThread.m_bHTTPSFailure = !string2.startsWith("HTTP");
                        throw new IOException(ErrorMessage.Format2(ErrorMessage.messages.getString("TJ1553"), Integer.toString(byArray2.length), string2));
                    }
                }
                int n = tDNetworkIOIF.m_con.getURLParameters().getSSLModeLevel();
                if (tDNetworkIOIF.log.isDebugEnabled()) {
                    tDNetworkIOIF.log.debug("Connection on port " + connectThread.m_socket.getPort() + " nSSLModeLevel=" + n + " m_bUseHTTPS=" + connectThread.m_bUseHTTPS);
                }
                if (n != 2 && n != 3) break block22;
                tDNetworkIOIF.socket = connectThread.m_socket;
                tDNetworkIOIF.inStream = connectThread.m_inStream;
                tDNetworkIOIF.outStream = connectThread.m_outStream;
                try {
                    object = new GenericLogonController(tDNetworkIOIF.m_con);
                    ((GenericLogonController)object).setConfigOnly();
                    try {
                        ((GenericLogonController)object).run();
                    }
                    catch (SQLException sQLException2) {
                        Throwable throwable;
                        for (throwable = sQLException2; throwable != null && !connectThread.m_bHTTPSFailure; throwable = throwable.getCause()) {
                            if (!(throwable instanceof IOException)) continue;
                            connectThread.m_bHTTPSFailure = true;
                        }
                        if (sQLException2.getErrorCode() == 8059 && sQLException != null) {
                            throwable = sQLException2;
                            while (throwable.getCause() != null) {
                                throwable = throwable.getCause();
                            }
                            throwable.initCause(sQLException);
                        }
                        throw sQLException2;
                    }
                    if (tDNetworkIOIF.log.isDebugEnabled()) {
                        tDNetworkIOIF.log.debug("Connection on port " + connectThread.m_socket.getPort() + " nSSLModeLevel=" + n + " bTLSAvailable=" + bl + " m_bUseHTTPS=" + connectThread.m_bUseHTTPS + " isLegacyPortAvailable=" + tDNetworkIOIF.m_con.getGtwConfig().isLegacyPortAvailable() + " isHTTPSPortAvailable=" + tDNetworkIOIF.m_con.getGtwConfig().isHTTPSPortAvailable());
                    }
                    if (n == 2 && connectThread.m_bUseHTTPS && tDNetworkIOIF.m_con.getGtwConfig().isLegacyPortAvailable()) {
                        throw new IOException(ErrorMessage.Format2(ErrorMessage.messages.getString("TJ1558"), connectThread.m_socket.getPort(), tDNetworkIOIF.m_con.getURLParameters().getDbsPort()));
                    }
                    if (n == 3 && bl && !connectThread.m_bUseHTTPS && tDNetworkIOIF.m_con.getGtwConfig().isHTTPSPortAvailable()) {
                        throw new IOException(ErrorMessage.Format2(ErrorMessage.messages.getString("TJ1559"), connectThread.m_socket.getPort(), tDNetworkIOIF.m_con.getURLParameters().getHTTPSPort()));
                    }
                }
                finally {
                    tDNetworkIOIF.socket = null;
                    tDNetworkIOIF.inStream = null;
                    tDNetworkIOIF.outStream = null;
                }
            }
            catch (Throwable throwable) {
                connectThread.m_ex = throwable;
                connectThread.m_dateFailure = new Date();
            }
        }
        if (tDNetworkIOIF.log.isDebugEnabled()) {
            tDNetworkIOIF.log.debug("Connection on port " + connectThread.m_socket.getPort() + " t.m_ex=", connectThread.m_ex);
        }
        return connectThread.m_ex == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int processReconnect(IOException iOException, BufferContainer bufferContainer, int n, TDStatement tDStatement, boolean bl) throws SQLException {
        SQLException sQLException;
        void var8_11;
        int n2;
        Object object;
        TDPacket tDPacket = this.m_con.createPacket(1);
        this.m_bReconnectInProgress = true;
        try {
            int n3;
            int sessionStatusResponseParcel;
            int bl3;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Read message failed; will attempt to reconnect after closing socket due to: " + iOException);
            }
            if ((bl3 = ((URLParameters)(object = this.m_con.getURLParameters())).getReconnectCount()) == 0) {
                sessionStatusResponseParcel = 11;
            }
            if ((n3 = ((URLParameters)object).getReconnectInterval()) == 0) {
                n3 = 30;
            }
            n2 = 1;
            while (true) {
                block37: {
                    this.closeSocket(true);
                    ++this.m_nReconnectAttempts;
                    if (n2 > 1) {
                        if (this.log.canLog(2)) {
                            this.log.timing("Reconnect attempt " + n2 + " of " + sessionStatusResponseParcel + " waiting " + n3 + " seconds for connection: " + this);
                        }
                        Utility.sleepForSeconds(n3);
                    }
                    this.log.error("Reconnect attempt " + n2 + " of " + sessionStatusResponseParcel + " for connection: " + this);
                    try {
                        this.createSocketConnection();
                    }
                    catch (SQLException sQLException2) {
                        if (n2 == sessionStatusResponseParcel) {
                            throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException2);
                        }
                        break block37;
                    }
                    GenericLogonController.Reconnect sQLException3 = new GenericLogonController.Reconnect();
                    sQLException3.nAuthenticationNonce = this.m_con.readAuthenticationNonce();
                    sQLException3.nRequestNumber = this.m_con.getCurrentRequestNum();
                    GenericLogonController genericLogonController = new GenericLogonController(this.m_con);
                    genericLogonController.setReconnect(sQLException3);
                    try {
                        genericLogonController.run();
                        break;
                    }
                    catch (SQLException sQLException4) {
                        this.close();
                        if (n2 != sessionStatusResponseParcel && "08S01".equals(sQLException4.getSQLState())) break block37;
                        throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException4);
                    }
                }
                n2 += 1;
            }
            try {
                this.m_bSkipFrame = true;
                try {
                    tDPacket.getBuffer().readStream(this, tDStatement, 0, true);
                }
                finally {
                    this.m_bSkipFrame = false;
                }
            }
            catch (SQLException sQLException5) {
                this.close();
                throw TDNetworkIOIF.makeReconnectException("TJ593", iOException, sQLException5);
            }
        }
        finally {
            this.m_bReconnectInProgress = false;
        }
        tDPacket.initParcelFactory(this.m_con);
        object = null;
        Object var8_10 = null;
        Object object2 = null;
        block18: while ((object2 = tDPacket.nextParcel()) != null) {
            switch (((Parcel)object2).getFlavor()) {
                case 12: {
                    continue block18;
                }
                case 9: 
                case 49: {
                    object = (ErrorParcel)object2;
                    continue block18;
                }
                case 195: {
                    SessionStatusResponseParcel sessionStatusResponseParcel = (SessionStatusResponseParcel)object2;
                    continue block18;
                }
            }
            throw TDNetworkIOIF.makeReconnectException("TJ592", iOException, ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object2).getFlavor())));
        }
        object2 = null;
        int n4 = n2 = var8_11 != null && this.m_abyLastSentMsg != null ? 1 : 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("processReconnect: errorParcel=" + object + " getCode=" + (object != null ? "" + ((ErrorParcel)object).getCode() : "n/a") + " sessStatResp=" + var8_11 + " m_abyLastSentMsg=" + this.m_abyLastSentMsg + " bAttemptRecoverableNP=" + (n2 != 0));
        }
        if (n2 != 0) {
            int n5;
            int n6;
            byte by = this.m_abyLastSentMsg[2];
            int n7 = ByteConverter.getInt(this.m_abyLastSentMsg, 32);
            int n8 = var8_11.getRedriveOrNewRequestOK();
            boolean bl2 = var8_11.getRequestState(n7) != null;
            boolean bl3 = false;
            if (n8 == 0 && by == 5 && this.m_abyLastSentMsg.length >= 54 && Parcel.trueFlavor((short)(n6 = ByteConverter.getShort(this.m_abyLastSentMsg, 52))) == 128 && this.m_abyLastSentMsg.length >= 52 + (n5 = Parcel.calculateHeaderLength(Parcel.isAPH((short)n6))) + 2) {
                short s = ByteConverter.getShort(this.m_abyLastSentMsg, 52 + n5);
                boolean bl4 = bl3 = s > 1;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("processReconnect: nLastSentRequestNumber=" + n7 + " nLastSentMsgKind=" + by + (by == 5 ? " (COPKINDSTART)" : "") + (by == 13 ? " (COPKINDELICIT)" : "") + " m_nRecoverableNetworkState=" + this.m_nRecoverableNetworkState + " nRedriveOrNewRequestOK=" + n8 + " bIsKnownRequest=" + bl2 + " bMultiTSRContinuation=" + bl3);
            }
            if (by == 5 && bl2 && n8 == 1) {
                this.log.debug("processReconnect: condition 1");
                this.sendElicitStartResp(tDStatement, bl, n7);
                return this.read(bufferContainer, n, tDStatement, bl);
            }
            if (by == 13 && bl2 && n8 == 1) {
                this.log.debug("processReconnect: condition 2");
                this.sendElicitStartResp(tDStatement, bl, n7);
                n6 = this.read(bufferContainer, n, tDStatement, bl);
                int n9 = n5 = n6 >= 52 && bufferContainer.getBuffer()[2] == 13 ? 1 : 0;
                if (n5 == 0) {
                    return n6;
                }
                this.sendUCAbort(tDStatement, bl, n7);
                this.read(bufferContainer, n, tDStatement, bl);
            } else {
                if (!(this.m_nRecoverableNetworkState != 0 || by != 5 && by != 6 || bl3)) {
                    this.log.debug("processReconnect: condition 3");
                    ByteConverter.putLong(this.m_abyLastSentMsg, 24, this.m_con.getAuthenticationNonce());
                    this.write(this.m_abyLastSentMsg, tDStatement, bl);
                    return this.read(bufferContainer, n, tDStatement, bl);
                }
                if (this.m_nRecoverableNetworkState == 1 && !bl2 && n8 == 1) {
                    this.log.debug("processReconnect: condition 4");
                    return 0;
                }
            }
            object2 = ErrorFactory.makeDriverJDBCException("TJ761", TDNetworkIOIF.messageTitle(this.m_abyLastSentMsg, ""));
        }
        SQLException sQLException6 = sQLException = object != null ? TDNetworkIOIF.makeReconnectException("TJ592", iOException, ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object).getMsg(), ((ErrorParcel)object).getCode())) : TDNetworkIOIF.makeReconnectException("TJ591", iOException, null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("processReconnect: reconnectEx=" + sQLException + " exRecoveryNotPossible=" + object2);
        }
        if (object2 != null) {
            sQLException.setNextException((SQLException)object2);
        }
        throw sQLException;
    }

    private static SQLException makeReconnectException(String string, IOException iOException, SQLException sQLException) {
        SQLException sQLException2 = ErrorFactory.makeDriverJDBCException(string);
        sQLException2.initCause(iOException);
        if (sQLException != null) {
            sQLException2.setNextException(sQLException);
        }
        return sQLException2;
    }

    private void processControlData(TDPacketStream tDPacketStream, TDStatement tDStatement, boolean bl) throws SQLException {
        LanHeader lanHeader = new LanHeader(tDPacketStream);
        int n = lanHeader.getControlDataLength();
        if (n == 0) {
            return;
        }
        int n2 = 52 + lanHeader.getMsgLength();
        int n3 = n2 - n;
        block11: while (n3 < n2) {
            Parcel parcel;
            short s = Parcel.trueFlavor(tDPacketStream.getShort(n3));
            tDPacketStream.position(n3);
            switch (s) {
                case 197: {
                    this.log.debug("processControlData: creating a ControlDataStartParcel");
                    parcel = new ControlDataStartParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    if (((ControlDataStartParcel)parcel).getControlDataLength() == n) continue block11;
                    this.log.error("ControlData length mismatch: Message header value: " + n + " ControlDataStartParcel value:" + ((ControlDataStartParcel)parcel).getControlDataLength());
                    continue block11;
                }
                case 198: {
                    this.log.debug("processControlData: creating a ControlDataEndParcel");
                    parcel = new ControlDataEndParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    if (((ControlDataEndParcel)parcel).getControlDataLength() == n) continue block11;
                    this.log.error("ControlData length mismatch: Message header value: " + n + " ControlDataEndParcel value:" + ((ControlDataEndParcel)parcel).getControlDataLength());
                    continue block11;
                }
                case 200: {
                    this.log.debug("processControlData: creating a RecoverableProtocolParcel");
                    parcel = new RecoverableProtocolParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    continue block11;
                }
                case 196: {
                    this.log.debug("processControlData: creating a ContinueContextParcel");
                    parcel = new ContinueContextParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    if (tDStatement == null) continue block11;
                    tDStatement.setContinueContext((ContinueContextParcel)parcel);
                    continue block11;
                }
                case 201: {
                    this.log.debug("processControlData: creating a RedriveParcel");
                    parcel = new RedriveParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifyRedrive((RedriveParcel)parcel);
                    continue block11;
                }
                case 204: {
                    this.log.debug("processControlData: creating a RedriveSupportedParcel");
                    parcel = new RedriveSupportedParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifyRedriveSupported((RedriveSupportedParcel)parcel);
                    continue block11;
                }
                case 214: {
                    this.log.debug("processControlData: creating a RecoverableNPSupportedParcel");
                    parcel = new RecoverableNPSupportedParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifyRecoverableNPSupported((RecoverableNPSupportedParcel)parcel);
                    continue block11;
                }
                case 202: {
                    this.log.debug("processControlData: creating a AckRequestedParcel");
                    parcel = new AckRequestedParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_nRecoverableNetworkState = 1;
                    this.sendAck(tDStatement, bl, lanHeader.getRequestNo());
                    continue block11;
                }
                case 206: {
                    this.log.debug("processControlData: creating a SecurityPolicyParcel");
                    parcel = new SecurityPolicyParcel(tDPacketStream, this.m_con);
                    n3 += parcel.getLength();
                    this.m_con.notifySecurityPolicy((SecurityPolicyParcel)parcel);
                    continue block11;
                }
            }
            this.log.debug("processControlData: unknown parcel");
            parcel = new UnknownParcel(tDPacketStream, this.m_con);
            n3 += parcel.getLength();
        }
    }

    private void sendAck(TDStatement tDStatement, boolean bl, int n) throws SQLException {
        TDPacket tDPacket = this.m_con.createPacket(1);
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)2);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)15);
        this.sendPacket(tDPacket, tDStatement, bl);
        tDPacket.clear();
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)1);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)6);
        tDPacket.addParcel(new CancelParcel(this.m_con));
        this.sendPacket(tDPacket, tDStatement, bl);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this, tDStatement, 0, bl);
    }

    private void sendElicitStartResp(TDStatement tDStatement, boolean bl, int n) throws SQLException {
        TDPacket tDPacket = this.m_con.createPacket(1);
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)1);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)14);
        int n2 = 0;
        ControlDataStartParcel controlDataStartParcel = new ControlDataStartParcel(this.m_con);
        n2 += controlDataStartParcel.getLength();
        RecoverableProtocolParcel recoverableProtocolParcel = new RecoverableProtocolParcel(this.m_con);
        n2 += recoverableProtocolParcel.getLength();
        ControlDataEndParcel controlDataEndParcel = new ControlDataEndParcel(this.m_con);
        controlDataStartParcel.setControlDataLength(n2 += controlDataEndParcel.getLength());
        controlDataEndParcel.setControlDataLength(n2);
        tDPacket.addParcel(controlDataStartParcel);
        tDPacket.addParcel(recoverableProtocolParcel);
        tDPacket.addParcel(controlDataEndParcel);
        tDPacket.setControlDataLength(n2);
        this.sendPacket(tDPacket, tDStatement, bl);
    }

    private void sendUCAbort(TDStatement tDStatement, boolean bl, int n) throws SQLException {
        TDPacket tDPacket = this.m_con.createPacket(1);
        tDPacket.setInitParcelPosition();
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        tDPacket.setLANClass((byte)1);
        tDPacket.setRequestNumber(n);
        tDPacket.setLANKind((byte)7);
        tDPacket.addParcel(new AbortUCParcel(this.m_con));
        this.sendPacket(tDPacket, tDStatement, bl);
    }

    public void sendPacket(TDPacket tDPacket, TDStatement tDStatement, boolean bl) throws SQLException {
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this, tDStatement, bl);
    }

    public static class WorkerThreadList {
        private List m_listCompletedThreads = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List waitForThreads(long l) {
            boolean bl = false;
            try {
                long l2 = System.currentTimeMillis();
                while (this.m_listCompletedThreads.isEmpty()) {
                    long l3;
                    if (l == 0L) {
                        l3 = 0L;
                    } else {
                        long l4 = l2 + l;
                        l3 = l4 - System.currentTimeMillis();
                        if (l3 <= 0L) break;
                    }
                    try {
                        this.wait(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                List list = this.m_listCompletedThreads;
                this.m_listCompletedThreads = new ArrayList();
                List list2 = list;
                return list2;
            }
            finally {
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public synchronized void reportCompletion(Thread thread) {
            this.m_listCompletedThreads.add(thread);
            this.notify();
        }
    }

    public static class ConnectThread
    extends Thread {
        private Log m_log;
        private URLParameters m_urlParams;
        private boolean m_bKeepAlive;
        private boolean m_bNoDelay;
        private Integer m_nReceive;
        private Integer m_nSend;
        private boolean m_bLinger;
        private int m_nLinger;
        private Integer m_nTraffic;
        public InetSocketAddress m_isa;
        public int m_nTimeoutMs;
        public boolean m_bUseHTTPS;
        private SSLSocketFactory m_socketFactory;
        private List<Socket> m_listSockets;
        private WorkerThreadList m_workerThreadList;
        public Socket m_socket;
        public boolean m_bHTTPSFailure;
        public Throwable m_ex;
        public Date m_dateFailure;
        public long m_nElapsedTime;
        public String m_sProxyUsed;
        public String m_sCertStatus;
        public InputStream m_inStream;
        public OutputStream m_outStream;

        public ConnectThread(Log log, URLParameters uRLParameters, boolean bl, boolean bl2, Integer n, Integer n2, boolean bl3, int n3, Integer n4, InetSocketAddress inetSocketAddress, int n5, boolean bl4, SSLSocketFactory sSLSocketFactory, List<Socket> list, WorkerThreadList workerThreadList) {
            this.m_log = log;
            this.m_urlParams = uRLParameters;
            this.m_bKeepAlive = bl;
            this.m_bNoDelay = bl2;
            this.m_nReceive = n;
            this.m_nSend = n2;
            this.m_bLinger = bl3;
            this.m_nLinger = n3;
            this.m_nTraffic = n4;
            this.m_isa = inetSocketAddress;
            this.m_nTimeoutMs = n5;
            this.m_bUseHTTPS = bl4;
            this.m_socketFactory = sSLSocketFactory;
            this.m_listSockets = list;
            this.m_workerThreadList = workerThreadList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = System.currentTimeMillis();
            try {
                String[] stringArray = new String[1];
                this.m_socket = ProxySupport.connectSocket(this.m_log, this.m_urlParams, this.m_bKeepAlive, this.m_bNoDelay, this.m_nReceive, this.m_nSend, this.m_bLinger, this.m_nLinger, this.m_nTraffic, this.m_isa, this.m_nTimeoutMs, this.m_bUseHTTPS ? "https" : "socket", this.m_socketFactory, stringArray, this.m_listSockets);
                this.m_sProxyUsed = stringArray[0];
                this.m_outStream = this.m_socket.getOutputStream();
                this.m_inStream = this.m_socket.getInputStream();
            }
            catch (Throwable throwable) {
                this.m_bHTTPSFailure = throwable instanceof SSLException;
                this.m_ex = throwable;
                this.m_dateFailure = new Date();
            }
            finally {
                this.m_nElapsedTime = System.currentTimeMillis() - l;
            }
            this.m_workerThreadList.reportCompletion(this);
        }
    }

    public static class Lookup {
        private GenericTeradataConnection m_conn;
        private String m_sHostName;
        private boolean m_bLookupDone = false;
        private InetAddress[] m_aAddrs = null;
        private UnknownHostException m_exUnk = null;
        private SecurityException m_exSec = null;

        public Lookup(GenericTeradataConnection genericTeradataConnection, String string) {
            this.m_conn = genericTeradataConnection;
            this.m_sHostName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void doLookup() throws SQLException {
            if (this.m_bLookupDone) {
                return;
            }
            this.m_bLookupDone = true;
            this.m_conn.checkRemainingLoginTime();
            long l = System.currentTimeMillis();
            try {
                this.m_aAddrs = InetAddress.getAllByName(this.m_sHostName);
            }
            catch (UnknownHostException unknownHostException) {
                this.m_exUnk = unknownHostException;
                if (this.m_conn.getLog().canLog(2)) {
                    this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                }
            }
            catch (SecurityException securityException) {
                this.m_exSec = securityException;
                if (this.m_conn.getLog().canLog(2)) {
                    this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                }
                {
                    catch (Throwable throwable) {
                        if (this.m_conn.getLog().canLog(2)) {
                            this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                        }
                        throw throwable;
                    }
                }
            }
            if (this.m_conn.getLog().canLog(2)) {
                this.m_conn.getLog().timing("Hostname lookup for " + this.m_sHostName + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
            }
        }

        public boolean isLiteralIpAddress() throws SQLException {
            if (this.m_sHostName.length() > 0 && Character.isLetter(this.m_sHostName.charAt(0)) && this.m_sHostName.indexOf(58) < 0) {
                return false;
            }
            this.doLookup();
            return this.m_aAddrs != null && this.m_aAddrs.length > 0 && this.m_aAddrs[0].toString().startsWith("/");
        }

        public InetAddress[] getAddresses() throws SecurityException, SQLException, UnknownHostException {
            this.doLookup();
            if (this.m_exUnk != null) {
                throw this.m_exUnk;
            }
            if (this.m_exSec != null) {
                throw this.m_exSec;
            }
            return this.m_aAddrs;
        }
    }
}

