/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.asn1.der;

import com.teradata.tdgss.asn1.der.DER;
import com.teradata.tdgss.asn1.der.DERASN1Type;
import com.teradata.tdgss.asn1.der.DERException;
import com.teradata.tdgss.asn1.der.DERLength;
import com.teradata.tdgss.asn1.der.DERTag;
import com.teradata.tdgss.asn1.der.DERUniversalTagOctets;
import com.teradata.tdgss.asn1.der.ListArray;
import java.util.Arrays;

class DERSequence
extends DERASN1Type {
    private ListArray value;
    private final boolean implicitEncoding = true;

    DERSequence(ListArray listArray) {
        this.value = listArray;
        this.octets = this.calcOctets(this.value);
    }

    DERSequence(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    DERSequence(byte[] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    DERSequence(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, true);
    }

    DERSequence(byte[] byArray, int n, int n2, boolean bl) {
        this.parse(byArray, n, n2, bl);
    }

    @Override
    protected void parse(byte[] byArray, int n, int n2, boolean bl) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new DERException("Illegal values are passed.");
        }
        if (bl) {
            this.octets = new byte[n2];
            System.arraycopy(byArray, n, this.octets, 0, n2);
            this.value = this.getValueOf(this.octets);
        } else {
            this.parseExplicitOctets(byArray, n);
        }
    }

    @Override
    protected final void parseExplicitOctets(byte[] byArray, int n) {
        DER dER;
        byte[] byArray2 = new DERTag(byArray, n).getTagOctets();
        if (!Arrays.equals(byArray2, this.getUniveralTagOctets())) {
            throw new DERException("Invalid Universal tag octets.");
        }
        DERLength dERLength = new DERLength(byArray, n += byArray2.length);
        this.value = new ListArray(DER.class);
        for (int i = n += dERLength.size(); i < byArray.length; i += dER.size(false)) {
            dER = new DER(byArray, i, false);
            this.value.add(dER);
        }
        this.octets = ((DER)this.value.get(0)).getEncodedValue(this.implicitEncoding);
        for (int i = 1; i < this.value.size(); ++i) {
            this.octets = super.concat(this.octets, ((DER)this.value.get(i)).getEncodedValue(this.implicitEncoding));
        }
    }

    @Override
    byte[] getUniveralTagOctets() {
        return DERUniversalTagOctets.SEQUENCE;
    }

    private final byte[] calcOctets(ListArray listArray) {
        byte[] byArray = null;
        if (this.value.size() > 0) {
            byArray = ((DER)listArray.get(0)).getEncodedValue(this.implicitEncoding);
        }
        for (int i = 1; i < this.value.size(); ++i) {
            byArray = super.concat(byArray, ((DER)listArray.get(i)).getEncodedValue(this.implicitEncoding));
        }
        return byArray;
    }

    private final ListArray getValueOf(byte[] byArray) {
        DER dER;
        ListArray listArray = new ListArray(DER.class);
        for (int i = 0; i < byArray.length; i += dER.size()) {
            dER = new DER(byArray, i);
            listArray.add(dER);
        }
        return listArray;
    }

    DER getElementAt(int n) {
        return (DER)this.value.get(n);
    }

    DER getElementWithTag(int n) {
        for (int i = 0; i < this.value.size(); ++i) {
            DER dER = (DER)this.value.get(i);
            if (dER.getTagNumber() != n) continue;
            return dER;
        }
        return null;
    }

    ListArray getValue() {
        return this.value;
    }

    @Override
    protected byte[] getOctets(boolean bl) {
        if (bl) {
            return this.octets;
        }
        byte[] byArray = ((DER)this.value.get(0)).getEncodedValue(bl);
        for (int i = 1; i < this.value.size(); ++i) {
            byArray = super.concat(byArray, ((DER)this.value.get(i)).getEncodedValue(bl));
        }
        return this.getExplicitOctets(byArray);
    }

    private final byte[] getExplicitOctets(byte[] byArray) {
        byte[] byArray2 = this.getUniveralTagOctets();
        byte[] byArray3 = new DERLength(byArray.length).getLengthOctets();
        byte[] byArray4 = super.concat(byArray2, byArray3);
        return this.concat(byArray4, byArray);
    }

    final boolean add(DER dER) {
        this.octets = this.value.size() == 0 ? dER.getEncodedValue(this.implicitEncoding) : super.concat(this.octets, dER.getEncodedValue(this.implicitEncoding));
        this.value.add(dER);
        return true;
    }

    @Override
    protected boolean isConstructed() {
        return true;
    }
}

