/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.LocatorBlob;
import com.teradata.jdbc.LocatorClob;
import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.TDStatement;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.statemachine.RSSelectionContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.security.Security;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TeraDriver
implements Driver {
    protected static Log sm_log = new Log("TeraDriver/" + TeraDriver.class.getClassLoader());
    public static final String DEFAULT_CONN_PREFIX = "jdbc:default:connection";
    public static final String REMOTE_CONN_PREFIX = "jdbc:teradata://";
    private static Hashtable ioTable = new Hashtable();
    private static final int FORMAT_TEXT = 1;
    private static final int FORMAT_RAW = 2;
    private static final int FORMAT_CSV = 3;
    private static Calendar DUMMY_CALENDAR;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        return TeraDriver.doConnect(string, properties);
    }

    private static Connection doConnect(String string, Properties properties) throws SQLException {
        Connection connection;
        String string2;
        String string3;
        if (!TeraDriver.doAcceptsURL(string)) {
            return null;
        }
        boolean bl = string.startsWith(DEFAULT_CONN_PREFIX);
        String string4 = "";
        String string5 = bl ? DEFAULT_CONN_PREFIX : REMOTE_CONN_PREFIX;
        String string6 = string.substring(string5.length());
        int n = string6.indexOf("/");
        if (n >= 0) {
            string3 = string6.substring(0, n);
            string4 = string6.substring(n + 1);
        } else {
            string3 = string6.trim();
            string4 = "";
        }
        if (string3.startsWith("[") && string3.endsWith("]")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (properties != null && properties.containsKey("username")) {
            boolean bl2;
            string2 = (String)properties.remove("username");
            boolean bl3 = bl2 = !properties.containsKey("user");
            if (bl2) {
                properties.setProperty("user", string2);
            }
        }
        URLParameters uRLParameters = new URLParameters(string4, properties);
        string2 = uRLParameters.getUser();
        String string7 = uRLParameters.getPassword();
        if (string2 == null) {
            string2 = "";
        }
        if (string7 == null) {
            string7 = "";
        }
        uRLParameters.setJavaSPDefaultConnection(bl);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        if (uRLParameters.isJavaSPDefaultConnection() && currentThreadIO == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ496");
        }
        if (uRLParameters.isJavaSPDefaultConnection() && "DEBUG".equalsIgnoreCase((String)currentThreadIO.getOptions().get("LOG"))) {
            uRLParameters.setLogLevel("DEBUG");
        }
        Connection connection2 = connection = uRLParameters.isJavaSPDefaultConnection() && currentThreadIO.getConnection() != null ? currentThreadIO.getConnection() : ConnectionFactory.createConnection(string3, string2, string7, uRLParameters);
        if (uRLParameters.isJavaSPDefaultConnection()) {
            TDSession tDSession = (TDSession)connection;
            if (currentThreadIO.getConnection() == null) {
                currentThreadIO.setConnection(connection);
                Integer n2 = (Integer)currentThreadIO.getOptions().get("SPReturnResult");
                if (n2 != null) {
                    tDSession.setSPReturnResult(n2.byteValue());
                }
                if (tDSession.getLog().isDebugEnabled()) {
                    tDSession.getLog().debug("options SPReturnResult=" + n2 + ", session getSPReturnResult=" + tDSession.getSPReturnResult());
                }
            }
            tDSession.updateURLParameters(uRLParameters);
        }
        return connection;
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return TeraDriver.doAcceptsURL(string);
    }

    private static boolean doAcceptsURL(String string) {
        return string != null && (string.startsWith(DEFAULT_CONN_PREFIX) || string.startsWith(REMOTE_CONN_PREFIX));
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = properties != null && properties.containsKey("username") ? "username" : "user";
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, null);
        driverPropertyInfo.required = true;
        driverPropertyInfo.description = ErrorMessage.messages.getString("TJ401");
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", null);
        driverPropertyInfo2.required = true;
        driverPropertyInfo2.description = ErrorMessage.messages.getString("TJ402");
        return new DriverPropertyInfo[]{driverPropertyInfo, driverPropertyInfo2};
    }

    @Override
    public int getMajorVersion() {
        return 20;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static void setCurrentThreadDefaultConnection(InputStream inputStream, OutputStream outputStream, Map map) throws SQLException {
        CurrentThreadIO currentThreadIO = new CurrentThreadIO(inputStream, outputStream, map);
        ioTable.put(Thread.currentThread(), currentThreadIO);
        TeraDriver.doConnect(DEFAULT_CONN_PREFIX, new Properties());
    }

    public static CurrentThreadIO getCurrentThreadDefaultConnection() {
        return (CurrentThreadIO)ioTable.get(Thread.currentThread());
    }

    public static Clob createDefaultConnectionClob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorClob(l, byArray2, false);
    }

    public static byte[] getClobLocator(Clob clob) throws SQLException {
        LocatorClob locatorClob = (LocatorClob)clob;
        byte[] byArray = locatorClob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Object createDefaultConnectionSQLXML(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorSQLXML((short)860, l, byArray2);
    }

    public static byte[] getSQLXMLLocator(Object object) throws SQLException {
        byte[] byArray = ((TeraSQLXML)object).getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static Blob createDefaultConnectionBlob(byte[] byArray) {
        long l = ByteConverter.getLong(byArray, 0);
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        return tDSession.constructLocatorBlob(l, byArray2, false);
    }

    public static byte[] getBlobLocator(Blob blob) throws SQLException {
        LocatorBlob locatorBlob = (LocatorBlob)blob;
        byte[] byArray = locatorBlob.getLocator();
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDynamicResultSets(ResultSet[] resultSetArray, Integer n) throws SQLException {
        AutoCloseable autoCloseable;
        CurrentThreadIO currentThreadIO = TeraDriver.getCurrentThreadDefaultConnection();
        Log log = ((TDSession)currentThreadIO.getConnection()).getLog();
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " total number of result sets is: " + (resultSetArray == null ? 0 : resultSetArray.length));
        }
        ArrayList<ResultSetSelectionItem> arrayList = new ArrayList<ResultSetSelectionItem>();
        for (int i = 0; resultSetArray != null && i < resultSetArray.length; ++i) {
            if (resultSetArray[i] == null || (autoCloseable = (TDResultSet)resultSetArray[i]) == null || ((TDResultSet)autoCloseable).isClosed()) continue;
            long l = ((TDResultSet)autoCloseable).getDynamicResultSetCurrentRowNumber();
            if (log.isDebugEnabled()) {
                log.debug("closeDynamicResultSets reqnum=" + n + " adding rs[" + i + "]" + " reqnum=" + ((TDResultSet)autoCloseable).getRequestNumber() + " stmtnum=" + ((TDResultSet)autoCloseable).getStatementNumber() + " row=" + l);
            }
            arrayList.add(new ResultSetSelectionItem(((TDResultSet)autoCloseable).getStatementNumber(), ((TDResultSet)autoCloseable).getRequestNumber(), l));
            ((TDResultSet)autoCloseable).suppressResponseCancel();
        }
        if (log.isDebugEnabled()) {
            log.debug("closeDynamicResultSets reqnum=" + n + " number of open result sets: " + arrayList.size());
        }
        TDSession tDSession = (TDSession)currentThreadIO.getConnection();
        autoCloseable = (TDStatement)tDSession.createStatement();
        StatementController statementController = new StatementController((TDStatement)autoCloseable, tDSession, null);
        statementController.setCurrentRequestNumber(n);
        StatementReceiveState statementReceiveState = new StatementReceiveState(statementController);
        statementReceiveState.setRequestNum(n);
        statementController.setHistoricalState(new RSSelectionContinueState(statementController, statementReceiveState, arrayList));
        tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.run();
        }
        finally {
            tDSession.releaseSessionLock();
        }
    }

    private static String quoteText(String string) {
        return string == null ? "null" : "\"" + string.replaceAll("[\r\n]+", " ").replaceAll("\"", "\"\"") + "\"";
    }

    private static String quoteCsvText(String string) {
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "\"\"";
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c >= ' ' && c != ',' && c != '\"') continue;
            return "\"" + string.replaceAll("\"", "\"\"") + "\"";
        }
        return string;
    }

    private static String formatValue(int n, boolean bl, int n2, String string, String string2) {
        if (n == 1) {
            return string + " = " + TeraDriver.quoteText(string2);
        }
        if (n == 2) {
            return (bl ? string + "=" : (n2 > 1 ? " " : "")) + (string2 == null ? "null" : string2.replaceAll("[\r\n]+", "\n"));
        }
        return (n2 > 1 ? "," : "") + (string2 == null ? "" : TeraDriver.quoteCsvText(string2));
    }

    private static void printValue(PrintWriter printWriter, int n, boolean bl, int n2, int n3, String string, String string2) {
        boolean bl2;
        String string3 = TeraDriver.formatValue(n, bl, n2, string, string2);
        boolean bl3 = n == 1 || n == 2 && bl;
        boolean bl4 = bl2 = n2 >= n3;
        if (bl3 || bl2) {
            printWriter.println(string3);
        } else {
            printWriter.print(string3);
        }
    }

    private static void printArray(PrintWriter printWriter, int n, boolean bl, String[][] stringArray) {
        int n2;
        String[] stringArray2 = stringArray[0];
        for (int i = n2 = n == 3 ? 0 : 1; i < stringArray.length; ++i) {
            String[] stringArray3 = stringArray[i];
            for (int j = 1; j <= stringArray3.length; ++j) {
                TeraDriver.printValue(printWriter, n, bl, j, stringArray3.length, stringArray2[j - 1], stringArray3[j - 1]);
            }
        }
    }

    private static void printNameValue(PrintWriter printWriter, int n, String string, String string2) {
        TeraDriver.printArray(printWriter, n, false, new String[][]{{string}, {string2}});
    }

    private static void printProps(PrintWriter printWriter, int n, Properties properties) {
        Map.Entry[] entryArray = properties == null ? new Map.Entry[]{} : properties.entrySet().toArray(new Map.Entry[0]);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                Comparable comparable = (Comparable)entry.getKey();
                Comparable comparable2 = (Comparable)entry2.getKey();
                return comparable.compareTo(comparable2);
            }
        });
        String[][] stringArray = new String[][]{new String[entryArray.length], new String[entryArray.length]};
        for (int i = 0; i < entryArray.length; ++i) {
            stringArray[0][i] = (String)entryArray[i].getKey();
            stringArray[1][i] = (String)entryArray[i].getValue();
        }
        if (n == 1) {
            printWriter.println("(Properties " + (properties == null ? "null" : "" + entryArray.length) + ")");
        }
        TeraDriver.printArray(printWriter, n, true, stringArray);
    }

    private static String formatCsvHeader(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        return resultSetMetaData.getColumnName(n) + (bl ? " " + resultSetMetaData.getColumnTypeName(n) + (resultSetMetaData.getColumnType(n) == -2 ? "(" + resultSetMetaData.getPrecision(n) + ")" : "") + (resultSetMetaData.getColumnType(n) == 3 ? "(" + resultSetMetaData.getPrecision(n) + (resultSetMetaData.getScale(n) != 0 ? "," + resultSetMetaData.getScale(n) : "") + ")" : "") : "");
    }

    private static String formatAsHexDigits(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i] & 0xFF);
            string = string + (string2.length() < 2 ? "0" : "") + string2;
        }
        return string;
    }

    private static byte[] parseHexDigits(String string) {
        boolean bl;
        if (string == null) {
            return null;
        }
        boolean bl2 = bl = (string.length() & 1) == 1;
        if (bl) {
            throw new IllegalArgumentException("Odd number of hex digits: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return byArray;
    }

    private static String stringify(Object object) {
        return object == null ? null : object.toString();
    }

    private static void printParameterMetaData(PrintWriter printWriter, int n, Map<String, Boolean> map, ParameterMetaData parameterMetaData) throws SQLException {
        if (!map.values().contains(true)) {
            return;
        }
        for (int i = 1; i <= parameterMetaData.getParameterCount(); ++i) {
            int n2;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            if (map.get("getParameterClassName").booleanValue()) {
                linkedHashMap.put("getParameterClassName", TeraDriver.stringify(parameterMetaData.getParameterClassName(i)));
            }
            if (map.get("getParameterMode").booleanValue()) {
                linkedHashMap.put("getParameterMode", TeraDriver.stringify(parameterMetaData.getParameterMode(i)));
            }
            if (map.get("getParameterType").booleanValue()) {
                linkedHashMap.put("getParameterType", TeraDriver.stringify(parameterMetaData.getParameterType(i)));
            }
            if (map.get("getParameterTypeName").booleanValue()) {
                linkedHashMap.put("getParameterTypeName", TeraDriver.stringify(parameterMetaData.getParameterTypeName(i)));
            }
            if (map.get("getPrecision").booleanValue()) {
                linkedHashMap.put("getPrecision", TeraDriver.stringify(parameterMetaData.getPrecision(i)));
            }
            if (map.get("getScale").booleanValue()) {
                linkedHashMap.put("getScale", TeraDriver.stringify(parameterMetaData.getScale(i)));
            }
            if (map.get("isNullable").booleanValue()) {
                linkedHashMap.put("isNullable", TeraDriver.stringify(parameterMetaData.isNullable(i)));
            }
            if (map.get("isSigned").booleanValue()) {
                linkedHashMap.put("isSigned", TeraDriver.stringify(parameterMetaData.isSigned(i)));
            }
            ArrayList arrayList = new ArrayList(linkedHashMap.entrySet());
            if (n == 3 && i == 1) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), null, (String)((Map.Entry)arrayList.get(n2)).getKey());
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), (String)((Map.Entry)arrayList.get(n2)).getKey() + "(" + i + ")", (String)((Map.Entry)arrayList.get(n2)).getValue());
            }
        }
    }

    private static void printResultSetMetaData(PrintWriter printWriter, int n, Map<String, Boolean> map, ResultSetMetaData resultSetMetaData) throws SQLException {
        if (!map.values().contains(true)) {
            return;
        }
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n2;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            if (map.get("getCatalogName").booleanValue()) {
                linkedHashMap.put("getCatalogName", TeraDriver.stringify(resultSetMetaData.getCatalogName(i)));
            }
            if (map.get("getColumnClassName").booleanValue()) {
                linkedHashMap.put("getColumnClassName", TeraDriver.stringify(resultSetMetaData.getColumnClassName(i)));
            }
            if (map.get("getColumnDisplaySize").booleanValue()) {
                linkedHashMap.put("getColumnDisplaySize", TeraDriver.stringify(resultSetMetaData.getColumnDisplaySize(i)));
            }
            if (map.get("getColumnLabel").booleanValue()) {
                linkedHashMap.put("getColumnLabel", TeraDriver.stringify(resultSetMetaData.getColumnLabel(i)));
            }
            if (map.get("getColumnName").booleanValue()) {
                linkedHashMap.put("getColumnName", TeraDriver.stringify(resultSetMetaData.getColumnName(i)));
            }
            if (map.get("getColumnType").booleanValue()) {
                linkedHashMap.put("getColumnType", TeraDriver.stringify(resultSetMetaData.getColumnType(i)));
            }
            if (map.get("getColumnTypeName").booleanValue()) {
                linkedHashMap.put("getColumnTypeName", TeraDriver.stringify(resultSetMetaData.getColumnTypeName(i)));
            }
            if (map.get("getPrecision").booleanValue()) {
                linkedHashMap.put("getPrecision", TeraDriver.stringify(resultSetMetaData.getPrecision(i)));
            }
            if (map.get("getScale").booleanValue()) {
                linkedHashMap.put("getScale", TeraDriver.stringify(resultSetMetaData.getScale(i)));
            }
            if (map.get("getSchemaName").booleanValue()) {
                linkedHashMap.put("getSchemaName", TeraDriver.stringify(resultSetMetaData.getSchemaName(i)));
            }
            if (map.get("getTableName").booleanValue()) {
                linkedHashMap.put("getTableName", TeraDriver.stringify(resultSetMetaData.getTableName(i)));
            }
            if (map.get("isAutoIncrement").booleanValue()) {
                linkedHashMap.put("isAutoIncrement", TeraDriver.stringify(resultSetMetaData.isAutoIncrement(i)));
            }
            if (map.get("isCaseSensitive").booleanValue()) {
                linkedHashMap.put("isCaseSensitive", TeraDriver.stringify(resultSetMetaData.isCaseSensitive(i)));
            }
            if (map.get("isCurrency").booleanValue()) {
                linkedHashMap.put("isCurrency", TeraDriver.stringify(resultSetMetaData.isCurrency(i)));
            }
            if (map.get("isDefinitelyWritable").booleanValue()) {
                linkedHashMap.put("isDefinitelyWritable", TeraDriver.stringify(resultSetMetaData.isDefinitelyWritable(i)));
            }
            if (map.get("isNullable").booleanValue()) {
                linkedHashMap.put("isNullable", TeraDriver.stringify(resultSetMetaData.isNullable(i)));
            }
            if (map.get("isReadOnly").booleanValue()) {
                linkedHashMap.put("isReadOnly", TeraDriver.stringify(resultSetMetaData.isReadOnly(i)));
            }
            if (map.get("isSearchable").booleanValue()) {
                linkedHashMap.put("isSearchable", TeraDriver.stringify(resultSetMetaData.isSearchable(i)));
            }
            if (map.get("isSigned").booleanValue()) {
                linkedHashMap.put("isSigned", TeraDriver.stringify(resultSetMetaData.isSigned(i)));
            }
            if (map.get("isWritable").booleanValue()) {
                linkedHashMap.put("isWritable", TeraDriver.stringify(resultSetMetaData.isWritable(i)));
            }
            ArrayList arrayList = new ArrayList(linkedHashMap.entrySet());
            if (n == 3 && i == 1) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), null, (String)((Map.Entry)arrayList.get(n2)).getKey());
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                TeraDriver.printValue(printWriter, n, true, n2 + 1, arrayList.size(), (String)((Map.Entry)arrayList.get(n2)).getKey() + "(" + i + ")", (String)((Map.Entry)arrayList.get(n2)).getValue());
            }
        }
    }

    private static String stripControlChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\t' && c != '\r' && c != '\n' && (c < ' ' || c == '\u007f' || c == '\ufffd')) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static void printResultSet(PrintWriter printWriter, int n, Map<String, Boolean> map, boolean bl, boolean bl2, String string, ResultSet resultSet) throws SQLException {
        int n2;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        TeraDriver.printResultSetMetaData(printWriter, n, map, resultSetMetaData);
        if (n == 3) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), null, TeraDriver.formatCsvHeader(resultSetMetaData, n2, bl2));
            }
        }
        while (resultSet.next()) {
            for (n2 = 1; n2 <= resultSetMetaData.getColumnCount(); ++n2) {
                Comparable<Calendar> comparable;
                String string2;
                String string3 = (string != null ? string + " " : "") + "Row " + resultSet.getRow() + " Column " + n2 + " " + TeraDriver.quoteText(resultSetMetaData.getColumnName(n2)) + " " + resultSetMetaData.getColumnTypeName(n2) + "(" + resultSetMetaData.getPrecision(n2) + ")";
                if (resultSetMetaData.getColumnType(n2) == 2004 || resultSetMetaData.getColumnType(n2) == -2 || resultSetMetaData.getColumnType(n2) == -3 || resultSetMetaData.getColumnType(n2) == -4) {
                    string2 = TeraDriver.formatAsHexDigits(resultSet.getBytes(n2));
                } else if (resultSetMetaData.getColumnType(n2) == 92) {
                    comparable = resultSet.getTimestamp(n2);
                    string2 = comparable == null ? null : ((Timestamp)comparable).toString().substring("1970-01-01 ".length());
                } else {
                    string2 = resultSet.getString(n2);
                    if (string2 != null && !bl) {
                        string2 = TeraDriver.stripControlChars(string2);
                    }
                }
                if (string2 != null && resultSetMetaData.getColumnTypeName(n2).endsWith(" WITH TIME ZONE")) {
                    comparable = Calendar.getInstance();
                    resultSet.getTimestamp(n2, (Calendar)comparable);
                    string2 = string2 + TDPreparedStatement.formatTimeZone(((Calendar)comparable).getTimeZone());
                }
                TeraDriver.printValue(printWriter, n, false, n2, resultSetMetaData.getColumnCount(), string3, string2);
            }
        }
    }

    private static void printUpdateCounts(PrintWriter printWriter, int n, int[] nArray) {
        if (n == 3) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, null, "Update Counts");
        }
        for (int i = 0; i < nArray.length; ++i) {
            TeraDriver.printValue(printWriter, n, false, 1, 1, "Update count " + (i + 1), "" + nArray[i]);
        }
    }

    private static CsvHeader[] parseCsvHeaders(String[] stringArray) {
        CsvHeader[] csvHeaderArray = new CsvHeader[stringArray.length];
        block0: for (int i = 0; i < csvHeaderArray.length; ++i) {
            CsvHeader csvHeader;
            csvHeaderArray[i] = csvHeader = new CsvHeader();
            csvHeader.sHeader = stringArray[i];
            csvHeader.nType = 1111;
            if (csvHeader.sHeader == null) continue;
            for (int j = 0; j < TypeDesc.types.length; ++j) {
                Matcher matcher = Pattern.compile("(?i).* " + TypeDesc.types[j].sTypeName + "(?:\\(([0-9]+)(?:,([0-9]+))?\\))?").matcher(csvHeader.sHeader);
                if (!matcher.matches()) continue;
                csvHeader.sTypeName = TypeDesc.types[j].sTypeName;
                csvHeader.nType = TypeDesc.types[j].nType;
                csvHeader.bTimeZone = csvHeader.sTypeName.endsWith(" WITH TIME ZONE");
                if (matcher.group(2) != null) {
                    csvHeader.nScale = Integer.parseInt(matcher.group(2));
                    continue block0;
                }
                if (matcher.group(1) == null) continue block0;
                csvHeader.nScale = Integer.parseInt(matcher.group(1));
                continue block0;
            }
        }
        return csvHeaderArray;
    }

    private static String[] readCsvRow(PeekReader peekReader) throws IOException {
        if (peekReader.peek() < 0) {
            return null;
        }
        StringList stringList = new StringList();
        stringList.add(null);
        boolean bl = false;
        int n;
        while ((n = peekReader.read()) >= 0) {
            if (bl) {
                if (n != 34) {
                    stringList.append(n);
                    continue;
                }
                if (peekReader.peek() == 34) {
                    stringList.append(peekReader.read());
                    continue;
                }
                bl = false;
                continue;
            }
            if (n == 44) {
                stringList.add(null);
                continue;
            }
            if (n == 34) {
                bl = true;
                continue;
            }
            if (n == 13) continue;
            if (n == 10) {
                return stringList.toStringArray();
            }
            stringList.append(n);
        }
        return stringList.toStringArray();
    }

    private static void bindValue(PreparedStatement preparedStatement, int n, int n2, CsvHeader csvHeader, String string) {
        try {
            if (csvHeader.nType == -6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setByte(n2, Byte.parseByte(string));
                }
            } else if (csvHeader.nType == 5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setShort(n2, Short.parseShort(string));
                }
            } else if (csvHeader.nType == 4) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setInt(n2, Integer.parseInt(string));
                }
            } else if (csvHeader.nType == -5) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setLong(n2, Long.parseLong(string));
                }
            } else if (csvHeader.nType == 6) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setDouble(n2, Double.parseDouble(string));
                }
            } else if (csvHeader.nType == 3) {
                preparedStatement.setObject(n2, (Object)(string == null ? null : new BigDecimal(string)), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == 2) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setBigDecimal(n2, new BigDecimal(string));
                }
            } else if (csvHeader.nType == 2005) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    preparedStatement.setCharacterStream(n2, (Reader)new StringReader(string), string.length());
                }
            } else if (csvHeader.nType == 2004) {
                if (string == null) {
                    preparedStatement.setNull(n2, csvHeader.nType);
                } else {
                    byte[] byArray = TeraDriver.parseHexDigits(string);
                    preparedStatement.setBinaryStream(n2, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
                }
            } else if (csvHeader.nType == -2) {
                preparedStatement.setObject(n2, (Object)TeraDriver.parseHexDigits(string), csvHeader.nType, csvHeader.nScale);
            } else if (csvHeader.nType == -3 || csvHeader.nType == -4) {
                preparedStatement.setBytes(n2, TeraDriver.parseHexDigits(string));
            } else if (csvHeader.nType == 91) {
                preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
            } else if (csvHeader.nType == 92) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTime(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else if (csvHeader.nType == 93) {
                if (string == null && csvHeader.bTimeZone) {
                    preparedStatement.setTimestamp(n2, null, DUMMY_CALENDAR);
                } else {
                    preparedStatement.setObject(n2, (Object)string, csvHeader.nType);
                }
            } else {
                preparedStatement.setString(n2, string);
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error for CSV line " + n + " column " + n2 + " value: " + string);
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    private static <T> T safePeek(Stack<T> stack) {
        return stack.empty() ? null : (T)stack.peek();
    }

    private static <T> void pushDiff(Stack<T> stack, T t) {
        if (t != TeraDriver.safePeek(stack)) {
            stack.push(t);
        }
    }

    private static <T extends Closeable> void popClose(Stack<T> stack, T t) throws IOException {
        Closeable closeable = (Closeable)stack.pop();
        if (closeable != t) {
            closeable.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void main(String[] var0) throws Throwable {
        if (var0.length == 0) {
            System.err.println("Arguments: Command...");
            System.err.println("-i turns on interactive mode to prompt for commands from System.in");
            System.err.println("-im turns on interactive mode and sql:multi");
            System.err.println("-is turns on interactive mode and sql:semicolon");
            System.err.println("# begins a comment");
            System.err.println("agkr:generated returns generated keys");
            System.err.println("agkr:index,index,... returns the inserted column values corresponding to the specific column indexes");
            System.err.println("agkr:none (the default) does not use the Auto-Generated Key Retrieval feature");
            System.err.println("autocommit:off turns off autocommit");
            System.err.println("autocommit:on turns on autocommit");
            System.err.println("commit calls Connection.commit");
            System.err.println("con:name switches to the specified connection (default name is \"default\")");
            System.err.println("cont:message sets the continuation prompt to the specified message");
            System.err.println("csvline:string appends comma-separated values from the specified string for use by a subsequent parameterized SQL request");
            System.err.println("driver prints the driver name and version");
            System.err.println("echo:message prints the specified message");
            System.err.println("exit stops reading commands from the current input source");
            System.err.println("format:csv formats output as comma-separated values");
            System.err.println("format:raw avoids formatting output");
            System.err.println("format:text (the default) formats output as text");
            System.err.println("getCatalogs prints the result from DatabaseMetaData.getCatalogs");
            System.err.println("getColumns:catalog,schemaPattern,tableNamePattern,columnNamePattern prints the result from DatabaseMetaData.getColumns");
            System.err.println("getDatabaseProductVersion prints the return value from DatabaseMetaData.getDatabaseProductVersion");
            System.err.println("getDriverVersion prints the return value from DatabaseMetaData.getDriverVersion");
            System.err.println("getSchemas prints the result from DatabaseMetaData.getSchemas");
            System.err.println("getTables:catalog,schemaPattern,tableNamePattern[,tableType]... prints the result from DatabaseMetaData.getTables");
            System.err.println("getURL prints the return value from DatabaseMetaData.getURL");
            System.err.println("host= prefix begins an ignored Python driver connection string");
            System.err.println("http-header:value adds an HTTP header for the next HTTP request");
            System.err.println("http-method:value overrides the default HTTP GET method to specify the HTTP method for the next HTTP request");
            System.err.println("http-params:name=value,name=value,... specifies driver connection parameters for the next HTTP request");
            System.err.println("http://... makes an HTTP request to the specified URL");
            System.err.println("https://... makes an HTTPS request to the specified URL");
            System.err.println("ignore:nsql:all ignores all non-SQLException");
            System.err.println("ignore:nsql:none (the default) stops for any non-SQLException");
            System.err.println("ignore:sql:all ignores all SQLException");
            System.err.println("ignore:sql:code,code,... ignores SQLException with one of the specified error codes");
            System.err.println("ignore:sql:none stops for any SQLException");
            System.err.println("input:filename reads commands from the specified file until EOF");
            System.err.println("input:stdin reads commands from System.in until EOF (interactive Ctrl+Z on Windows)");
            System.err.println("jdbc: prefix calls DriverManager.getConnection for the command");
            System.err.println("list prints the open connections");
            System.err.println("lsof prints the open file handles of the JVM on Linux");
            System.err.println("nativeSQL:command calls Connection.nativeSQL for the command");
            System.err.println("output:filename sends output to specified file");
            System.err.println("output:stdout (the default) sends output to System.out");
            System.err.println("pause waits for a line from System.in");
            System.err.println("pid prints the process ID of the JVM");
            System.err.println("pmd:all prints all parameter marker metadata");
            System.err.println("pmd:function,function,... prints only the parameter marker metadata returned from the specified ParameterMetaData functions");
            System.err.println("pmd:none (the default) does not print parameter marker metadata");
            System.err.println("prompt:message sets the prompt to the specified message");
            System.err.println("prop:name=value sets the property name to value for DriverManager.getConnection");
            System.err.println("props:filename reads Properties from the specified file for DriverManager.getConnection");
            System.err.println("props:list prints the Properties for DriverManager.getConnection");
            System.err.println("props:new specifies new empty Properties for DriverManager.getConnection");
            System.err.println("props:null (the default) specifies null Properties for DriverManager.getConnection");
            System.err.println("random:b64:count prints a base64 encoded string of the specified number of random bytes");
            System.err.println("random:b64u:count prints a base64 URL encoded string of the specified number of random bytes");
            System.err.println("random:hex:count prints a hex-format string of the specified number of random bytes");
            System.err.println("readcsv:filename reads comma-separated values from the specified UTF8-encoded file for use by a subsequent parameterized SQL request");
            System.err.println("rollback calls Connection.rollback");
            System.err.println("rsmd:all prints all result set column metadata");
            System.err.println("rsmd:function,function,... prints only the result set column metadata returned from the specified ResultSetMetaData functions");
            System.err.println("rsmd:none (the default) does not print result set column metadata");
            System.err.println("Security.getProperty:name prints the specified Security property");
            System.err.println("Security.getProviders prints the list of Security providers");
            System.err.println("Security.setProperty:name=value sets the Security property name to value");
            System.err.println("setLoginTimeout:value calls DriverManager.setLoginTimeout with the specified login timeout value in seconds");
            System.err.println("sleep:ms sleeps for the specified number of milliseconds");
            System.err.println("sql:multi accepts multiple arguments or input lines as a SQL request up to an empty argument or input line");
            System.err.println("sql:semicolon accepts multiple arguments or input lines as a SQL request up to an argument or input line ending with a semicolon");
            System.err.println("sql:single (the default) accepts a single argument or input line as a SQL request");
            System.err.println("System.getProperties prints the Properties from System.getProperties");
            System.err.println("System.getProperty:name prints the specified System property");
            System.err.println("System.setProperty:name=value sets the System property name to value");
            System.err.println("time prints the current date and time");
            System.err.println("verbose:connection (the default) and verbose:-connection control printing connection status");
            System.err.println("verbose:controlchars and verbose:-controlchars (the default) control printing control characters");
            System.err.println("verbose:csvtypes and verbose:-csvtypes (the default) control printing data types in CSV header");
            System.err.println("verbose:dbmd and verbose:-dbmd (the default) control printing arguments before calling DatabaseMetaData methods");
            System.err.println("verbose:sleep (the default) and verbose:-sleep control printing sleep status");
            System.err.println("verbose:sql and verbose:-sql (the default) control printing the SQL request before executing");
            System.err.println("verbose:stack and verbose:-stack (the default) control printing SQLException stack traces");
            System.err.println("verbose:transaction and verbose:-transaction (the default) control printing transaction commands");
            System.err.println("verbose:updatecounts and verbose:-updatecounts (the default) control printing update counts after executing");
            System.err.println("version prints the Teradata JDBC Driver version");
            System.err.println("Otherwise the SQL request is executed, using parameter values if previously specified");
            return;
        }
        var1_1 = 1;
        var2_2 = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        var3_3 = new Stack<E>();
        try {
            var5_5 = var4_4 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), true);
            try {
                var6_6 = "default";
                var7_7 = new LinkedHashMap<String, Connection>();
                try {
                    var8_8 = null;
                    try {
                        var12_9 = 3;
                        var13_10 = null;
                        var14_11 = null;
                        var15_12 = null;
                        var16_13 = "GET";
                        var17_14 = new StringList();
                        var18_15 = new URLParameters("");
                        var19_16 = null;
                        var20_17 = false;
                        var21_18 = null;
                        var22_19 = new Integer(2);
                        var23_20 = true;
                        var24_21 = false;
                        var25_22 = true;
                        var26_23 = false;
                        var27_24 = false;
                        var28_25 = false;
                        var29_26 = false;
                        var30_27 = false;
                        var31_28 = false;
                        var32_29 = new LinkedHashMap<String, Boolean>();
                        var32_29.put("getParameterClassName", false);
                        var32_29.put("getParameterMode", false);
                        var32_29.put("getParameterType", false);
                        var32_29.put("getParameterTypeName", false);
                        var32_29.put("getPrecision", false);
                        var32_29.put("getScale", false);
                        var32_29.put("isNullable", false);
                        var32_29.put("isSigned", false);
                        var33_30 = new LinkedHashMap<String, Boolean>();
                        var33_30.put("getCatalogName", false);
                        var33_30.put("getColumnClassName", false);
                        var33_30.put("getColumnDisplaySize", false);
                        var33_30.put("getColumnLabel", false);
                        var33_30.put("getColumnName", false);
                        var33_30.put("getColumnType", false);
                        var33_30.put("getColumnTypeName", false);
                        var33_30.put("getPrecision", false);
                        var33_30.put("getScale", false);
                        var33_30.put("getSchemaName", false);
                        var33_30.put("getTableName", false);
                        var33_30.put("isAutoIncrement", false);
                        var33_30.put("isCaseSensitive", false);
                        var33_30.put("isCurrency", false);
                        var33_30.put("isDefinitelyWritable", false);
                        var33_30.put("isNullable", false);
                        var33_30.put("isReadOnly", false);
                        var33_30.put("isSearchable", false);
                        var33_30.put("isSigned", false);
                        var33_30.put("isWritable", false);
                        var34_31 = 0;
                        while (true) lbl-1000:
                        // 115 sources

                        {
                            var35_32 = null;
                            if (TeraDriver.safePeek(var3_3) == var2_2) {
                                if (var13_10 != null && var14_11 != null) {
                                    var4_4.print(var14_11);
                                } else if (var13_10 == null && var15_12 != null) {
                                    var4_4.print(var15_12);
                                }
                                var4_4.flush();
                            }
                            while (var35_32 == null && TeraDriver.safePeek(var3_3) != null) {
                                var35_32 = ((BufferedReader)TeraDriver.safePeek(var3_3)).readLine();
                                if (var35_32 != null) continue;
                                TeraDriver.popClose(var3_3, var2_2);
                            }
                            if (var35_32 == null && var34_31 < var0.length) {
                                var35_32 = var0[var34_31++];
                            }
                            var36_33 = false;
                            if (var13_10 != null) {
                                if (var35_32 == null) {
                                    var35_32 = var13_10;
                                    var13_10 = null;
                                    var36_33 = true;
                                } else if (var12_9 == 1 && var35_32.equals("")) {
                                    var35_32 = var13_10;
                                    var13_10 = null;
                                    var36_33 = true;
                                } else if (var12_9 == 2 && var35_32.endsWith(";")) {
                                    var35_32 = var13_10 + " " + var35_32;
                                    var13_10 = null;
                                    var36_33 = true;
                                } else {
                                    var13_10 = var13_10 + " " + var35_32;
                                    continue;
                                }
                            }
                            if (var35_32 == null) ** break;
                            try {
                                if (var35_32.equals("")) ** GOTO lbl-1000
                                if (var35_32.equals("-i") || var35_32.equals("-im") || var35_32.equals("-is")) {
                                    TeraDriver.pushDiff(var3_3, var2_2);
                                    var15_12 = ">>> ";
                                    var14_11 = "... ";
                                    var20_17 = true;
                                    var21_18 = new int[]{};
                                    if (var35_32.equals("-im")) {
                                        var12_9 = 1;
                                    }
                                    if (!var35_32.equals("-is")) ** GOTO lbl-1000
                                    var12_9 = 2;
                                }
                                if (var35_32.equals("sql:multi")) {
                                    var12_9 = 1;
                                }
                                if (var35_32.equals("sql:semicolon")) {
                                    var12_9 = 2;
                                }
                                if (var35_32.equals("sql:single")) {
                                    var12_9 = 3;
                                }
                                if (var35_32.startsWith("cont:")) {
                                    var14_11 = var35_32.substring("cont:".length());
                                }
                                if (var35_32.startsWith("prompt:")) {
                                    var15_12 = var35_32.substring("prompt:".length());
                                }
                                if (var35_32.equals("exit")) {
                                    if (var3_3.size() <= 0) ** GOTO lbl-1000
                                    TeraDriver.popClose(var3_3, var2_2);
                                }
                                if (var35_32.startsWith("#")) ** GOTO lbl-1000
                                if (var35_32.equals("time")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, new Timestamp(System.currentTimeMillis()).toString());
                                }
                                if (var35_32.equals("verbose:sleep")) {
                                    var25_22 = true;
                                }
                                if (var35_32.equals("verbose:-sleep")) {
                                    var25_22 = false;
                                }
                                if (var35_32.startsWith("sleep:")) {
                                    var37_34 = Long.parseLong(var35_32.substring("sleep:".length()));
                                    if (var25_22) {
                                        var5_5.println("Sleeping for " + var37_34 + " ms");
                                    }
                                    try {
                                        Thread.sleep(var37_34);
                                    }
                                    catch (InterruptedException var39_95) {
                                        // empty catch block
                                    }
                                    if (!var25_22) ** GOTO lbl-1000
                                    var5_5.println("Done sleeping for " + var37_34 + " ms");
                                }
                                if (var35_32.equals("driver")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, "Teradata JDBC Driver " + Const.DRIVER_VERSION);
                                }
                                if (var35_32.equals("version")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, Const.DRIVER_VERSION);
                                }
                                if (var35_32.equals("pid")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, ClientAttributesParcel.getJVMProcessID());
                                }
                                if (var35_32.equals("lsof")) {
                                    var37_35 = new File("/proc/self/fd").listFiles();
                                    if (var37_35 == null) {
                                        throw new IOException("/proc file system is not available");
                                    }
                                    var38_71 = new ArrayList<File>(Arrays.asList(var37_35));
                                    var37_35 = new File("/proc/self/map_files").listFiles();
                                    if (var37_35 != null) {
                                        var38_71.addAll(Arrays.asList(var37_35));
                                    }
                                    var39_96 = new LinkedHashMap<String, String>();
                                    for (String[][] var41_120 : var38_71) {
                                        var42_125 = var41_120.getName();
                                        var43_128 = null;
                                        try {
                                            var43_128 = Files.readSymbolicLink(var41_120.toPath()).toString();
                                        }
                                        catch (Throwable var44_131) {
                                            // empty catch block
                                        }
                                        if (var43_128 == null) continue;
                                        var44_132 = var42_125.indexOf(45);
                                        v0 = var45_134 = var44_132 >= 0;
                                        if (var45_134) {
                                            var42_125 = "mem-" + var42_125.substring(0, var44_132);
                                        }
                                        if (var46_137 = var45_134 != false && var39_96.containsValue(var43_128) != false) continue;
                                        var39_96.put(var42_125, (String)var43_128);
                                    }
                                    var40_111 = var39_96.entrySet().toArray(new Map.Entry[0]);
                                    var41_120 = new String[][]{new String[var40_111.length], new String[var40_111.length]};
                                    for (var42_124 = 0; var42_124 < var40_111.length; ++var42_124) {
                                        var41_120[0][var42_124] = (String)var40_111[var42_124].getKey();
                                        var41_120[1][var42_124] = (String)var40_111[var42_124].getValue();
                                    }
                                    if (var1_1 == 1) {
                                        var5_5.println("(Open files " + var40_111.length + ")");
                                    }
                                    TeraDriver.printArray(var5_5, var1_1, true, var41_120);
                                }
                                if (var35_32.startsWith("echo:")) {
                                    var37_36 = var35_32.substring("echo:".length());
                                    var5_5.println(var37_36);
                                }
                                if (var35_32.equals("pause")) {
                                    var5_5.println("Paused. Press Enter to continue:");
                                    var2_2.readLine();
                                }
                                if (var35_32.startsWith("prop:")) {
                                    var37_37 = Pattern.compile("prop:([^=]+)=(.*)").matcher(var35_32);
                                    if (!var37_37.matches()) {
                                        throw new IllegalArgumentException(var35_32);
                                    }
                                    if (var19_16 == null) {
                                        var19_16 = new Properties();
                                    }
                                    var19_16.setProperty(var37_37.group(1), var37_37.group(2));
                                }
                                if (var35_32.startsWith("props:")) {
                                    var37_38 = var35_32.substring("props:".length());
                                    if (var37_38.equals("null")) {
                                        var19_16 = null;
                                    }
                                    if (var37_38.equals("new")) {
                                        var19_16 = new Properties();
                                    }
                                    if (var37_38.equals("list")) {
                                        TeraDriver.printProps(var5_5, var1_1, var19_16);
                                    }
                                    var19_16 = new Properties();
                                    var38_72 = new FileInputStream(var37_38);
                                    try {
                                        var19_16.load(var38_72);
                                    }
                                    finally {
                                        var38_72.close();
                                    }
                                }
                                if (var35_32.equals("verbose:connection")) {
                                    var23_20 = true;
                                }
                                if (var35_32.equals("verbose:-connection")) {
                                    var23_20 = false;
                                }
                                if (var35_32.startsWith("con:")) {
                                    var6_6 = var35_32.substring("con:".length());
                                }
                                if (var35_32.equals("list")) {
                                    var37_39 = new ArrayList<String[]>();
                                    var37_39.add(new String[]{"Connection", "Current", "Status", "Remote", "Version", "Session"});
                                    for (Map.Entry<K, V> var39_97 : var7_7.entrySet()) {
                                        var40_112 = (String)var39_97.getKey();
                                        var41_121 = (Connection)var39_97.getValue();
                                        var37_39.add(new String[]{var40_112, var6_6.equals(var40_112) != false ? "Y" : "N", var41_121.isClosed() != false ? "Closed" : "Connected", var41_121.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), var41_121.getMetaData().getDatabaseProductVersion(), var41_121.isClosed() != false ? null : var41_121.nativeSQL("{fn teradata_session_number}")});
                                    }
                                    TeraDriver.printArray(var5_5, var1_1, false, (String[][])var37_39.toArray((T[])new String[0][]));
                                }
                                if (var35_32.startsWith("host=")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Ignored", var35_32);
                                }
                                if (var35_32.startsWith("jdbc:")) {
                                    if (var7_7.containsKey(var6_6)) {
                                        ((Connection)var7_7.remove(var6_6)).close();
                                    }
                                    var37_40 = DriverManager.getConnection(var35_32, var19_16);
                                    var7_7.put(var6_6, var37_40);
                                    if (!var23_20) ** GOTO lbl-1000
                                    TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"Status", "Remote", "Version", "Session"}, {var37_40.isClosed() != false ? "Closed" : "Connected", var37_40.nativeSQL("{fn teradata_provide(remote_address)}:{fn teradata_provide(remote_port)}"), var37_40.getMetaData().getDatabaseProductVersion(), var37_40.isClosed() != false ? null : var37_40.nativeSQL("{fn teradata_session_number}")}});
                                }
                                if (var35_32.startsWith("setLoginTimeout:")) {
                                    var37_41 = Integer.parseInt(var35_32.substring("setLoginTimeout:".length()));
                                    DriverManager.setLoginTimeout(var37_41);
                                }
                                if (var35_32.startsWith("input:")) {
                                    var37_42 = var35_32.substring("input:".length());
                                    TeraDriver.pushDiff(var3_3, var37_42.equals("stdin") != false ? var2_2 : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(var37_42), "UTF-8")));
                                }
                                if (var35_32.startsWith("output:")) {
                                    var37_43 = var35_32.substring("output:".length());
                                    if (var5_5 != var4_4) {
                                        var5_5.close();
                                    }
                                    var5_5 = var4_4;
                                    if (var37_43.equals("stdout")) ** GOTO lbl-1000
                                    var5_5 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(var37_43), "UTF-8"), true);
                                }
                                if (var35_32.startsWith("format:")) {
                                    var37_44 = var35_32.substring("format:".length());
                                    if (var37_44.equals("text")) {
                                        var1_1 = 1;
                                    }
                                    if (var37_44.equals("raw")) {
                                        var1_1 = 2;
                                    }
                                    if (var37_44.equals("csv")) {
                                        var1_1 = 3;
                                    }
                                    throw new IllegalArgumentException("Unknown format " + var37_44);
                                }
                                if (var35_32.equals("ignore:nsql:all")) {
                                    var20_17 = true;
                                }
                                if (var35_32.equals("ignore:nsql:none")) {
                                    var20_17 = false;
                                }
                                if (var35_32.equals("ignore:sql:all")) {
                                    var21_18 = new int[]{};
                                }
                                if (var35_32.equals("ignore:sql:none")) {
                                    var21_18 = null;
                                }
                                if (var35_32.startsWith("ignore:sql:")) {
                                    var37_45 = var35_32.substring("ignore:sql:".length());
                                    var38_74 = var37_45.split(",");
                                    if (var38_74.length == 0) {
                                        throw new IllegalArgumentException(var35_32);
                                    }
                                    var21_18 = new int[var38_74.length];
                                    var39_98 = 0;
                                    while (true) {
                                        if (var39_98 >= var38_74.length) ** GOTO lbl-1000
                                        var21_18[var39_98] = Integer.parseInt(var38_74[var39_98]);
                                        ++var39_98;
                                    }
                                }
                                if (var35_32.startsWith("System.setProperty:")) {
                                    var37_46 = Pattern.compile("System\\.setProperty:([^=]+)=(.*)").matcher(var35_32);
                                    if (!var37_46.matches()) {
                                        throw new IllegalArgumentException(var35_32);
                                    }
                                    System.setProperty(var37_46.group(1), var37_46.group(2));
                                }
                                if (var35_32.startsWith("System.getProperty:")) {
                                    var37_47 = var35_32.substring("System.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, var37_47, System.getProperty(var37_47));
                                }
                                if (var35_32.equals("System.getProperties")) {
                                    TeraDriver.printProps(var5_5, var1_1, System.getProperties());
                                }
                                if (var35_32.startsWith("Security.setProperty:")) {
                                    var37_48 = Pattern.compile("Security\\.setProperty:([^=]+)=(.*)").matcher(var35_32);
                                    if (!var37_48.matches()) {
                                        throw new IllegalArgumentException(var35_32);
                                    }
                                    Security.setProperty(var37_48.group(1), var37_48.group(2));
                                }
                                if (var35_32.startsWith("Security.getProperty:")) {
                                    var37_49 = var35_32.substring("Security.getProperty:".length());
                                    TeraDriver.printNameValue(var5_5, var1_1, var37_49, Security.getProperty(var37_49));
                                }
                                if (var35_32.equals("Security.getProviders")) {
                                    var37_50 = Security.getProviders();
                                    var38_75 = new String[][]{new String[var37_50.length], new String[var37_50.length]};
                                    for (var39_99 = 0; var39_99 < var37_50.length; ++var39_99) {
                                        var38_75[0][var39_99] = String.valueOf(var37_50[var39_99]);
                                        var38_75[1][var39_99] = var37_50[var39_99].getInfo();
                                    }
                                    if (var1_1 == 1) {
                                        var5_5.println("(Providers " + var37_50.length + ")");
                                    }
                                    TeraDriver.printArray(var5_5, var1_1, true, var38_75);
                                }
                                if (var35_32.startsWith("random:b64:") || var35_32.startsWith("random:b64u:") || var35_32.startsWith("random:hex:")) {
                                    var37_51 = var35_32.split(":", 3);
                                    var38_76 = Utility.getRandomBytes(Integer.parseInt(var37_51[2]));
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, var37_51[1].equals("hex") != false ? Utility.formatByteArrayAsHexDigits(var38_76) : Utility.base64Encode(var37_51[1].equals("b64u"), var38_76));
                                }
                                if (var35_32.startsWith("http-method:")) {
                                    var16_13 = var35_32.substring("http-method:".length()).trim().toUpperCase();
                                }
                                if (var35_32.startsWith("http-header:")) {
                                    var17_14.add(var35_32.substring("http-header:".length()));
                                }
                                if (var35_32.startsWith("http-params:")) {
                                    var18_15 = new URLParameters(var35_32.substring("http-params:".length()));
                                    TeraDriver.sm_log.setLogLevel(var18_15.getLogLevel());
                                }
                                if (var35_32.startsWith("http:") || var35_32.startsWith("https:")) {
                                    var37_52 = var16_13;
                                    var16_13 = "GET";
                                    var38_77 = var17_14.isEmpty() != false ? null : var17_14.toStringArray();
                                    var17_14.clear();
                                    var39_100 = Utility.doHttpRequest(var18_15, TeraDriver.sm_log, var37_52, var35_32, var38_77, null, false, null);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Code", "" + var39_100.nCode);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Message", var39_100.sMessage);
                                    TeraDriver.printNameValue(var5_5, var1_1, "Body", var39_100.sBody);
                                }
                                if (var35_32.equals("verbose:dbmd")) {
                                    var24_21 = true;
                                }
                                if (var35_32.equals("verbose:-dbmd")) {
                                    var24_21 = false;
                                }
                                if (var35_32.equals("verbose:sql")) {
                                    var26_23 = true;
                                }
                                if (var35_32.equals("verbose:-sql")) {
                                    var26_23 = false;
                                }
                                if (var35_32.equals("pmd:all")) {
                                    var37_53 = var32_29.keySet().iterator();
                                    while (true) {
                                        if (!var37_53.hasNext()) ** GOTO lbl-1000
                                        var38_78 = (String)var37_53.next();
                                        var32_29.put(var38_78, true);
                                    }
                                }
                                if (var35_32.equals("pmd:none")) {
                                    var37_54 = var32_29.keySet().iterator();
                                    while (true) {
                                        if (!var37_54.hasNext()) ** GOTO lbl-1000
                                        var38_79 = (String)var37_54.next();
                                        var32_29.put(var38_79, false);
                                    }
                                }
                                if (var35_32.startsWith("pmd:")) {
                                    var37_55 = var35_32.substring("pmd:".length()).split(",");
                                    if (var37_55.length == 0) {
                                        throw new IllegalArgumentException(var35_32);
                                    }
                                    for (String var39_101 : var32_29.keySet()) {
                                        var32_29.put(var39_101, false);
                                    }
                                    var38_80 = var37_55;
                                    var39_102 = var38_80.length;
                                    var40_113 = 0;
                                    while (true) {
                                        if (var40_113 >= var39_102) ** GOTO lbl-1000
                                        var41_121 = var38_80[var40_113];
                                        if (!var32_29.containsKey(var41_121)) {
                                            throw new IllegalArgumentException((String)var41_121);
                                        }
                                        var32_29.put((String)var41_121, true);
                                        ++var40_113;
                                    }
                                }
                                if (var35_32.equals("rsmd:all")) {
                                    var37_56 = var33_30.keySet().iterator();
                                    while (true) {
                                        if (!var37_56.hasNext()) ** GOTO lbl-1000
                                        var38_81 = (String)var37_56.next();
                                        var33_30.put(var38_81, true);
                                    }
                                }
                                if (var35_32.equals("rsmd:none")) {
                                    var37_57 = var33_30.keySet().iterator();
                                    while (true) {
                                        if (!var37_57.hasNext()) ** GOTO lbl-1000
                                        var38_82 = (String)var37_57.next();
                                        var33_30.put(var38_82, false);
                                    }
                                }
                                if (var35_32.startsWith("rsmd:")) {
                                    var37_58 = var35_32.substring("rsmd:".length()).split(",");
                                    if (var37_58.length == 0) {
                                        throw new IllegalArgumentException(var35_32);
                                    }
                                    for (String var39_103 : var33_30.keySet()) {
                                        var33_30.put(var39_103, false);
                                    }
                                    var38_83 = var37_58;
                                    var39_104 = var38_83.length;
                                    var40_114 = 0;
                                    while (true) {
                                        if (var40_114 >= var39_104) ** GOTO lbl-1000
                                        var41_121 = var38_83[var40_114];
                                        if (!var33_30.containsKey(var41_121)) {
                                            throw new IllegalArgumentException((String)var41_121);
                                        }
                                        var33_30.put((String)var41_121, true);
                                        ++var40_114;
                                    }
                                }
                                if (var35_32.equals("verbose:controlchars")) {
                                    var27_24 = true;
                                }
                                if (var35_32.equals("verbose:-controlchars")) {
                                    var27_24 = false;
                                }
                                if (var35_32.equals("verbose:csvtypes")) {
                                    var28_25 = true;
                                }
                                if (var35_32.equals("verbose:-csvtypes")) {
                                    var28_25 = false;
                                }
                                if (var35_32.equals("verbose:updatecounts")) {
                                    var29_26 = true;
                                }
                                if (var35_32.equals("verbose:-updatecounts")) {
                                    var29_26 = false;
                                }
                                if (var35_32.equals("verbose:stack")) {
                                    var30_27 = true;
                                }
                                if (var35_32.equals("verbose:-stack")) {
                                    var30_27 = false;
                                }
                                if (var35_32.equals("verbose:transaction")) {
                                    var31_28 = true;
                                }
                                if (var35_32.equals("verbose:-transaction")) {
                                    var31_28 = false;
                                }
                                if (var35_32.equals("agkr:none")) {
                                    var22_19 = new Integer(2);
                                }
                                if (var35_32.equals("agkr:generated")) {
                                    var22_19 = new Integer(1);
                                }
                                if (var35_32.startsWith("agkr:")) {
                                    var37_59 = var35_32.substring("agkr:".length());
                                    var38_84 = var37_59.split(",");
                                    if (var38_84.length == 0) {
                                        throw new IllegalArgumentException(var35_32);
                                    }
                                    var39_105 = new int[var38_84.length];
                                    var22_19 = var39_105;
                                    var40_115 = 0;
                                    while (true) {
                                        if (var40_115 >= var38_84.length) ** GOTO lbl-1000
                                        var39_105[var40_115] = Integer.parseInt(var38_84[var40_115]);
                                        ++var40_115;
                                    }
                                }
                                if (var35_32.startsWith("csvline:")) {
                                    var37_60 = var35_32.substring("csvline:".length()) + "\n";
                                    var38_85 = new ByteArrayInputStream(var37_60.getBytes("UTF-8"));
                                    var8_8 = var8_8 == null ? var38_85 : new SequenceInputStream((InputStream)var8_8, var38_85);
                                }
                                if (var35_32.startsWith("readcsv:")) {
                                    var37_61 = var35_32.substring("readcsv:".length());
                                    var38_86 = new FileInputStream(var37_61);
                                    var8_8 = var8_8 == null ? var38_86 : new SequenceInputStream((InputStream)var8_8, var38_86);
                                }
                                if (!var7_7.containsKey(var6_6)) {
                                    throw new IllegalArgumentException("No connection available for " + var35_32);
                                }
                                if (var35_32.equals("autocommit:off")) {
                                    if (var31_28) {
                                        var5_5.println(var35_32);
                                    }
                                    ((Connection)var7_7.get(var6_6)).setAutoCommit(false);
                                }
                                if (var35_32.equals("autocommit:on")) {
                                    if (var31_28) {
                                        var5_5.println(var35_32);
                                    }
                                    ((Connection)var7_7.get(var6_6)).setAutoCommit(true);
                                }
                                if (var35_32.equals("commit")) {
                                    if (var31_28) {
                                        var5_5.println(var35_32);
                                    }
                                    ((Connection)var7_7.get(var6_6)).commit();
                                }
                                if (var35_32.equals("rollback")) {
                                    if (var31_28) {
                                        var5_5.println(var35_32);
                                    }
                                    ((Connection)var7_7.get(var6_6)).rollback();
                                }
                                if (var35_32.equals("getCatalogs")) {
                                    var37_62 = ((Connection)var7_7.get(var6_6)).getMetaData().getCatalogs();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, "getCatalogs", var37_62);
                                    }
                                    finally {
                                        var37_62.close();
                                    }
                                }
                                if (var35_32.equals("getSchemas")) {
                                    var37_63 = ((Connection)var7_7.get(var6_6)).getMetaData().getSchemas();
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, "getSchemas", var37_63);
                                    }
                                    finally {
                                        var37_63.close();
                                    }
                                }
                                if (var35_32.startsWith("getTables:")) {
                                    var37_64 = var35_32.substring("getTables:".length()).split(",", -1);
                                    if (var37_64.length < 3) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var35_32);
                                    }
                                    for (var38_87 = 0; var38_87 < var37_64.length; ++var38_87) {
                                        if (!"null".equals(var37_64[var38_87])) continue;
                                        var37_64[var38_87] = null;
                                    }
                                    v1 = var38_88 = var37_64.length <= 3 ? null : Arrays.copyOfRange(var37_64, 3, var37_64.length);
                                    if (var24_21) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getTables catalog", "getTables schemaPattern", "getTables tableNamePattern", "getTables tableTypes"}, {var37_64[0], var37_64[1], var37_64[2], var38_88 == null ? null : Arrays.toString(var38_88)}});
                                    }
                                    var39_106 = ((Connection)var7_7.get(var6_6)).getMetaData().getTables(var37_64[0], var37_64[1], var37_64[2], (String[])var38_88);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, "getTables", var39_106);
                                    }
                                    finally {
                                        var39_106.close();
                                    }
                                }
                                if (var35_32.startsWith("getColumns:")) {
                                    var37_65 = var35_32.substring("getColumns:".length()).split(",", -1);
                                    if (var37_65.length != 4) {
                                        throw new IllegalArgumentException("Invalid arguments for " + var35_32);
                                    }
                                    for (var38_89 = 0; var38_89 < var37_65.length; ++var38_89) {
                                        if (!"null".equals(var37_65[var38_89])) continue;
                                        var37_65[var38_89] = null;
                                    }
                                    if (var24_21) {
                                        TeraDriver.printArray(var5_5, var1_1, false, new String[][]{{"getColumns catalog", "getColumns schemaPattern", "getColumns tableNamePattern", "getColumns columnNamePattern"}, {var37_65[0], var37_65[1], var37_65[2], var37_65[3]}});
                                    }
                                    var38_90 = ((Connection)var7_7.get(var6_6)).getMetaData().getColumns(var37_65[0], var37_65[1], var37_65[2], var37_65[3]);
                                    try {
                                        TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, "getColumns", var38_90);
                                    }
                                    finally {
                                        var38_90.close();
                                    }
                                }
                                if (var35_32.equals("getDatabaseProductVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, ((Connection)var7_7.get(var6_6)).getMetaData().getDatabaseProductVersion());
                                }
                                if (var35_32.equals("getDriverVersion")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, ((Connection)var7_7.get(var6_6)).getMetaData().getDriverVersion());
                                }
                                if (var35_32.equals("getURL")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, var35_32, ((Connection)var7_7.get(var6_6)).getMetaData().getURL());
                                }
                                if (var35_32.startsWith("nativeSQL:")) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "nativeSQL", ((Connection)var7_7.get(var6_6)).nativeSQL(var35_32.substring("nativeSQL:".length())));
                                }
                                if (var35_32.startsWith("prepare:")) {
                                    if (var26_23) {
                                        var5_5.println(var35_32);
                                    }
                                    var37_66 = var35_32.substring("prepare:".length());
                                    var38_91 = ((Connection)var7_7.get(var6_6)).prepareStatement(var37_66);
                                    try {
                                        TeraDriver.printParameterMetaData(var5_5, var1_1, var32_29, var38_91.getParameterMetaData());
                                        do {
                                            if ((var39_107 = var38_91.getMetaData()) == null) continue;
                                            TeraDriver.printResultSetMetaData(var5_5, var1_1, var33_30, var39_107);
                                        } while (var38_91.getMoreResults());
                                    }
                                    finally {
                                        var38_91.close();
                                    }
                                }
                                if (var12_9 == 1 && !var36_33) {
                                    var13_10 = var35_32;
                                }
                                if (var12_9 == 2 && !var36_33 && !var35_32.endsWith(";")) {
                                    var13_10 = var35_32;
                                }
                                if (var8_8 != null) {
                                    try {
                                        var37_67 = new PeekReader(new InputStreamReader((InputStream)var8_8, "UTF-8"));
                                        try {
                                            var38_92 = TeraDriver.readCsvRow(var37_67);
                                            if (var38_92 == null) {
                                                throw new IllegalArgumentException("CSV header line is missing and no CSV data lines are available");
                                            }
                                            var39_108 = TeraDriver.parseCsvHeaders(var38_92);
                                            if (var26_23) {
                                                var5_5.println(var35_32);
                                            }
                                            var40_116 = var22_19 instanceof int[] != false ? ((Connection)var7_7.get(var6_6)).prepareStatement(var35_32, (int[])var22_19) : ((Connection)var7_7.get(var6_6)).prepareStatement(var35_32, (Integer)var22_19);
                                            try {
                                                TeraDriver.printParameterMetaData(var5_5, var1_1, var32_29, var40_116.getParameterMetaData());
                                                var41_122 = 0;
                                                while (true) {
                                                    if ((var42_126 = TeraDriver.readCsvRow(var37_67)) == null && var41_122 >= 2 || var42_126 != null && var41_122 >= 1) {
                                                        var40_116.addBatch();
                                                    }
                                                    if (var42_126 == null) break;
                                                    if (var42_126.length != var39_108.length) {
                                                        throw new IllegalArgumentException("CSV data line " + var37_67.lineNumber + " contains " + var42_126.length + " values instead of the expected " + var39_108.length + " values");
                                                    }
                                                    for (var43_130 = 0; var43_130 < var42_126.length; ++var43_130) {
                                                        TeraDriver.bindValue(var40_116, var37_67.lineNumber, var43_130 + 1, var39_108[var43_130], var42_126[var43_130]);
                                                    }
                                                    ++var41_122;
                                                }
                                                var42_124 = 0;
                                                var43_128 = null;
                                                if (var41_122 >= 2) {
                                                    var43_128 = var40_116.executeBatch();
                                                } else {
                                                    var42_124 = (int)var40_116.execute();
                                                }
                                                var44_133 = 1;
                                                while (true) {
                                                    if (var29_26) {
                                                        if (var41_122 >= 2) {
                                                            TeraDriver.printUpdateCounts(var5_5, var1_1, (int[])var43_128);
                                                        } else if (var42_124 == 0) {
                                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var40_116.getUpdateCount());
                                                        }
                                                    }
                                                    if (var42_124 != 0) {
                                                        var45_135 = var40_116.getResultSet();
                                                        try {
                                                            TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, "Result " + var44_133, var45_135);
                                                        }
                                                        finally {
                                                            var45_135.close();
                                                        }
                                                    }
                                                    var45_135 = var40_116.getGeneratedKeys();
                                                    try {
                                                        TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, var22_19 instanceof int[] != false ? "Inserted" : "Generated", var45_135);
                                                    }
                                                    finally {
                                                        var45_135.close();
                                                    }
                                                    if (var41_122 >= 2) ** GOTO lbl-1000
                                                    var42_124 = (int)var40_116.getMoreResults();
                                                    v2 = var45_136 = var42_124 != 0 || var40_116.getUpdateCount() != -1;
                                                    if (!var45_136) ** GOTO lbl-1000
                                                    ++var44_133;
                                                }
                                            }
                                            finally {
                                                var40_116.close();
                                            }
                                        }
                                        finally {
                                            var37_67.close();
                                        }
                                    }
                                    finally {
                                        var8_8 = null;
                                    }
                                }
                                var37_68 = ((Connection)var7_7.get(var6_6)).createStatement();
                                try {
                                    if (var26_23) {
                                        var5_5.println(var35_32);
                                    }
                                    var38_93 = var22_19 instanceof int[] != false ? var37_68.execute(var35_32, (int[])var22_19) : var37_68.execute(var35_32, (Integer)var22_19);
                                    var39_109 = 1;
                                    while (true) {
                                        if (!var38_93 && var37_68.getUpdateCount() == -1) ** GOTO lbl-1000
                                        if (var38_93) {
                                            var40_117 = var37_68.getResultSet();
                                            try {
                                                TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, "Result " + var39_109, var40_117);
                                            }
                                            finally {
                                                var40_117.close();
                                            }
                                        }
                                        if (var29_26) {
                                            TeraDriver.printNameValue(var5_5, var1_1, "Update count", "" + var37_68.getUpdateCount());
                                        }
                                        var40_117 = var37_68.getGeneratedKeys();
                                        try {
                                            TeraDriver.printResultSet(var5_5, var1_1, var33_30, var27_24, var28_25, var22_19 instanceof int[] != false ? "Inserted" : "Generated", var40_117);
                                        }
                                        finally {
                                            var40_117.close();
                                        }
                                        var38_93 = var37_68.getMoreResults();
                                        ++var39_109;
                                    }
                                }
                                finally {
                                    var37_68.close();
                                }
                            }
                            catch (SQLException var37_69) {
                                var38_94 = var21_18 != null && var21_18.length == 0;
                                for (var39_110 = 0; !var38_94 && var21_18 != null && var39_110 < var21_18.length; ++var39_110) {
                                    if (var37_69.getErrorCode() != var21_18[var39_110]) continue;
                                    var38_94 = true;
                                }
                                if (var38_94) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var37_69);
                                }
                                var39_110 = 0;
                                for (var40_118 = var37_69; var40_118 != null; var40_118 = var40_118.getNextException()) {
                                    ++var39_110;
                                }
                                var40_119 = 1;
                                for (var41_123 = var37_69; var41_123 != null; var41_123 = var41_123.getNextException()) {
                                    var42_127 = new StringWriter();
                                    var41_123.printStackTrace(new PrintWriter((Writer)var42_127, true));
                                    var5_5.println("SQLException " + var40_119 + " of " + var39_110 + ": " + (var30_27 != false ? "" + var42_127 : "" + var41_123));
                                    ++var40_119;
                                }
                                throw var37_69;
                            }
                            catch (Throwable var37_70) {
                                if (var20_17) {
                                    TeraDriver.printNameValue(var5_5, var1_1, "Exception", "" + var37_70);
                                    continue;
                                }
                                throw var37_70;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                        ** if (var8_8 == null) goto lbl-1000
                    }
                    catch (Throwable var61_152) {
                        if (var8_8 != null) {
                            var8_8.close();
                        }
                        throw var61_152;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var8_8.close();
                    }
lbl-1000:
                    // 1 sources

                    {
                    }
                }
                finally {
                    for (String var9_153 : new ArrayList<K>(var7_7.keySet())) {
                        ((Connection)var7_7.remove(var9_153)).close();
                    }
                }
            }
            finally {
                if (var5_5 != var4_4) {
                    var5_5.close();
                }
            }
        }
        finally {
            while (var3_3.size() > 0) {
                TeraDriver.popClose(var3_3, var2_2);
            }
        }
    }

    static {
        try {
            DriverManager.registerDriver(new TeraDriver());
        }
        catch (SQLException sQLException) {
            sm_log.error("Unable to register the Teradata JDBC Driver with DriverManager", sQLException);
        }
        DUMMY_CALENDAR = Calendar.getInstance();
    }

    private static class StringList
    extends ArrayList {
        public String[] toStringArray() {
            return this.toArray(new String[0]);
        }

        public void append(int n) {
            int n2 = this.size() - 1;
            String string = (String)this.get(n2);
            if (string == null) {
                string = "";
            }
            this.set(n2, string + (char)n);
        }
    }

    private static class PeekReader
    extends PushbackReader {
        public int lineNumber = 0;

        public PeekReader(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n == 10) {
                ++this.lineNumber;
            }
            return n;
        }

        public int peek() throws IOException {
            int n = super.read();
            if (n >= 0) {
                this.unread(n);
            }
            return n;
        }
    }

    private static class CsvHeader {
        public String sHeader;
        public int nType;
        public String sTypeName;
        public boolean bTimeZone;
        public int nScale;

        private CsvHeader() {
        }
    }

    private static class TypeDesc {
        public String sTypeName;
        public int nType;
        public static TypeDesc[] types = new TypeDesc[]{new TypeDesc("BYTEINT", -6), new TypeDesc("SMALLINT", 5), new TypeDesc("INTEGER", 4), new TypeDesc("BIGINT", -5), new TypeDesc("FLOAT", 6), new TypeDesc("DECIMAL", 3), new TypeDesc("NUMBER", 2), new TypeDesc("CLOB", 2005), new TypeDesc("CHAR", 1), new TypeDesc("VARCHAR", 12), new TypeDesc("LONGVARCHAR", -1), new TypeDesc("BLOB", 2004), new TypeDesc("BYTE", -2), new TypeDesc("VARBYTE", -3), new TypeDesc("LONGVARBYTE", -4), new TypeDesc("DATE", 91), new TypeDesc("TIME", 92), new TypeDesc("TIME WITH TIME ZONE", 92), new TypeDesc("TIMESTAMP", 93), new TypeDesc("TIMESTAMP WITH TIME ZONE", 93)};

        private TypeDesc(String string, int n) {
            this.sTypeName = string;
            this.nType = n;
        }
    }
}

