/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc;

import com.teradata.jdbc.TeraSQLXML;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class TeraSQLOutput
implements SQLOutput {
    protected int m_nIndex = 0;
    protected TDPreparedStatement m_pstmt;
    private FullContentMetadataItem[] m_aAttributeMetadata;
    private int m_nBaseAttributeNumber;
    private Class m_clsAppSQLData;

    public TeraSQLOutput(TDPreparedStatement tDPreparedStatement, FullContentMetadataItem[] fullContentMetadataItemArray, int n, Class clazz) {
        this.m_pstmt = tDPreparedStatement;
        this.m_aAttributeMetadata = fullContentMetadataItemArray;
        this.m_nBaseAttributeNumber = n;
        this.m_clsAppSQLData = clazz;
    }

    protected int attributeNumber() {
        return this.m_nBaseAttributeNumber + this.m_nIndex;
    }

    public int getNumberOfAttributesWritten() {
        return this.attributeNumber() - 1;
    }

    protected String[] verifyAttribute(String string, int[] nArray) throws SQLException {
        int n;
        String string2 = this.m_clsAppSQLData.getName() + ".writeSQL";
        string = "SQLOutput." + string;
        if (this.m_nIndex >= this.m_aAttributeMetadata.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ682", string2, String.valueOf(this.m_nIndex + 1), String.valueOf(this.m_aAttributeMetadata.length));
        }
        int n2 = JDBC4Constants.getJavaSQLType(this.m_aAttributeMetadata[this.m_nIndex].getDataType());
        boolean bl = false;
        for (n = 0; !bl && n < nArray.length; ++n) {
            bl = n2 == nArray[n];
        }
        for (n = 0; !bl && this.m_aAttributeMetadata[this.m_nIndex].isDistinct() && n < nArray.length; ++n) {
            bl = nArray[n] == 2001;
        }
        if (!bl) {
            throw ErrorFactory.makeDriverJDBCException("TJ681", string2, string, JDBC4Constants.getJavaSQLTypeName(n2));
        }
        return new String[]{string2, string};
    }

    @Override
    public void writeString(String string) throws SQLException {
        String[] stringArray = this.verifyAttribute("writeString", new int[]{1, 12, 1111});
        this.m_pstmt.internalSetString(this.attributeNumber(), -1, stringArray, string);
        ++this.m_nIndex;
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLOutput.writeBoolean");
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.verifyAttribute("writeByte", new int[]{-6});
        this.m_pstmt.setByte(this.attributeNumber(), by);
        ++this.m_nIndex;
    }

    @Override
    public void writeShort(short s) throws SQLException {
        this.verifyAttribute("writeShort", new int[]{5});
        this.m_pstmt.setShort(this.attributeNumber(), s);
        ++this.m_nIndex;
    }

    @Override
    public void writeInt(int n) throws SQLException {
        this.verifyAttribute("writeInt", new int[]{4});
        this.m_pstmt.setInt(this.attributeNumber(), n);
        ++this.m_nIndex;
    }

    @Override
    public void writeLong(long l) throws SQLException {
        this.verifyAttribute("writeLong", new int[]{-5});
        this.m_pstmt.setLong(this.attributeNumber(), l);
        ++this.m_nIndex;
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLOutput.writeFloat");
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.verifyAttribute("writeDouble", new int[]{8, 6, 7});
        this.m_pstmt.setDouble(this.attributeNumber(), d);
        ++this.m_nIndex;
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.verifyAttribute("writeBigDecimal", new int[]{3, 2});
        this.m_pstmt.setBigDecimal(this.attributeNumber(), bigDecimal);
        ++this.m_nIndex;
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        this.verifyAttribute("writeBytes", new int[]{-2, -3});
        this.m_pstmt.setBytes(this.attributeNumber(), byArray);
        ++this.m_nIndex;
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.verifyAttribute("writeDate", new int[]{91});
        this.m_pstmt.setDate(this.attributeNumber(), date);
        ++this.m_nIndex;
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.verifyAttribute("writeTime", new int[]{92});
        this.m_pstmt.setTime(this.attributeNumber(), time);
        ++this.m_nIndex;
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.verifyAttribute("writeTimestamp", new int[]{93});
        this.m_pstmt.setTimestamp(this.attributeNumber(), timestamp);
        ++this.m_nIndex;
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        String[] stringArray = this.verifyAttribute("writeCharacterStream", new int[]{12, -1});
        this.m_pstmt.internalSetCharacterStream(this.attributeNumber(), -1, stringArray, reader, 64000);
        ++this.m_nIndex;
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        String[] stringArray = this.verifyAttribute("writeAsciiStream", new int[]{12, -1});
        this.m_pstmt.internalSetAsciiStream(this.attributeNumber(), -1, stringArray, inputStream, 64000);
        ++this.m_nIndex;
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        this.verifyAttribute("writeBinaryStream", new int[]{-3, -4});
        this.m_pstmt.setBinaryStream(this.attributeNumber(), inputStream, 64000);
        ++this.m_nIndex;
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        this.verifyAttribute("writeObject", new int[]{2002, 2001});
        if (JDBC4Constants.getJavaSQLType(this.m_aAttributeMetadata[this.m_nIndex].getDataType()) == 2002) {
            this.m_pstmt.setStruct(this.attributeNumber(), sQLData, this.m_nIndex);
        } else {
            this.m_pstmt.setMappedDistinct(this.attributeNumber(), sQLData, this.m_aAttributeMetadata);
        }
        ++this.m_nIndex;
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLOutput.writeRef");
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        this.verifyAttribute("writeBlob", new int[]{2004});
        if (blob == null) {
            this.m_pstmt.internalSetNull(this.attributeNumber(), 2004, 0, this.m_aAttributeMetadata[this.m_nIndex].getDataType(), false);
        } else {
            this.m_pstmt.setBlob(this.attributeNumber(), blob);
        }
        ++this.m_nIndex;
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        this.verifyAttribute("writeClob", new int[]{2005});
        if (clob == null) {
            this.m_pstmt.internalSetNull(this.attributeNumber(), 2005, 0, this.m_aAttributeMetadata[this.m_nIndex].getDataType(), false);
        } else {
            this.m_pstmt.setClob(this.attributeNumber(), clob);
        }
        ++this.m_nIndex;
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        int n = struct == null ? 0 : JDBC4Constants.getJavaSQLTypeForStructCompatibleBuiltInType(struct.getSQLTypeName());
        this.verifyAttribute("writeStruct", new int[]{n != 0 ? n : 2002});
        this.m_pstmt.setStruct(this.attributeNumber(), struct, this.m_nIndex);
        ++this.m_nIndex;
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLOutput.writeArray");
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ549", "SQLOutput.writeURL");
    }

    @Override
    public void writeNString(String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "writeNString");
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "writeNClob");
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ215", "writeRowId");
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        if (!this.m_pstmt.getTDSession().isXMLDataTypeSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ215", "writeSQLXML");
        }
        String[] stringArray = this.verifyAttribute("writeSQLXML", new int[]{2009});
        this.m_pstmt.internalSetSQLXML(this.attributeNumber(), -1, stringArray, (TeraSQLXML)sQLXML);
        ++this.m_nIndex;
    }
}

