/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc.fastexport;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ManagerConnectionBase;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc.fastexport.FastExportManagerPreparedStatement;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.TDPreparedStatement;
import com.teradata.jdbc.jdbc_4.TDResultSet;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class FastExportManagerConnection
extends ManagerConnectionBase
implements ResultSetHelper {
    private List fastexports = Collections.synchronizedList(new ArrayList());

    public FastExportManagerConnection(String string, String string2, String string3, URLParameters uRLParameters) throws SQLException {
        super(string, string2, string3, uRLParameters);
    }

    private boolean isTeradataTypeSupported(TeraResultSetMetaData teraResultSetMetaData) throws SQLException {
        SQLWarning sQLWarning = null;
        block5: for (int i = 1; i <= teraResultSetMetaData.getColumnCount(); ++i) {
            switch (teraResultSetMetaData.getColumnType(i)) {
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 91: 
                case 92: 
                case 93: {
                    continue block5;
                }
                case 1111: {
                    if (teraResultSetMetaData.getColumnTypeName(i).startsWith("INTERVAL")) continue block5;
                }
                case 2002: {
                    if (teraResultSetMetaData.getColumnTypeName(i).startsWith("PERIOD")) continue block5;
                }
                default: {
                    String string = this.isStatementInfoSupported() ? teraResultSetMetaData.getSchemaName(i) + "." + teraResultSetMetaData.getTableName(i) : "";
                    this.getLog().info("Cannot FastExport because a data type of " + teraResultSetMetaData.getColumnTypeName(i) + " in column " + i + " of " + "the selected table " + string + " is not supported!");
                    sQLWarning = ErrorFactory.makeSQLWarning("TJ588", teraResultSetMetaData.getColumnTypeName(i), String.valueOf(i), string);
                    this.addWarning(sQLWarning);
                    return false;
                }
            }
        }
        return true;
    }

    protected synchronized PreparedStatement createManagerPreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        TDPreparedStatement tDPreparedStatement = (TDPreparedStatement)((Object)preparedStatement);
        MetaDataList metaDataList = tDPreparedStatement.getMetaDataList();
        if (metaDataList.size() == 0) {
            this.getLog().info("Cannot FastExport because no metadata is available.");
            SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ629");
            this.addWarning(sQLWarning);
            return preparedStatement;
        }
        if (preparedStatement.getResultSetConcurrency() != 1007) {
            this.getLog().info("Cannot FastExport because result set concurrency " + preparedStatement.getResultSetConcurrency() + " is not supported. JDBC FastExport only supports ResultSet.CONCUR_READ_ONLY.");
            this.addWarning(ErrorFactory.makeSQLWarning("TJ735", preparedStatement.getResultSetConcurrency()));
            return preparedStatement;
        }
        if (preparedStatement.getResultSetHoldability() != 1) {
            this.getLog().info("Cannot FastExport because result set holdability " + preparedStatement.getResultSetHoldability() + " is not supported. JDBC FastExport only supports ResultSet.HOLD_CURSORS_OVER_COMMIT.");
            this.addWarning(ErrorFactory.makeSQLWarning("TJ736", preparedStatement.getResultSetHoldability()));
            return preparedStatement;
        }
        if (preparedStatement.getResultSetType() != 1003) {
            this.getLog().info("Cannot FastExport because result set type " + preparedStatement.getResultSetType() + " is not supported. JDBC FastExport only supports ResultSet.TYPE_FORWARD_ONLY.");
            this.addWarning(ErrorFactory.makeSQLWarning("TJ737", preparedStatement.getResultSetType()));
            return preparedStatement;
        }
        for (int i = 0; i < metaDataList.size(); ++i) {
            TeraResultSetMetaData teraResultSetMetaData = metaDataList.getMetaDataForStatement(i + 1);
            if (!ActivityAnalyzer.isFastExportCompatible(teraResultSetMetaData.getActivityType())) {
                this.getLog().info("Cannot FastExport because statement is not a SELECT!");
                SQLWarning sQLWarning = ErrorFactory.makeSQLWarning("TJ571");
                this.addWarning(sQLWarning);
                return preparedStatement;
            }
            if (this.isTeradataTypeSupported(teraResultSetMetaData)) continue;
            return preparedStatement;
        }
        preparedStatement = this.constructPreparedStatement(this.machineName, this.userName, this.password, preparedStatement);
        this.fastexports.add(preparedStatement);
        return preparedStatement;
    }

    protected synchronized void removeStatement(Object object) {
        this.fastexports.remove(object);
    }

    protected boolean isStatementInfoSupported() {
        return this.m_appSession.isStatementInfoSupported();
    }

    public synchronized String getLogonSequenceNumber() {
        String string = "";
        boolean bl = true;
        for (int i = 0; i < this.fastexports.size(); ++i) {
            FastExportManagerPreparedStatement fastExportManagerPreparedStatement = (FastExportManagerPreparedStatement)this.fastexports.get(i);
            if (!fastExportManagerPreparedStatement.isConnected()) continue;
            if (!bl) {
                string = string + ",";
            } else {
                bl = false;
            }
            string = string + fastExportManagerPreparedStatement.hashCode() + ",";
            string = string + fastExportManagerPreparedStatement.getLogonSequenceNumber();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.connected) {
            SQLException sQLException = null;
            ArrayList arrayList = new ArrayList(this.fastexports);
            try {
                try {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object var8_9;
                        FastExportManagerPreparedStatement fastExportManagerPreparedStatement = (FastExportManagerPreparedStatement)arrayList.get(i);
                        try {
                            try {
                                fastExportManagerPreparedStatement.close();
                            }
                            catch (SQLException sQLException2) {
                                SQLException sQLException3 = ErrorFactory.makeDriverJDBCException("TJ595", i, arrayList.size());
                                sQLException = FastExportManagerConnection.chainSQLExceptions(sQLException, sQLException3);
                                sQLException = FastExportManagerConnection.chainSQLExceptions(sQLException, sQLException2);
                                var8_9 = null;
                                this.removeStatement(fastExportManagerPreparedStatement);
                                continue;
                            }
                            var8_9 = null;
                            this.removeStatement(fastExportManagerPreparedStatement);
                            continue;
                        }
                        catch (Throwable throwable) {
                            var8_9 = null;
                            this.removeStatement(fastExportManagerPreparedStatement);
                            throw throwable;
                        }
                    }
                    this.m_appSession.close();
                }
                catch (SQLException sQLException4) {
                    sQLException = FastExportManagerConnection.chainSQLExceptions(sQLException, sQLException4);
                    Object var10_12 = null;
                    this.connected = false;
                }
                Object var10_11 = null;
                this.connected = false;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.connected = false;
                throw throwable;
            }
            if (sQLException != null) {
                SQLException sQLException5 = ErrorFactory.makeDriverJDBCException("TJ596");
                sQLException5.setNextException(sQLException);
                throw sQLException5;
            }
        }
    }

    public abstract SQLInput constructSQLInput(Object[] var1, int[] var2, int[] var3, String[] var4, Map var5, Class var6);

    public abstract TDResultSet constructResultSet(TeraResultSetMetaData var1, int var2, Statement var3, RowFetchController var4, Log var5) throws SQLException;

    public abstract TeraResultSetMetaData constructResultSetMetaData() throws SQLException;

    protected abstract PreparedStatement constructPreparedStatement(String var1, String var2, String var3, PreparedStatement var4) throws SQLException;
}

