/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.logging.impl;

import com.teradata.tdgss.logging.TdgssLogger;
import com.teradata.tdgss.logging.TdgssLoggingListener;
import com.teradata.tdgss.logging.TdgssLoggingManager;
import com.teradata.tdgss.logging.impl.Delegate;
import com.teradata.tdgss.logging.impl.Level;
import com.teradata.tdgss.logging.impl.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

class Manager
extends TdgssLoggingManager {
    private static final String TDGSS_LOGGING_PROPERTIES = "tdgsslogging.properties";
    private static final String TDGSS_GLOBAL_LEVEL = TdgssLoggingManager.class.getPackage().getName() + ".level";
    private final Map loggerRegistry;
    private final Level globalLevel;
    private final Delegate listeners;
    private final Properties configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Manager() {
        Properties properties;
        block9: {
            this.loggerRegistry = new LinkedHashMap();
            properties = System.getProperties();
            this.listeners = new Delegate();
            ClassLoader classLoader = Manager.class.getClassLoader();
            InputStream inputStream = classLoader == null ? null : classLoader.getResourceAsStream(TDGSS_LOGGING_PROPERTIES);
            this.configuration = new Properties();
            if (inputStream != null) {
                this.configuration.load(inputStream);
                Object var6_4 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                break block9;
                {
                    catch (IOException iOException) {
                        Object var6_5 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        this.configuration.putAll((Map<?, ?>)properties);
        String string = this.configuration.getProperty(TDGSS_GLOBAL_LEVEL);
        this.globalLevel = string == null ? Level.ERROR : Level.getLevel(string, Level.ERROR);
    }

    private Level getLevel(String string) {
        String string2 = string + ".level";
        String string3 = this.configuration.getProperty(string2);
        if (string3 == null) {
            return this.globalLevel;
        }
        return Level.getLevel(string3, this.globalLevel);
    }

    public TdgssLogger getLogger() {
        String string = this.getCaller().getClassName();
        TdgssLogger tdgssLogger = (TdgssLogger)this.loggerRegistry.get(string);
        if (tdgssLogger == null) {
            tdgssLogger = new Logger(this.listeners, this.getLevel(string));
            this.loggerRegistry.put(string, tdgssLogger);
        }
        return tdgssLogger;
    }

    StackTraceElement getCaller() {
        Throwable throwable = new Throwable("");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length <= 2) {
            throw new IllegalStateException();
        }
        String string = stackTraceElementArray[1].getClassName();
        for (int i = 2; i < stackTraceElementArray.length; ++i) {
            if (stackTraceElementArray[i].getClassName().equals(string)) continue;
            return stackTraceElementArray[i];
        }
        throw new IllegalStateException();
    }

    public void addListener(TdgssLoggingListener tdgssLoggingListener) {
        this.listeners.addListener(tdgssLoggingListener);
    }

    public void removeListener(TdgssLoggingListener tdgssLoggingListener) {
        this.listeners.removeListener(tdgssLoggingListener);
    }

    static {
        TdgssLoggingManager.register(new Manager());
    }
}

