/*
 * Decompiled with CFR 0.152.
 */
package uk.co.codezen.maven.redlinerpm.mojo;

import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import uk.co.codezen.maven.redlinerpm.mojo.AbstractRpmMojo;
import uk.co.codezen.maven.redlinerpm.rpm.RpmPackage;
import uk.co.codezen.maven.redlinerpm.rpm.exception.AbstractRpmException;

@Mojo(name="listfiles", defaultPhase=LifecyclePhase.PACKAGE)
public final class ListFilesRpmMojo
extends AbstractRpmMojo {
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Declared packages:");
        this.scanMasterFiles();
        for (RpmPackage rpmPackage : this.packages) {
            Set<String> includedFiles;
            try {
                includedFiles = rpmPackage.listFiles();
            }
            catch (AbstractRpmException ex) {
                this.getLog().error((CharSequence)String.format("Unable to build package %s", rpmPackage.getName()), (Throwable)ex);
                throw new MojoExecutionException(String.format("Unable to build package %s", rpmPackage.getName()), (Exception)ex);
            }
            this.masterFiles.removeAll(includedFiles);
        }
        if (this.masterFiles.size() > 0) {
            this.getLog().info((CharSequence)"Unmatched files:");
            for (String unmatchedFile : this.masterFiles) {
                this.getLog().info((CharSequence)String.format("    - %s", unmatchedFile));
            }
        }
    }
}

