/*
 * Decompiled with CFR 0.152.
 */
package uk.co.codezen.maven.redlinerpm.mojo;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import uk.co.codezen.maven.redlinerpm.mojo.AbstractRpmMojo;
import uk.co.codezen.maven.redlinerpm.rpm.RpmPackage;
import uk.co.codezen.maven.redlinerpm.rpm.exception.AbstractRpmException;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE)
public final class PackageRpmMojo
extends AbstractRpmMojo {
    public void execute() throws MojoExecutionException {
        this.scanMasterFiles();
        long totalFilesPackaged = 0L;
        for (RpmPackage rpmPackage : this.packages) {
            Set<String> includedFiles;
            try {
                includedFiles = rpmPackage.build();
            }
            catch (IOException ex) {
                this.getLog().error((CharSequence)String.format("Unable to build package %s", rpmPackage.getName()), (Throwable)ex);
                throw new MojoExecutionException(String.format("Unable to build package %s", rpmPackage.getName()), (Exception)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                this.getLog().error((CharSequence)String.format("Unable to build package %s", rpmPackage.getName()), (Throwable)ex);
                throw new MojoExecutionException(String.format("Unable to build package %s", rpmPackage.getName()), (Exception)ex);
            }
            catch (AbstractRpmException ex) {
                this.getLog().error((CharSequence)String.format("Unable to build package %s", rpmPackage.getName()), (Throwable)ex);
                throw new MojoExecutionException(String.format("Unable to build package %s", rpmPackage.getName()), (Exception)ex);
            }
            this.masterFiles.removeAll(includedFiles);
            totalFilesPackaged += (long)includedFiles.size();
        }
        if (this.isPerformCheckingForExtraFiles() && this.masterFiles.size() > 0) {
            this.getLog().error((CharSequence)String.format("%d file(s) listed below were found in the build path that have not been included in any package or explicitly excluded. Maybe you need to exclude them?", this.masterFiles.size()));
            for (String missedFile : this.masterFiles) {
                this.getLog().error((CharSequence)String.format(" - %s", missedFile));
            }
            throw new MojoExecutionException(String.format("%d file(s) were found in the build path that have not been included or explicitly excluded. Maybe you need to exclude them? See the error report for more details.", this.masterFiles.size()));
        }
        if (0 < this.packages.size() && 0L == totalFilesPackaged) {
            this.getLog().error((CharSequence)String.format("No files were included when packaging RPM artifacts. Did you specify the correct output path?", new Object[0]));
            throw new MojoExecutionException("No files were included when packaging RPM artifacts. Did you specify the correct output path?");
        }
    }
}

