/*
 * Decompiled with CFR 0.152.
 */
package uk.co.codezen.maven.redlinerpm.rpm;

import java.util.List;
import org.redline_rpm.payload.Directive;
import uk.co.codezen.maven.redlinerpm.rpm.exception.InvalidRpmPackageRuleDirectiveException;

public final class RpmPackageRuleDirective {
    public static Directive newDirective(List<String> directiveList) throws InvalidRpmPackageRuleDirectiveException {
        Directive rpmDirective = new Directive();
        for (String directive : directiveList) {
            if ((directive = directive.toLowerCase()).equals("config")) {
                rpmDirective.set(1);
                continue;
            }
            if (directive.equals("doc")) {
                rpmDirective.set(2);
                continue;
            }
            if (directive.equals("icon")) {
                rpmDirective.set(4);
                continue;
            }
            if (directive.equals("missingok")) {
                rpmDirective.set(8);
                continue;
            }
            if (directive.equals("noreplace")) {
                rpmDirective.set(16);
                continue;
            }
            if (directive.equals("specfile")) {
                rpmDirective.set(32);
                continue;
            }
            if (directive.equals("ghost")) {
                rpmDirective.set(64);
                continue;
            }
            if (directive.equals("license")) {
                rpmDirective.set(128);
                continue;
            }
            if (directive.equals("readme")) {
                rpmDirective.set(256);
                continue;
            }
            if (directive.equals("unpatched")) {
                rpmDirective.set(1024);
                continue;
            }
            if (directive.equals("pubkey")) {
                rpmDirective.set(2048);
                continue;
            }
            if (directive.equals("policy")) {
                rpmDirective.set(4096);
                continue;
            }
            throw new InvalidRpmPackageRuleDirectiveException(directive);
        }
        return rpmDirective;
    }

    private RpmPackageRuleDirective() {
    }
}

