/*
 * Decompiled with CFR 0.152.
 */
package com.terheyden.value;

import com.terheyden.value.CheckedConsumer2;
import com.terheyden.value.Value1;
import com.terheyden.value.ValueStack;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedPredicate;
import io.vavr.CheckedRunnable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Value2<B, C> {
    private static final Value2<?, ?> EMPTY = new Value2(Optional.empty(), Optional.empty());
    private final Optional<B> optValue1;
    private final Optional<C> optValue2;

    public static <X, Y> Value2<X, Y> empty() {
        return EMPTY;
    }

    Value2(@Nullable B value1, @Nullable C value2) {
        this.optValue1 = Optional.ofNullable(value1);
        this.optValue2 = Optional.ofNullable(value2);
    }

    Value2(Optional<? extends B> optValue1, Optional<? extends C> optValue2) {
        this.optValue1 = optValue1;
        this.optValue2 = optValue2;
    }

    private <D> Value2<B, D> copyReplaceLast(Optional<? extends D> newValue2) {
        return new Value2<B, D>(this.optValue1, newValue2);
    }

    private <D> Value2<B, D> copyReplaceLast(@Nullable D newValue2) {
        return new Value2<B, D>(this.optValue1, Optional.ofNullable(newValue2));
    }

    public C get() {
        return this.optValue2.get();
    }

    public boolean isPresent() {
        return this.optValue1.isPresent() && this.optValue2.isPresent();
    }

    public boolean isEmpty() {
        return this.optValue1.isEmpty() || this.optValue2.isEmpty();
    }

    public Value2<B, C> ifPresent(CheckedConsumer<? super C> action) {
        this.optValue2.ifPresent(action.unchecked());
        return this;
    }

    public Value2<B, C> ifPresentOrElse(CheckedConsumer<? super C> action, CheckedRunnable emptyAction) {
        this.optValue2.ifPresentOrElse(action.unchecked(), emptyAction.unchecked());
        return this;
    }

    public Value2<B, C> ifAllPresent(CheckedConsumer2<? super B, ? super C> action) {
        if (this.isPresent()) {
            action.unchecked().accept(this.optValue1.get(), this.optValue2.get());
        }
        return this;
    }

    public Value2<B, C> ifEmpty(CheckedRunnable emptyAction) {
        if (this.isEmpty()) {
            emptyAction.unchecked().run();
        }
        return this;
    }

    public Value2<B, C> filter(CheckedPredicate<? super C> predicate) {
        return this.isEmpty() ? this : this.copyReplaceLast((Object)this.optValue2.filter(predicate.unchecked()));
    }

    public <U> Value2<B, U> map(CheckedFunction1<? super C, ? extends U> mapper) {
        return this.isEmpty() ? Value2.empty() : this.copyReplaceLast((Object)this.optValue2.map(mapper.unchecked()));
    }

    public <D> Value2<B, D> flatMap(CheckedFunction1<? super C, ? extends Optional<? extends D>> mapper) {
        return this.isEmpty() ? Value2.empty() : this.copyReplaceLast((D)this.optValue2.flatMap(mapper.unchecked()));
    }

    public <D> Value1<D> reduceAll(CheckedFunction2<? super B, ? super C, ? extends D> reducer) {
        return this.isEmpty() ? Value1.empty() : ValueStack.ofNullable(reducer.unchecked().apply(this.optValue1.get(), this.optValue2.get()));
    }

    public <D> Value1<D> flatReduceAll(CheckedFunction2<? super B, ? super C, Value1<? extends D>> reducer) {
        return this.isEmpty() ? Value1.empty() : (Value1)reducer.unchecked().apply(this.optValue1.get(), this.optValue2.get());
    }

    public Value2<B, C> or(CheckedFunction0<? extends Optional<? extends C>> supplier) {
        return this.isPresent() ? this : this.copyReplaceLast((Object)((Optional)supplier.unchecked().apply()));
    }

    public Value2<B, C> or(CheckedFunction1<? super B, ? extends C> valueFunction) {
        return this.isPresent() ? this : this.copyReplaceLast(valueFunction.unchecked().apply(this.optValue1.get()));
    }

    public Value2<B, C> or(Optional<? extends C> useIfEmpty) {
        return this.isPresent() ? this : this.copyReplaceLast((Object)useIfEmpty);
    }

    public Value2<B, C> or(Value1<? extends C> useIfEmpty) {
        return this.isPresent() ? this : this.copyReplaceLast((Object)useIfEmpty.toOptional());
    }

    public Value2<B, C> or(C useIfEmpty) {
        return this.isPresent() ? this : this.copyReplaceLast(useIfEmpty);
    }

    public Stream<C> stream() {
        return this.optValue2.stream();
    }

    @Nullable
    public C orElse(@Nullable C other) {
        return this.optValue2.orElse(other);
    }

    @Nullable
    public C orElseGet(Supplier<? extends C> supplier) {
        return this.optValue2.orElseGet(supplier);
    }

    public C orElseThrow() {
        return this.optValue2.orElseThrow();
    }

    public <X extends Throwable> C orElseThrow(CheckedFunction0<? extends X> exceptionSupplier) throws X {
        return this.optValue2.orElseThrow(exceptionSupplier.unchecked());
    }

    public Optional<C> toOptional() {
        return this.optValue2;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Value2)) {
            return false;
        }
        Value2 optObj = (Value2)obj;
        return this.optValue1.equals(optObj.optValue1) && this.optValue2.equals(optObj.optValue2);
    }

    public int hashCode() {
        return Objects.hash(this.optValue1, this.optValue2);
    }

    public String toString() {
        return "Value2[%s,%s]".formatted(this.optValue1.map(String::valueOf).orElse("null"), this.optValue2.map(String::valueOf).orElse("null"));
    }
}

