/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.testerum_api.testerum_steps_api.annotations.steps.When;
import com.testerum_api.testerum_steps_api.services.TesterumServiceLocator;
import com.testerum_api.testerum_steps_api.test_context.logger.TesterumLogger;
import com.testerum_api.testerum_steps_api.test_context.script_executer.ScriptExecuter;
import com.testerum_api.testerum_steps_api.test_context.test_vars.TestVariables;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0007J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lutil/UtilSteps;", "", "()V", "logger", "Lcom/testerum_api/testerum_steps_api/test_context/logger/TesterumLogger;", "scriptExecuter", "Lcom/testerum_api/testerum_steps_api/test_context/script_executer/ScriptExecuter;", "variables", "Lcom/testerum_api/testerum_steps_api/test_context/test_vars/TestVariables;", "executeJsScript", "script", "", "executeJsScriptAndSaveToVar", "", "varName", "executeJsScriptStep", "util-steps"})
public final class UtilSteps {
    private final TesterumLogger logger = TesterumServiceLocator.getTesterumLogger();
    private final TestVariables variables = TesterumServiceLocator.getTestVariables();
    private final ScriptExecuter scriptExecuter = TesterumServiceLocator.getScriptExecuter();

    @When(value="I execute the JS script <<script>>", description="Executes a custom JavaScript script that has access to all the variables in the test scope.\nThis script is not executed in the browser context.\nIn this script context you have access to the following variables:\n- ``testLogger``        - this is a TesterumLogger instance.\n- ``testVariables``     - this is a Map with all the variables defined in this test.\n- ``failTest(message)`` - function that allows to fail the test with the given message (String).\n")
    public final void executeJsScriptStep(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        this.logger.info("executing JS script:\n--------------------\n" + "script : " + script + '\n' + "\n");
        this.executeJsScript(script);
    }

    @When(value="I execute the JS script <<script>> and save the result into the variable <<varName>>", description="Executes a custom JavaScript script that has access to all the variables in the test scope.\nThe result of the script will be saved into the variable with the given name.\nThis script is not executed in the browser context.\nIn this script context you have access to the following variables:\n- ``testLogger``        - this is a TesterumLogger instance.\n- ``testVariables``     - this is a Map with all the variables defined in this test.\n- ``failTest(message)`` - function that allows to fail the test with the given message (String).\n")
    public final void executeJsScriptAndSaveToVar(@NotNull String script, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        this.logger.info("executing JS script and saving result:\n--------------------------------------\n" + "script  : " + script + '\n' + "varName : " + varName + '\n' + "\n");
        this.variables.set(varName, this.executeJsScript(script));
    }

    private final Object executeJsScript(String script) {
        Map context = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"testLogger", (Object)this.logger), TuplesKt.to((Object)"testVariables", (Object)this.variables)});
        return this.scriptExecuter.executeScript(script, context);
    }
}

