/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.testquack.beans.Attribute;
import com.testquack.beans.AttributeValue;
import com.testquack.beans.Filter;
import com.testquack.beans.TestcaseFilter;
import com.testquack.dal.AttributeRepository;
import com.testquack.dal.CommonRepository;
import com.testquack.services.BaseService;
import com.testquack.services.TestCaseService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.greatbit.whoru.auth.Session;

@Service
public class AttributeService
extends BaseService<Attribute> {
    @Autowired
    private TestCaseService testCaseService;
    @Autowired
    private AttributeRepository repository;

    @Override
    protected CommonRepository<Attribute> getRepository() {
        return this.repository;
    }

    @Override
    protected void beforeSave(Session session, String projectId, Attribute entity) {
        super.beforeSave(session, projectId, this.convertStringValuedToObjects(entity));
        HashSet existingValues = new HashSet();
        ArrayList filteredValues = new ArrayList();
        entity.getAttrValues().forEach(valueObject -> {
            if (!existingValues.contains(valueObject.getValue())) {
                existingValues.add(valueObject.getValue());
                filteredValues.add(valueObject);
            }
        });
        entity.setAttrValues(filteredValues);
        entity.getAttrValues().stream().filter(valueObj -> StringUtils.isEmpty((CharSequence)valueObj.getUuid())).forEach(valueObj -> valueObj.setUuid(UUID.randomUUID().toString()));
    }

    @Override
    protected Attribute beforeReturn(Session session, String projectId, Attribute entity) {
        return this.convertStringValuedToObjects(entity);
    }

    @Override
    protected void afterUpdate(Session session, String projectId, Attribute previousEntity, Attribute entity) {
        super.afterUpdate(session, projectId, previousEntity, entity);
        Map newValues = entity.getAttrValues().stream().collect(Collectors.toMap(AttributeValue::getUuid, Function.identity()));
        HashMap changedValues = new HashMap();
        previousEntity.getAttrValues().stream().filter(attributeValue -> newValues.containsKey(attributeValue.getUuid())).filter(attributeValue -> !((AttributeValue)newValues.get(attributeValue.getUuid())).getValue().equals(attributeValue.getValue())).forEach(attributeValue -> changedValues.put(attributeValue.getValue(), ((AttributeValue)newValues.get(attributeValue.getUuid())).getValue()));
        Map removedValues = previousEntity.getAttrValues().stream().filter(oldValues -> !newValues.containsKey(oldValues.getUuid())).collect(Collectors.toMap(AttributeValue::getValue, Function.identity()));
        Set valuesAffectedInTestCases = changedValues.keySet().stream().map(value -> new AttributeValue().withValue(value)).collect(Collectors.toSet());
        valuesAffectedInTestCases.addAll(removedValues.values());
        TestcaseFilter testcaseFilter = new TestcaseFilter().withFilters(Collections.singletonList(new Attribute().withId(entity.getId()).withAttrValues(valuesAffectedInTestCases)));
        List affectedTestcases = this.testCaseService.findFiltered(session, projectId, (Filter)testcaseFilter);
        affectedTestcases.forEach(testCase -> {
            Set newTestcaseAttributeValues = ((Set)testCase.getAttributes().get(entity.getId())).stream().map(value -> changedValues.getOrDefault(value, value)).filter(value -> !removedValues.containsKey(value)).collect(Collectors.toSet());
            testCase.getAttributes().put(entity.getId(), newTestcaseAttributeValues);
        });
        this.testCaseService.save(session, projectId, affectedTestcases);
    }

    @Override
    public void delete(Session session, String projectId, String id) {
        Attribute attributeToDelete = (Attribute)this.findOne(session, projectId, id);
        TestcaseFilter testcaseFilter = new TestcaseFilter().withFilters(Collections.singletonList(new Attribute().withId(id).withAttrValues((Collection)attributeToDelete.getAttrValues())));
        List affectedTestcases = this.testCaseService.findFiltered(session, projectId, (Filter)testcaseFilter);
        affectedTestcases.forEach(testCase -> {
            Set cfr_ignored_0 = (Set)testCase.getAttributes().remove(id);
        });
        this.testCaseService.save(session, projectId, affectedTestcases);
        super.delete(session, projectId, id);
    }

    private Attribute convertStringValuedToObjects(Attribute attribute) {
        Set objectValues = attribute.getAttrValues().stream().map(AttributeValue::getValue).collect(Collectors.toSet());
        attribute.getValues().stream().filter(strValue -> !objectValues.contains(strValue)).map(strValue -> new AttributeValue().withValue(strValue).withUuid(UUID.randomUUID().toString())).forEach(newObjectValue -> attribute.getAttrValues().add(newObjectValue));
        attribute.getValues().clear();
        return attribute;
    }
}

