/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import com.testquack.beans.Entity;
import com.testquack.beans.Filter;
import com.testquack.beans.Organization;
import com.testquack.beans.Project;
import com.testquack.dal.CommonRepository;
import com.testquack.dal.OrganizationRepository;
import com.testquack.dal.ProjectRepository;
import com.testquack.services.UpdatableEntityConvertor;
import com.testquack.services.errors.EntityAccessDeniedException;
import com.testquack.services.errors.EntityNotFoundException;
import com.testquack.services.errors.EntityValidationException;
import com.testquack.services.errors.OrganizationNotSetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import ru.greatbit.whoru.auth.Session;

public abstract class BaseService<E extends Entity> {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String CURRENT_ORGANIZATION_KEY = "currentOrganization";
    public static final String ORGANIZATIONS_KEY = "organizations";
    public static final String ORGANIZATIONS_ENABLED_KEY = "organizationsEnabled";
    @Value(value="${quack.organizations.enabled}")
    protected boolean organizationsEnabled;
    @Value(value="${entity.lock.ttl.min}")
    protected long lockTtl;
    @Autowired
    protected HazelcastInstance hazelcastInstance;
    @Autowired
    protected ProjectRepository projectRepository;
    @Autowired
    protected OrganizationRepository organizationRepository;

    protected abstract CommonRepository<E> getRepository();

    public List<E> findAll(Session session, String projectId) {
        throw new UnsupportedOperationException();
    }

    public List<E> findFiltered(Session session, String projectId, Filter filter) {
        return this.userCanReadProject(session, projectId) ? this.getRepository().find(this.getCurrOrganizationId(session), projectId, filter).stream().map(entity -> this.beforeReturn(session, projectId, entity)).collect(Collectors.toList()) : Collections.emptyList();
    }

    public E findOneUnfiltered(Session session, String projectId, String id) {
        Entity entity = (Entity)this.getRepository().findOne(this.getCurrOrganizationId(session), projectId, id);
        if (entity == null) {
            throw new EntityNotFoundException();
        }
        if (!this.userCanRead(session, projectId, entity)) {
            throw new EntityAccessDeniedException(String.format("User %s can't read entity %s", session.getPerson().getLogin(), id));
        }
        return (E)entity;
    }

    public E findOne(Session session, String projectId, String id) {
        E entity = this.findOneUnfiltered(session, projectId, id);
        return this.beforeReturn(session, projectId, entity);
    }

    public E save(Session user, String projectId, E entity) {
        if (!this.userCanSave(user, projectId, entity)) {
            throw new EntityAccessDeniedException(String.format("User %s can't save entity %s", user.getPerson().getLogin(), entity.getId()));
        }
        return StringUtils.isEmpty((CharSequence)entity.getId()) ? this.create(user, projectId, entity) : this.update(user, projectId, entity, (origEnt, newEnt) -> newEnt);
    }

    public Collection<E> save(Session user, String projectId, Collection<E> entities) {
        if (!this.userCanSave(user, projectId, entities)) {
            throw new EntityAccessDeniedException(String.format("User %s can't save entities %s", user.getPerson().getLogin(), entities.stream().map(obj -> obj == null ? "null" : obj.toString()).collect(Collectors.joining(", "))));
        }
        return this.getRepository().save(this.getCurrOrganizationId(user), projectId, entities);
    }

    public void delete(Session session, String projectId, String id) {
        this.beforeDelete(session, projectId, id);
        if (!this.userCanDelete(session, projectId, id)) {
            throw new EntityAccessDeniedException(String.format("User %s can't delete entity %s", session.getPerson().getLogin(), id));
        }
        E entity = this.findOne(session, projectId, id);
        entity.setDeleted(true);
        this.getRepository().save(this.getCurrOrganizationId(session), projectId, entity);
        this.afterDelete(session, projectId, id);
    }

    public long count(Session session, String projectId, Filter filter) {
        return this.userCanReadProject(session, projectId) ? this.getRepository().count(this.getCurrOrganizationId(session), projectId, filter) : 0L;
    }

    protected boolean userCanRead(Session session, String projectId, E entity) {
        return this.userCanReadProject(session, projectId);
    }

    protected boolean userCanUpdateProject(Session session, String projectId) {
        return this.userCanReadProject(session, projectId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean userCanReadProject(Session session, String projectId) {
        if (session.isIsAdmin()) {
            return true;
        }
        Organization organization = (Organization)this.organizationRepository.findOne(null, null, this.getCurrOrganizationId(session));
        if (!this.isUserInOrganization(session, organization)) {
            return false;
        }
        if (this.isUserOrganizationAdmin(session, organization)) {
            return true;
        }
        Project project = (Project)this.projectRepository.findOne(this.getCurrOrganizationId(session), null, projectId);
        if (project.isDeleted()) {
            throw new EntityNotFoundException(String.format("Project %s does not exist", projectId));
        }
        if (project.getReadWriteGroups().stream().anyMatch(session.getPerson().getGroups()::contains)) return true;
        if (!project.getReadWriteUsers().stream().anyMatch(session.getPerson().getLogin()::equals)) return false;
        return true;
    }

    protected boolean userCanSave(Session session, String projectId, E entity) {
        return session.isIsAdmin() || this.userCanUpdateProject(session, projectId);
    }

    protected boolean userCanSave(Session session, String projectId, Collection<E> entities) {
        return session.isIsAdmin() || this.userCanUpdateProject(session, projectId);
    }

    protected boolean userCanDelete(Session session, String projectId, String id) {
        return session.isIsAdmin() || this.userCanUpdateProject(session, projectId);
    }

    protected boolean userCanCreate(Session session, String projectId, E entity) {
        return session.isIsAdmin() || this.userCanUpdateProject(session, projectId);
    }

    protected boolean userCanUpdate(Session session, String projectId, E entity) {
        return session.isIsAdmin() || this.userCanUpdateProject(session, projectId);
    }

    protected void beforeCreate(Session session, String projectId, E entity) {
        if (!StringUtils.isEmpty((CharSequence)entity.getId()) && this.getRepository().exists(this.getCurrOrganizationId(session), projectId, entity.getId())) {
            throw new EntityValidationException(String.format("Entity with id [%s] already exists", entity.getId()));
        }
        entity.setCreatedTime(System.currentTimeMillis());
        entity.setCreatedBy(session.getPerson().getLogin());
        if (entity.getName() == "") {
            entity.setName(entity.getClass().getSimpleName());
        }
    }

    protected void afterCreate(Session session, String projectId, E entity) {
    }

    protected void beforeUpdate(Session session, String projectId, E existingEntity, E entity) {
    }

    protected void afterUpdate(Session session, String projectId, E previousEntity, E entity) {
    }

    protected void beforeSave(Session session, String projectId, E entity) {
        entity.setLastModifiedTime(System.currentTimeMillis());
        entity.setLastModifiedBy(session.getLogin());
    }

    protected void afterSave(Session session, String projectId, E entity) {
    }

    protected void beforeDelete(Session session, String projectId, String id) {
    }

    protected void afterDelete(Session session, String projectId, String id) {
    }

    protected E beforeReturn(Session session, String projectId, E entity) {
        return entity;
    }

    protected boolean validateEntity(E ent) {
        return true;
    }

    protected E create(Session session, String projectId, E entity) {
        this.beforeCreate(session, projectId, entity);
        if (!this.userCanCreate(session, projectId, entity)) {
            throw new EntityAccessDeniedException(this.getAccessDeniedMessage(session, entity, "CREATE"));
        }
        entity = this.doSave(session, projectId, entity);
        this.afterCreate(session, projectId, entity);
        return entity;
    }

    protected E update(Session session, String projectId, E entity) {
        return this.update(session, projectId, entity, (savedEnt, newEnt) -> newEnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected E update(Session session, String projectId, E entity, UpdatableEntityConvertor converter) {
        if (!this.userCanUpdate(session, projectId, entity)) {
            throw new EntityAccessDeniedException(this.getAccessDeniedMessage(session, entity, "UPDATE"));
        }
        FencedLock lock = this.hazelcastInstance.getCPSubsystem().getLock(entity.getClass() + entity.getId());
        try {
            lock.tryLock(this.lockTtl, TimeUnit.MINUTES);
            E existingEntity = this.findOneUnfiltered(session, projectId, entity.getId());
            this.beforeUpdate(session, projectId, existingEntity, entity);
            if (existingEntity != null) {
                if (existingEntity.getLastModifiedTime() > entity.getLastModifiedTime()) {
                    throw new EntityValidationException("Entity has been changed previously. Changes will cause lost updates.");
                }
                entity = converter.transform(existingEntity, entity);
            }
            entity = this.doSave(session, projectId, entity);
            this.afterUpdate(session, projectId, existingEntity, entity);
            E e = entity;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    private E doSave(Session session, String projectId, E entity) {
        this.beforeSave(session, projectId, entity);
        if (this.validateEntity(entity)) {
            entity = (Entity)this.getRepository().save(this.getCurrOrganizationId(session), projectId, entity);
            this.afterSave(session, projectId, entity);
            return entity;
        }
        throw new EntityValidationException(this.getAccessDeniedMessage(session, entity, "SAVE"));
    }

    protected String getAccessDeniedMessage(Session session, E ent, String action) {
        String login = session != null && session.getPerson() != null ? session.getPerson().getLogin() : "unknown";
        String entId = ent != null && ent.getId() != null ? ent.getId().toString() : "new entity";
        return String.format("User %s doesn't have %s permissions on %s", login, action, entId);
    }

    protected boolean exists(Session session, String projectId, String entityId) {
        return this.getRepository().exists(this.getCurrOrganizationId(session), projectId, entityId);
    }

    public void delete(Session session, String projectId, Filter filter) {
        if (this.userCanUpdateProject(session, projectId)) {
            this.findFiltered(session, projectId, filter).forEach(entity -> {
                entity.setDeleted(true);
                this.getRepository().save(this.getCurrOrganizationId(session), projectId, entity);
            });
        }
    }

    public String getCurrOrganizationId(Session session) {
        return (String)session.getMetainfo().get(CURRENT_ORGANIZATION_KEY);
    }

    protected boolean isUserInOrganization(Session session) {
        return this.isUserInOrganization(session, this.getCurrOrganizationId(session));
    }

    protected boolean isUserInOrganization(Session session, String organizationId) {
        if (this.organizationsEnabled) {
            if (organizationId == null) {
                throw new OrganizationNotSetException("Organization not set for session");
            }
            Organization organization = (Organization)this.organizationRepository.findOne(null, null, organizationId);
            return this.isUserInOrganization(session, organization);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isUserInOrganization(Session session, Organization organization) {
        if (!this.organizationsEnabled) return true;
        if (organization == null || organization.isDeleted()) {
            throw new EntityNotFoundException(String.format("Organization %s does not exist", organization.getId()));
        }
        if (organization.getAllowedGroups().stream().anyMatch(session.getPerson().getGroups()::contains)) return true;
        if (organization.getAllowedUsers().stream().anyMatch(session.getPerson().getLogin()::equals)) return true;
        if (!organization.getAdmins().stream().anyMatch(session.getPerson().getLogin()::equals)) return false;
        return true;
    }

    protected boolean isUserOrganizationAdmin(Session session) {
        if (this.organizationsEnabled) {
            String currOrganizationId = this.getCurrOrganizationId(session);
            if (currOrganizationId == null) {
                throw new OrganizationNotSetException("Organization not set for session");
            }
            Organization organization = (Organization)this.organizationRepository.findOne(null, null, currOrganizationId);
            return this.isUserOrganizationAdmin(session, organization);
        }
        return false;
    }

    protected boolean isUserOrganizationAdmin(Session session, Organization organization) {
        if (this.organizationsEnabled) {
            if (organization.isDeleted()) {
                throw new EntityNotFoundException(String.format("Organization %s does not exist", organization.getId()));
            }
            return organization.getAdmins().stream().anyMatch(session.getPerson().getLogin()::equals);
        }
        return false;
    }
}

