/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.google.common.collect.MinMaxPriorityQueue;
import com.hazelcast.cp.lock.FencedLock;
import com.testquack.beans.Event;
import com.testquack.beans.FailureDetails;
import com.testquack.beans.Filter;
import com.testquack.beans.Issue;
import com.testquack.beans.Launch;
import com.testquack.beans.LaunchStatistics;
import com.testquack.beans.LaunchStats;
import com.testquack.beans.LaunchStatus;
import com.testquack.beans.LaunchTestCase;
import com.testquack.beans.LaunchTestCaseTree;
import com.testquack.beans.LaunchTestcaseStats;
import com.testquack.beans.TestCase;
import com.testquack.beans.TestCaseTree;
import com.testquack.beans.TestSuite;
import com.testquack.beans.TestcaseFilter;
import com.testquack.dal.CommonRepository;
import com.testquack.dal.LaunchRepository;
import com.testquack.dal.impl.CommonRepositoryImpl;
import com.testquack.dal.impl.DBUtils;
import com.testquack.services.BaseService;
import com.testquack.services.CommentService;
import com.testquack.services.EventService;
import com.testquack.services.LaunchTestcaseStatsComparator;
import com.testquack.services.TestCaseService;
import com.testquack.services.TestSuiteService;
import com.testquack.services.errors.EntityNotFoundException;
import com.testquack.tracker.Tracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import ru.greatbit.whoru.auth.Session;

@Service
public class LaunchService
extends BaseService<Launch> {
    @Autowired
    private LaunchRepository repository;
    @Autowired
    private TestCaseService testCaseService;
    @Autowired
    private TestSuiteService testSuiteSerbice;
    @Autowired
    private Tracker tracker;
    @Autowired
    private CommentService commentService;
    @Autowired
    private EventService eventService;
    @Autowired
    DBUtils dbUtils;
    private final String FAILURE_DETAILS_TYPE = "failureDetails";
    private static final Set<LaunchStatus> NON_FAILED_STATUSES = Stream.of(LaunchStatus.RUNNING, LaunchStatus.RUNNABLE, LaunchStatus.SKIPPED, LaunchStatus.PASSED).collect(Collectors.toSet());

    @Override
    protected CommonRepository<Launch> getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LaunchTestCase updateLaunchTestCaseStatus(HttpServletRequest request, Session session, String projectId, String launchId, String testCaseUUID, LaunchStatus status, FailureDetails failureDetails) throws Exception {
        FencedLock lock = this.hazelcastInstance.getCPSubsystem().getLock(Launch.class + launchId + "updateLaunchTestCaseStatus");
        try {
            lock.tryLock(this.lockTtl, TimeUnit.MINUTES);
            Launch launch = (Launch)this.findOne(session, projectId, launchId);
            LaunchTestCase launchTestCase = this.findLaunchTestCaseInTree(launch.getTestCaseTree(), testCaseUUID);
            if (launchTestCase == null) {
                throw new EntityNotFoundException(String.format("Launch Test Case with UUID %s not found in Launch with id %s", testCaseUUID, launchId));
            }
            if (this.isFailedStatus(status) && failureDetails != null && this.isFailureDetailsValid(failureDetails)) {
                launchTestCase.setFailureDetails(failureDetails);
                this.addFailureDetails(request, session, projectId, launchTestCase, failureDetails);
            }
            this.updateStatus(session.getPerson().getLogin(), launchTestCase, status);
            this.update(session, projectId, launch);
            if (this.isTerminalStatus(status)) {
                this.eventService.create(session, projectId, new Event().withEventType(status.toString()).withTime(System.currentTimeMillis()).withUser(session.getLogin()).withEntityId(launchTestCase.getId()).withEntityType(TestCase.class.getSimpleName()));
            }
            LaunchTestCase launchTestCase2 = launchTestCase;
            return launchTestCase2;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean isTerminalStatus(LaunchStatus status) {
        return status != LaunchStatus.RUNNABLE && status != LaunchStatus.RUNNING;
    }

    private boolean isFailureDetailsValid(FailureDetails failureDetails) {
        Issue issue = failureDetails.getLinkedIssue();
        return !StringUtils.isEmpty((Object)failureDetails.getText()) || issue != null && (!StringUtils.isEmpty((Object)issue.getId()) || !StringUtils.isEmpty((Object)issue.getName()));
    }

    private boolean isFailedStatus(LaunchStatus status) {
        return status.equals((Object)LaunchStatus.FAILED) || status.equals((Object)LaunchStatus.BROKEN) || status.equals((Object)LaunchStatus.SKIPPED);
    }

    private void addFailureDetails(HttpServletRequest request, Session session, String projectId, LaunchTestCase launchTestCase, FailureDetails failureDetails) throws Exception {
        if (failureDetails.getLinkedIssue() != null) {
            Issue issue = failureDetails.getLinkedIssue();
            issue = StringUtils.isEmpty((Object)issue.getId()) ? this.tracker.createIssue(request, session, issue) : this.tracker.linkIssue(request, session, issue.getId());
            this.testCaseService.linkIssue(request, session, projectId, launchTestCase.getId(), issue.getId());
        }
    }

    @Override
    protected void beforeCreate(Session session, String projectId, Launch launch) {
        if (this.isLaunchTescasesTreeEmpty(launch)) {
            this.fillLaunchTestCases(session, projectId, launch);
        }
        this.fillById(session, projectId, launch);
        this.fillByAliases(session, projectId, launch);
        launch.setStatus(LaunchStatus.RUNNABLE);
        this.removeTestcasesWithNullId(launch.getTestCaseTree());
        this.prepareLaunchTestCasesForCreate(launch.getTestCaseTree(), launch);
        super.beforeCreate(session, projectId, launch);
    }

    private void prepareLaunchTestCasesForCreate(LaunchTestCaseTree testCaseTree, Launch launch) {
        testCaseTree.getTestCases().forEach(testcase -> this.prepareLaunchTestCaseForCreate((LaunchTestCase)testcase, launch));
        testCaseTree.getChildren().forEach(child -> this.prepareLaunchTestCasesForCreate((LaunchTestCaseTree)child, launch));
    }

    private void prepareLaunchTestCaseForCreate(LaunchTestCase launchTestCase, Launch launch) {
        if (StringUtils.isEmpty((Object)launchTestCase.getUuid())) {
            launchTestCase.setUuid(UUID.randomUUID().toString());
        }
        if (launch.isSkipBroken() && launchTestCase.isBroken()) {
            launchTestCase.setLaunchStatus(LaunchStatus.SKIPPED);
        }
    }

    @Override
    protected void beforeSave(Session session, String projectId, Launch launch) {
        super.beforeSave(session, projectId, launch);
        this.updateLaunchStatus(launch);
    }

    private boolean isLaunchTescasesTreeEmpty(Launch launch) {
        return launch.getTestCaseTree() == null || launch.getTestCaseTree().getChildren().isEmpty() && launch.getTestCaseTree().getTestCases().isEmpty();
    }

    private void fillLaunchTestCases(Session session, String projectId, Launch launch) {
        if (launch.getTestSuite() != null && !StringUtils.isEmpty((Object)launch.getTestSuite().getId())) {
            this.fillLaunchBySuite(session, projectId, launch);
        } else if (launch.getTestSuite() != null && launch.getTestSuite().getFilter() != null) {
            this.fillLaunchByFilter(session, projectId, launch);
        }
    }

    private void updateLaunchStatus(Launch launch) {
        launch.setLaunchStats(new LaunchStats());
        this.updateLaunchStatus(launch.getLaunchStats(), launch.getTestCaseTree());
        if (this.isLaunchFinished(launch) && launch.getFinishTime() == 0L) {
            launch.setFinishTime(System.currentTimeMillis());
        }
        if (!this.isLaunchFinished(launch) && launch.getLaunchStats().getStatusCounters().getOrDefault(LaunchStatus.RUNNABLE, 0).intValue() != launch.getLaunchStats().getTotal() && launch.getStartTime() == 0L) {
            launch.setStartTime(System.currentTimeMillis());
        }
    }

    private boolean isLaunchFinished(Launch launch) {
        Map statusCounters = launch.getLaunchStats().getStatusCounters();
        return launch.getLaunchStats().getTotal() == (Integer)statusCounters.get(LaunchStatus.PASSED) + (Integer)statusCounters.get(LaunchStatus.FAILED) + (Integer)statusCounters.get(LaunchStatus.BROKEN) + (Integer)statusCounters.get(LaunchStatus.SKIPPED);
    }

    private void updateLaunchStatus(LaunchStats launchStats, LaunchTestCaseTree testCaseTree) {
        this.updateLaunchStatus(launchStats, testCaseTree.getTestCases());
        testCaseTree.getChildren().forEach(child -> this.updateLaunchStatus(launchStats, (LaunchTestCaseTree)child));
    }

    private void updateLaunchStatus(LaunchStats launchStats, List<LaunchTestCase> testCases) {
        testCases.forEach(testCase -> {
            launchStats.setTotal(launchStats.getTotal() + 1);
            int counter = (Integer)launchStats.getStatusCounters().get(testCase.getLaunchStatus());
            launchStats.getStatusCounters().put(testCase.getLaunchStatus(), counter + 1);
        });
    }

    private Launch fillLaunchByFilter(Session session, String projectId, Launch launch) {
        TestcaseFilter filter = (TestcaseFilter)launch.getTestSuite().getFilter().withSkip(0).withLimit(0);
        filter.getExcludedFields().clear();
        filter.getIncludedFields().clear();
        filter.withField("deleted", new Object[]{false});
        TestCaseTree tcTree = this.testCaseService.findFilteredTreeFullCase(session, projectId, filter);
        launch.setTestCaseTree(this.convertToLaunchTestCases(tcTree));
        return launch;
    }

    private LaunchTestCaseTree convertToLaunchTestCases(TestCaseTree tcTree) {
        List launchTestCases = tcTree.getTestCases().stream().map(testCase -> {
            LaunchTestCase launchTestCase = new LaunchTestCase();
            testCase.copyTo((Object)launchTestCase);
            launchTestCase.getAttributes().putAll(testCase.getAttributes());
            return launchTestCase.withUuid(UUID.randomUUID().toString()).withLaunchStatus(LaunchStatus.RUNNABLE);
        }).collect(Collectors.toList());
        LaunchTestCaseTree launchTestCaseTree = new LaunchTestCaseTree();
        launchTestCaseTree.getTestCases().addAll(launchTestCases);
        launchTestCaseTree.getChildren().addAll(tcTree.getChildren().stream().map(this::convertToLaunchTestCases).collect(Collectors.toList()));
        launchTestCaseTree.setTitle(tcTree.getTitle());
        launchTestCaseTree.setId(tcTree.getId());
        if (!tcTree.isIsLeaf()) {
            launchTestCaseTree.setUuid(tcTree.getId() + ":" + UUID.randomUUID().toString());
        }
        launchTestCaseTree.setCount(tcTree.getCount());
        launchTestCaseTree.setIsLeaf(tcTree.isIsLeaf());
        return launchTestCaseTree;
    }

    private Launch fillLaunchBySuite(Session session, String projectId, Launch launch) {
        if (launch.getTestSuite() == null || launch.getTestSuite().getId() == null) {
            return launch;
        }
        TestSuite testSuite = (TestSuite)this.testSuiteSerbice.findOne(session, projectId, launch.getTestSuite().getId());
        if (testSuite == null) {
            return launch;
        }
        launch.setTestSuite(testSuite);
        return this.fillLaunchByFilter(session, projectId, launch);
    }

    private LaunchTestCase findLaunchTestCaseInTree(LaunchTestCaseTree tree, String uuid) {
        LaunchTestCase testCase = tree.getTestCases().stream().filter(testcase -> testcase.getUuid().equals(uuid)).findFirst().orElse(null);
        if (testCase == null) {
            for (LaunchTestCaseTree child : tree.getChildren()) {
                testCase = this.findLaunchTestCaseInTree(child, uuid);
                if (testCase == null) continue;
                return testCase;
            }
        }
        return testCase;
    }

    private void updateStatus(String userId, LaunchTestCase launchTestCase, LaunchStatus status) {
        if (status.equals((Object)LaunchStatus.RUNNING)) {
            launchTestCase.setCurrentUser(userId);
        }
        launchTestCase.setLaunchStatus(status);
        if (!launchTestCase.getUsers().contains(userId)) {
            launchTestCase.getUsers().add(userId);
        }
    }

    public Map<String, LaunchStatistics> getLaunchesStatistics(Session session, String projectId, Filter filter) throws Exception {
        if (this.userCanReadProject(session, projectId)) {
            return this.dbUtils.mapReduce(Launch.class, CommonRepositoryImpl.getCollectionName((String)this.getCurrOrganizationId(session), (String)projectId, Launch.class), "launchStatsMap.js", "launchStatsReduce.js", filter, LaunchStatistics.class);
        }
        return Collections.emptyMap();
    }

    public Launch cleanLaunchForRestart(Session session, String projectId, Launch launch, boolean failedOnly) {
        Launch sourceLaunch = (Launch)this.findOne(session, projectId, launch.getId());
        launch.setTestCaseTree(sourceLaunch.getTestCaseTree());
        this.cleanUpLaunchForRestart(launch, failedOnly);
        return launch;
    }

    public Collection<LaunchTestcaseStats> getTestCasesHeatMap(Session session, String projectId, Filter filter, int statsTopLimit) throws Exception {
        int n = statsTopLimit = statsTopLimit == 0 ? 100 : statsTopLimit;
        if (this.userCanReadProject(session, projectId)) {
            Map unsortedMap = this.dbUtils.mapReduce(Launch.class, CommonRepositoryImpl.getCollectionName((String)this.getCurrOrganizationId(session), (String)projectId, Launch.class), "testcaseHeatMap.js", "testcaseHeatReduce.js", filter, LaunchTestcaseStats.class);
            MinMaxPriorityQueue topStats = MinMaxPriorityQueue.orderedBy((Comparator)new LaunchTestcaseStatsComparator()).maximumSize(statsTopLimit).create();
            topStats.addAll(unsortedMap.values());
            Map statsMap = topStats.stream().collect(Collectors.toMap(LaunchTestcaseStats::getId, Function.identity()));
            List actualTestcases = this.testCaseService.findFiltered(session, projectId, new TestcaseFilter().withIncludedField("id").withIncludedField("name").withIncludedField("broken").withIncludedField("importedName").withField("id", statsMap.keySet().toArray()));
            actualTestcases.forEach(actualTestcase -> {
                LaunchTestcaseStats statsToUpdate = (LaunchTestcaseStats)statsMap.get(actualTestcase.getId());
                statsToUpdate.setBroken(actualTestcase.isBroken());
                statsToUpdate.setName(StringUtils.isEmpty((Object)actualTestcase.getName()) ? actualTestcase.getImportedName() : actualTestcase.getName());
            });
            ArrayList<LaunchTestcaseStats> sortedStats = new ArrayList<LaunchTestcaseStats>(topStats.size());
            sortedStats.addAll((Collection<LaunchTestcaseStats>)topStats);
            sortedStats.sort(new LaunchTestcaseStatsComparator());
            return sortedStats;
        }
        return Collections.emptyList();
    }

    private void cleanUpLaunchForRestart(Launch launch, boolean failedOnly) {
        launch.withId(null).withCreatedBy(null).withCreatedTime(0L).withFinishTime(0L).withLastModifiedBy(null).withLastModifiedTime(0L).withStatus(LaunchStatus.RUNNABLE);
        launch.setLaunchStats(null);
        this.cleanUpLaunchesTestCases(launch.getTestCaseTree(), failedOnly);
    }

    private LaunchTestCaseTree cleanUpLaunchesTestCases(LaunchTestCaseTree testCaseTree, boolean failedOnly) {
        List newTopLevelLaunchTestCases = testCaseTree.getTestCases().stream().filter(launchTestCase -> !failedOnly || this.isFailedState(launchTestCase.getLaunchStatus())).map(launchTestCase -> this.cleanUpLauncheTestCase((LaunchTestCase)launchTestCase)).collect(Collectors.toList());
        testCaseTree.setTestCases(newTopLevelLaunchTestCases);
        List newChildren = testCaseTree.getChildren().stream().map(child -> this.cleanUpLaunchesTestCases((LaunchTestCaseTree)child, failedOnly)).filter(child -> !child.getTestCases().isEmpty() || !child.getChildren().isEmpty()).collect(Collectors.toList());
        testCaseTree.setChildren(newChildren);
        return testCaseTree;
    }

    private LaunchTestCase cleanUpLauncheTestCase(LaunchTestCase launchTestCase) {
        launchTestCase.getUsers().clear();
        launchTestCase.withDuration(0L).withCurrentUser(null).withFinishTime(0L).withStartTime(0L).withLaunchStatus(LaunchStatus.RUNNABLE).withUuid(UUID.randomUUID().toString());
        return launchTestCase;
    }

    private boolean isFailedState(LaunchStatus launchStatus) {
        return !NON_FAILED_STATUSES.contains(launchStatus);
    }

    private void fillById(Session session, String projectId, Launch launch) {
        HashMap<String, LaunchTestCase> testcasesToFill = new HashMap<String, LaunchTestCase>();
        this.getTestcasesToFillById(launch.getTestCaseTree(), testcasesToFill);
        this.fillByFeld(session, projectId, "id", testcasesToFill);
    }

    private void fillByAliases(Session session, String projectId, Launch launch) {
        HashMap<String, LaunchTestCase> testcasesToFill = new HashMap<String, LaunchTestCase>();
        this.getTestcasesToFillByAliases(launch.getTestCaseTree(), testcasesToFill);
        this.fillByFeld(session, projectId, "alias", testcasesToFill);
    }

    private void fillByFeld(Session session, String projectId, String fieldName, Map<String, LaunchTestCase> testcasesToFill) {
        TestcaseFilter filter = (TestcaseFilter)new TestcaseFilter().withField(fieldName, testcasesToFill.keySet().toArray());
        List originalTestCases = this.testCaseService.findFiltered(session, projectId, (Filter)filter);
        originalTestCases.forEach(originalTestCase -> this.fillOriginalTestcase((TestCase)originalTestCase, testcasesToFill));
    }

    private void fillOriginalTestcase(TestCase originalTestCase, Map<String, LaunchTestCase> testcasesToFill) {
        LaunchTestCase testcaseToUpdate = testcasesToFill.getOrDefault(originalTestCase.getAlias(), testcasesToFill.get(originalTestCase.getId()));
        if (testcaseToUpdate == null) {
            return;
        }
        originalTestCase.copyTo((Object)testcaseToUpdate);
        testcaseToUpdate.getAttributes().putAll(originalTestCase.getAttributes());
        testcaseToUpdate.getMetaData().putAll(originalTestCase.getMetaData());
    }

    private void getTestcasesToFillByAliases(LaunchTestCaseTree tree, Map<String, LaunchTestCase> casesToUpdate) {
        tree.getTestCases().stream().filter(testcase -> testcase.getId() == null).forEach(testcase -> casesToUpdate.put(testcase.getAlias(), (LaunchTestCase)testcase));
        tree.getChildren().forEach(child -> this.getTestcasesToFillByAliases((LaunchTestCaseTree)child, casesToUpdate));
    }

    private void getTestcasesToFillById(LaunchTestCaseTree tree, Map<String, LaunchTestCase> casesToUpdate) {
        tree.getTestCases().stream().filter(testcase -> testcase.getId() != null).forEach(testcase -> casesToUpdate.put(testcase.getId(), (LaunchTestCase)testcase));
        tree.getChildren().forEach(child -> this.getTestcasesToFillByAliases((LaunchTestCaseTree)child, casesToUpdate));
    }

    private void removeTestcasesWithNullId(LaunchTestCaseTree tree) {
        tree.setTestCases(tree.getTestCases().stream().filter(testCase -> testCase.getId() != null).collect(Collectors.toList()));
        tree.getChildren().forEach(this::removeTestcasesWithNullId);
    }
}

