/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.testquack.beans.Filter;
import com.testquack.beans.Organization;
import com.testquack.dal.CommonRepository;
import com.testquack.dal.OrganizationRepository;
import com.testquack.dal.UserRepository;
import com.testquack.services.BaseService;
import com.testquack.services.SequencerService;
import com.testquack.services.errors.EntityValidationException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import ru.greatbit.whoru.auth.Session;

@Service
public class OrganizationService
extends BaseService<Organization> {
    @Value(value="${quack.organization.default.sessions.capacity}")
    public int defaultSessionCapacity;
    @Autowired
    private OrganizationRepository repository;
    @Autowired
    private SequencerService sequencerService;
    @Autowired
    private UserRepository userRepository;

    @Override
    protected CommonRepository<Organization> getRepository() {
        return this.repository;
    }

    @Override
    protected void beforeCreate(Session session, String projectId, Organization entity) {
        if (StringUtils.isEmpty((CharSequence)entity.getId())) {
            throw new EntityValidationException("Organization ID must not be empty");
        }
        if (entity.getId().length() < 3) {
            throw new EntityValidationException("Organization ID must contain at least 3 characters");
        }
        entity.setLicenseCapacity(this.defaultSessionCapacity);
        super.beforeCreate(session, projectId, entity);
    }

    public Organization createOrganization(Session user, Organization entity) {
        if (entity.getId() != null && this.repository.exists(null, null, entity.getId())) {
            throw new EntityValidationException(String.format("Organization with id %s already exists", entity.getId()));
        }
        entity.getAdmins().add(user.getLogin());
        entity.getAllowedUsers().add(user.getLogin());
        return this.create(user, null, entity);
    }

    @Override
    public List<Organization> findFiltered(Session session, String projectId, Filter filter) {
        return this.getRepository().find(null, projectId, filter).stream().filter(organization -> {
            if (session.isIsAdmin()) return true;
            if (organization.getAllowedGroups().stream().anyMatch(session.getPerson().getGroups()::contains)) return true;
            if (organization.getAllowedUsers().stream().anyMatch(session.getPerson().getLogin()::equals)) return true;
            if (!organization.getAdmins().stream().anyMatch(session.getPerson().getLogin()::equals)) return false;
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    protected boolean userCanCreate(Session session, String projectId, Organization organization) {
        return true;
    }

    @Override
    protected boolean userCanDelete(Session session, String projectId, String id) {
        return session.isIsAdmin() || this.isUserOrganizationAdmin(session);
    }

    @Override
    protected boolean userCanRead(Session session, String projectId, Organization entity) {
        return session.isIsAdmin() || this.isUserInOrganization(session);
    }

    @Override
    protected boolean userCanUpdate(Session session, String projectId, Organization organization) {
        return session.isIsAdmin() || this.isUserOrganizationAdmin(session);
    }

    @Override
    protected void beforeUpdate(Session session, String projectId, Organization existingEntity, Organization entity) {
        if (!session.isIsAdmin()) {
            entity.setLicenseCapacity(existingEntity.getLicenseCapacity());
            entity.setLicenseExpiration(existingEntity.getLicenseExpiration());
        }
        super.beforeUpdate(session, projectId, existingEntity, entity);
    }
}

