/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.testquack.beans.Filter;
import com.testquack.beans.Organization;
import com.testquack.beans.Project;
import com.testquack.dal.CommonRepository;
import com.testquack.dal.ProjectRepository;
import com.testquack.services.BaseService;
import com.testquack.services.SequencerService;
import com.testquack.services.errors.EntityValidationException;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.greatbit.whoru.auth.Session;

@Service
public class ProjectService
extends BaseService<Project> {
    @Autowired
    private ProjectRepository repository;
    @Autowired
    private SequencerService sequencerService;

    @Override
    protected CommonRepository<Project> getRepository() {
        return this.repository;
    }

    @Override
    protected void beforeCreate(Session session, String projectId, Project entity) {
        if (StringUtils.isEmpty((CharSequence)entity.getId())) {
            throw new EntityValidationException("Project ID must not be empty");
        }
        if (entity.getId().length() < 3) {
            throw new EntityValidationException("Project ID must contain at least 3 characters");
        }
        super.beforeCreate(session, projectId, entity);
        this.sequencerService.create(this.getCurrOrganizationId(session), projectId);
    }

    public Project createProject(Session user, Project entity) {
        if (entity.getId() != null && this.repository.exists(this.getCurrOrganizationId(user), null, entity.getId())) {
            throw new EntityValidationException(String.format("Project with id %s already exists", entity.getId()));
        }
        return this.create(user, null, entity);
    }

    @Override
    public List<Project> findFiltered(Session session, String projectId, Filter filter) {
        return this.getRepository().find(this.getCurrOrganizationId(session), projectId, filter).stream().filter(project -> {
            if (session.isIsAdmin()) return true;
            if (this.isUserOrganizationAdmin(session)) return true;
            if (project.getReadWriteGroups().stream().anyMatch(session.getPerson().getGroups()::contains)) return true;
            if (!project.getReadWriteUsers().stream().anyMatch(session.getPerson().getLogin()::equals)) return false;
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    protected void beforeSave(Session session, String projectId, Project project) {
        super.beforeSave(session, projectId, project);
        project.getLauncherConfigs().forEach(launcherConfig -> {
            if (StringUtils.isEmpty((CharSequence)launcherConfig.getUuid())) {
                launcherConfig.setUuid(UUID.randomUUID().toString());
            }
            if (StringUtils.isEmpty((CharSequence)launcherConfig.getName())) {
                launcherConfig.setName(launcherConfig.getLauncherId());
            }
        });
    }

    @Override
    protected boolean userCanCreate(Session session, String projectId, Project project) {
        if (!this.organizationsEnabled) {
            return super.userCanCreate(session, projectId, project);
        }
        Organization organization = (Organization)this.organizationRepository.findOne(null, null, this.getCurrOrganizationId(session));
        return session.isIsAdmin() || organization != null && organization.getAdmins().contains(session.getPerson().getLogin());
    }
}

