/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.cp.lock.FencedLock;
import com.testquack.beans.Sequencer;
import com.testquack.dal.SequencerRepository;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SequencerService {
    @Autowired
    private HazelcastInstance hazelcastInstance;
    @Autowired
    private SequencerRepository repository;
    private final long LOCK_TTL = 5L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequencer create(String organizationId, String projectId) {
        String sequencerId = this.getSquencerId(organizationId, projectId);
        FencedLock lock = this.hazelcastInstance.getCPSubsystem().getLock(this.getLockId(sequencerId));
        lock.tryLock(5L, TimeUnit.MINUTES);
        try {
            Sequencer sequencer = (Sequencer)this.repository.save((Object)new Sequencer().withId(sequencerId));
            return sequencer;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequencer increment(String organizationId, String projectId) {
        String sequencerId = this.getSquencerId(organizationId, projectId);
        FencedLock lock = this.hazelcastInstance.getCPSubsystem().getLock(this.getLockId(sequencerId));
        lock.tryLock(5L, TimeUnit.MINUTES);
        try {
            Sequencer sequencer = this.repository.findById((Object)sequencerId).orElse(new Sequencer().withId(sequencerId));
            sequencer.setIndex(sequencer.getIndex() + 1L);
            Sequencer sequencer2 = (Sequencer)this.repository.save((Object)sequencer);
            return sequencer2;
        }
        finally {
            lock.unlock();
        }
    }

    private String getLockId(String projectId) {
        return String.format("sequencer-%s", projectId);
    }

    private String getSquencerId(String organizationId, String projectId) {
        return StringUtils.isEmpty((CharSequence)organizationId) ? projectId : organizationId + "_" + projectId;
    }
}

